#ifndef __ARM7TDMI__
#define __ARM7TDMI__
/*********************************************************************************************/
#include "types.h"
/*********************************************************************************************/
#define E_BADCOND		0x80000000
#define E_BADOP		0x40000000
#define E_COP			0x20000000
#define NEGATIVE		0x80000000
#define ZERO			0x40000000
#define CARRY			0x20000000
#define OVERFLOW		0x10000000
#define IRQ_DISABLE	0x00000080
#define FIQ_DISABLE	0x00000040
#define STATE_BIT		0x00000020
#define MODE_BITS		0x0000001f
#define ARM_MODE		0
#define THUMB_MODE	1
#define USER			0x10
#define FIQ				0x11
#define IRQ				0x12
#define SUPERVISOR	0x13
#define ABORT			0x17
#define UNDEFINED		0x1b
#define SYSTEM			0x1f
/*********************************************************************************************/
typedef void (*execfunc)();
typedef u8 (*read8func)(u32);
typedef u16 (*read16func)(u32);
typedef u32 (*read32func)(u32);
typedef void (*write8func)(u32,u8);
typedef void (*write16func)(u32,u16);
typedef void (*write32func)(u32,u32);
typedef struct
	{
	u32 regs[18]; //r0 - r15 + cpsr + spsr
	u32 regsaves[6][18]; //for different modes
	u32 pipe[3]; //instruction pipeline
	u8 state; //arm or thumb
	read8func read8funcs[256];
	read16func read16funcs[256];
	read32func read32funcs[256];
	write8func write8funcs[256];
	write16func write16funcs[256];
	write32func write32funcs[256];
	} arm7tdmi;
/*********************************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
extern u32 cyclesexec;
/*********************************************************************************************/
#define ADDCYCLES(n)	cyclesexec += n;
void arm7tdmi_init();
void arm7tdmi_modechange(u8 newmode);
u8 arm7tdmi_getmode();
void arm7tdmi_getcontext(arm7tdmi *newcontext);
void arm7tdmi_setcontext(arm7tdmi *newcontext);
void arm7tdmi_softreset();
void arm7tdmi_hardreset();
void arm7tdmi_fillpipe();
u32 arm7tdmi_getcycles();
void arm7tdmi_irq();
u32 arm7tdmi_execute(u32 cycles);
u32 arm7tdmi_executeop();
void arm7tdmi_addcycles(u32 cycles);
#ifdef __cplusplus
}
#endif
/*********************************************************************************************/
#endif