static void op_strh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write16[addr >> 24](addr,(u16)REGS(rd));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24](addr);
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24](addr);
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24](addr);
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write16[addr >> 24](addr,(u16)REGS(rd));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24](addr);
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24](addr);
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24](addr);
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write16[addr >> 24](addr,(u16)REGS(rd));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24](addr);
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24](addr);
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24](addr);
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write16[addr >> 24](addr,(u16)REGS(rd));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24](addr);
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24](addr);
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24](addr);
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_swp_word()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = read32[addr >> 24](addr);
write32[addr >> 24](addr,REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) - REGS(OPCODE & 0xf));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) -= REGS(OPCODE & 0xf));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_swp_byte()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = (u32)read8[addr >> 24](addr);
write8[addr >> 24](addr,(u8)REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf)));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf)));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) + REGS(OPCODE & 0xf));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) += REGS(OPCODE & 0xf));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf)));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = (REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf)));
write16[addr >> 24](addr,(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read16[addr >> 24]((addr += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsb_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s8)read8[addr >> 24]((addr += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_ldrsh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (s32)(s16)read16[addr >> 24]((addr += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8[addr >> 24](addr);
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8[addr >> 24](addr);
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_pre_down_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_pre_down_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_pre_down_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_pre_down_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_pre_up_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_imm_pre_up_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_pre_up_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_imm_pre_up_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8[addr >> 24](addr);
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8[addr >> 24](addr);
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_pre_down_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_pre_down_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_pre_down_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_pre_down_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_pre_up_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_str_reg_pre_up_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff));
write32[addr >> 24](addr,REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldr_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = read32[addr >> 24](addr & ~3);
if(addr & ldrmask)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_pre_up_nowb()
{
addr = (REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_strb_reg_pre_up_wb()
{
addr = (REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff));
write8[addr >> 24](addr,(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_ldrb_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8[addr >> 24](addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
static void op_stm_post_down_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr -= 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_down_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr -= 4;
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr -= 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr -= 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_down_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr -= 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_down_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr -= 4;
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_down_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr -= 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_down_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr -= 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr += 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr += 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_up_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_up_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr += 4;
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_post_up_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		write32[addr >> 24](addr,REGS(i));
		addr += 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_post_up_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		REGS(i) = read32[addr >> 24](addr);
		addr += 4;
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_down_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_down_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_down_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_down_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_down_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_down_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_down_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=15;i>=0;i--)
	{
	if(o & (1 << i))
		{
		addr -= 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_up_noload_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_up_noload_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_up_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_up_load_nowb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
static void op_stm_pre_up_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		write32[addr >> 24](addr,REGS(i));
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 1;
incpipe();
}
/*********************************************************************************************/
static void op_ldm_pre_up_load_wb()
{
int i;
u32 o = OPCODE & 0xffff;

addr = REGS((OPCODE >> 16) & 0xf);
for(i=0;i<16;i++)
	{
	if(o & (1 << i))
		{
		addr += 4;
		REGS(i) = read32[addr >> 24](addr);
		cyclesexec++;
		}
	}
REGS(rn) = addr;
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
