void op_strh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_down_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) -= REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_down_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_up_reg()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) += REGS(OPCODE & 0xf);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16(REGS(rn),(u16)REGS(rd));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_post_up_imm()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16(REGS(rn));
REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_swp_word()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = read32(addr);
write32(addr,REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) - REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) - REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) -= REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) -= REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_swp_byte()
{
u32 addr = REGS((OPCODE >> 16) & 0xf);

REGS((OPCODE >> 12) & 0xf) = (u32)read8(addr);
write8(addr,(u8)REGS(OPCODE & 0xf));
cyclesexec += 4;
incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) - (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_down_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) -= (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) + REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_reg_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) + REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) += REGS(OPCODE & 0xf)),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_reg_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) += REGS(OPCODE & 0xf)));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_imm_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) + (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
write16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))),(u16)REGS(rd));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (u32)read16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsb_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s8)read8((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_ldrsh_pre_up_imm_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
REGS(rd) = (s32)(s16)read16((REGS(rn) += (((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) -= ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += (OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) += ((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_down_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_down_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_down_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_down_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_up_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_imm_pre_up_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_up_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_imm_pre_up_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_imm_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += (OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_post_down()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) -= regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_post_down()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) -= regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write32(REGS(rn),REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_post_up()
{
rn = (u8)((OPCODE >> 16) & 0xf);
write8(REGS(rn),(u8)REGS((OPCODE >> 12) & 0xf));
REGS(rn) += regshift(OPCODE & 0xfff);
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_post_up()
{
rd = (u8)((OPCODE >> 12) & 0xf);
rn = (u8)((OPCODE >> 16) & 0xf);
addr = REGS(rn);
REGS(rd) = (u32)read8(addr);
REGS(rn) += regshift((OPCODE & 0xfff));
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_down_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_down_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_down_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_down_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) - regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_down_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_down_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) -= regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_up_nowb()
{
write32((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_str_reg_pre_up_wb()
{
write32((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)),REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldr_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = read32(addr & ~3);
if(addr & 3)
	{
	addr = (addr & 3) * 8;
	REGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));
	}
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_up_nowb()
{
write8((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_up_nowb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) + regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void op_strb_reg_pre_up_wb()
{
write8((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)),(u8)REGS((OPCODE >> 12) & 0xf));
cyclesexec += 2;
incpipe();
}
/*********************************************************************************************/
void op_ldrb_reg_pre_up_wb()
{
rd = (u8)((OPCODE >> 12) & 0xf);
addr = ((REGS((OPCODE >> 16) & 0xf) += regshift(OPCODE & 0xfff)));
REGS(rd) = (u32)read8(addr);
cyclesexec += 3;
if(rd == 15)
	{
	PC &= ~1;
	cyclesexec += 2;
	fillpipe();
	}
else
	incpipe();
}
/*********************************************************************************************/
void fill_arm_func_table_entry(u16 poo)
{
ops[poo] = op_error;
switch((poo >> 4) & 0xff)
	{
	case 0x00:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_reg;break;
			case 0xd:ops[poo] = op_strh_post_down_reg;break;
			case 0xf:ops[poo] = op_strh_post_down_reg;break;
			}
	case 0x01:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_reg;break;
			}
	case 0x02:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_reg;break;
			case 0xd:ops[poo] = op_strh_post_down_reg;break;
			case 0xf:ops[poo] = op_strh_post_down_reg;break;
			}
	case 0x03:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_reg;break;
			}
	case 0x04:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_imm;break;
			case 0xd:ops[poo] = op_strh_post_down_imm;break;
			case 0xf:ops[poo] = op_strh_post_down_imm;break;
			}
	case 0x05:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_imm;break;
			}
	case 0x06:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_down_imm;break;
			case 0xd:ops[poo] = op_strh_post_down_imm;break;
			case 0xf:ops[poo] = op_strh_post_down_imm;break;
			}
	case 0x07:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_down_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_down_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_down_imm;break;
			}
	case 0x08:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_reg;break;
			case 0xd:ops[poo] = op_strh_post_up_reg;break;
			case 0xf:ops[poo] = op_strh_post_up_reg;break;
			}
	case 0x09:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_reg;break;
			}
	case 0x0a:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_reg;break;
			case 0xd:ops[poo] = op_strh_post_up_reg;break;
			case 0xf:ops[poo] = op_strh_post_up_reg;break;
			}
	case 0x0b:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_reg;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_reg;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_reg;break;
			}
	case 0x0c:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_imm;break;
			case 0xd:ops[poo] = op_strh_post_up_imm;break;
			case 0xf:ops[poo] = op_strh_post_up_imm;break;
			}
	case 0x0d:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_imm;break;
			}
	case 0x0e:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_post_up_imm;break;
			case 0xd:ops[poo] = op_strh_post_up_imm;break;
			case 0xf:ops[poo] = op_strh_post_up_imm;break;
			}
	case 0x0f:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_post_up_imm;break;
			case 0xd:ops[poo] = op_ldrsb_post_up_imm;break;
			case 0xf:ops[poo] = op_ldrsh_post_up_imm;break;
			}
	case 0x10:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_swp_word;break;
			case 0xb:ops[poo] = op_strh_pre_down_reg_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_down_reg_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_down_reg_nowb;break;
			}
	case 0x11:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_reg_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_reg_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_reg_nowb;break;
			}
	case 0x12:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_down_reg_wb;break;
			case 0xd:ops[poo] = op_strh_pre_down_reg_wb;break;
			case 0xf:ops[poo] = op_strh_pre_down_reg_wb;break;
			}
	case 0x13:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_reg_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_reg_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_reg_wb;break;
			}
	case 0x14:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_swp_byte;break;
			case 0xb:ops[poo] = op_strh_pre_down_imm_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_down_imm_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_down_imm_nowb;break;
			}
	case 0x15:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_imm_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_imm_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_imm_nowb;break;
			}
	case 0x16:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_down_imm_wb;break;
			case 0xd:ops[poo] = op_strh_pre_down_imm_wb;break;
			case 0xf:ops[poo] = op_strh_pre_down_imm_wb;break;
			}
	case 0x17:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_down_imm_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_down_imm_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_down_imm_wb;break;
			}
	case 0x18:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_reg_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_up_reg_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_up_reg_nowb;break;
			}
	case 0x19:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_reg_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_reg_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_reg_nowb;break;
			}
	case 0x1a:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_reg_wb;break;
			case 0xd:ops[poo] = op_strh_pre_up_reg_wb;break;
			case 0xf:ops[poo] = op_strh_pre_up_reg_wb;break;
			}
	case 0x1b:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_reg_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_reg_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_reg_wb;break;
			}
	case 0x1c:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_imm_nowb;break;
			case 0xd:ops[poo] = op_strh_pre_up_imm_nowb;break;
			case 0xf:ops[poo] = op_strh_pre_up_imm_nowb;break;
			}
	case 0x1d:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_imm_nowb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_imm_nowb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_imm_nowb;break;
			}
	case 0x1e:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_strh_pre_up_imm_wb;break;
			case 0xd:ops[poo] = op_strh_pre_up_imm_wb;break;
			case 0xf:ops[poo] = op_strh_pre_up_imm_wb;break;
			}
	case 0x1f:
		switch(poo & 0xf)
			{
			default:ops[poo] = op_error;break;
			case 0x9:ops[poo] = op_error;break;
			case 0xb:ops[poo] = op_ldrh_pre_up_imm_wb;break;
			case 0xd:ops[poo] = op_ldrsb_pre_up_imm_wb;break;
			case 0xf:ops[poo] = op_ldrsh_pre_up_imm_wb;break;
			}
	case 0x20:ops[poo] = op_error;break;
	case 0x21:ops[poo] = op_error;break;
	case 0x22:ops[poo] = op_error;break;
	case 0x23:ops[poo] = op_error;break;
	case 0x24:ops[poo] = op_error;break;
	case 0x25:ops[poo] = op_error;break;
	case 0x26:ops[poo] = op_error;break;
	case 0x27:ops[poo] = op_error;break;
	case 0x28:ops[poo] = op_error;break;
	case 0x29:ops[poo] = op_error;break;
	case 0x2a:ops[poo] = op_error;break;
	case 0x2b:ops[poo] = op_error;break;
	case 0x2c:ops[poo] = op_error;break;
	case 0x2d:ops[poo] = op_error;break;
	case 0x2e:ops[poo] = op_error;break;
	case 0x2f:ops[poo] = op_error;break;
	case 0x30:ops[poo] = op_error;break;
	case 0x31:ops[poo] = op_error;break;
	case 0x32:ops[poo] = op_error;break;
	case 0x33:ops[poo] = op_error;break;
	case 0x34:ops[poo] = op_error;break;
	case 0x35:ops[poo] = op_error;break;
	case 0x36:ops[poo] = op_error;break;
	case 0x37:ops[poo] = op_error;break;
	case 0x38:ops[poo] = op_error;break;
	case 0x39:ops[poo] = op_error;break;
	case 0x3a:ops[poo] = op_error;break;
	case 0x3b:ops[poo] = op_error;break;
	case 0x3c:ops[poo] = op_error;break;
	case 0x3d:ops[poo] = op_error;break;
	case 0x3e:ops[poo] = op_error;break;
	case 0x3f:ops[poo] = op_error;break;
	case 0x40:ops[poo] = op_str_imm_post_down;break;
	case 0x41:ops[poo] = op_ldr_imm_post_down;break;
	case 0x42:ops[poo] = op_str_imm_post_down;break;
	case 0x43:ops[poo] = op_ldr_imm_post_down;break;
	case 0x44:ops[poo] = op_strb_imm_post_down;break;
	case 0x45:ops[poo] = op_ldrb_imm_post_down;break;
	case 0x46:ops[poo] = op_strb_imm_post_down;break;
	case 0x47:ops[poo] = op_ldrb_imm_post_down;break;
	case 0x48:ops[poo] = op_str_imm_post_up;break;
	case 0x49:ops[poo] = op_ldr_imm_post_up;break;
	case 0x4a:ops[poo] = op_str_imm_post_up;break;
	case 0x4b:ops[poo] = op_ldr_imm_post_up;break;
	case 0x4c:ops[poo] = op_strb_imm_post_up;break;
	case 0x4d:ops[poo] = op_ldrb_imm_post_up;break;
	case 0x4e:ops[poo] = op_strb_imm_post_up;break;
	case 0x4f:ops[poo] = op_ldrb_imm_post_up;break;
	case 0x50:ops[poo] = op_str_imm_pre_down_nowb;break;
	case 0x51:ops[poo] = op_ldr_imm_pre_down_nowb;break;
	case 0x52:ops[poo] = op_str_imm_pre_down_wb;break;
	case 0x53:ops[poo] = op_ldr_imm_pre_down_wb;break;
	case 0x54:ops[poo] = op_strb_imm_pre_down_nowb;break;
	case 0x55:ops[poo] = op_ldrb_imm_pre_down_nowb;break;
	case 0x56:ops[poo] = op_strb_imm_pre_down_wb;break;
	case 0x57:ops[poo] = op_ldrb_imm_pre_down_wb;break;
	case 0x58:ops[poo] = op_str_imm_pre_up_nowb;break;
	case 0x59:ops[poo] = op_ldr_imm_pre_up_nowb;break;
	case 0x5a:ops[poo] = op_str_imm_pre_up_wb;break;
	case 0x5b:ops[poo] = op_ldr_imm_pre_up_wb;break;
	case 0x5c:ops[poo] = op_strb_imm_pre_up_nowb;break;
	case 0x5d:ops[poo] = op_ldrb_imm_pre_up_nowb;break;
	case 0x5e:ops[poo] = op_strb_imm_pre_up_wb;break;
	case 0x5f:ops[poo] = op_ldrb_imm_pre_up_wb;break;
	case 0x60:ops[poo] = op_str_reg_post_down;break;
	case 0x61:ops[poo] = op_ldr_reg_post_down;break;
	case 0x62:ops[poo] = op_str_reg_post_down;break;
	case 0x63:ops[poo] = op_ldr_reg_post_down;break;
	case 0x64:ops[poo] = op_strb_reg_post_down;break;
	case 0x65:ops[poo] = op_ldrb_reg_post_down;break;
	case 0x66:ops[poo] = op_strb_reg_post_down;break;
	case 0x67:ops[poo] = op_ldrb_reg_post_down;break;
	case 0x68:ops[poo] = op_str_reg_post_up;break;
	case 0x69:ops[poo] = op_ldr_reg_post_up;break;
	case 0x6a:ops[poo] = op_str_reg_post_up;break;
	case 0x6b:ops[poo] = op_ldr_reg_post_up;break;
	case 0x6c:ops[poo] = op_strb_reg_post_up;break;
	case 0x6d:ops[poo] = op_ldrb_reg_post_up;break;
	case 0x6e:ops[poo] = op_strb_reg_post_up;break;
	case 0x6f:ops[poo] = op_ldrb_reg_post_up;break;
	case 0x70:ops[poo] = op_str_reg_pre_down_nowb;break;
	case 0x71:ops[poo] = op_ldr_reg_pre_down_nowb;break;
	case 0x72:ops[poo] = op_str_reg_pre_down_wb;break;
	case 0x73:ops[poo] = op_ldr_reg_pre_down_wb;break;
	case 0x74:ops[poo] = op_strb_reg_pre_down_nowb;break;
	case 0x75:ops[poo] = op_ldrb_reg_pre_down_nowb;break;
	case 0x76:ops[poo] = op_strb_reg_pre_down_wb;break;
	case 0x77:ops[poo] = op_ldrb_reg_pre_down_wb;break;
	case 0x78:ops[poo] = op_str_reg_pre_up_nowb;break;
	case 0x79:ops[poo] = op_ldr_reg_pre_up_nowb;break;
	case 0x7a:ops[poo] = op_str_reg_pre_up_wb;break;
	case 0x7b:ops[poo] = op_ldr_reg_pre_up_wb;break;
	case 0x7c:ops[poo] = op_strb_reg_pre_up_nowb;break;
	case 0x7d:ops[poo] = op_ldrb_reg_pre_up_nowb;break;
	case 0x7e:ops[poo] = op_strb_reg_pre_up_wb;break;
	case 0x7f:ops[poo] = op_ldrb_reg_pre_up_wb;break;
	case 0x80:ops[poo] = op_error;break;
	case 0x81:ops[poo] = op_error;break;
	case 0x82:ops[poo] = op_error;break;
	case 0x83:ops[poo] = op_error;break;
	case 0x84:ops[poo] = op_error;break;
	case 0x85:ops[poo] = op_error;break;
	case 0x86:ops[poo] = op_error;break;
	case 0x87:ops[poo] = op_error;break;
	case 0x88:ops[poo] = op_error;break;
	case 0x89:ops[poo] = op_error;break;
	case 0x8a:ops[poo] = op_error;break;
	case 0x8b:ops[poo] = op_error;break;
	case 0x8c:ops[poo] = op_error;break;
	case 0x8d:ops[poo] = op_error;break;
	case 0x8e:ops[poo] = op_error;break;
	case 0x8f:ops[poo] = op_error;break;
	case 0x90:ops[poo] = op_error;break;
	case 0x91:ops[poo] = op_error;break;
	case 0x92:ops[poo] = op_error;break;
	case 0x93:ops[poo] = op_error;break;
	case 0x94:ops[poo] = op_error;break;
	case 0x95:ops[poo] = op_error;break;
	case 0x96:ops[poo] = op_error;break;
	case 0x97:ops[poo] = op_error;break;
	case 0x98:ops[poo] = op_error;break;
	case 0x99:ops[poo] = op_error;break;
	case 0x9a:ops[poo] = op_error;break;
	case 0x9b:ops[poo] = op_error;break;
	case 0x9c:ops[poo] = op_error;break;
	case 0x9d:ops[poo] = op_error;break;
	case 0x9e:ops[poo] = op_error;break;
	case 0x9f:ops[poo] = op_error;break;
	case 0xa0:ops[poo] = op_error;break;
	case 0xa1:ops[poo] = op_error;break;
	case 0xa2:ops[poo] = op_error;break;
	case 0xa3:ops[poo] = op_error;break;
	case 0xa4:ops[poo] = op_error;break;
	case 0xa5:ops[poo] = op_error;break;
	case 0xa6:ops[poo] = op_error;break;
	case 0xa7:ops[poo] = op_error;break;
	case 0xa8:ops[poo] = op_error;break;
	case 0xa9:ops[poo] = op_error;break;
	case 0xaa:ops[poo] = op_error;break;
	case 0xab:ops[poo] = op_error;break;
	case 0xac:ops[poo] = op_error;break;
	case 0xad:ops[poo] = op_error;break;
	case 0xae:ops[poo] = op_error;break;
	case 0xaf:ops[poo] = op_error;break;
	case 0xb0:ops[poo] = op_error;break;
	case 0xb1:ops[poo] = op_error;break;
	case 0xb2:ops[poo] = op_error;break;
	case 0xb3:ops[poo] = op_error;break;
	case 0xb4:ops[poo] = op_error;break;
	case 0xb5:ops[poo] = op_error;break;
	case 0xb6:ops[poo] = op_error;break;
	case 0xb7:ops[poo] = op_error;break;
	case 0xb8:ops[poo] = op_error;break;
	case 0xb9:ops[poo] = op_error;break;
	case 0xba:ops[poo] = op_error;break;
	case 0xbb:ops[poo] = op_error;break;
	case 0xbc:ops[poo] = op_error;break;
	case 0xbd:ops[poo] = op_error;break;
	case 0xbe:ops[poo] = op_error;break;
	case 0xbf:ops[poo] = op_error;break;
	case 0xc0:ops[poo] = op_error;break;
	case 0xc1:ops[poo] = op_error;break;
	case 0xc2:ops[poo] = op_error;break;
	case 0xc3:ops[poo] = op_error;break;
	case 0xc4:ops[poo] = op_error;break;
	case 0xc5:ops[poo] = op_error;break;
	case 0xc6:ops[poo] = op_error;break;
	case 0xc7:ops[poo] = op_error;break;
	case 0xc8:ops[poo] = op_error;break;
	case 0xc9:ops[poo] = op_error;break;
	case 0xca:ops[poo] = op_error;break;
	case 0xcb:ops[poo] = op_error;break;
	case 0xcc:ops[poo] = op_error;break;
	case 0xcd:ops[poo] = op_error;break;
	case 0xce:ops[poo] = op_error;break;
	case 0xcf:ops[poo] = op_error;break;
	case 0xd0:ops[poo] = op_error;break;
	case 0xd1:ops[poo] = op_error;break;
	case 0xd2:ops[poo] = op_error;break;
	case 0xd3:ops[poo] = op_error;break;
	case 0xd4:ops[poo] = op_error;break;
	case 0xd5:ops[poo] = op_error;break;
	case 0xd6:ops[poo] = op_error;break;
	case 0xd7:ops[poo] = op_error;break;
	case 0xd8:ops[poo] = op_error;break;
	case 0xd9:ops[poo] = op_error;break;
	case 0xda:ops[poo] = op_error;break;
	case 0xdb:ops[poo] = op_error;break;
	case 0xdc:ops[poo] = op_error;break;
	case 0xdd:ops[poo] = op_error;break;
	case 0xde:ops[poo] = op_error;break;
	case 0xdf:ops[poo] = op_error;break;
	case 0xe0:ops[poo] = op_error;break;
	case 0xe1:ops[poo] = op_error;break;
	case 0xe2:ops[poo] = op_error;break;
	case 0xe3:ops[poo] = op_error;break;
	case 0xe4:ops[poo] = op_error;break;
	case 0xe5:ops[poo] = op_error;break;
	case 0xe6:ops[poo] = op_error;break;
	case 0xe7:ops[poo] = op_error;break;
	case 0xe8:ops[poo] = op_error;break;
	case 0xe9:ops[poo] = op_error;break;
	case 0xea:ops[poo] = op_error;break;
	case 0xeb:ops[poo] = op_error;break;
	case 0xec:ops[poo] = op_error;break;
	case 0xed:ops[poo] = op_error;break;
	case 0xee:ops[poo] = op_error;break;
	case 0xef:ops[poo] = op_error;break;
	case 0xf0:ops[poo] = op_error;break;
	case 0xf1:ops[poo] = op_error;break;
	case 0xf2:ops[poo] = op_error;break;
	case 0xf3:ops[poo] = op_error;break;
	case 0xf4:ops[poo] = op_error;break;
	case 0xf5:ops[poo] = op_error;break;
	case 0xf6:ops[poo] = op_error;break;
	case 0xf7:ops[poo] = op_error;break;
	case 0xf8:ops[poo] = op_error;break;
	case 0xf9:ops[poo] = op_error;break;
	case 0xfa:ops[poo] = op_error;break;
	case 0xfb:ops[poo] = op_error;break;
	case 0xfc:ops[poo] = op_error;break;
	case 0xfd:ops[poo] = op_error;break;
	case 0xfe:ops[poo] = op_error;break;
	case 0xff:ops[poo] = op_error;break;
	}
/*********************************************************************************************/
