#ifndef __BLITTER_H__
#define __BLITTER_H__
/*********************************************************************************************/
#include <ddraw.h>
#include "types.h"
/*********************************************************************************************/
class blitter
	{
	public:
		virtual int init(HWND h){h=0;return(0);}
		virtual void kill(){}
		virtual void resize(){}
		virtual void *framestart(){return(0);}
		virtual void framestop(){}
	};
class gdiblitter:public blitter
	{
	private:
		u8 inited;
		BITMAPINFO bmpinfo;
		RECT rect;
		HWND hwnd;
		HDC hdc;
		HBITMAP hbitmap;
		int bpp;
		void *dest;
	public:
		gdiblitter();
		~gdiblitter();
		int init(HWND h);
		void kill();
		void resize();
		void *framestart();
		void framestop();
	};
class dxblitter:public blitter
	{
	private:
		DDSURFACEDESC2 ddsd;
		LPDIRECTDRAW7 lpDD;
		LPDIRECTDRAWSURFACE7 lpDDSPrimary;
		LPDIRECTDRAWSURFACE7 lpDDSBack;
		LPDIRECTDRAWCLIPPER lpClipper;
		u8 inited;
		RECT rect;
		HWND hwnd;
		int bpp;
		void *dest;
	public:
		dxblitter();
		~dxblitter();
		int init(HWND h);
		void kill();
		void resize();
		void *framestart();
		void framestop();
	};
/*********************************************************************************************/
#endif