// creem.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "creem.h"

#include "MainFrm.h"
#include "timing.h"
#include "settings.h"
#include "rominfo.h"
#include "render.h"

#include <afxwin.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/*********************************************************************************************/
#define getcheck_num(rk,c,v,k,d)\
{\
char value[256],*stop;\
u32 valuelen = 256;\
v = d;\
if(rk.QueryValue(value,k,&valuelen) == ERROR_SUCCESS)\
	v = (c)strtol(value,&stop,10);\
}
#define getcheck_str(rk,v,k,d)\
{\
char value[512];\
u32 valuelen = 512;\
strcpy(v,d);\
if(rk.QueryValue(value,k,&valuelen) == ERROR_SUCCESS)\
	strcpy(v,value);\
}
#define setcheck_num(rk,v,k)\
{\
char _value[256];\
sprintf(_value,"%ld",v);\
if(rk.SetKeyValue("",_value,k) != ERROR_SUCCESS)\
	{\
	if(rk.SetKeyValue("",_value,k) != ERROR_SUCCESS)\
		MessageBox(0,"error trying to write key \""k"\" to registry","error",MB_OK);\
	}\
}
#define setcheck_str(rk,v,k)\
{\
if(rk.SetKeyValue("",v,k) != ERROR_SUCCESS)\
	{\
	if(rk.SetKeyValue("",v,k) != ERROR_SUCCESS)\
		MessageBox(0,"error trying to write key \""k"\" to registry","error",MB_OK);\
	}\
}
#define GBA_TOTAL_SCANLINES(gt)	(gt->screen_scanlines + gt->blank_scanlines)
#define GBA_TOTAL_DOTS(gt)			(gt->screen_dots + gt->blank_dots)
#define GBA_SCANLINE_CYCLES(gt)	(gt->cpu_hz / gt->frequency / GBA_TOTAL_SCANLINES(gt))
#define GBA_SCREEN_CYCLES(gt)		(GBA_SCANLINE_CYCLES(gt) / GBA_TOTAL_DOTS(gt) * gt->screen_dots)
#define GBA_HBLANK_CYCLES(gt)		(GBA_SCANLINE_CYCLES(gt) / GBA_TOTAL_DOTS(gt) * gt->blank_dots)
#define GBA_VBLANK_CYCLES(gt)		((GBA_SCREEN_CYCLES(gt) + GBA_HBLANK_CYCLES(gt)) * gt->blank_scanlines)
/*********************************************************************************************/
char *useridentstring = "^dZ*dnak";
/*
code - user
-----------
dnak - internal code
*/
typedef void (*renderer_t)();
void (*renderer)();
gba_timing_t *gba_timing;
settings_t *settings;
arm7tdmi *context;
u8 stopped;
u8 scanline;
u32 romsize,cycles;
u32 rommask;
u32 oldaddr;
u8 regs[0x400];
u8 *bios=0;
u8 *ewram=0;
u8 *iwram=0;
u8 *pram=0;
u8 *vram=0;
u8 *oam=0;
u8 *rom=0,*romptr;
u16 *pal16;
u16 *pal17;
u32 *pal32;
char romfilename[_MAX_PATH] = "";
char biosfilename[_MAX_PATH] = "";
char *biosnames[12] = {"rom.bin","gba.bin","agb.bin",""};
#define reg_VCOUNT scanline //006
CStringList messages;
int maxmessages = 500;
renderer_t renderers_16[9] = {renderer0_16,renderer1_16,renderer2_16,renderer3_16,renderer4_16,renderer5_16,renderer0_16,renderer0_16,rendererblank_16};
renderer_t renderers_17[9] = {renderer0_17,renderer1_17,renderer2_17,renderer3_17,renderer4_17,renderer5_17,renderer0_17,renderer0_17,rendererblank_17};
renderer_t renderers_32[9] = {renderer0_32,renderer1_32,renderer2_32,renderer3_32,renderer4_32,renderer5_32,renderer0_32,renderer0_32,rendererblank_32};
renderer_t *renderers;
void (*palwrite16)(u32,u16);
void (*palwrite32)(u32,u32);
u32 romwait;
u32 romwaittable1[8] = {4,3,2,8,4,3,2,8};
u32 romwaittable2[3][8] =
	{
	{2,2,2,2,1,1,1,1},
	{4,4,4,4,1,1,1,1},
	{8,8,8,8,1,1,1,1}
	};
/*********************************************************************************************/
extern "C" void emumessage(char *msg,...)
{
va_list args;
char debugmsg[1024];
int i,sl;

va_start(args,msg);
vsprintf(debugmsg,msg,args);
va_end(args);
sl = strlen(debugmsg);
for(i=0;i<sl;i++)
	{
	if(debugmsg[i] == '\n')
		debugmsg[i] = ' ';
	}
if(messages.GetCount() > maxmessages)
	messages.RemoveAt(messages.FindIndex(0));
messages.AddTail(debugmsg);
if(theApp.messagesdlg)
	theApp.messagesdlg->addstring(debugmsg);
}
/*********************************************************************************************/
void palwrite16_16(u32 addr,u16 value)
{
pal16[addr >> 1] = (u16)(((value & 0x7c00) >> 10) | (value & 0x03e0) | ((value & 0x001f) << 10));
}
void palwrite32_16(u32 addr,u32 value)
{
u16 v1,v2;

v1 = (u16)value;
v2 = (u16)(value >> 16);
pal16[addr >> 1] = (u16)(((v1 & 0x7c00) >> 10) | (v1 & 0x03e0) | ((v1 & 0x001f) << 10));
pal16[(addr >> 1) + 1] = (u16)(((v2 & 0x7c00) >> 10) | (v2 & 0x03e0) | ((v2 & 0x001f) << 10));
}
/*********************************************************************************************/
void palwrite16_17(u32 addr,u16 value)
{
pal16[addr >> 1] = (u16)(((value & 0x7c00) >> 10) | (value & 0x03e0) | ((value & 0x001f) << 10));
}
void palwrite32_17(u32 addr,u32 value)
{
u16 v1,v2;

v1 = (u16)value;
v2 = (u16)(value >> 16);
pal16[addr >> 1] = (u16)(((v1 & 0x7c00) >> 10) | (v1 & 0x03e0) | ((v1 & 0x001f) << 10));
pal16[(addr >> 1) + 1] = (u16)(((v2 & 0x7c00) >> 10) | (v2 & 0x03e0) | ((v2 & 0x001f) << 10));
}
/*********************************************************************************************/
void palwrite16_32(u32 addr,u16 value)
{
pal32[addr >> 1] = (u32)(((value & 0x7c00) >> 7) | ((value & 0x3e0) << 6) | ((value & 0x1f) << 19));
}
void palwrite32_32(u32 addr,u32 value)
{
u16 v1,v2;

v1 = (u16)value;
v2 = (u16)(value >> 16);
pal32[addr >> 1] = (u32)(((v1 & 0x7c00) >> 7) | ((v1 & 0x3e0) << 6) | ((v1 & 0x1f) << 19));
pal32[(addr >> 1) + 1] = (u32)(((v2 & 0x7c00) >> 7) | ((v2 & 0x3e0) << 6) | ((v2 & 0x1f) << 19));
}
/*********************************************************************************************/
u8 read8_bios(u32 addr)
{
if(addr < 0x4000)
	return(bios[addr]);
return(0);
}
/*********************************************************************************************/
u8 read8_null(u32 /*addr*/)
{
return(0);
}
/*********************************************************************************************/
u8 read8_ewram(u32 addr)
{
ADDCYCLES(2);
return(ewram[addr & 0x3ffff]);
}
/*********************************************************************************************/
u8 read8_iwram(u32 addr)
{
return(iwram[addr & 0x7fff]);
}
/*********************************************************************************************/
u8 read8_registers(u32 addr)
{
addr &= 0x3ff;
if(addr == DISPSTAT)
	{
	if(cyclesexec > gba_timing->screen_cycles)
		regs[DISPSTAT] |= 2; //were in hblank
	else
		regs[DISPSTAT] &= ~2;
	}
return(regs[addr]);
}
/*********************************************************************************************/
u8 read8_pram(u32 addr)
{
return(pram[addr & 0x3ff]);
}
/*********************************************************************************************/
u8 read8_vram(u32 addr)
{
addr &= 0x1ffff;
addr &= ~((addr & 0x10000) >> 1);
return(vram[addr % 0x18000]);
}
/*********************************************************************************************/
u8 read8_oam(u32 addr)
{
return(oam[addr & 0x3ff]);
}
/*********************************************************************************************/
u8 read8_rom(u32 addr)
{
if((oldaddr + 1) == addr){ADDCYCLES(2);}
else{ADDCYCLES(4);}
oldaddr = addr;
return(rom[addr & rommask]);
}
/*********************************************************************************************/
u16 read16_bios(u32 addr)
{
if(addr < 0x4000)
	return(*(u16*)(bios + addr));
return(0);
}
/*********************************************************************************************/
u16 read16_null(u32 /*addr*/)
{
return(0);
}
/*********************************************************************************************/
u16 read16_ewram(u32 addr)
{
ADDCYCLES(2);
return(*(u16*)(ewram + (addr & 0x3fffe)));
}
/*********************************************************************************************/
u16 read16_iwram(u32 addr)
{
return(*(u16*)(iwram + (addr & 0x7ffe)));
}
/*********************************************************************************************/
u16 read16_registers(u32 addr)
{
addr &= 0x3fe;
if(addr == DISPSTAT)
	{
	if(cyclesexec > gba_timing->screen_cycles)
		regs[DISPSTAT] |= 2; //were in hblank
	else
		regs[DISPSTAT] &= ~2;
	}
return(GETREG16(addr));
}
/*********************************************************************************************/
u16 read16_pram(u32 addr)
{
return(*(u16*)(pram + (addr & 0x3fe)));
}
/*********************************************************************************************/
u16 read16_vram(u32 addr)
{
addr &= 0x1fffe;
addr &= ~((addr & 0x10000) >> 1);
return(*(u16*)(vram + addr));
}
/*********************************************************************************************/
u16 read16_oam(u32 addr)
{
return(*(u16*)(oam + (addr & 0x3fe)));
}
/*********************************************************************************************/
u16 read16_rom(u32 addr)
{
if((oldaddr + 2) == addr){ADDCYCLES(2);}
else{ADDCYCLES(4);}
oldaddr = addr;
return(*(u16*)(rom + (addr & rommask)));
}
/*********************************************************************************************/
u32 read32_bios(u32 addr)
{
if(addr < 0x4000)
	return(*(u32*)(bios + addr));
return(0);
}
/*********************************************************************************************/
u32 read32_null(u32 /*addr*/)
{
return(0);
}
/*********************************************************************************************/
u32 read32_ewram(u32 addr)
{
ADDCYCLES(2);
return(*(u32*)(ewram + (addr & 0x3fffc)));
}
/*********************************************************************************************/
u32 read32_iwram(u32 addr)
{
return(*(u32*)(iwram + (addr & 0x7ffc)));
}
/*********************************************************************************************/
u32 read32_registers(u32 addr)
{
addr &= ~3;
return(read16_registers(addr) | (read16_registers(addr+2) << 16));
}
/*********************************************************************************************/
u32 read32_pram(u32 addr)
{
return(*(u32*)(pram + (addr & 0x3fc)));
}
/*********************************************************************************************/
u32 read32_vram(u32 addr)
{
addr &= 0x1fffc;
addr &= ~((addr & 0x10000) >> 1);
return(*(u32*)(vram + addr));
}
/*********************************************************************************************/
u32 read32_oam(u32 addr)
{
return(*(u32*)(oam + (addr & 0x3fc)));
}
/*********************************************************************************************/
u32 read32_rom(u32 addr)
{
if((oldaddr + 4) == addr){ADDCYCLES(2);}
else{ADDCYCLES(4);}
oldaddr = addr;
return(*(u32*)(rom + (addr & rommask)));
}
/*********************************************************************************************/
void write8_bios(u32 /*addr*/,u8 /*value*/)
{

}
/*********************************************************************************************/
void write8_null(u32 /*addr*/,u8 /*value*/)
{

}
/*********************************************************************************************/
void write8_ewram(u32 addr,u8 value)
{
ADDCYCLES(2);
ewram[addr & 0x3ffff] = value;
}
/*********************************************************************************************/
void write8_iwram(u32 addr,u8 value)
{
iwram[addr & 0x7fff] = value;
}
/*********************************************************************************************/
void write8_registers(u32 addr,u8 value)
{
addr &= 0x3ff;
regs[addr] = value;
switch(addr)
	{
	case DISPCNT:
		if(value & 0x0080) //screen off
			renderer = renderers[8];
		else
			renderer = renderers[value & 7];
		break;
	case DM0CNT_H+1:
		if((value & 0xb0) == 0x80) //execute now
			dma0();
		break;
	case DM1CNT_H+1:
		if((value & 0xb0) == 0x80)
			dma1();
		break;
	case DM2CNT_H+1:
		if((value & 0xb0) == 0x80)
			dma2();
		break;
	case DM3CNT_H+1:
		if((value & 0xb0) == 0x80)
			dma3();
		break;
	}
}
/*********************************************************************************************/
void write8_pram(u32 addr,u8 value)
{
u16 v;

v = (u16)(value | (value << 8));
addr &= 0x3fe;
*(u16*)(pram + addr) = v;
palwrite16(addr,v);
}
/*********************************************************************************************/
void write8_vram(u32 addr,u8 value)
{
u16 v;

v = (u16)(value | (value << 8));
addr &= 0x1ffff;
addr &= ~((addr & 0x10000) >> 1);
*(u16*)(vram + addr) = v;
}
/*********************************************************************************************/
void write8_oam(u32 addr,u8 value)
{
u16 v;

v = (u16)(value | (value << 8));
*(u16*)(oam + addr) = v;
}
/*********************************************************************************************/
void write8_rom(u32 /*addr*/,u8 /*value*/)
{

}
/*********************************************************************************************/
void write16_bios(u32 /*addr*/,u16 /*value*/)
{

}
/*********************************************************************************************/
void write16_null(u32 /*addr*/,u16 /*value*/)
{

}
/*********************************************************************************************/
void write16_ewram(u32 addr,u16 value)
{
ADDCYCLES(2);
*(u16*)(ewram + (addr & 0x3fffe)) = value;
}
/*********************************************************************************************/
void write16_iwram(u32 addr,u16 value)
{
*(u16*)(iwram + (addr & 0x7ffe)) = value;
}
/*********************************************************************************************/
void write16_registers(u32 addr,u16 value)
{
addr &= 0x3fe;
SETREG16(addr,value);
switch(addr)
	{
	case DISPCNT:
		if(value & 0x0080) //screen off
			renderer = renderers[8];
		else
			renderer = renderers[value & 7];
		break;
	case DM0CNT_H:
		if((value & 0xb000) == 0x8000) //execute now
			dma0();
		break;
	case DM1CNT_H:
		if((value & 0xb000) == 0x8000)
			dma1();
		break;
	case DM2CNT_H:
		if((value & 0xb000) == 0x8000)
			dma2();
		break;
	case DM3CNT_H:
		if((value & 0xb000) == 0x8000)
			dma3();
		break;
	}
}
/*********************************************************************************************/
void write16_pram(u32 addr,u16 value)
{
addr &= 0x3fe;
*(u16*)(pram + addr) = value;
palwrite16(addr,value);
}
/*********************************************************************************************/
void write16_vram(u32 addr,u16 value)
{
addr &= 0x1fffe;
addr &= ~((addr & 0x10000) >> 1);
*(u16*)(vram + addr) = value;
}
/*********************************************************************************************/
void write16_oam(u32 addr,u16 value)
{
*(u16*)(oam + (addr & 0x3fe)) = value;
}
/*********************************************************************************************/
void write16_rom(u32 /*addr*/,u16 /*value*/)
{

}
/*********************************************************************************************/
void write32_bios(u32 /*addr*/,u32 /*value*/)
{

}
/*********************************************************************************************/
void write32_null(u32 /*addr*/,u32 /*value*/)
{

}
/*********************************************************************************************/
void write32_ewram(u32 addr,u32 value)
{
ADDCYCLES(2);
*(u32*)(ewram + (addr & 0x3fffc)) = value;
}
/*********************************************************************************************/
void write32_iwram(u32 addr,u32 value)
{
*(u32*)(iwram + (addr & 0x7ffc)) = value;
}
/*********************************************************************************************/
void write32_registers(u32 addr,u32 value)
{
addr &= ~3;
write16_registers(addr,(u16)value);
write16_registers(addr+2,(u16)(value >> 16));
}
/*********************************************************************************************/
void write32_pram(u32 addr,u32 value)
{
addr &= 0x3fc;
*(u32*)(pram + addr) = value;
palwrite32(addr,value);
}
/*********************************************************************************************/
void write32_vram(u32 addr,u32 value)
{
addr &= 0x1fffc;
addr &= ~((addr & 0x10000) >> 1);
*(u32*)(vram + addr) = value;
}
/*********************************************************************************************/
void write32_oam(u32 addr,u32 value)
{
*(u32*)(oam + (addr & 0x3fc)) = value;
}
/*********************************************************************************************/
void write32_rom(u32 /*addr*/,u32 /*value*/)
{

}
/*********************************************************************************************/
#define dmafunc(num,name,sadl,sadh,dadl,dadh,cntl,cnth,sm,dm,cm,imask)\
void name()\
{\
u16 i;\
u32 src,dest;\
s32 sinc,dinc;\
\
switch((cnth >> 7) & 3)\
	{\
	default:\
	case 0:sinc = 1;break;\
	case 1:sinc = -1;break;\
	case 2:sinc = 0;break;\
	case 3:sinc = 0;break;\
	}\
switch((cnth >> 5) & 3)\
	{\
	default:\
	case 0:dinc = 1;break;\
	case 1:dinc = -1;break;\
	case 2:dinc = 0;break;\
	case 3:dinc = 1;break;\
	}\
emumessage("dma%d: src %08x, dest %08x, bytes %08x, src adder %d, dest adder %d\n",num,(sadl | (sadh << 16)) & sm,(dadl | (dadh << 16)) & dm,cntl & cm,sinc,dinc);\
if(cnth & 0x0400)\
	{\
	src = (sadl | (sadh << 16)) & sm;\
	dest = (dadl | (dadh << 16)) & dm;\
	for(i=0;i<(cntl & cm);i++)\
		{\
		context->write32funcs[dest >> 24](dest,context->read32funcs[dest >> 24](src));\
		dest += dinc;\
		src += sinc;\
		}\
	}\
else\
	{\
	src = (sadl | (sadh << 16)) & sm;\
	dest = (dadl | (dadh << 16)) & dm;\
	for(i=0;i<(cntl & cm);i++)\
		{\
		context->write16funcs[dest >> 24](dest,context->read16funcs[dest >> 24](src));\
		dest += dinc;\
		src += sinc;\
		}\
	}\
if((cnth & 0x0080) == 0x0000)\
	{\
	sadl = (u16)src;\
	sadh = (u16)((src >> 16) & (sm >> 16));\
	dadl = (u16)dest;\
	dadh = (u16)((dest >> 16) & (dm >> 16));\
	}\
if((cnth & 0x0200) == 0)\
	cnth &= ~0x8000;\
if(GETREG16(IME) & 1)\
	{\
	if(GETREG16(IE) & imask)\
		{\
		GETREG16(IF) |= imask;\
		arm7tdmi_irq();\
		}\
	}\
}
dmafunc(0,dma0,GETREG16(DM0SAD_L),GETREG16(DM0SAD_H),GETREG16(DM0DAD_L),GETREG16(DM0DAD_H),GETREG16(DM0CNT_L),GETREG16(DM0CNT_H),0x07ffffff,0x07ffffff,0x3fff,0x0100);
dmafunc(1,dma1,GETREG16(DM1SAD_L),GETREG16(DM1SAD_H),GETREG16(DM1DAD_L),GETREG16(DM1DAD_H),GETREG16(DM1CNT_L),GETREG16(DM1CNT_H),0x07ffffff,0x0fffffff,0x3fff,0x0200);
dmafunc(2,dma2,GETREG16(DM2SAD_L),GETREG16(DM2SAD_H),GETREG16(DM2DAD_L),GETREG16(DM2DAD_H),GETREG16(DM2CNT_L),GETREG16(DM2CNT_H),0x07ffffff,0x0fffffff,0x3fff,0x0400);
dmafunc(3,dma3,GETREG16(DM3SAD_L),GETREG16(DM3SAD_H),GETREG16(DM3DAD_L),GETREG16(DM3DAD_H),GETREG16(DM3CNT_L),GETREG16(DM3CNT_H),0x0fffffff,0x0fffffff,0xffff,0x0800);
/*********************************************************************************************/
int loadbios(char *fn)
{
FILE *f;
u32 biossize;

if((f = fopen(fn,"rb")) == 0)
	{
	emumessage("cant open bios file %s\n",fn);
	return(1);
	}
else
	{
	fseek(f,0,SEEK_END);
	biossize = ftell(f);
	fseek(f,0,SEEK_SET);
	if(biossize != 16384)
		{
		emumessage("bios file %s is %s, should be 16384 bytes\n",fn,biossize<16384?"smaller":"bigger");
		fclose(f);
		return(2);
		}
	bios = new u8[biossize];
	if(fread(bios,biossize,1,f) != biossize)
		emumessage("%s bios file loaded, %ld bytes\n",fn,biossize);
	else
		{
		emumessage("error reading bios file %s\n",fn);
		fclose(f);
		return(1);
		}
	fclose(f);
	return(0);
	}
}
/*********************************************************************************************/
/*
0x00 - 4 bytes		0x7f,"ELF"  (ELF file identifier)
0x04 - 1 byte		File Class: 1=32bit, 2=64bit objects
0x05 - 1 byte		Data Encoding: 1=ELFDATA2LSB, 2=ELFDATA2MSB
0x06 - 1 byte		ELF header version (must be 1)
0x07 - 9 bytes		zeroised
0x10 - 2 bytes		ELF type: 0=NONE, 1=REL, 2=EXEC, 3=SHARED, 4=CORE
0x12 - 2 bytes		Processor: 8=MIPS R3000
0x14 - 4 bytes		Version: 1=current
0x18 - 4 bytes		Entry point address
0x1C - 4 bytes		Start of program headers (offset from file start)
0x20 - 4 bytes		Start of section headers (offset from file start)
0x24 - 4 bytes		Processor specific flags = 0x20924001 noreorder, mips
0x28 - 2 bytes		ELF header size (0x34 = 52 bytes)
0x2A - 2 bytes		Program headers entry size 
0x2C - 2 bytes		Number of program headers
0x3E - 2 bytes		Section headers entry size
0x30 - 2 bytes		Number of section headers
0x32 - 2 bytes		Section header stringtable index	*/
typedef struct
	{
	u8 ident[4];
	u8 fileclass;
	u8 encoding;
	u8 headerversion;
	u8 zeros[9];
	u16 type;
	u16 processor;
	u32 version;
	u32 entrypoint;
	u32 programheaderstart;
	u32 sectionheaderstart;
	u32 processorflags;
	u16 headersize;
	u16 programheadersize;
	u16 programheadernum;
	u16 sectionheadersize;
	u16 sectionheadernum;
	} elf_header_t;
/*
0x00 - 4 bytes		Segment type: 
				0=Inactive
				1=Load the segment into memory, no. of bytes specified by 0x10 and 0x14
				2=Dynamic linking
				3=Interpreter. The array element must specify a path name
				4=Note. The array element must specify the location and size of aux. info
				5=reserved
				6=The array element must specify location and size of the program header table.
				0x70000000 - 0x7fffffff processor specific semantics
0x04 - 4 bytes		Offset from file start to program segment.
0x08 - 4 bytes		Virtual address of the segment
0x0C - 4 bytes		Physical address of the segment
0x10 - 4 bytes		Number of bytes in the file image of the segment
0x14 - 4 bytes		Number of bytes in the memory image of the segment
0x18 - 4 bytes		Flags for segment
0x1C - 4 bytes		Alignment. The address of 0x08 and 0x0C must fit this alignment. 0=no alignment*/
typedef struct
	{
	u32 segmenttype;
	u32 segmentaddr;
	u32 vaddr;
	u32 paddr;
	u32 filebytes;
	u32 memorybytes;
	u32 flags;
	u32 alignment;
	} program_header_t;

int fileexists(char *f)
{
FILE *file;

if((file = fopen(f,"rb")) == 0)
	return(0);
fclose(file);
return(1);
}

int loadrom(char *filename)
{
FILE *f;
char _fn[512],*fn = _fn;

strcpy(fn,filename);
if(fileexists(fn) == 0)
	{
	sprintf(fn,"%s%s",settings->rompath,filename);
	if(fileexists(fn) == 0)
		{
		emumessage("cant open %s it doesnt exist\n",filename);
		return(1);
		}
	}
if(strnicmp(fn + strlen(fn) - 3,"elf",3) == 0)
	{
	if((f = fopen(fn,"rb")) == 0)
		{
		emumessage("cant open file %s\n",fn);
		return(1);
		}
	else
		{
		elf_header_t elf_header;
		program_header_t program_header;
		u32 saveloc,i;
		u8 elfident[4] = {0x7f,'E','L','F'};

		fread(&elf_header,sizeof(elf_header_t),1,f);
		if(memcmp(elf_header.ident,elfident,4) != 0)
			{
			emumessage("bad elf header ident\n");
			fclose(f);
			return(1);
			}
		fseek(f,elf_header.programheaderstart,SEEK_SET);
		for(i=0;i<elf_header.programheadernum;i++)
			{
			fread(&program_header,sizeof(program_header_t),1,f);
			saveloc = ftell(f);
			fseek(f,program_header.segmentaddr,SEEK_SET);
//load segment
			fseek(f,saveloc,SEEK_SET);
			}
		fclose(f);
		return(1);
		}
	}
else
	{
	if((f = fopen(fn,"rb")) == 0)
		{
		emumessage("cant open file %s\n",fn);
		return(1);
		}
	else
		{
		u32 i;

		fseek(f,0,SEEK_END);
		romsize = ftell(f);
		fseek(f,0,SEEK_SET);
		rommask = 0;
		for(i=0;i<32;i++)
			{
			if((u32)((1 << i) - 1) >= romsize)
				{
				rommask = (1 << i) - 1;
				break;
				}
			}
		if(rommask == 0 || romsize > 0x07ffffff)
			{
			emumessage("cant find a good rommask\n");
			return(0);
			}
		else
			emumessage("rom mask %08x, rom size %08x\n",rommask,romsize);
		romptr = rom = new u8[rommask + 1];
		if(fread(rom,romsize,1,f) != romsize)
			emumessage("%s loaded, %ld bytes\n",fn,romsize);
		else
			{
			emumessage("error reading file %s\n",fn);
			fclose(f);
			return(1);
			}
		fclose(f);
		return(0);
		}
	}
return(1);
}
/*********************************************************************************************/
/////////////////////////////////////////////////////////////////////////////
// CCreemApp

BEGIN_MESSAGE_MAP(CCreemApp, CWinApp)
	//{{AFX_MSG_MAP(CCreemApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_VIEW_TIMING, OnViewTiming)
	ON_COMMAND(ID_VIEW_DEBUGGER, OnViewDebugger)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_COMMAND(ID_EMULATION_RESET, OnEmulationReset)
	ON_COMMAND(ID_VIEW_WINDOWSIZE_1X, OnViewWindowsize1x)
	ON_COMMAND(ID_VIEW_WINDOWSIZE_2X, OnViewWindowsize2x)
	ON_COMMAND(ID_VIEW_WINDOWSIZE_3X, OnViewWindowsize3x)
	ON_COMMAND(ID_VIEW_WINDOWSIZE_4X, OnViewWindowsize4x)
	ON_COMMAND(ID_EMULATION_START, OnEmulationStart)
	ON_COMMAND(ID_EMULATION_STOP, OnEmulationStop)
	ON_COMMAND(ID_VIEW_MESSAGES, OnViewMessages)
	ON_COMMAND(ID_VIEW_SETTINGS, OnViewSettings)
	ON_COMMAND(ID_VIEW_ROMINFO, OnViewRominfo)
	ON_COMMAND(ID_VIEW_MEMORY, OnViewMemory)
	ON_UPDATE_COMMAND_UI(ID_FILE_RECENTFILES, OnUpdateFileRecentfiles)
	ON_COMMAND(ID_FILE_SAVESETTINGS, OnFileSavesettings)
	ON_COMMAND(ID_FILE_SCREENSHOT, OnFileScreenshot)
	ON_COMMAND(ID_FILE_RELOAD, OnFileReload)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCreemApp construction

CCreemApp::CCreemApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
int i;

messages.RemoveAll();
emumessage("creem v%s by Dead_Body, built on %s at %s\n",VERSION,__DATE__,__TIME__);
rom = 0;
romptr = 0;
arm7tdmi_init();
context = new arm7tdmi;
for(i=0;i<16;i++)
	{
	int bank = i * 16;

	context->read8funcs[bank | 0] = read8_bios;
	context->read8funcs[bank | 1] = read8_null;
	context->read8funcs[bank | 2] = read8_ewram;
	context->read8funcs[bank | 3] = read8_iwram;
	context->read8funcs[bank | 4] = read8_registers;
	context->read8funcs[bank | 5] = read8_pram;
	context->read8funcs[bank | 6] = read8_vram;
	context->read8funcs[bank | 7] = read8_oam;
	context->read8funcs[bank | 8] = read8_rom;
	context->read8funcs[bank | 9] = read8_rom;
	context->read8funcs[bank | 10] = read8_rom;
	context->read8funcs[bank | 11] = read8_rom;
	context->read8funcs[bank | 12] = read8_rom;
	context->read8funcs[bank | 13] = read8_rom;
	context->read8funcs[bank | 14] = read8_rom;
	context->read8funcs[bank | 15] = read8_rom;
	context->read16funcs[bank | 0] = read16_bios;
	context->read16funcs[bank | 1] = read16_null;
	context->read16funcs[bank | 2] = read16_ewram;
	context->read16funcs[bank | 3] = read16_iwram;
	context->read16funcs[bank | 4] = read16_registers;
	context->read16funcs[bank | 5] = read16_pram;
	context->read16funcs[bank | 6] = read16_vram;
	context->read16funcs[bank | 7] = read16_oam;
	context->read16funcs[bank | 8] = read16_rom;
	context->read16funcs[bank | 9] = read16_rom;
	context->read16funcs[bank | 10] = read16_rom;
	context->read16funcs[bank | 11] = read16_rom;
	context->read16funcs[bank | 12] = read16_rom;
	context->read16funcs[bank | 13] = read16_rom;
	context->read16funcs[bank | 14] = read16_rom;
	context->read16funcs[bank | 15] = read16_rom;
	context->read32funcs[bank | 0] = read32_bios;
	context->read32funcs[bank | 1] = read32_null;
	context->read32funcs[bank | 2] = read32_ewram;
	context->read32funcs[bank | 3] = read32_iwram;
	context->read32funcs[bank | 4] = read32_registers;
	context->read32funcs[bank | 5] = read32_pram;
	context->read32funcs[bank | 6] = read32_vram;
	context->read32funcs[bank | 7] = read32_oam;
	context->read32funcs[bank | 8] = read32_rom;
	context->read32funcs[bank | 9] = read32_rom;
	context->read32funcs[bank | 10] = read32_rom;
	context->read32funcs[bank | 11] = read32_rom;
	context->read32funcs[bank | 12] = read32_rom;
	context->read32funcs[bank | 13] = read32_rom;
	context->read32funcs[bank | 14] = read32_rom;
	context->read32funcs[bank | 15] = read32_rom;
	context->write8funcs[bank | 0] = write8_bios;
	context->write8funcs[bank | 1] = write8_null;
	context->write8funcs[bank | 2] = write8_ewram;
	context->write8funcs[bank | 3] = write8_iwram;
	context->write8funcs[bank | 4] = write8_registers;
	context->write8funcs[bank | 5] = write8_pram;
	context->write8funcs[bank | 6] = write8_vram;
	context->write8funcs[bank | 7] = write8_oam;
	context->write8funcs[bank | 8] = write8_rom;
	context->write8funcs[bank | 9] = write8_rom;
	context->write8funcs[bank | 10] = write8_rom;
	context->write8funcs[bank | 11] = write8_rom;
	context->write8funcs[bank | 12] = write8_rom;
	context->write8funcs[bank | 13] = write8_rom;
	context->write8funcs[bank | 14] = write8_rom;
	context->write8funcs[bank | 15] = write8_rom;
	context->write16funcs[bank | 0] = write16_bios;
	context->write16funcs[bank | 1] = write16_null;
	context->write16funcs[bank | 2] = write16_ewram;
	context->write16funcs[bank | 3] = write16_iwram;
	context->write16funcs[bank | 4] = write16_registers;
	context->write16funcs[bank | 5] = write16_pram;
	context->write16funcs[bank | 6] = write16_vram;
	context->write16funcs[bank | 7] = write16_oam;
	context->write16funcs[bank | 8] = write16_rom;
	context->write16funcs[bank | 9] = write16_rom;
	context->write16funcs[bank | 10] = write16_rom;
	context->write16funcs[bank | 11] = write16_rom;
	context->write16funcs[bank | 12] = write16_rom;
	context->write16funcs[bank | 13] = write16_rom;
	context->write16funcs[bank | 14] = write16_rom;
	context->write16funcs[bank | 15] = write16_rom;
	context->write32funcs[bank | 0] = write32_bios;
	context->write32funcs[bank | 1] = write32_null;
	context->write32funcs[bank | 2] = write32_ewram;
	context->write32funcs[bank | 3] = write32_iwram;
	context->write32funcs[bank | 4] = write32_registers;
	context->write32funcs[bank | 5] = write32_pram;
	context->write32funcs[bank | 6] = write32_vram;
	context->write32funcs[bank | 7] = write32_oam;
	context->write32funcs[bank | 8] = write32_rom;
	context->write32funcs[bank | 9] = write32_rom;
	context->write32funcs[bank | 10] = write32_rom;
	context->write32funcs[bank | 11] = write32_rom;
	context->write32funcs[bank | 12] = write32_rom;
	context->write32funcs[bank | 13] = write32_rom;
	context->write32funcs[bank | 14] = write32_rom;
	context->write32funcs[bank | 15] = write32_rom;
	}
gba_timing = new gba_timing_t;
settings = new settings_t;
debuggerdlg = 0;
messagesdlg = 0;
memorydlg = 0;
screen = 0;
loadsettings();
calctiming();
switch(settings->blitter)
	{
	default:settings->blitter = 0;
	case 0:m_blitter = new gdiblitter;break;
	case 1:m_blitter = new dxblitter;break;
	}
}

CCreemApp::~CCreemApp()
{
savesettings();
killemu(0);
delete context;
delete gba_timing;
delete settings;
delete m_blitter;
if(messagesdlg)
	delete messagesdlg;
}

void CCreemApp::startemulation()
{
LARGE_INTEGER c;

stopped = 0;
m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_GRAYED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_ENABLED);
QueryPerformanceFrequency(&freq);
QueryPerformanceCounter(&c);
last = c.QuadPart;
frametime = freq.QuadPart / 60;
}

void CCreemApp::stopemulation()
{
char newtitle[512];
char filename[512];
u32 i;

stopped = 1;
m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_GRAYED);
strcpy(filename,romfilename);
for(i=0;i<strlen(filename);i++)
	{
	if(filename[i] == '/')
		filename[i] = '\\';
	}
sprintf(newtitle,"creem - %s",strrchr(filename,'\\') + 1);
m_pMainWnd->SetWindowText(newtitle);
}

void CCreemApp::loadsettings()
{
CRegKey key;

if(key.Open(HKEY_CURRENT_USER,"Software\\Dead_Body\\creem\\settings") == ERROR_SUCCESS)
	{
	char curdir[512];

	GetCurrentDirectory(512,curdir);
	getcheck_num(key,u32,gba_timing->cpu_hz,"cpu_hz",16780000);
	getcheck_num(key,u8,gba_timing->frequency,"frequency",60);
	getcheck_num(key,u8,gba_timing->screen_scanlines,"screen_scanlines",160);
	getcheck_num(key,u8,gba_timing->screen_dots,"screen_dots",240);
	getcheck_num(key,u8,gba_timing->blank_scanlines,"blank_scanlines",68);
	getcheck_num(key,u8,gba_timing->blank_dots,"blank_dots",68);
	getcheck_num(key,u8,settings->startwhenloaded,"startwhenloaded",1);
	getcheck_num(key,u32,settings->startaddr,"startaddr",0x08000000);
	getcheck_num(key,u8,settings->requirebios,"requirebios",0);
	getcheck_num(key,u32,settings->w,"w",240);
	getcheck_num(key,u32,settings->h,"h",160);
	getcheck_num(key,u32,settings->x,"x",0xffffffff);
	getcheck_num(key,u32,settings->y,"y",0xffffffff);
	getcheck_num(key,u32,settings->debugger_x,"debugger_x",0xffffffff);
	getcheck_num(key,u32,settings->debugger_y,"debugger_y",0xffffffff);
	getcheck_num(key,u32,settings->messages_x,"messages_x",0xffffffff);
	getcheck_num(key,u32,settings->messages_y,"messages_y",0xffffffff);
	getcheck_num(key,u32,settings->memory_x,"memory_x",0xffffffff);
	getcheck_num(key,u32,settings->memory_y,"memory_y",0xffffffff);
	getcheck_num(key,u8,settings->blitter,"blitter",0);
	getcheck_num(key,u8,settings->framelimit,"framelimit",0);
	getcheck_num(key,u8,settings->frameskip,"frameskip",0);
	getcheck_num(key,u8,settings->maxrecentfiles,"maxrecentfiles",10);
	getcheck_str(key,settings->rompath,"rompath",curdir);
	getcheck_str(key,settings->miscpath,"miscpath",curdir);
	key.Close();
	emumessage("settings loaded\n");
	}
else
	{
	gba_timing->cpu_hz = 16780000;
	gba_timing->frequency = 60;
	gba_timing->screen_scanlines = 160;
	gba_timing->screen_dots = 240;
	gba_timing->blank_scanlines = 68;
	gba_timing->blank_dots = 68;
	settings->startwhenloaded = 1;
	settings->startaddr = 0x08000000;
	settings->requirebios = 0;
	settings->w = 240;
	settings->h = 160;
	settings->x = 0xffffffff;
	settings->y = 0xffffffff;
	settings->debugger_x = 0xffffffff;
	settings->debugger_y = 0xffffffff;
	settings->messages_x = 0xffffffff;
	settings->messages_y = 0xffffffff;
	settings->memory_x = 0xffffffff;
	settings->memory_y = 0xffffffff;
	settings->blitter = 0;
	settings->framelimit = 1;
	settings->frameskip = 0;
	settings->maxrecentfiles = 10;
	GetCurrentDirectory(512,settings->rompath);
	GetCurrentDirectory(512,settings->miscpath);
	emumessage("error loading settings (maybe first time ran?  congratulation!)\n");
	}
fixpathstring(settings->rompath);
fixpathstring(settings->miscpath);
}

void CCreemApp::savesettings()
{
CRegKey key;

if(key.Create(HKEY_CURRENT_USER,"Software\\Dead_Body\\creem\\settings") == ERROR_SUCCESS)
	{
	setcheck_num(key,gba_timing->cpu_hz,"cpu_hz");
	setcheck_num(key,gba_timing->frequency,"frequency");
	setcheck_num(key,gba_timing->screen_scanlines,"screen_scanlines");
	setcheck_num(key,gba_timing->screen_dots,"screen_dots");
	setcheck_num(key,gba_timing->blank_scanlines,"blank_scanlines");
	setcheck_num(key,gba_timing->blank_dots,"blank_dots");
	setcheck_num(key,settings->startwhenloaded,"startwhenloaded");
	setcheck_num(key,settings->startaddr,"startaddr");
	setcheck_num(key,settings->requirebios,"requirebios");
	setcheck_num(key,settings->w,"w");
	setcheck_num(key,settings->h,"h");
	setcheck_num(key,settings->x,"x");
	setcheck_num(key,settings->y,"y");
	setcheck_num(key,settings->debugger_x,"debugger_x");
	setcheck_num(key,settings->debugger_y,"debugger_y");
	setcheck_num(key,settings->messages_x,"messages_x");
	setcheck_num(key,settings->messages_y,"messages_y");
	setcheck_num(key,settings->memory_x,"memory_x");
	setcheck_num(key,settings->memory_y,"memory_y");
	setcheck_num(key,settings->blitter,"blitter");
	setcheck_num(key,settings->framelimit,"framelimit");
	setcheck_num(key,settings->frameskip,"frameskip");
	setcheck_num(key,settings->maxrecentfiles,"maxrecentfiles");
	setcheck_str(key,settings->rompath,"rompath");
	setcheck_str(key,settings->miscpath,"miscpath");
	key.Close();
	emumessage("settings saved\n");
	}
else
	emumessage("error saving settings\n");
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCreemApp object

CCreemApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CCreemApp initialization

int isin(char *str,char c)
{
while(*str)
	{
	if(*str++ == c)
		return(1);
	}
return(0);
}

BOOL CCreemApp::InitInstance()
{
int i;
char *ptr = m_lpCmdLine;
char **b;

recent = 0;
argc = 0;
for(i=0;i<64;i++)
	argv[i] = 0;
argv[argc] = new char[_MAX_PATH];
GetModuleFileName(0,argv[argc],_MAX_PATH);
argc++;
if((ptr = strtok(m_lpCmdLine," ")) != 0)
	{
	for(;;)
		{
		argv[argc] = new char[strlen(ptr)+1];
		strcpy(argv[argc],ptr);
		argc++;
		if((ptr = strtok(0," ")) == 0)
			break;
		}
	}
strcpy(romfilename,"");
for(i=1;i<argc;i++)
	{
	if(strcmpi("-rom",argv[i]) == 0)
		{
		char tempfilename[512];

		i++;
		if(argv[i][0] == '"') //filename with spaces
			{
			sprintf(tempfilename,"%s ",&argv[i++][1]);
			while(isin(argv[i],'"') == 0)
				{
				strcat(tempfilename,argv[i++]);
				strcat(tempfilename," ");
				}
			strncat(tempfilename,argv[i],strlen(argv[i]) - 1);
			}
		else //filename without spaces
			strcpy(tempfilename,argv[i]);
		if(tempfilename[1] != ':')
			{
			char curdir[512],*poop;

			GetCurrentDirectory(512,curdir);
			GetFullPathName(tempfilename,512,romfilename,&poop);
			}
		else
			strcpy(romfilename,tempfilename);
		}
	else if(strcmpi("-bios",argv[i]) == 0)
		{
		i++;
		if(argv[i][0] == '"') //filename with spaces
			{
			sprintf(biosfilename,"%s ",&argv[i++][1]);
			while(isin(argv[i],'"') == 0)
				{
				strcat(biosfilename,argv[i++]);
				strcat(biosfilename," ");
				}
			strncat(biosfilename,argv[i],strlen(argv[i]) - 1);
			}
		else //filename without spaces
			strcpy(biosfilename,argv[i]);
		}
	else if(strcmpi("-nobios",argv[i]) == 0)
		settings->requirebios = 0;
	else if(strcmpi("-start",argv[i]) == 0)
		{
		char *p,*stop;
		int base = 10;

		i++;
		p = argv[i];
		if(*p == '$')
			{
			p++;
			base = 16;
			}
		else if((*p == '0' && (*(p+1) == 'x') || (*p == '0' && *(p+1) == 'X')))
			{
			p += 2;
			base = 16;
			}
		settings->startaddr = strtol(p,&stop,base);
		}
	else if(strcmpi("-autostart",argv[i]) == 0)
		{
		i++;
		if(stricmp(argv[i],"yes") == 0 || stricmp(argv[i],"on") == 0 || stricmp(argv[i],"1") == 0)
			settings->startwhenloaded = 1;
		else if(stricmp(argv[i],"no") == 0 || stricmp(argv[i],"off") == 0 || stricmp(argv[i],"0") == 0)
			settings->startwhenloaded = 0;
		else
			emumessage("bad autostart value: %s\n",argv[i]);
		}
	else if(strcmpi("-help",argv[i]) == 0 || strcmpi("-h",argv[i]) == 0 || strcmpi("-?",argv[i]) == 0)
		{
		MessageBox(0,
			"-rom filename = load filename as the rom\n"
			"-bios filename = load filename as the bios\n"
			"-nobios = dont require the bios to be loaded\n"
			"-start address = start execution at address\n"
			"-autostart yes/no = yes to start roms when loaded, no to not\n"
			,"usage",MB_OK);
		return(FALSE);
		}
	}
b = biosnames;
while(strcmp(*b,"") != 0)
	{
	if(fileexists(*b))
		{
		strcpy(biosfilename,*b);
		break;
		}
	*b++;
	}
if(strcmp(biosfilename,"") == 0)
	{
	if(settings->requirebios)
		{
		MessageBox(0,"no bios found, bios is required to run (you set this in settings, try \"creem -nobios\" to run)","error",MB_OK);
		return(FALSE);
		}
	else
		{
		emumessage("no bios found, continuing because its not required to run (see settings)\n");
		bios = new u8[0x4000];
		}
	}
else if(loadbios(biosfilename))
	{
	if(settings->requirebios)
		{
		MessageBox(0,"error loading bios file","error",MB_OK);
		return(FALSE);
		}
	else
		{
		emumessage("bios not loaded, continuing because its not required to run (see settings)\n");
		bios = new u8[0x4000];
		}
	}
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Dead_Body"));

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	pFrame->m_bAutoMenuEnable = 0; //DONT FUCK WITH MY MENU SHIT MFC

	recent = new CRecentFileList(0,"recent","file%d",settings->maxrecentfiles,200);
	loadrecentfiles();

	// create and load the frame with its resources
	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);

	if(settings->x < 65535 && settings->y < 65535)
		pFrame->SetWindowPos(0,settings->x,settings->y,0,0,SWP_NOZORDER | SWP_NOSIZE);
	pFrame->resizeclient(settings->w,settings->h);
	pFrame->SetIcon(LoadIcon(IDR_MAINFRAME),TRUE);

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();
	killemu();
	if(strcmp(romfilename,"") != 0)
		{
		if(initemu(romfilename) == 0)
			reset();
		}
	return TRUE;
}

void CCreemApp::addrecentfile(char *fn)
{
if(recent)
	recent->Add(fn);
}

void CCreemApp::loadrecentfiles()
{
if(recent)
	recent->ReadList();
}

void CCreemApp::saverecentfiles()
{
if(recent)
	recent->WriteList();
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_versionstring;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_versionstring = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_VERSIONSTRING, m_versionstring);
	//}}AFX_DATA_MAP
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
m_versionstring.Format("creem v%s\n",VERSION);//, built on %s at %s\n",VERSION,__DATE__,__TIME__);
UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CCreemApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CCreemApp message handlers


void CCreemApp::OnViewTiming() 
{
	// TODO: Add your command handler code here
CTiming timingdlg;

timingdlg.set_data(gba_timing);
timingdlg.DoModal();
}

void CCreemApp::OnViewDebugger()
{
	// TODO: Add your command handler code here
if(debuggerdlg == 0)
	{
	u32 x,y;

	x = settings->debugger_x;
	y = settings->debugger_y;
	stopemulation();
	debuggerdlg = new CDebugger;
	debuggerdlg->setregs(context);
	debuggerdlg->Create(IDD_DEBUGGER,debuggerdlg->GetDesktopWindow());
	if(x < 65535 && y < 65535)
		debuggerdlg->SetWindowPos(0,x,y,0,0,SWP_NOZORDER | SWP_NOSIZE);
	debuggerdlg->ShowWindow(SW_SHOW);
	debuggerdlg->reset(); //just sets the address to see
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_DEBUGGER,MF_CHECKED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_GRAYED);
	}
else
	{
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_DEBUGGER,MF_UNCHECKED);
	delete debuggerdlg;
	debuggerdlg = 0;
	if(stopped)
		{
		m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_ENABLED);
		m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_GRAYED);
		}
	else
		{
		m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_GRAYED);
		m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_ENABLED);
		}
	}
}

void CCreemApp::calctiming()
{
gba_timing->total_scanlines = (u8)GBA_TOTAL_SCANLINES(gba_timing);
gba_timing->total_dots = (u8)GBA_TOTAL_DOTS(gba_timing);
gba_timing->scanline_cycles = (u32)GBA_SCANLINE_CYCLES(gba_timing);
gba_timing->screen_cycles = (u32)GBA_SCREEN_CYCLES(gba_timing);
gba_timing->hblank_cycles = (u32)GBA_HBLANK_CYCLES(gba_timing);
}

void CCreemApp::reset()
{
averagefps = 60;
frames = 0;
frameskipcounter = 0;
renderer = renderers[0];
memset(regs,0,0x400);
SETREG16(DISPCNT,0x0080);
SETREG16(SG_BIAS,0x0200);
arm7tdmi_setcontext(context);
arm7tdmi_hardreset();
cycles = 0;
arm7tdmi_getcontext(context);
context->regs[15] = settings->startaddr;
arm7tdmi_setcontext(context);
arm7tdmi_fillpipe();
if(debuggerdlg)
	debuggerdlg->reset();
needscreenshot = 0;
}

int CCreemApp::initemu(char *gbaromfilename)
{
char newtitle[512];
char filename[512];
char newfn[512];
char *fnptr;
u32 i;

killemu();
pal16 = new u16[512];
pal32 = new u32[512];
ewram = new u8[0x40000];
iwram = new u8[0x8000];
pram = new u8[0x400];
vram = new u8[0x18000];
oam = new u8[0x400];
memset(ewram,0,0x40000);
memset(iwram,0,0x8000);
memset(pram,0,0x400);
memset(vram,0,0x18000);
memset(oam,0,0x400);
if((bpp = m_blitter->init(m_pMainWnd->GetSafeHwnd())) == 0)
	{
	MessageBox(0,"error initialzing blitter","error",MB_OK|MB_ICONERROR);
	return(1);
	}
switch(bpp)
	{
	case 16:
		renderers = renderers_16;
		palwrite16 = palwrite16_16;
		palwrite32 = palwrite32_16;
		color0 = pal16;
		break;
	case 17:
		renderers = renderers_17;
		palwrite16 = palwrite16_17;
		palwrite32 = palwrite32_17;
		color0 = pal17;
		break;
	case 32:
		renderers = renderers_32;
		palwrite16 = palwrite16_32;
		palwrite32 = palwrite32_32;
		color0 = pal32;
		break;
	}
if(loadrom(gbaromfilename) != 0)
	{
	m_blitter->kill();
	MessageBox(0,"error loading rom","error",MB_OK|MB_ICONERROR);
	return(1);
	}
strcpy(romfilename,gbaromfilename);
if(settings->startwhenloaded)
	OnEmulationStart();
else
	OnEmulationStop();
m_pMainWnd->GetMenu()->EnableMenuItem(ID_FILE_CLOSE,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_FILE_SCREENSHOT,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_RESET,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_DEBUGGER,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_MEMORY,MF_ENABLED);
m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_ROMINFO,MF_ENABLED);
strcpy(filename,romfilename);
for(i=0;i<strlen(filename);i++)
	{
	if(filename[i] == '/')
		filename[i] = '\\';
	}
sprintf(newtitle,"creem - %s",strrchr(filename,'\\') + 1);
GetFullPathName(filename,512,newfn,&fnptr);
addrecentfile(strlwr(newfn));
return(0);
}

#define DELETEVAR(v)if(v){delete v;v=0;}
#define DELETEARRAY(v)if(v){delete[] v;v=0;}
void CCreemApp::killemu(int updatemenus)
{
m_blitter->kill();
DELETEARRAY(pal16);
DELETEARRAY(pal17);
DELETEARRAY(pal32);
DELETEARRAY(ewram);
DELETEARRAY(iwram);
DELETEARRAY(pram);
DELETEARRAY(vram);
DELETEARRAY(oam);
DELETEARRAY(rom);
if(updatemenus)
	{
	if(debuggerdlg)
		OnViewDebugger();
	if(memorydlg)
		OnViewMemory();
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_FILE_CLOSE,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_FILE_SCREENSHOT,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_START,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_STOP,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_EMULATION_RESET,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_DEBUGGER,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_MEMORY,MF_GRAYED);
	m_pMainWnd->GetMenu()->EnableMenuItem(ID_VIEW_ROMINFO,MF_GRAYED);
	m_pMainWnd->SetWindowText("creem");
	}
else
	{
	if(debuggerdlg)
		{
		delete debuggerdlg;
		debuggerdlg = 0;
		}
	if(memorydlg)
		{
		delete memorydlg;
		memorydlg = 0;
		}
	}
romsize = 0;
screen = 0;
}

void memset_16(u16 *dest,u16 v,u32 size)
{
u32 i;

for(i=0;i<size;i++)
	*dest++ = v;
}

void memset_32(u32 *dest,u32 v,u32 size)
{
u32 i;

for(i=0;i<size;i++)
	*dest++ = v;
}

void CCreemApp::frame()
{
u32 scanlinecycles;

if(frameskipcounter == 0) //only if frame needs to be emulated
	{
	if((screen = m_blitter->framestart()) == 0)
		{
		stopemulation();
		return;
		}
	if((regs[DISPCNT] & 7) <= 2)
		{
		if(bpp & 16)
			memset_16((u16*)screen,*(u16*)color0,240*160);
		else if(bpp & 32)
			memset_32((u32*)screen,*(u32*)color0,240*160);
		}
	else
		memset(screen,0,240*160*((bpp >> 4) * 2));
	}
for(;;)
	{
	scanlinecycles = arm7tdmi_execute(gba_timing->scanline_cycles);
	if(scanlinecycles & 0xf0000000)
		{
		m_blitter->framestop();
		stopemulation();
		switch(scanlinecycles & 0xf0000000)
			{
			case E_BADCOND:MessageBox(0,"bad condition","arm7tdmi error",MB_OK);break;
			case E_BADOP:MessageBox(0,"bad opcode","arm7tdmi error",MB_OK);break;
			case E_COP:MessageBox(0,"coprocessor opcodes not emulated","arm7tdmi error",MB_OK);break;
			default:MessageBox(0,"unknown error","arm7tdmi error",MB_OK);break;
			}
		break;
		}
	if(frameskipcounter == 0)
		{
		if(scanline < gba_timing->screen_scanlines)
			renderer();
		}
	if((regs[DM0CNT_H] & 0xb000) == 0xa000)dma0(); //hblank dmas
	if((regs[DM1CNT_H] & 0xb000) == 0xa000)dma1();
	if((regs[DM2CNT_H] & 0xb000) == 0xa000)dma2();
	if((regs[DM3CNT_H] & 0xb000) == 0xa000)dma3();
	if(regs[IE] & 0x0002 && regs[DISPSTAT] & 0x0010) //hblank irq
		{
		GETREG16(IF) |= 0x0002;
		arm7tdmi_irq();
		}
	scanline++;
	if(scanline == (u8)(GETREG16(DISPSTAT) >> 8)) //vcount match
		{
		GETREG16(DISPSTAT) |= 4;
		if(GETREG16(IE) & 0x0004 && GETREG16(DISPSTAT) & 0x0020) //vblank irq
			{
			GETREG16(IF) |= 0x0004;
			arm7tdmi_irq();
			}
		}
	else
		GETREG16(DISPSTAT) &= ~4;
	if(scanline == 160)
		{
		GETREG16(DISPSTAT) |= 1; //set vblank bit
		if((GETREG16(DM0CNT_H) & 0xb000) == 0x9000)dma0(); //vblank dmas
		if((GETREG16(DM1CNT_H) & 0xb000) == 0x9000)dma1();
		if((GETREG16(DM2CNT_H) & 0xb000) == 0x9000)dma2();
		if((GETREG16(DM3CNT_H) & 0xb000) == 0x9000)dma3();
		if(GETREG16(IE) & 0x0001 && GETREG16(DISPSTAT) & 0x0008) //vblank irq
			{
			GETREG16(IF) |= 0x0001;
			arm7tdmi_irq();
			}
		}
	else if(scanline >= 228) //scanline 228 = scanline 0, end of frame
		{
		char newtitle[128];
		__int64 t;

		if(frameskipcounter == 0)
			{
			if(needscreenshot)
				{
				u16 *d = new u16[240*160];
				u16 *dptr = d;
				u16 *screen16 = (u16*)screen;
				u32 *screen32 = (u32*)screen;
				int i;

				switch(bpp)
					{
					case 16:
						memcpy(d,screen,240*160*2);
						break;
					case 17:
						for(i=0;i<(240*160);i++)
							{
							u16 p = *screen16++;

							*dptr++ = (u16)(((p & 0xf800) >> 1) | ((p & 0x07e0) >> 1) | (p & 0x001f));
							}
						break;
					case 32:
						for(i=0;i<(240*160);i++)
							{
							u32 p = *screen32++;

							*dptr++ = (u16)(((p & 0xf8) << 7) | ((p & 0xf800) >> 6) | ((p & 0xf80000) >> 19));
							}
						break;
					}
				screenshot(d);
				needscreenshot = 0;
				delete[] d;
				}
			m_blitter->framestop();
			frameskipcounter = (u8)(settings->frameskip + 1);
			}
		scanline = 0;
		GETREG16(DISPSTAT) &= ~1; //clear vblank bit
		if(settings->framelimit)
			{
			for(;;)
				{
				QueryPerformanceCounter(&c);
				if((c.QuadPart - last) >= frametime)
					break;
				}
			}
		QueryPerformanceCounter(&c);
		if((frames & 0xf) == 0)
			{
			t = c.QuadPart - last;
			fps = (float)freq.QuadPart / t;
			averagefps = (averagefps + fps) / 2;
			if(t)
				sprintf(newtitle,"creem - %5.1f fps",averagefps);
			m_pMainWnd->SetWindowText(newtitle);
			}
		last = c.QuadPart;
		frames++;
		break;
		}
	}
frameskipcounter--;
}

void CCreemApp::screenshot(u16 *data)
{
char filename[512];
int shotnum = 0;
FILE *screenshotfile;
BITMAPFILEHEADER *bmfh;
BITMAPINFOHEADER *bmih;
BYTE aBitmapBits[240*160*3];
int i,j;

for(;;)
	{
	sprintf(filename,"%sshot%04d.bmp",settings->miscpath,shotnum);
	if((screenshotfile = fopen(filename,"rb")) == 0) //dont exist
		break;
	fclose(screenshotfile);
	shotnum++;
	if(shotnum > 9999)
		{
		MessageBox(0,"already 9999 screenshots, delete some","error",MB_OK);
		return;
		}
	}
if((screenshotfile = fopen(filename,"wb")) == 0)
	{
	char e[512 + 32];

	sprintf(e,"cant create screenshot file %s\n",filename);
	MessageBox(0,e,"error",MB_OK);
	return;
	}
bmfh = new BITMAPFILEHEADER;
bmih = new BITMAPINFOHEADER;
bmfh->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
bmfh->bfReserved1 = 0;
bmfh->bfReserved2 = 0;
bmfh->bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + (240 * 160 * 3);
bmfh->bfType = 19778;
bmih->biBitCount = 24;
bmih->biClrImportant = 0;
bmih->biClrUsed = 0;
bmih->biCompression = BI_RGB;
bmih->biHeight = 160;
bmih->biPlanes = 1;
bmih->biSize = sizeof(BITMAPINFOHEADER);
bmih->biSizeImage = 0;
bmih->biWidth = 240;
bmih->biXPelsPerMeter = 0;
bmih->biYPelsPerMeter = 0;
fseek(screenshotfile,0,SEEK_SET);
fwrite(bmfh,sizeof(BITMAPFILEHEADER),1,screenshotfile);
fwrite(bmih,sizeof(BITMAPINFOHEADER),1,screenshotfile);
for(i=0;i<160;i++)
	{
	u16 *sline = (data + (240 * 160)) - (240 * (i + 1));
	u8 *bline = aBitmapBits + (((i * 240) * 3) - (240 * 3));

	for(j=0;j<256;j++)
		{
		u16 p = *sline++;

		*bline++ = (u8)(((p & 0x7c00) >> 10) << 3);
		*bline++ = (u8)(((p & 0x03e0) >>  5) << 3);
		*bline++ = (u8)(((p & 0x001f) >>  0) << 3);
		}
	}
fwrite(aBitmapBits,240*160,3,screenshotfile);
delete bmfh;
delete bmih;
fclose(screenshotfile);
emumessage("screenshot saved to %s\n",filename);
}
extern "C" void arm7tdmi_printopcodeusage(FILE*);
BOOL CCreemApp::OnIdle(LONG /*lCount*/) 
{
	// TODO: Add your specialized code here and/or call the base class
if(GetAsyncKeyState('Q') < 0)
	{
	FILE *f = fopen("oplog.txt","wt");

	arm7tdmi_printopcodeusage(f);
	fclose(f);
	}
if(romsize)
	{
	if(debuggerdlg) //let debugger control whats going on
		debuggerdlg->update();
	else if(stopped == 0) //debugger not open, so just do a frame
		frame();
	}
	return TRUE;//CWinApp::OnIdle(lCount);
}

void CCreemApp::OnFileOpen() 
{
	// TODO: Add your command handler code here
char fn[_MAX_PATH] = "";
OPENFILENAME dlgdata;

strcpy(fn,romfilename);
dlgdata.lStructSize = sizeof(OPENFILENAME);
dlgdata.hwndOwner = m_pMainWnd->GetSafeHwnd();
dlgdata.hInstance = 0;
dlgdata.lpstrFilter = "gba roms (*.gba;*.agb;*.bin)\0*.gba;*.agb;*.bin\0elf format roms (*.elf)\0*.elf\0";
dlgdata.lpstrCustomFilter = 0;
dlgdata.nMaxCustFilter = 0;
dlgdata.nFilterIndex = 0;
dlgdata.lpstrFile = fn;
dlgdata.nMaxFile = _MAX_PATH;
dlgdata.lpstrFileTitle = 0;
dlgdata.nMaxFileTitle = 0;
dlgdata.lpstrInitialDir = settings->rompath;
dlgdata.lpstrTitle = "open rom";
dlgdata.Flags = OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;
dlgdata.nFileOffset = 0;
dlgdata.nFileExtension = 0;
dlgdata.lpstrDefExt = 0;
dlgdata.lCustData = 0;
dlgdata.lpfnHook = 0;
dlgdata.lpTemplateName = 0;
if(GetOpenFileName(&dlgdata))
	{
	killemu();
	if(initemu(fn) == 0)
		reset();
	}
}

void CCreemApp::OnFileClose() 
{
	// TODO: Add your command handler code here
killemu();
}

void CCreemApp::OnEmulationReset() 
{
	// TODO: Add your command handler code here
	if(romsize)
		reset();
}

void CCreemApp::OnViewWindowsize1x() 
{
	// TODO: Add your command handler code here
	((CMainFrame*)m_pMainWnd)->resizeclient(240,160);
}

void CCreemApp::OnViewWindowsize2x() 
{
	// TODO: Add your command handler code here
	((CMainFrame*)m_pMainWnd)->resizeclient(240*2,160*2);
}

void CCreemApp::OnViewWindowsize3x() 
{
	// TODO: Add your command handler code here
	((CMainFrame*)m_pMainWnd)->resizeclient(240*3,160*3);
}

void CCreemApp::OnViewWindowsize4x() 
{
	// TODO: Add your command handler code here
	((CMainFrame*)m_pMainWnd)->resizeclient(240*4,160*4);
}

void CCreemApp::OnEmulationStart() 
{
	// TODO: Add your command handler code here
startemulation();
}

void CCreemApp::OnEmulationStop() 
{
	// TODO: Add your command handler code here
stopemulation();
}

void CCreemApp::OnFileSavesettings() 
{
	// TODO: Add your command handler code here
RECT r;

m_pMainWnd->GetClientRect(&r);
settings->w = r.right;
settings->h = r.bottom;
m_pMainWnd->GetWindowRect(&r);
settings->x = r.left;
settings->y = r.top;
if(debuggerdlg)
	{
	debuggerdlg->GetWindowRect(&r);
	settings->debugger_x = r.left;
	settings->debugger_y = r.top;
	}
if(messagesdlg)
	{
	messagesdlg->GetWindowRect(&r);
	settings->messages_x = r.left;
	settings->messages_y = r.top;
	}
if(memorydlg)
	{
	memorydlg->GetWindowRect(&r);
	settings->memory_x = r.left;
	settings->memory_y = r.top;
	}
savesettings();
}

void CCreemApp::OnViewMessages() 
{
	// TODO: Add your command handler code here
if(messagesdlg == 0)
	{
	u32 x,y;

	x = settings->messages_x;
	y = settings->messages_y;
	messagesdlg = new CMessages;
	messagesdlg->Create(IDD_MESSAGES,messagesdlg->GetDesktopWindow());
	if(x < 65535 && y < 65535)
		messagesdlg->SetWindowPos(0,x,y,0,0,SWP_NOZORDER | SWP_NOSIZE);
	messagesdlg->setstringlist(&messages);
	messagesdlg->ShowWindow(SW_SHOW);
	messagesdlg->SetWindowPos(&messagesdlg->wndNoTopMost,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_MESSAGES,MF_CHECKED);
	}
else
	{
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_MESSAGES,MF_UNCHECKED);
	delete messagesdlg;
	messagesdlg = 0;
	}
}

void CCreemApp::OnViewSettings() 
{
	// TODO: Add your command handler code here
CSettings settingsdlg;

settingsdlg.set_data(settings);
settingsdlg.DoModal();
}

void CCreemApp::OnViewRominfo() 
{
	// TODO: Add your command handler code here
CRomInfo rominfo;

rominfo.set_data(rom,romfilename,romsize);
rominfo.DoModal();
}

int CCreemApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
int i;

saverecentfiles();
for(i=0;i<64;i++)
	{
	if(argv[i] != 0)
		delete[] argv[i];
	}
DELETEARRAY(bios);
	return CWinApp::ExitInstance();
}

void CCreemApp::OnFileScreenshot() 
{
	// TODO: Add your command handler code here
needscreenshot = 1;
}

void CCreemApp::OnViewMemory() 
{
	// TODO: Add your command handler code here
if(memorydlg == 0)
	{
	u32 x,y;

	x = settings->memory_x;
	y = settings->memory_y;
	stopemulation();
	memorydlg = new CMemory;
	memorydlg->setcpu(context);
	memorydlg->Create(IDD_MEMORY,memorydlg->GetDesktopWindow());
	if(x < 65535 && y < 65535)
		memorydlg->SetWindowPos(0,x,y,0,0,SWP_NOZORDER | SWP_NOSIZE);
	memorydlg->ShowWindow(SW_SHOW);
	memorydlg->SetWindowPos(&memorydlg->wndNoTopMost,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_MEMORY,MF_CHECKED);
	}
else
	{
	m_pMainWnd->GetMenu()->CheckMenuItem(ID_VIEW_MEMORY,MF_UNCHECKED);
	delete memorydlg;
	memorydlg = 0;
	}
}

void CCreemApp::OnUpdateFileRecentfiles(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
recent->UpdateMenu(pCmdUI);
}

BOOL CCreemApp::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
if(nCode == 0) //clicked
	{
	if((nID >= ID_FILE_RECENTFILES) && (nID < (UINT)(ID_FILE_RECENTFILES + settings->maxrecentfiles)))
		{
		CString s = (*recent)[nID - ID_FILE_RECENTFILES];

		killemu();
		if(initemu(s.GetBuffer(512)) == 0)
			reset();
		return(0);
		}
	}
	return CWinApp::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CCreemApp::OnFileReload() 
{
	// TODO: Add your command handler code here
killemu();
if(initemu(romfilename) == 0)
	reset();
}
