// creem.h : main header file for the CREEM application
//

#if !defined(AFX_CREEM_H__C79B6B44_4E1C_11D5_BCEA_00A0CCD69DE3__INCLUDED_)
#define AFX_CREEM_H__C79B6B44_4E1C_11D5_BCEA_00A0CCD69DE3__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols
#include "debugger.h"
#include "messages.h"
#include "blitter.h"
#include "memory.h"
#include "types.h"
/////////////////////////////////////////////////////////////////////////////
// CCreemApp:
// See creem.cpp for the implementation of this class
//

#define GETREG16(a)		(*(u16*)(&regs[a]))
#define SETREG16(a,v)	*(u16*)(&regs[a]) = v;
#define DISPCNT			0x000
#define DISPSTAT			0x004
#define BG0CNT				0x008
#define BG1CNT				0x00a
#define BG2CNT				0x00c
#define BG3CNT				0x00e
#define BG0HOFS			0x010
#define BG0VOFS			0x012
#define BG1HOFS			0x014
#define BG1VOFS			0x016
#define BG2HOFS			0x018
#define BG2VOFS			0x01a
#define BG3HOFS			0x01c
#define BG3VOFS			0x01e
#define SG_BIAS			0x088
#define DM0SAD_L			0x0b0
#define DM0SAD_H			0x0b2
#define DM0DAD_L			0x0b4
#define DM0DAD_H			0x0b6
#define DM0CNT_L			0x0b8
#define DM0CNT_H			0x0ba
#define DM1SAD_L			0x0bc
#define DM1SAD_H			0x0be
#define DM1DAD_L			0x0c0
#define DM1DAD_H			0x0c2
#define DM1CNT_L			0x0c4
#define DM1CNT_H			0x0c6
#define DM2SAD_L			0x0c8
#define DM2SAD_H			0x0ca
#define DM2DAD_L			0x0cc
#define DM2DAD_H			0x0ce
#define DM2CNT_L			0x0d0
#define DM2CNT_H			0x0d2
#define DM3SAD_L			0x0d4
#define DM3SAD_H			0x0d6
#define DM3DAD_L			0x0d8
#define DM3DAD_H			0x0da
#define DM3CNT_L			0x0dc
#define DM3CNT_H			0x0de
#define IE					0x200
#define IF					0x202
#define IME					0x208

#define fixpathstring(string) /* fix up the paths in the config file so they work */\
if(string[strlen(string) - 1] != '\\' && string[strlen(string) - 1] != '/')\
	{\
	int l = strlen(string);\
\
	string[l + 0] = '\\';\
	string[l + 1] = 0;\
	}\
while((string[strlen(string) - 1] == '\\' || string[strlen(string) - 1] == '/') && (string[strlen(string) - 2] == '\\' || string[strlen(string) - 2] == '/'))\
	string[strlen(string) - 1] = 0;
#define VERSION	"0.50 PRIVATE"

class CCreemApp : public CWinApp
{
private:
	int argc;
	char *argv[64];
	CDebugger *debuggerdlg;
	u64 last,frametime;
	LARGE_INTEGER freq,c;
	u32 frames;
	float fps,averagefps;
	void *color0;
	u8 needscreenshot;
	CRecentFileList *recent;
#ifdef CREEMPROFILE
	profile_t profile;
#endif
public:
	u8 frameskipcounter;
	int bpp;
	CMemory *memorydlg;
	blitter *m_blitter;
	void *screen;
	CMessages *messagesdlg;
	void addrecentfile(char *fn);
	void loadrecentfiles();
	void saverecentfiles();
	void loadsettings();
	void savesettings();
	void calctiming();
	void reset();
	int initemu(char *gbaromfilename);
	void killemu(int updatemenus = 1);
	void frame();
	void screenshot(u16 *data);
	void startemulation();
	void stopemulation();
	CCreemApp();
	~CCreemApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCreemApp)
	public:
	virtual BOOL InitInstance();
	virtual BOOL OnIdle(LONG lCount);
	virtual int ExitInstance();
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	//}}AFX_VIRTUAL

// Implementation

public:
	//{{AFX_MSG(CCreemApp)
	afx_msg void OnAppAbout();
	afx_msg void OnViewTiming();
	afx_msg void OnViewDebugger();
	afx_msg void OnFileOpen();
	afx_msg void OnFileClose();
	afx_msg void OnEmulationReset();
	afx_msg void OnViewWindowsize1x();
	afx_msg void OnViewWindowsize2x();
	afx_msg void OnViewWindowsize3x();
	afx_msg void OnViewWindowsize4x();
	afx_msg void OnEmulationStart();
	afx_msg void OnEmulationStop();
	afx_msg void OnViewMessages();
	afx_msg void OnViewSettings();
	afx_msg void OnViewRominfo();
	afx_msg void OnViewMemory();
	afx_msg void OnUpdateFileRecentfiles(CCmdUI* pCmdUI);
	afx_msg void OnFileSavesettings();
	afx_msg void OnFileScreenshot();
	afx_msg void OnFileReload();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

extern CCreemApp theApp;

void dma0();
void dma1();
void dma2();
void dma3();
u8 read8_registers(u32 addr);
void write8_registers(u32 addr,u8 value);
extern "C" void emumessage(char *,...);
extern void (*renderer)();
extern gba_timing_t *gba_timing;
extern settings_t *settings;
extern u8 scanline;
extern u32 rommask;
extern u8 regs[];
extern u8 *bios;
extern u8 *ewram;
extern u8 *iwram;
extern u8 *pram;
extern u8 *vram;
extern u8 *oam;
extern u8 *rom;
extern u16 *pal16;
extern u16 *pal17;
extern u32 *pal32;
/*extern u16 reg_DISPCNT;//000
extern u16 reg_DISPSTAT;//004
extern u16 reg_BG0CNT;//008
extern u16 reg_BG1CNT;//00a
extern u16 reg_BG2CNT;//00c
extern u16 reg_BG3CNT;//00e
extern u16 reg_BG0HOFS;//010
extern u16 reg_BG0VOFS;//012
extern u16 reg_BG1HOFS;//014
extern u16 reg_BG1VOFS;//016
extern u16 reg_BG2HOFS;//018
extern u16 reg_BG2VOFS;//01a
extern u16 reg_BG3HOFS;//01c
extern u16 reg_BG3VOFS;//01e
extern u16 reg_DM0SAD_L;//0b0
extern u16 reg_DM0SAD_H;//0b2
extern u16 reg_DM0DAD_L;//0b4
extern u16 reg_DM0DAD_H;//0b6
extern u16 reg_DM0CNT_L;//0b8
extern u16 reg_DM0CNT_H;//0ba
extern u16 reg_DM1SAD_L;//0bc
extern u16 reg_DM1SAD_H;//0be
extern u16 reg_DM1DAD_L;//0c0
extern u16 reg_DM1DAD_H;//0c2
extern u16 reg_DM1CNT_L;//0c4
extern u16 reg_DM1CNT_H;//0c6
extern u16 reg_DM2SAD_L;//0c8
extern u16 reg_DM2SAD_H;//0ca
extern u16 reg_DM2DAD_L;//0cc
extern u16 reg_DM2DAD_H;//0ce
extern u16 reg_DM2CNT_L;//0d0
extern u16 reg_DM2CNT_H;//0d2
extern u16 reg_DM3SAD_L;//0d4
extern u16 reg_DM3SAD_H;//0d6
extern u16 reg_DM3DAD_L;//0d8
extern u16 reg_DM3DAD_H;//0da
extern u16 reg_DM3CNT_L;//0dc
extern u16 reg_DM3CNT_H;//0de
extern u16 reg_IE;//208
extern u16 reg_IF;//208
extern u16 reg_IME;//208
extern u16 reg_SG_BIAS;*/
/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CREEM_H__C79B6B44_4E1C_11D5_BCEA_00A0CCD69DE3__INCLUDED_)
