#ifndef __TYPES_H__
#define __TYPES_H__
/*********************************************************************************************/
#define INLINE	__forceinline //change for your compiler
/*********************************************************************************************/
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;
typedef unsigned __int64 u64; //change this for your compiler
typedef signed char s8;
typedef signed short s16;
typedef signed long s32;
typedef signed __int64 s64; //change this for your compiler
typedef struct
	{
	u32 cpu_hz;
	u8 frequency;
	u8 screen_scanlines;
	u8 screen_dots;
	u8 blank_scanlines;
	u8 blank_dots;
	u8 total_scanlines;
	u8 total_dots;
	u32 scanline_cycles;
	u32 screen_cycles;
	u32 hblank_cycles;
	} gba_timing_t;
typedef struct
	{
	u8 startwhenloaded;
	u32 startaddr;
	u8 requirebios;
	u32 x,y;
	u32 w,h;
	u32 debugger_x;
	u32 debugger_y;
	u32 messages_x;
	u32 messages_y;
	u32 memory_x;
	u32 memory_y;
	u8 blitter;
	u8 framelimit;
	u8 frameskip;
	u8 maxrecentfiles;
	char rompath[512];
	char miscpath[512];
	} settings_t;
typedef struct profile_s
	{
	u64 frametime;
	u64 rendertime;
	u64 cputime;
	u64 cleartime;
	u64 idletime;
	u64 windowstime;
	} profile_t;
typedef struct
	{
	u8 Manufacturer;
	u8 Version;
	u8 Encoding;
	u8 BitsPerPixel;
	u16 Xmin;
	u16 Ymin;
	u16 Xmax;
	u16 Ymax;
	u16 HDpi;
	u16 VDpi;
	u8 Colormap[48];
	u8 Reserved;
	u8 NPlanes;
	u16 BytesPerLine;
	u16 PaletteInfo;
	u16 HscreenSize;
	u16 VscreenSize;
	u8 Filler[54];
	} PCXHEADER;
/*********************************************************************************************/
#endif