//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "search.h"
#include "gpfuncs.h"
//---------------------------------------------------------------------
#pragma resource "*.dfm"
Tsearchform *searchform;

struct T86HW
{
	long banksel0;
    long banksel1;
	unsigned char mainmem[393216];
    long port3word;
	long port3acc;
	long intrpt;
	long intrptm;
	long rowscan;
	long wierdmem0;
	long wierdmem1;
	long push1;
};
struct TWORKSPACE {
	long dumpaddr;
	long disaddr;
	long disinc;
	long disa[32];
	long brk;
	long breakaddr;
	long shutdwn;
	long keyhold;
	long waitstates;
	long keyholdmax;
	long runmode;
	long backcolor;
	long backcolor2;
	long backcolor1;
	long backcolor0;
	long forecolor;
	long forecolor2;
	long forecolor1;
	long forecolor0;
	long runonstartup;
	long scrnsize;
	long scrnrows;
    long keymode;

    long dumpsetaddrmode;
    long numformat;
    long alwaysontop;
    long usejoystick;

    long avail[1019];
};

long getz80mem(T86HW* hw86, long j);

//---------------------------------------------------------------------
__fastcall Tsearchform::Tsearchform(TComponent* AOwner)
	: TForm(AOwner)
{
}
//---------------------------------------------------------------------
void __fastcall Tsearchform::closebuttonClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall Tsearchform::searchnowbuttonClick(TObject *Sender)
{
    char tempbuf[256];
    long startaddr,endaddr,searchtype;
	T86HW* hw861 = (T86HW*)hw86;
    TWORKSPACE* wks1 = (TWORKSPACE*)wks;
    TAnswer ans;
    long i,j,ct,numfound;


	numfound = 0;
	resultsmemo->Clear();

    strcpy(tempbuf, startaddrbox->Text.c_str() );
    startaddr = extract(tempbuf, wks1->numformat, &ans);
    strcpy(tempbuf, endaddrbox->Text.c_str() );
    endaddr = extract(tempbuf, wks1->numformat, &ans);
	strcpy(tempbuf, searchforbox->Text.c_str() );
	i = extract(tempbuf, wks1->numformat, &ans);

	if (ans.count <= 0) return;
	if (z80spacebutton->Checked)
    {
		for (j=startaddr; j<endaddr-ans.count; ++j)
        {
            ct = 0;
			for (i=0; i<ans.count; ++i)
            {
                if (getz80mem(hw861, j+i) == ans.vals[i])
                	++ct;
            }
            if (ct == ans.count)
            {
            	sprintf(tempbuf, "$%04x", j);
                resultsmemo->Lines->Add(tempbuf);
                ++numfound;
            }
        }
    }
    else
    {
	    for (j=startaddr; j<endaddr-ans.count; ++j)
	    {
            ct = 0;
			for(i=0; i<ans.count; ++i)
            {
            	if (hw861->mainmem[j+i] == ans.vals[i])
                	++ct;
            }
            if (ct == ans.count)
            {
            	sprintf(tempbuf, "$%06x", j);
                resultsmemo->Lines->Add(tempbuf);
                ++numfound;
            }
	    }
    }
    if (numfound == 0)
    	resultsmemo->Lines->Add("Not found");
}
//---------------------------------------------------------------------------

long getz80mem(T86HW* hw86, long j)
{
	long i;
			if (j >= 0xc000)
		    	i = hw86->mainmem[((j-0xc000)&0x0000ffff)+262144];
		    else if (j >= 0x8000)
		    {
				if (hw86->wierdmem1)
                	i = 0x0a;
                else
					i = hw86->mainmem[((j-0x8000)&0x0000ffff)+((hw86->banksel1)<<14)];
		    }
		    else if (j >= 0x4000)
		    {
				if (hw86->wierdmem0)
                	i = 0x0a;
                else
		    		i = hw86->mainmem[((j-0x4000)&0x0000ffff)+((hw86->banksel0)<<14)];
		    }
		    else
		    	i = hw86->mainmem[j&0x0000ffff];
            return(i);
}
void __fastcall Tsearchform::FormKeyPress(TObject *Sender, char &Key)
{
	if (Key == 27)
    {
        Key = 0;
    	Close();
    }
	
}
//---------------------------------------------------------------------------
