// TI86EMU MAIN FORM:
// 
// Emulator core and disassembler are in here also.
// 
// COPYRIGHT 1998 STEVE GORDON
//

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <fcntl.h>
#include <io.h>
#include <sys\stat.h>
#include "inbx.h"
#include "dualinbx.h"
#include "about.h"
#include "options.h"
#include "search.h"
#include "gpfuncs.h"
#include "vkey.h"
#include "keytab.h"
#include "ti86frm.h"

#pragma hdrstop

//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma resource "*.dfm"

#include "Z80.h"
Tmaincalc *maincalc;

void rasterize(void);
TAnswer ans;

// TI86 machine minus the microprocessor
struct T86HW
{
	long banksel0;
    long banksel1;
	unsigned char mainmem[393216];
    long port3word;
	long port3acc;
	long machtype;
	long port6word; // used for 85
	long rowscan;
	long wierdmem0;
	long wierdmem1;
	long colscan;
};
T86HW* hw86 = new(T86HW);

void setcustomcolors(void);
void setscreensize(void);
void defworkspace(void);
long disline(long addr, char* line);
void wipemem(void);
long hwinit(void);
//void createz80tophysaddrtab();
void checkwks(void);

long dummy = 0;
char tempbuf[256];
long numdislines = 17;
char filebf[32768];
long macro[256];
long macroptr=-1;
long macroctr=16;
long macroalt = 0;
long loadfiletype;
long loadphase = -1;
long loadctr;
void load0(void);
void load1(void);
void load2(void);

struct TWORKSPACE {
	long dumpaddr;
	long disaddr;
	long disinc;
	long disa[32];
	long brk;
	long breakaddr;
	long shutdwn;
	long keyhold;
	long waitstates;
	long keyholdmax;
	long runmode;
	long backcolor;
	long backcolor0;
    long unused1;
    long unused2;
	long forecolor;
	long forecolor0;
    long unused3;
    long unused4;
	long runonstartup;
	long scrnsize;
	long scrnrows;
    long keymode;
    long dumpsetaddrmode;
    long numformat;
    long alwaysontop;
    long usejoystick;
	long drawctrmax;
    long trapaddr;
    long trap;
    long enabletrap;
    long avail[1016];
};
TWORKSPACE wks;

// disassembler declarations
void getp(long addr, char* tempbuf, long p);
void getcc(char* tempbuf, long cc);
void getreg8(char* tempbuf, long reg);
void getreg16(char* tempbuf, long reg);

// emulator vars
static Z80_Regs R;
int Z80_Running=1;
int Z80_IPeriod=1;
int Z80_ICount=1;

// ssssadd

int Z80_IRQ=Z80_IGNORE_INT;

int Z80_ExecuteDebug (void);

// for writing when ROM writing allowed

void Z80_WRMEM2(dword A,byte V);


// bitmap graphics stuff

BITMAPINFOHEADER bmih;

int RowSize = ((((256 + 1) * 3) / 4) * 4);

BYTE *Bits = new BYTE[RowSize * 128];

unsigned long* longBits = (unsigned long*)Bits;

HBITMAP hbmp;

RGBQUAD rgb0 = {0,0,0,0};
BITMAPINFO bmi;

// graphics lookup tables
long longbitsdatatab[256][6];
long longbitsaddrtab[1024];
long longbigbitsdatatab[256][12];
long longbigbitsaddrtab[1024];

// z80->physical address table
//long z80tophysaddrtab[65536];

long shiftdown = 0;
long intrpt;
long intrptm;
long modifierc;
long modifier8;
long graphmem;
long drawctr;


//---------------------------------------------------------------------------
__fastcall Tmaincalc::Tmaincalc(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::FormClose(TObject *Sender, TCloseAction &Action)
{
    wks.brk = 1;
    wks.shutdwn = 1;
    Application->ProcessMessages();

	delete[] Bits;
	delete hw86;
}
//---------------------------------------------------------------------------

void Tmaincalc::printregs(void)
{
    sprintf(tempbuf, "%04x", R.AF.W.l);
    strupr(tempbuf);
	afregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.BC.W.l);
    strupr(tempbuf);
	bcregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.DE.W.l);
    strupr(tempbuf);
	deregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.HL.W.l);
    strupr(tempbuf);
	hlregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.IX.W.l);
    strupr(tempbuf);
	ixregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.IY.W.l);
    strupr(tempbuf);
	iyregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.PC.W.l);
    strupr(tempbuf);
	pcregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.SP.W.l);
    strupr(tempbuf);
	spregbox->Text = tempbuf;

    sprintf(tempbuf, "%04x", R.AF2.W.l);
    strupr(tempbuf);
	afpregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.BC2.W.l);
    strupr(tempbuf);
	bcpregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.DE2.W.l);
    strupr(tempbuf);
	depregbox->Text = tempbuf;
    sprintf(tempbuf, "%04x", R.HL2.W.l);
    strupr(tempbuf);
	hlpregbox->Text = tempbuf;


    sprintf(tempbuf, "%02x", R.AF.B.h);
    strupr(tempbuf);
	aregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.AF.B.l);
    strupr(tempbuf);
	fregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.BC.B.h);
    strupr(tempbuf);
	bregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.BC.B.l);
    strupr(tempbuf);
	cregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.DE.B.h);
    strupr(tempbuf);
	dregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.DE.B.l);
    strupr(tempbuf);
	eregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.HL.B.h);
    strupr(tempbuf);
	hregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.HL.B.l);
    strupr(tempbuf);
	lregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.I);
    strupr(tempbuf);
	iregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.R);
    strupr(tempbuf);
	rregbox->Text = tempbuf;
    sprintf(tempbuf, "%02x", R.IM);
    //sprintf(tempbuf, "%02x", hw86->rowscan);
    strupr(tempbuf);
	imregbox->Text = tempbuf;

    if (R.AF.B.l&0x80) s7box->Color = clYellow; else s7box->Color = clBtnFace;
	if (R.AF.B.l&0x40) s6box->Color = clYellow; else s6box->Color = clBtnFace;
    if (R.AF.B.l&0x20) s5box->Color = clYellow; else s5box->Color = clBtnFace;
    if (R.AF.B.l&0x10) s4box->Color = clYellow; else s4box->Color = clBtnFace;
    //if (R.AF.B.l&0x08) s3box->Color = clYellow; else s3box->Color = clBtnFace;
	if (R.IFF1) s3box->Color = clYellow; else s3box->Color = clBtnFace;
    if (R.AF.B.l&0x04) s2box->Color = clYellow; else s2box->Color = clBtnFace;
    if (R.AF.B.l&0x02) s1box->Color = clYellow; else s1box->Color = clBtnFace;
    if (R.AF.B.l&0x01) s0box->Color = clYellow; else s0box->Color = clBtnFace;
}

void Tmaincalc::printdump(void)
{
	long i,j,k,l;
    long mem[8];
    long asc[8];
    char s[16];

	if (wks.dumpsetaddrmode == 0)
    {
		l = memdumplist->ItemIndex;
	    j=wks.dumpaddr;
	    for (i=0; i<8; ++i)
	    {
	        for (k=0; k<8; ++k)
	        {
	            if (Z80_RDMEM(j+k) != 0)
	            	asc[k] = Z80_RDMEM(j+k);
	            else
	            	asc[k] = '.';
	           	mem[k] = Z80_RDMEM(j+k);
			}
			sprintf(s, "%04x", j);
	        strupr(s);
	        sprintf(tempbuf,
	         "%s : %02x %02x %02x %02x %02x %02x %02x %02x : %c%c%c%c%c%c%c%c",
			 s,
	         mem[0],mem[1],mem[2],mem[3],mem[4],mem[5],mem[6],mem[7],
	         asc[0],asc[1],asc[2],asc[3],asc[4],asc[5],asc[6],asc[7] );
	    	j+=8;
	        //strupr(tempbuf);
	        memdumplist->Items->Strings[i] = tempbuf;
        }
    }
    else
    {
		l = memdumplist->ItemIndex;
	    j=wks.dumpaddr;
	    for (i=0; i<8; ++i)
	    {
	        for (k=0; k<8; ++k)
	        {
	            if (hw86->mainmem[j+k] != 0)
	            	asc[k] = hw86->mainmem[j+k];
	            else
	            	asc[k] = '.';
	           	mem[k] = hw86->mainmem[j+k];
			}
			sprintf(s, "%06x", j);
	        strupr(s);
	        sprintf(tempbuf,
	         "%s : %02x %02x %02x %02x %02x %02x %02x %02x : %c%c%c%c%c%c%c%c",
			 s,
	         mem[0],mem[1],mem[2],mem[3],mem[4],mem[5],mem[6],mem[7],
	         asc[0],asc[1],asc[2],asc[3],asc[4],asc[5],asc[6],asc[7] );
	    	j+=8;
	        //strupr(tempbuf);
	        memdumplist->Items->Strings[i] = tempbuf;
        }
    }
  	memdumplist->ItemIndex = l;
}

void Tmaincalc::printstk(void)
{
	long j,k;
    long mem[8];
    long asc[8];

    j=R.SP.W.l;

    for (k=0; k<8; ++k)
    {
    	if (Z80_RDMEM(j+k) != 0)
        	asc[k] = Z80_RDMEM(j+k);
        else
        	asc[k] = '.';
        mem[k] = Z80_RDMEM(j+k);
    }
    sprintf(tempbuf,
	 "%04x : %02x %02x %02x %02x %02x %02x %02x %02x : %c%c%c%c%c%c%c%c",
     j,
     mem[0],mem[1],mem[2],mem[3],mem[4],mem[5],mem[6],mem[7],
     asc[0],asc[1],asc[2],asc[3],asc[4],asc[5],asc[6],asc[7] );

    strupr(tempbuf);
    stackdumplist->Items->Strings[0] = tempbuf;
}

void Tmaincalc::printdis(void)
{
	long i,j,f,o;

    j=wks.disaddr;
    f=0;
    for (i=0; i<17; ++i)
    {
        wks.disa[i] = j;
    	o = disline(j, tempbuf);
        if (j == wks.breakaddr)
        	tempbuf[0] = '*';

        j=(j+o)&0x0000ffff;
		if (f == 0) wks.disinc = o;
        dislist->Items->Strings[i] = tempbuf;
        f=1;
    }
}

void __fastcall Tmaincalc::exitbuttonClick(TObject *Sender)
{
    wks.brk = 1;
    Application->ProcessMessages();
	Application->Terminate();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::FormCreate(TObject *Sender)
{
	TRect rect1;
	long handle;

	firstactiv = 1;

    // load the rom
	if ((handle = open("TI86.ROM", O_BINARY)) == -1)
   	{
		if ((handle = open("TI85.ROM", O_BINARY)) == -1)
        	hw86->machtype = -1;
        else
        	hw86->machtype = 1;
  	}
	else
    {
    	hw86->machtype = 0;
    }
	if (hw86->machtype >= 0)
	{
	    read(handle, hw86->mainmem, 262144);
	    close(handle);
    }
    else
    {
		MessageBox(0,"Could not open TI86.ROM or TI85.ROM", "Error",0);
    }
    getmachine();

    // load the workspace
    if ((handle = open("DEFAULT.WKS", O_BINARY)) == -1)
    {
        defworkspace();
    	//MessageBox(0,"Could not open DEFAULT.WKS, defaults set", "Error",0);
    }
    else
    {
   		read(handle, &wks, 4308);
   		close(handle);
    }
	checkwks();

	if (wks.runonstartup)
    {
	    if (wks.scrnsize == 1)
	    {
		    maincalc->ClientWidth = 280;
		    maincalc->ClientHeight = 155;
	    }
	    else
	    {
	       	maincalc->ClientWidth = 152;
	    	maincalc->ClientHeight = 93;
	    }
    }
    else
    {
	    maincalc->ClientWidth = 706;
	    maincalc->ClientHeight = 475;
	}

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::FormActivate(TObject *Sender)
{
	long handle;

	if (firstactiv == 1)
    {
    	firstactiv = 0;
		if (wks.dumpsetaddrmode == 0)
        	ScrollBar1->Max = 8184;
        else
        	ScrollBar1->Max = 24572;

	    if (wks.scrnsize == 1)
			setbitmapheader(256, 128);
	    else
	    	setbitmapheader(128, 64);

		wks.dumpaddr=0;

		if ((handle = open("DEFAULT.STA", O_BINARY)) == -1)
	   	{
    		hwinit();
			Z80_Reset();
		    wipemem();
	   	}
	    else
	    {
	    	read(handle, &R, sizeof(R));
	    	read(handle, hw86, sizeof(*hw86));
	        close(handle);
            getmachine();
	    }
        hw86->colscan = 0xff;
    	hw86->rowscan = 0xffff;
        //createz80tophysaddrtab();

		printregs();
	    printdump();
	    printstk();
	    printdis();
	    dislist->ItemIndex = 0;
		setscreensize();
	    rasterize();
	    drawscr();
        if (wks.runonstartup)
            Timer1->Enabled = true;
    }
    else
   		dummyedit->SetFocus();

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::ScrollBar1Change(TObject *Sender)
{
	if (wks.dumpsetaddrmode == 0)
		wks.dumpaddr=(ScrollBar1->Position)<<3;
    else
        wks.dumpaddr=(ScrollBar1->Position)<<4;
    printdump();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
	static int lastpos;
    int delta;

    delta = UpDown1->Position-lastpos;

	if (delta == -1 || (delta > 1) )
	{
		wks.disaddr=(wks.disaddr+wks.disinc)&0x0000ffff;
	    printdis();
    }
  	else
    {
		wks.disaddr=(wks.disaddr-1)&0x0000ffff;
        printdis();
    }
    lastpos = UpDown1->Position;

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::disatbuttonClick(TObject *Sender)
{
    long i;

	sprintf(tempbuf, "$%04x", wks.disaddr);
    strupr(tempbuf);
    inputbox->answer1->Text = tempbuf;
    inputbox->prompt->Caption = "Enter the address to start disassembly";
	inputbox->ShowModal();
    if (inputbox->cancel == 0)
	{
	    strcpy(tempbuf, inputbox->answer1->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    wks.disaddr = i;
	    printdis();
    }
  	dummyedit->SetFocus();    
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::aregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, aregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
        R.AF.B.h = i;
		printregs();
	    printstk();
    }
}

void __fastcall Tmaincalc::fregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, fregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
        R.AF.B.l = i;
		printregs();
	    printstk();
    }
}


//---------------------------------------------------------------------------
void __fastcall Tmaincalc::cregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, cregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.BC.B.l = i;
		printregs();
	    printstk();
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::eregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, eregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.DE.B.l = i;
		printregs();
	    printstk();
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::lregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, lregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.HL.B.l = i;
		printregs();
	    printstk();
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::iregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, iregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.I = i;
		printregs();
	    printstk();
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::rregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, rregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.R = i;
		printregs();
	    printstk();
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::imregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, imregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
        R.IM = i;
		printregs();
	    printstk();
    }
}

void __fastcall Tmaincalc::bregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, bregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.BC.B.h = i;
		printregs();
	    printstk();
    }
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::hregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, hregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.HL.B.h = i;
		printregs();
	    printstk();
    }
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::dregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, dregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.DE.B.h = i;
		printregs();
	    printstk();
    }
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::afregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, afregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.AF.W.l = i;
		printregs();
	    printstk();
    }
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::bcregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, bcregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.BC.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::deregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, deregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.DE.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::hlregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, hlregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.HL.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::ixregboxKeyPress(TObject *Sender, char &Key)
{
 	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, ixregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		R.IX.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::iyregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, iyregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.IY.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::pcregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, pcregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.PC.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::spregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, spregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.SP.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::afpregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, afpregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.AF2.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::bcpregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, bcpregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.BC2.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::depregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, depregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.DE2.W.l = i;
		printregs();
	    printstk();
    }

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::hlpregboxKeyPress(TObject *Sender, char &Key)
{
	int i;
	if (Key == 0x0d)
    {
	    strcpy(tempbuf, hlpregbox->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    R.HL2.W.l = i;
		printregs();
	    printstk();
    }
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::aregboxExit(TObject *Sender)
{
		printregs();
	    printstk();

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::setmembuttonClick(TObject *Sender)
{
	setmem();
  	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::outportbuttonClick(TObject *Sender)
{
    long i,j;

    dualinbox->answer1->Text = "";
	dualinbox->answer2->Text = "";
    dualinbox->prompt1->Caption = "Enter outport";
	dualinbox->prompt2->Caption = "Enter the value to set";
	dualinbox->ShowModal();

    if (inputbox->cancel == 0)
	{
	    strcpy(tempbuf, dualinbox->answer1->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans)&0x0000ffff;
	    strcpy(tempbuf, dualinbox->answer2->Text.c_str() );
		j = extract(tempbuf, wks.numformat, &ans);

		Z80_Out(i, j);
	    printdump();
        printstk();
        printdis();
    }
  	dummyedit->SetFocus();
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::stepbuttonClick(TObject *Sender)
{
    int i,j,found;

	wks.runmode = 4;
	Z80_IPeriod=1;
	Z80_ICount=1;

    intrptm = 1000;
    intrpt = 1000;


	Z80_Execute();

	drawscr();

    printregs();
    //printdis();

    found = 0;
    for (i=0; i<17; ++i)
    {
    	if (wks.disa[i] == R.PC.W.l)
        {
        	found = 1;
            j = i;
        }
    }

    if (found)
    {
    	dislist->ItemIndex = j;
    }
    else
	{
    	wks.disaddr = R.PC.W.l;
        printdis();
        dislist->ItemIndex = 0;
    }

    printdump();
    printstk();
  	dummyedit->SetFocus();    

}
//---------------------------------------------------------------------------

void __fastcall Tmaincalc::rundebugbuttonClick(TObject *Sender)
{
    int i = 1;
    int j;
    int f = 1;

	dummyedit->SetFocus();
	wks.runmode = 1;
	Z80_IPeriod=100000;
	Z80_ICount=100000;		//10000;

    intrptm = 1;

    intrpt = 1;

    dislist->ItemIndex = -1;


    runbutton->Enabled = false;
    rundebugbutton->Enabled = false;
    animatebutton->Enabled = false;
    stepbutton->Enabled = false;
	wks.brk = 0;
    wks.trap = 0;
    while (wks.brk == 0 && wks.trap == 0)
    {
		Z80_ExecuteDebug();
		if (macroptr == -1 && loadphase == -1)
        {
        	if (--drawctr == 0)
		    {
				drawscr();
		        drawctr = wks.drawctrmax;
		    }
        }
        //drawscr();
        f = 0;
        if (loadphase == 0 && macroptr == -1)
        {
            // macro to "type in" and execute a dummy ASM program
        	load0();
            loadphase = 1;
            loadctr = 100;
        }
        else if (loadphase == 1 && macroptr == -1)
        {
            if (--loadctr == 0)
			{
				// modify the dummy ASM program to create the desired variable,
	            // then make macro to re-run the modified dummy program
	        	load1();
	            loadphase = 2;
	            loadctr = 100;
            }
        }
        else if (loadphase == 2 && macroptr == -1)
        {
            if (--loadctr == 0)
            {
	            // variable is now created, so load the data from filebf into it.
				load2();
	            loadphase = -1;
	            loadctr = 100;
            }
        }
        if (macroptr > -1)
        {
            if (--macroctr == 0)
            {
                if (macroalt == 0)
                {
        			hw86->rowscan = ~macro[macroptr--];
                    macroalt = 1;
                }
                else
                {
        			hw86->rowscan = 0xffff;
                    macroalt = 0;
                }
                macroctr = 16;
            }
        }
    }
ex0:
    if (wks.shutdwn) return;
	printregs();
    printdump();
    printstk();
    wks.brk = 1;


    j=-1;
    for (i=0; i<17; ++i)
    {
        if (wks.disa[i] == R.PC.W.l)
            j = i;
    }
    if (j != -1)
    	dislist->ItemIndex = j;
    else
    {
    	wks.disaddr = R.PC.W.l;
        printdis();
        dislist->ItemIndex = 0;
    }
    runbutton->Enabled = true;
    rundebugbutton->Enabled = true;
    animatebutton->Enabled = true;
    stepbutton->Enabled = true;

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::breakbuttonClick(TObject *Sender)
{
    runbutton->Enabled = true;
    rundebugbutton->Enabled = true;
    animatebutton->Enabled = true;
    stepbutton->Enabled = true;
	wks.brk = 1;
  	dummyedit->SetFocus();
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::animatebuttonClick(TObject *Sender)
{
    int i,j,found;
    int frst;

  	dummyedit->SetFocus();
    runbutton->Enabled = false;
    rundebugbutton->Enabled = false;
    animatebutton->Enabled = false;
    stepbutton->Enabled = false;
    frst = 1;
	Z80_IPeriod=1; //50000;
	Z80_ICount=1; //50000;

    intrptm = 1000;
    intrpt = 1000;


	wks.runmode = 2;
    wks.brk = 0;
    wks.trap = 0;
	while (wks.brk == 0 && wks.trap == 0)
    {
		if (R.PC.W.l == wks.breakaddr && frst == 0)
        {
        	wks.brk = 1;
            goto endanimate;
        }
		Z80_ExecuteDebug();
        drawscr();
	    printregs();
	    //printdis();

	    found = 0;
	    for (i=0; i<17; ++i)
	    {
	    	if (wks.disa[i] == R.PC.W.l)
	        {
	        	found = 1;
	            j = i;
	        }
	    }
	    if (found)
	    {
	    	dislist->ItemIndex = j;
	    }
	    else
		{
	    	wks.disaddr = R.PC.W.l;
	        printdis();
	        dislist->ItemIndex = 0;
	    }

	    printdump();
	    printstk();
        Application->ProcessMessages();
        frst = 0;
    }
    wks.brk = 1;
endanimate:
    runbutton->Enabled = true;
    rundebugbutton->Enabled = true;
    animatebutton->Enabled = true;
    stepbutton->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::dislistDblClick(TObject *Sender)
{
	int i;

    i = dislist->ItemIndex;
	if (wks.breakaddr != wks.disa[dislist->ItemIndex])
    	wks.breakaddr = wks.disa[dislist->ItemIndex];
    else
    	wks.breakaddr = -1;

    printdis();
    dislist->ItemIndex = i;
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::searchbuttonClick(TObject *Sender)
{
	searchform->hw86 = (void*)hw86;
	searchform->wks = (void*)&wks;
	searchform->Show();
  	//dummyedit->SetFocus();

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::runbuttonClick(TObject *Sender)
{
    int i = 1;
    int j;
    int f = 1;

	dummyedit->SetFocus();
    wks.runmode = 0;
	GroupBox5->Enabled = false;
    GroupBox2->Enabled = false;
    FormStyle = fsStayOnTop;
    if (wks.scrnsize == 1)
    {
	    maincalc->ClientWidth = 280;
	    maincalc->ClientHeight = 155;
    }
    else
    {
       	maincalc->ClientWidth = 152;
    	maincalc->ClientHeight = 93;
    }
	Z80_IPeriod=100000;
	Z80_ICount=100000;		//10000;

    intrptm = 1;

    intrpt = 1;

    dislist->ItemIndex = -1;


	wks.brk = 0;
    while (wks.brk == 0)
    {
        if (wks.waitstates == 0)
			Z80_Execute();
        else
        	Z80_ExecuteDebug();

	    if (--drawctr == 0 && wks.brk ==0 && wks.shutdwn == 0)
	    {
			drawscr();
	        drawctr = wks.drawctrmax;
	    }
    }
    if (wks.shutdwn) return;
	printregs();
    printdump();
    printstk();
    j=-1;
    for (i=0; i<17; ++i)
    {
        if (wks.disa[i] == R.PC.W.l)
            j = i;
    }
    if (j != -1)
    	dislist->ItemIndex = j;
    else
    {
    	wks.disaddr = R.PC.W.l;
        printdis();
        dislist->ItemIndex = 0;
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::debugbuttonClick(TObject *Sender)
{
   	//maincalc->ClientWidth = 576;
    //maincalc->ClientHeight = 471;
    FormStyle = fsNormal;
   	maincalc->ClientWidth = 706;
    maincalc->ClientHeight = 475;
	GroupBox5->Enabled = true;
    GroupBox2->Enabled = true;
    wks.brk = 1;
	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall Tmaincalc::inportbuttonClick(TObject *Sender)
{
	long i,j;

	sprintf(tempbuf, "", wks.disaddr);
    inputbox->answer1->Text = tempbuf;
    inputbox->prompt->Caption = "Enter port address";
	inputbox->ShowModal();
    if (inputbox->cancel == 0)
	{
	    strcpy(tempbuf, inputbox->answer1->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
		j = Z80_In(i);
        sprintf(tempbuf, "$%02x", j);
		MessageBox(0,tempbuf, "Inport",0);

    }
   	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::loadbuttonClick(TObject *Sender)
{
	int handle;
    long i,j,k,f,o;
    char filename[256];
    char* binfile = NULL;

    i = opendialog->Execute();
    if (i == 0)
    {
       	dummyedit->SetFocus();
    	return;
    }
    strcpy(filename, opendialog->FileName.c_str());
	if ((handle = open(filename, O_BINARY | O_RDONLY)) == -1)
   	{
    	MessageBox(0,"Could not open file", "Error",0);
       	dummyedit->SetFocus();
      	return;
   	}

    strcpy(filename, opendialog->FileName.c_str());
    strupr(filename);
    if (strstr(filename, ".STA") != NULL)
    {
	    read(handle, &R, sizeof(R));
	    read(handle, hw86, sizeof(*hw86));

		//createz80tophysaddrtab();
        getmachine();
        rasterize();
		drawscr();
        printdis();
        printdump();
        printregs();
        printstk();
    }
    else if (strstr(filename, ".86P") != NULL)
	{
		read(handle, filebf, 32768);
	    close(handle);
		if (wks.runmode == 1 && wks.brk == 0)
        {
	        loadphase = 0;
	        loadfiletype = 0x12;
        }
        else
        {
        	MessageBox(0,"In order to load an .86p file, go to debug mode and click 'RUN'", "Error",0);
        }
/*
    	j = 268104;
	    for (i=75; i<9000; ++i)
	    {
	        f=filebf[i];
	        hw86->mainmem[j] = f;
	        ++j;
	    }
        //R.PC.W.l = 0xd748;
*/

    }
    else if (strstr(filename, ".BIN") != NULL)
    {
		// load binary memory
		sprintf(tempbuf, "$%05x", 0);
	    strupr(tempbuf);
	    dualinbox->answer1->Text = tempbuf;
		sprintf(tempbuf, "$%05x", 0);
	    strupr(tempbuf);
		dualinbox->answer2->Text = tempbuf;
	    dualinbox->prompt1->Caption = "Enter the VIRTUAL start address";
		dualinbox->prompt2->Caption = "Enter the length";
		dualinbox->ShowModal();
	    if (inputbox->cancel == 0)
		{
		    strcpy(tempbuf, dualinbox->answer1->Text.c_str() );
		    i = extract(tempbuf, wks.numformat, &ans);
		    strcpy(tempbuf, dualinbox->answer2->Text.c_str() );
			j = extract(tempbuf, wks.numformat, &ans);
            binfile = new char[j];
			read(handle, binfile, j);
         	close(handle);
            for (k=i; k<(i+j); ++k)
            	hw86->mainmem[k] = binfile[k-i];
			delete binfile;
	    }
        // rasterize just in case load included video memory
        rasterize();
		drawscr();
    }
    else if (strstr(filename, ".WKS") != NULL)
    {
    	// load the workspace
   		read(handle, &wks, 4308);
   		close(handle);

		if (wks.dumpsetaddrmode == 0)
        	ScrollBar1->Max = 8184;
        else
        	ScrollBar1->Max = 24572;

/*
		if (wks.alwaysontop)
        	FormStyle = fsStayOnTop;
        else
        	FormStyle = fsNormal;
*/

        checkwks();
		setscreensize();
        printdis();
        printregs();
        printdump();
        printstk();
        rasterize();
        drawscr();
    }
	else if (strstr(filename, ".86S") != NULL)
    {
		read(handle, filebf, 32768);
	    close(handle);

		if (wks.runmode == 1 && wks.brk == 0)
        {
	        loadphase = 0;
	        loadfiletype = 0x0c;
        }
        else
        {
        	MessageBox(0,"In order to load an .86s file, go to debug mode and click 'RUN'", "Error",0);
        }
    }
	else if (strstr(filename, ".85S") != NULL)
    {
		read(handle, filebf, 32768);
	    close(handle);

		if (wks.runmode == 1 && wks.brk == 0)
        {
	        loadphase = 0;
	        loadfiletype = 0x8c;
        }
        else
        {
        	MessageBox(0,"In order to load an .85s file, go to debug mode and click 'RUN'", "Error",0);
        }
    }
	else if (strstr(filename, ".86I") != NULL)
    {
		read(handle, filebf, 32768);
	    close(handle);

		if (wks.runmode == 1 && wks.brk == 0)
        {
	        loadphase = 0;
	        loadfiletype = 0x11;
        }
        else
        {
        	MessageBox(0,"In order to load an .86I file, go to debug mode and click 'RUN'", "Error",0);
        }
    }
    else
    	MessageBox(0,"Unrecognized file type", "Error",0);
	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::resetbuttonClick(TObject *Sender)
{
    runbutton->Enabled = true;
    rundebugbutton->Enabled = true;
    animatebutton->Enabled = true;
    stepbutton->Enabled = true;

	wks.brk = 1;
  	dummyedit->SetFocus();
	wks.dumpaddr=0;
    ScrollBar1->Position = wks.dumpaddr;


/*
	long handle;
    // load the rom
	if ((handle = open("TI86.ROM", O_BINARY)) == -1)
   	{
		if ((handle = open("TI85.ROM", O_BINARY)) == -1)
        	hw86->machtype = -1;
        else
        	hw86->machtype = 1;
  	}
	else
    {
    	hw86->machtype = 0;
    }
	if (hw86->machtype >= 0)
	{
	    read(handle, hw86->mainmem, 262144);
	    close(handle);
    }
    else
    {
		MessageBox(0,"Could not open TI86.ROM or TI85.ROM", "Error",0);
    }
*/    

	drawctr = wks.drawctrmax;
    hwinit();
    wipemem();
	Z80_Reset();
    setscreensize();
    getmachine();

	printregs();
    printdump();
    printstk();
    printdis();
    dislist->ItemIndex = 0;

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::savebuttonClick(TObject *Sender)
{
	int i,j,k,handle;
    char filename[256];
    char* binfile = NULL;

    dummyedit->SetFocus();
    i = savedialog->Execute();
    if (i == 0)
    {
       	dummyedit->SetFocus();
    	return;
    }

    strcpy(filename, savedialog->FileName.c_str());
    strupr(filename);
	if (strstr(filename, ".STA") != NULL)
    {

		if ((handle = open(savedialog->FileName.c_str(), O_CREAT|O_TRUNC|O_BINARY|O_RDWR, S_IREAD|S_IWRITE	)) == -1)
	   	{
	    	MessageBox(0,"Could not open .STA file", "Error",0);
          	dummyedit->SetFocus();
	      	return;
	   	}
	   	write(handle, &R, sizeof(R));
        write(handle, hw86, sizeof(*hw86));
	   	close(handle);
    }
    else if (strstr(filename, ".BIN") != NULL)
    {
    	// save binary memory
		sprintf(tempbuf, "$%05x", 0);
	    strupr(tempbuf);
	    dualinbox->answer1->Text = tempbuf;
		sprintf(tempbuf, "$%05x", 0);
	    strupr(tempbuf);
		dualinbox->answer2->Text = tempbuf;
	    dualinbox->prompt1->Caption = "Enter the VIRTUAL start address";
		dualinbox->prompt2->Caption = "Enter the length";
		dualinbox->ShowModal();
	    if (inputbox->cancel == 0)
		{
		    strcpy(tempbuf, dualinbox->answer1->Text.c_str() );
		    i = extract(tempbuf, wks.numformat, &ans);
		    strcpy(tempbuf, dualinbox->answer2->Text.c_str() );
			j = extract(tempbuf, wks.numformat, &ans);
            binfile = new char[j];
            for (k=i; k<(i+j); ++k)	binfile[k-i] = hw86->mainmem[k];
			if ((handle = open(savedialog->FileName.c_str(), O_CREAT|O_TRUNC|O_BINARY|O_RDWR, S_IREAD|S_IWRITE	)) == -1)
		   	{
		    	MessageBox(0,"Could not open .BIN file", "Error",0);
               	dummyedit->SetFocus();
		      	return;
		   	}
			write(handle, binfile, j);
         	close(handle);
			delete[] binfile;
	    }
    }
	else if (strstr(filename, ".WKS") != NULL)
    {
    	if ((handle = open(savedialog->FileName.c_str(), O_CREAT|O_TRUNC|O_BINARY|O_RDWR, S_IREAD|S_IWRITE	)) == -1)
        {
        	MessageBox(0,"Could not open .WKS file", "Error",0);
           	dummyedit->SetFocus();
            return;
        }
        write(handle, &wks, 4308);
        close(handle);
    }
    else
		MessageBox(0,"Unrecognized file type", "Error",0);
   	dummyedit->SetFocus();
}

void rasterize(void)
{
	int i,j,physaddr,row,col,base,offs;
    int V;

    for (physaddr=graphmem; physaddr<graphmem+0x400; ++physaddr)
 	{
    	row = (physaddr-graphmem)>>4;
        col = ((physaddr-graphmem)&0x0000000f)<<3;
        base = 8064-(row<<7);
        offs = base+col;
        V = hw86->mainmem[physaddr];
        j = 128;
        if (wks.scrnsize == 0)
        {
            i = longbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbitsdatatab[V][0];
	        longBits[i+1]=longbitsdatatab[V][1];
	        longBits[i+2]=longbitsdatatab[V][2];
	        longBits[i+3]=longbitsdatatab[V][3];
	        longBits[i+4]=longbitsdatatab[V][4];
	        longBits[i+5]=longbitsdatatab[V][5];
        }
        else
        {
            i = longbigbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];

			i += 192;
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall Tmaincalc::helpbuttonClick(TObject *Sender)
{
	AboutBox->ShowModal();
  	dummyedit->SetFocus();    
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::Button1Click(TObject *Sender)
{
    char lbuf[32];
	TRect rect1;
    long l;

	setcustomcolors();
    sprintf(lbuf, "%d", wks.waitstates);

	if (wks.numformat == 0)
    	optionsform->decimalbox->Checked = true;
    else
    	optionsform->hexbox->Checked = true;
    if (wks.dumpsetaddrmode == 0)
    	optionsform->z80addrbox->Checked = true;
    else
    	optionsform->virtualaddrbox->Checked = true;
    if (wks.enabletrap == 1)
    	optionsform->alwaysontopbox->Checked = true;
    else
    	optionsform->alwaysontopbox->Checked = false;
    if (wks.drawctrmax == 2)
    	optionsform->usejoystickbox->Checked = true;
    else
    	optionsform->usejoystickbox->Checked = false;

	if (wks.keymode == 0)
    	optionsform->realkeymodebox->Checked = true;
    else
    	optionsform->fastkeymodebox->Checked = true;
    if (wks.runonstartup == 1)
    	optionsform->startrunbutton->Checked = true;
    else
    	optionsform->startrunbutton->Checked = false;
    optionsform->wsbox->Text = lbuf;
    optionsform->forecolorval = wks.forecolor;
    optionsform->backcolorval = wks.backcolor;
    if (wks.scrnsize == 0)
    	optionsform->largescrnbutton->Checked = false;
    else
    	optionsform->largescrnbutton->Checked = true;

	optionsform->ShowModal();
    if (optionsform->cancel == 0)
    {

    	if (optionsform->decimalbox->Checked)
           	wks.numformat = 0;
        else
           	wks.numformat = 1;
		if (optionsform->z80addrbox->Checked)
	    	wks.dumpsetaddrmode = 0;
        else
	    	wks.dumpsetaddrmode = 1;
		if (optionsform->alwaysontopbox->Checked)
        	wks.enabletrap = 1;
        else
        	wks.enabletrap = 0;
		if (optionsform->usejoystickbox->Checked)
        	wks.drawctrmax = 2;
        else
	   		wks.drawctrmax = 1;

		if (optionsform->realkeymodebox->Checked)
        	wks.keymode = 0;
        else
        	wks.keymode = 1;

/*
		if (wks.alwaysontop)
        	FormStyle = fsStayOnTop;
        else
        	FormStyle = fsNormal;
*/

		if (wks.dumpsetaddrmode == 0)
        	ScrollBar1->Max = 8184;
        else
        	ScrollBar1->Max = 24572;

        hw86->rowscan = 0xffff;
    	wks.waitstates = atoi(optionsform->wsbox->Text.c_str());
        if (optionsform->largescrnbutton->Checked)
        	wks.scrnsize = 1;
        else
        	wks.scrnsize = 0;
        if (optionsform->startrunbutton->Checked)
        	wks.runonstartup = 1;
        else
        	wks.runonstartup = 0;
    	wks.forecolor = optionsform->forecolorval;
    	wks.backcolor = optionsform->backcolorval;

		setscreensize();
        printdump();
        rasterize();
        drawscr();
    }
	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall Tmaincalc::setbitmapheader(long w, long h)
{
	bmih.biSize = sizeof(BITMAPINFOHEADER);
    bmih.biWidth = w;
    bmih.biHeight = h;
    bmih.biPlanes = 1;
    bmih.biBitCount = 24;
    bmih.biCompression = BI_RGB;
    bmih.biSizeImage = 0;
    bmih.biXPelsPerMeter = 0;
    bmih.biYPelsPerMeter = 0;
    bmih.biClrUsed = 0;
    bmih.biClrImportant = 0;

	bmi.bmiHeader = bmih;
	bmi.bmiColors[0] = rgb0;    // no palette
}

void __fastcall Tmaincalc::drawscr(void)
{
	TRect dstrect, srcrect;
    HDC hdc;
    long i, j, val;
    long lbase,bbase;
    long lcbase, bcbase;

	if (wks.scrnsize == 0)
    {
   		bmih.biWidth = 128;
    	bmih.biHeight = 64;
       	bmi.bmiHeader = bmih;

	    hbmp = scrn->Picture->Bitmap->Handle;
		hdc = scrn->Canvas->Handle;
	    SetDIBits (
	     hdc,
	     hbmp,
	     0,
	     64,
	     Bits,
	     &bmi,
	     DIB_RGB_COLORS
	    );
        Application->ProcessMessages();
    	scrn->Refresh();
    }
    else
    {
    	bmih.biWidth = 256;
    	bmih.biHeight = 128;
       	bmi.bmiHeader = bmih;
        hbmp = scrnbig->Picture->Bitmap->Handle;
		hdc = scrnbig->Canvas->Handle;
	    SetDIBits (
	     hdc,
	     hbmp,
	     0,
	     128,
	     Bits,
	     &bmi,
	     DIB_RGB_COLORS
	    );
        Application->ProcessMessages();
        scrnbig->Refresh();
	}
}

void __fastcall Tmaincalc::dummyeditKeyPress(TObject *Sender, char &Key)
{
	Key = 0;
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::dumpatbuttonClick(TObject *Sender)
{
    long i;

	sprintf(tempbuf, "$%04x", wks.dumpaddr);
    strupr(tempbuf);
    inputbox->answer1->Text = tempbuf;
    inputbox->prompt->Caption = "Enter the address to start memory dump";
	inputbox->ShowModal();
    if (inputbox->cancel == 0)
	{
	    strcpy(tempbuf, inputbox->answer1->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    wks.dumpaddr = i;
	    printdump();
    }
    if (wks.dumpsetaddrmode == 0)
    	ScrollBar1->Position = i >> 3;
    else
    	ScrollBar1->Position = i >> 4;

  	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------

void defworkspace(void)
{
	wks.dumpaddr= 0;
	wks.disaddr = 0;
	wks.disinc = 0;
	//wks.disa[32];
	wks.brk = 0;
	wks.breakaddr = -1;
	wks.shutdwn = 0;
	wks.keyhold = 0;
	wks.waitstates = 0;
	wks.keyholdmax = 5;
	wks.runmode = 0;
	wks.backcolor = 0x0087afaf;
	wks.backcolor0= 0x00afaf87;
	wks.forecolor = 0x00570e0e;
	wks.forecolor0= 0x000e0e57;
	wks.runonstartup=0;
	wks.scrnsize = 1;
	wks.scrnrows = 128;
    wks.keymode = 0;
    wks.dumpsetaddrmode = 0;
    wks.numformat = 0;
    wks.alwaysontop = 0;
    wks.usejoystick = 0;
    wks.drawctrmax = 2;
}

void __fastcall Tmaincalc::setscreensize(void)
{
	unsigned long i,j,k,l,m,n,even;
    unsigned long fgc, bgc;
    //ttttttt
    l = wks.forecolor;
    wks.forecolor0 = l;
    wks.forecolor0 = ( (wks.forecolor0 & 0x00ffff00) | (l>>16) );
    wks.forecolor0 = ( (wks.forecolor0 & 0x0000ffff) | (l<<16) );
    wks.forecolor0 &= 0x00ffffff;

    l = wks.backcolor;
    wks.backcolor0 = l;
    wks.backcolor0 = ( (wks.backcolor0 & 0x00ffff00) | (l>>16) );
    wks.backcolor0 = ( (wks.backcolor0 & 0x0000ffff) | (l<<16) );
    wks.backcolor0 &= 0x00ffffff;

    fgc = wks.forecolor0;
    bgc = wks.backcolor0;
        if (wks.scrnsize == 1)
        {
        	// construct address and data lookup tables
            // address table
            k = 1008;
            n = 24192;
            m = 0;
            for (i=0; i<64; ++i)
            {
             	for(j=0; j<16; ++j)
                {
            		longbigbitsaddrtab[m++] = n;
                    ++k;
                    n=n+12;
                }
                k -= 32;
                n -= 576;
            }

            // data table
            for (i=0; i<256; ++i)
            {
            	even = 0;
            	for (j=0; j<8; ++j)
                {
                	if(i & (1<<(7-j)))
                    {
                    	// fg color
                        if(j == 0)
                        {
                            k = fgc;
                            k = (fgc<<24)|k;
                            longbigbitsdatatab[i][0] = k;
                            k = fgc >> 8;
                        }
                        else if (j == 1)
                        {
                        	k = (fgc<<16)|k;
                            longbigbitsdatatab[i][1] = k;
                            k = (fgc>>16);
                            k = (fgc<<8)|k;
                            longbigbitsdatatab[i][2] = k;
                        }
                        else if (j == 2)
                        {
                            k = fgc;
                            k = (fgc<<24)|k;
                            longbigbitsdatatab[i][3] = k;
                            k = fgc >> 8;
                        }
                        else if (j == 3)
                        {
                        	k = (fgc<<16)|k;
                            longbigbitsdatatab[i][4] = k;
                            k = (fgc>>16);
                            k = (fgc<<8)|k;
                            longbigbitsdatatab[i][5] = k;
                        }
                        else if (j == 4)
                        {
                            k = fgc;
                            k = (fgc<<24)|k;
                            longbigbitsdatatab[i][6] = k;
                            k = fgc >> 8;
                        }
                        else if (j == 5)
                        {
                        	k = (fgc<<16)|k;
                            longbigbitsdatatab[i][7] = k;
                            k = (fgc>>16);
                            k = (fgc<<8)|k;
                            longbigbitsdatatab[i][8] = k;
                        }
                        else if (j == 6)
                        {
                            k = fgc;
                            k = (fgc<<24)|k;
                            longbigbitsdatatab[i][9] = k;
                            k = fgc >> 8;
                        }
                        else if (j == 7)
                        {
                        	k = (fgc<<16)|k;
                            longbigbitsdatatab[i][10] = k;
                            k = (fgc>>16);
                            k = (fgc<<8)|k;
                            longbigbitsdatatab[i][11] = k;
                        }
                    }
                    else
                    {
                    	// bg color
                        if(j == 0)
                        {
                            k = bgc;
                            k = (bgc<<24)|k;
                            longbigbitsdatatab[i][0] = k;
                            k = bgc >> 8;
                        }
                        else if (j == 1)
                        {
                        	k = (bgc<<16)|k;
                            longbigbitsdatatab[i][1] = k;
                            k = (bgc>>16);
                            k = (bgc<<8)|k;
                            longbigbitsdatatab[i][2] = k;
                        }
                        else if (j == 2)
                        {
                            k = bgc;
                            k = (bgc<<24)|k;
                            longbigbitsdatatab[i][3] = k;
                            k = bgc >> 8;
                        }
                        else if (j == 3)
                        {
                        	k = (bgc<<16)|k;
                            longbigbitsdatatab[i][4] = k;
                            k = (bgc>>16);
                            k = (bgc<<8)|k;
                            longbigbitsdatatab[i][5] = k;
                        }
                        else if (j == 4)
                        {
                            k = bgc;
                            k = (bgc<<24)|k;
                            longbigbitsdatatab[i][6] = k;
                            k = bgc >> 8;
                        }
                        else if (j == 5)
                        {
                        	k = (bgc<<16)|k;
                            longbigbitsdatatab[i][7] = k;
                            k = (bgc>>16);
                            k = (bgc<<8)|k;
                            longbigbitsdatatab[i][8] = k;
                        }
                        else if (j == 6)
                        {
                            k = bgc;
                            k = (bgc<<24)|k;
                            longbigbitsdatatab[i][9] = k;
                            k = bgc >> 8;
                        }
                        else if (j == 7)
                        {
                        	k = (bgc<<16)|k;
                            longbigbitsdatatab[i][10] = k;
                            k = (bgc>>16);
                            k = (bgc<<8)|k;
                            longbigbitsdatatab[i][11] = k;
                        }
                    }
                }
            }

        	scrn->Visible = false;
            scrnbig->Visible = true;
        	background->Visible = false;
        	backgroundbig->Visible = true;

            setbitmapheader(256,128);
            wks.scrnrows = 128;
        	rasterize();
        	scrnbig->Canvas->Refresh();
        }
        else
        {
            // construct address and data lookup tables
            // address table
            k = 1008;
            m = 0;
            for (i=0; i<64; ++i)
            {
             	for(j=0; j<16; ++j)
                {
            		longbitsaddrtab[m++] = k*6;
                    ++k;
                }
                k -= 32;
            }

            // data table
            for (i=0; i<256; ++i)
            {
            	even = 0;
            	for (j=0; j<8; ++j)
                {
                	if(i & (1<<(7-j)))
                    {
                    	// fg color
                        if(j == 0)
                        {
                            k = fgc;
                        }
                        else if (j == 1)
                        {
                        	k = (fgc<<24)|k;
                            longbitsdatatab[i][0] = k;
                            k = (fgc>>8);
                        }
                        else if (j == 2)
                        {
                        	k = (fgc<<16)|k;
                            longbitsdatatab[i][1] = k;
                            k = (fgc>>16);
                        }
                        else if (j == 3)
                        {
                        	k = (fgc<<8)|k;
                            longbitsdatatab[i][2] = k;
                            k = 0;
                        }
                        else if (j == 4)
                        {
                            k = (fgc);
                        }
                        else if (j == 5)
                        {
                        	k = (fgc<<24)|k;
                            longbitsdatatab[i][3] = k;
                            k = (fgc>>8);
                        }
                        else if (j == 6)
                        {
                        	k = (fgc<<16)|k;
                            longbitsdatatab[i][4] = k;
                            k = (fgc>>16);
                        }
                        else if (j == 7)
                        {
                        	k = (fgc<<8)|k;
                            longbitsdatatab[i][5] = k;
                            k = 0;
                        }
                    }
                    else
                    {
                    	// bg color
                        if(j == 0)
                        {
                            k = bgc;
                        }
                        else if (j == 1)
                        {
                        	k = (bgc<<24)|k;
                            longbitsdatatab[i][0] = k;
                            k = (bgc>>8);
                        }
                        else if (j == 2)
                        {
                        	k = (bgc<<16)|k;
                            longbitsdatatab[i][1] = k;
                            k = (bgc>>16);
                        }
                        else if (j == 3)
                        {
                        	k = (bgc<<8)|k;
                            longbitsdatatab[i][2] = k;
                            k = 0;
                        }
                        else if (j == 4)
                        {
                            k = (bgc);
                        }
                        else if (j == 5)
                        {
                        	k = (bgc<<24)|k;
                            longbitsdatatab[i][3] = k;
                            k = (bgc>>8);
                        }
                        else if (j == 6)
                        {
                        	k = (bgc<<16)|k;
                            longbitsdatatab[i][4] = k;
                            k = (bgc>>16);
                        }
                        else if (j == 7)
                        {
                        	k = (bgc<<8)|k;
                            longbitsdatatab[i][5] = k;
                            k = 0;
                        }
                    }
                }
            }
            scrnbig->Visible = false;
        	scrn->Visible = true;
        	background->Visible = true;
        	backgroundbig->Visible = false;
            setbitmapheader(128,64);
        	wks.scrnsize = 0;
            wks.scrnrows = 64;
        	rasterize();
        	scrn->Canvas->Refresh();
        }
}

void setcustomcolors(void)
{
    optionsform->colordialog->CustomColors->Clear();
    sprintf(tempbuf, "ColorA=%08x", wks.forecolor);
    optionsform->colordialog->CustomColors->Add(tempbuf);
    sprintf(tempbuf, "ColorB=%08x", wks.backcolor);
    optionsform->colordialog->CustomColors->Add(tempbuf);
}

void __fastcall Tmaincalc::setmem(void)
{
    long a,i,j,k;


	if (wks.dumpsetaddrmode == 0)
    {
        if (memdumplist->ItemIndex >= 0)
	    	a = wks.dumpaddr+((memdumplist->ItemIndex)<<3);
        else
        	a = wks.dumpaddr;

		sprintf(tempbuf, "$%04x", a);
	    strupr(tempbuf);
	    dualinbox->answer1->Text = tempbuf;
		sprintf(tempbuf, "$%02x", Z80_RDMEM(wks.dumpaddr));
	    strupr(tempbuf);
		dualinbox->answer2->Text = tempbuf;
	    dualinbox->prompt1->Caption = "Enter the memory address to set";
		dualinbox->prompt2->Caption = "Enter the value to set";
		dualinbox->ShowModal();

	    if (inputbox->cancel == 0)
		{
		    strcpy(tempbuf, dualinbox->answer1->Text.c_str() );
		    i = extract(tempbuf, wks.numformat, &ans)&0x0000ffff;
		    strcpy(tempbuf, dualinbox->answer2->Text.c_str() );
			j = extract(tempbuf, wks.numformat, &ans);

			for (k=0; k<ans.count; ++k)
				Z80_WRMEM2(i++, ans.vals[k]);
		    printdump();
	        printstk();
	        printdis();
	    }
    }
    else
    {
		if (memdumplist->ItemIndex >= 0)
        	a = wks.dumpaddr+((memdumplist->ItemIndex)<<3);
        else
        	a = wks.dumpaddr;

		sprintf(tempbuf, "$%06x", a);
	    strupr(tempbuf);
	    dualinbox->answer1->Text = tempbuf;
		sprintf(tempbuf, "$%02x", hw86->mainmem[wks.dumpaddr]);
	    strupr(tempbuf);
		dualinbox->answer2->Text = tempbuf;
	    dualinbox->prompt1->Caption = "Enter the memory address to set";
		dualinbox->prompt2->Caption = "Enter the value to set";
		dualinbox->ShowModal();

	    if (inputbox->cancel == 0)
		{
		    strcpy(tempbuf, dualinbox->answer1->Text.c_str() );
		    i = extract(tempbuf, wks.numformat, &ans)&0x000fffff;
		    strcpy(tempbuf, dualinbox->answer2->Text.c_str() );
			j = extract(tempbuf, wks.numformat, &ans);

			for (k=0; k<ans.count; ++k)
				hw86->mainmem[i++] =  ans.vals[k];
		    printdump();
	        printstk();
	        printdis();
	    }
    }

    rasterize();
	drawscr();
}
void __fastcall Tmaincalc::memdumplistKeyPress(TObject *Sender, char &Key)
{
	if (Key == 0x0d) setmem();
}
//---------------------------------------------------------------------------

void load0(void)
{
	macro[50] = keytab[220];	// clear
	macro[49] = keytab[119];	// prgm
    macro[48] = keytab[113];	// f2
    macro[47] = keytab['D'];	// D
    macro[46] = keytab['U'];	// U
    macro[45] = keytab['M'];	// M
    macro[44] = keytab['M'];	// M
    macro[43] = keytab['Y'];	// Y
    macro[42] = keytab[192];	// alpha
    macro[41] = keytab['9'];	// 9
    macro[40] = keytab['7'];	// 7
    macro[39] = keytab['3'];	// 3
    macro[38] = keytab[0x0d];	// enter
	macro[37] = keytab[220];	// clear
    macro[36] = keytab[46];	// delete
	macro[35] = keytab[220];	// clear
    macro[34] = keytab[46];	// delete
    macro[33] = keytab[192];	// alpha
    macro[32] = keytab[192];	// alpha
    macro[31] = keytab['A'];	// A
    macro[30] = keytab['S'];	// S
    macro[29] = keytab['M'];	// M
    macro[28] = keytab['P'];	// P
    macro[27] = keytab['R'];	// R
    macro[26] = keytab['G'];	// G
    macro[25] = keytab['M'];	// M
    macro[24] = keytab[0x0d];	// enter
    macro[23] = keytab[192];	// alpha
    macro[22] = keytab['C'];	// C
    macro[21] = keytab['9'];	// 9
    macro[20] = keytab[27];	// esc
    macro[19] = keytab[27];	// esc
    macro[18] = keytab[192];	// alpha
    macro[17] = keytab[192];	// alpha
    macro[16] = keytab['A'];	// A
    macro[15] = keytab['S'];	// S
    macro[14] = keytab['M'];	// M
    macro[13] = keytab[192];	// alpha
    macro[12] = keytab[219];	// (
    macro[11] = keytab[192];	// alpha
    macro[10] = keytab[192];	// alpha
    macro[9] = keytab['D'];	// D
    macro[8] = keytab['U'];	// U
    macro[7] = keytab['M'];	// M
    macro[6] = keytab['M'];	// M
    macro[5] = keytab['Y'];	// Y
    macro[4] = keytab[192];	// alpha
    macro[3] = keytab['9'];	// 9
    macro[2] = keytab['7'];	// 7
    macro[1] = keytab['3'];	// 3
    macro[0] = keytab[0x0d];	// enter
    macroptr = 50;
}

void load1(void)
{
	if (loadfiletype == 0x0c || loadfiletype == 0x12 || loadfiletype == 0x11 || loadfiletype == 0x8c)
    {
		// string file: $3c = varname length
        //				$3d... = var name
        //				$47,$48 = string length
        //				$49... = string data

		hw86->mainmem[0x41748] = 0x3e; hw86->mainmem[0x41749] = filebf[0x3c]; // ld a, namelen
        hw86->mainmem[0x4174a] = 0x32; hw86->mainmem[0x4174b] = 0x8a; hw86->mainmem[0x4174c] = 0xc0; // ld ($c08a),
        hw86->mainmem[0x4174d] = 0x3e; hw86->mainmem[0x4174e] = filebf[0x3d]; // ld a, strname[0]
        hw86->mainmem[0x4174f] = 0x32; hw86->mainmem[0x41750] = 0x8b; hw86->mainmem[0x41751] = 0xc0; // ld ($c08b), a
        hw86->mainmem[0x41752] = 0x3e; hw86->mainmem[0x41753] = filebf[0x3e]; // ld a, strname[1]
        hw86->mainmem[0x41754] = 0x32; hw86->mainmem[0x41755] = 0x8c; hw86->mainmem[0x41756] = 0xc0; // ld ($c08c), a
        hw86->mainmem[0x41757] = 0x3e; hw86->mainmem[0x41758] = filebf[0x3f]; // ld a, strname[2]
        hw86->mainmem[0x41759] = 0x32; hw86->mainmem[0x4175a] = 0x8d; hw86->mainmem[0x4175b] = 0xc0; // ld ($c08d), a
        hw86->mainmem[0x4175c] = 0x3e; hw86->mainmem[0x4175d] = filebf[0x40]; // ld a, strname[3]
        hw86->mainmem[0x4175e] = 0x32; hw86->mainmem[0x4175f] = 0x8e; hw86->mainmem[0x41760] = 0xc0; // ld ($c08e), a
        hw86->mainmem[0x41761] = 0x3e; hw86->mainmem[0x41762] = filebf[0x41]; // ld a, strname[4]
        hw86->mainmem[0x41763] = 0x32; hw86->mainmem[0x41764] = 0x8f; hw86->mainmem[0x41765] = 0xc0; // ld ($c08f), a
        hw86->mainmem[0x41766] = 0x3e; hw86->mainmem[0x41767] = filebf[0x42]; // ld a, strname[5]
        hw86->mainmem[0x41768] = 0x32; hw86->mainmem[0x41769] = 0x90; hw86->mainmem[0x4176a] = 0xc0; // ld ($c090), a
        hw86->mainmem[0x4176b] = 0x3e; hw86->mainmem[0x4176c] = filebf[0x43]; // ld a, strname[6]
        hw86->mainmem[0x4176d] = 0x32; hw86->mainmem[0x4176e] = 0x91; hw86->mainmem[0x4176f] = 0xc0; // ld ($c091), a
        hw86->mainmem[0x41770] = 0x3e; hw86->mainmem[0x41771] = filebf[0x44]; // ld a, strname[7]     3e n
        hw86->mainmem[0x41772] = 0x32; hw86->mainmem[0x41773] = 0x92; hw86->mainmem[0x41774] = 0xc0; // ld ($c092), a        32 nn
        if (loadfiletype == 0x8c)
        {
        	hw86->mainmem[0x41775] = 0x21;
            hw86->mainmem[0x41776] = filebf[0x3c+filebf[0x3c]+1+2];
            hw86->mainmem[0x41777] = filebf[0x03c+filebf[0x03c]+1+2+1];
        } // ld hl, strlen 		21 nn
        else
        {
        	hw86->mainmem[0x41775] = 0x21;
            hw86->mainmem[0x41776] = filebf[0x47];
            hw86->mainmem[0x41777] = filebf[0x48]; // ld hl, strlen 		21 nn
        }
        if (loadfiletype == 0x0c || loadfiletype == 0x8c)
        	{hw86->mainmem[0x41778] = 0xcd; hw86->mainmem[0x41779] = 0x2f; hw86->mainmem[0x4177a] = 0x47;} // call $472f 			cd nn
		else if (loadfiletype == 0x12)
			{hw86->mainmem[0x41778] = 0xcd; hw86->mainmem[0x41779] = 0x4f; hw86->mainmem[0x4177a] = 0x47;} // call $474f 			cd nn
		else if (loadfiletype == 0x11)
			{hw86->mainmem[0x41778] = 0xcd; hw86->mainmem[0x41779] = 0x3b; hw86->mainmem[0x4177a] = 0x47;} // call $473b 			cd nn
        hw86->mainmem[0x4177b] = 0xc9; // ret					c9
    }

    macroctr = 16;
    macro[21] = keytab[220];	// clear
    macro[20] = keytab[192];	// alpha
    macro[19] = keytab[192];	// alpha
    macro[18] = keytab['A'];	// A
    macro[17] = keytab['S'];	// S
    macro[16] = keytab['M'];	// M
    macro[15] = keytab[192];	// alpha
    macro[14] = keytab[219];	// (
    macro[13] = keytab[192];	// alpha
    macro[12] = keytab[192];	// alpha
    macro[11] = keytab['D'];	// D
    macro[10] = keytab['U'];	// U
    macro[9] = keytab['M'];	// M
    macro[8] = keytab['M'];	// M
    macro[7] = keytab['Y'];	// Y
    macro[6] = keytab[192];	// alpha
    macro[5] = keytab['9'];	// 9
    macro[4] = keytab['7'];	// 7
    macro[3] = keytab['3'];	// 3
    macro[2] = keytab[0x0d];	// enter
    macro[1] = keytab[220];	// clear
    macro[0] = keytab[220];	// clear
    macroptr = 21;
}

void load2(void)
{
	long i,j,k,numfound,namelen,varlen,symaddr,foundaddr,virtaddr,absaddr;
    char look;
    char searchstr[16];


	//return;
    switch (loadfiletype)
    {
    	case 0x0c:
        {
        	namelen = filebf[0x3c];
        	for (i=0; i<namelen; ++i)
            	searchstr[i] = filebf[0x3d+i];
			varlen = ((unsigned long)(filebf[0x47])&0x000000ff)+(256*((unsigned long)(filebf[0x48])&0x000000ff));
            break;
        }
		case 0x8c:
        {
        	namelen = filebf[0x3c];
        	for (i=0; i<namelen; ++i)
            	searchstr[i] = filebf[0x3d+i];
			varlen = ((unsigned long)(filebf[0x3c+filebf[0x3c]+1+2])&0x000000ff)+(256*((unsigned long)(filebf[0x3c+filebf[0x3c]+1+2+1])&0x000000ff));
            break;
        }
        case 0x11:
        {
        	namelen = filebf[0x3c];
        	for (i=0; i<namelen; ++i)
            	searchstr[i] = filebf[0x3d+i];
            //varlen = filebf[0x47] + filebf[0x48]*256;
            varlen = 1024;
            break;
        }
        case 0x12:
        {
        	namelen = filebf[0x3c];
        	for (i=0; i<namelen; ++i)
            	searchstr[i] = filebf[0x3d+i];
            varlen = ((unsigned long)(filebf[0x47])&0x000000ff)+(256*((unsigned long)(filebf[0x48])&0x000000ff));
            break;
        }
    }
    // find varname in sym table
	for (symaddr = 0x5ffff; symaddr > 0x5c000+namelen; --symaddr)
    {
        foundaddr = symaddr + 3;
		numfound = 0;
    	for (i=0; i<namelen; ++i)
        {
        	if ( hw86->mainmem[symaddr-i]  == searchstr[i])
            	++numfound;
        }
        if ( (numfound == namelen) &&
             (hw86->mainmem[symaddr+1] == namelen) &&
             (hw86->mainmem[symaddr+2] == 0)

             )
        	goto out1;
    }
    hw86->rowscan = 0xffff;
	return;
out1:
    // translate ABS address to virtual address
	absaddr = hw86->mainmem[foundaddr] << 16;
    absaddr += hw86->mainmem[foundaddr+1] << 8;
    absaddr += hw86->mainmem[foundaddr+2];

    virtaddr = absaddr + 0x34000;

    // copy the data into TI86 variable
	if (loadfiletype == 0x0c || loadfiletype == 0x12 || loadfiletype == 0x11 || loadfiletype == 0x8c)
    {
        virtaddr += 2;
		for (i=0; i<varlen; ++i)
        {
            if (loadfiletype == 0x8c)
				hw86->mainmem[i+virtaddr] = filebf[i+0x3c+filebf[0x3c]+1+2+2];
            else
        		hw86->mainmem[i+virtaddr] = filebf[i+0x49];
        }
    }
    hw86->rowscan = 0xffff;
}

void __fastcall Tmaincalc::Button2Click(TObject *Sender)
{
   	dummyedit->SetFocus();
    vkeypad->rowscan = &(hw86->rowscan);
    vkeypad->keymode = &(wks.keymode);
    vkeypad->keytab = keytab;
	vkeypad->Show();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::dummyeditKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
    if (Key == 18) return;
    if (Key == 16) shiftdown = 1;
	if (shiftdown == 1)
    {
	    if (Key == 56 ) Key = 106;
	    else if (Key == 57 ) Key = 219;
	    else if (Key == 48 ) Key = 221;
        else if (Key == 187) Key = 107;
   		else if (Key == 54) Key = 69;
    }

   	if (wks.keymode == 0)
    	hw86->rowscan &= ~keytab[Key];
    else
    	hw86->rowscan = ~keytab[Key];

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::dummyeditKeyUp(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
    long i, j, k;

	if (Key == 18) return;
	if (shiftdown == 1)
    {
	    if (Key == 56 ) Key = 106;
	    else if (Key == 57 ) Key = 219;
	    else if (Key == 48 ) Key = 221;
        else if (Key == 187) Key = 107;
   		else if (Key == 54) Key = 69;
    }
    if (Key == 16) shiftdown = 0;

	if (wks.keymode == 0)
    {
	    j = 0; for (i=0; i<8; ++i)	{if ( (1<<i) & ~(hw86->rowscan) ) ++j;}
		k = 0; for (i=8; i<16; ++i) {if ( (1<<i) & ~(hw86->rowscan) ) ++k;}
		if (k > 1)
            // > 1 colum = error condition, reset keypad
        	hw86->rowscan = 0xffff;
		else
        {
		   	if (j == 1)
		    	hw86->rowscan = hw86->rowscan | keytab[Key]; // normal
		    else
		    	hw86->rowscan = hw86->rowscan | (keytab[Key] & 0x00ff); // multi rows
        }
    }
    else
    	hw86->rowscan = 0xffff;
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::Button3Click(TObject *Sender)
{
	hw86->rowscan = 0xffff;
	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
	if (Key == 33)
    {
    	hw86->rowscan = 0xffff;
       	dummyedit->SetFocus();
    }
	if (Key == 122 && runbutton->Enabled) runbutton->Checked = true;
    if (Key == 123) debugbutton->Checked = true;
}
//---------------------------------------------------------------------------

void Tmaincalc::getmachine(void)
{
	if (	hw86->mainmem[0x5c14] == 'A' &&
    		hw86->mainmem[0x5c15] == 's' &&
            hw86->mainmem[0x5c16] == 'm' &&
            hw86->mainmem[0x5c19] == 'A' &&
            hw86->mainmem[0x5c1a] == 's' &&
            hw86->mainmem[0x5c1b] == 'm' &&
            hw86->mainmem[0x5c22] == 'A' &&
            hw86->mainmem[0x5c23] == 's' &&
            hw86->mainmem[0x5c24] == 'm'
            )
    {
    	hw86->machtype = 0;
        maincalc->Caption = "TI86EMU V1.0 (86)";
        modifierc = 0xc000;
        modifier8 = 0x8000;
        graphmem = 0x43c00;
    }
    else
    {
    	hw86->machtype = 1;
        maincalc->Caption = "TI86EMU V1.0 (85)";
        modifierc = 0x8000;
        modifier8 = 0x8000;
        graphmem = 0x47c00;
    }
}

/*
void createz80tophysaddrtab()
{
	unsigned long i,j,k;


	    // $0000-$3fff
	    for (i=0; i<0x4000; ++i)
	    {
	    	z80tophysaddrtab[i] = i;
	    }
	    // $4000-$7fff
	    for (i=0x4000; i<0x8000; ++i)
	    {
	        if (hw86->banksel0 < 0x18)
	    		z80tophysaddrtab[i] = i-0x4000+0x4000*hw86->banksel0;
	        else
	            z80tophysaddrtab[i] = 0;
	    }
	    // $8000-$bfff
	    for (i=0x8000; i<0xc000; ++i)
	    {
	        if (hw86->banksel1 < 0x18)
	    		z80tophysaddrtab[i] = i-0x8000+0x4000*hw86->banksel1;
	        else
	            z80tophysaddrtab[i] = 0;
	    }
	    // $c000-$ffff
	    for (i=0xc000; i<0x10000; ++i)
	    {
	    	z80tophysaddrtab[i] = i-0xc000+0x40000;
	    }
}
*/

long hwinit(void)
{
	hw86->banksel0 = 0;
    if (hw86->machtype == 1)
    	hw86->banksel1 = 0x10;
    else
    	hw86->banksel1 = 0x0;
	//createz80tophysaddrtab();
    hw86->port3word = 1;
	hw86->port3acc = 0;
    hw86->port6word = 0;
	intrpt = 1;
	intrptm = 100;
    //hw86->push1 = 0;
}

void wipemem(void)
{
	int i;

    for (i=262144; i<393216; ++i)
    	hw86->mainmem[i] = 0x0;

}

void checkwks(void)
{
	if (wks.drawctrmax < 1 || wks.drawctrmax > 2)
    	wks.drawctrmax = 2;
    drawctr = wks.drawctrmax;

}


//**********************************************************************
// Z80 EMULATION and DISASSEMBLER
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//**********************************************************************

// DISSASEMBLER

unsigned char normset[1024] = {
       	 0x01,0x8c,0x00,0x00,             //nop            //00
         0x13,0x73,0x71,0x21,             //ld bc,nn
         0x11,0x73,0x81,0x60,             //ld (bc),a
         0x21,0x57,0x71,0x00,             //inc bc
         0x21,0x57,0x62,0x00,             //inc b
         0x21,0x36,0x62,0x00,             //dec b
         0x12,0x73,0x62,0x11,             //ld b,n
         0x01,0xd2,0x00,0x00,             //rlca
         0x81,0x13,0x00,0x00,             //xc af,af'
         0x11,0x04,0x73,0x71,             //add hl,bc
         0x11,0x73,0x60,0x81,             //ld a,(bc)
         0x21,0x36,0x71,0x00,             //dec bc
         0x21,0x57,0x63,0x00,             //inc c
         0x21,0x36,0x63,0x00,             //dec c
         0x12,0x73,0x63,0x11,             //ld c,n
         0x01,0xe6,0x00,0x00,             //rrca
         0x32,0x3d,0x00,0xc1,             //djnz (pc+e)        //10
         0x13,0x73,0x72,0x21,             //ld de,nn
         0x11,0x73,0x82,0x60,             //ld (de),a
         0x21,0x57,0x72,0x00,             //inc de
         0x21,0x57,0x64,0x00,             //inc d
         0x21,0x36,0x64,0x00,             //dec d
         0x12,0x73,0x64,0x11,             //ld d,n
         0x01,0xca,0x00,0x00,             //rla
         0x32,0x70,0x00,0xc1,             //jr (pc+e)
         0x11,0x04,0x73,0x72,             //add hl,de
         0x11,0x73,0x60,0x82,             //ld a,(de)
         0x21,0x36,0x72,0x00,             //dec de
         0x21,0x57,0x65,0x00,             //inc e
         0x21,0x36,0x65,0x00,             //dec e
         0x12,0x73,0x65,0x11,             //ld e,n
         0x01,0xde,0x00,0x00,             //rra
         0x32,0x70,0x04,0xc1,             //jr nz,(pc+e)   //20
         0x13,0x73,0x73,0x21,             //ld hl,nn
         0x13,0x73,0x41,0x73,             //ld (nn),hl
         0x21,0x57,0x73,0x00,             //inc hl
         0x21,0x57,0x66,0x00,             //inc h
         0x21,0x36,0x66,0x00,             //dec h
         0x12,0x73,0x66,0x11,             //ld h,n
         0x01,0x32,0x00,0x00,             //daa
         0x32,0x70,0x03,0xc1,             //jr z,(pc+e)
         0x11,0x04,0x73,0x73,             //add hl,hl
         0x13,0x73,0x73,0x41,             //ld hl,(nn)
         0x21,0x36,0x73,0x00,             //dec hl
         0x21,0x57,0x67,0x00,             //inc l
         0x21,0x36,0x67,0x00,             //dec l
         0x12,0x73,0x67,0x11,             //ld l,n
         0x01,0x2e,0x00,0x00,             //cpl
         0x32,0x70,0x02,0xc1,             //jr nc,(pc+e)   //0x30
         0x13,0x73,0x76,0x21,             //ld sp,nn
         0x13,0x73,0x41,0x60,             //ld (nn),a
         0x21,0x57,0x76,0x00,             //inc sp
         0x21,0x57,0x83,0x00,             //inc (hl)
         0x21,0x36,0x83,0x00,             //dec (hl)
         0x12,0x73,0x83,0x11,             //ld (hl),n
         0x01,0xf7,0x00,0x00,             //scf
         0x32,0x70,0x01,0xc1,             //jr c,(pc+e)
         0x11,0x04,0x73,0x76,             //add hl,sp
         0x13,0x73,0x60,0x41,             //ld a,(nn)
         0x21,0x36,0x76,0x00,             //dec sp
         0x21,0x57,0x60,0x00,             //inc a
         0x21,0x36,0x60,0x00,             //dec a
         0x12,0x73,0x60,0x11,             //ld a,n
         0x01,0x15,0x00,0x00,             //ccf
         0x11,0x73,0x62,0x62,             //ld b,b         //40
         0x11,0x73,0x62,0x63,             //ld b,c
         0x11,0x73,0x62,0x64,             //ld b,d
         0x11,0x73,0x62,0x65,             //ld b,e
         0x11,0x73,0x62,0x66,             //ld b,h
         0x11,0x73,0x62,0x67,             //ld b,l
         0x11,0x73,0x62,0x83,             //ld b,(hl)
         0x11,0x73,0x62,0x60,             //ld b,a
         0x11,0x73,0x63,0x62,             //ld c,b
         0x11,0x73,0x63,0x63,             //ld c,c
         0x11,0x73,0x63,0x64,             //ld c,d
         0x11,0x73,0x63,0x65,             //ld c,e
         0x11,0x73,0x63,0x66,             //ld c,h
         0x11,0x73,0x63,0x67,             //ld c,l
         0x11,0x73,0x63,0x83,             //ld c,(hl)
         0x11,0x73,0x63,0x60,             //ld c,a
         0x11,0x73,0x64,0x62,             //ld d,b         //50
         0x11,0x73,0x64,0x63,             //ld d,c
         0x11,0x73,0x64,0x64,             //ld d,d
         0x11,0x73,0x64,0x65,             //ld d,e
         0x11,0x73,0x64,0x66,             //ld d,h
         0x11,0x73,0x64,0x67,             //ld d,l
         0x11,0x73,0x64,0x83,             //ld d,(hl)
         0x11,0x73,0x64,0x60,             //ld d,a
         0x11,0x73,0x65,0x62,             //ld e,b
         0x11,0x73,0x65,0x63,             //ld e,c
         0x11,0x73,0x65,0x64,             //ld e,d
         0x11,0x73,0x65,0x65,             //ld e,e
         0x11,0x73,0x65,0x66,             //ld e,h
         0x11,0x73,0x65,0x67,             //ld e,l
         0x11,0x73,0x65,0x83,             //ld e,(hl)
         0x11,0x73,0x65,0x60,             //ld e,a
         0x11,0x73,0x66,0x62,             //ld h,b         //60
         0x11,0x73,0x66,0x63,             //ld h,c
         0x11,0x73,0x66,0x64,             //ld h,d
         0x11,0x73,0x66,0x65,             //ld h,e
         0x11,0x73,0x66,0x66,             //ld h,h
         0x11,0x73,0x66,0x67,             //ld h,l
         0x11,0x73,0x66,0x83,             //ld h,(hl)
         0x11,0x73,0x66,0x60,             //ld h,a
         0x11,0x73,0x67,0x62,             //ld l,b
         0x11,0x73,0x67,0x63,             //ld l,c
         0x11,0x73,0x67,0x64,             //ld l,d
         0x11,0x73,0x67,0x65,             //ld l,e
         0x11,0x73,0x67,0x66,             //ld l,h
         0x11,0x73,0x67,0x67,             //ld l,l
         0x11,0x73,0x67,0x83,             //ld l,(hl)
         0x11,0x73,0x67,0x60,             //ld l,a
         0x11,0x73,0x83,0x62,             //ld (hl),b      //70
         0x11,0x73,0x83,0x63,             //ld (hl),c
         0x11,0x73,0x83,0x64,             //ld (hl),d
         0x11,0x73,0x83,0x65,             //ld (hl),e
         0x11,0x73,0x83,0x66,             //ld (hl),h
         0x11,0x73,0x83,0x67,             //ld (hl),l      //75
         0x01,0x4c,0x00,0x00,             //halt
         0x11,0x73,0x83,0x60,             //ld (hl),a
         0x11,0x73,0x60,0x62,             //ld a,b
         0x11,0x73,0x60,0x63,             //ld a,c
         0x11,0x73,0x60,0x64,             //ld a,d
         0x11,0x73,0x60,0x65,             //ld a,e
         0x11,0x73,0x60,0x66,             //ld a,h
         0x11,0x73,0x60,0x67,             //ld a,l
         0x11,0x73,0x60,0x83,             //ld a,(hl)
         0x11,0x73,0x60,0x60,             //ld a,a
         0x11,0x04,0x60,0x62,             //add a,b        //80
         0x11,0x04,0x60,0x63,             //add a,c
         0x11,0x04,0x60,0x64,             //add a,d
         0x11,0x04,0x60,0x65,             //add a,e
         0x11,0x04,0x60,0x66,             //add a,h
         0x11,0x04,0x60,0x67,             //add a,l
         0x11,0x04,0x60,0x83,             //add a,(hl)
         0x11,0x04,0x60,0x60,             //add a,a
         0x11,0x00,0x60,0x62,             //adc a,b
         0x11,0x00,0x60,0x63,             //adc a,c
         0x11,0x00,0x60,0x64,             //adc a,d
         0x11,0x00,0x60,0x65,             //adc a,e
         0x11,0x00,0x60,0x66,             //adc a,h
         0x11,0x00,0x60,0x67,             //adc a,l
         0x11,0x00,0x60,0x83,             //adc a,(hl)
         0x11,0x00,0x60,0x60,             //adc a,a
         0x91,0x0b,0x6a,0x62,             //sub b          //90
         0x91,0x0b,0x6a,0x63,             //sub c
         0x91,0x0b,0x6a,0x64,             //sub d
         0x91,0x0b,0x6a,0x65,             //sub e
         0x91,0x0b,0x6a,0x66,             //sub h
         0x91,0x0b,0x6a,0x67,             //sub l
         0x91,0x0b,0x6a,0x83,             //sub (hl)
         0x91,0x0b,0x6a,0x60,             //sub a
         0x11,0xf3,0x60,0x62,             //sbc a,b
         0x11,0xf3,0x60,0x63,             //sbc a,c
         0x11,0xf3,0x60,0x64,             //sbc a,d
         0x11,0xf3,0x60,0x65,             //sbc a,e
         0x11,0xf3,0x60,0x66,             //sbc a,h
         0x11,0xf3,0x60,0x67,             //sbc a,l
         0x11,0xf3,0x60,0x83,             //sbc a,(hl)
         0x11,0xf3,0x60,0x60,             //sbc a,a
         0x11,0x08,0x6a,0x62,             //and b          //a0
         0x11,0x08,0x6a,0x63,             //and c
         0x11,0x08,0x6a,0x64,             //and d
         0x11,0x08,0x6a,0x65,             //and e
         0x11,0x08,0x6a,0x66,             //and h
         0x11,0x08,0x6a,0x67,             //and l
         0x11,0x08,0x6a,0x83,             //and (hl)
         0x11,0x08,0x6a,0x60,             //and a
         0x91,0x0f,0x6a,0x62,             //xor b
         0x91,0x0f,0x6a,0x63,             //xor c
         0x91,0x0f,0x6a,0x64,             //xor d
         0x91,0x0f,0x6a,0x65,             //xor e
         0x91,0x0f,0x6a,0x66,             //xor h
         0x91,0x0f,0x6a,0x67,             //xor l
         0x91,0x0f,0x6a,0x83,             //xor (hl)
         0x91,0x0f,0x6a,0x60,             //xor a
         0x11,0x90,0x6a,0x62,             //or b           //b0
         0x11,0x90,0x6a,0x63,             //or c
         0x11,0x90,0x6a,0x64,             //or d
         0x11,0x90,0x6a,0x65,             //or e
         0x11,0x90,0x6a,0x66,             //or h
         0x11,0x90,0x6a,0x67,             //or l
         0x11,0x90,0x6a,0x83,             //or (hl)
         0x11,0x90,0x6a,0x60,             //or a
         0x11,0x19,0x6a,0x62,             //cp b
         0x11,0x19,0x6a,0x63,             //cp c
         0x11,0x19,0x6a,0x64,             //cp d
         0x11,0x19,0x6a,0x65,             //cp e
         0x11,0x19,0x6a,0x66,             //cp h
         0x11,0x19,0x6a,0x67,             //cp l
         0x11,0x19,0x6a,0x83,             //cp (hl)
         0x11,0x19,0x6a,0x60,             //cp a
         0x31,0xb8,0x04,0xb0,             //ret nz         //c0
         0x21,0xab,0x71,0x00,             //pop bc
         0x33,0x6d,0x04,0x21,             //jp nz,(nn)
         0x33,0x6d,0x00,0x21,             //jp (nn)
         0x33,0x10,0x04,0x21,             //call nz,(nn)
         0x21,0xaf,0x71,0x00,             //push bc
         0x12,0x04,0x60,0x11,             //add a,n
         0x81,0x1d,0x00,0x00,             //rst 0h
         0x31,0xb8,0x03,0xb0,             //ret z
         0x31,0xb8,0x00,0xb0,             //ret
         0x33,0x6d,0x03,0x21,             //jp z,(nn)
         0x81,0x5b,0x00,0x00,             //CB INSTRUCTION SET
         0x33,0x10,0x03,0x21,             //call z,(nn)
         0x33,0x10,0x00,0x21,             //call (nn)
         0x12,0x00,0x60,0x11,             //adc a,n
         0x81,0x24,0x00,0x00,             //rst 8h
         0x31,0xb8,0x02,0xb0,             //ret nc         //d0
         0x21,0xab,0x72,0x00,             //pop de
         0x33,0x6d,0x02,0x21,             //jp nc,(nn)
         0x12,0x9d,0xa1,0x60,             //out (n),a
         0x33,0x10,0x02,0x21,             //call nc,(nn)
         0x21,0xaf,0x72,0x00,             //push de
         0x92,0x0b,0x6a,0x11,             //sub n
         0x81,0x2b,0x00,0x00,             //rst 10h
         0x31,0xb8,0x01,0xb0,             //ret c
         0x01,0x48,0x00,0x00,             //exx
         0x33,0x6d,0x01,0x21,             //jp c,(nn)
         0x12,0x54,0x60,0xa1,             //in a,(n)
         0x33,0x10,0x01,0x21,             //call c,(nn)
         0x81,0x5b,0x00,0x00,             //DD INSTRUCTION SET     //dd
         0x12,0xf3,0x60,0x11,             //sbc a,n
         0x81,0x33,0x00,0x00,             //rst 18h
         0x31,0xb8,0x05,0xb0,             //ret po         //e0
         0x21,0xab,0x73,0x00,             //pop hl
         0x33,0x6d,0x05,0x21,             //jp po,(nn)
         0x11,0x45,0x86,0x73,             //ex (sp),hl
         0x33,0x10,0x05,0x21,             //call po,(nn)
         0x21,0xaf,0x73,0x00,             //push hl
         0x12,0x08,0x6a,0x11,             //and n
         0x81,0x3b,0x00,0x00,             //rst 20h
         0x31,0xb8,0x06,0xb0,             //ret pe
         0x31,0x6d,0x00,0x83,             //jp (hl)
         0x33,0x6d,0x06,0x21,             //jp pe,(nn)
         0x11,0x45,0x72,0x73,             //ex de,hl
         0x33,0x10,0x06,0x21,             //call pe,(nn)
         0x81,0x5b,0x00,0x00,             //ED INSTRUCTION SET
         0x92,0x0f,0x6a,0x11,             //xor n
         0x81,0x43,0x00,0x00,             //rst 28h
         0x31,0xb8,0x07,0xb0,             //ret p          //f0
         0x21,0xab,0x70,0x00,             //pop af
         0x33,0x6d,0x07,0x21,             //jp p,(nn)
         0x01,0x3a,0x00,0x00,             //di
         0x33,0x10,0x07,0x21,             //call p,(nn)
         0x21,0xaf,0x70,0x00,             //push af
         0x12,0x90,0x6a,0x11,             //or n
         0x81,0x4b,0x00,0x00,             //rst 30h
         0x31,0xb8,0x08,0xb0,             //ret m
         0x11,0x73,0x76,0x73,             //ld sp,hl
         0x33,0x6d,0x08,0x21,             //jp m,(nn)
         0x01,0x42,0x00,0x00,             //ei
         0x33,0x10,0x08,0x21,             //call m,(nn)
         0x81,0x5b,0x00,0x00,             //FD INSTRUCTION SET
         0x12,0x19,0x6a,0x11,             //cp n
         0x81,0x53,0x00,0x00              //rst 38h         //ff
			};

unsigned char cbset[1024] = {
         0x22,0xce,0x62,0x00,             //rlc b
         0x22,0xce,0x63,0x00,             //rlc c
         0x22,0xce,0x64,0x00,             //rlc d
         0x22,0xce,0x65,0x00,             //rlc e
         0x22,0xce,0x66,0x00,             //rlc h
         0x22,0xce,0x67,0x00,             //rlc l
         0x22,0xce,0x83,0x00,             //rlc (hl)
         0x22,0xce,0x60,0x00,             //rlc a
         0x22,0xe2,0x62,0x00,             //rrc b
         0x22,0xe2,0x63,0x00,             //rrc c
         0x22,0xe2,0x64,0x00,             //rrc d
         0x22,0xe2,0x65,0x00,             //rrc e
         0x22,0xe2,0x66,0x00,             //rrc h
         0x22,0xe2,0x67,0x00,             //rrc l
         0x22,0xe2,0x83,0x00,             //rrc (hl)
         0x22,0xe2,0x60,0x00,             //rrc a
         0xa2,0x5f,0x62,0x00,             //rl b
         0xa2,0x5f,0x63,0x00,             //rl c
         0xa2,0x5f,0x64,0x00,             //rl d
         0xa2,0x5f,0x65,0x00,             //rl e
         0xa2,0x5f,0x66,0x00,             //rl h
         0xa2,0x5f,0x67,0x00,             //rl l
         0xa2,0x5f,0x83,0x00,             //rl (hl)
         0xa2,0x5f,0x60,0x00,             //rl a
         0x22,0xdb,0x62,0x00,             //rr b
         0x22,0xdb,0x63,0x00,             //rr c
         0x22,0xdb,0x64,0x00,             //rr d
         0x22,0xdb,0x65,0x00,             //rr e
         0x22,0xdb,0x66,0x00,             //rr h
         0x22,0xdb,0x67,0x00,             //rr l
         0x22,0xdb,0x83,0x00,             //rr (hl)
         0x22,0xdb,0x60,0x00,             //rr a
         0x22,0xff,0x62,0x00,             //sla b
         0x22,0xff,0x63,0x00,             //sla c
         0x22,0xff,0x64,0x00,             //sla d
         0x22,0xff,0x65,0x00,             //sla e
         0x22,0xff,0x66,0x00,             //sla h
         0x22,0xff,0x67,0x00,             //sla l
         0x22,0xff,0x83,0x00,             //sla (hl)
         0x22,0xff,0x60,0x00,             //sla a
         0xa2,0x03,0x62,0x00,             //sra b
         0xa2,0x03,0x63,0x00,             //sra c
         0xa2,0x03,0x64,0x00,             //sra d
         0xa2,0x03,0x65,0x00,             //sra e
         0xa2,0x03,0x66,0x00,             //sra h
         0xa2,0x03,0x67,0x00,             //sra l
         0xa2,0x03,0x83,0x00,             //sra (hl)
         0xa2,0x03,0x60,0x00,             //sra a
         0x81,0x5b,0x62,0x00,             //sll b*
         0x81,0x5b,0x63,0x00,             //sll c*
         0x81,0x5b,0x64,0x00,             //sll d*
         0x81,0x5b,0x65,0x00,             //sll e*
         0x81,0x5b,0x66,0x00,             //sll h*
         0x81,0x5b,0x67,0x00,             //sll l*
         0x81,0x5b,0x83,0x00,             //sll (hl)*
         0x81,0x5b,0x60,0x00,             //sll a*
         0xa2,0x07,0x62,0x00,             //srl b
         0xa2,0x07,0x63,0x00,             //srl c
         0xa2,0x07,0x64,0x00,             //srl d
         0xa2,0x07,0x65,0x00,             //srl e
         0xa2,0x07,0x66,0x00,             //srl h
         0xa2,0x07,0x67,0x00,             //srl l
         0xa2,0x07,0x83,0x00,             //srl (hl)
         0xa2,0x07,0x60,0x00,             //srl a
         0x12,0x0c,0xd0,0x62,             //bit 0,b
         0x12,0x0c,0xd0,0x63,             //bit 0,c
         0x12,0x0c,0xd0,0x64,             //bit 0,d
         0x12,0x0c,0xd0,0x65,             //bit 0,e
         0x12,0x0c,0xd0,0x66,             //bit 0,h
         0x12,0x0c,0xd0,0x67,             //bit 0,l
         0x12,0x0c,0xd0,0x83,             //bit 0,(hl)
         0x12,0x0c,0xd0,0x60,             //bit 0,a
         0x12,0x0c,0xd1,0x62,             //bit 1,b
         0x12,0x0c,0xd1,0x63,             //bit 1,c
         0x12,0x0c,0xd1,0x64,             //bit 1,d
         0x12,0x0c,0xd1,0x65,             //bit 1,e
         0x12,0x0c,0xd1,0x66,             //bit 1,h
         0x12,0x0c,0xd1,0x67,             //bit 1,l
         0x12,0x0c,0xd1,0x83,             //bit 1,(hl)
         0x12,0x0c,0xd1,0x60,             //bit 1,a
         0x12,0x0c,0xd2,0x62,             //bit 2,b
         0x12,0x0c,0xd2,0x63,             //bit 2,c
         0x12,0x0c,0xd2,0x64,             //bit 2,d
         0x12,0x0c,0xd2,0x65,             //bit 2,e
         0x12,0x0c,0xd2,0x66,             //bit 2,h
         0x12,0x0c,0xd2,0x67,             //bit 2,l
         0x12,0x0c,0xd2,0x83,             //bit 2,(hl)
         0x12,0x0c,0xd2,0x60,             //bit 2,a
         0x12,0x0c,0xd3,0x62,             //bit 3,b
         0x12,0x0c,0xd3,0x63,             //bit 3,c
         0x12,0x0c,0xd3,0x64,             //bit 3,d
         0x12,0x0c,0xd3,0x65,             //bit 3,e
         0x12,0x0c,0xd3,0x66,             //bit 3,h
         0x12,0x0c,0xd3,0x67,             //bit 3,l
         0x12,0x0c,0xd3,0x83,             //bit 3,(hl)
         0x12,0x0c,0xd3,0x60,             //bit 3,a
         0x12,0x0c,0xd4,0x62,             //bit 4,b
         0x12,0x0c,0xd4,0x63,             //bit 4,c
         0x12,0x0c,0xd4,0x64,             //bit 4,d
         0x12,0x0c,0xd4,0x65,             //bit 4,e
         0x12,0x0c,0xd4,0x66,             //bit 4,h
         0x12,0x0c,0xd4,0x67,             //bit 4,l
         0x12,0x0c,0xd4,0x83,             //bit 4,(hl)
         0x12,0x0c,0xd4,0x60,             //bit 4,a
         0x12,0x0c,0xd5,0x62,             //bit 5,b
         0x12,0x0c,0xd5,0x63,             //bit 5,c
         0x12,0x0c,0xd5,0x64,             //bit 5,d
         0x12,0x0c,0xd5,0x65,             //bit 5,e
         0x12,0x0c,0xd5,0x66,             //bit 5,h
         0x12,0x0c,0xd5,0x67,             //bit 5,l
         0x12,0x0c,0xd5,0x83,             //bit 5,(hl)
         0x12,0x0c,0xd5,0x60,             //bit 5,a
         0x12,0x0c,0xd6,0x62,             //bit 6,b
         0x12,0x0c,0xd6,0x63,             //bit 6,c
         0x12,0x0c,0xd6,0x64,             //bit 6,d
         0x12,0x0c,0xd6,0x65,             //bit 6,e
         0x12,0x0c,0xd6,0x66,             //bit 6,h
         0x12,0x0c,0xd6,0x67,             //bit 6,l
         0x12,0x0c,0xd6,0x83,             //bit 6,(hl)
         0x12,0x0c,0xd6,0x60,             //bit 6,a
         0x12,0x0c,0xd7,0x62,             //bit 7,b
         0x12,0x0c,0xd7,0x63,             //bit 7,c
         0x12,0x0c,0xd7,0x64,             //bit 7,d
         0x12,0x0c,0xd7,0x65,             //bit 7,e
         0x12,0x0c,0xd7,0x66,             //bit 7,h
         0x12,0x0c,0xd7,0x67,             //bit 7,l
         0x12,0x0c,0xd7,0x83,             //bit 7,(hl)
         0x12,0x0c,0xd7,0x60,             //bit 7,a
         0x12,0xb4,0xd0,0x62,             //res 0,b
         0x12,0xb4,0xd0,0x63,             //res 0,c
         0x12,0xb4,0xd0,0x64,             //res 0,d
         0x12,0xb4,0xd0,0x65,             //res 0,e
         0x12,0xb4,0xd0,0x66,             //res 0,h
         0x12,0xb4,0xd0,0x67,             //res 0,l
         0x12,0xb4,0xd0,0x83,             //res 0,(hl)
         0x12,0xb4,0xd0,0x60,             //res 0,a
         0x12,0xb4,0xd1,0x62,             //res 1,b
         0x12,0xb4,0xd1,0x63,             //res 1,c
         0x12,0xb4,0xd1,0x64,             //res 1,d
         0x12,0xb4,0xd1,0x65,             //res 1,e
         0x12,0xb4,0xd1,0x66,             //res 1,h
         0x12,0xb4,0xd1,0x67,             //res 1,l
         0x12,0xb4,0xd1,0x83,             //res 1,(hl)
         0x12,0xb4,0xd1,0x60,             //res 1,a
         0x12,0xb4,0xd2,0x62,             //res 2,b
         0x12,0xb4,0xd2,0x63,             //res 2,c
         0x12,0xb4,0xd2,0x64,             //res 2,d
         0x12,0xb4,0xd2,0x65,             //res 2,e
         0x12,0xb4,0xd2,0x66,             //res 2,h
         0x12,0xb4,0xd2,0x67,             //res 2,l
         0x12,0xb4,0xd2,0x83,             //res 2,(hl)
         0x12,0xb4,0xd2,0x60,             //res 2,a
         0x12,0xb4,0xd3,0x62,             //res 3,b
         0x12,0xb4,0xd3,0x63,             //res 3,c
         0x12,0xb4,0xd3,0x64,             //res 3,d
         0x12,0xb4,0xd3,0x65,             //res 3,e
         0x12,0xb4,0xd3,0x66,             //res 3,h
         0x12,0xb4,0xd3,0x67,             //res 3,l
         0x12,0xb4,0xd3,0x83,             //res 3,(hl)
         0x12,0xb4,0xd3,0x60,             //res 3,a
         0x12,0xb4,0xd4,0x62,             //res 4,b
         0x12,0xb4,0xd4,0x63,             //res 4,c
         0x12,0xb4,0xd4,0x64,             //res 4,d
         0x12,0xb4,0xd4,0x65,             //res 4,e
         0x12,0xb4,0xd4,0x66,             //res 4,h
         0x12,0xb4,0xd4,0x67,             //res 4,l
         0x12,0xb4,0xd4,0x83,             //res 4,(hl)
         0x12,0xb4,0xd4,0x60,             //res 4,a
         0x12,0xb4,0xd5,0x62,             //res 5,b
         0x12,0xb4,0xd5,0x63,             //res 5,c
         0x12,0xb4,0xd5,0x64,             //res 5,d
         0x12,0xb4,0xd5,0x65,             //res 5,e
         0x12,0xb4,0xd5,0x66,             //res 5,h
         0x12,0xb4,0xd5,0x67,             //res 5,l
         0x12,0xb4,0xd5,0x83,             //res 5,(hl)
         0x12,0xb4,0xd5,0x60,             //res 5,a
         0x12,0xb4,0xd6,0x62,             //res 6,b
         0x12,0xb4,0xd6,0x63,             //res 6,c
         0x12,0xb4,0xd6,0x64,             //res 6,d
         0x12,0xb4,0xd6,0x65,             //res 6,e
         0x12,0xb4,0xd6,0x66,             //res 6,h
         0x12,0xb4,0xd6,0x67,             //res 6,l
         0x12,0xb4,0xd6,0x83,             //res 6,(hl)
         0x12,0xb4,0xd6,0x60,             //res 6,a
         0x12,0xb4,0xd7,0x62,             //res 7,b
         0x12,0xb4,0xd7,0x63,             //res 7,c
         0x12,0xb4,0xd7,0x64,             //res 7,d
         0x12,0xb4,0xd7,0x65,             //res 7,e
         0x12,0xb4,0xd7,0x66,             //res 7,h
         0x12,0xb4,0xd7,0x67,             //res 7,l
         0x12,0xb4,0xd7,0x83,             //res 7,(hl)
         0x12,0xb4,0xd7,0x60,             //res 7,a
         0x12,0xfb,0xd0,0x62,             //set 0,b
         0x12,0xfb,0xd0,0x63,             //set 0,c
         0x12,0xfb,0xd0,0x64,             //set 0,d
         0x12,0xfb,0xd0,0x65,             //set 0,e
         0x12,0xfb,0xd0,0x66,             //set 0,h
         0x12,0xfb,0xd0,0x67,             //set 0,l
         0x12,0xfb,0xd0,0x83,             //set 0,(hl)
         0x12,0xfb,0xd0,0x60,             //set 0,a
         0x12,0xfb,0xd1,0x62,             //set 1,b
         0x12,0xfb,0xd1,0x63,             //set 1,c
         0x12,0xfb,0xd1,0x64,             //set 1,d
         0x12,0xfb,0xd1,0x65,             //set 1,e
         0x12,0xfb,0xd1,0x66,             //set 1,h
         0x12,0xfb,0xd1,0x67,             //set 1,l
         0x12,0xfb,0xd1,0x83,             //set 1,(hl)
         0x12,0xfb,0xd1,0x60,             //set 1,a
         0x12,0xfb,0xd2,0x62,             //set 2,b
         0x12,0xfb,0xd2,0x63,             //set 2,c
         0x12,0xfb,0xd2,0x64,             //set 2,d
         0x12,0xfb,0xd2,0x65,             //set 2,e
         0x12,0xfb,0xd2,0x66,             //set 2,h
         0x12,0xfb,0xd2,0x67,             //set 2,l
         0x12,0xfb,0xd2,0x83,             //set 2,(hl)
         0x12,0xfb,0xd2,0x60,             //set 2,a
         0x12,0xfb,0xd3,0x62,             //set 3,b
         0x12,0xfb,0xd3,0x63,             //set 3,c
         0x12,0xfb,0xd3,0x64,             //set 3,d
         0x12,0xfb,0xd3,0x65,             //set 3,e
         0x12,0xfb,0xd3,0x66,             //set 3,h
         0x12,0xfb,0xd3,0x67,             //set 3,l
         0x12,0xfb,0xd3,0x83,             //set 3,(hl)
         0x12,0xfb,0xd3,0x60,             //set 3,a
         0x12,0xfb,0xd4,0x62,             //set 4,b
         0x12,0xfb,0xd4,0x63,             //set 4,c
         0x12,0xfb,0xd4,0x64,             //set 4,d
         0x12,0xfb,0xd4,0x65,             //set 4,e
         0x12,0xfb,0xd4,0x66,             //set 4,h
         0x12,0xfb,0xd4,0x67,             //set 4,l
         0x12,0xfb,0xd4,0x83,             //set 4,(hl)
         0x12,0xfb,0xd4,0x60,             //set 4,a
         0x12,0xfb,0xd5,0x62,             //set 5,b
         0x12,0xfb,0xd5,0x63,             //set 5,c
         0x12,0xfb,0xd5,0x64,             //set 5,d
         0x12,0xfb,0xd5,0x65,             //set 5,e
         0x12,0xfb,0xd5,0x66,             //set 5,h
         0x12,0xfb,0xd5,0x67,             //set 5,l
         0x12,0xfb,0xd5,0x83,             //set 5,(hl)
         0x12,0xfb,0xd5,0x60,             //set 5,a
         0x12,0xfb,0xd6,0x62,             //set 6,b
         0x12,0xfb,0xd6,0x63,             //set 6,c
         0x12,0xfb,0xd6,0x64,             //set 6,d
         0x12,0xfb,0xd6,0x65,             //set 6,e
         0x12,0xfb,0xd6,0x66,             //set 6,h
         0x12,0xfb,0xd6,0x67,             //set 6,l
         0x12,0xfb,0xd6,0x83,             //set 6,(hl)
         0x12,0xfb,0xd6,0x60,             //set 6,a
         0x12,0xfb,0xd7,0x62,             //set 7,b
         0x12,0xfb,0xd7,0x63,             //set 7,c
         0x12,0xfb,0xd7,0x64,             //set 7,d
         0x12,0xfb,0xd7,0x65,             //set 7,e
         0x12,0xfb,0xd7,0x66,             //set 7,h
         0x12,0xfb,0xd7,0x67,             //set 7,l
         0x12,0xfb,0xd7,0x83,             //set 7,(hl)
         0x12,0xfb,0xd7,0x60              //set 7,a
         	};

unsigned char ddset[196] = {
         39,
         0x09,0x12,0x04,0x74,0x71,         //add ix,bc
         0x19,0x12,0x04,0x74,0x72,         //add ix,de
         0x21,0x14,0x73,0x74,0x22,         //ld ix,nn
         0x22,0x14,0x73,0x42,0x74,         //ld (nn),ix
         0x23,0x22,0x57,0x74,0x00,         //inc ix
         0x29,0x12,0x04,0x74,0x74,         //add ix,ix
         0x2a,0x14,0x73,0x74,0x42,         //ld ix,(nn)
         0x2b,0x22,0x36,0x74,0x00,         //dec ix
         0x34,0x23,0x57,0x54,0x00,         //inc (ix+d)
         0x35,0x23,0x36,0x54,0x00,         //dec (ix+d)
         0x36,0x14,0x73,0x54,0x13,         //ld (ix+d),n
         0x39,0x12,0x04,0x74,0x76,         //add ix,sp
         0x46,0x13,0x73,0x62,0x54,         //ld b,(ix+d)
         0x4e,0x13,0x73,0x63,0x54,         //ld c,(ix+d)
         0x56,0x13,0x73,0x64,0x54,         //ld d,(ix+d)
         0x5e,0x13,0x73,0x65,0x54,         //ld e,(ix+d)
         0x66,0x13,0x73,0x66,0x54,         //ld h,(ix+d)
         0x6e,0x13,0x73,0x67,0x54,         //ld l,(ix+d)
         0x70,0x13,0x73,0x54,0x62,         //ld (ix+d),b
         0x71,0x13,0x73,0x54,0x63,         //ld (ix+d),c
         0x72,0x13,0x73,0x54,0x64,         //ld (ix+d),d
         0x73,0x13,0x73,0x54,0x65,         //ld (ix+d),e
         0x74,0x13,0x73,0x54,0x66,         //ld (ix+d),h
         0x75,0x13,0x73,0x54,0x67,         //ld (ix+d),l
         0x77,0x13,0x73,0x54,0x60,         //ld (ix+d),a
         0x7e,0x13,0x73,0x60,0x54,         //ld a,(ix+d)
         0x86,0x13,0x04,0x60,0x54,         //add a,(ix+d)
         0x8e,0x13,0x00,0x60,0x54,         //adc a,(ix+d)
         0x96,0x93,0x0b,0x6a,0x54,         //sub (ix+d)
         0x9e,0x13,0xf3,0x60,0x54,         //sbc a,(ix+d)
         0xa6,0x13,0x08,0x6a,0x54,         //and (ix+d)
         0xae,0x93,0x0f,0x6a,0x54,         //xor (ix+d)
         0xb6,0x13,0x90,0x6a,0x54,         //or (ix+d)
         0xbe,0x13,0x19,0x6a,0x54,         //cp (ix+d)
         0xe1,0x22,0xab,0x74,0x00,         //pop ix
         0xe3,0x12,0x45,0x86,0x74,         //ex (sp),ix
         0xe5,0x22,0xaf,0x74,0x00,         //push ix
         0xe9,0x32,0x6d,0x00,0x84,         //jp (ix)
         0xf9,0x12,0x73,0x76,0x74          //ld sp,ix
         	};

unsigned char ddcbset[156] = {
         31,
         0x06,0x24,0xce,0x54,0x00,         //rlc (ix+d)
         0x0e,0x24,0xe2,0x54,0x00,         //rrc (ix+d)
         0x16,0xa4,0x5f,0x54,0x00,         //rl (ix+d)
         0x1e,0x24,0xdb,0x54,0x00,         //rr (ix+d)
         0x26,0x24,0xff,0x54,0x00,         //sla (ix+d)
         0x2e,0xa4,0x03,0x54,0x00,         //sra (ix+d)
         0x3e,0xa4,0x07,0x54,0x00,         //srl (ix+d)
         0x46,0x14,0x0c,0xd0,0x54,         //bit 0,(ix+d)
         0x4e,0x14,0x0c,0xd1,0x54,         //bit 1,(ix+d)
         0x56,0x14,0x0c,0xd2,0x54,         //bit 2,(ix+d)
         0x5e,0x14,0x0c,0xd3,0x54,         //bit 3,(ix+d)
         0x66,0x14,0x0c,0xd4,0x54,         //bit 4,(ix+d)
         0x6e,0x14,0x0c,0xd5,0x54,         //bit 5,(ix+d)
         0x76,0x14,0x0c,0xd6,0x54,         //bit 6,(ix+d)
         0x7e,0x14,0x0c,0xd7,0x54,         //bit 7,(ix+d)
         0x86,0x14,0xb4,0xd0,0x54,         //res 0,(ix+d)
         0x8e,0x14,0xb4,0xd1,0x54,         //res 1,(ix+d)
         0x96,0x14,0xb4,0xd2,0x54,         //res 2,(ix+d)
         0x9e,0x14,0xb4,0xd3,0x54,         //res 3,(ix+d)
         0xa6,0x14,0xb4,0xd4,0x54,         //res 4,(ix+d)
         0xae,0x14,0xb4,0xd5,0x54,         //res 5,(ix+d)
         0xb6,0x14,0xb4,0xd6,0x54,         //res 6,(ix+d)
         0xbe,0x14,0xb4,0xd7,0x54,         //res 7,(ix+d)
         0xc6,0x14,0xfb,0xd0,0x54,         //set 0,(ix+d)
         0xce,0x14,0xfb,0xd1,0x54,         //set 1,(ix+d)
         0xd6,0x14,0xfb,0xd2,0x54,         //set 2,(ix+d)
         0xde,0x14,0xfb,0xd3,0x54,         //set 3,(ix+d)
         0xe6,0x14,0xfb,0xd4,0x54,         //set 4,(ix+d)
         0xee,0x14,0xfb,0xd5,0x54,         //set 5,(ix+d)
         0xf6,0x14,0xfb,0xd6,0x54,         //set 6,(ix+d)
         0xfe,0x14,0xfb,0xd7,0x54          //set 7,(ix+d)
         	};

unsigned char fdset[196] = {
         39,
         0x09,0x12,0x04,0x75,0x71,         //add iy,bc
         0x19,0x12,0x04,0x75,0x72,         //add iy,de
         0x21,0x14,0x73,0x75,0x22,         //ld iy,nn
         0x22,0x14,0x73,0x42,0x75,         //ld (nn),iy
         0x23,0x22,0x57,0x75,0x00,         //inc iy
         0x29,0x12,0x04,0x75,0x75,         //add iy,iy
         0x2a,0x14,0x73,0x75,0x42,         //ld iy,(nn)
         0x2b,0x22,0x36,0x75,0x00,         //dec iy
         0x34,0x23,0x57,0x55,0x00,         //inc (iy+d)
         0x35,0x23,0x36,0x55,0x00,         //dec (iy+d)
         0x36,0x14,0x73,0x55,0x13,         //ld (iy+d),n
         0x39,0x12,0x04,0x75,0x76,         //add iy,sp
         0x46,0x13,0x73,0x62,0x55,         //ld b,(iy+d)
         0x4e,0x13,0x73,0x63,0x55,         //ld c,(iy+d)
         0x56,0x13,0x73,0x64,0x55,         //ld d,(iy+d)
         0x5e,0x13,0x73,0x65,0x55,         //ld e,(iy+d)
         0x66,0x13,0x73,0x66,0x55,         //ld h,(iy+d)
         0x6e,0x13,0x73,0x67,0x55,         //ld l,(iy+d)
         0x70,0x13,0x73,0x55,0x62,         //ld (iy+d),b
         0x71,0x13,0x73,0x55,0x63,         //ld (iy+d),c
         0x72,0x13,0x73,0x55,0x64,         //ld (iy+d),d
         0x73,0x13,0x73,0x55,0x65,         //ld (iy+d),e
         0x74,0x13,0x73,0x55,0x66,         //ld (iy+d),h
         0x75,0x13,0x73,0x55,0x67,         //ld (iy+d),l
         0x77,0x13,0x73,0x55,0x60,         //ld (iy+d),a
         0x7e,0x13,0x73,0x60,0x55,         //ld a,(iy+d)
         0x86,0x13,0x04,0x60,0x55,         //add a,(iy+d)
         0x8e,0x13,0x00,0x60,0x55,         //adc a,(iy+d)
         0x96,0x93,0x0b,0x6a,0x55,         //sub (iy+d)
         0x9e,0x13,0xf3,0x60,0x55,         //sbc a,(iy+d)
         0xa6,0x13,0x08,0x6a,0x55,         //and (iy+d)
         0xae,0x93,0x0f,0x6a,0x55,         //xor (iy+d)
         0xb6,0x13,0x90,0x6a,0x55,         //or (iy+d)
         0xbe,0x13,0x19,0x6a,0x55,         //cp (iy+d)
         0xe1,0x22,0xab,0x75,0x00,         //pop iy
         0xe3,0x12,0x45,0x86,0x75,         //ex (sp),iy
         0xe5,0x22,0xaf,0x75,0x00,         //push iy
         0xe9,0x32,0x6d,0x00,0x85,         //jp (iy)
         0xf9,0x12,0x73,0x76,0x75          //ld sp,iy
         	};

unsigned char fdcbset[156] = {
         31,
         0x06,0x24,0xce,0x55,0x00,         //rlc (iy+d)
         0x0e,0x24,0xe2,0x55,0x00,         //rrc (iy+d)
         0x16,0xa4,0x5f,0x55,0x00,         //rl (iy+d)
         0x1e,0x24,0xdb,0x55,0x00,         //rr (iy+d)
         0x26,0x24,0xff,0x55,0x00,         //sla (iy+d)
         0x2e,0xa4,0x03,0x55,0x00,         //sra (iy+d)
         0x3e,0xa4,0x07,0x55,0x00,         //srl (iy+d)
         0x46,0x14,0x0c,0xd0,0x55,         //bit 0,(iy+d)
         0x4e,0x14,0x0c,0xd1,0x55,         //bit 1,(iy+d)
         0x56,0x14,0x0c,0xd2,0x55,         //bit 2,(iy+d)
         0x5e,0x14,0x0c,0xd3,0x55,         //bit 3,(iy+d)
         0x66,0x14,0x0c,0xd4,0x55,         //bit 4,(iy+d)
         0x6e,0x14,0x0c,0xd5,0x55,         //bit 5,(iy+d)
         0x76,0x14,0x0c,0xd6,0x55,         //bit 6,(iy+d)
         0x7e,0x14,0x0c,0xd7,0x55,         //bit 7,(iy+d)
         0x86,0x14,0xb4,0xd0,0x55,         //res 0,(iy+d)
         0x8e,0x14,0xb4,0xd1,0x55,         //res 1,(iy+d)
         0x96,0x14,0xb4,0xd2,0x55,         //res 2,(iy+d)
         0x9e,0x14,0xb4,0xd3,0x55,         //res 3,(iy+d)
         0xa6,0x14,0xb4,0xd4,0x55,         //res 4,(iy+d)
         0xae,0x14,0xb4,0xd5,0x55,         //res 5,(iy+d)
         0xb6,0x14,0xb4,0xd6,0x55,         //res 6,(iy+d)
         0xbe,0x14,0xb4,0xd7,0x55,         //res 7,(iy+d)
         0xc6,0x14,0xfb,0xd0,0x55,         //set 0,(iy+d)
         0xce,0x14,0xfb,0xd1,0x55,         //set 1,(iy+d)
         0xd6,0x14,0xfb,0xd2,0x55,         //set 2,(iy+d)
         0xde,0x14,0xfb,0xd3,0x55,         //set 3,(iy+d)
         0xe6,0x14,0xfb,0xd4,0x55,         //set 4,(iy+d)
         0xee,0x14,0xfb,0xd5,0x55,         //set 5,(iy+d)
         0xf6,0x14,0xfb,0xd6,0x55,         //set 6,(iy+d)
         0xfe,0x14,0xfb,0xd7,0x55          //set 7,(iy+d)
         	};

unsigned char edset[291] = {
         58,
         0x40,0x12,0x54,0x62,0xe3,         //in b,(c)
         0x41,0x12,0x9d,0xe3,0x62,         //out (c),b
         0x42,0x12,0xf3,0x73,0x71,         //sbc hl,bc
         0x43,0x14,0x73,0x42,0x71,         //ld (nn),bc
         0x44,0x02,0x88,0x00,0x00,         //neg
         0x45,0x32,0xc1,0x00,0xb0,         //retn
         0x46,0x22,0x51,0xd0,0x00,         //im 0
         0x47,0x12,0x73,0x68,0x60,         //ld i,a
         0x48,0x12,0x54,0x63,0xe3,         //in c,(c)
         0x49,0x12,0x9d,0xe3,0x63,         //out (c),c
         0x4a,0x12,0x00,0x73,0x71,         //adc hl,bc
         0x4b,0x14,0x73,0x71,0x42,         //ld bc,(nn)
         0x4d,0x32,0xbc,0x00,0xb0,         //reti
         0x4f,0x12,0x73,0x69,0x60,         //ld r,a
         0x50,0x12,0x54,0x64,0xe3,         //in d,(c)
         0x51,0x12,0x9d,0xe3,0x64,         //out (c),d
         0x52,0x12,0xf3,0x73,0x72,         //sbc hl,de
         0x53,0x14,0x73,0x42,0x72,         //ld (nn),de
         0x56,0x22,0x51,0xd1,0x00,         //im 1
         0x57,0x12,0x73,0x60,0x68,         //ld a,i
         0x58,0x12,0x54,0x65,0xe3,         //in e,(c)
         0x59,0x12,0x9d,0xe3,0x65,         //out (c),e
         0x5a,0x12,0x00,0x73,0x72,         //adc hl,de
         0x5b,0x14,0x73,0x72,0x42,         //ld de,(nn)
         0x5e,0x22,0x51,0xd2,0x00,         //im 2
         0x5f,0x12,0x73,0x60,0x69,         //ld a,r
         0x60,0x12,0x54,0x66,0xe3,         //in h,(c)
         0x61,0x12,0x9d,0xe3,0x66,         //out (c),h
         0x62,0x12,0xf3,0x73,0x73,         //sbc hl,hl
         0x63,0x14,0x73,0x42,0x73,         //ld (nn),hl
         0x67,0x02,0xeb,0x00,0x00,         //rrd
         0x68,0x12,0x54,0x67,0xe3,         //in l,(c)
         0x69,0x12,0x9d,0xe3,0x67,         //out (c),l
         0x6a,0x12,0x00,0x73,0x73,         //adc hl,hl
         0x6b,0x14,0x73,0x73,0x42,         //ld hl,(nn)
         0x6f,0x02,0xd7,0x00,0x00,         //rld
         0x72,0x12,0xf3,0x73,0x76,         //sbc hl,sp
         0x73,0x14,0x73,0x42,0x76,         //ld (nn),sp
         0x78,0x12,0x54,0x60,0xe3,         //in a,(c)
         0x79,0x12,0x9d,0xe3,0x60,         //out (c),a
         0x7a,0x12,0x00,0x73,0x76,         //adc hl,sp
         0x7b,0x14,0x73,0x76,0x42,         //ld sp,(nn)
         0xa0,0x02,0x7f,0x00,0x00,         //ldi
         0xa1,0x02,0x25,0x00,0x00,         //cpi
         0xa2,0x02,0x64,0x00,0x00,         //ini
         0xa3,0x02,0xa6,0x00,0x00,         //outi
         0xa8,0x02,0x76,0x00,0x00,         //ldd
         0xa9,0x02,0x1c,0x00,0x00,         //cpd
         0xaa,0x02,0x5b,0x00,0x00,         //ind
         0xab,0x02,0xa1,0x00,0x00,         //outd
         0xb0,0x02,0x83,0x00,0x00,         //ldir
         0xb1,0x02,0x29,0x00,0x00,         //cpir
         0xb2,0x02,0x68,0x00,0x00,         //inir
         0xb3,0x02,0x98,0x00,0x00,         //otir
         0xb8,0x02,0x7a,0x00,0x00,         //lddr
         0xb9,0x02,0x20,0x00,0x00,         //cpdr
         0xba,0x02,0x5f,0x00,0x00,         //indr
         0xbb,0x02,0x93,0x00,0x00          //otdr
	         };
        //702 total instructions


char cctab[22] = {
        0,0,
        'C',0,
        'N','C',0,
        'Z',0,
        'N','Z',0,
        'P','O',0,
        'P','E',0,
        'P',0,
        'M',0
        	};


char regtab[62] = {
        'A',0,'F',0,'B',0,'C',0,'D',0,'E',0,'H',0,'L',0,
        'I',0,'R',0,0,0,'I','X','H',0,'I','X','L',0,'I','Y','H',0,'I','Y','L',0,
        'A','F',0,'B','C',0,'D','E',0,'H','L',0,'I','X',0,'I','Y',0,'S','P',0,'P','C',0
        	};


char mnutab[354] = {
        'A','D','C',0,'A','D','D',0,'A','N','D',0,'B','I','T',0,'C','A','L','L',0,
        'C','C','F',0,    //24d  18h
        'C','P',0,'C','P','D',0,'C','P','D','R',0,'C','P','I',0,'C','P','I','R',0,
        'C','P','L',0,    //49d  31h
        'D','A','A',0,'D','E','C',0,'D','I',0,'D','J','N','Z',0,'E','I',0,
        'E','X',0,       //71d  47h
        'E','X','X',0,'H','A','L','T',0,'I','M',0,'I','N',0,'I','N','C',0,
        'I','N','D',0,      //94d  5eh
        'I','N','D','R',0,'I','N','I',0,'I','N','I','R',0,'J','P',0,'J','R',0,
        'L','D',0,      //117d 75h
        'L','D','D',0,'L','D','D','R',0,'L','D','I',0,'L','D','I','R',0,
        'N','E','G',0,'N','O','P',0,   //143d 8fh
        'O','R',0,'O','T','D','R',0,'O','T','I','R',0,'O','U','T',0,
        'O','U','T','D',0,'O','U','T','I',0,  //170d aah
        'P','O','P',0,'P','U','S','H',0,'R','E','S',0,'R','E','T',0,
        'R','E','T','I',0,'R','E','T','N',0,  //197d c5h
        'R','O','L',0,'R','L','A',0,'R','L','C',0,'R','L','C','A',0,
        'R','L','D',0,'R','R',0,     //221d ddh
        'R','R','A',0,'R','R','C',0,'R','R','C','A',0,'R','R','D',0,
        'R','S','T',0,'S','B','C',0,    //246d f6h
        'S','C','F',0,'S','E','T',0,'S','L','A',0,'S','R','A',0,
        'S','R','L',0,'S','U','B',0,     //270d 10eh
        'X','O','R',0,'E','X',' ','A','F',',','A','F',0x27,0,'R','S','T',' ',
        '$','0',0,'R','S','T',' ','$','8',0,      //298d 12ah
        'R','S','T',' ','$','1','0',0,
        'R','S','T',' ','$','1','8',0,
        'R','S','T',' ','$','2','0',0,                 //142h 322
        'R','S','T',' ','$','2','8',0,
        'R','S','T',' ','$','3','0',0,
        'R','S','T',' ','$','3','8',0,
        '?','?','?',0,
        'R','L',0   //161h  353
			};

long disline(long addr, char* line)
{
    long i,j,l,op;
    unsigned char instrtab[4];
	char tempbuf[256];
    char buf2[256];
    bool validins=false;
    char* cptr;

    op = Z80_RDMEM(addr);
    if (op == 0xcb)
    {
    	op = Z80_RDMEM(addr+1);
        instrtab[0] = cbset[(op<<2)+0];
        instrtab[1] = cbset[(op<<2)+1];
        instrtab[2] = cbset[(op<<2)+2];
        instrtab[3] = cbset[(op<<2)+3];
        validins = true;
    }
    else if (op == 0xdd)
    {
    	op = Z80_RDMEM(addr+1);
        if (op == 0xcb)
        {
            op = Z80_RDMEM(addr+3);
        	j = ddcbset[0];
            i = 1;
			while ((j != 0) && (validins == false))
            {
            	if (ddcbset[i] == op)
                {
                    instrtab[0] = ddcbset[i+1];
                    instrtab[1] = ddcbset[i+2];
                    instrtab[2] = ddcbset[i+3];
                    instrtab[3] = ddcbset[i+4];
                	validins = true;
                }
                i += 5;
                --j;
            }
        }
        else
        {
            op = Z80_RDMEM(addr+1);
        	j = ddset[0];
            i = 1;
			while ((j != 0) && (validins == false))
            {
            	if (ddset[i] == op)
                {
                    instrtab[0] = ddset[i+1];
                    instrtab[1] = ddset[i+2];
                    instrtab[2] = ddset[i+3];
                    instrtab[3] = ddset[i+4];
                	validins = true;
                }
                i += 5;
                --j;
            }
        }
    }
    else if (op == 0xfd)
    {
    	op = Z80_RDMEM(addr+1);
        if (op == 0xcb)
        {
            op = Z80_RDMEM(addr+3);
        	j = fdcbset[0];
            i = 1;
			while ((j != 0) && (validins == false))
            {
            	if (fdcbset[i] == op)
                {
                    instrtab[0] = fdcbset[i+1];
                    instrtab[1] = fdcbset[i+2];
                    instrtab[2] = fdcbset[i+3];
                    instrtab[3] = fdcbset[i+4];
                	validins = true;
                }
                i += 5;
                --j;
            }
        }
        else
        {
            op = Z80_RDMEM(addr+1);
        	j = fdset[0];
            i = 1;
			while ((j != 0) && (validins == false))
            {
            	if (fdset[i] == op)
                {
                    instrtab[0] = fdset[i+1];
                    instrtab[1] = fdset[i+2];
                    instrtab[2] = fdset[i+3];
                    instrtab[3] = fdset[i+4];
                	validins = true;
                }
                i += 5;
                --j;
            }
        }
    }
    else if (op == 0xed)
    {
    	op = Z80_RDMEM(addr+1);
        j = edset[0];
        i = 1;
        while ((j != 0) && (validins == false))
        {
        	if (edset[i] == op)
            {
            	instrtab[0] = edset[i+1];
                instrtab[1] = edset[i+2];
                instrtab[2] = edset[i+3];
                instrtab[3] = edset[i+4];
				validins = true;
            }
            i += 5;
            --j;
        }
        
        if (validins == false)
        {
        	instrtab[0] = 1;
        }

    }
    else
    {
        instrtab[0] = normset[(op<<2)+0];
        instrtab[1] = normset[(op<<2)+1];
        instrtab[2] = normset[(op<<2)+2];
        instrtab[3] = normset[(op<<2)+3];
        validins = true;
    }

	if (validins)
    {
        l = instrtab[0]&0x0f;
        cptr = mnutab + ( (instrtab[0]&0x80)<<1) + instrtab[1];
        sprintf(tempbuf, "%s", cptr);
	    switch ( (instrtab[0]&0x30)>>4 )
        {
		    case 0:
	        	break;
		    case 1:
            	strcat(tempbuf, " ");
                if (instrtab[2] != 0x6a)
                {
	                getp(addr, tempbuf, instrtab[2]);
	                strcat(tempbuf, ",");
                }
                getp(addr, tempbuf, instrtab[3]);
	        	break;
		    case 2:
            	strcat(tempbuf, " ");
                getp(addr, tempbuf, instrtab[2]);
	        	break;
		    case 3:
            	strcat (tempbuf, " ");
				if (instrtab[2] > 0)
                {
					getcc(tempbuf, instrtab[2]);
                    if ( instrtab[3] != 0xb0) strcat(tempbuf, ",");
                }
                getp(addr, tempbuf, instrtab[3]);
	        	break;
        }
    }
    else
    {
    	strcpy(tempbuf, "???");
        l=1;
    }
    strcpy(line, "  ");
    sprintf(buf2, "%04x ", addr);
    strcat(line, buf2);
    for (i=0; i<l; ++i)
    {
    	sprintf(buf2, "%02x", Z80_RDMEM(i+addr));
        strcat(line, buf2);
	}
    j=4-l;
    for (i=0; i<j; ++i)
    {
    	strcat(line, "  ");
    }
   	strcat(line, " ");
	strcat(line, tempbuf);
    strupr(line);
    return(l);
}

//mode:  0=none
//       1=immediate
//       2=16bit immediate
//       3=8bit relative
//       4=extended (direct)
//       5=register indirect indexed (xx+n)
//       6=8bit register
//       7=16bit register
//       8=16bit register indirect
//       9=bit
//       a=zeropage
//       b=ret
//       c=pc relative (PC+e)
//       d=literal
//       e=8bit register indirect

void getp(long addr, char* tempbuf, long p)
{
    long a;
    char buf[32];

    a = p&0x0f;
	switch((p>>4)&0x0f)
    {
    	case 0:
	       	return;
        case 1:
            sprintf(buf, "$%02x", Z80_RDMEM(addr+a));
            strcat(tempbuf, buf);
        	return;
        case 2:
            sprintf(buf, "$%04x", (long)Z80_RDMEM(addr+a)+
             (long)((long)(Z80_RDMEM(addr+a+1))<<8));
            strcat(tempbuf, buf);
        	return;
        case 3:
        	return;
        case 4:
            sprintf(buf, "($%04x)", (long)Z80_RDMEM(addr+a)+
             (long)((long)(Z80_RDMEM(addr+a+1))<<8));
            strcat(tempbuf, buf);
        	return;
        case 5:
        	strcat(tempbuf, "(");
            getreg16(tempbuf, a);
            strcat(tempbuf, "+");
            sprintf(buf, "$%02x", Z80_RDMEM(addr+2));
            strcat(tempbuf, buf);
            strcat(tempbuf, ")");
        	return;
        case 6:
			getreg8(tempbuf, a);
        	return;
        case 7:
        	getreg16(tempbuf, a);
        	return;
        case 8:
            strcat(tempbuf, "(");
            getreg16(tempbuf, a);
            strcat(tempbuf, ")");
        	return;
        case 9:
        	return;
        case 10:
            strcat(tempbuf, "(");
            sprintf(buf, "$%02x", Z80_RDMEM(addr+a));
            strcat(tempbuf, buf);
            strcat(tempbuf, ")");
        	return;
        case 11:
        	return;
        case 12:
            sprintf(buf, "$%04x", addr+2+(char)Z80_RDMEM(addr+a));
            strcat(tempbuf, buf);
        	return;
        case 13:
        	sprintf(buf, "%01x", a);
            strcat(tempbuf, buf);
        	return;
        case 14:
            strcat(tempbuf, "(");
        	getreg8(tempbuf, a);
            strcat(tempbuf, ")");
        	return;
        case 15:
        	return;
    }
}

void getcc(char* tempbuf, long cc)
{
	switch (cc)
    {
    	case 0:
        	return;
        case 1:
        	strcat(tempbuf, "c");
            return;
        case 2:
        	strcat(tempbuf, "nc");
            return;
        case 3:
        	strcat(tempbuf, "z");
            return;
        case 4:
        	strcat(tempbuf, "nz");
            return;
        case 5:
        	strcat(tempbuf, "po");
			return;
        case 6:
        	strcat(tempbuf, "pe");
            return;
        case 7:
        	strcat(tempbuf, "p");
            return;
        case 8:
        	strcat(tempbuf, "m");
            return;
    }
}

void getreg8(char* tempbuf, long reg)
{
	char* cptr = regtab+(reg<<1);
	strcat(tempbuf, cptr);
}

void getreg16(char* tempbuf, long reg)
{
	char* cptr = regtab + 38 + (reg<<1)+reg;
    strcat(tempbuf, cptr);
}

// **************************************************************************
// EMULATOR CORE: THANKS MARCEL DE KOGEL, WORKS GREAT WITH ALMOST NO CHANGES!
// **************************************************************************
//
/*** Z80Em: Portable Z80 emulator *******************************************/
/***                                                                      ***/
/***                                 Z80.c                                ***/
/***                                                                      ***/
/*** This file contains the emulation code                                ***/
/***                                                                      ***/
/*** Copyright (C) Marcel de Kogel 1996,1997                              ***/
/***     You are not allowed to distribute this software commercially     ***/
/***     Please, notify me, if you make any changes to this file          ***/
/****************************************************************************/

//#include <stdio.h>
//#include <string.h>
//#include <stdlib.h>

//sssssssadd
//#include "Z80.h"

#define M_RDMEM(A)      Z80_RDMEM(A)
#define M_WRMEM(A,V)    Z80_WRMEM(A,V)
#define M_RDOP(A)       Z80_RDOP(A)
#define M_RDOP_ARG(A)   Z80_RDOP_ARG(A)
#define M_RDSTACK(A)    Z80_RDSTACK(A)
#define M_WRSTACK(A,V)  Z80_WRSTACK(A,V)

#define DoIn(lo,hi)     Z80_In((lo)+(((unsigned)(hi))<<8))
#define DoOut(lo,hi,v)  Z80_Out((lo)+(((unsigned)(hi))<<8),v)

static void Interrupt(int j);
static void ei(void);

#define S_FLAG          0x80
#define Z_FLAG          0x40
#define H_FLAG          0x10
#define V_FLAG          0x04
#define N_FLAG          0x02
#define C_FLAG          0x01

#define M_SKIP_CALL     R.PC.W.l+=2
#define M_SKIP_JP       R.PC.W.l+=2
#define M_SKIP_JR       R.PC.W.l+=1
#define M_SKIP_RET


//sssssmovetotop
//static Z80_Regs R;
//int Z80_Running=1;
//int Z80_IPeriod=50000;
//int Z80_ICount=50000;

//sssssssaddd

#ifdef DEBUG
int Z80_Trace=0;
int Z80_Trap=-1;
#endif
#ifdef TRACE
static unsigned pc_trace[256];
static unsigned pc_count=0;
#endif

static byte PTable[512];
static byte ZSTable[512];
static byte ZSPTable[512];
#include "Z80DAA.h"

typedef void (*opcode_fn) (void);

#define M_C     (R.AF.B.l&C_FLAG)
#define M_NC    (!M_C)
#define M_Z     (R.AF.B.l&Z_FLAG)
#define M_NZ    (!M_Z)
#define M_M     (R.AF.B.l&S_FLAG)
#define M_P     (!M_M)
#define M_PE    (R.AF.B.l&V_FLAG)
#define M_PO    (!M_PE)

/* Get next opcode argument and increment program counter */
INLINE unsigned M_RDMEM_OPCODE (void)
{
 unsigned retval;
 retval=M_RDOP_ARG(R.PC.D);
 R.PC.W.l++;
 return retval;
}

INLINE unsigned M_RDMEM_WORD (dword A)
{
 int i;
 i=M_RDMEM(A);
 i+=M_RDMEM(((A)+1)&0xFFFF)<<8;
 return i;
}

INLINE void M_WRMEM_WORD (dword A,word V)
{
 M_WRMEM (A,V&255);
 M_WRMEM (((A)+1)&0xFFFF,V>>8);
}

INLINE unsigned M_RDMEM_OPCODE_WORD (void)
{
 int i;
 i=M_RDMEM_OPCODE();
 i+=M_RDMEM_OPCODE()<<8;
 return i;
}

#define M_XIX       ((R.IX.D+(offset)M_RDMEM_OPCODE())&0xFFFF)
#define M_XIY       ((R.IY.D+(offset)M_RDMEM_OPCODE())&0xFFFF)
#define M_RD_XHL    M_RDMEM(R.HL.D)
INLINE unsigned M_RD_XIX(void)
{
 int i;
 i=M_XIX;
 return M_RDMEM(i);
}
INLINE unsigned M_RD_XIY(void)
{
 int i;
 i=M_XIY;
 return M_RDMEM(i);
}
INLINE void M_WR_XIX(byte a)
{
 int i;
 i=M_XIX;
 M_WRMEM(i,a);
}
INLINE void M_WR_XIY(byte a)
{
 int i;
 i=M_XIY;
 M_WRMEM(i,a);
}

#ifdef X86_ASM
#include "Z80CDx86.h"
#else
#include "Z80Codes.h"
#endif

static void adc_a_xhl(void) { byte i=M_RD_XHL; M_ADC(i); }
static void adc_a_xix(void) { byte i=M_RD_XIX(); M_ADC(i); }
static void adc_a_xiy(void) { byte i=M_RD_XIY(); M_ADC(i); }
static void adc_a_a(void) { M_ADC(R.AF.B.h); }
static void adc_a_b(void) { M_ADC(R.BC.B.h); }
static void adc_a_c(void) { M_ADC(R.BC.B.l); }
static void adc_a_d(void) { M_ADC(R.DE.B.h); }
static void adc_a_e(void) { M_ADC(R.DE.B.l); }
static void adc_a_h(void) { M_ADC(R.HL.B.h); }
static void adc_a_l(void) { M_ADC(R.HL.B.l); }
static void adc_a_ixl(void) { M_ADC(R.IX.B.l); }
static void adc_a_ixh(void) { M_ADC(R.IX.B.h); }
static void adc_a_iyl(void) { M_ADC(R.IY.B.l); }
static void adc_a_iyh(void) { M_ADC(R.IY.B.h); }
static void adc_a_byte(void) { byte i=M_RDMEM_OPCODE(); M_ADC(i); }

static void adc_hl_bc(void) { M_ADCW(BC); }
static void adc_hl_de(void) { M_ADCW(DE); }
static void adc_hl_hl(void) { M_ADCW(HL); }
static void adc_hl_sp(void) { M_ADCW(SP); }

static void add_a_xhl(void) { byte i=M_RD_XHL; M_ADD(i); }
static void add_a_xix(void) { byte i=M_RD_XIX(); M_ADD(i); }
static void add_a_xiy(void) { byte i=M_RD_XIY(); M_ADD(i); }
static void add_a_a(void) { M_ADD(R.AF.B.h); }
static void add_a_b(void) { M_ADD(R.BC.B.h); }
static void add_a_c(void) { M_ADD(R.BC.B.l); }
static void add_a_d(void) { M_ADD(R.DE.B.h); }
static void add_a_e(void) { M_ADD(R.DE.B.l); }
static void add_a_h(void) { M_ADD(R.HL.B.h); }
static void add_a_l(void) { M_ADD(R.HL.B.l); }
static void add_a_ixl(void) { M_ADD(R.IX.B.l); }
static void add_a_ixh(void) { M_ADD(R.IX.B.h); }
static void add_a_iyl(void) { M_ADD(R.IY.B.l); }
static void add_a_iyh(void) { M_ADD(R.IY.B.h); }
static void add_a_byte(void) { byte i=M_RDMEM_OPCODE(); M_ADD(i); }

static void add_hl_bc(void) { M_ADDW(HL,BC); }
static void add_hl_de(void) { M_ADDW(HL,DE); }
static void add_hl_hl(void) { M_ADDW(HL,HL); }
static void add_hl_sp(void) { M_ADDW(HL,SP); }
static void add_ix_bc(void) { M_ADDW(IX,BC); }
static void add_ix_de(void) { M_ADDW(IX,DE); }
static void add_ix_ix(void) { M_ADDW(IX,IX); }
static void add_ix_sp(void) { M_ADDW(IX,SP); }
static void add_iy_bc(void) { M_ADDW(IY,BC); }
static void add_iy_de(void) { M_ADDW(IY,DE); }
static void add_iy_iy(void) { M_ADDW(IY,IY); }
static void add_iy_sp(void) { M_ADDW(IY,SP); }

static void and_xhl(void) { byte i=M_RD_XHL; M_AND(i); }
static void and_xix(void) { byte i=M_RD_XIX(); M_AND(i); }
static void and_xiy(void) { byte i=M_RD_XIY(); M_AND(i); }
static void and_a(void) { R.AF.B.l=ZSPTable[R.AF.B.h]|H_FLAG; }
static void and_b(void) { M_AND(R.BC.B.h); }
static void and_c(void) { M_AND(R.BC.B.l); }
static void and_d(void) { M_AND(R.DE.B.h); }
static void and_e(void) { M_AND(R.DE.B.l); }
static void and_h(void) { M_AND(R.HL.B.h); }
static void and_l(void) { M_AND(R.HL.B.l); }
static void and_ixh(void) { M_AND(R.IX.B.h); }
static void and_ixl(void) { M_AND(R.IX.B.l); }
static void and_iyh(void) { M_AND(R.IY.B.h); }
static void and_iyl(void) { M_AND(R.IY.B.l); }
static void and_byte(void) { byte i=M_RDMEM_OPCODE(); M_AND(i); }

static void bit_0_xhl(void) { byte i=M_RD_XHL; M_BIT(0,i); }
static void bit_0_xix(void) { byte i=M_RD_XIX(); M_BIT(0,i); }
static void bit_0_xiy(void) { byte i=M_RD_XIY(); M_BIT(0,i); }
static void bit_0_a(void) { M_BIT(0,R.AF.B.h); }
static void bit_0_b(void) { M_BIT(0,R.BC.B.h); }
static void bit_0_c(void) { M_BIT(0,R.BC.B.l); }
static void bit_0_d(void) { M_BIT(0,R.DE.B.h); }
static void bit_0_e(void) { M_BIT(0,R.DE.B.l); }
static void bit_0_h(void) { M_BIT(0,R.HL.B.h); }
static void bit_0_l(void) { M_BIT(0,R.HL.B.l); }

static void bit_1_xhl(void) { byte i=M_RD_XHL; M_BIT(1,i); }
static void bit_1_xix(void) { byte i=M_RD_XIX(); M_BIT(1,i); }
static void bit_1_xiy(void) { byte i=M_RD_XIY(); M_BIT(1,i); }
static void bit_1_a(void) { M_BIT(1,R.AF.B.h); }
static void bit_1_b(void) { M_BIT(1,R.BC.B.h); }
static void bit_1_c(void) { M_BIT(1,R.BC.B.l); }
static void bit_1_d(void) { M_BIT(1,R.DE.B.h); }
static void bit_1_e(void) { M_BIT(1,R.DE.B.l); }
static void bit_1_h(void) { M_BIT(1,R.HL.B.h); }
static void bit_1_l(void) { M_BIT(1,R.HL.B.l); }

static void bit_2_xhl(void) { byte i=M_RD_XHL; M_BIT(2,i); }
static void bit_2_xix(void) { byte i=M_RD_XIX(); M_BIT(2,i); }
static void bit_2_xiy(void) { byte i=M_RD_XIY(); M_BIT(2,i); }
static void bit_2_a(void) { M_BIT(2,R.AF.B.h); }
static void bit_2_b(void) { M_BIT(2,R.BC.B.h); }
static void bit_2_c(void) { M_BIT(2,R.BC.B.l); }
static void bit_2_d(void) { M_BIT(2,R.DE.B.h); }
static void bit_2_e(void) { M_BIT(2,R.DE.B.l); }
static void bit_2_h(void) { M_BIT(2,R.HL.B.h); }
static void bit_2_l(void) { M_BIT(2,R.HL.B.l); }

static void bit_3_xhl(void) { byte i=M_RD_XHL; M_BIT(3,i); }
static void bit_3_xix(void) { byte i=M_RD_XIX(); M_BIT(3,i); }
static void bit_3_xiy(void) { byte i=M_RD_XIY(); M_BIT(3,i); }
static void bit_3_a(void) { M_BIT(3,R.AF.B.h); }
static void bit_3_b(void) { M_BIT(3,R.BC.B.h); }
static void bit_3_c(void) { M_BIT(3,R.BC.B.l); }
static void bit_3_d(void) { M_BIT(3,R.DE.B.h); }
static void bit_3_e(void) { M_BIT(3,R.DE.B.l); }
static void bit_3_h(void) { M_BIT(3,R.HL.B.h); }
static void bit_3_l(void) { M_BIT(3,R.HL.B.l); }

static void bit_4_xhl(void) { byte i=M_RD_XHL; M_BIT(4,i); }
static void bit_4_xix(void) { byte i=M_RD_XIX(); M_BIT(4,i); }
static void bit_4_xiy(void) { byte i=M_RD_XIY(); M_BIT(4,i); }
static void bit_4_a(void) { M_BIT(4,R.AF.B.h); }
static void bit_4_b(void) { M_BIT(4,R.BC.B.h); }
static void bit_4_c(void) { M_BIT(4,R.BC.B.l); }
static void bit_4_d(void) { M_BIT(4,R.DE.B.h); }
static void bit_4_e(void) { M_BIT(4,R.DE.B.l); }
static void bit_4_h(void) { M_BIT(4,R.HL.B.h); }
static void bit_4_l(void) { M_BIT(4,R.HL.B.l); }

static void bit_5_xhl(void) { byte i=M_RD_XHL; M_BIT(5,i); }
static void bit_5_xix(void) { byte i=M_RD_XIX(); M_BIT(5,i); }
static void bit_5_xiy(void) { byte i=M_RD_XIY(); M_BIT(5,i); }
static void bit_5_a(void) { M_BIT(5,R.AF.B.h); }
static void bit_5_b(void) { M_BIT(5,R.BC.B.h); }
static void bit_5_c(void) { M_BIT(5,R.BC.B.l); }
static void bit_5_d(void) { M_BIT(5,R.DE.B.h); }
static void bit_5_e(void) { M_BIT(5,R.DE.B.l); }
static void bit_5_h(void) { M_BIT(5,R.HL.B.h); }
static void bit_5_l(void) { M_BIT(5,R.HL.B.l); }

static void bit_6_xhl(void) { byte i=M_RD_XHL; M_BIT(6,i); }
static void bit_6_xix(void) { byte i=M_RD_XIX(); M_BIT(6,i); }
static void bit_6_xiy(void) { byte i=M_RD_XIY(); M_BIT(6,i); }
static void bit_6_a(void) { M_BIT(6,R.AF.B.h); }
static void bit_6_b(void) { M_BIT(6,R.BC.B.h); }
static void bit_6_c(void) { M_BIT(6,R.BC.B.l); }
static void bit_6_d(void) { M_BIT(6,R.DE.B.h); }
static void bit_6_e(void) { M_BIT(6,R.DE.B.l); }
static void bit_6_h(void) { M_BIT(6,R.HL.B.h); }
static void bit_6_l(void) { M_BIT(6,R.HL.B.l); }

static void bit_7_xhl(void) { byte i=M_RD_XHL; M_BIT(7,i); }
static void bit_7_xix(void) { byte i=M_RD_XIX(); M_BIT(7,i); }
static void bit_7_xiy(void) { byte i=M_RD_XIY(); M_BIT(7,i); }
static void bit_7_a(void) { M_BIT(7,R.AF.B.h); }
static void bit_7_b(void) { M_BIT(7,R.BC.B.h); }
static void bit_7_c(void) { M_BIT(7,R.BC.B.l); }
static void bit_7_d(void) { M_BIT(7,R.DE.B.h); }
static void bit_7_e(void) { M_BIT(7,R.DE.B.l); }
static void bit_7_h(void) { M_BIT(7,R.HL.B.h); }
static void bit_7_l(void) { M_BIT(7,R.HL.B.l); }

static void call_c(void) { if (M_C) { M_CALL; } else { M_SKIP_CALL; } }
static void call_m(void) { if (M_M) { M_CALL; } else { M_SKIP_CALL; } }
static void call_nc(void) { if (M_NC) { M_CALL; } else { M_SKIP_CALL; } }
static void call_nz(void) { if (M_NZ) { M_CALL; } else { M_SKIP_CALL; } }
static void call_p(void) { if (M_P) { M_CALL; } else { M_SKIP_CALL; } }
static void call_pe(void) { if (M_PE) { M_CALL; } else { M_SKIP_CALL; } }
static void call_po(void) { if (M_PO) { M_CALL; } else { M_SKIP_CALL; } }
static void call_z(void) { if (M_Z) { M_CALL; } else { M_SKIP_CALL; } }
static void call(void) { M_CALL; }

static void ccf(void) { R.AF.B.l=((R.AF.B.l&0xED)|((R.AF.B.l&1)<<4))^1; }

static void cp_xhl(void) { byte i=M_RD_XHL; M_CP(i); }
static void cp_xix(void) { byte i=M_RD_XIX(); M_CP(i); }
static void cp_xiy(void) { byte i=M_RD_XIY(); M_CP(i); }
static void cp_a(void) { M_CP(R.AF.B.h); }
static void cp_b(void) { M_CP(R.BC.B.h); }
static void cp_c(void) { M_CP(R.BC.B.l); }
static void cp_d(void) { M_CP(R.DE.B.h); }
static void cp_e(void) { M_CP(R.DE.B.l); }
static void cp_h(void) { M_CP(R.HL.B.h); }
static void cp_l(void) { M_CP(R.HL.B.l); }
static void cp_ixh(void) { M_CP(R.IX.B.h); }
static void cp_ixl(void) { M_CP(R.IX.B.l); }
static void cp_iyh(void) { M_CP(R.IY.B.h); }
static void cp_iyl(void) { M_CP(R.IY.B.l); }
static void cp_byte(void) { byte i=M_RDMEM_OPCODE(); M_CP(i); }

static void cpd(void)
{
 byte i,j;
 i=M_RDMEM(R.HL.D);
 j=R.AF.B.h-i;
 --R.HL.W.l;
 --R.BC.W.l;
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSTable[j]|
          ((R.AF.B.h^i^j)&H_FLAG)|(R.BC.D? V_FLAG:0)|N_FLAG;
}

static void cpdr(void)
{
 cpd ();
 if (R.BC.D && !(R.AF.B.l&Z_FLAG)) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void cpi(void)
{
 byte i,j;
 i=M_RDMEM(R.HL.D);
 j=R.AF.B.h-i;
 ++R.HL.W.l;
 --R.BC.W.l;
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSTable[j]|
          ((R.AF.B.h^i^j)&H_FLAG)|(R.BC.D? V_FLAG:0)|N_FLAG;
}

static void cpir(void)
{
 cpi ();
 if (R.BC.D && !(R.AF.B.l&Z_FLAG)) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void cpl(void) { R.AF.B.h^=0xFF; R.AF.B.l|=(H_FLAG|N_FLAG); }

static void daa(void)
{
 int i;
 i=R.AF.B.h;
 if (R.AF.B.l&C_FLAG) i|=256;
 if (R.AF.B.l&H_FLAG) i|=512;
 if (R.AF.B.l&N_FLAG) i|=1024;
 R.AF.W.l=DAATable[i];
};

static void dec_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_DEC(i);
 M_WRMEM(R.HL.D,i);
}
static void dec_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_DEC(i);
 M_WRMEM(j,i);
}
static void dec_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_DEC(i);
 M_WRMEM(j,i);
}
static void dec_a(void) { M_DEC(R.AF.B.h); }
static void dec_b(void) { M_DEC(R.BC.B.h); }
static void dec_c(void) { M_DEC(R.BC.B.l); }
static void dec_d(void) { M_DEC(R.DE.B.h); }
static void dec_e(void) { M_DEC(R.DE.B.l); }
static void dec_h(void) { M_DEC(R.HL.B.h); }
static void dec_l(void) { M_DEC(R.HL.B.l); }
static void dec_ixh(void) { M_DEC(R.IX.B.h); }
static void dec_ixl(void) { M_DEC(R.IX.B.l); }
static void dec_iyh(void) { M_DEC(R.IY.B.h); }
static void dec_iyl(void) { M_DEC(R.IY.B.l); }

static void dec_bc(void) { --R.BC.W.l; }
static void dec_de(void) { --R.DE.W.l; }
static void dec_hl(void) { --R.HL.W.l; }
static void dec_ix(void) { --R.IX.W.l; }
static void dec_iy(void) { --R.IY.W.l; }
static void dec_sp(void) { --R.SP.W.l; }

static void di(void) { R.IFF1=R.IFF2=0; }

static void djnz(void) { if (--R.BC.B.h) { M_JR; } else { M_SKIP_JR; } }

static void ex_xsp_hl(void)
{
 int i;
 i=M_RDMEM_WORD(R.SP.D);
 M_WRMEM_WORD(R.SP.D,R.HL.D);
 R.HL.D=i;
}

static void ex_xsp_ix(void)
{
 int i;
 i=M_RDMEM_WORD(R.SP.D);
 M_WRMEM_WORD(R.SP.D,R.IX.D);
 R.IX.D=i;
}

static void ex_xsp_iy(void)
{
 int i;
 i=M_RDMEM_WORD(R.SP.D);
 M_WRMEM_WORD(R.SP.D,R.IY.D);
 R.IY.D=i;
}

static void ex_af_af(void)
{
 int i;
 i=R.AF.D;
 R.AF.D=R.AF2.D;
 R.AF2.D=i;
}

static void ex_de_hl(void)
{
 int i;
 i=R.DE.D;
 R.DE.D=R.HL.D;
 R.HL.D=i;
}

static void exx(void)
{
 int i;
 i=R.BC.D;
 R.BC.D=R.BC2.D;
 R.BC2.D=i;
 i=R.DE.D;
 R.DE.D=R.DE2.D;
 R.DE2.D=i;
 i=R.HL.D;
 R.HL.D=R.HL2.D;
 R.HL2.D=i;
}

static void halt(void)
{
 --R.PC.W.l;
 R.HALT=1;
 if (Z80_ICount>0) Z80_ICount=0;
}

static void im_0(void) { R.IM=0; }
static void im_1(void) { R.IM=1; }
static void im_2(void) { R.IM=2; }

static void in_a_c(void) { M_IN(R.AF.B.h); }
static void in_b_c(void) { M_IN(R.BC.B.h); }
static void in_c_c(void) { M_IN(R.BC.B.l); }
static void in_d_c(void) { M_IN(R.DE.B.h); }
static void in_e_c(void) { M_IN(R.DE.B.l); }
static void in_h_c(void) { M_IN(R.HL.B.h); }
static void in_l_c(void) { M_IN(R.HL.B.l); }
static void in_0_c(void) { byte i; M_IN(i); }

static void in_a_byte(void)
{
 byte i=M_RDMEM_OPCODE();
 R.AF.B.h=DoIn(i,R.AF.B.h);
}

static void inc_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_INC(i);
 M_WRMEM(R.HL.D,i);
}
static void inc_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_INC(i);
 M_WRMEM(j,i);
}
static void inc_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_INC(i);
 M_WRMEM(j,i);
}
static void inc_a(void) { M_INC(R.AF.B.h); }
static void inc_b(void) { M_INC(R.BC.B.h); }
static void inc_c(void) { M_INC(R.BC.B.l); }
static void inc_d(void) { M_INC(R.DE.B.h); }
static void inc_e(void) { M_INC(R.DE.B.l); }
static void inc_h(void) { M_INC(R.HL.B.h); }
static void inc_l(void) { M_INC(R.HL.B.l); }
static void inc_ixh(void) { M_INC(R.IX.B.h); }
static void inc_ixl(void) { M_INC(R.IX.B.l); }
static void inc_iyh(void) { M_INC(R.IY.B.h); }
static void inc_iyl(void) { M_INC(R.IY.B.l); }

static void inc_bc(void) { ++R.BC.W.l; }
static void inc_de(void) { ++R.DE.W.l; }
static void inc_hl(void) { ++R.HL.W.l; }
static void inc_ix(void) { ++R.IX.W.l; }
static void inc_iy(void) { ++R.IY.W.l; }
static void inc_sp(void) { ++R.SP.W.l; }

static void ind(void)
{
 --R.BC.B.h;
 M_WRMEM(R.HL.D,DoIn(R.BC.B.l,R.BC.B.h));
 --R.HL.W.l;
 R.AF.B.l=(R.BC.B.h)? N_FLAG:(N_FLAG|Z_FLAG);
}

static void indr(void)
{
 ind ();
 if (R.BC.B.h) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void ini(void)
{
 --R.BC.B.h;
 M_WRMEM(R.HL.D,DoIn(R.BC.B.l,R.BC.B.h));
 ++R.HL.W.l;
 R.AF.B.l=(R.BC.B.h)? N_FLAG:(N_FLAG|Z_FLAG);
}

static void inir(void)
{
 ini ();
 if (R.BC.B.h) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void jp(void) { M_JP; }
static void jp_hl(void) { R.PC.D=R.HL.D; }
static void jp_ix(void) { R.PC.D=R.IX.D; }
static void jp_iy(void) { R.PC.D=R.IY.D; }
static void jp_c(void) { if (M_C) { M_JP; } else { M_SKIP_JP; } }
static void jp_m(void) { if (M_M) { M_JP; } else { M_SKIP_JP; } }
static void jp_nc(void) { if (M_NC) { M_JP; } else { M_SKIP_JP; } }
static void jp_nz(void) { if (M_NZ) { M_JP; } else { M_SKIP_JP; } }
static void jp_p(void) { if (M_P) { M_JP; } else { M_SKIP_JP; } }
static void jp_pe(void) { if (M_PE) { M_JP; } else { M_SKIP_JP; } }
static void jp_po(void) { if (M_PO) { M_JP; } else { M_SKIP_JP; } }
static void jp_z(void) { if (M_Z) { M_JP; } else { M_SKIP_JP; } }

static void jr(void) { M_JR; }
static void jr_c(void) { if (M_C) { M_JR; } else { M_SKIP_JR; } }
static void jr_nc(void) { if (M_NC) { M_JR; } else { M_SKIP_JR; } }
static void jr_nz(void) { if (M_NZ) { M_JR; } else { M_SKIP_JR; } }
static void jr_z(void) { if (M_Z) { M_JR; } else { M_SKIP_JR; } }

static void ld_xbc_a(void) { M_WRMEM(R.BC.D,R.AF.B.h); }
static void ld_xde_a(void) { M_WRMEM(R.DE.D,R.AF.B.h); }
static void ld_xhl_a(void) { M_WRMEM(R.HL.D,R.AF.B.h); }
static void ld_xhl_b(void) { M_WRMEM(R.HL.D,R.BC.B.h); }
static void ld_xhl_c(void) { M_WRMEM(R.HL.D,R.BC.B.l); }
static void ld_xhl_d(void) { M_WRMEM(R.HL.D,R.DE.B.h); }
static void ld_xhl_e(void) { M_WRMEM(R.HL.D,R.DE.B.l); }
static void ld_xhl_h(void) { M_WRMEM(R.HL.D,R.HL.B.h); }
static void ld_xhl_l(void) { M_WRMEM(R.HL.D,R.HL.B.l); }
static void ld_xhl_byte(void) { byte i=M_RDMEM_OPCODE(); M_WRMEM(R.HL.D,i); }
static void ld_xix_a(void) { M_WR_XIX(R.AF.B.h); }
static void ld_xix_b(void) { M_WR_XIX(R.BC.B.h); }
static void ld_xix_c(void) { M_WR_XIX(R.BC.B.l); }
static void ld_xix_d(void) { M_WR_XIX(R.DE.B.h); }
static void ld_xix_e(void) { M_WR_XIX(R.DE.B.l); }
static void ld_xix_h(void) { M_WR_XIX(R.HL.B.h); }
static void ld_xix_l(void) { M_WR_XIX(R.HL.B.l); }
static void ld_xix_byte(void)
{
 int i,j;
 i=M_XIX;
 j=M_RDMEM_OPCODE();
 M_WRMEM(i,j);
}
static void ld_xiy_a(void) { M_WR_XIY(R.AF.B.h); }
static void ld_xiy_b(void) { M_WR_XIY(R.BC.B.h); }
static void ld_xiy_c(void) { M_WR_XIY(R.BC.B.l); }
static void ld_xiy_d(void) { M_WR_XIY(R.DE.B.h); }
static void ld_xiy_e(void) { M_WR_XIY(R.DE.B.l); }
static void ld_xiy_h(void) { M_WR_XIY(R.HL.B.h); }
static void ld_xiy_l(void) { M_WR_XIY(R.HL.B.l); }
static void ld_xiy_byte(void)
{
 int i,j;
 i=M_XIY;
 j=M_RDMEM_OPCODE();
 M_WRMEM(i,j);
}
static void ld_xbyte_a(void)
{ int i=M_RDMEM_OPCODE_WORD(); M_WRMEM(i,R.AF.B.h); }
static void ld_xword_bc(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.BC.D); }
static void ld_xword_de(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.DE.D); }
static void ld_xword_hl(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.HL.D); }
static void ld_xword_ix(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.IX.D); }
static void ld_xword_iy(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.IY.D); }
static void ld_xword_sp(void) { M_WRMEM_WORD(M_RDMEM_OPCODE_WORD(),R.SP.D); }
static void ld_a_xbc(void) { R.AF.B.h=M_RDMEM(R.BC.D); }
static void ld_a_xde(void) { R.AF.B.h=M_RDMEM(R.DE.D); }
static void ld_a_xhl(void) { R.AF.B.h=M_RD_XHL; }
static void ld_a_xix(void) { R.AF.B.h=M_RD_XIX(); }
static void ld_a_xiy(void) { R.AF.B.h=M_RD_XIY(); }
static void ld_a_xbyte(void)
{ int i=M_RDMEM_OPCODE_WORD(); R.AF.B.h=M_RDMEM(i); }

static void ld_a_byte(void) { R.AF.B.h=M_RDMEM_OPCODE(); }
static void ld_b_byte(void) { R.BC.B.h=M_RDMEM_OPCODE(); }
static void ld_c_byte(void) { R.BC.B.l=M_RDMEM_OPCODE(); }
static void ld_d_byte(void) { R.DE.B.h=M_RDMEM_OPCODE(); }
static void ld_e_byte(void) { R.DE.B.l=M_RDMEM_OPCODE(); }
static void ld_h_byte(void) { R.HL.B.h=M_RDMEM_OPCODE(); }
static void ld_l_byte(void) { R.HL.B.l=M_RDMEM_OPCODE(); }
static void ld_ixh_byte(void) { R.IX.B.h=M_RDMEM_OPCODE(); }
static void ld_ixl_byte(void) { R.IX.B.l=M_RDMEM_OPCODE(); }
static void ld_iyh_byte(void) { R.IY.B.h=M_RDMEM_OPCODE(); }
static void ld_iyl_byte(void) { R.IY.B.l=M_RDMEM_OPCODE(); }

static void ld_b_xhl(void) { R.BC.B.h=M_RD_XHL; }
static void ld_c_xhl(void) { R.BC.B.l=M_RD_XHL; }
static void ld_d_xhl(void) { R.DE.B.h=M_RD_XHL; }
static void ld_e_xhl(void) { R.DE.B.l=M_RD_XHL; }
static void ld_h_xhl(void) { R.HL.B.h=M_RD_XHL; }
static void ld_l_xhl(void) { R.HL.B.l=M_RD_XHL; }
static void ld_b_xix(void) { R.BC.B.h=M_RD_XIX(); }
static void ld_c_xix(void) { R.BC.B.l=M_RD_XIX(); }
static void ld_d_xix(void) { R.DE.B.h=M_RD_XIX(); }
static void ld_e_xix(void) { R.DE.B.l=M_RD_XIX(); }
static void ld_h_xix(void) { R.HL.B.h=M_RD_XIX(); }
static void ld_l_xix(void) { R.HL.B.l=M_RD_XIX(); }
static void ld_b_xiy(void) { R.BC.B.h=M_RD_XIY(); }
static void ld_c_xiy(void) { R.BC.B.l=M_RD_XIY(); }
static void ld_d_xiy(void) { R.DE.B.h=M_RD_XIY(); }
static void ld_e_xiy(void) { R.DE.B.l=M_RD_XIY(); }
static void ld_h_xiy(void) { R.HL.B.h=M_RD_XIY(); }
static void ld_l_xiy(void) { R.HL.B.l=M_RD_XIY(); }
static void ld_a_a(void) { }
static void ld_a_b(void) { R.AF.B.h=R.BC.B.h; }
static void ld_a_c(void) { R.AF.B.h=R.BC.B.l; }
static void ld_a_d(void) { R.AF.B.h=R.DE.B.h; }
static void ld_a_e(void) { R.AF.B.h=R.DE.B.l; }
static void ld_a_h(void) { R.AF.B.h=R.HL.B.h; }
static void ld_a_l(void) { R.AF.B.h=R.HL.B.l; }
static void ld_a_ixh(void) { R.AF.B.h=R.IX.B.h; }
static void ld_a_ixl(void) { R.AF.B.h=R.IX.B.l; }
static void ld_a_iyh(void) { R.AF.B.h=R.IY.B.h; }
static void ld_a_iyl(void) { R.AF.B.h=R.IY.B.l; }
static void ld_b_b(void) { }
static void ld_b_a(void) { R.BC.B.h=R.AF.B.h; }
static void ld_b_c(void) { R.BC.B.h=R.BC.B.l; }
static void ld_b_d(void) { R.BC.B.h=R.DE.B.h; }
static void ld_b_e(void) { R.BC.B.h=R.DE.B.l; }
static void ld_b_h(void) { R.BC.B.h=R.HL.B.h; }
static void ld_b_l(void) { R.BC.B.h=R.HL.B.l; }
static void ld_b_ixh(void) { R.BC.B.h=R.IX.B.h; }
static void ld_b_ixl(void) { R.BC.B.h=R.IX.B.l; }
static void ld_b_iyh(void) { R.BC.B.h=R.IY.B.h; }
static void ld_b_iyl(void) { R.BC.B.h=R.IY.B.l; }
static void ld_c_c(void) { }
static void ld_c_a(void) { R.BC.B.l=R.AF.B.h; }
static void ld_c_b(void) { R.BC.B.l=R.BC.B.h; }
static void ld_c_d(void) { R.BC.B.l=R.DE.B.h; }
static void ld_c_e(void) { R.BC.B.l=R.DE.B.l; }
static void ld_c_h(void) { R.BC.B.l=R.HL.B.h; }
static void ld_c_l(void) { R.BC.B.l=R.HL.B.l; }
static void ld_c_ixh(void) { R.BC.B.l=R.IX.B.h; }
static void ld_c_ixl(void) { R.BC.B.l=R.IX.B.l; }
static void ld_c_iyh(void) { R.BC.B.l=R.IY.B.h; }
static void ld_c_iyl(void) { R.BC.B.l=R.IY.B.l; }
static void ld_d_d(void) { }
static void ld_d_a(void) { R.DE.B.h=R.AF.B.h; }
static void ld_d_c(void) { R.DE.B.h=R.BC.B.l; }
static void ld_d_b(void) { R.DE.B.h=R.BC.B.h; }
static void ld_d_e(void) { R.DE.B.h=R.DE.B.l; }
static void ld_d_h(void) { R.DE.B.h=R.HL.B.h; }
static void ld_d_l(void) { R.DE.B.h=R.HL.B.l; }
static void ld_d_ixh(void) { R.DE.B.h=R.IX.B.h; }
static void ld_d_ixl(void) { R.DE.B.h=R.IX.B.l; }
static void ld_d_iyh(void) { R.DE.B.h=R.IY.B.h; }
static void ld_d_iyl(void) { R.DE.B.h=R.IY.B.l; }
static void ld_e_e(void) { }
static void ld_e_a(void) { R.DE.B.l=R.AF.B.h; }
static void ld_e_c(void) { R.DE.B.l=R.BC.B.l; }
static void ld_e_b(void) { R.DE.B.l=R.BC.B.h; }
static void ld_e_d(void) { R.DE.B.l=R.DE.B.h; }
static void ld_e_h(void) { R.DE.B.l=R.HL.B.h; }
static void ld_e_l(void) { R.DE.B.l=R.HL.B.l; }
static void ld_e_ixh(void) { R.DE.B.l=R.IX.B.h; }
static void ld_e_ixl(void) { R.DE.B.l=R.IX.B.l; }
static void ld_e_iyh(void) { R.DE.B.l=R.IY.B.h; }
static void ld_e_iyl(void) { R.DE.B.l=R.IY.B.l; }
static void ld_h_h(void) { }
static void ld_h_a(void) { R.HL.B.h=R.AF.B.h; }
static void ld_h_c(void) { R.HL.B.h=R.BC.B.l; }
static void ld_h_b(void) { R.HL.B.h=R.BC.B.h; }
static void ld_h_e(void) { R.HL.B.h=R.DE.B.l; }
static void ld_h_d(void) { R.HL.B.h=R.DE.B.h; }
static void ld_h_l(void) { R.HL.B.h=R.HL.B.l; }
static void ld_l_l(void) { }
static void ld_l_a(void) { R.HL.B.l=R.AF.B.h; }
static void ld_l_c(void) { R.HL.B.l=R.BC.B.l; }
static void ld_l_b(void) { R.HL.B.l=R.BC.B.h; }
static void ld_l_e(void) { R.HL.B.l=R.DE.B.l; }
static void ld_l_d(void) { R.HL.B.l=R.DE.B.h; }
static void ld_l_h(void) { R.HL.B.l=R.HL.B.h; }
static void ld_ixh_a(void) { R.IX.B.h=R.AF.B.h; }
static void ld_ixh_b(void) { R.IX.B.h=R.BC.B.h; }
static void ld_ixh_c(void) { R.IX.B.h=R.BC.B.l; }
static void ld_ixh_d(void) { R.IX.B.h=R.DE.B.h; }
static void ld_ixh_e(void) { R.IX.B.h=R.DE.B.l; }
static void ld_ixh_ixh(void) { }
static void ld_ixh_ixl(void) { R.IX.B.h=R.IX.B.l; }
static void ld_ixl_a(void) { R.IX.B.l=R.AF.B.h; }
static void ld_ixl_b(void) { R.IX.B.l=R.BC.B.h; }
static void ld_ixl_c(void) { R.IX.B.l=R.BC.B.l; }
static void ld_ixl_d(void) { R.IX.B.l=R.DE.B.h; }
static void ld_ixl_e(void) { R.IX.B.l=R.DE.B.l; }
static void ld_ixl_ixh(void) { R.IX.B.l=R.IX.B.h; }
static void ld_ixl_ixl(void) { }
static void ld_iyh_a(void) { R.IY.B.h=R.AF.B.h; }
static void ld_iyh_b(void) { R.IY.B.h=R.BC.B.h; }
static void ld_iyh_c(void) { R.IY.B.h=R.BC.B.l; }
static void ld_iyh_d(void) { R.IY.B.h=R.DE.B.h; }
static void ld_iyh_e(void) { R.IY.B.h=R.DE.B.l; }
static void ld_iyh_iyh(void) { }
static void ld_iyh_iyl(void) { R.IY.B.h=R.IY.B.l; }
static void ld_iyl_a(void) { R.IY.B.l=R.AF.B.h; }
static void ld_iyl_b(void) { R.IY.B.l=R.BC.B.h; }
static void ld_iyl_c(void) { R.IY.B.l=R.BC.B.l; }
static void ld_iyl_d(void) { R.IY.B.l=R.DE.B.h; }
static void ld_iyl_e(void) { R.IY.B.l=R.DE.B.l; }
static void ld_iyl_iyh(void) { R.IY.B.l=R.IY.B.h; }
static void ld_iyl_iyl(void) { }
static void ld_bc_xword(void) { R.BC.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_bc_word(void) { R.BC.D=M_RDMEM_OPCODE_WORD(); }
static void ld_de_xword(void) { R.DE.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_de_word(void) { R.DE.D=M_RDMEM_OPCODE_WORD(); }
static void ld_hl_xword(void) { R.HL.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_hl_word(void) { R.HL.D=M_RDMEM_OPCODE_WORD(); }
static void ld_ix_xword(void) { R.IX.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_ix_word(void) { R.IX.D=M_RDMEM_OPCODE_WORD(); }
static void ld_iy_xword(void) { R.IY.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_iy_word(void) { R.IY.D=M_RDMEM_OPCODE_WORD(); }
static void ld_sp_xword(void) { R.SP.D=M_RDMEM_WORD(M_RDMEM_OPCODE_WORD()); }
static void ld_sp_word(void) { R.SP.D=M_RDMEM_OPCODE_WORD(); }
static void ld_sp_hl(void) { R.SP.D=R.HL.D; }
static void ld_sp_ix(void) { R.SP.D=R.IX.D; }
static void ld_sp_iy(void) { R.SP.D=R.IY.D; }
static void ld_a_i(void)
{
 R.AF.B.h=R.I;
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSTable[R.I]|(R.IFF2<<2);
}
static void ld_i_a(void) { R.I=R.AF.B.h; }
static void ld_a_r(void)
{
 R.AF.B.h=(R.R&127)|(R.R2&128);
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSTable[R.AF.B.h]|(R.IFF2<<2);
}
static void ld_r_a(void) { R.R=R.R2=R.AF.B.h; }

static void ldd(void)
{
 M_WRMEM(R.DE.D,M_RDMEM(R.HL.D));
 --R.DE.W.l;
 --R.HL.W.l;
 --R.BC.W.l;
 R.AF.B.l=(R.AF.B.l&0xE9)|(R.BC.D? V_FLAG:0);
}
static void lddr(void)
{
 ldd ();
 if (R.BC.D) { Z80_ICount-=5; R.PC.W.l-=2; }
}
static void ldi(void)
{
 M_WRMEM(R.DE.D,M_RDMEM(R.HL.D));
 ++R.DE.W.l;
 ++R.HL.W.l;
 --R.BC.W.l;
 R.AF.B.l=(R.AF.B.l&0xE9)|(R.BC.D? V_FLAG:0);
}
static void ldir(void)
{
 ldi ();
 if (R.BC.D) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void neg(void)
{
 byte i;
 i=R.AF.B.h;
 R.AF.B.h=0;
 M_SUB(i);
}

static void nop(void) { };

static void or_xhl(void) { byte i=M_RD_XHL; M_OR(i); }
static void or_xix(void) { byte i=M_RD_XIX(); M_OR(i); }
static void or_xiy(void) { byte i=M_RD_XIY(); M_OR(i); }
static void or_a(void) { R.AF.B.l=ZSPTable[R.AF.B.h]; }
static void or_b(void) { M_OR(R.BC.B.h); }
static void or_c(void) { M_OR(R.BC.B.l); }
static void or_d(void) { M_OR(R.DE.B.h); }
static void or_e(void) { M_OR(R.DE.B.l); }
static void or_h(void) { M_OR(R.HL.B.h); }
static void or_l(void) { M_OR(R.HL.B.l); }
static void or_ixh(void) { M_OR(R.IX.B.h); }
static void or_ixl(void) { M_OR(R.IX.B.l); }
static void or_iyh(void) { M_OR(R.IY.B.h); }
static void or_iyl(void) { M_OR(R.IY.B.l); }
static void or_byte(void) { byte i=M_RDMEM_OPCODE(); M_OR(i); }

static void outd(void)
{
 --R.BC.B.h;
 DoOut (R.BC.B.l,R.BC.B.h,M_RDMEM(R.HL.D));
 --R.HL.W.l;
 R.AF.B.l=(R.BC.B.h)? N_FLAG:(Z_FLAG|N_FLAG);
}
static void otdr(void)
{
 outd ();
 if (R.BC.B.h) { Z80_ICount-=5; R.PC.W.l-=2; }
}
static void outi(void)
{
 --R.BC.B.h;
 DoOut (R.BC.B.l,R.BC.B.h,M_RDMEM(R.HL.D));
 ++R.HL.W.l;
 R.AF.B.l=(R.BC.B.h)? N_FLAG:(Z_FLAG|N_FLAG);
}
static void otir(void)
{
 outi ();
 if (R.BC.B.h) { Z80_ICount-=5; R.PC.W.l-=2; }
}

static void out_c_a(void) { DoOut(R.BC.B.l,R.BC.B.h,R.AF.B.h); }
static void out_c_b(void) { DoOut(R.BC.B.l,R.BC.B.h,R.BC.B.h); }
static void out_c_c(void) { DoOut(R.BC.B.l,R.BC.B.h,R.BC.B.l); }
static void out_c_d(void) { DoOut(R.BC.B.l,R.BC.B.h,R.DE.B.h); }
static void out_c_e(void) { DoOut(R.BC.B.l,R.BC.B.h,R.DE.B.l); }
static void out_c_h(void) { DoOut(R.BC.B.l,R.BC.B.h,R.HL.B.h); }
static void out_c_l(void) { DoOut(R.BC.B.l,R.BC.B.h,R.HL.B.l); }
static void out_c_0(void) { DoOut(R.BC.B.l,R.BC.B.h,0); }
static void out_byte_a(void)
{
 byte i=M_RDMEM_OPCODE();
 DoOut(i,R.AF.B.h,R.AF.B.h);
}

static void pop_af(void) { M_POP(AF); }
static void pop_bc(void) { M_POP(BC); }
static void pop_de(void) { M_POP(DE); }
static void pop_hl(void) { M_POP(HL); }
static void pop_ix(void) { M_POP(IX); }
static void pop_iy(void) { M_POP(IY); }

static void push_af(void) { M_PUSH(AF); }
static void push_bc(void) { M_PUSH(BC); }
static void push_de(void) { M_PUSH(DE); }
static void push_hl(void) { M_PUSH(HL); }
static void push_ix(void) { M_PUSH(IX); }
static void push_iy(void) { M_PUSH(IY); }

static void res_0_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(0,i);
 M_WRMEM(R.HL.D,i);
};
static void res_0_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(0,i);
 M_WRMEM(j,i);
};
static void res_0_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(0,i);
 M_WRMEM(j,i);
};
static void res_0_a(void) { M_RES(0,R.AF.B.h); };
static void res_0_b(void) { M_RES(0,R.BC.B.h); };
static void res_0_c(void) { M_RES(0,R.BC.B.l); };
static void res_0_d(void) { M_RES(0,R.DE.B.h); };
static void res_0_e(void) { M_RES(0,R.DE.B.l); };
static void res_0_h(void) { M_RES(0,R.HL.B.h); };
static void res_0_l(void) { M_RES(0,R.HL.B.l); };

static void res_1_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(1,i);
 M_WRMEM(R.HL.D,i);
};
static void res_1_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(1,i);
 M_WRMEM(j,i);
};
static void res_1_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(1,i);
 M_WRMEM(j,i);
};
static void res_1_a(void) { M_RES(1,R.AF.B.h); };
static void res_1_b(void) { M_RES(1,R.BC.B.h); };
static void res_1_c(void) { M_RES(1,R.BC.B.l); };
static void res_1_d(void) { M_RES(1,R.DE.B.h); };
static void res_1_e(void) { M_RES(1,R.DE.B.l); };
static void res_1_h(void) { M_RES(1,R.HL.B.h); };
static void res_1_l(void) { M_RES(1,R.HL.B.l); };

static void res_2_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(2,i);
 M_WRMEM(R.HL.D,i);
};
static void res_2_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(2,i);
 M_WRMEM(j,i);
};
static void res_2_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(2,i);
 M_WRMEM(j,i);
};
static void res_2_a(void) { M_RES(2,R.AF.B.h); };
static void res_2_b(void) { M_RES(2,R.BC.B.h); };
static void res_2_c(void) { M_RES(2,R.BC.B.l); };
static void res_2_d(void) { M_RES(2,R.DE.B.h); };
static void res_2_e(void) { M_RES(2,R.DE.B.l); };
static void res_2_h(void) { M_RES(2,R.HL.B.h); };
static void res_2_l(void) { M_RES(2,R.HL.B.l); };

static void res_3_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(3,i);
 M_WRMEM(R.HL.D,i);
};
static void res_3_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(3,i);
 M_WRMEM(j,i);
};
static void res_3_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(3,i);
 M_WRMEM(j,i);
};
static void res_3_a(void) { M_RES(3,R.AF.B.h); };
static void res_3_b(void) { M_RES(3,R.BC.B.h); };
static void res_3_c(void) { M_RES(3,R.BC.B.l); };
static void res_3_d(void) { M_RES(3,R.DE.B.h); };
static void res_3_e(void) { M_RES(3,R.DE.B.l); };
static void res_3_h(void) { M_RES(3,R.HL.B.h); };
static void res_3_l(void) { M_RES(3,R.HL.B.l); };

static void res_4_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(4,i);
 M_WRMEM(R.HL.D,i);
};
static void res_4_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(4,i);
 M_WRMEM(j,i);
};
static void res_4_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(4,i);
 M_WRMEM(j,i);
};
static void res_4_a(void) { M_RES(4,R.AF.B.h); };
static void res_4_b(void) { M_RES(4,R.BC.B.h); };
static void res_4_c(void) { M_RES(4,R.BC.B.l); };
static void res_4_d(void) { M_RES(4,R.DE.B.h); };
static void res_4_e(void) { M_RES(4,R.DE.B.l); };
static void res_4_h(void) { M_RES(4,R.HL.B.h); };
static void res_4_l(void) { M_RES(4,R.HL.B.l); };

static void res_5_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(5,i);
 M_WRMEM(R.HL.D,i);
};
static void res_5_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(5,i);
 M_WRMEM(j,i);
};
static void res_5_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(5,i);
 M_WRMEM(j,i);
};
static void res_5_a(void) { M_RES(5,R.AF.B.h); };
static void res_5_b(void) { M_RES(5,R.BC.B.h); };
static void res_5_c(void) { M_RES(5,R.BC.B.l); };
static void res_5_d(void) { M_RES(5,R.DE.B.h); };
static void res_5_e(void) { M_RES(5,R.DE.B.l); };
static void res_5_h(void) { M_RES(5,R.HL.B.h); };
static void res_5_l(void) { M_RES(5,R.HL.B.l); };

static void res_6_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(6,i);
 M_WRMEM(R.HL.D,i);
};
static void res_6_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(6,i);
 M_WRMEM(j,i);
};
static void res_6_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(6,i);
 M_WRMEM(j,i);
};
static void res_6_a(void) { M_RES(6,R.AF.B.h); };
static void res_6_b(void) { M_RES(6,R.BC.B.h); };
static void res_6_c(void) { M_RES(6,R.BC.B.l); };
static void res_6_d(void) { M_RES(6,R.DE.B.h); };
static void res_6_e(void) { M_RES(6,R.DE.B.l); };
static void res_6_h(void) { M_RES(6,R.HL.B.h); };
static void res_6_l(void) { M_RES(6,R.HL.B.l); };

static void res_7_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RES(7,i);
 M_WRMEM(R.HL.D,i);
};
static void res_7_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RES(7,i);
 M_WRMEM(j,i);
};
static void res_7_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RES(7,i);
 M_WRMEM(j,i);
};
static void res_7_a(void) { M_RES(7,R.AF.B.h); };
static void res_7_b(void) { M_RES(7,R.BC.B.h); };
static void res_7_c(void) { M_RES(7,R.BC.B.l); };
static void res_7_d(void) { M_RES(7,R.DE.B.h); };
static void res_7_e(void) { M_RES(7,R.DE.B.l); };
static void res_7_h(void) { M_RES(7,R.HL.B.h); };
static void res_7_l(void) { M_RES(7,R.HL.B.l); };

static void ret(void) { M_RET; }
static void ret_c(void) { if (M_C) { M_RET; } else { M_SKIP_RET; } }
static void ret_m(void) { if (M_M) { M_RET; } else { M_SKIP_RET; } }
static void ret_nc(void) { if (M_NC) { M_RET; } else { M_SKIP_RET; } }
static void ret_nz(void) { if (M_NZ) { M_RET; } else { M_SKIP_RET; } }
static void ret_p(void) { if (M_P) { M_RET; } else { M_SKIP_RET; } }
static void ret_pe(void) { if (M_PE) { M_RET; } else { M_SKIP_RET; } }
static void ret_po(void) { if (M_PO) { M_RET; } else { M_SKIP_RET; } }
static void ret_z(void) { if (M_Z) { M_RET; } else { M_SKIP_RET; } }

static void reti(void) { Z80_Reti(); M_RET; }
static void retn(void) { R.IFF1=R.IFF2; Z80_Retn(); M_RET; }

static void rl_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RL(i);
 M_WRMEM(R.HL.D,i);
}
static void rl_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RL(i);
 M_WRMEM(j,i);
}
static void rl_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RL(i);
 M_WRMEM(j,i);
}
static void rl_a(void) { M_RL(R.AF.B.h); }
static void rl_b(void) { M_RL(R.BC.B.h); }
static void rl_c(void) { M_RL(R.BC.B.l); }
static void rl_d(void) { M_RL(R.DE.B.h); }
static void rl_e(void) { M_RL(R.DE.B.l); }
static void rl_h(void) { M_RL(R.HL.B.h); }
static void rl_l(void) { M_RL(R.HL.B.l); }
static void rla(void)  { M_RLA; }

static void rlc_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RLC(i);
 M_WRMEM(R.HL.D,i);
}
static void rlc_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RLC(i);
 M_WRMEM(j,i);
}
static void rlc_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RLC(i);
 M_WRMEM(j,i);
}
static void rlc_a(void) { M_RLC(R.AF.B.h); }
static void rlc_b(void) { M_RLC(R.BC.B.h); }
static void rlc_c(void) { M_RLC(R.BC.B.l); }
static void rlc_d(void) { M_RLC(R.DE.B.h); }
static void rlc_e(void) { M_RLC(R.DE.B.l); }
static void rlc_h(void) { M_RLC(R.HL.B.h); }
static void rlc_l(void) { M_RLC(R.HL.B.l); }
static void rlca(void)  { M_RLCA; }

static void rld(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_WRMEM(R.HL.D,(i<<4)|(R.AF.B.h&0x0F));
 R.AF.B.h=(R.AF.B.h&0xF0)|(i>>4);
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSPTable[R.AF.B.h];
}

static void rr_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RR(i);
 M_WRMEM(R.HL.D,i);
}
static void rr_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RR(i);
 M_WRMEM(j,i);
}
static void rr_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RR(i);
 M_WRMEM(j,i);
}
static void rr_a(void) { M_RR(R.AF.B.h); }
static void rr_b(void) { M_RR(R.BC.B.h); }
static void rr_c(void) { M_RR(R.BC.B.l); }
static void rr_d(void) { M_RR(R.DE.B.h); }
static void rr_e(void) { M_RR(R.DE.B.l); }
static void rr_h(void) { M_RR(R.HL.B.h); }
static void rr_l(void) { M_RR(R.HL.B.l); }
static void rra(void)  { M_RRA; }

static void rrc_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_RRC(i);
 M_WRMEM(R.HL.D,i);
}
static void rrc_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_RRC(i);
 M_WRMEM(j,i);
}
static void rrc_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_RRC(i);
 M_WRMEM(j,i);
}
static void rrc_a(void) { M_RRC(R.AF.B.h); }
static void rrc_b(void) { M_RRC(R.BC.B.h); }
static void rrc_c(void) { M_RRC(R.BC.B.l); }
static void rrc_d(void) { M_RRC(R.DE.B.h); }
static void rrc_e(void) { M_RRC(R.DE.B.l); }
static void rrc_h(void) { M_RRC(R.HL.B.h); }
static void rrc_l(void) { M_RRC(R.HL.B.l); }
static void rrca(void)  { M_RRCA; }

static void rrd(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_WRMEM(R.HL.D,(i>>4)|(R.AF.B.h<<4));
 R.AF.B.h=(R.AF.B.h&0xF0)|(i&0x0F);
 R.AF.B.l=(R.AF.B.l&C_FLAG)|ZSPTable[R.AF.B.h];
}

static void rst_00(void) { M_RST(0x00); }
static void rst_08(void) { M_RST(0x08); }
static void rst_10(void) { M_RST(0x10); }
static void rst_18(void) { M_RST(0x18); }
static void rst_20(void) { M_RST(0x20); }
static void rst_28(void) { M_RST(0x28); }
static void rst_30(void) { M_RST(0x30); }
static void rst_38(void) { M_RST(0x38); }

static void sbc_a_byte(void) { byte i=M_RDMEM_OPCODE(); M_SBC(i); }
static void sbc_a_xhl(void) { byte i=M_RD_XHL; M_SBC(i); }
static void sbc_a_xix(void) { byte i=M_RD_XIX(); M_SBC(i); }
static void sbc_a_xiy(void) { byte i=M_RD_XIY(); M_SBC(i); }
static void sbc_a_a(void) { M_SBC(R.AF.B.h); }
static void sbc_a_b(void) { M_SBC(R.BC.B.h); }
static void sbc_a_c(void) { M_SBC(R.BC.B.l); }
static void sbc_a_d(void) { M_SBC(R.DE.B.h); }
static void sbc_a_e(void) { M_SBC(R.DE.B.l); }
static void sbc_a_h(void) { M_SBC(R.HL.B.h); }
static void sbc_a_l(void) { M_SBC(R.HL.B.l); }
static void sbc_a_ixh(void) { M_SBC(R.IX.B.h); }
static void sbc_a_ixl(void) { M_SBC(R.IX.B.l); }
static void sbc_a_iyh(void) { M_SBC(R.IY.B.h); }
static void sbc_a_iyl(void) { M_SBC(R.IY.B.l); }

static void sbc_hl_bc(void) { M_SBCW(BC); }
static void sbc_hl_de(void) { M_SBCW(DE); }
static void sbc_hl_hl(void) { M_SBCW(HL); }
static void sbc_hl_sp(void) { M_SBCW(SP); }

static void scf(void) { R.AF.B.l=(R.AF.B.l&0xEC)|C_FLAG; }

static void set_0_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(0,i);
 M_WRMEM(R.HL.D,i);
};
static void set_0_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(0,i);
 M_WRMEM(j,i);
};
static void set_0_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(0,i);
 M_WRMEM(j,i);
};
static void set_0_a(void) { M_SET(0,R.AF.B.h); };
static void set_0_b(void) { M_SET(0,R.BC.B.h); };
static void set_0_c(void) { M_SET(0,R.BC.B.l); };
static void set_0_d(void) { M_SET(0,R.DE.B.h); };
static void set_0_e(void) { M_SET(0,R.DE.B.l); };
static void set_0_h(void) { M_SET(0,R.HL.B.h); };
static void set_0_l(void) { M_SET(0,R.HL.B.l); };

static void set_1_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(1,i);
 M_WRMEM(R.HL.D,i);
};
static void set_1_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(1,i);
 M_WRMEM(j,i);
};
static void set_1_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(1,i);
 M_WRMEM(j,i);
};
static void set_1_a(void) { M_SET(1,R.AF.B.h); };
static void set_1_b(void) { M_SET(1,R.BC.B.h); };
static void set_1_c(void) { M_SET(1,R.BC.B.l); };
static void set_1_d(void) { M_SET(1,R.DE.B.h); };
static void set_1_e(void) { M_SET(1,R.DE.B.l); };
static void set_1_h(void) { M_SET(1,R.HL.B.h); };
static void set_1_l(void) { M_SET(1,R.HL.B.l); };

static void set_2_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(2,i);
 M_WRMEM(R.HL.D,i);
};
static void set_2_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(2,i);
 M_WRMEM(j,i);
};
static void set_2_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(2,i);
 M_WRMEM(j,i);
};
static void set_2_a(void) { M_SET(2,R.AF.B.h); };
static void set_2_b(void) { M_SET(2,R.BC.B.h); };
static void set_2_c(void) { M_SET(2,R.BC.B.l); };
static void set_2_d(void) { M_SET(2,R.DE.B.h); };
static void set_2_e(void) { M_SET(2,R.DE.B.l); };
static void set_2_h(void) { M_SET(2,R.HL.B.h); };
static void set_2_l(void) { M_SET(2,R.HL.B.l); };

static void set_3_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(3,i);
 M_WRMEM(R.HL.D,i);
};
static void set_3_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(3,i);
 M_WRMEM(j,i);
};
static void set_3_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(3,i);
 M_WRMEM(j,i);
};
static void set_3_a(void) { M_SET(3,R.AF.B.h); };
static void set_3_b(void) { M_SET(3,R.BC.B.h); };
static void set_3_c(void) { M_SET(3,R.BC.B.l); };
static void set_3_d(void) { M_SET(3,R.DE.B.h); };
static void set_3_e(void) { M_SET(3,R.DE.B.l); };
static void set_3_h(void) { M_SET(3,R.HL.B.h); };
static void set_3_l(void) { M_SET(3,R.HL.B.l); };

static void set_4_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(4,i);
 M_WRMEM(R.HL.D,i);
};
static void set_4_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(4,i);
 M_WRMEM(j,i);
};
static void set_4_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(4,i);
 M_WRMEM(j,i);
};
static void set_4_a(void) { M_SET(4,R.AF.B.h); };
static void set_4_b(void) { M_SET(4,R.BC.B.h); };
static void set_4_c(void) { M_SET(4,R.BC.B.l); };
static void set_4_d(void) { M_SET(4,R.DE.B.h); };
static void set_4_e(void) { M_SET(4,R.DE.B.l); };
static void set_4_h(void) { M_SET(4,R.HL.B.h); };
static void set_4_l(void) { M_SET(4,R.HL.B.l); };

static void set_5_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(5,i);
 M_WRMEM(R.HL.D,i);
};
static void set_5_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(5,i);
 M_WRMEM(j,i);
};
static void set_5_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(5,i);
 M_WRMEM(j,i);
};
static void set_5_a(void) { M_SET(5,R.AF.B.h); };
static void set_5_b(void) { M_SET(5,R.BC.B.h); };
static void set_5_c(void) { M_SET(5,R.BC.B.l); };
static void set_5_d(void) { M_SET(5,R.DE.B.h); };
static void set_5_e(void) { M_SET(5,R.DE.B.l); };
static void set_5_h(void) { M_SET(5,R.HL.B.h); };
static void set_5_l(void) { M_SET(5,R.HL.B.l); };

static void set_6_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(6,i);
 M_WRMEM(R.HL.D,i);
};
static void set_6_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(6,i);
 M_WRMEM(j,i);
};
static void set_6_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(6,i);
 M_WRMEM(j,i);
};
static void set_6_a(void) { M_SET(6,R.AF.B.h); };
static void set_6_b(void) { M_SET(6,R.BC.B.h); };
static void set_6_c(void) { M_SET(6,R.BC.B.l); };
static void set_6_d(void) { M_SET(6,R.DE.B.h); };
static void set_6_e(void) { M_SET(6,R.DE.B.l); };
static void set_6_h(void) { M_SET(6,R.HL.B.h); };
static void set_6_l(void) { M_SET(6,R.HL.B.l); };

static void set_7_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SET(7,i);
 M_WRMEM(R.HL.D,i);
};
static void set_7_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SET(7,i);
 M_WRMEM(j,i);
};
static void set_7_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SET(7,i);
 M_WRMEM(j,i);
};
static void set_7_a(void) { M_SET(7,R.AF.B.h); };
static void set_7_b(void) { M_SET(7,R.BC.B.h); };
static void set_7_c(void) { M_SET(7,R.BC.B.l); };
static void set_7_d(void) { M_SET(7,R.DE.B.h); };
static void set_7_e(void) { M_SET(7,R.DE.B.l); };
static void set_7_h(void) { M_SET(7,R.HL.B.h); };
static void set_7_l(void) { M_SET(7,R.HL.B.l); };

static void sla_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SLA(i);
 M_WRMEM(R.HL.D,i);
}
static void sla_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SLA(i);
 M_WRMEM(j,i);
}
static void sla_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SLA(i);
 M_WRMEM(j,i);
}
static void sla_a(void) { M_SLA(R.AF.B.h); }
static void sla_b(void) { M_SLA(R.BC.B.h); }
static void sla_c(void) { M_SLA(R.BC.B.l); }
static void sla_d(void) { M_SLA(R.DE.B.h); }
static void sla_e(void) { M_SLA(R.DE.B.l); }
static void sla_h(void) { M_SLA(R.HL.B.h); }
static void sla_l(void) { M_SLA(R.HL.B.l); }

static void sll_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SLL(i);
 M_WRMEM(R.HL.D,i);
}
static void sll_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SLL(i);
 M_WRMEM(j,i);
}
static void sll_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SLL(i);
 M_WRMEM(j,i);
}
static void sll_a(void) { M_SLL(R.AF.B.h); }
static void sll_b(void) { M_SLL(R.BC.B.h); }
static void sll_c(void) { M_SLL(R.BC.B.l); }
static void sll_d(void) { M_SLL(R.DE.B.h); }
static void sll_e(void) { M_SLL(R.DE.B.l); }
static void sll_h(void) { M_SLL(R.HL.B.h); }
static void sll_l(void) { M_SLL(R.HL.B.l); }

static void sra_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SRA(i);
 M_WRMEM(R.HL.D,i);
}
static void sra_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SRA(i);
 M_WRMEM(j,i);
}
static void sra_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SRA(i);
 M_WRMEM(j,i);
}
static void sra_a(void) { M_SRA(R.AF.B.h); }
static void sra_b(void) { M_SRA(R.BC.B.h); }
static void sra_c(void) { M_SRA(R.BC.B.l); }
static void sra_d(void) { M_SRA(R.DE.B.h); }
static void sra_e(void) { M_SRA(R.DE.B.l); }
static void sra_h(void) { M_SRA(R.HL.B.h); }
static void sra_l(void) { M_SRA(R.HL.B.l); }

static void srl_xhl(void)
{
 byte i;
 i=M_RDMEM(R.HL.D);
 M_SRL(i);
 M_WRMEM(R.HL.D,i);
}
static void srl_xix(void)
{
 byte i;
 int j;
 j=M_XIX;
 i=M_RDMEM(j);
 M_SRL(i);
 M_WRMEM(j,i);
}
static void srl_xiy(void)
{
 byte i;
 int j;
 j=M_XIY;
 i=M_RDMEM(j);
 M_SRL(i);
 M_WRMEM(j,i);
}
static void srl_a(void) { M_SRL(R.AF.B.h); }
static void srl_b(void) { M_SRL(R.BC.B.h); }
static void srl_c(void) { M_SRL(R.BC.B.l); }
static void srl_d(void) { M_SRL(R.DE.B.h); }
static void srl_e(void) { M_SRL(R.DE.B.l); }
static void srl_h(void) { M_SRL(R.HL.B.h); }
static void srl_l(void) { M_SRL(R.HL.B.l); }

static void sub_xhl(void) { byte i=M_RD_XHL; M_SUB(i); }
static void sub_xix(void) { byte i=M_RD_XIX(); M_SUB(i); }
static void sub_xiy(void) { byte i=M_RD_XIY(); M_SUB(i); }
static void sub_a(void) { R.AF.D=Z_FLAG|N_FLAG; }
static void sub_b(void) { M_SUB(R.BC.B.h); }
static void sub_c(void) { M_SUB(R.BC.B.l); }
static void sub_d(void) { M_SUB(R.DE.B.h); }
static void sub_e(void) { M_SUB(R.DE.B.l); }
static void sub_h(void) { M_SUB(R.HL.B.h); }
static void sub_l(void) { M_SUB(R.HL.B.l); }
static void sub_ixh(void) { M_SUB(R.IX.B.h); }
static void sub_ixl(void) { M_SUB(R.IX.B.l); }
static void sub_iyh(void) { M_SUB(R.IY.B.h); }
static void sub_iyl(void) { M_SUB(R.IY.B.l); }
static void sub_byte(void) { byte i=M_RDMEM_OPCODE(); M_SUB(i); }

static void xor_xhl(void) { byte i=M_RD_XHL; M_XOR(i); }
static void xor_xix(void) { byte i=M_RD_XIX(); M_XOR(i); }
static void xor_xiy(void) { byte i=M_RD_XIY(); M_XOR(i); }
static void xor_a(void) { R.AF.D=Z_FLAG|V_FLAG; }
static void xor_b(void) { M_XOR(R.BC.B.h); }
static void xor_c(void) { M_XOR(R.BC.B.l); }
static void xor_d(void) { M_XOR(R.DE.B.h); }
static void xor_e(void) { M_XOR(R.DE.B.l); }
static void xor_h(void) { M_XOR(R.HL.B.h); }
static void xor_l(void) { M_XOR(R.HL.B.l); }
static void xor_ixh(void) { M_XOR(R.IX.B.h); }
static void xor_ixl(void) { M_XOR(R.IX.B.l); }
static void xor_iyh(void) { M_XOR(R.IY.B.h); }
static void xor_iyl(void) { M_XOR(R.IY.B.l); }
static void xor_byte(void) { byte i=M_RDMEM_OPCODE(); M_XOR(i); }

static void no_op(void)
{
 --R.PC.W.l;
}

static void patch(void) { Z80_Patch(&R); }

static unsigned cycles_main[256]=
{
  4,10,7,6,4,4,7,4,
  4,11,7,6,4,4,7,4,
  8,10,7,6,4,4,7,4,
  7,11,7,6,4,4,7,4,
  7,10,16,6,4,4,7,4,
  7,11,16,6,4,4,7,4,
  7,10,13,6,11,11,10,4,
  7,11,13,6,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  7,7,7,7,7,7,4,7,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  4,4,4,4,4,4,7,4,
  5,10,10,10,10,11,7,11,
  5,4,10,0,10,10,7,11,
  5,10,10,11,10,11,7,11,
  5,4,10,11,10,0,7,11,
  5,10,10,19,10,11,7,11,
  5,4,10,4,10,0,7,11,
  5,10,10,4,10,11,7,11,
  5,6,10,4,10,0,7,11
};

static unsigned cycles_cb[256]=
{
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,12,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8,
  8,8,8,8,8,8,15,8
};
static unsigned cycles_xx_cb[]=
{
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  20,20,20,20,20,20,20,20,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0,
  0,0,0,0,0,0,23,0
};
static unsigned cycles_xx[256]=
{
  0,0,0,0,0,0,0,0,
  0,15,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,15,0,0,0,0,0,0,
  0,14,20,10,9,9,9,0,
  0,15,20,10,9,9,9,0,
  0,0,0,0,23,23,19,0,
  0,15,0,0,0,0,0,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  9,9,9,9,9,9,9,9,
  9,9,9,9,9,9,9,9,
  19,19,19,19,19,19,19,19,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,9,9,19,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,14,0,23,0,15,0,0,
  0,8,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,10,0,0,0,0,0,0
};
static unsigned cycles_ed[256]=
{
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  12,12,15,20,8,8,8,9,
  12,12,15,20,8,8,8,9,
  12,12,15,20,8,8,8,9,
  12,12,15,20,8,8,8,9,
  12,12,15,20,8,8,8,18,
  12,12,15,20,8,8,8,18,
  12,12,15,20,8,8,8,0,
  12,12,15,20,8,8,8,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  16,16,16,16,0,0,0,0,
  16,16,16,16,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0
};

static void no_op_xx(void) {
++R.PC.W.l; }

static opcode_fn opcode_dd_cb[256]=
{
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rlc_xix  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rrc_xix  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rl_xix   ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rr_xix   ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sla_xix  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sra_xix  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sll_xix  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,srl_xix  ,no_op_xx ,
 bit_0_xix,bit_0_xix,bit_0_xix,bit_0_xix,bit_0_xix,bit_0_xix,bit_0_xix,bit_0_xix,
 bit_1_xix,bit_1_xix,bit_1_xix,bit_1_xix,bit_1_xix,bit_1_xix,bit_1_xix,bit_1_xix,
 bit_2_xix,bit_2_xix,bit_2_xix,bit_2_xix,bit_2_xix,bit_2_xix,bit_2_xix,bit_2_xix,
 bit_3_xix,bit_3_xix,bit_3_xix,bit_3_xix,bit_3_xix,bit_3_xix,bit_3_xix,bit_3_xix,
 bit_4_xix,bit_4_xix,bit_4_xix,bit_4_xix,bit_4_xix,bit_4_xix,bit_4_xix,bit_4_xix,
 bit_5_xix,bit_5_xix,bit_5_xix,bit_5_xix,bit_5_xix,bit_5_xix,bit_5_xix,bit_5_xix,
 bit_6_xix,bit_6_xix,bit_6_xix,bit_6_xix,bit_6_xix,bit_6_xix,bit_6_xix,bit_6_xix,
 bit_7_xix,bit_7_xix,bit_7_xix,bit_7_xix,bit_7_xix,bit_7_xix,bit_7_xix,bit_7_xix,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_0_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_1_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_2_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_3_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_4_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_5_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_6_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_7_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_0_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_1_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_2_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_3_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_4_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_5_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_6_xix,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_7_xix,no_op_xx
};

static opcode_fn opcode_fd_cb[256]=
{
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rlc_xiy  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rrc_xiy  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rl_xiy   ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,rr_xiy   ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sla_xiy  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sra_xiy  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,sll_xiy  ,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,srl_xiy  ,no_op_xx ,
 bit_0_xiy,bit_0_xiy,bit_0_xiy,bit_0_xiy,bit_0_xiy,bit_0_xiy,bit_0_xiy,bit_0_xiy,
 bit_1_xiy,bit_1_xiy,bit_1_xiy,bit_1_xiy,bit_1_xiy,bit_1_xiy,bit_1_xiy,bit_1_xiy,
 bit_2_xiy,bit_2_xiy,bit_2_xiy,bit_2_xiy,bit_2_xiy,bit_2_xiy,bit_2_xiy,bit_2_xiy,
 bit_3_xiy,bit_3_xiy,bit_3_xiy,bit_3_xiy,bit_3_xiy,bit_3_xiy,bit_3_xiy,bit_3_xiy,
 bit_4_xiy,bit_4_xiy,bit_4_xiy,bit_4_xiy,bit_4_xiy,bit_4_xiy,bit_4_xiy,bit_4_xiy,
 bit_5_xiy,bit_5_xiy,bit_5_xiy,bit_5_xiy,bit_5_xiy,bit_5_xiy,bit_5_xiy,bit_5_xiy,
 bit_6_xiy,bit_6_xiy,bit_6_xiy,bit_6_xiy,bit_6_xiy,bit_6_xiy,bit_6_xiy,bit_6_xiy,
 bit_7_xiy,bit_7_xiy,bit_7_xiy,bit_7_xiy,bit_7_xiy,bit_7_xiy,bit_7_xiy,bit_7_xiy,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_0_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_1_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_2_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_3_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_4_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_5_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_6_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,res_7_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_0_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_1_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_2_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_3_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_4_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_5_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_6_xiy,no_op_xx ,
 no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,no_op_xx ,set_7_xiy,no_op_xx
};

static void dd_cb(void)
{
 unsigned opcode;
 opcode=M_RDOP_ARG((R.PC.D+1)&0xFFFF);
 Z80_ICount-=cycles_xx_cb[opcode];
 (*(opcode_dd_cb[opcode]))();
 ++R.PC.W.l;
};
static void fd_cb(void)
{
 unsigned opcode;
 opcode=M_RDOP_ARG((R.PC.D+1)&0xFFFF);
 Z80_ICount-=cycles_xx_cb[opcode];
 (*(opcode_fd_cb[opcode]))();
 ++R.PC.W.l;
};

static opcode_fn opcode_cb[256]=
{
 rlc_b  ,rlc_c  ,rlc_d  ,rlc_e  ,rlc_h  ,rlc_l  ,rlc_xhl  ,rlc_a  ,
 rrc_b  ,rrc_c  ,rrc_d  ,rrc_e  ,rrc_h  ,rrc_l  ,rrc_xhl  ,rrc_a  ,
 rl_b   ,rl_c   ,rl_d   ,rl_e   ,rl_h   ,rl_l   ,rl_xhl   ,rl_a   ,
 rr_b   ,rr_c   ,rr_d   ,rr_e   ,rr_h   ,rr_l   ,rr_xhl   ,rr_a   ,
 sla_b  ,sla_c  ,sla_d  ,sla_e  ,sla_h  ,sla_l  ,sla_xhl  ,sla_a  ,
 sra_b  ,sra_c  ,sra_d  ,sra_e  ,sra_h  ,sra_l  ,sra_xhl  ,sra_a  ,
 sll_b  ,sll_c  ,sll_d  ,sll_e  ,sll_h  ,sll_l  ,sll_xhl  ,sll_a  ,
 srl_b  ,srl_c  ,srl_d  ,srl_e  ,srl_h  ,srl_l  ,srl_xhl  ,srl_a  ,
 bit_0_b,bit_0_c,bit_0_d,bit_0_e,bit_0_h,bit_0_l,bit_0_xhl,bit_0_a,
 bit_1_b,bit_1_c,bit_1_d,bit_1_e,bit_1_h,bit_1_l,bit_1_xhl,bit_1_a,
 bit_2_b,bit_2_c,bit_2_d,bit_2_e,bit_2_h,bit_2_l,bit_2_xhl,bit_2_a,
 bit_3_b,bit_3_c,bit_3_d,bit_3_e,bit_3_h,bit_3_l,bit_3_xhl,bit_3_a,
 bit_4_b,bit_4_c,bit_4_d,bit_4_e,bit_4_h,bit_4_l,bit_4_xhl,bit_4_a,
 bit_5_b,bit_5_c,bit_5_d,bit_5_e,bit_5_h,bit_5_l,bit_5_xhl,bit_5_a,
 bit_6_b,bit_6_c,bit_6_d,bit_6_e,bit_6_h,bit_6_l,bit_6_xhl,bit_6_a,
 bit_7_b,bit_7_c,bit_7_d,bit_7_e,bit_7_h,bit_7_l,bit_7_xhl,bit_7_a,
 res_0_b,res_0_c,res_0_d,res_0_e,res_0_h,res_0_l,res_0_xhl,res_0_a,
 res_1_b,res_1_c,res_1_d,res_1_e,res_1_h,res_1_l,res_1_xhl,res_1_a,
 res_2_b,res_2_c,res_2_d,res_2_e,res_2_h,res_2_l,res_2_xhl,res_2_a,
 res_3_b,res_3_c,res_3_d,res_3_e,res_3_h,res_3_l,res_3_xhl,res_3_a,
 res_4_b,res_4_c,res_4_d,res_4_e,res_4_h,res_4_l,res_4_xhl,res_4_a,
 res_5_b,res_5_c,res_5_d,res_5_e,res_5_h,res_5_l,res_5_xhl,res_5_a,
 res_6_b,res_6_c,res_6_d,res_6_e,res_6_h,res_6_l,res_6_xhl,res_6_a,
 res_7_b,res_7_c,res_7_d,res_7_e,res_7_h,res_7_l,res_7_xhl,res_7_a,
 set_0_b,set_0_c,set_0_d,set_0_e,set_0_h,set_0_l,set_0_xhl,set_0_a,
 set_1_b,set_1_c,set_1_d,set_1_e,set_1_h,set_1_l,set_1_xhl,set_1_a,
 set_2_b,set_2_c,set_2_d,set_2_e,set_2_h,set_2_l,set_2_xhl,set_2_a,
 set_3_b,set_3_c,set_3_d,set_3_e,set_3_h,set_3_l,set_3_xhl,set_3_a,
 set_4_b,set_4_c,set_4_d,set_4_e,set_4_h,set_4_l,set_4_xhl,set_4_a,
 set_5_b,set_5_c,set_5_d,set_5_e,set_5_h,set_5_l,set_5_xhl,set_5_a,
 set_6_b,set_6_c,set_6_d,set_6_e,set_6_h,set_6_l,set_6_xhl,set_6_a,
 set_7_b,set_7_c,set_7_d,set_7_e,set_7_h,set_7_l,set_7_xhl,set_7_a
};

static opcode_fn opcode_dd[256]=
{
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,add_ix_bc ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,add_ix_de ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,ld_ix_word,ld_xword_ix,inc_ix   ,inc_ixh    ,dec_ixh    ,ld_ixh_byte,no_op   ,
  no_op   ,add_ix_ix ,ld_ix_xword,dec_ix   ,inc_ixl    ,dec_ixl    ,ld_ixl_byte,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,inc_xix    ,dec_xix    ,ld_xix_byte,no_op   ,
  no_op   ,add_ix_sp ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_b_ixh   ,ld_b_ixl   ,ld_b_xix   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_c_ixh   ,ld_c_ixl   ,ld_c_xix   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_d_ixh   ,ld_d_ixl   ,ld_d_xix   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_e_ixh   ,ld_e_ixl   ,ld_e_xix   ,no_op   ,
  ld_ixh_b,ld_ixh_c  ,ld_ixh_d   ,ld_ixh_e ,ld_ixh_ixh ,ld_ixh_ixl ,ld_h_xix   ,ld_ixh_a,
  ld_ixl_b,ld_ixl_c  ,ld_ixl_d   ,ld_ixl_e ,ld_ixl_ixh ,ld_ixl_ixl ,ld_l_xix   ,ld_ixl_a,
  ld_xix_b,ld_xix_c  ,ld_xix_d   ,ld_xix_e ,ld_xix_h   ,ld_xix_l   ,no_op      ,ld_xix_a,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_a_ixh   ,ld_a_ixl   ,ld_a_xix   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,add_a_ixh  ,add_a_ixl  ,add_a_xix  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,adc_a_ixh  ,adc_a_ixl  ,adc_a_xix  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,sub_ixh    ,sub_ixl    ,sub_xix    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,sbc_a_ixh  ,sbc_a_ixl  ,sbc_a_xix  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,and_ixh    ,and_ixl    ,and_xix    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,xor_ixh    ,xor_ixl    ,xor_xix    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,or_ixh     ,or_ixl     ,or_xix     ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,cp_ixh     ,cp_ixl     ,cp_xix     ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,dd_cb    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,pop_ix    ,no_op      ,ex_xsp_ix,no_op      ,push_ix    ,no_op      ,no_op   ,
  no_op   ,jp_ix     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,ld_sp_ix  ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op
};

static opcode_fn opcode_ed[256]=
{
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 in_b_c,out_c_b,sbc_hl_bc,ld_xword_bc,neg,retn,im_0 ,ld_i_a,
 in_c_c,out_c_c,adc_hl_bc,ld_bc_xword,neg,reti,im_0 ,ld_r_a,
 in_d_c,out_c_d,sbc_hl_de,ld_xword_de,neg,retn,im_1 ,ld_a_i,
 in_e_c,out_c_e,adc_hl_de,ld_de_xword,neg,reti,im_2 ,ld_a_r,
 in_h_c,out_c_h,sbc_hl_hl,ld_xword_hl,neg,retn,im_0 ,rrd   ,
 in_l_c,out_c_l,adc_hl_hl,ld_hl_xword,neg,reti,im_0 ,rld   ,
 in_0_c,out_c_0,sbc_hl_sp,ld_xword_sp,neg,retn,im_1 ,nop   ,
 in_a_c,out_c_a,adc_hl_sp,ld_sp_xword,neg,reti,im_2 ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 ldi   ,cpi    ,ini      ,outi       ,nop,nop ,nop  ,nop   ,
 ldd   ,cpd    ,ind      ,outd       ,nop,nop ,nop  ,nop   ,
 ldir  ,cpir   ,inir     ,otir       ,nop,nop ,nop  ,nop   ,
 lddr  ,cpdr   ,indr     ,otdr       ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,nop  ,nop   ,
 nop   ,nop    ,nop      ,nop        ,nop,nop ,patch,nop
};

static opcode_fn opcode_fd[256]=
{
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,add_iy_bc ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,add_iy_de ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,ld_iy_word,ld_xword_iy,inc_iy   ,inc_iyh    ,dec_iyh    ,ld_iyh_byte,no_op   ,
  no_op   ,add_iy_iy ,ld_iy_xword,dec_iy   ,inc_iyl    ,dec_iyl    ,ld_iyl_byte,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,inc_xiy    ,dec_xiy    ,ld_xiy_byte,no_op   ,
  no_op   ,add_iy_sp ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_b_iyh   ,ld_b_iyl   ,ld_b_xiy   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_c_iyh   ,ld_c_iyl   ,ld_c_xiy   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_d_iyh   ,ld_d_iyl   ,ld_d_xiy   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_e_iyh   ,ld_e_iyl   ,ld_e_xiy   ,no_op   ,
  ld_iyh_b,ld_iyh_c  ,ld_iyh_d   ,ld_iyh_e ,ld_iyh_iyh ,ld_iyh_iyl ,ld_h_xiy   ,ld_iyh_a,
  ld_iyl_b,ld_iyl_c  ,ld_iyl_d   ,ld_iyl_e ,ld_iyl_iyh ,ld_iyl_iyl ,ld_l_xiy   ,ld_iyl_a,
  ld_xiy_b,ld_xiy_c  ,ld_xiy_d   ,ld_xiy_e ,ld_xiy_h   ,ld_xiy_l   ,no_op      ,ld_xiy_a,
  no_op   ,no_op     ,no_op      ,no_op    ,ld_a_iyh   ,ld_a_iyl   ,ld_a_xiy   ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,add_a_iyh  ,add_a_iyl  ,add_a_xiy  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,adc_a_iyh  ,adc_a_iyl  ,adc_a_xiy  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,sub_iyh    ,sub_iyl    ,sub_xiy    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,sbc_a_iyh  ,sbc_a_iyl  ,sbc_a_xiy  ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,and_iyh    ,and_iyl    ,and_xiy    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,xor_iyh    ,xor_iyl    ,xor_xiy    ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,or_iyh     ,or_iyl     ,or_xiy     ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,cp_iyh     ,cp_iyl     ,cp_xiy     ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,fd_cb    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,pop_iy    ,no_op      ,ex_xsp_iy,no_op      ,push_iy    ,no_op      ,no_op   ,
  no_op   ,jp_iy     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,no_op     ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op   ,
  no_op   ,ld_sp_iy  ,no_op      ,no_op    ,no_op      ,no_op      ,no_op      ,no_op
};

static void cb(void)
{
 unsigned opcode;
 ++R.R;
 opcode=M_RDOP(R.PC.D);
 R.PC.W.l++;
 Z80_ICount-=cycles_cb[opcode];
 (*(opcode_cb[opcode]))();
}
static void dd(void)
{
 unsigned opcode;
 ++R.R;
 opcode=M_RDOP(R.PC.D);
 R.PC.W.l++;
 Z80_ICount-=cycles_xx[opcode];
 (*(opcode_dd[opcode]))();
}
static void ed(void)
{
 unsigned opcode;
 ++R.R;
 opcode=M_RDOP(R.PC.D);
 R.PC.W.l++;
 Z80_ICount-=cycles_ed[opcode];
 (*(opcode_ed[opcode]))();
}
static void fd (void)
{
 unsigned opcode;
 ++R.R;
 opcode=M_RDOP(R.PC.D);
 R.PC.W.l++;
 Z80_ICount-=cycles_xx[opcode];
 (*(opcode_fd[opcode]))();
}

static opcode_fn opcode_main[256]=
{
 nop     ,ld_bc_word,ld_xbc_a   ,inc_bc    ,inc_b   ,dec_b   ,ld_b_byte  ,rlca    ,
 ex_af_af,add_hl_bc ,ld_a_xbc   ,dec_bc    ,inc_c   ,dec_c   ,ld_c_byte  ,rrca    ,
 djnz    ,ld_de_word,ld_xde_a   ,inc_de    ,inc_d   ,dec_d   ,ld_d_byte  ,rla     ,
 jr      ,add_hl_de ,ld_a_xde   ,dec_de    ,inc_e   ,dec_e   ,ld_e_byte  ,rra     ,
 jr_nz   ,ld_hl_word,ld_xword_hl,inc_hl    ,inc_h   ,dec_h   ,ld_h_byte  ,daa     ,
 jr_z    ,add_hl_hl ,ld_hl_xword,dec_hl    ,inc_l   ,dec_l   ,ld_l_byte  ,cpl     ,
 jr_nc   ,ld_sp_word,ld_xbyte_a ,inc_sp    ,inc_xhl ,dec_xhl ,ld_xhl_byte,scf     ,
 jr_c    ,add_hl_sp ,ld_a_xbyte ,dec_sp    ,inc_a   ,dec_a   ,ld_a_byte  ,ccf     ,
 ld_b_b  ,ld_b_c    ,ld_b_d     ,ld_b_e    ,ld_b_h  ,ld_b_l  ,ld_b_xhl   ,ld_b_a  ,
 ld_c_b  ,ld_c_c    ,ld_c_d     ,ld_c_e    ,ld_c_h  ,ld_c_l  ,ld_c_xhl   ,ld_c_a  ,
 ld_d_b  ,ld_d_c    ,ld_d_d     ,ld_d_e    ,ld_d_h  ,ld_d_l  ,ld_d_xhl   ,ld_d_a  ,
 ld_e_b  ,ld_e_c    ,ld_e_d     ,ld_e_e    ,ld_e_h  ,ld_e_l  ,ld_e_xhl   ,ld_e_a  ,
 ld_h_b  ,ld_h_c    ,ld_h_d     ,ld_h_e    ,ld_h_h  ,ld_h_l  ,ld_h_xhl   ,ld_h_a  ,
 ld_l_b  ,ld_l_c    ,ld_l_d     ,ld_l_e    ,ld_l_h  ,ld_l_l  ,ld_l_xhl   ,ld_l_a  ,
 ld_xhl_b,ld_xhl_c  ,ld_xhl_d   ,ld_xhl_e  ,ld_xhl_h,ld_xhl_l,halt       ,ld_xhl_a,
 ld_a_b  ,ld_a_c    ,ld_a_d     ,ld_a_e    ,ld_a_h  ,ld_a_l  ,ld_a_xhl   ,ld_a_a  ,
 add_a_b ,add_a_c   ,add_a_d    ,add_a_e   ,add_a_h ,add_a_l ,add_a_xhl  ,add_a_a ,
 adc_a_b ,adc_a_c   ,adc_a_d    ,adc_a_e   ,adc_a_h ,adc_a_l ,adc_a_xhl  ,adc_a_a ,
 sub_b   ,sub_c     ,sub_d      ,sub_e     ,sub_h   ,sub_l   ,sub_xhl    ,sub_a   ,
 sbc_a_b ,sbc_a_c   ,sbc_a_d    ,sbc_a_e   ,sbc_a_h ,sbc_a_l ,sbc_a_xhl  ,sbc_a_a ,
 and_b   ,and_c     ,and_d      ,and_e     ,and_h   ,and_l   ,and_xhl    ,and_a   ,
 xor_b   ,xor_c     ,xor_d      ,xor_e     ,xor_h   ,xor_l   ,xor_xhl    ,xor_a   ,
 or_b    ,or_c      ,or_d       ,or_e      ,or_h    ,or_l    ,or_xhl     ,or_a    ,
 cp_b    ,cp_c      ,cp_d       ,cp_e      ,cp_h    ,cp_l    ,cp_xhl     ,cp_a    ,
 ret_nz  ,pop_bc    ,jp_nz      ,jp        ,call_nz ,push_bc ,add_a_byte ,rst_00  ,
 ret_z   ,ret       ,jp_z       ,cb        ,call_z  ,call    ,adc_a_byte ,rst_08  ,
 ret_nc  ,pop_de    ,jp_nc      ,out_byte_a,call_nc ,push_de ,sub_byte   ,rst_10  ,
 ret_c   ,exx       ,jp_c       ,in_a_byte ,call_c  ,dd      ,sbc_a_byte ,rst_18  ,
 ret_po  ,pop_hl    ,jp_po      ,ex_xsp_hl ,call_po ,push_hl ,and_byte   ,rst_20  ,
 ret_pe  ,jp_hl     ,jp_pe      ,ex_de_hl  ,call_pe ,ed      ,xor_byte   ,rst_28  ,
 ret_p   ,pop_af    ,jp_p       ,di        ,call_p  ,push_af ,or_byte    ,rst_30  ,
 ret_m   ,ld_sp_hl  ,jp_m       ,ei        ,call_m  ,fd      ,cp_byte    ,rst_38
};

static void ei(void)
{
 unsigned opcode;
 /* If interrupts were disabled, execute one more instruction and check the */
 /* IRQ line. If not, simply set interrupt flip-flop 2                      */
 if (!R.IFF1)
 {
#ifdef DEBUG
  if (R.PC.D==Z80_Trap) Z80_Trace=1;
  if (Z80_Trace) Z80_Debug(&R);
#endif
  R.IFF1=R.IFF2=1;
  ++R.R;
  opcode=M_RDOP(R.PC.D);
  R.PC.W.l++;
  Z80_ICount-=cycles_main[opcode];
  (*(opcode_main[opcode]))();
  Interrupt(Z80_IRQ);
 }
 else
  R.IFF2=1;
}

/****************************************************************************/
/* Reset registers to their initial values                                  */
/****************************************************************************/
void Z80_Reset (void)
{
 memset (&R,0,sizeof(Z80_Regs));
 R.SP.D=0xF000;
 R.R=rand();
 Z80_ICount=Z80_IPeriod;
}

/****************************************************************************/
/* Initialise the various lookup tables used by the emulation code          */
/****************************************************************************/
static void InitTables (void)
{
 static int InitTables_virgin=1;
 byte zs;
 int i,p;
 if (!InitTables_virgin) return;
 InitTables_virgin=0;
 for (i=0;i<256;++i)
 {
  zs=0;
  if (i==0)
   zs|=Z_FLAG;
  if (i&0x80)
   zs|=S_FLAG;
  p=0;
  if (i&1) ++p;
  if (i&2) ++p;
  if (i&4) ++p;
  if (i&8) ++p;
  if (i&16) ++p;
  if (i&32) ++p;
  if (i&64) ++p;
  if (i&128) ++p;
  PTable[i]=(p&1)? 0:V_FLAG;
  ZSTable[i]=zs;
  ZSPTable[i]=zs|PTable[i];
 }
 for (i=0;i<256;++i)
 {
  ZSTable[i+256]=ZSTable[i]|C_FLAG;
  ZSPTable[i+256]=ZSPTable[i]|C_FLAG;
  PTable[i+256]=PTable[i]|C_FLAG;
 }
}

/****************************************************************************/
/* Issue an interrupt if necessary                                          */
/****************************************************************************/
static void Interrupt (int j)
{
 if (j==Z80_IGNORE_INT) return;
 if (j==Z80_NMI_INT || R.IFF1)
 {
  /* Clear interrupt flip-flop 1 */
  R.IFF1=0;
  /* Check if processor was halted */
  if (R.HALT)
  {
   ++R.PC.W.l;
   R.HALT=0;
  }
  if (j==Z80_NMI_INT)
  {
   M_PUSH (PC);
   R.PC.D=0x0066;
  }
  else
  {
   /* Interrupt mode 2. Call [R.I:databyte] */
   if (R.IM==2)
   {
    M_PUSH (PC);
    R.PC.D=M_RDMEM_WORD((j&255)|(R.I<<8));
   }
   else
    /* Interrupt mode 1. RST 38h */
    if (R.IM==1)
    {
     Z80_ICount-=cycles_main[0xFF];
     (*(opcode_main[0xFF]))();
    }
    else
    /* Interrupt mode 0. We check for CALL and JP instructions, if neither  */
    /* of these were found we assume a 1 byte opcode was placed on the      */
    /* databus                                                              */
    {
     switch (j&0xFF0000)
     {
      case 0xCD:
       M_PUSH(PC);
      case 0xC3:
       R.PC.D=j&0xFFFF;
       break;
      default:
       j&=255;
       Z80_ICount-=cycles_main[j];
       (*(opcode_main[j]))();
       break;
     }
    }
  }
 }
}

/****************************************************************************/
/* Set all registers to given values                                        */
/****************************************************************************/
void Z80_SetRegs (Z80_Regs *Regs)
{
 R=*Regs;
}

/****************************************************************************/
/* Get all registers in given buffer                                        */
/****************************************************************************/
void Z80_GetRegs (Z80_Regs *Regs)
{
 *Regs=R;
}

/****************************************************************************/
/* Return program counter                                                   */
/****************************************************************************/
unsigned Z80_GetPC (void)
{
 return R.PC.D;
}

/****************************************************************************/
/* Execute IPeriod T-States. Return 0 if emulation should be stopped        */
/****************************************************************************/
int Z80_Execute (void)
{
 unsigned opcode;
 Z80_Running=1;
 InitTables ();

 do
 {

#ifdef TRACE
  pc_trace[pc_count]=R.PC.D;
  pc_count=(pc_count+1)&255;
#endif
#ifdef DEBUG
  if (R.PC.D==Z80_Trap) Z80_Trace=1;
  if (Z80_Trace) Z80_Debug(&R);
  if (!Z80_Running) break;
#endif
  ++R.R;
  opcode=M_RDOP(R.PC.D);
  R.PC.W.l++;
  Z80_ICount-=cycles_main[opcode];
  (*(opcode_main[opcode]))();
 }
 while (Z80_ICount>0);
 Z80_ICount+=Z80_IPeriod;
 Interrupt (Z80_Interrupt());
 return Z80_Running;
}


//ssssss made this to execute while looking for breakpoints
int Z80_ExecuteDebug (void)
{
 unsigned opcode;
 int wsts;
 int f = 1;
 Z80_Running=1;
 InitTables ();

 do
 {
#ifdef TRACE
  pc_trace[pc_count]=R.PC.D;
  pc_count=(pc_count+1)&255;
#endif
#ifdef DEBUG
  if (R.PC.D==Z80_Trap) Z80_Trace=1;
  if (Z80_Trace) Z80_Debug(&R);
  if (!Z80_Running) break;
#endif
  ++R.R;
  if (R.PC.W.l == wks.breakaddr && wks.runmode == 1 && f == 0)
  {
  	wks.brk = 1;
    return(Z80_Running);
  }
  f = 0;
  opcode=M_RDOP(R.PC.D);
  R.PC.W.l++;
  Z80_ICount-=cycles_main[opcode];
  (*(opcode_main[opcode]))();
  wsts = wks.waitstates+1;
  do
  	--wsts;
  while(wsts);

 }
 while (Z80_ICount>0 && wks.trap == 0);
 Z80_ICount+=Z80_IPeriod;
 Interrupt (Z80_Interrupt());
 return Z80_Running;
}


/****************************************************************************/
/* Interpret Z80 code                                                       */
/****************************************************************************/
word Z80 (void)
{
 while (Z80_Execute());
 return(R.PC.W.l);
}

/****************************************************************************/
/* Dump register contents and (optionally) a PC trace to stdout             */
/****************************************************************************/
void Z80_RegisterDump (void)
{
 int i;
 printf
 (
   "AF:%04X HL:%04X DE:%04X BC:%04X PC:%04X SP:%04X IX:%04X IY:%04X\n",
   R.AF.W.l,R.HL.W.l,R.DE.W.l,R.BC.W.l,R.PC.W.l,R.SP.W.l,R.IX.W.l,R.IY.W.l
 );
 printf ("STACK: ");
 for (i=0;i<10;++i) printf ("%04X ",M_RDMEM_WORD((R.SP.D+i*2)&0xFFFF));
 puts ("");
#ifdef TRACE
 puts ("PC TRACE:");
 for (i=1;i<=256;++i) printf ("%04X\n",pc_trace[(pc_count-i)&255]);
#endif
}

/****************************************************************************/
/* Set number of memory refresh wait states (i.e. extra cycles inserted     */
/* when the refresh register is being incremented)                          */
/****************************************************************************/
void Z80_SetWaitStates (int n)
{
 int i;
 for (i=0;i<256;++i)
 {
  cycles_main[i]+=n;
  cycles_cb[i]+=n;
  cycles_ed[i]+=n;
  cycles_xx[i]+=n;
 }
}

void Z80_Patch (Z80_Regs *Regs)
{
}

int Z80_Interrupt(void)
{
	--intrpt;
    if (intrpt == 0)
	{
		intrpt = intrptm;
		return(0);
    }
    else
		return(Z80_IRQ);
}

void Z80_Reti (void)
{
}

void Z80_Retn (void)
{
}

//ports
byte Z80_In (byte Port)
{
	int i;
	switch (Port)
    {
    	case 0:
           	break;
        case 1:
            if (hw86->colscan == 128)
            	return(0);
            else
            {
    			if (hw86->rowscan != 0xffff)
                	dummy = 1;
            	if ( ~( ((hw86->colscan << 8)|0xffff00ff) | (hw86->rowscan | 0xffff00ff) ) )
                	return(hw86->rowscan & 0xff);
                else
                	return(0xff);
            }
        	break;
        case 2:
        	break;
        case 3:
            //i = port3word;
            //port3word = 8;
            if (++hw86->port3acc == 10000)
            {
                if (R.IFF1 == 0)
            		hw86->port3word = 10;
                else
                	hw86->port3word = 8;
                hw86->port3acc = 9999;
            }
        	return(hw86->port3word);
        	break;
        case 4:
        	break;
        case 5:
        	if (hw86->banksel0 < 16)
            {
            	return(hw86->banksel0);
            }
            else
            {
            	return(hw86->banksel0+48);
            }
            break;
        case 6:
			if (hw86->machtype == 1)
			{
            	return(hw86->port6word);
            }
            else
            {
	        	if (hw86->banksel1 < 16)
	            {
	            	return(hw86->banksel1);
	            }
	            else
	            {
	            	return(hw86->banksel1+48);
	            }
            }
            break;
        case 7:
        	return(3);
    }
}

void Z80_Out (byte Port,byte Value)
{
	int i;
	switch (Port)
    {
    	case 0:
           	break;
        case 1:
        	hw86->colscan = Value|0x80;
        	break;
        case 2:
        	break;
        case 3:
        	break;
        case 4:
        	break;
        case 5:
        	if (Value < 64)
            {
                if (Value >= 16)
                	i = Value%16;
            	hw86->banksel0 = Value;
            }
            else
            {
                //26974

				if (Value >= 128)
                {
                	hw86->wierdmem0 = 1;
                    hw86->banksel0 = 0;
                    return;
                }
                if (Value >= 72)
                {
                    i = (Value - 64)%8;
                	Value = i + 64;
                }
                hw86->banksel0 = Value-48;
                hw86->wierdmem0 = 0;
            }
            if (hw86->banksel0 < 0) hw86->banksel0 = 0;
            //createz80tophysaddrtab();
            break;
        case 6:
            if (hw86->machtype == 1)
            {
                // TI85, do nothing (for now)
				hw86->port6word = Value;
            }
            else
            {
	        	if (Value < 64)
	            {
	                if (Value >= 16)
	                	i = Value%16;
	            	hw86->banksel1 = Value;
	            }
	            else
	            {
	                //26974
					if (Value >= 128)
	                {
	                	hw86->wierdmem1 = 1;
                        hw86->banksel1 = 0;
	                    return;
	                }
	                if (Value >= 72)
	                {
	                    i = (Value - 64)%8;
	                	Value = i + 64;
	                }
	                hw86->banksel1 = Value-48;
	                hw86->wierdmem1 = 0;
	            }
                if (hw86->banksel1 < 0) hw86->banksel1 = 0;
            }
            //createz80tophysaddrtab();
            break;
    }
}

INLINE unsigned Z80_RDMEM(dword A)
{
	if (wks.enabletrap)
    {
		if (A == wks.trapaddr)
	    	wks.trap = 1;
    }
	if (A >= 0xc000)
    	return(hw86->mainmem[A-modifierc+0x40000]);
    else if (A >= 0x8000)
		return(hw86->mainmem[(A-modifier8)+((hw86->banksel1)<<14)]);
    else if (A >= 0x4000)
    	return(hw86->mainmem[(A-0x4000)+((hw86->banksel0)<<14)]);
    else
    	return(hw86->mainmem[A]);
}

INLINE void Z80_WRMEM(dword A,byte V)
{
//wwwwww
    long physaddr;
    long i,j,row,col;
    long base,offs;

	if (A >= 0xc000)
   		physaddr = (A-modifierc+0x040000);
    else if (A >= 0x8000)
   		physaddr = (A-modifier8)+((hw86->banksel1)<<14);
    else if (A >= 0x4000)
		physaddr = (A-0x4000)+((hw86->banksel0)<<14);
    else
		physaddr = A;
   	if (physaddr >= 262144)
    	hw86->mainmem[physaddr]=V;
	if (physaddr >= graphmem && physaddr < graphmem+0x400)
 	{
        if (wks.scrnsize == 0)
        {
            i = longbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbitsdatatab[V][0];
	        longBits[i+1]=longbitsdatatab[V][1];
	        longBits[i+2]=longbitsdatatab[V][2];
	        longBits[i+3]=longbitsdatatab[V][3];
	        longBits[i+4]=longbitsdatatab[V][4];
	        longBits[i+5]=longbitsdatatab[V][5];
        }
        else
        {
            i = longbigbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];

			i += 192;
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];
        }
    }
	if (wks.enabletrap)
    {
		if (A == wks.trapaddr)
	    	wks.trap = 1;
	}
}

INLINE void Z80_WRMEM2(dword A,byte V) // allow writes to ROM
{
    long physaddr;
    long i,j,row,col;
    long base,offs;

	if (A >= 0xc000)
    	//physaddr = z80tophysaddrtab[A];
   		physaddr = (A-modifierc+0x040000);
    else if (A >= 0x8000)
   		physaddr = (A-modifier8)+((hw86->banksel1)<<14);
    else if (A >= 0x4000)
		physaddr = (A-0x4000)+((hw86->banksel0)<<14);
    else
		physaddr = A;
   	//if (physaddr >= 262144)
    	hw86->mainmem[physaddr]=V;
	if (physaddr >= graphmem && physaddr < graphmem+0x400)
 	{
        if (wks.scrnsize == 0)
        {
            i = longbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbitsdatatab[V][0];
	        longBits[i+1]=longbitsdatatab[V][1];
	        longBits[i+2]=longbitsdatatab[V][2];
	        longBits[i+3]=longbitsdatatab[V][3];
	        longBits[i+4]=longbitsdatatab[V][4];
	        longBits[i+5]=longbitsdatatab[V][5];
        }
        else
        {
            i = longbigbitsaddrtab[physaddr-graphmem];
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];

			i += 192;
			longBits[i]=longbigbitsdatatab[V][0];
	        longBits[i+1]=longbigbitsdatatab[V][1];
	        longBits[i+2]=longbigbitsdatatab[V][2];
	        longBits[i+3]=longbigbitsdatatab[V][3];
	        longBits[i+4]=longbigbitsdatatab[V][4];
	        longBits[i+5]=longbigbitsdatatab[V][5];
			longBits[i+6]=longbigbitsdatatab[V][6];
	        longBits[i+7]=longbigbitsdatatab[V][7];
	        longBits[i+8]=longbigbitsdatatab[V][8];
	        longBits[i+9]=longbigbitsdatatab[V][9];
	        longBits[i+10]=longbigbitsdatatab[V][10];
	        longBits[i+11]=longbigbitsdatatab[V][11];
        }
    }
}


void __fastcall Tmaincalc::FormCloseQuery(TObject *Sender, bool &CanClose)
{
    CanClose = true;
    wks.brk = 1;
    wks.shutdwn = 1;

}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::Timer1Timer(TObject *Sender)
{
    Timer1->Enabled = 0;
	runbutton->Checked = true;
}
//---------------------------------------------------------------------------
void __fastcall Tmaincalc::trapbuttonClick(TObject *Sender)
{
	long i;
    
	sprintf(tempbuf, "$%04x", wks.trapaddr);
    strupr(tempbuf);
    inputbox->answer1->Text = tempbuf;
    inputbox->prompt->Caption = "Enter the trap address";
	inputbox->ShowModal();
    if (inputbox->cancel == 0)
	{
	    strcpy(tempbuf, inputbox->answer1->Text.c_str() );
	    i = extract(tempbuf, wks.numformat, &ans);
	    wks.trapaddr = i;
    }
  	dummyedit->SetFocus();
}
//---------------------------------------------------------------------------
