#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <dos.h>
#include <dpmi.h>
#include <sys/farptr.h>
#include <go32.h>
#include <dzcomm.h>
#include <kb.h>
#include "ti8xemu.h"
#include "z80.h"
#include "z80io.h"
#include "hardware.h"

static comm_port* Comm;

byte invert[4] = {3,1,2,0};

byte BMPheader[0x3E] = { 0x42,0x4D,0x40,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
                         0x3E,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x60,0x00,
                         0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x00,0x01,0x00,
                         0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x0B,
                         0x00,0x00,0x12,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,
                         0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
                         0x00,0x00 };

inline byte KeyboardRead(void)
{
		kb_update();

		if((KeypadMask == 0xFF) || !kb_keys_pressed())
                        return 0xFF;
	     
		xByte = 0xFF;

		if((CALC == 82) || (CALC == 83))
		{
		if(~KeypadMask&1)
		{
			if(kb_key(KB_SCAN_DOWN))
				xByte ^= 1;
			if(kb_key(KB_SCAN_LEFT))
				xByte ^= 2;
			if(kb_key(KB_SCAN_RIGHT))
				xByte ^= 4;
			if(kb_key(KB_SCAN_UP))
				xByte ^= 8;
		}

		if(~KeypadMask&2)
		{
			if(kb_key(KB_SCAN_ENTER) || kb_key(KB_SCAN_ENTER_PAD))
				xByte ^= 1;
			if(kb_key(KB_SCAN_PLUS_PAD))
				xByte ^= 2;
			if(kb_key(KB_SCAN_MINUS_PAD) || kb_key(KB_SCAN_W))
				xByte ^= 4;
			if(kb_key(KB_SCAN_MULTIPLY_PAD) || kb_key(KB_SCAN_R))
				xByte ^= 8;
			if(kb_key(KB_SCAN_DIVIDE_PAD) || kb_key(KB_SCAN_SLASH) || kb_key(KB_SCAN_M))
				xByte ^= 16;
			if(kb_key(KB_SCAN_BACKQUOTE) || kb_key(KB_SCAN_H))
				xByte ^= 32;
			if(kb_key(KB_SCAN_BACKSPACE))
				xByte ^= 64;
		}

		if(~KeypadMask&4)
		{
			if(kb_key(KB_SCAN_MINUS))
				xByte ^= 1;
			if(kb_key(KB_SCAN_3) || kb_key(KB_SCAN_3_PAD))
				xByte ^= 2;
			if(kb_key(KB_SCAN_6) || kb_key(KB_SCAN_6_PAD) || kb_key(KB_SCAN_V))
				xByte ^= 4;
			if(kb_key(KB_SCAN_9) || kb_key(KB_SCAN_9_PAD) || kb_key(KB_SCAN_Q))
				xByte ^= 8;
			if(kb_key(KB_SCAN_CLOSEBRACE) || kb_key(KB_SCAN_L))
				xByte ^= 16;
			if(kb_key(KB_SCAN_G))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F10))
				xByte ^= 64;
		}

		if(~KeypadMask&8)
		{
			if(kb_key(KB_SCAN_PERIOD) || kb_key(KB_SCAN_PERIOD_PAD))
				xByte ^= 1;
			if(kb_key(KB_SCAN_2) || kb_key(KB_SCAN_2_PAD) || kb_key(KB_SCAN_Z))
				xByte ^= 2;
			if(kb_key(KB_SCAN_5) || kb_key(KB_SCAN_5_PAD) || kb_key(KB_SCAN_U))
				xByte ^= 4;
			if(kb_key(KB_SCAN_8) || kb_key(KB_SCAN_8_PAD) || kb_key(KB_SCAN_P))
				xByte ^= 8;
			if(kb_key(KB_SCAN_OPENBRACE) || kb_key(KB_SCAN_K))
				xByte ^= 16;
			if(kb_key(KB_SCAN_F))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F9) || kb_key(KB_SCAN_C))
				xByte ^= 64;
			if(kb_key(KB_SCAN_F6))
				xByte ^= 128;
		}

		if(~KeypadMask&16)
		{
			if(kb_key(KB_SCAN_0) || kb_key(KB_SCAN_0_PAD) || kb_key(KB_SCAN_SPACE))
				xByte ^= 1;
			if(kb_key(KB_SCAN_1) || kb_key(KB_SCAN_1_PAD) || kb_key(KB_SCAN_Y))
				xByte ^= 2;
			if(kb_key(KB_SCAN_4) || kb_key(KB_SCAN_4_PAD) || kb_key(KB_SCAN_T))
				xByte ^= 4;
			if(kb_key(KB_SCAN_7) || kb_key(KB_SCAN_7_PAD) || kb_key(KB_SCAN_O))
				xByte ^= 8;
			if(kb_key(KB_SCAN_COMMA) || kb_key(KB_SCAN_J))
				xByte ^= 16;
			if(kb_key(KB_SCAN_E))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F8) || kb_key(KB_SCAN_B))
				xByte ^= 64;
			if(kb_key(KB_SCAN_QUOTE))
				xByte ^= 128;
		}

		if(~KeypadMask&32)
		{
			if(kb_key(KB_SCAN_EQUAL) || kb_key(KB_SCAN_X))
				xByte ^= 2;
			if(kb_key(KB_SCAN_S))
				xByte ^= 4;
			if(kb_key(KB_SCAN_N))
				xByte ^= 8;
			if(kb_key(KB_SCAN_I))
				xByte ^= 16;
			if(kb_key(KB_SCAN_D))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F7) || kb_key(KB_SCAN_A))
				xByte ^= 64;
			if(kb_key(KB_SCAN_LCONTROL) || kb_key(KB_SCAN_RCONTROL))
				xByte ^= 128;
		}

		if(~KeypadMask&64)
		{
			if(kb_key(KB_SCAN_F5))
				xByte ^= 1;
			if(kb_key(KB_SCAN_F4))
				xByte ^= 2;
			if(kb_key(KB_SCAN_F3))
				xByte ^= 4;
			if(kb_key(KB_SCAN_F2))
				xByte ^= 8;
			if(kb_key(KB_SCAN_F1))
				xByte ^= 16;
			if(kb_key(KB_SCAN_LSHIFT) || kb_key(KB_SCAN_RSHIFT))
				xByte ^= 32;
			if(kb_key(KB_SCAN_ESC))
				xByte ^= 64;
			if(kb_key(KB_SCAN_DELETE) || kb_key(KB_SCAN_INSERT))
				xByte ^= 128;
		}
		}

		if((CALC == 85) || (CALC == 86))
		{
		if(~KeypadMask&1)
		{
			if(kb_key(KB_SCAN_DOWN))
				xByte ^= 1;
			if(kb_key(KB_SCAN_LEFT))
				xByte ^= 2;
			if(kb_key(KB_SCAN_RIGHT))
				xByte ^= 4;
			if(kb_key(KB_SCAN_UP))
				xByte ^= 8;
		}

		if(~KeypadMask&2)
		{
			if(kb_key(KB_SCAN_ENTER) || kb_key(KB_SCAN_ENTER_PAD))
				xByte ^= 1;
			if(kb_key(KB_SCAN_PLUS_PAD) || kb_key(KB_SCAN_X))
				xByte ^= 2;
			if(kb_key(KB_SCAN_MINUS_PAD) || kb_key(KB_SCAN_T))
				xByte ^= 4;
			if(kb_key(KB_SCAN_MULTIPLY_PAD) || kb_key(KB_SCAN_O))
				xByte ^= 8;
			if(kb_key(KB_SCAN_DIVIDE_PAD) || kb_key(KB_SCAN_SLASH) || kb_key(KB_SCAN_J))
				xByte ^= 16;
			if(kb_key(KB_SCAN_BACKQUOTE) || kb_key(KB_SCAN_E))
				xByte ^= 32;
			if(kb_key(KB_SCAN_BACKSPACE))
				xByte ^= 64;
		}

		if(~KeypadMask&4)
		{
			if(kb_key(KB_SCAN_MINUS) || kb_key(KB_SCAN_SPACE))
				xByte ^= 1;
			if(kb_key(KB_SCAN_3) || kb_key(KB_SCAN_3_PAD) || kb_key(KB_SCAN_W))
				xByte ^= 2;
			if(kb_key(KB_SCAN_6) || kb_key(KB_SCAN_6_PAD) || kb_key(KB_SCAN_S))
				xByte ^= 4;
			if(kb_key(KB_SCAN_9) || kb_key(KB_SCAN_9_PAD) || kb_key(KB_SCAN_N))
				xByte ^= 8;
			if(kb_key(KB_SCAN_CLOSEBRACE) || kb_key(KB_SCAN_I))
				xByte ^= 16;
			if(kb_key(KB_SCAN_D))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F10))
				xByte ^= 64;
		}

		if(~KeypadMask&8)
		{
			if(kb_key(KB_SCAN_PERIOD) || kb_key(KB_SCAN_PERIOD_PAD) || kb_key(KB_SCAN_Z))
				xByte ^= 1;
			if(kb_key(KB_SCAN_2) || kb_key(KB_SCAN_2_PAD) || kb_key(KB_SCAN_V))
				xByte ^= 2;
			if(kb_key(KB_SCAN_5) || kb_key(KB_SCAN_5_PAD) || kb_key(KB_SCAN_R))
				xByte ^= 4;
			if(kb_key(KB_SCAN_8) || kb_key(KB_SCAN_8_PAD) || kb_key(KB_SCAN_M))
				xByte ^= 8;
			if(kb_key(KB_SCAN_OPENBRACE) || kb_key(KB_SCAN_H))
				xByte ^= 16;
			if(kb_key(KB_SCAN_C))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F9))
				xByte ^= 64;
			if(kb_key(KB_SCAN_DELETE) || kb_key(KB_SCAN_INSERT))
				xByte ^= 128;
		}

		if(~KeypadMask&16)
		{
			if(kb_key(KB_SCAN_0) || kb_key(KB_SCAN_0_PAD) || kb_key(KB_SCAN_Y))
				xByte ^= 1;
			if(kb_key(KB_SCAN_1) || kb_key(KB_SCAN_1_PAD) || kb_key(KB_SCAN_U))
				xByte ^= 2;
			if(kb_key(KB_SCAN_4) || kb_key(KB_SCAN_4_PAD) || kb_key(KB_SCAN_Q))
				xByte ^= 4;
			if(kb_key(KB_SCAN_7) || kb_key(KB_SCAN_7_PAD) || kb_key(KB_SCAN_L))
				xByte ^= 8;
			if(kb_key(KB_SCAN_G))
				xByte ^= 16;
			if(kb_key(KB_SCAN_B))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F8))
				xByte ^= 64;
			if(kb_key(KB_SCAN_QUOTE))
				xByte ^= 128;
		}

		if(~KeypadMask&32)
		{
			if(kb_key(KB_SCAN_EQUAL))
				xByte ^= 2;
			if(kb_key(KB_SCAN_COMMA) || kb_key(KB_SCAN_P))
				xByte ^= 4;
			if(kb_key(KB_SCAN_K))
				xByte ^= 8;
			if(kb_key(KB_SCAN_F))
				xByte ^= 16;
			if(kb_key(KB_SCAN_A))
				xByte ^= 32;
			if(kb_key(KB_SCAN_F7))
				xByte ^= 64;
			if(kb_key(KB_SCAN_LCONTROL) || kb_key(KB_SCAN_RCONTROL))
				xByte ^= 128;
		}

		if(~KeypadMask&64)
		{
			if(kb_key(KB_SCAN_F5))
				xByte ^= 1;
			if(kb_key(KB_SCAN_F4))
				xByte ^= 2;
			if(kb_key(KB_SCAN_F3))
				xByte ^= 4;
			if(kb_key(KB_SCAN_F2))
				xByte ^= 8;
			if(kb_key(KB_SCAN_F1))
				xByte ^= 16;
			if(kb_key(KB_SCAN_LSHIFT) || kb_key(KB_SCAN_RSHIFT))
				xByte ^= 32;
			if(kb_key(KB_SCAN_ESC))
				xByte ^= 64;
			if(kb_key(KB_SCAN_TAB))
				xByte ^= 128;
		}
		}
		
	return xByte;
}

inline byte LinkRecv(void)
{
		if(CALC == 83)
                {
                        if(LINK == 'G')
                        {                              
                                if(!queue_empty(Comm->InBuf) && !LinkRecvBit && !LinkRecvAgain)
                                {                                                         
                                        LinkRecvByte = (char)comm_port_test(Comm);
                                        LinkRecvBit = 1;
                                        LinkReg = 3;                                     
                                }

                                if(LinkRecvBit || LinkRecvAgain)
                                {
                                        LinkRecvAgain = 0;

                                        if(LinkReg == 0)
                                        {
                                                LinkReg = 3;                                                
                                                return ((Sector1_Page & 8) << 1) | 0xC;
                                        }
                                        if(LinkReg == 1)
                                                return ((Sector1_Page & 8) << 1) | LinkReg | 8;
                                        if(LinkReg == 2)
                                                return ((Sector1_Page & 8) << 1) | LinkReg | 4;                                        
                                        
                                        xByte = ((Sector1_Page & 8) << 1) | LinkReg | ((LinkRecvByte & LinkRecvBit) ? 4 : 8);

                                        return xByte;
                                }

                                if((LinkReg == 1) || (LinkReg == 2))
                                        return ((Sector1_Page & 8) << 1) | LinkReg;                            

                                return ((Sector1_Page & 8) << 1) | LinkReg | 0xC;
                        }
                        if(LINK == 'P')
                                return ((Sector1_Page & 8) << 1) | LinkReg | ((inp(LinkPort+1) & 0x30) >> 2);
                        if(LINK == 'S')
                                return ((Sector1_Page & 8) << 1) | LinkReg | ((inp(LinkPort+6) & 0x30) >> 2);
                        if(LINK == 'K')
                                return ((Sector1_Page & 8) << 1) | LinkReg | 0xC;                  
                }
                else
                {
                        if(LINK == 'G')
                        {                              
                                if(!queue_empty(Comm->InBuf) && !LinkRecvBit && !LinkRecvAgain)
                                {                   
                                        LinkRecvByte = (char)comm_port_test(Comm);
                                        LinkRecvBit = 1;
                                        LinkReg = 3;                                     
                                }

                                if(LinkRecvBit || LinkRecvAgain)
                                {
                                        LinkRecvAgain = 0;

                                        if(LinkReg == 0)
                                        {
                                                LinkReg = 3;                                                
                                                return 3;
                                        }
                                        if(LinkReg == 1)
                                                return (LinkReg << 2) | 2;
                                        if(LinkReg == 2)
                                                return (LinkReg << 2) | 1;                                        
                                        
                                        xByte = (LinkReg << 2) | ((LinkRecvByte & LinkRecvBit) ? 1 : 2);

                                        return xByte;
                                }

                                if((LinkReg == 1) || (LinkReg == 2))
                                        return LinkReg << 2;                            

                                return (LinkReg << 2) | 3;
                        }
                        if(LINK == 'P')
                                return (LinkReg << 2) | ((inp(LinkPort+1) & 0x30) >> 4);
                        if(LINK == 'S')
                                return (LinkReg << 2) | ((inp(LinkPort+6) & 0x30) >> 4);
                        if(LINK == 'K')
                                return (LinkReg << 2) | 3;                  
                }
}

inline void LinkSend(byte Value)
{
		if(CALC == 83)
		{
                        Sector1_Page = (Sector1_Page & 7) | ((Value & 16) >> 1);                                         

                        LinkReg = Value & 3;

                        if(LINK == 'G')
                        {                                
                                switch(LinkReg)
                                {
                                        case 1:
                                                if(!LinkRecvBit)
                                                {
                                                        if(!LinkSendBit)
                                                                LinkSendBit = 1;                                                                                                                                                                                    

                                                        LinkSendBit <<= 1;

                                                        if(!LinkSendBit)
                                                        {
                                                                comm_port_out(Comm,LinkSendByte);
                                                                LinkSendByte = 0;
                                                        }                                                    
                                                }
                                                else
                                                {
                                                        LinkRecvBit <<= 1;

                                                        if(!LinkRecvBit)
                                                                LinkRecvAgain = 1;
                                                }
                                                break;
                                        case 2:
                                                if(!LinkRecvBit)
                                                {
                                                        if(!LinkSendBit)
                                                                LinkSendBit = 1;

                                                        LinkSendByte |= LinkSendBit;

                                                        LinkSendBit <<= 1;

                                                        if(!LinkSendBit)
                                                        {
                                                                comm_port_out(Comm,LinkSendByte);
                                                                LinkSendByte = 0;
                                                        }
                                                }
                                                else
                                                {
                                                        LinkRecvBit <<= 1;

                                                        if(!LinkRecvBit)
                                                                LinkRecvAgain = 1;
                                                }
                                }                                    
                        }

                        if(LINK == 'P')
                                outp(LinkPort, invert[LinkReg]);
                        if(LINK == 'S')                                
                                outp(LinkPort+4, invert[LinkReg]);                                                           
                        if(LINK == 'K')
                                outp(0x61, (inp(0x61) &~ 0x03) | (LinkReg ? 0x2 : 0x0));
		}
                else
		{                   
                        LinkReg = (Value & 0xC) >> 2;

                        if(LINK == 'G')
                        {                                
                                switch(LinkReg)
                                {
                                        case 1:
                                                if(!LinkRecvBit)
                                                {
                                                        if(!LinkSendBit)
                                                                LinkSendBit = 1;                                                                                                                                                                                    

                                                        LinkSendBit <<= 1;

                                                        if(!LinkSendBit)
                                                        {
                                                                comm_port_out(Comm,LinkSendByte);
                                                                LinkSendByte = 0;
                                                        }                                                    
                                                }
                                                else
                                                {
                                                        LinkRecvBit <<= 1;

                                                        if(!LinkRecvBit)
                                                                LinkRecvAgain = 1;
                                                }
                                                break;
                                        case 2:
                                                if(!LinkRecvBit)
                                                {
                                                        if(!LinkSendBit)
                                                                LinkSendBit = 1;

                                                        LinkSendByte |= LinkSendBit;

                                                        LinkSendBit <<= 1;

                                                        if(!LinkSendBit)
                                                        {
                                                                comm_port_out(Comm,LinkSendByte);
                                                                LinkSendByte = 0;
                                                        }
                                                }
                                                else
                                                {
                                                        LinkRecvBit <<= 1;

                                                        if(!LinkRecvBit)
                                                                LinkRecvAgain = 1;
                                                }
                                }                                    
                        }
                                        
                        if(LINK == 'P')
                                outp(LinkPort, invert[LinkReg]);
                        if(LINK == 'S')                                
                                outp(LinkPort+4, invert[LinkReg]);                                                           
                        if(LINK == 'K')
                                outp(0x61, (inp(0x61) &~ 0x03) | (LinkReg ? 0x2 : 0x0));
		}
}

byte Z80_In(byte Port)
{   
        Port &= ((CALC == 82) || (CALC == 83)) ? 0x17 : 0x27;
	
	switch(Port)
	{
	case 0x00:
                if((CALC == 82) || (CALC == 83))
                        return LinkRecv();
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	case 0x01:           
		return KeyboardRead();
	case 0x02:
		if((CALC == 82) || (CALC == 83))
			return (Sector1_Page & 7) | 0x88;               
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	case 0x03:
                xByte = 0;

                if(kb_key(KB_SCAN_BACKSLASH))
                        xByte |= ONmask;
                else
			xByte |= 8;
            
                if(LCDon)
                        xByte |= LCDmask;

		return xByte;
	case 0x04:
		if(CALC == 86)
			return PowerReg;
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	case 0x05:
		if(CALC == 85)
			return Sector1_Page;
		if(CALC == 86)
			return Sector1_Page | Sector1_Type;
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	case 0x06:                                                                    
		if(CALC == 85)
			return PowerReg;
		if(CALC == 86)
			return Sector2_Page | Sector2_Type;
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
        case 0x07:       
                if((CALC == 85) || (CALC == 86))
                        return LinkRecv();
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	case 0x11:
		if((CALC == 82) || (CALC == 83))
		{                                                   
			if(VidDir == 4)
				++VidY;
			if(VidDir == 5)
				--VidY;
			if(VidDir == 6)
				++VidX;
			if(VidDir == 7)
				--VidX;

			if(VidMode)
				xByte = VidRAM[(12*VidY)+VidX];
			else
			{
				VidCol = VidX * 6;                                                                                                
				VidBit = VidCol & 7;
				VidPtr = &VidRAM[(VidY*12)+(VidCol>>3)];
				xByte = ((((*VidPtr)<<8)+VidPtr[1])>>(10-VidBit));
			}

			if(VidDir == 4)
				VidY-=2;
			if(VidDir == 5)
				VidY+=2;
			if(VidDir == 6)
				VidX-=2;
			if(VidDir == 7)
				VidX+=2;

			VidX &= 15;
			VidY &= 63;

			return xByte;
		}                     
	default:
                return ((CALC == 82) || (CALC == 83)) ? 0x08 : 0x78;
	}
}

void Z80_Out(byte Port,byte Value)
{
        Port &= ((CALC == 82) || (CALC == 83)) ? 0x17 : 0x27;

	switch(Port)
	{
	case 0x00:
                if((CALC == 82) || (CALC == 83))
                        LinkSend(Value);
                else
			VidOffset = Value;
		return;
	case 0x01:
		KeypadMask = Value;
		return;
	case 0x02:
		if(CALC == 82)
			Sector1_Page = Value & 7;
		if(CALC == 83)
			Sector1_Page = (Sector1_Page & 8) | (Value & 7);
                if((CALC == 85) || (CALC == 86))
                        Contrast = Value;
		return;
	case 0x03:                                                                        
		ONmask = Value & 1;
                LCDmask = Value & 2;
                LCDon = Value & 8;
		return;
	case 0x04:
		if(CALC == 86)
			PowerReg = Value & 0xC1;
		return;
	case 0x05:
		if(CALC == 85)             
			Sector1_Page = Value & 7;
		if(CALC == 86)
		{
			Sector1_Type = Value & 0x40;
			Sector1_Page = Value & 15;
		}
		return;
	case 0x06:
		if(CALC == 85)
			PowerReg = Value & 0xC1;
		if(CALC == 86)
		{
			Sector2_Type = Value & 0x40;
			Sector2_Page = Value & 15;
		}
		return;
	case 0x07:
                if((CALC == 85) || (CALC == 86))
                        LinkSend(Value);
		return;
	case 0x10:
		if((CALC == 82) || (CALC == 83))
		{
			if((Value == 0) || (Value == 1))
				VidMode = Value;
			if((Value >= 0x20) && (Value <= 0x30))
				VidX = Value - 0x20;
			if((Value >= 0x80) && (Value <= 0xBF))
				VidY = Value - 0x80;
			if((Value == 4) || (Value == 5) || (Value == 6) || (Value == 7))
				VidDir = Value;
                        if((Value >= 0x40) && (Value <= 0x7F))
                                VidScroll = Value - 0x40;
                        if(Value >= 0xD8)
                                Contrast = Value - 0xD8;
		}
		return;                    
	case 0x11:
		if((CALC == 82) || (CALC == 83))
		{
			if(VidMode)                        
				VidRAM[(12*VidY)+VidX] = Value;
			else
			{
				Value = Value<<2;
				VidCol = VidX * 6;                                                                                                
				VidBit = VidCol & 7;
				VidPtr = &VidRAM[(VidY*12)+(VidCol>>3)];
				*VidPtr = (*VidPtr & ~(0xFC>>VidBit)) | (Value>>VidBit);
				if(VidBit>2)
					VidPtr[1] = (VidPtr[1] & ~(0xFC<<(8-VidBit))) | (Value<<(8-VidBit));
			}

			if(VidDir == 4)
				--VidY;
			if(VidDir == 5)
				++VidY;
			if(VidDir == 6)
				--VidX;
			if(VidDir == 7)
				++VidX;

			VidX &= 15;
			VidY &= 63;
		}                    
	}
}

int Address(dword addr)
{
	int return_addr = (int)addr;

	if((CALC == 82) || (CALC == 83) || (CALC == 85))
	{
		if((return_addr >= 0x4000) && (return_addr < 0x8000))
		{
			Mem_Type = 0;                                                                
			return_addr = return_addr - 0x4000 + (0x4000 * (int)Sector1_Page);
		}

		else if(return_addr < 0x4000)
		{
			Mem_Type = 0;
		}

		else if(return_addr >= 0x8000)
		{
			Mem_Type = 1;
			return_addr -= 0x8000;
		}         
	}

	if(CALC == 86)
	{
		if((return_addr >= 0x4000) && (return_addr < 0x8000))
		{
			Mem_Type = Sector1_Type;
			return_addr = return_addr - 0x4000 + (0x4000 * (int)Sector1_Page);
		}

		else if((return_addr >= 0x8000) && (return_addr < 0xC000))
		{
			Mem_Type = Sector2_Type; 
			return_addr = return_addr - 0x8000 + (0x4000 * (int)Sector2_Page);
		}

		else if(return_addr < 0x4000)
		{
			Mem_Type = 0;
		}

		else if(return_addr >= 0xC000)
		{
			Mem_Type = 1;
			return_addr -= 0xC000;
		}
	}

	return return_addr;
}

unsigned Z80_RDMEM(dword A)
{
	int addr;

	addr = Address(A);

	if(Mem_Type)
		return RAM[addr];
	else
		return ROM[addr];

}

void Z80_WRMEM(dword A,byte V)
{
	int addr;

	addr = Address(A);

	if(Mem_Type)
		RAM[addr] = V;
}

void Z80_Reti(void)
{
}

void Z80_Retn(void)
{
}

void Z80_Patch(Z80_Regs* Regs)
{
}

int Z80_Interrupt(void)
{
	kb_update();
	
        if(kb_key(KB_SCAN_END))
                TICalcDebug();

	if(kb_key(KB_SCAN_F11))
		TICalcExit(1);      

	if(kb_key(KB_SCAN_F12))                 
		TICalcExit(0);      

        if(!key_stuck && kb_keys_pressed())
        {
                key_stuck = 1;

                if(kb_key(KB_SCAN_PGUP))
                        SaveRAM();

                if(kb_key(KB_SCAN_PGDN))
                        LoadRAM();

                if(kb_key(KB_SCAN_HOME))
                        SnapShot();
        }

        if(!kb_keys_pressed())
                key_stuck = 0;

	DrawScreen();

        return 0xFF;
}

void TICalcExit(byte DoSaveRAM)
{      
	SetVideoMode(3);

        if(DoSaveRAM)
	{
                SaveRAM();
                printf("RAM image saved to: %s\n",SAVfilename);
	}
	else
                printf("RAM image not saved\n");
	
	exit(0);
}

void LoadMEM(char* rfilename,char* sfilename)
{                      
        if(CALC == 82)
        {
                ROMSIZE = 0x20000;
                RAMSIZE = 0x7FFF;
                SAVSIZE = 0x832B;
                BMPSIZE = 0x340;
                VIDJUMP = 7;
                LCDWIDTH = 3;                
        }
        if(CALC == 83)
        {
                ROMSIZE = 0x40000;
                RAMSIZE = 0x7FFF;
                SAVSIZE = 0x832C;
                BMPSIZE = 0x340;
                VIDJUMP = 7;
                LCDWIDTH = 3;
        }
        if(CALC == 85)
        {
                ROMSIZE = 0x20000;
                RAMSIZE = 0x7FFF;
                SAVSIZE = 0x8028;
                BMPSIZE = 0x440;
                VIDJUMP = 6;
                LCDWIDTH = 4;
        }
        if(CALC == 86)
        {
                ROMSIZE = 0x40000;
                RAMSIZE = 0x1FFFF;
                SAVSIZE = 0x20029;
                BMPSIZE = 0x440;
                VIDJUMP = 6;
                LCDWIDTH = 4;
        }

        strcpy(ROMfilename,rfilename);
        strcpy(SAVfilename,sfilename);

        LoadROM();
	LoadRAM();
}

void LoadROM(void)
{
        fh_ROM = open(ROMfilename,O_RDONLY|O_BINARY,S_IREAD);

        if((fh_ROM == -1) || (filelength(fh_ROM) != ROMSIZE))
        {
                printf("\aError loading %s!\n",ROMfilename);
                exit(-1);
        }

        read(fh_ROM,ROM,ROMSIZE);

        close(fh_ROM);
}

void LoadRAM(void)
{        		                           
        memset(VidRAM,0xFF,768);

        fh_SAV = open(SAVfilename,O_RDONLY|O_BINARY,S_IREAD);

        if(fh_SAV == -1)
        {
                memset(RAM,0xFF,SAVSIZE);
                InitRAM = 1;
        }
        else
        {                           
                if(filelength(fh_SAV) != SAVSIZE)
                {
                        printf("\aError loading %s!\n",SAVfilename);
                        exit(-1);
                }

                read(fh_SAV,RAM,SAVSIZE);

                close(fh_SAV);
	}

        if(InitRAM)
	{          
		for(xInt = 0; xInt <= 0x4000; ++xInt)           
		{
			if(CALC == 86)
			{
				if((ROM[xInt] == 0x3E) && (ROM[xInt+1] == 0x56) &&
					(ROM[xInt+2] == 0xD3) && (ROM[xInt+3] == 0x04))
					{
						R.PC.W.l = xInt;
						break;
					}
			}
			else
			{
				if((ROM[xInt] == 0x3E) && (ROM[xInt+1] == 0x16) &&
					(ROM[xInt+2] == 0xD3) && (ROM[xInt+3] == 0x04))
					{
						R.PC.W.l = xInt;
						break;
					}
			}
		}
		return;
	}

        xInt = RAMSIZE;

	R.AF.B.h = RAM[++xInt];
	R.AF.B.l = RAM[++xInt];
	R.BC.B.h = RAM[++xInt];
	R.BC.B.l = RAM[++xInt];
	R.DE.B.h = RAM[++xInt];
	R.DE.B.l = RAM[++xInt];
	R.HL.B.h = RAM[++xInt];
	R.HL.B.l = RAM[++xInt];
	R.IX.B.h = RAM[++xInt];
	R.IX.B.l = RAM[++xInt];
	R.IY.B.h = RAM[++xInt];
	R.IY.B.l = RAM[++xInt];
	R.PC.B.h = RAM[++xInt];
	R.PC.B.l = RAM[++xInt];
	R.SP.B.h = RAM[++xInt];
	R.SP.B.l = RAM[++xInt];
	R.AF2.B.h = RAM[++xInt];
	R.AF2.B.l = RAM[++xInt];
	R.BC2.B.h = RAM[++xInt];
	R.BC2.B.l = RAM[++xInt];
	R.DE2.B.h = RAM[++xInt];
	R.DE2.B.l = RAM[++xInt];
	R.HL2.B.h = RAM[++xInt];
	R.HL2.B.l = RAM[++xInt];
	R.IFF1 = RAM[++xInt];
	R.IFF2 = RAM[++xInt];
	R.HALT = RAM[++xInt];
	R.IM = RAM[++xInt];
	R.I = RAM[++xInt];
	R.R = RAM[++xInt];
	R.R2 = RAM[++xInt];

	KeypadMask = RAM[++xInt];
	ONmask = RAM[++xInt];
        LinkReg = RAM[++xInt];
        LCDmask = RAM[++xInt];
        LCDon = RAM[++xInt];
        Contrast = RAM[++xInt];

        if(CALC == 83)
                Z80_Out(0,RAM[++xInt]);

	if((CALC == 82) || (CALC == 83))
	{
		Z80_Out(2,RAM[++xInt]);
		VidX = RAM[++xInt];
		VidY = RAM[++xInt];
		VidDir = RAM[++xInt];
		VidMode = RAM[++xInt];
                VidScroll = RAM[++xInt];
		memcpy(VidRAM,RAM + (++xInt),768);
	}

        if((CALC == 85) || (CALC == 86))
                Z80_Out(5,RAM[++xInt]);
        if(CALC == 86)
                Z80_Out(6,RAM[++xInt]);

	if((CALC == 85) || (CALC == 86))
	{
		VidOffset = RAM[++xInt];                      
		PowerReg = RAM[++xInt];            
	}                        
}

void SaveRAM(void)
{
        InitRAM = 0;

        xInt = RAMSIZE;

	RAM[++xInt] = R.AF.B.h;
	RAM[++xInt] = R.AF.B.l;
	RAM[++xInt] = R.BC.B.h;
	RAM[++xInt] = R.BC.B.l;
	RAM[++xInt] = R.DE.B.h;
	RAM[++xInt] = R.DE.B.l;
	RAM[++xInt] = R.HL.B.h;
	RAM[++xInt] = R.HL.B.l;
	RAM[++xInt] = R.IX.B.h;
	RAM[++xInt] = R.IX.B.l;
	RAM[++xInt] = R.IY.B.h;
	RAM[++xInt] = R.IY.B.l;
	RAM[++xInt] = R.PC.B.h;
	RAM[++xInt] = R.PC.B.l;
	RAM[++xInt] = R.SP.B.h;
	RAM[++xInt] = R.SP.B.l;
	RAM[++xInt] = R.AF2.B.h;
	RAM[++xInt] = R.AF2.B.l;
	RAM[++xInt] = R.BC2.B.h;
	RAM[++xInt] = R.BC2.B.l;
	RAM[++xInt] = R.DE2.B.h;
	RAM[++xInt] = R.DE2.B.l;
	RAM[++xInt] = R.HL2.B.h;
	RAM[++xInt] = R.HL2.B.l;
	RAM[++xInt] = R.IFF1;
	RAM[++xInt] = R.IFF2;
	RAM[++xInt] = R.HALT;
	RAM[++xInt] = R.IM;
	RAM[++xInt] = R.I;
	RAM[++xInt] = R.R;
	RAM[++xInt] = R.R2;

	RAM[++xInt] = KeypadMask;
	RAM[++xInt] = ONmask;
        RAM[++xInt] = LinkReg;
        RAM[++xInt] = LCDmask;
        RAM[++xInt] = LCDon;
        RAM[++xInt] = Contrast;

        if(CALC == 83)
                RAM[++xInt] = Z80_In(0);

	if((CALC == 82) || (CALC == 83))
	{
		RAM[++xInt] = Z80_In(2);             
		RAM[++xInt] = VidX;
		RAM[++xInt] = VidY;
		RAM[++xInt] = VidDir;
		RAM[++xInt] = VidMode;
                RAM[++xInt] = VidScroll;
		memcpy(RAM + (++xInt),VidRAM,768);
	}
	if((CALC == 85) || (CALC == 86))
		RAM[++xInt] = Z80_In(5);
	if(CALC == 86)     
		RAM[++xInt] = Z80_In(6);

        if((CALC == 85) || (CALC == 86))
        {
                RAM[++xInt] = VidOffset;
                RAM[++xInt] = PowerReg;
        }

        fh_SAV = open(SAVfilename,O_WRONLY|O_CREAT|O_BINARY,S_IWRITE);

        write(fh_SAV,RAM,SAVSIZE);
	
        close(fh_SAV);
}

void SetVideoMode(word m)
{
	__dpmi_regs regs;
	memset(&regs,0,sizeof regs);
	regs.x.ax = m;
	__dpmi_int(0x10,&regs);
}

void SetCalc(byte c)
{
        CALC = c;
}

void SetLink(char l,char p)
{
        LINK = toupper(l);

        if(((p < '1') || (p > '9')) && (LINK != 'K'))
        {
                printf("\aInvalid paramaters!\n");
                exit(-1);
        }
                
        switch(LINK)
        {
                case 'G':
                        dzcomm_init();
                        Comm = comm_port_init(p-49);
                        comm_port_set_baud_rate(Comm,_9600);
                        comm_port_set_flow_control(Comm,NO_CONTROL);

                        if(!comm_port_install_handler(Comm))
                        {
                                printf("Error opening COM port!\a\n");
                                return;
                        }
                        break;        
                case 'P':
                        LinkPort = 0x378 - ((p-'1') << 8);
                        break;
                case 'S':
                        LinkPort = 0x3F8-(((p-'1')&0x1)<<8)-(((p-'1')&0x2)<<3);
                        break;
                case 'K':
                        break;
                default:
                        printf("\aInvalid paramaters!\n");
                        exit(-1);
        }                        
}

void SetBMP(char* f)
{
        strcpy(BMPfilename,f);
}

void SnapShot(void)
{       
        int x,y;
        byte* LCD;

        fh_BMP = open(BMPfilename,O_WRONLY|O_CREAT|O_BINARY,S_IWRITE);

        memcpy(BMP,BMPheader,0x3E);
        
        if((CALC == 82) || (CALC == 83))
        {
                BMP[0x12] = 0x60;
                LCD = VidRAM;
        }
        if(CALC == 85)
        {
                BMP[0x12] = 0x80;
                LCD = (byte*)(RAM+0x7C00);
        }
        if(CALC == 86)
        {
                BMP[0x12] = 0x80;
                LCD = (byte*)(RAM+0x3C00);
        }

        for(y = 63; y >= 0; --y)
        {                                                  
                for(x = 0; x <= (LCDWIDTH*4)-1; ++x)            
                        BMP[0x3E + x + (LCDWIDTH * 4 * y)] = *(LCD++);
        }

        BMP[BMPSIZE-2] = 0;
        BMP[BMPSIZE-1] = 0;

        write(fh_BMP,BMP,BMPSIZE);

        close(fh_BMP);
}

void InitDisplay(void)
{    
        byte* vid;
        int x;
        int y;
        int fr,fg,fb;
        int br,bg,bb;
        int rR,gR,bR;

        SetVideoMode(0x13);

        br=48; bb=48; bg=48;
        fr=0; fb=0; fg=0;

        rR=(br-fr)/2; gR=(bg-fg)/2; bR=(bb-fb)/2;

        outportb(0x3C8,0);

        for(x=0;x<64;x++)
        {
                outportb(0x3C9,fr+(x*x*rR/(64*64)));
                outportb(0x3C9,fg+(x*x*gR/(64*64)));
                outportb(0x3C9,fb+(x*x*bR/(64*64)));
        }
        for(x=0;x<65;x++)
        {
                outportb(0x3C9,br-((64-x)*(64-x)*rR/(64*64)));
                outportb(0x3C9,bg-((64-x)*(64-x)*gR/(64*64)));
                outportb(0x3C9,bb-((64-x)*(64-x)*bR/(64*64)));
        }

        if((CALC == 82) || (CALC == 83))
                vid = (byte*)0xA4F30;
        if((CALC == 85) || (CALC == 86))
                vid = (byte*)0xA4F20;

        for(y=1;y<=68;++y)
        {
                for(x=1;x<=LCDWIDTH*32+4;++x)
                        _farpokeb(_dos_ds,(int)(vid++),0x80);

                vid += VIDJUMP*32-4;
        }
}

inline void DrawScreen(void)
{                        
        byte x;
        byte y;

	if((CALC == 82) || (CALC == 83))
	{
                memcpy(VidRAM+0x300,VidRAM,0x300);                        
		vidsel=_dos_ds;
                vidptr=VidRAM + (12 * VidScroll);
                vgaptr=(byte *)(0xA51AE);

		UpdateLCD96();
	}

	if((CALC == 85) || (CALC == 86))
	{
		vidptr=RAM + ((VidOffset & 0x3F) * 0x100);
		if(CALC == 85)
			vidptr += 0x4000;

		vidsel=_dos_ds;
                vgaptr=(byte *)(0xA519E);

		UpdateLCD128();
	}
}

void TICalcDebug(void)
{          
        char choice[256] = " ";
        char reg[256];
        byte port;
        word value;
        word addr;

        kb_remove();

        SetVideoMode(3);

        Z80_RegisterDump();

        printf("\n");

        while(*choice != 'Q')
        {          
                printf(": ");

                scanf("%s",choice);                

                *choice = toupper(*choice);

                switch(*choice)
                {
                case '?':
                        printf("\nCommands: [C,D,E,I,O,Q,R,S,W,X]\n\n");
                        break;
                case 'C':
                        clrscr();
                        Z80_RegisterDump();
                        printf("\n");
                        break;
                case 'D':
                        printf("\n");
                        Z80_RegisterDump();
                        printf("\n");
                        break;
                case 'E':
                        printf("\nREG   : ");
                        scanf("%s",reg);

                        for(xByte = 0; reg[xByte] != NULL; reg[xByte] = toupper(reg[xByte]), ++xByte);

                        printf("VALUE : 0x");
                        scanf("%x",&value);
                        printf("\n");

                        if(!strcmp(reg,"AF"))
                                R.AF.W.l = value;
                        else if(!strcmp(reg,"BC"))
                                R.BC.W.l = value;
                        else if(!strcmp(reg,"DE"))
                                R.DE.W.l = value;
                        else if(!strcmp(reg,"HL"))
                                R.HL.W.l = value;
                        else if(!strcmp(reg,"AF'"))
                                R.AF2.W.l = value;
                        else if(!strcmp(reg,"BC'"))
                                R.BC2.W.l = value;
                        else if(!strcmp(reg,"DE'"))
                                R.DE2.W.l = value;
                        else if(!strcmp(reg,"HL'"))
                                R.HL2.W.l = value;
                        else if(!strcmp(reg,"IX"))
                                R.IX.W.l = value;
                        else if(!strcmp(reg,"IY"))
                                R.IY.W.l = value;
                        else if(!strcmp(reg,"PC"))
                                R.PC.W.l = value;
                        else if(!strcmp(reg,"SP"))
                                R.SP.W.l = value;

                        else if(!strcmp(reg,"A"))
                                R.AF.B.h = value;
                        else if(!strcmp(reg,"F"))
                                R.AF.B.l = value;
                        else if(!strcmp(reg,"B"))
                                R.BC.B.h = value;
                        else if(!strcmp(reg,"C"))
                                R.BC.B.l = value;
                        else if(!strcmp(reg,"D"))
                                R.DE.B.h = value;
                        else if(!strcmp(reg,"E"))
                                R.DE.B.l = value;
                        else if(!strcmp(reg,"H"))
                                R.HL.B.h = value;
                        else if(!strcmp(reg,"L"))
                                R.HL.B.l = value;
                        else if(!strcmp(reg,"A'"))
                                R.AF2.B.h = value;
                        else if(!strcmp(reg,"F'"))
                                R.AF2.B.l = value;
                        else if(!strcmp(reg,"B'"))
                                R.BC2.B.h = value;
                        else if(!strcmp(reg,"C'"))
                                R.BC2.B.l = value;
                        else if(!strcmp(reg,"D'"))
                                R.DE2.B.h = value;
                        else if(!strcmp(reg,"E'"))
                                R.DE2.B.l = value;
                        else if(!strcmp(reg,"H'"))
                                R.HL2.B.h = value;
                        else if(!strcmp(reg,"L'"))
                                R.HL2.B.l = value;
                        else if(!strcmp(reg,"IXH"))
                                R.IX.B.h = value;
                        else if(!strcmp(reg,"IXL"))
                                R.IX.B.l = value;
                        else if(!strcmp(reg,"IYH"))
                                R.IY.B.h = value;
                        else if(!strcmp(reg,"IYL"))
                                R.IY.B.l = value;                                             
                        else
                                printf("Invalid register!\n\n");
                        break;
                case 'I':
                        printf("\nPORT  : 0x");
                        scanf("%x",&port);
                        printf("VALUE : 0x%02X\n\n",Z80_In(port));
                        break;
                case 'O':
                        printf("\nPORT  : 0x");
                        scanf("%x",&port);
                        printf("VALUE : 0x");
                        scanf("%x",&value);
                        printf("\n");
                        Z80_Out(port,(byte)value);
                        break;
                case 'Q':
                        break;
                case 'R':
                        printf("\nADDR  : 0x");
                        scanf("%x",&addr);
                        printf("VALUE : 0x%02X\n\n",Z80_RDMEM((dword)addr));
                        break;
                case 'S':
                        TICalcExit(1);
                case 'W':
                        printf("\nADDR  : 0x");
                        scanf("%x",&addr);
                        printf("VALUE : 0x");
                        scanf("%x",&value);
                        printf("\n");
                        Z80_WRMEM((dword)addr,(byte)value);
                        break;
                case 'X':
                        TICalcExit(0);
                default:
                        printf("\nInvalid command!\n\n");
                }                
        }

        InitDisplay();
        kb_install(0);
        return;
}
