#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <kb.h>
#include "ti8xemu.h"
#include "z80.h"
#include "hardware.h"

void Help(void)
{
        printf("TI-8X emulator v%.1f",VERSION);
        printf("\nby Randy Gluvna");
        printf("\nrandy@gluvna.com");     
        printf("\nhttp://randy.gluvna.com/ti8xemu/");
        printf("\n--------------------------------------------------------------------------------");
        printf("Usage: ti8xemu [calc] [options]");     
        printf("\n--------------------------------------------------------------------------------");
        printf("-bmp [filename]\t\t: specify BMP filename for snapshot");
        printf("\n-help\t\t\t: show this screen");
        printf("\n-link [Gx,Px,Sx,K]\t: link options");
        printf("\n-rom [filename]\t\t: specify alternate ROM filename\n");

        exit(0);
}

void main(int argc,char* argv[])
{          
        char rfilename[256];
        char sfilename[256];
	byte calc;
	int x;

        clrscr();

	Z80_Reset();

        if(argc == 2)
        {
                if(!strcmp("-help",argv[1]))
                        Help();
        }

	if(argc == 1)     
                Help();                 
        else
        {
		calc = (byte)(atoi(argv[1]));

		if((calc >= 82) && (calc <= 86) && (calc != 84))
		{
			SetCalc(calc);
                        sprintf(sfilename,"image.%d",calc);
		}
		else
		{
			for(x = 0; argv[1][x] != '.'; ++x);
			
			calc = (byte)(atoi(argv[1]+x+1));

			if((calc >= 82) && (calc <= 86) && (calc != 84))
			{
				SetCalc(calc);
                                strcpy(sfilename,argv[1]);
			}
			else
			{
				printf("\aInvalid paramaters!\n");
				exit(-1);
			}
		}

                sprintf(rfilename,"ti%d.rom",calc);

                for(x = 2; x <= argc; ++x)
                {
                        if(!strcmp("-help",argv[x]))
                                Help();
                        if(!strcmp("-bmp",argv[x]))
                                SetBMP(argv[x+1]);                                
                        if(!strcmp("-link",argv[x]))
                                SetLink(argv[x+1][0],argv[x+1][1]);
                        if(!strcmp("-rom",argv[x]))
                                strcpy(rfilename,argv[x+1]);
                }

                for(x = 0; rfilename[x] != NULL; ++x)
                        rfilename[x] = tolower(rfilename[x]);
                for(x = 0; sfilename[x] != NULL; ++x)
                        sfilename[x] = tolower(sfilename[x]);                           

                LoadMEM(rfilename,sfilename);
                InitDisplay();
	}

        kb_install(0);

	Z80();
}
