/* raw keyboard stuff for djgpp 1.x
 * PD by RJM
 */

#include <stdio.h>
#include <stdlib.h>
#include <pc.h>
#include <sys/types.h>
#include <dpmi.h>
#include <go32.h>
#include "cli.h"


static _go32_dpmi_seginfo old_handler,new_handler;
static _go32_dpmi_seginfo old_rm_handler,new_rm_handler;
static _go32_dpmi_registers regs;

volatile char keyboard[128];


void kybd_handler()
{
int a,b;

a=inportb(0x60);
b=inportb(0x61);
outportb(0x61,b|0x80);
outportb(0x61,b&0x7f);
outportb(0x20,0x20);
keyboard[a&127]=((a>127)?0:1);
}



void keyson()
{
memset((void *)keyboard,0,128);
memset(&regs,0,sizeof(regs));

cli();

/* save old and install new; first, protected mode */
_go32_dpmi_get_protected_mode_interrupt_vector(9,&old_handler);
new_handler.pm_offset=(int)kybd_handler;
new_handler.pm_selector=_go32_my_cs();
_go32_dpmi_allocate_iret_wrapper(&new_handler);
_go32_dpmi_set_protected_mode_interrupt_vector(9,&new_handler);

/* now real mode (need both so non-DPMI is ok) */
_go32_dpmi_get_real_mode_interrupt_vector(9,&old_rm_handler);
new_rm_handler.pm_offset=(int)kybd_handler;
_go32_dpmi_allocate_real_mode_callback_iret(&new_rm_handler,&regs);
_go32_dpmi_set_real_mode_interrupt_vector(9,&new_rm_handler);

sti();
}


void keysoff()
{
cli();

/* restore old */
_go32_dpmi_set_real_mode_interrupt_vector(9,&old_rm_handler);
_go32_dpmi_set_protected_mode_interrupt_vector(9,&old_handler);

sti();

_go32_dpmi_free_real_mode_callback(&new_rm_handler);
_go32_dpmi_free_iret_wrapper(&new_handler);
}
