/* timer.c - 100Hz timer stuff */

#include <stdio.h>
#include <string.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/farptr.h>

#include "timer.h"


int intflag_rm_addr;


/* allocate real-mode memory for timer. */
void timer_alloc(void)
{
static _go32_dpmi_seginfo info;

info.size=1;
_go32_dpmi_allocate_dos_memory(&info);
intflag_rm_addr=info.rm_segment*16;
}


/* start timeout, which will end in 10ms. */
void start_timeout(void)
{
_go32_dpmi_registers regs;

/* zero the timer-finished flag */
_farpokeb(_go32_conventional_mem_selector(),intflag_rm_addr,0);

memset(&regs,0,sizeof(regs));
regs.x.ax=0x8300;
regs.x.cx=0;
regs.x.dx=9800;	/* 10000us (ish) */
regs.x.es=(intflag_rm_addr>>4);
regs.x.bx=0;
_go32_dpmi_simulate_int(0x15,&regs);
}


void wait_for_timeout(void)
{
while(!_farpeekb(_go32_conventional_mem_selector(),intflag_rm_addr))
  ;
}


void timer_stop(void)
{
_go32_dpmi_registers regs;

memset(&regs,0,sizeof(regs));
regs.x.ax=0x8301;	/* cancel timer */
_go32_dpmi_simulate_int(0x15,&regs);
}

