unit IO_IRQ;

interface

procedure PowerOn;

implementation

uses
  CPU, IO_Shared, LogUnit, BinaryFile;

function Read_1402: Byte;
begin
  Result := IRQMask;
end;

function Read_1403: Byte;
begin
  Result := CPU.State.IRQs;
  CPU.State.IRQs := 0;
end;

procedure Write_1402(Value: Byte);
begin
  IRQMask := Value;
end;

procedure Write_1403(Value: Byte);
begin
  CPU.State.IRQs := CPU.State.IRQs and not IRQ_TIMER or Value and $F8;
end;

procedure Reset;
begin
  IRQMask := 0;
end;

function LoadState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.ReadCount(@IRQMask, SizeOf(IRQMask));
    Result := True;
  except
  end;
end;

function SaveState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.Write(@IRQMask, SizeOf(IRQMask));
    Result := True;
  except
  end;
end;

procedure PowerOn;
begin
  IOReadHandler[$1402] := Read_1402;
  IOReadHandler[$1403] := Read_1403;
  IOWriteHandler[$1402] := Write_1402;
  IOWriteHandler[$1403] := Write_1403;
  ResetList.Add(@Reset);
  LoadSaveStateList.Add(@LoadState);
  LoadSaveStateList.Add(@SaveState);
  Reset;
end;

end.
