unit IO_Joystick;

interface

uses
  DXInput;

procedure PowerOn;
procedure Update;

var
  DInput: TDXInput;

implementation

uses
  CPU, IO_Shared, LogUnit, BinaryFile, Config;

const
  COUNTRY_US        = $40;
  COUNTRY_JP        = $00;
  READ_NIBBLE_HIGH  = $01;
  CMD_RESET         = $02;

  JOY_LEFT          = $80;
  JOY_RIGHT         = $20;
  JOY_UP            = $10;
  JOY_DOWN          = $40;
  JOY_BUTTON_1      = $01;
  JOY_BUTTON_2      = $02;
  JOY_RUN           = $08;
  JOY_SELECT        = $04;

type
  TState = record
    Country, Select: Byte;
    Counter: Integer;
    State: array[0..4] of Byte;
  end;

var
  PS: TState;

procedure GetState(var S: Byte; Input: TDXInputStates);
begin
  S := 0;
  if isUp in Input then S := S or JOY_UP
  else if isDown in Input then S := S or JOY_DOWN;
  if isLeft in Input then S := S or JOY_LEFT
  else if isRight in Input then S := S or JOY_RIGHT;
  if isButton1 in Input then S := S or JOY_BUTTON_1;
  if isButton2 in Input then S := S or JOY_BUTTON_2;
  if isButton3 in Input then S := S or JOY_RUN;
  if isButton4 in Input then S := S or JOY_SELECT;
  S := S xor $ff;
end;

procedure Update;
begin
  DInput.Update;
  case InputP1 of
    iKeyboard: GetState(PS.State[0], DInput.Keyboard.States);
    iJoystick: GetState(PS.State[0], DInput.Joystick.States);
    iBoth: GetState(PS.State[0], DInput.States);
  end;
  case InputP2 of
    iKeyboard: GetState(PS.State[1], DInput.Keyboard.States);
    iJoystick: GetState(PS.State[1], DInput.Joystick.States);
    iBoth: GetState(PS.State[1], DInput.States);
  end;
end;

function Read_1000: Byte;
begin
  if PS.Select and READ_NIBBLE_HIGH <> 0 then
    Result := PS.State[PS.Counter] shr 4 or PS.Country
  else
    begin
      Result := PS.State[PS.Counter] and $f or PS.Country;
      PS.Counter := (PS.Counter + 1) mod 5;
    end;
end;

procedure Write_1000(Value: Byte);
begin
  PS.Select := Value and READ_NIBBLE_HIGH;
  if Value and CMD_RESET <> 0 then PS.Counter := 0;
end;

procedure Reset;
begin
  with PS do
    begin
      Select := 0;
      Counter := 0;
      State[0] := $ff;
      State[1] := $ff;
      State[2] := $ff;
      State[3] := $ff;
      State[4] := $ff;
    end;
end;

function LoadState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.ReadCount(@PS, SizeOf(PS));
    Result := True;
  except
  end;
end;

function SaveState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.Write(@PS, SizeOf(PS));
    Result := True;
  except
  end;
end;

procedure PowerOn;
begin
  PS.Country := COUNTRY_US;
  IOReadHandler[$1000] := Read_1000;
  IOWriteHandler[$1000] := Write_1000;
  ResetList.Add(@Reset);
  LoadSaveStateList.Add(@LoadState);
  LoadSaveStateList.Add(@SaveState);
  Reset;
end;

end.
