unit LogUnit;

interface

uses
  SysUtils;

type
  ELog = class(Exception);

procedure Log(Level: Integer; const Msg: string); overload;
procedure Log(Level: Integer; const Fmt: string;
  const Args: array of const); overload;

procedure Init(FileMinLevel, ScreenMinLevel: Integer; Filename: string);

implementation

uses
  Forms, Windows, TextFiles;

var
  LogFile: TTextFileWrite = nil;
  ScreenLevel: Integer = 9;
  FileLevel: Integer = MaxInt;

procedure Log(Level: Integer; const Msg: string);
begin
  if Level >= ScreenLevel then
    Application.MessageBox(PChar(Msg), 'Log', MB_OK);
  if (Level >= FileLevel) and (FileLevel >= 0) then
    LogFile.Write(UpperCase(Msg){ + #13 + #10});
  //LogFile.Flush;
end;

procedure Log(Level: Integer; const Fmt: string; const Args: array of const);
begin
  Log(Level, Format(Fmt, Args));
end;

procedure Init(FileMinLevel, ScreenMinLevel: Integer; Filename: string);
begin
  FileLevel := FileMinLevel;
  ScreenLevel := ScreenMinLevel;
  if FileLevel >= 0 then
    begin
      try
        LogFile := TTextFileWrite.Create;
        LogFile.CreateFile(Filename);
      except
        FreeAndNil(LogFile);
        raise ELog.Create('cannot create log file: ' + Filename);
      end;
    end
  else
    FreeAndNil(LogFile);
end;

initialization
finalization
  if LogFile <> nil then FreeAndNil(LogFile);

end.
