procedure _E8; // inc X
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  inc   bl
  lahf
  jmp   NextOpcode
end;

procedure _C8; // inc Y
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  inc   bh
  lahf
  jmp   NextOpcode
end;

procedure _1A; // inc A
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  inc   al
  lahf
  jmp   NextOpcode
end;

procedure _E6; // inc ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    sahf
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;

procedure _F6; // inc ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    sahf
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;

procedure __inc_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  sahf
  inc   byte ptr [edx]
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  sahf
  inc   cl
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
    sahf
    mov   cl, byte ptr [edx]
    inc   cl
    lahf
  jmp   NextOpcode
end;

procedure _EE; // inc ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __inc_abs
end;

procedure _FE; // inc ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __inc_abs
end;

procedure _CA; // dec X
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  dec   bl
  lahf
  jmp   NextOpcode
end;
procedure _88; // dec Y
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  dec   bh
  lahf
  jmp   NextOpcode
end;
procedure _3A; // dec A
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  dec   al
  lahf
  jmp   NextOpcode
end;
procedure _C6; // dec ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    sahf
  dec   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure _D6; // dec ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    sahf
  dec   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure __dec_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  sahf
  dec   byte ptr [edx]
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  sahf
  dec   cl
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
    sahf
    mov   cl, byte ptr [edx]
    dec   cl
    lahf
  jmp   NextOpcode
end;
procedure _CE; // dec ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __dec_abs
end;
procedure _DE; // dec ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __dec_abs
end;

procedure _C9; // cpa IMM
asm
  sub   ebp, 2 shl 20 + 2
    cmp   al, byte ptr [esi]
  lahf
  xor   ah, FLAG_C
  inc   esi
  jmp   NextOpcode
end;
procedure _C5; // cpa ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    cmp   al, byte ptr [PS.RAM + edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;
procedure _D5; // cpa ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    cmp   al, byte ptr [PS.RAM + edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;
procedure __cpa_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  cmp   al, byte ptr [edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  cmp   al, cl
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;
procedure _D2; // cpa ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __cpa_abs
end;
procedure _C1; // cpa ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __cpa_abs
end;
procedure _D1; // cpa ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __cpa_abs
end;
procedure _CD; // cpa ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __cpa_abs
end;
procedure _DD; // cpa ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __cpa_abs
end;
procedure _D9; // cpa ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __cpa_abs
end;

procedure _E0; // cpx IMM
asm
  sub   ebp, 2 shl 20 + 2
    cmp   bl, byte ptr [esi]
  lahf
  xor   ah, FLAG_C
  inc   esi
  jmp   NextOpcode
end;
procedure _E4; // cpx ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    cmp   bl, byte ptr [PS.RAM + edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;
procedure _EC; // cpx ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  cmp   bl, byte ptr [edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  cmp   bl, cl
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;

procedure _C0; // cpy IMM
asm
  sub   ebp, 2 shl 20 + 2
    cmp   bh, byte ptr [esi]
  lahf
  xor   ah, FLAG_C
  inc   esi
  jmp   NextOpcode
end;
procedure _C4; // cpy ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    cmp   bh, byte ptr [PS.RAM + edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;
procedure _CC; // cpy ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  cmp   bh, byte ptr [edx]
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  cmp   bh, cl
  lahf
  xor   ah, FLAG_C
  jmp   NextOpcode
end;

procedure __branch_b; forward;

procedure _0F; // bbr 0
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $01
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _1F; // bbr 1
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $02
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _2F; // bbr 2
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $04
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _3F; // bbr 3
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $08
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _4F; // bbr 4
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $10
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _5F; // bbr 5
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $20
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _6F; // bbr 6
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $40
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _7F; // bbr 7
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $80
  jz    __branch_b
  inc   esi
  jmp   NextOpcode
end;

procedure __branch_b; // do branch on bit (re)set
asm
  movsx edx, byte ptr [esi]
  inc   esi
  add   esi, edx
  sub   bp, dx
  jmp   NextOpcode
end;

procedure _8F; // bbs 0
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $01
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _9F; // bbs 1
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $02
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _AF; // bbs 2
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $04
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _BF; // bbs 3
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $08
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _CF; // bbs 4
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $10
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _DF; // bbs 5
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $20
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _EF; // bbs 6
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $40
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;
procedure _FF; // bbs 7
asm
  sub   ebp, 6 shl 20 + 3
  mov  dl, byte ptr [esi]
  inc  esi
  test  byte ptr [PS.RAM + edx], $80
  jnz   __branch_b
  inc   esi
  jmp   NextOpcode
end;

procedure _80; // branch
asm
  sub   ebp, 4 shl 20 + 2
movsx edx, byte ptr [esi]
inc   esi
  add   esi, edx
  sub   bp, dx
  jmp   NextOpcode
end;

procedure __branch_z; // do branch if z
asm
  jnz   @no_branch
  movsx edx, byte ptr [esi - 1]
  sub   ebp, 1 shl 20
  add   esi, edx
  sub   bp, dx
@no_branch:
  jmp   NextOpcode
end;
procedure __branch_nz; // do branch if nz
asm
  jz    @no_branch
  movsx edx, byte ptr [esi - 1]
  sub   ebp, 1 shl 20
  add   esi, edx
  sub   bp, dx
@no_branch:
  jmp   NextOpcode
end;
procedure _90; // branch on carry z
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, FLAG_C
  jmp   __branch_z
end;
procedure _B0; // branch on carry nz
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, FLAG_C
  jmp   __branch_nz
end;
procedure _D0; // branch on zero z
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, EMU_FLAG_Z
  jmp   __branch_z
end;
procedure _F0; // branch on zero nz
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, EMU_FLAG_Z
  jmp   __branch_nz
end;
procedure _10; // branch on negative z
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, FLAG_N
  jmp   __branch_z
end;
procedure _30; // branch on negative nz
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  ah, FLAG_N
  jmp   __branch_nz
end;
procedure _50; // branch on overflow z
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  [PS.FlagOverflow], $FF
  jmp   __branch_z
end;
procedure _70; // branch on overflow nz
asm
  sub   ebp, 2 shl 20 + 2
  inc   esi
  test  [PS.FlagOverflow], $FF
  jmp   __branch_nz
end;

procedure _4C; // jmp ABS
asm
  sub   ebp, 4 shl 20 + 3
  mov   dx, word ptr [esi]
    jmp   NewPC_J
  jmp   NextOpcode
end;
procedure _6C; // jmp ABSI
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
mov   edi, edx
shr   edi, 13
mov   edi, dword ptr [PS.MMRBase + 4 * edi]
mov   cl, byte ptr [edx + edi]
  inc   edx
mov   edi, edx
shr   edi, 13
mov   edi, dword ptr [PS.MMRBase + 4 * edi]
mov   dh, byte ptr [edx + edi]
mov   dl, cl
    jmp   NewPC_J
  jmp   NextOpcode
end;
procedure _7C; // jmp ABSXI
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   dl, bl
adc   dh, 0
mov   edi, edx
shr   edi, 13
mov   edi, dword ptr [PS.MMRBase + 4 * edi]
mov   cl, byte ptr [edx + edi]
  inc   edx
mov   edi, edx
shr   edi, 13
mov   edi, dword ptr [PS.MMRBase + 4 * edi]
mov   dh, byte ptr [edx + edi]
mov   dl, cl
    jmp   NewPC_J
  jmp   NextOpcode
end;

procedure _20; // jump to subroutine
asm
  sub   ebp, 7 shl 20 + 3
  call  GetPC
  inc   dx
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dh
  dec   ch
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dl
  dec   ch
  movzx edx, word ptr [esi]
  jmp   NewPC_J
end;

procedure _44; // branch to subroutine
asm
  sub   ebp, 8 shl 20 + 2
  call  GetPC
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dh
  dec   ch
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dl
  dec   ch
  movsx edx, byte ptr [esi]
  inc   esi
  add   esi, edx
  sub   bp, dx
  jmp   NextOpcode
end;

procedure _85; // sta ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   byte ptr [PS.RAM + edx], al
  jmp   NextOpcode
end;
procedure _95; // sta ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    mov   byte ptr [PS.RAM + edx], al
  jmp   NextOpcode
end;
procedure __store_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @io_or_rom
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   byte ptr [edx], cl
  jmp   NextOpcode
@io_or_rom:
  jz    @is_rom
  mov   cl, cl
  push  eax
  push  ecx
  and   edx, $1fff
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
    // nothing
  jmp   NextOpcode
end;
procedure _92; // sta ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
mov   cl, al
  jmp   __store_abs
end;
procedure _81; // sta ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
mov   cl, al
  jmp   __store_abs
end;
procedure _91; // sta ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
mov   cl, al
  jmp   __store_abs
end;
procedure _8D; // sta ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
mov   cl, al
  jmp   __store_abs
end;
procedure _9D; // sta ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
mov   cl, al
  jmp   __store_abs
end;
procedure _99; // sta ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
mov   cl, al
  jmp   __store_abs
end;

procedure _86; // stx ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   byte ptr [PS.RAM + edx], bl
  jmp   NextOpcode
end;
procedure _96; // stx ZPY
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bh
    mov   byte ptr [PS.RAM + edx], bl
  jmp   NextOpcode
end;
procedure _8E; // stx ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
mov   cl, bl
  jmp   __store_abs
end;

procedure _84; // sty ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   byte ptr [PS.RAM + edx], bh
  jmp   NextOpcode
end;
procedure _94; // sty ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    mov   byte ptr [PS.RAM + edx], bh
  jmp   NextOpcode
end;
procedure _8C; // sty ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
mov   cl, bh
  jmp   __store_abs
end;

procedure _64; // stz ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   byte ptr [PS.RAM + edx], 0
  jmp   NextOpcode
end;
procedure _74; // stz ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    mov   byte ptr [PS.RAM + edx], 0
  jmp   NextOpcode
end;
procedure _9C; // stz ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
mov   cl, 0
  jmp   __store_abs
end;
procedure _9E; // stz ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
mov   cl, 0
  jmp   __store_abs
end;

procedure _29; // and IMM
asm
  sub   ebp, 2 shl 20 + 2
    and   al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _25; // and ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    and   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _35; // and ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    and   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure __and_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  and   al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  and   al, cl
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _32; // and ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __and_abs
end;
procedure _21; // and ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __and_abs
end;
procedure _31; // and ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __and_abs
end;
procedure _2D; // and ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __and_abs
end;
procedure _3D; // and ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __and_abs
end;
procedure _39; // and ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __and_abs
end;

procedure _49; // xor IMM
asm
  sub   ebp, 2 shl 20 + 2
    xor   al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _45; // xor ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    xor   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _55; // xor ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    xor   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure __xor_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  xor   al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  xor   al, cl
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _52; // xor ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __xor_abs
end;
procedure _41; // xor ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __xor_abs
end;
procedure _51; // xor ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __xor_abs
end;
procedure _4D; // xor ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __xor_abs
end;
procedure _5D; // xor ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __xor_abs
end;
procedure _59; // xor ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __xor_abs
end;

procedure _09; // or IMM
asm
  sub   ebp, 2 shl 20 + 2
    or    al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _05; // or ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    or    al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _15; // or ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    or    al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure __or_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  or    al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  or    al, cl
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _12; // or ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __or_abs
end;
procedure _01; // or ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __or_abs
end;
procedure _11; // or ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __or_abs
end;
procedure _0D; // or ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __or_abs
end;
procedure _1D; // or ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __or_abs
end;
procedure _19; // or ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __or_abs
end;

procedure _A9; // lda IMM
asm
  sub   ebp, 2 shl 20 + 2
    mov   al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _A5; // lda ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _B5; // lda ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    mov   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure __lda_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  mov   al, cl
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _B2; // lda ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __lda_abs
end;
procedure _A1; // lda ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __lda_abs
end;
procedure _B1; // lda ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __lda_abs
end;
procedure _AD; // lda ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __lda_abs
end;
procedure _BD; // lda ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __lda_abs
end;
procedure _B9; // lda ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __lda_abs
end;

procedure _A2; // ldx IMM
asm
  sub   ebp, 2 shl 20 + 2
    mov   bl, byte ptr [esi]
  sahf
  dec   bl
  inc   bl
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _A6; // ldx ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   bl, byte ptr [PS.RAM + edx]
  sahf
  dec   bl
  inc   bl
  lahf
  jmp   NextOpcode
end;
procedure _B6; // ldx ZPY
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bh
    mov   bl, byte ptr [PS.RAM + edx]
  sahf
  dec   bl
  inc   bl
  lahf
  jmp   NextOpcode
end;
procedure __ldx_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   bl, byte ptr [edx]
  sahf
  dec   bl
  inc   bl
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  mov   bl, cl
  sahf
  dec   bl
  inc   bl
  lahf
  jmp   NextOpcode
end;
procedure _AE; // ldx ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __ldx_abs
end;
procedure _BE; // ldx ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __ldx_abs
end;

procedure _A0; // ldy IMM
asm
  sub   ebp, 2 shl 20 + 2
    mov   bh, byte ptr [esi]
  sahf
  dec   bh
  inc   bh
  lahf
  inc   esi
  jmp   NextOpcode
end;
procedure _A4; // ldy ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    mov   bh, byte ptr [PS.RAM + edx]
  sahf
  dec   bh
  inc   bh
  lahf
  jmp   NextOpcode
end;
procedure _B4; // ldy ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    mov   bh, byte ptr [PS.RAM + edx]
  sahf
  dec   bh
  inc   bh
  lahf
  jmp   NextOpcode
end;
procedure __ldy_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   bh, byte ptr [edx]
  sahf
  dec   bh
  inc   bh
  lahf
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  mov   bh, cl
  sahf
  dec   bh
  inc   bh
  lahf
  jmp   NextOpcode
end;
procedure _AC; // ldy ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __ldy_abs
end;
procedure _BC; // ldy ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __ldy_abs
end;

procedure _07; // reset memory bit 0
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $01
  jmp   NextOpcode
end;
procedure _17; // reset memory bit 1
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $02
  jmp   NextOpcode
end;
procedure _27; // reset memory bit 2
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $04
  jmp   NextOpcode
end;
procedure _37; // reset memory bit 3
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $08
  jmp   NextOpcode
end;
procedure _47; // reset memory bit 4
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $10
  jmp   NextOpcode
end;
procedure _57; // reset memory bit 5
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $20
  jmp   NextOpcode
end;
procedure _67; // reset memory bit 6
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $40
  jmp   NextOpcode
end;
procedure _77; // reset memory bit 7
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  and   byte ptr [PS.RAM + edx], $FF - $80
  jmp   NextOpcode
end;
procedure _87; // set memory bit 0
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $01
  jmp   NextOpcode
end;
procedure _97; // set memory bit 1
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $02
  jmp   NextOpcode
end;
procedure _A7; // set memory bit 2
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $04
  jmp   NextOpcode
end;
procedure _B7; // set memory bit 3
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $08
  jmp   NextOpcode
end;
procedure _C7; // set memory bit 4
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $10
  jmp   NextOpcode
end;
procedure _D7; // set memory bit 5
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $20
  jmp   NextOpcode
end;
procedure _E7; // set memory bit 6
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $40
  jmp   NextOpcode
end;
procedure _F7; // set memory bit 7
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  or    byte ptr [PS.RAM + edx], $80
  jmp   NextOpcode
end;

procedure _2A; // rcl A
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  rcl   al, 1
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _26; // rcl ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    sahf
  rcl   byte ptr [PS.RAM + edx], 1
  dec   byte ptr [PS.RAM + edx]
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure _36; // rcl ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    sahf
  rcl   byte ptr [PS.RAM + edx], 1
  dec   byte ptr [PS.RAM + edx]
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure __rcl_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  sahf
  rcl   byte ptr [edx], 1
  dec   byte ptr [edx]
  inc   byte ptr [edx]
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  sahf
  rcl   cl, 1
  dec   cl
  inc   cl
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, byte ptr [edx]
    sahf
    rcl   cl, 1
    dec   cl
    inc   cl
    lahf
  jmp   NextOpcode
end;
procedure _2E; // rcl ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __rcl_abs
end;
procedure _3E; // rcl ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __rcl_abs
end;

procedure _6A; // rcr A
asm
  sub   ebp, 2 shl 20 + 1
    sahf
  rcr   al, 1
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _66; // rcr ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    sahf
  rcr   byte ptr [PS.RAM + edx], 1
  dec   byte ptr [PS.RAM + edx]
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure _76; // rcr ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    sahf
  rcr   byte ptr [PS.RAM + edx], 1
  dec   byte ptr [PS.RAM + edx]
  inc   byte ptr [PS.RAM + edx]
  lahf
  jmp   NextOpcode
end;
procedure __rcr_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  sahf
  rcr   byte ptr [edx], 1
  dec   byte ptr [edx]
  inc   byte ptr [edx]
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  sahf
  rcr   cl, 1
  dec   cl
  inc   cl
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, byte ptr [edx]
    sahf
    rcr   cl, 1
    dec   cl
    inc   cl
    lahf
  jmp   NextOpcode
end;
procedure _6E; // rcr ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __rcr_abs
end;
procedure _7E; // rcr ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __rcr_abs
end;

procedure _0A; // shl A
asm
  sub   ebp, 2 shl 20 + 1
    shl   al, 1
  lahf
  jmp   NextOpcode
end;
procedure _06; // shl ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    shl   byte ptr [PS.RAM + edx], 1
  lahf
  jmp   NextOpcode
end;
procedure _16; // shl ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    shl   byte ptr [PS.RAM + edx], 1
  lahf
  jmp   NextOpcode
end;
procedure __shl_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  shl   byte ptr [edx], 1
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  shl   cl, 1
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, byte ptr [edx]
    shl   cl, 1
    lahf
  jmp   NextOpcode
end;
procedure _0E; // shl ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __shl_abs
end;
procedure _1E; // shl ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __shl_abs
end;

procedure _4A; // shr A
asm
  sub   ebp, 2 shl 20 + 1
    shr   al, 1
  lahf
  jmp   NextOpcode
end;
procedure _46; // shr ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    shr   byte ptr [PS.RAM + edx], 1
  lahf
  jmp   NextOpcode
end;
procedure _56; // shr ZPX
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    shr   byte ptr [PS.RAM + edx], 1
  lahf
  jmp   NextOpcode
end;
procedure __shr_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jae   @rom_or_io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  shr   byte ptr [edx], 1
  lahf
  jmp   NextOpcode
@rom_or_io:
  jz    @is_rom
  push  eax
  push  ecx
  and   edx, $1fff
  push  edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   edx
  pop   ecx
  mov   cl, al
  pop   eax
  shr   cl, 1
  lahf
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
@is_rom:
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, byte ptr [edx]
    shr   cl, 1
    lahf
  jmp   NextOpcode
end;
procedure _4E; // shr ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __shr_abs
end;
procedure _5E; // shr ABSX
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __shr_abs
end;

procedure _48; // push A
asm
  sub   ebp, 3 shl 20 + 1
  mov   dl, al
    movzx edi, ch
    mov   byte ptr [PS.RAM + $100 + edi], dl
    dec   ch
  jmp   NextOpcode
end;
procedure _DA; // push X
asm
  sub   ebp, 3 shl 20 + 1
  mov   dl, bl
    movzx edi, ch
    mov   byte ptr [PS.RAM + $100 + edi], dl
    dec   ch
  jmp   NextOpcode
end;
procedure _5A; // push Y
asm
  sub   ebp, 3 shl 20 + 1
  mov   dl, bh
    movzx edi, ch
    mov   byte ptr [PS.RAM + $100 + edi], dl
    dec   ch
  jmp   NextOpcode
end;
procedure _08; // push F
asm
  sub   ebp, 3 shl 20 + 1
  call  PackFlags
    movzx edi, ch
    mov   byte ptr [PS.RAM + $100 + edi], dl
    dec   ch
  jmp   NextOpcode
end;

procedure _68; // pop A
asm
  sub   ebp, 4 shl 20 + 1
    inc   ch
  movzx edi, ch
  mov   al, byte ptr [PS.RAM + $100 + edi]
  sahf
  dec   al
  inc   al
  lahf
  jmp   NextOpcode
end;
procedure _FA; // pop X
asm
  sub   ebp, 4 shl 20 + 1
    inc   ch
  movzx edi, ch
  mov   bl, byte ptr [PS.RAM + $100 + edi]
  sahf
  dec   bl
  inc   bl
  lahf
  jmp   NextOpcode
end;
procedure _7A; // pop Y
asm
  sub   ebp, 4 shl 20 + 1
    inc   ch
  movzx edi, ch
  mov   bh, byte ptr [PS.RAM + $100 + edi]
  sahf
  dec   bh
  inc   bh
  lahf
  jmp   NextOpcode
end;

procedure _28; // pop F
asm
  sub   ebp, 4 shl 20 + 1
  inc   ch
  movzx edi, ch
  mov   cl, byte ptr [PS.RAM + $100 + edi]
  test  [State.IRQs], IRQ_ALL
  jz    @no
  test  [PS.FlagsxxTBDIxx], FLAG_I
  jz    @no
  test  cl, FLAG_I
  jnz   @no
  call  UnPackFlags
  jmp   ExecuteIRQs
@no:
  call  UnPackFlags
  jmp   NextOpcode
end;

procedure _18; // clear carry
asm
  sub   ebp, 2 shl 20 + 1
    and   ah, $FF - FLAG_C
  jmp   NextOpcode
end;
procedure _38; // set carry
asm
  sub   ebp, 2 shl 20 + 1
    or    ah, FLAG_C
  jmp   NextOpcode
end;
procedure _D8; // clear decimal
asm
  sub   ebp, 2 shl 20 + 1
    and   [PS.FlagsxxTBDIxx], FLAG_T + FLAG_B + FLAG_I
  jmp   NextOpcode
end;
procedure _F8; // set decimal
asm
  sub   ebp, 2 shl 20 + 1
    or    [PS.FlagsxxTBDIxx], FLAG_D
  jmp   NextOpcode
end;
procedure _78; // set interrupt
asm
  sub   ebp, 2 shl 20 + 1
    or    [PS.FlagsxxTBDIxx], FLAG_I
  jmp   NextOpcode
end;
procedure _B8; // clear overflow
asm
  sub   ebp, 2 shl 20 + 1
    mov   [PS.FlagOverflow], 0
  jmp   NextOpcode
end;

procedure _58; // clear interrupt
asm
  sub   ebp, 2 shl 20 + 1
  test  [State.IRQs], IRQ_ALL
  jz    @no
  test  [PS.FlagsxxTBDIxx], FLAG_I
  jz    @no
  and   [PS.FlagsxxTBDIxx], FLAG_T + FLAG_B + FLAG_D
  jmp   ExecuteIRQs
@no:
  and   [PS.FlagsxxTBDIxx], FLAG_T + FLAG_B + FLAG_D
  jmp   NextOpcode
end;

procedure _C2; // clear Y
asm
  sub   ebp, 2 shl 20 + 1
    mov   bh, 0
  jmp   NextOpcode
end;
procedure _82; // clear X
asm
  sub   ebp, 2 shl 20 + 1
    mov   bl, 0
  jmp   NextOpcode
end;
procedure _62; // clear A
asm
  sub   ebp, 2 shl 20 + 1
    mov   al, 0
  jmp   NextOpcode
end;

procedure _22; // swap A, X
asm
  sub   ebp, 3 shl 20 + 1
    xchg  al, bl
  jmp   NextOpcode
end;
procedure _42; // swap A, Y
asm
  sub   ebp, 3 shl 20 + 1
    xchg  al, bh
  jmp   NextOpcode
end;
procedure _02; // swap X, Y
asm
  sub   ebp, 3 shl 20 + 1
    xchg  bl, bh
  jmp   NextOpcode
end;

procedure _AA; // X <= A
asm
  sub   ebp, 2 shl 20 + 1
  mov   bl, al
  sahf
  inc   bl
  dec   bl
  lahf
  jmp   NextOpcode
end;
procedure _8A; // A <= X
asm
  sub   ebp, 2 shl 20 + 1
  mov   al, bl
  sahf
  inc   al
  dec   al
  lahf
  jmp   NextOpcode
end;
procedure _A8; // Y <= A
asm
  sub   ebp, 2 shl 20 + 1
  mov   bh, al
  sahf
  inc   bh
  dec   bh
  lahf
  jmp   NextOpcode
end;
procedure _98; // A <= Y
asm
  sub   ebp, 2 shl 20 + 1
  mov   al, bh
  sahf
  inc   al
  dec   al
  lahf
  jmp   NextOpcode
end;
procedure _BA; // X <= SP
asm
  sub   ebp, 2 shl 20 + 1
  mov   bl, ch
  sahf
  inc   bl
  dec   bl
  lahf
  jmp   NextOpcode
end;
procedure _9A; // SP <= X
asm
  sub   ebp, 2 shl 20 + 1
    mov   ch, bl
  jmp   NextOpcode
end;

procedure __do_adc; // adc A, cl
asm
  test  [PS.FlagsxxTBDIxx], FLAG_D
  jnz   @decimal
  sahf
  adc   al, cl
  jmp   @end
@decimal:
  sub   ebp, 1 shl 20
  sahf
  adc   al, cl
  daa
@end:
  lahf
  seto	[PS.FlagOverflow]
  jmp   NextOpcode
end;

procedure _69; // adc IMM
asm
  sub   ebp, 2 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  jmp   __do_adc
end;
procedure _65; // adc ZP
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_adc
end;
procedure _75; // adc ZPX
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_adc
end;
procedure __adc_abs; // adc abs
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @is_io
  mov   edi, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, [edx + edi]
  jmp   __do_adc
@is_io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  jmp   __do_adc
end;
procedure _72; // adc ZPI
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __adc_abs
end;
procedure _61; // adc ZPXI
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __adc_abs
end;
procedure _71; // adc ZPIY
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __adc_abs
end;
procedure _6D; // adc ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  jmp   __adc_abs
end;
procedure _7D; // adc ABSX
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __adc_abs
end;
procedure _79; // adc ABSY
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __adc_abs
end;

procedure __do_sbb; // sbb A, cl
asm
  xor   ah, FLAG_C
  test  [PS.FlagsxxTBDIxx], FLAG_D
  jnz   @decimal
  sahf
  sbb   al, cl
  jmp   @end
@decimal:
  sub   ebp, 1 shl 20
  sahf
  sbb   al, cl
  das
@end:
  lahf
  seto	[PS.FlagOverflow]
  xor   ah, FLAG_C
  jmp   NextOpcode
end;

procedure _E9; // sbb IMM
asm
  sub   ebp, 2 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  jmp   __do_sbb
end;
procedure _E5; // sbb ZP
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_sbb
end;
procedure _F5; // sbb ZPX
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_sbb
end;
procedure __sbb_abs; // sbb abs
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @is_io
  mov   edi, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, [edx + edi]
  jmp   __do_sbb
@is_io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  jmp   __do_sbb
end;
procedure _F2; // sbb ZPI
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __sbb_abs
end;
procedure _E1; // sbb ZPXI
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __sbb_abs
end;
procedure _F1; // sbb ZPIY
asm
  sub   ebp, 7 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __sbb_abs
end;
procedure _ED; // sbb ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  jmp   __sbb_abs
end;
procedure _FD; // sbb ABSX
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __sbb_abs
end;
procedure _F9; // sbb ABSY
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __sbb_abs
end;



procedure EndTransfer;
asm
  mov   [PS.RunTo], RT_EXEC_IRQS
  pop   ebp
  and   esi, $fff00000
  and   ebp, $0000ffff
  or    ebp, esi
  pop   esi
  pop   ecx
  pop   ebx
  pop   eax
  sub   ebp, 7
  add   esi, 6
  jmp   ExecuteIRQs
end;

procedure StopTransfer;
asm
  test  esi, $20000
  jz    EndTransfer
  mov   [PS.TransferSource], ebp
  mov   [PS.TransferDest], ebx
  mov   eax, esi
  and   eax, $ffff
  inc   eax
  mov   [PS.TransferCount], eax
  pop   ebp
  and   esi, $fff00000
  and   ebp, $0000ffff
  or    ebp, esi
  pop   esi
  pop   ecx
  pop   ebx
  pop   eax
  jmp   NoMoreCycles
end;

procedure _F3_do_transfer;
asm
  pop   ebp
  mov   esi, ebp
  push  ebp
  and   esi, $fff00000
  dec   edx
  or    esi, edx
  or    esi, $20000
  mov   ebp, eax
  test  esi, $40010000
  jnz   StopTransfer
@again:
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_1
  @io_r_1:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_1:
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_1
    jz    @end_w_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_1
  @io_w_1:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_1:
  sub   esi, 6 shl 20 + 1
  test  esi, $00010000
  jnz   StopTransfer
  inc   bx
  inc   bp
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_2_i
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_2_i
  @io_r_2_i:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_2_i:
  dec   bp
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_2
    jz    @end_w_2
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_2
  @io_w_2:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_2:
  inc   bx
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @again
  jmp   StopTransfer
end;

procedure _F3; // transfer alternate increment
asm
  sub   ebp, 17 shl 20 + 0
  mov   [PS.RunTo], RT_RESUME_F3
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  movzx eax, word ptr [esi]
  movzx ebx, word ptr [esi + 2]
  movzx edx, word ptr [esi + 4]
  jmp   _F3_do_transfer
end;

procedure _F3_resume;
asm
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  mov   eax, [PS.TransferSource]
  mov   ebx, [PS.TransferDest]
  mov   edx, [PS.TransferCount]
  jmp   _F3_do_transfer
end;

procedure _E3_do_transfer;
asm
  pop   ebp
  mov   esi, ebp
  push  ebp
  and   esi, $fff00000
  dec   edx
  or    esi, edx
  or    esi, $20000
  mov   ebp, eax
  test  esi, $40010000
  jnz   StopTransfer
  mov   ecx, ebx
  shr   ecx, 13
  cmp   byte ptr [PS.MMRType + ecx], MMR_IS_IO
  jnz   @again
  mov   ecx, ebx
  inc   cx
  shr   ecx, 13
  cmp   byte ptr [PS.MMRType + ecx], MMR_IS_IO
  jnz   @again
  mov   ecx, ebp
  shr   ecx, 13
  cmp   byte ptr [PS.MMRType + ecx], MMR_IS_IO
  jz    @again
  mov   ecx, ebp
  inc   cx
  shr   ecx, 13
  cmp   byte ptr [PS.MMRType + ecx], MMR_IS_IO
  jz    @again
@is_to_io:
  mov   edx, ebp
  shr   edx, 13
  mov   edx, dword ptr [PS.MMRBase + edx * 4]
  mov   al, [edx + ebp]
  inc   bp
  mov   edx, ebx
  and   edx, $1fff
  and   eax, $ff
  call  dword ptr [IOWriteHandler + edx * 4]
  sub   esi, 6 shl 20 + 1
  test  esi, $00010000
  jnz   StopTransfer
  mov   edx, ebp
  shr   edx, 13
  mov   edx, dword ptr [PS.MMRBase + edx * 4]
  mov   al, [edx + ebp]
  inc   bp
  inc   bx
  mov   edx, ebx
  and   edx, $1fff
  and   eax, $ff
  call  dword ptr [IOWriteHandler + edx * 4]
  dec   bx
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @is_to_io
  jmp   StopTransfer
@again:
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_1
  @io_r_1:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_1:
  inc   bp
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_1
    jz    @end_w_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_1
  @io_w_1:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_1:
  sub   esi, 6 shl 20 + 1
  test  esi, $00010000
  jnz   StopTransfer
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_2
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_2
  @io_r_2:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_2:
  inc   bp
  inc   bx
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_2_i
    jz    @end_w_2_i
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_2_i
  @io_w_2_i:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_2_i:
  dec   bx
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @again
  jmp   StopTransfer
end;

procedure _E3; // transfer increment alternate
asm
  sub   ebp, 17 shl 20 + 0
  mov   [PS.RunTo], RT_RESUME_E3
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  movzx eax, word ptr [esi]
  movzx ebx, word ptr [esi + 2]
  movzx edx, word ptr [esi + 4]
  jmp   _E3_do_transfer
end;

procedure _E3_resume;
asm
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  mov   eax, [PS.TransferSource]
  mov   ebx, [PS.TransferDest]
  mov   edx, [PS.TransferCount]
  jmp   _E3_do_transfer
end;

procedure _C3_do_transfer;
asm
  pop   ebp
  mov   esi, ebp
  push  ebp
  and   esi, $fff00000
  dec   edx
  or    esi, edx
  or    esi, $20000
  mov   ebp, eax
  test  esi, $40010000
  jnz   StopTransfer
@again:
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_1
  @io_r_1:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_1:
  dec   bp
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_1
    jz    @end_w_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_1
  @io_w_1:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_1:
  dec   bx
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @again
  jmp   StopTransfer
end;

procedure _C3; // transfer decrement decrement
asm
  sub   ebp, 17 shl 20 + 0
  mov   [PS.RunTo], RT_RESUME_C3
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  movzx eax, word ptr [esi]
  movzx ebx, word ptr [esi + 2]
  movzx edx, word ptr [esi + 4]
  jmp   _C3_do_transfer
end;

procedure _C3_resume;
asm
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  mov   eax, [PS.TransferSource]
  mov   ebx, [PS.TransferDest]
  mov   edx, [PS.TransferCount]
  jmp   _C3_do_transfer
end;

procedure _73_do_transfer;
asm
  pop   ebp
  mov   esi, ebp
  push  ebp
  and   esi, $fff00000
  dec   edx
  or    esi, edx
  or    esi, $20000
  mov   ebp, eax
  test  esi, $40010000
  jnz   StopTransfer
@again:
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_1
  @io_r_1:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_1:
  inc   bp
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_1
    jz    @end_w_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_1
  @io_w_1:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_1:
  inc   bx
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @again
  jmp   StopTransfer
end;

procedure _73; // transfer increment increment
asm
  sub   ebp, 17 shl 20 + 0
  mov   [PS.RunTo], RT_RESUME_73
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  movzx eax, word ptr [esi]
  movzx ebx, word ptr [esi + 2]
  movzx edx, word ptr [esi + 4]
  jmp   _73_do_transfer
end;

procedure _73_resume;
asm
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  mov   eax, [PS.TransferSource]
  mov   ebx, [PS.TransferDest]
  mov   edx, [PS.TransferCount]
  jmp   _73_do_transfer
end;

procedure _D3_do_transfer;
asm
  pop   ebp
  mov   esi, ebp
  push  ebp
  and   esi, $fff00000
  dec   edx
  or    esi, edx
  or    esi, $20000
  mov   ebp, eax
  test  esi, $40010000
  jnz   StopTransfer
@again:
    mov   edx, ebp
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_IO
    jz    @io_r_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   al, [edx + ebp]
    jmp   @end_r_1
  @io_r_1:
    mov   edx, ebp
    and   edx, $1fff
    call  dword ptr [IOReadHandler + edx * 4]
  @end_r_1:
  inc   bp
    mov   edx, ebx
    shr   edx, 13
    cmp   byte ptr [PS.MMRType + edx], MMR_IS_ROM
    ja    @io_w_1
    jz    @end_w_1
    mov   edx, dword ptr [PS.MMRBase + edx * 4]
    mov   [edx + ebx], al
    jmp   @end_w_1
  @io_w_1:
    mov   edx, ebx
    and   edx, $1fff
    and   eax, $ff
    call  dword ptr [IOWriteHandler + edx * 4]
  @end_w_1:
  sub   esi, 6 shl 20 + 1
  test  esi, $40010000
  jz    @again
  jmp   StopTransfer
end;

procedure _D3; // transfer increment none
asm
  sub   ebp, 17 shl 20 + 0
  mov   [PS.RunTo], RT_RESUME_D3
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  movzx eax, word ptr [esi]
  movzx ebx, word ptr [esi + 2]
  movzx edx, word ptr [esi + 4]
  jmp   _D3_do_transfer
end;

procedure _D3_resume;
asm
  push  eax
  push  ebx
  push  ecx
  push  esi
  push  ebp
  mov   eax, [PS.TransferSource]
  mov   ebx, [PS.TransferDest]
  mov   edx, [PS.TransferCount]
  jmp   _D3_do_transfer
end;



procedure __bit;
asm
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
  jmp   NextOpcode
end;

procedure _89; // bit IMM
asm
  sub   ebp, 2 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  jmp   __bit
end;
procedure _24; // bit ZP
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __bit
end;
procedure _34; // bit ZPX
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __bit
end;
procedure _2C; // bit ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  push  eax
push  ecx
and   edx, $1fff
call  dword ptr [IOReadHandler + edx * 4]
pop   ecx
mov   cl, al
pop   eax
  jmp   __bit
end;
procedure _3C; // bit ABSX
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  push  eax
push  ecx
and   edx, $1fff
call  dword ptr [IOReadHandler + edx * 4]
pop   ecx
mov   cl, al
pop   eax
  jmp   __bit
end;

procedure _14; // trb ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
  inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  and   ah, FLAG_C
  test  al, cl
  setz  dh
  shl   dh, 6
  or    ah, dh
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dh, cl
  and   dh, $80
  or    ah, dh
  mov   dh, 0
  mov   cl, al
  not   cl
  and   byte ptr [PS.RAM + edx], cl
  jmp   NextOpcode
end;

procedure _04; // tsb ZP
asm
  sub   ebp, 6 shl 20 + 2
  mov   dl, byte ptr [esi]
  inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  and   ah, FLAG_C
  test  al, cl
  setz  dh
  shl   dh, 6
  or    ah, dh
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dh, cl
  and   dh, $80
  or    ah, dh
  mov   dh, 0
  or    byte ptr [PS.RAM + edx], al
  jmp   NextOpcode
end;

procedure _1C; // trb ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
  add   esi, 2
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jbe   @ram_rom
  push  eax
  push  ecx
  and   edx, $1fff
  mov   edi, edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  mov   dh, cl
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
  mov   cl, al
  not   cl
  and   cl, dh
  mov   edx, edi
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   @end
@ram_rom:
  jz    @rom
  mov   edi, edx
  shr   edx, 13
  add   edi, dword ptr [PS.MMRBase + 4 * edx]
  mov   cl, [edi]
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
  mov   cl, al
  not   cl
  and   cl, dh
  mov   [edi], cl
  jmp   @end
@rom:
  mov   edi, edx
  shr   edx, 13
  add   edi, dword ptr [PS.MMRBase + 4 * edx]
  mov   cl, [edi]
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
@end:
  jmp   NextOpcode
end;

procedure _0C; // tsb ABS
asm
  sub   ebp, 7 shl 20 + 3
  mov   dx, word ptr [esi]
  add   esi, 2
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_ROM
  jbe   @ram_rom
  push  eax
  push  ecx
  and   edx, $1fff
  mov   edi, edx
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  mov   dh, cl
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
  mov   cl, al
  or    cl, dh
  mov   edx, edi
  push  eax
  push  ecx
  movzx eax, cl
  call  dword ptr [IOWriteHandler + edx * 4]
  pop   ecx
  pop   eax
  jmp   @end
@ram_rom:
  jz    @rom
  mov   edi, edx
  shr   edx, 13
  add   edi, dword ptr [PS.MMRBase + 4 * edx]
  mov   cl, [edi]
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
  mov   cl, al
  or    cl, dh
  mov   [edi], cl
  jmp   @end
@rom:
  mov   edi, edx
  shr   edx, 13
  add   edi, dword ptr [PS.MMRBase + 4 * edx]
  mov   cl, [edi]
  and   ah, FLAG_C
  test  al, cl
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  cl, $40
  setnz [PS.FlagOverflow]
  mov   dl, cl
  and   dl, $80
  or    ah, dl
@end:
  jmp   NextOpcode
end;

procedure __tst;
asm
  mov   dh, [edi]
  and   ah, FLAG_C
  test  cl, dh
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  dh, $40
  setnz [PS.FlagOverflow]
  mov   dl, dh
  and   dl, $80
  or    ah, dl
  jmp   NextOpcode
end;

procedure _83; // tst IMM, ZP
asm
  sub   ebp, 7 shl 20 + 3
  mov   cl, byte ptr [esi]
  inc   esi
mov   dl, byte ptr [esi]
inc   esi
  mov   dh, byte ptr [PS.RAM + edx]
  and   ah, FLAG_C
  test  cl, dh
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  dh, $40
  setnz [PS.FlagOverflow]
  mov   dl, dh
  and   dl, $80
  or    ah, dl
  jmp   NextOpcode
end;

procedure _A3; // tst IMM, ZPX
asm
  sub   ebp, 7 shl 20 + 3
  mov   cl, byte ptr [esi]
  inc   esi
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
  mov   dh, byte ptr [PS.RAM + edx]
  and   ah, FLAG_C
  test  cl, dh
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  dh, $40
  setnz [PS.FlagOverflow]
  mov   dl, dh
  and   dl, $80
  or    ah, dl
  jmp   NextOpcode
end;

procedure __tst_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  mov   edi, dword ptr [PS.MMRBase + 4 * edi]
  mov   dh, [edi + edx]
  jmp   @do
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   dh, al
  pop   eax
@do:
  and   ah, FLAG_C
  test  cl, dh
  setz  dl
  shl   dl, 6
  or    ah, dl
  test  dh, $40
  setnz [PS.FlagOverflow]
  mov   dl, dh
  and   dl, $80
  or    ah, dl
  jmp   NextOpcode
end;

procedure _93; // tst IMM ABS, ABS
asm
  sub   ebp, 8 shl 20 + 4
  mov   cl, byte ptr [esi]
  inc   esi
mov   dx, word ptr [esi]
add   esi, 2
  jmp   __tst_abs
end;

procedure _B3; // tst IMM ABSX, ABSX
asm
  sub   ebp, 8 shl 20 + 4
  mov   cl, byte ptr [esi]
  inc   esi
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __tst_abs
end;

// T flag set

procedure _T_29; // and_t IMM
asm
  sub   ebp, 2 shl 20 + 2
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  and   al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_25; // and_t ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  and   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_35; // and_t ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  and   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure __and_t_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  and   al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  and   al, cl
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_32; // and_t ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __and_t_abs
end;
procedure _T_21; // and_t ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __and_t_abs
end;
procedure _T_31; // and_t ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __and_t_abs
end;
procedure _T_2D; // and_t ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __and_t_abs
end;
procedure _T_3D; // and_t ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __and_t_abs
end;
procedure _T_39; // and_t ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __and_t_abs
end;

procedure _T_49; // xor_t IMM
asm
  sub   ebp, 2 shl 20 + 2
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  xor   al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_45; // xor_t ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  xor   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_55; // xor_t ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  xor   al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure __xor_t_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  xor   al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  xor   al, cl
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_52; // xor_t ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __xor_t_abs
end;
procedure _T_41; // xor_t ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __xor_t_abs
end;
procedure _T_51; // xor_t ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __xor_t_abs
end;
procedure _T_4D; // xor_t ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __xor_t_abs
end;
procedure _T_5D; // xor_t ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __xor_t_abs
end;
procedure _T_59; // xor_t ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __xor_t_abs
end;

procedure _T_09; // or_t IMM
asm
  sub   ebp, 2 shl 20 + 2
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  or    al, byte ptr [esi]
  sahf
  dec   al
  inc   al
  lahf
  inc   esi
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_05; // or_t ZP
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  or    al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_15; // or_t ZPX
asm
  sub   ebp, 4 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
    movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  or    al, byte ptr [PS.RAM + edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure __or_t_abs;
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @io
  add   edx, dword ptr [PS.MMRBase + 4 * edi]
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  or    al, byte ptr [edx]
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
@io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  movzx edi, bl
  mov   [Backup_A], al
  mov   al, byte ptr [PS.RAM + edi]
  or    al, cl
  sahf
  dec   al
  inc   al
  lahf
  movzx edi, bl
  mov   byte ptr [PS.RAM + edi], al
  mov   al, [Backup_A]
  jmp   NextOpcode
end;
procedure _T_12; // or_t ZPI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __or_t_abs
end;
procedure _T_01; // or_t ZPXI
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __or_t_abs
end;
procedure _T_11; // or_t ZPIY
asm
  sub   ebp, 7 shl 20 + 2
  mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __or_t_abs
end;
procedure _T_0D; // or_t ABS
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
  jmp   __or_t_abs
end;
procedure _T_1D; // or_t ABSX
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __or_t_abs
end;
procedure _T_19; // or_t ABSY
asm
  sub   ebp, 5 shl 20 + 3
  mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __or_t_abs
end;

procedure __do_adc_t; // adc ZP[X], cl
asm
  movzx edi, bl
  mov   dl, al
  mov   al, byte ptr [PS.RAM + edi]
  test  [PS.FlagsxxTBDIxx], FLAG_D
  jnz   @decimal
  sahf
  adc   al, cl
  jmp   @end
@decimal:
  sub   ebp, 1 shl 20
  sahf
  adc   al, cl
  daa
@end:
  lahf
  seto	[PS.FlagOverflow]
  mov   byte ptr [PS.RAM + edi], al
  mov   al, dl
  jmp   NextOpcode
end;

procedure _T_69; // adc_t IMM
asm
  sub   ebp, 2 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  jmp   __do_adc_t
end;
procedure _T_65; // adc_t ZP
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_adc_t
end;
procedure _T_75; // adc_t ZPX
asm
  sub   ebp, 4 shl 20 + 2
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
  mov   cl, byte ptr [PS.RAM + edx]
  jmp   __do_adc_t
end;

procedure __adc_abs_t; // adc_t abs
asm
  mov   edi, edx
  shr   edi, 13
  cmp   byte ptr [PS.MMRType + edi], MMR_IS_IO
  jz    @is_io
  mov   edi, dword ptr [PS.MMRBase + 4 * edi]
  mov   cl, [edx + edi]
  jmp   __do_adc_t
@is_io:
  push  eax
  push  ecx
  and   edx, $1fff
  call  dword ptr [IOReadHandler + edx * 4]
  pop   ecx
  mov   cl, al
  pop   eax
  jmp   __do_adc_t
end;

procedure _T_72; // adc_t ZPI
asm
  sub   ebp, 7 shl 20 + 3
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __adc_abs_t
end;
procedure _T_61; // adc_t ZPXI
asm
  sub   ebp, 7 shl 20 + 3
mov   dl, byte ptr [esi]
inc   esi
add   dl, bl
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
  jmp   __adc_abs_t
end;
procedure _T_71; // adc_t ZPIY
asm
  sub   ebp, 7 shl 20 + 3
mov   dl, byte ptr [esi]
inc   esi
mov   cl, byte ptr [PS.RAM + edx]
inc   dl
mov   dh, byte ptr [PS.RAM + edx]
mov   dl, cl
add   dl, bh
adc   dh, 0
  jmp   __adc_abs_t
end;
procedure _T_6D; // adc_t ABS
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
  jmp   __adc_abs_t
end;
procedure _T_7D; // adc_t ABSX
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bl
adc   dh, 0
  jmp   __adc_abs_t
end;
procedure _T_79; // adc_t ABSY
asm
  sub   ebp, 5 shl 20 + 3
mov   dx, word ptr [esi]
add   esi, 2
add   dl, bh
adc   dh, 0
  jmp   __adc_abs_t
end;

// misc

procedure _40; // return from interrupt
asm
  sub   ebp, 7 shl 20 + 1
  inc   ch
  movzx edi, ch
  mov   cl, byte ptr [PS.RAM + $100 + edi]
  inc   ch
  movzx edi, ch
  mov   dl, byte ptr [PS.RAM + $100 + edi]
  inc   ch
  movzx edi, ch
  mov   dh, byte ptr [PS.RAM + $100 + edi]
  test  [State.IRQs], IRQ_ALL
  jz    @no
  test  [PS.FlagsxxTBDIxx], FLAG_I
  jz    @no
  test  cl, FLAG_I
  jnz   @no
  call  UnPackFlags
  call  NewPC
  jmp   ExecuteIRQs
@no:
  call  UnPackFlags
  jmp   NewPC_J
end;

procedure _60; // return from subroutine
asm
  sub   ebp, 7 shl 20 + 1
  inc   ch
  movzx edi, ch
  mov   dl, byte ptr [PS.RAM + $100 + edi]
  inc   ch
  movzx edi, ch
  mov   dh, byte ptr [PS.RAM + $100 + edi]
  inc   dx
  jmp   NewPC_J
end;

procedure _00; // break
asm
  sub   ebp, 8 shl 20 + 1
  inc   esi
  call  GetPC
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dh
  dec   ch
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dl
  dec   ch
  call  PackFlags
  or    dl, FLAG_B
  movzx edi, ch
  mov   byte ptr [PS.RAM + $100 + edi], dl
  dec   ch
  and   [PS.FlagsxxTBDIxx], $FF - FLAG_D - FLAG_T
  or    [PS.FlagsxxTBDIxx], FLAG_I
  mov   edi, dword ptr [PS.MMRBase + 4 * (VEC_BREAK shr 13)]
  movzx edx, word ptr [edi + VEC_BREAK]
  jmp   NewPC_J
end;

procedure _03; // store huc6270 0
asm
  sub   ebp, 4 shl 20 + 2
  push  eax
  movzx eax, byte ptr [esi]
  inc   esi
  push  ecx
  call dword ptr [IOWriteHandler + 0* 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
end;
procedure _13; // store huc6270 2
asm
  sub   ebp, 4 shl 20 + 2
  push  eax
  movzx eax, byte ptr [esi]
  inc   esi
  push  ecx
  call dword ptr [IOWriteHandler + 2* 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
end;
procedure _23; // store huc6270 3
asm
  sub   ebp, 4 shl 20 + 2
  push  eax
  movzx eax, byte ptr [esi]
  inc   esi
  push  ecx
  call dword ptr [IOWriteHandler + 3* 4]
  pop   ecx
  pop   eax
  jmp   NextOpcode
end;

procedure BAD;
asm
  sub   ebp, BAD_OPCODE_CYCLES shl 20 + 1
  jmp		ExitBadOpcode
  jmp   NextOpcode
end;

procedure _EA; // nop
asm
  sub   ebp, 2 shl 20 + 1
  jmp   NextOpcode
end;

// _D4 - change speed high (2)
// _54 - change speed low (2)
procedure NOP;
asm
  sub   ebp, 2 shl 20 + 1
  jmp   NextOpcode
end;

procedure _53; // transfer A to MMRi
asm
  sub   ebp, 5 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  mov   dl, al
  xor   edi, edi
  test  cl, $01
  jz    @no_01
  call  SetMMR
@no_01:
  inc   edi
  test  cl, $02
  jz    @no_02
  call  SetMMR
@no_02:
  inc   edi
  test  cl, $04
  jz    @no_04
  call  SetMMR
@no_04:
  inc   edi
  test  cl, $08
  jz    @no_08
  call  SetMMR
@no_08:
  inc   edi
  test  cl, $10
  jz    @no_10
  call  SetMMR
@no_10:
  inc   edi
  test  cl, $20
  jz    @no_20
  call  SetMMR
@no_20:
  inc   edi
  test  cl, $40
  jz    @no_40
  call  SetMMR
@no_40:
  inc   edi
  test  cl, $80
  jz    @no_80
  call  SetMMR
@no_80:
  inc   edi
  jmp   NextOpcode
end;

procedure _43; // transfer MMRi to A
asm
  sub   ebp, 4 shl 20 + 2
  mov   cl, byte ptr [esi]
  inc   esi
  mov   edi, offset PS.RMMR
  test  cl, $01
  jz    @no_01
  mov   al, [edi]
@no_01:
  inc   edi
  test  cl, $02
  jz    @no_02
  mov   al, [edi]
@no_02:
  inc   edi
  test  cl, $04
  jz    @no_04
  mov   al, [edi]
@no_04:
  inc   edi
  test  cl, $08
  jz    @no_08
  mov   al, [edi]
@no_08:
  inc   edi
  test  cl, $10
  jz    @no_10
  mov   al, [edi]
@no_10:
  inc   edi
  test  cl, $20
  jz    @no_20
  mov   al, [edi]
@no_20:
  inc   edi
  test  cl, $40
  jz    @no_40
  mov   al, [edi]
@no_40:
  inc   edi
  test  cl, $80
  jz    @no_80
  mov   al, [edi]
@no_80:
  inc   edi
  jmp   NextOpcode
end;

procedure _F4; // set T
asm
  sub   ebp, 3 shl 20 + 1
  jmp   NextOpcodeT
end;


