unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus, DXInput, AppEvnts, ExtCtrls, DXDraws, DXClass,
  DXSounds, Wave, MMSystem, IO_Shared;

type
  TForm1 = class(TDXForm)
    Menu: TMainMenu;
    OpenDialog: TOpenDialog;
    DXDraw: TDXDraw;
    DInput: TDXInput;
    PCE1: TMenuItem;
    Pause1: TMenuItem;
    DXSound: TDXSound;
    Status: TStatusBar;
    Reset1: TMenuItem;
    LoadState1: TMenuItem;
    SaveState1: TMenuItem;
    Config1: TMenuItem;
    N3: TMenuItem;
    ROM1: TMenuItem;
    LoadRom2: TMenuItem;
    R11: TMenuItem;
    R21: TMenuItem;
    R31: TMenuItem;
    R41: TMenuItem;
    D11: TMenuItem;
    D21: TMenuItem;
    D31: TMenuItem;
    D41: TMenuItem;
    N1: TMenuItem;
    N4: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Pause1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DXDrawInitialize(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure LoadState1Click(Sender: TObject);
    procedure SaveState1Click(Sender: TObject);
    procedure Config1Click(Sender: TObject);
    procedure LoadRom2Click(Sender: TObject);
    procedure R11Click(Sender: TObject);
  private
    FDXInit, IsActive, FDoesWindow, FDoesFullScreen: Boolean;
    FStateNum, FSW, FSH: Integer;
    procedure RunPCE;
    procedure SetFullScreen;
    procedure SetWindowMode;
    procedure MsgWriteInfo(var Message: TMsgWriteInfo); message MSG_WRITE_INFO;
    procedure MsgCPUBroken(var Message: TMessage); message MSG_CPU_BROKEN;
    procedure ChangeScreenMode;
    procedure SetState(S: Integer);
    procedure LoadState;
    procedure SaveState;
    function GetStateName: string;
    procedure PausePCE;
    function BeginPause: Boolean;
    procedure EndPause(P: Boolean);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  CPU, BinaryFile, IO, TextFiles, LogUnit, PCE, DirectX,
  IO_Video, IO_Joystick, IO_Palette, IO_Sound, Config;

procedure TForm1.FormActivate(Sender: TObject);
begin
  if IsActive then Exit;
  IsActive := True;
  LogUnit.Init(-1, 1, '');
  IO_Video.DXDraw := DXDraw;
  IO_Joystick.DInput := DInput;
  IO_Video.DInput := DInput;
  IO_Shared.MainWindow := Handle;
  IO_Sound.DXSound := DXSound;
  PCE.PowerOn;
  FStateNum := 0;
  Status.Panels[4].Text := 'idle';
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if PCE.Active then PCE.PowerOff;
end;

procedure TForm1.SetFullScreen;
begin
  DXDraw.Finalize;
  StoreWindow;
  DXDraw.Cursor := crNone;
  BorderStyle := bsNone;
  with DXDraw.Display do
    begin
      BitCount := 16;
      Height := FSH;
      Width := FSW;
    end;
  DXDraw.Options := DXDraw.Options + [doFullScreen];
  DXDraw.Initialize;
end;

procedure TForm1.SetWindowMode;
begin
  DXDraw.Finalize;
  RestoreWindow;
  DXDraw.Cursor := crDefault;
  BorderStyle := bsSizeable;
  DXDraw.Options := DXDraw.Options - [doFullScreen];
  DXDraw.Initialize;
end;

procedure TForm1.RunPCE;
begin
  Pause1.Checked := False;
  Status.Panels[4].Text := 'running';
  if not (doFullScreen in DXDraw.NowOptions) and not FDoesWindow then
    SetFullScreen;
  PCE.Run;
end;

procedure TForm1.Pause1Click(Sender: TObject);
begin
  if Pause1.Checked then RunPCE else PausePCE;
end;

procedure TForm1.ChangeScreenMode;
var
  P: Boolean;
begin
  if doFullScreen in DXDraw.NowOptions then
    begin
      if not FDoesWindow then Exit;
      P := BeginPause;
      SetWindowMode;
      EndPause(P);
    end
  else
    begin
      if not FDoesFullScreen then Exit;
      P := BeginPause;
      SetFullScreen;
      EndPause(P);
    end;
end;

function TForm1.GetStateName: string;
begin
  Result := Form2.SSDir.Text;
  if Result[Length(Result)] <> '\' then Result := Result + '\';
  Result := Result + ExtractFileName(PCE.RomName) + '.' + IntToStr(FStateNum);
end;

procedure TForm1.LoadState;
var
  P: Boolean;
begin
  if not PCE.LoadState(GetStateName) then
    begin
      P := BeginPause;
      ShowMessage('Could not load state');
      EndPause(P);
    end;
end;

procedure TForm1.SaveState;
var
  P: Boolean;
begin
  if not PCE.SaveState(GetStateName) then
    begin
      P := BeginPause;
      ShowMessage('Could not save state');
      EndPause(P);
    end;
end;

procedure TForm1.SetState(S: Integer);
begin
  Status.Panels[0].Text := IntToStr(S);
  FStateNum := S;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_ESCAPE: Close;
    VK_RETURN: if ssAlt in Shift then ChangeScreenMode;
    //VK_F2: SaveState;
    //VK_F3: LoadState;
    Ord('0')..Ord('9'): SetState(9 - Ord('9') + Key);
  end;
end;

procedure TForm1.DXDrawInitialize(Sender: TObject);
var
  i: Integer;
begin
  if not FDXInit then
    begin
      FDoesWindow := DXDraw.Primary.BitCount = 16;
      FSW := MaxInt; FSH := MaxInt;
      for i := 0 to DXDraw.Display.Count - 1 do with DXDraw.Display.Modes[i] do
      begin
        if  (BitCount = 16) and
            (Width >= SURFACE_WIDTH) and
            (Height >= SURFACE_HEIGHT) and
            (Width <= FSW) and
            (Height <= FSH) then
          begin
            FSW := Width;
            FSH := Height;
          end;
        //ShowMessage(Format('%dx%dx%d', [Width, Height, BitCount]));
      end;
      FDoesFullScreen := FSW <> MaxInt;
      FDXInit := true;
      if not (FDoesFullScreen or FDoesWindow) then
      begin
        Application.MessageBox('cannot find a valid 16 bit screen mode',
           'DirectX Error', MB_OK);
        Close;
      end;
    end;
  with DXDraw.Primary.SurfaceDesc.ddpfPixelFormat do
    IO_Palette.SetPixelFormat(dwRBitMask, dwGBitMask, dwBBitMask);
end;

procedure TForm1.Reset1Click(Sender: TObject);
begin
  Status.Panels[4].Text := 'running';
  PCE.Reset;
end;

procedure TForm1.MsgWriteInfo(var Message: TMsgWriteInfo);
begin
  with Message, Status do
    begin
      Panels[1].Text := Format('fps: %d', [FPS]);
      Panels[2].Text := Format('cycles: %.10d', [Cycles]);
      Panels[3].Text := Format('i/o: %d', [IOError]);
    end;
end;

procedure TForm1.MsgCPUBroken(var Message: TMessage);
begin
  Pause1.Checked := True;
  ShowMessage('CPU Broken. Paused');
end;

procedure TForm1.LoadState1Click(Sender: TObject);
begin
  LoadState;
end;

procedure TForm1.SaveState1Click(Sender: TObject);
begin
  SaveState;
end;

procedure TForm1.PausePCE;
begin
  PCE.Pause;
  Status.Panels[4].Text := 'paused';
  Pause1.Checked := True;
end;

function TForm1.BeginPause: Boolean;
begin
  Result := PCE.Runnable and not PCE.Paused;
  if Result then PausePCE;
end;

procedure TForm1.EndPause(P: Boolean);
begin
  if not P then Exit;
  RunPCE;
end;

procedure TForm1.Config1Click(Sender: TObject);
var
  P: Boolean;
begin
  P := BeginPause;
  Form2.ShowModal;
  EndPause(P);
end;

procedure TForm1.LoadRom2Click(Sender: TObject);
begin
  BeginPause;
  OpenDialog.InitialDir := LastDir[1];
  if OpenDialog.Execute then
    begin
      Form2.NewLastDir(ExtractFileDir(OpenDialog.Filename));
      if PCE.LoadRom(OpenDialog.FileName) then
        begin
          Form2.NewLastRom(OpenDialog.Filename);
          RunPCE;
        end;
    end;
end;

procedure TForm1.R11Click(Sender: TObject);
var
  Index: Integer;
begin
  Index := (Sender as TMenuItem).MenuIndex;
  if Index >= 7 then
    begin
      BeginPause;
      OpenDialog.InitialDir := LastDir[Index - 6];
      if OpenDialog.Execute then
        begin
          Form2.NewLastDir(OpenDialog.InitialDir);
          if PCE.LoadRom(OpenDialog.FileName) then
            begin
              Form2.NewLastRom(OpenDialog.Filename);
              RunPCE;
            end;
        end;
    end
  else
    begin
      Status.Panels[4].Text := 'paused';
      PCE.Pause;
      if PCE.LoadRom(LastRom[Index - 1]) then
        begin
          Form2.NewLastRom(LastRom[Index - 1]);
          RunPCE;
        end;
    end
end;

end.

