function CheckSpriteHit: Boolean;
var
  S: PSprite;
  i, X0, Y0, XX0, YY0, X, Y, XX, YY: Integer;
begin
  S := @PS.SPRAM[0];
  X0 := S^.X;
  Y0 := S^.Y;
  XX0 := X0 + ((S^.Attr shr 8) and $1 + 1) shl 4;
  YY0 := Y0 + ((S^.Attr shr 12) and $3 + 1) shl 4;
  for i := 1 to 63 do
    begin
      Inc(S);
      X := S^.X;
      Y := S^.Y;
      XX := X + ((S^.Attr shr 8) and $1 + 1) shl 4;
      YY := Y + ((S^.Attr shr 12) and $3 + 1) shl 4;
      if (X < XX0) and (XX > X0) and (Y < YY0) and (YY > Y0) then
        begin
          Result := True;
          Exit;
        end;
    end;
  Result := False;
end;

procedure DrawScanline;
const
  STATUS_VBLANK = $20;
  STATUS_SPRITE_HIT = $01;
  STATUS_SCANLINE_HIT = $04;
  CR_IRQ_SCANLINE_HIT = $04;
  CR_IRQ_VBLANK = $08;
  DCR_IRQ_SATB = $01;
  CR_SPRITES_ON = $40;
  DCR_DO_SATB = $10;
var
  IRQ: Boolean;
  Slx, Sly, Slydiff: Integer;
begin
  with PS do begin
  Scanline := (Scanline + 1) mod SCANLINES_PER_FRAME;
  IRQ := False;
  if Scanline > MaxLine then Status := Status or STATUS_VBLANK;
  Status := Status and not STATUS_SCANLINE_HIT;
  if ScanLine = 0 then
    begin
      Status := Status and not STATUS_VBLANK;
      PrevLine := FirstLine;
      ScrollYDiff := 0;
      ScrollYDiffOld := 0;
    end
  else if Scanline = MaxLine then
    begin
      Status := Status and not STATUS_SPRITE_HIT;
      if CheckSpriteHit then Status := Status or STATUS_SPRITE_HIT;
      if (PrevLine < LastLine) and not SkipFrame then
        begin
          DrawBGLines(PrevLine, LastLine);
          if Regs[R_CR].W and CR_SPRITES_ON <> 0 then
            RefreshSprite(PrevLine, LastLine + 1);
        end;
      PrevLine := LastLine + 1;
      RefreshScreen;
    end;
  if Scanline <= MaxLine then
    begin
      if Scanline = Regs[R_RCR].W and 1023 - 64 then
        begin
          if (Regs[R_CR].W and CR_IRQ_SCANLINE_HIT <> 0) and
             (FirstLine <= Scanline) and (Scanline <= LastLine) then
            begin
              if (PrevLine < LastLine) and not SkipFrame then
                begin
                  DrawBGLines(PrevLine, ScanLine - 1);
                  if Regs[R_CR].W and CR_SPRITES_ON <> 0 then
                    RefreshSprite(PrevLine, Scanline);
                end;
              PrevLine := Scanline;
            end;
          Status := Status or STATUS_SCANLINE_HIT;
          if Regs[R_CR].W and CR_IRQ_SCANLINE_HIT <> 0 then IRQ := True;
        end
      else
        if Scroll then
          if (ScanLine - 1 > PrevLine) and not SkipFrame then
            begin
              Slx := Regs[R_BXR].W;
              Sly := Regs[R_BYR].W;
              Slydiff := ScrollYDiff;
              Regs[R_BXR].W := ScrollXOld;
              Regs[R_BYR].W := ScrollYOld;
              ScrollYDiff := ScrollYDiffOld;
              DrawBGLines(PrevLine, ScanLine - 2);
              if Regs[R_CR].W and CR_SPRITES_ON <> 0 then
                RefreshSprite(PrevLine, Scanline - 1);
              PrevLine := Scanline - 1;
              Regs[R_BXR].W := Slx;
              Regs[R_BYR].W := Sly;
              ScrollYDiff := Slydiff;
            end;
    end
  else
    if Scanline = Regs[R_RCR].W and 1023 - 64 then
      begin
        ScrollYDiff := Scanline;
        if Regs[R_CR].W and CR_IRQ_SCANLINE_HIT <> 0 then
          begin
            Status := Status or STATUS_SCANLINE_HIT;
            IRQ := True;
          end;
      end;
  Scroll := False;
  if Scanline = MaxLine + 1 then
    begin
      if HasSATB or (Regs[R_DCR].W and DCR_DO_SATB <> 0) then
        begin
          Move(VRAM[Regs[R_SATB].W], SPRAM, SizeOf(SPRAM));
          HasSATB := True;
          Status := Status and not STATUS_SATB_FINISH;
        end;
      if IRQ then PendingVSync := True
      else
        if Regs[R_CR].W and CR_IRQ_VBLANK <> 0 then IRQ := True;
    end
  else
    if Scanline = SATBLine then
      begin
        if HasSATB then
          begin
            Status := Status or STATUS_SATB_FINISH;
            HasSATB := False;
            if Regs[R_DCR].W and DCR_IRQ_SATB <> 0 then IRQ := True;
          end
      end
    else
      if PendingVSync and not IRQ then
        begin
          PendingVSync := False;
          if Regs[R_CR].W and CR_IRQ_VBLANK <> 0 then IRQ := True;
        end;
  if IRQ and (IRQMask and IRQ_VIDEO = 0) then
    CPU.State.IRQs := CPU.State.IRQs or IRQ_VIDEO;
  end;
end;
