procedure AsmCopyFrame(Surface: Pointer; Pitch: Integer);
asm // eax = surface, edx = pitch
  add   eax, SURFACE_WIDTH
  push  esi
  sub   eax, [PS.ScreenWidth]
  push  edi
  mov   edi, eax
  mov   eax, SURFACE_HEIGHT - 1
  push  ebx
  mov   ecx, [PS.FirstLine]
  sub   eax, [PS.LastLine]
  push  ebp
  add   eax, ecx
  mov   ebx, edx
  mov   ebp, edx
  shr   eax, 1
  imul  ecx, MAX_WIDTH * 2
  imul  eax, ebx
  mov   edx, [PS.LastLine]
  add   edi, eax
  lea   esi, [Bitmap + 64 + ecx]
  sub   edx, [PS.FirstLine]
  mov   eax, [PS.ScreenWidth]
  inc   edx
  mov   ebx, eax
  shl   eax, 1
  sub   ebp, eax
  shr   ebx, 1
  cld
  mov   ecx, ebx
@loop:
  rep   movsd
  lea   eax, [ebx * 4 - MAX_WIDTH * 2]
  add   edi, ebp
  sub   esi, eax
  dec   edx
  mov   ecx, ebx
  jnz   @loop
  pop   ebp
  pop   ebx
  pop   edi
  pop   esi
end;

var
  LastCount: Int64 = 0;
  FrameCycles: Int64 = 0;
  FrameCyclesTolerance: Int64;
  CounterDif, SleepTime, FrameSync: Integer;

procedure WaitNextFrame;
var
  Counter: Int64;
label
  Done;
begin
  with PS do begin
  if FrameCycles = 0 then
    begin
      FrameSync := 0;
      QueryPerformanceFrequency(FrameCycles);
      FrameCycles := FrameCycles div 60;
      QueryPerformanceCounter(LastCount);
      Dec(LastCount, FrameCycles);
      FrameCyclesTolerance := FrameCycles - FrameCycles div 4;
    end;
  if not SkipFrame then
    DXDraw.DDraw.IDraw4.WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);
  QueryPerformanceCounter(Counter);
  CounterDif := Counter - LastCount;
  if SkipFrame then goto Done;
  if CounterDif >= FrameCyclesTolerance then goto Done;
  SleepTime := CounterDif * 1000 div 60 div FrameCycles;
  if SleepTime > 1 then Sleep(SleepTime - 1);
  repeat
    QueryPerformanceCounter(Counter);
    if Counter - LastCount >= FrameCycles then goto Done;
  until False;
  DXDraw.DDraw.IDraw4.WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN, 0);
Done:
  Inc(LastCount, FrameCycles);
  //QueryPerformanceCounter(LastCount);
  end;
end;

procedure RefreshScreen;
var
  SurfaceDesc: TDDSurfaceDesc;
label 
  NoFrame;
begin
  with PS do begin
    Inc(Frame);
    IO_Joystick.Update;
    if SkipFrame then
      begin
        WaitNextFrame;
        goto NoFrame;
      end;
    if (GetTickCount - Ticks) >= 1000 then
      begin
        Ticks := GetTickCount;
        FPS := FrameCount;
        FrameCount := 0;
        PostMessage(MainWindow, MSG_WRITE_INFO, CPU.State.CyclesDone,
          (InvalidReads + InvalidWrites) shl 16 + FPS);
      end
    else Inc(FrameCount);
    if DXDraw.Surface.Lock(SurfaceDesc) then
      begin
        AsmCopyFrame(SurfaceDesc.lpSurface, SurfaceDesc.lPitch);
        DXDraw.Surface.UnLock;
      end;
    WaitNextFrame;
    DXDraw.Flip;
NoFrame:
    SkipFrame := CounterDif > FrameCycles + FrameCycles;
    if SkipFrame then
      begin
        Inc(SkipFrameCount);
        if SkipFrameCount > MAX_SKIP_FRAME then
          begin
            SkipFrameCount := 0;
            SkipFrame := False;
            QueryPerformanceCounter(LastCount);
            Inc(LastCount, FrameCycles);
          end;
      end
    else
      SkipFrameCount := 0;
  end;
end;

procedure Resume;
begin
  FrameSync := 0;
  PS.Ticks := GetTickCount;
  PS.FrameCount := 0;
  QueryPerformanceCounter(LastCount);
  SkipFrameCount := 0;
end;
