procedure AsmUpdateSpriteImage(n: Integer); // vars: eax, edx, ecx
asm // eax = n
  push  ebp         ; shl   eax, 7
  push  edi         ; xor   ecx, ecx
  push  esi         ; lea   esi, [VRAM + eax] // SpriteCache = VRAM + DELTA
  push  ebx
@loop:
  mov    dl, [esi + ecx]
  mov   eax, edx    ; mov   ebp, edx    ; mov   edi, edx
  and   eax, $0088  ; and   ebp, $0044  ; and   edi, $0022
  mov    dh, [esi + ecx + 32]
  shr   eax, 3      ; shl   ebp, 6      ; shl   edi, 15
  mov   ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi    ; mov   edi, edx
  and   eax, $0011  ; and   ebp, $8800  ; and   edi, $4400
  mov    dl, [esi + ecx + 64]
  shl   eax, 24     ; shr   ebp, 10     ; shr   edi, 1
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi
  and   eax, $2200  ; and   ebp, $1100
  shl   eax, 8      ; shl   ebp, 17
  mov    dh, [esi + ecx + 96]
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
                      mov   edi, edx
  and   eax, $0088  ; and   ebp, $0044  ; and   edi, $0022
  shr   eax, 1      ; shl   ebp, 8      ; shl   edi, 17
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi    ; mov   edi, edx
  and   eax, $0011  ; and   ebp, $8800  ; and   edi, $4400
  shl   eax, 26     ; shr   ebp, 8      ; shl   edi, 1
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi
  and   eax, $2200  ; and   ebp, $1100
  shl   eax, 10     ; shl   ebp, 19
  or    eax, ebx    ; inc   ecx
  or    eax, ebp    ; cmp   ecx, 32
  mov   [esi + VRAM_SPRITECACHE_DELTA + ecx * 4 - 4], eax
  jnz   @loop
  pop   ebx
  pop   esi
  pop   edi
  pop   ebp
end;

procedure PutSprite(P, C, R, C2: PChar; H, Incr: Integer);
label
  Next;
var
  i: Integer;
  J, L: Cardinal;
begin
  for i := 0 to H - 1 do
    begin
      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      //L := SpriteToPixel(C + 1);
      L := PCardinal(C2 + 4)^;

      if J and $8000 <> 0 then PWord(P +  0)^ := PWord(R + (L shr  3) and $1E)^;
      if J and $4000 <> 0 then PWord(P +  2)^ := PWord(R + (L shr 11) and $1E)^;
      if J and $2000 <> 0 then PWord(P +  4)^ := PWord(R + (L shr 19) and $1E)^;
      if J and $1000 <> 0 then PWord(P +  6)^ := PWord(R + (L shr 27) and $1E)^;
      if J and $0800 <> 0 then PWord(P +  8)^ := PWord(R + (L shl  1) and $1E)^;
      if J and $0400 <> 0 then PWord(P + 10)^ := PWord(R + (L shr  7) and $1E)^;
      if J and $0200 <> 0 then PWord(P + 12)^ := PWord(R + (L shr 15) and $1E)^;
      if J and $0100 <> 0 then PWord(P + 14)^ := PWord(R + (L shr 23) and $1E)^;
      //L := SpriteToPixel(C);
      L := PCardinal(C2 + 0)^;
      if J and $0080 <> 0 then PWord(P + 16)^ := PWord(R + (L shr  3) and $1E)^;
      if J and $0040 <> 0 then PWord(P + 18)^ := PWord(R + (L shr 11) and $1E)^;
      if J and $0020 <> 0 then PWord(P + 20)^ := PWord(R + (L shr 19) and $1E)^;
      if J and $0010 <> 0 then PWord(P + 22)^ := PWord(R + (L shr 27) and $1E)^;
      if J and $0008 <> 0 then PWord(P + 24)^ := PWord(R + (L shl  1) and $1E)^;
      if J and $0004 <> 0 then PWord(P + 26)^ := PWord(R + (L shr  7) and $1E)^;
      if J and $0002 <> 0 then PWord(P + 28)^ := PWord(R + (L shr 15) and $1E)^;
      if J and $0001 <> 0 then PWord(P + 30)^ := PWord(R + (L shr 23) and $1E)^;
    Next:
      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
    end;
end;

procedure PutSpriteBack(P, C, R, C2: PChar;
  H, Incr, Cx, Cy, XOffset, YOffset: Integer);
label
  Next;
var
  i, No, Tx: Integer;
  J, L, M: Cardinal;
  CC1, CC2, CC3: PChar;
begin //Exit; PutSprite(P, C, R, C2, H, Incr); Exit;
  with PS do begin
  Inc(YOffset, 8);
  Dec(Cy);
  CC1 := nil; CC2 := nil; CC3 := nil;
  for i := 0 to H - 1 do
    begin
      if YOffset >= 8 then
        begin
          Cy := (Cy + 1) and BGHeightMask;
          Dec(YOffset, 8);
          No := VRAM[Cx + Cy * BGWidth].W and $7FF;
          CC1 := @VRAM[No * 16 + YOffset];
          Tx := (Cx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W and $7FF;
          CC2 := @VRAM[No * 16 + YOffset];
          Tx := (Tx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W and $7FF;
          CC3 := @VRAM[No * 16 + YOffset];
        end;
      M := Ord((CC1 +  0)^) or Ord((CC1 +  1)^)
        or Ord((CC1 + 16)^) or Ord((CC1 + 17)^);
    	M := (M shl 8) or Ord((CC2 + 0)^) or Ord((CC2 + 1)^)
        or Ord((CC2 + 16)^) or Ord((CC2 + 17)^);
      M := (M shl 8) or Ord((CC3 + 0)^) or Ord((CC3 + 1)^)
        or Ord((CC3 + 16)^) or Ord((CC3 + 17)^);
    	M := not (M shr (8 - XOffset));

      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      //L := SpriteToPixel(C + 1);
      L := PCardinal(C2 + 4)^;
      if J and M and $8000 <> 0 then PWord(P +  0)^ := PWord(R + (L shr  3) and $1E)^;
      if J and M and $4000 <> 0 then PWord(P +  2)^ := PWord(R + (L shr 11) and $1E)^;
      if J and M and $2000 <> 0 then PWord(P +  4)^ := PWord(R + (L shr 19) and $1E)^;
      if J and M and $1000 <> 0 then PWord(P +  6)^ := PWord(R + (L shr 27) and $1E)^;
      if J and M and $0800 <> 0 then PWord(P +  8)^ := PWord(R + (L shl  1) and $1E)^;
      if J and M and $0400 <> 0 then PWord(P + 10)^ := PWord(R + (L shr  7) and $1E)^;
      if J and M and $0200 <> 0 then PWord(P + 12)^ := PWord(R + (L shr 15) and $1E)^;
      if J and M and $0100 <> 0 then PWord(P + 14)^ := PWord(R + (L shr 23) and $1E)^;
      //L := SpriteToPixel(C);
      L := PCardinal(C2 + 0)^;
      if J and M and $0080 <> 0 then PWord(P + 16)^ := PWord(R + (L shr  3) and $1E)^;
      if J and M and $0040 <> 0 then PWord(P + 18)^ := PWord(R + (L shr 11) and $1E)^;
      if J and M and $0020 <> 0 then PWord(P + 20)^ := PWord(R + (L shr 19) and $1E)^;
      if J and M and $0010 <> 0 then PWord(P + 22)^ := PWord(R + (L shr 27) and $1E)^;
      if J and M and $0008 <> 0 then PWord(P + 24)^ := PWord(R + (L shl  1) and $1E)^;
      if J and M and $0004 <> 0 then PWord(P + 26)^ := PWord(R + (L shr  7) and $1E)^;
      if J and M and $0002 <> 0 then PWord(P + 28)^ := PWord(R + (L shr 15) and $1E)^;
      if J and M and $0001 <> 0 then PWord(P + 30)^ := PWord(R + (L shr 23) and $1E)^;
    Next:
      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
      Inc(YOffset);
      Inc(CC1, 2);
      Inc(CC2, 2);
      Inc(CC3, 2);
    end;
  end;
end;

procedure PutSpriteBack2(P, C, R, C2: PChar;
  H, Incr, Cx, Cy, XOffset, YOffset: Integer);
label
  Next;
var
  i, J, No, Tx: Integer;
  CL, L, M: Cardinal;
  CC1, CC2, CC3, CR1, CR2, CR3, CP: PChar;
  CC21, CC22, CC23: PCardinal;
begin //PutSpriteBack(P, C, R, C2, H, Incr, Cx, Cy, XOffset, YOffset); Exit;
  with PS do begin
  Inc(YOffset, 8);
  Dec(Cy);
  { not needed... }
  CC1 := nil; CC2 := nil; CC3 := nil;
  CR1 := nil; CR2 := nil; CR3 := nil;
  CC21 := nil; CC22 := nil; CC23 := nil;
  { till here }
  for i := 0 to H - 1 do
    begin
      if YOffset >= 8 then
        begin
          Cy := (Cy + 1) and BGHeightMask;
          Dec(YOffset, 8);
          No := VRAM[Cx + Cy * BGWidth].W;
          CR1 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC1 := @VRAM[No * 16 + YOffset];
          CC21 := @TileCache[No * 8 + YOffset];
          Tx := (Cx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W;

          CR2 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC2 := @VRAM[No * 16 + YOffset];
          CC22 := @TileCache[No * 8 + YOffset];
          Tx := (Tx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W;

          CR3 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC3 := @VRAM[No * 16 + YOffset];
          CC23 := @TileCache[No * 8 + YOffset];
        end;
      M := Ord((CC1 +  0)^) or Ord((CC1 +  1)^)
        or Ord((CC1 + 16)^) or Ord((CC1 + 17)^);
    	M := (M shl 8) or Ord((CC2 + 0)^) or Ord((CC2 + 1)^)
        or Ord((CC2 + 16)^) or Ord((CC2 + 17)^);
      M := (M shl 8) or Ord((CC3 + 0)^) or Ord((CC3 + 1)^)
        or Ord((CC3 + 16)^) or Ord((CC3 + 17)^);
    	M := not (M shr (8 - XOffset));
      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      L := PCardinal(C2 + 4)^;
      //L := SpriteToPixel(C + 1);
      if J and M and $8000 <> 0 then PWord(P +  0)^ := PWord(R + (L shr  3) and $1E)^;
      if J and M and $4000 <> 0 then PWord(P +  2)^ := PWord(R + (L shr 11) and $1E)^;
      if J and M and $2000 <> 0 then PWord(P +  4)^ := PWord(R + (L shr 19) and $1E)^;
      if J and M and $1000 <> 0 then PWord(P +  6)^ := PWord(R + (L shr 27) and $1E)^;
      if J and M and $0800 <> 0 then PWord(P +  8)^ := PWord(R + (L shl  1) and $1E)^;
      if J and M and $0400 <> 0 then PWord(P + 10)^ := PWord(R + (L shr  7) and $1E)^;
      if J and M and $0200 <> 0 then PWord(P + 12)^ := PWord(R + (L shr 15) and $1E)^;
      if J and M and $0100 <> 0 then PWord(P + 14)^ := PWord(R + (L shr 23) and $1E)^;
      L := PCardinal(C2)^;
      //L := SpriteToPixel(C);
      if J and M and $0080 <> 0 then PWord(P + 16)^ := PWord(R + (L shr  3) and $1E)^;
      if J and M and $0040 <> 0 then PWord(P + 18)^ := PWord(R + (L shr 11) and $1E)^;
      if J and M and $0020 <> 0 then PWord(P + 20)^ := PWord(R + (L shr 19) and $1E)^;
      if J and M and $0010 <> 0 then PWord(P + 22)^ := PWord(R + (L shr 27) and $1E)^;
      if J and M and $0008 <> 0 then PWord(P + 24)^ := PWord(R + (L shl  1) and $1E)^;
      if J and M and $0004 <> 0 then PWord(P + 26)^ := PWord(R + (L shr  7) and $1E)^;
      if J and M and $0002 <> 0 then PWord(P + 28)^ := PWord(R + (L shr 15) and $1E)^;
      if J and M and $0001 <> 0 then PWord(P + 30)^ := PWord(R + (L shr 23) and $1E)^;

      M := not (M shl (8 - XOffset));
      J := J shl (8 - XOffset);
      CL := CC21^;
      CP := P - XOffset * 2;

      if (XOffset <= 0) and (J and M and $800000 <> 0) then
        PWord(CP +  0)^ := PWord(CR1 + (CL shr  3) and $1E)^;
      if (XOffset <= 1) and (J and M and $400000 <> 0) then
        PWord(CP +  2)^ := PWord(CR1 + (CL shr 11) and $1E)^;
      if (XOffset <= 2) and (J and M and $200000 <> 0) then
        PWord(CP +  4)^ := PWord(CR1 + (CL shr 19) and $1E)^;
      if (XOffset <= 3) and (J and M and $100000 <> 0) then
        PWord(CP +  6)^ := PWord(CR1 + (CL shr 27) and $1E)^;
      if (XOffset <= 4) and (J and M and $080000 <> 0) then
        PWord(CP +  8)^ := PWord(CR1 + (CL shl  1) and $1E)^;
      if (XOffset <= 5) and (J and M and $040000 <> 0) then
        PWord(CP + 10)^ := PWord(CR1 + (CL shr  7) and $1E)^;
      if (XOffset <= 6) and (J and M and $020000 <> 0) then
        PWord(CP + 12)^ := PWord(CR1 + (CL shr 15) and $1E)^;
      if J and M and $010000 <> 0 then
        PWord(CP + 14)^ := PWord(CR1 + (CL shr 23) and $1E)^;

      CL := CC22^;
      if J and M and $8000 <> 0 then
        PWord(CP + 16)^ := PWord(CR2 + (CL shr  3) and $1E)^;
      if J and M and $4000 <> 0 then
        PWord(CP + 18)^ := PWord(CR2 + (CL shr 11) and $1E)^;
      if J and M and $2000 <> 0 then
        PWord(CP + 20)^ := PWord(CR2 + (CL shr 19) and $1E)^;
      if J and M and $1000 <> 0 then
        PWord(CP + 22)^ := PWord(CR2 + (CL shr 27) and $1E)^;
      if J and M and $0800 <> 0 then
        PWord(CP + 24)^ := PWord(CR2 + (CL shl  1) and $1E)^;
      if J and M and $0400 <> 0 then
        PWord(CP + 26)^ := PWord(CR2 + (CL shr  7) and $1E)^;
      if J and M and $0200 <> 0 then
        PWord(CP + 28)^ := PWord(CR2 + (CL shr 15) and $1E)^;
      if J and M and $0100 <> 0 then
        PWord(CP + 30)^ := PWord(CR2 + (CL shr 23) and $1E)^;

      CL := CC23^;
      if (XOffset >= 1) and (J and M and $80 <> 0) then
        PWord(CP + 32)^ := PWord(CR3 + (CL shr  3) and $1E)^;
      if (XOffset >= 2) and (J and M and $40 <> 0) then
        PWord(CP + 34)^ := PWord(CR3 + (CL shr 11) and $1E)^;
      if (XOffset >= 3) and (J and M and $20 <> 0) then
        PWord(CP + 36)^ := PWord(CR3 + (CL shr 19) and $1E)^;
      if (XOffset >= 4) and (J and M and $10 <> 0) then
        PWord(CP + 38)^ := PWord(CR3 + (CL shr 27) and $1E)^;
      if (XOffset >= 5) and (J and M and $08 <> 0) then
        PWord(CP + 40)^ := PWord(CR3 + (CL shl  1) and $1E)^;
      if (XOffset >= 6) and (J and M and $04 <> 0) then
        PWord(CP + 42)^ := PWord(CR3 + (CL shr  7) and $1E)^;
      if (XOffset >= 7) and (J and M and $02 <> 0) then
        PWord(CP + 44)^ := PWord(CR3 + (CL shr 15) and $1E)^;
    Next:
      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
      Inc(YOffset);
      Inc(CC1, 2);
      Inc(CC2, 2);
      Inc(CC3, 2);
      Inc(CC21);
      Inc(CC22);
      Inc(CC23);
    end;
  end;
end;

procedure PutSpriteHFlip(P, C, R, C2: PChar; H, Incr: Integer);
label
  Next;
var
  i, J: Integer;
  L: Cardinal;
begin //Exit; PutSprite(P, C, R, C2, H, Incr); Exit;
  with PS do begin
  for i := 0 to H - 1 do
    begin
      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      //L := SpriteToPixel(C);
      L := PCardinal(C2 + 0)^;
      if J and $0001 <> 0 then PWord(P +  0)^ := PWord(R + (L shr 23) and $1E)^;
      if J and $0002 <> 0 then PWord(P +  2)^ := PWord(R + (L shr 15) and $1E)^;
      if J and $0004 <> 0 then PWord(P +  4)^ := PWord(R + (L shr  7) and $1E)^;
      if J and $0008 <> 0 then PWord(P +  6)^ := PWord(R + (L shl  1) and $1E)^;
      if J and $0010 <> 0 then PWord(P +  8)^ := PWord(R + (L shr 27) and $1E)^;
      if J and $0020 <> 0 then PWord(P + 10)^ := PWord(R + (L shr 19) and $1E)^;
      if J and $0040 <> 0 then PWord(P + 12)^ := PWord(R + (L shr 11) and $1E)^;
      if J and $0080 <> 0 then PWord(P + 14)^ := PWord(R + (L shr  3) and $1E)^;
      //L := SpriteToPixel(C + 1);
      L := PCardinal(C2 + 4)^;
      if J and $0100 <> 0 then PWord(P + 16)^ := PWord(R + (L shr 23) and $1E)^;
      if J and $0200 <> 0 then PWord(P + 18)^ := PWord(R + (L shr 15) and $1E)^;
      if J and $0400 <> 0 then PWord(P + 20)^ := PWord(R + (L shr  7) and $1E)^;
      if J and $0800 <> 0 then PWord(P + 22)^ := PWord(R + (L shl  1) and $1E)^;
      if J and $1000 <> 0 then PWord(P + 24)^ := PWord(R + (L shr 27) and $1E)^;
      if J and $2000 <> 0 then PWord(P + 26)^ := PWord(R + (L shr 19) and $1E)^;
      if J and $4000 <> 0 then PWord(P + 28)^ := PWord(R + (L shr 11) and $1E)^;
      if J and $8000 <> 0 then PWord(P + 30)^ := PWord(R + (L shr  3) and $1E)^;
    Next:
      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
    end;
  end;
end;

procedure PutSpriteHFlipBack(P, C, R, C2: PChar;
  H, Incr, Cx, Cy, XOffset, YOffset: Integer);
label
  Next;
var
  i, No, Tx: Integer;
  J, L, M: Cardinal;
  CC1, CC2, CC3: PChar;
begin //Exit; PutSpriteHFlip(P, C, R, C2, H, Incr); Exit;
  //Log(50, 'SpriteHFlipBack');
  with PS do begin
  Inc(YOffset, 8);
  Dec(Cy);
  CC1 := nil; CC2 := nil; CC3 := nil;
  for i := 0 to H - 1 do
    begin
      if YOffset >= 8 then
        begin
          Cy := (Cy + 1) and BGHeightMask;
          Dec(YOffset, 8);
          No := VRAM[Cx + Cy * BGWidth].W and $7ff;
          CC1 := @VRAM[No * 16 + YOffset];
          Tx := (Cx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W and $7ff;
          CC2 := @VRAM[No * 16 + YOffset];
          Tx := (Tx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W and $7ff;
          CC3 := @VRAM[No * 16 + YOffset];
        end;
      M := Ord((CC1 +  0)^) or Ord((CC1 +  1)^)
        or Ord((CC1 + 16)^) or Ord((CC1 + 17)^);
    	M := (M shl 8) or Ord((CC2 + 0)^) or Ord((CC2 + 1)^)
        or Ord((CC2 + 16)^) or Ord((CC2 + 17)^);
      M := (M shl 8) or Ord((CC3 + 0)^) or Ord((CC3 + 1)^)
        or Ord((CC3 + 16)^) or Ord((CC3 + 17)^);
    	M := M shr (8 - XOffset);
      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      //L := SpriteToPixel(C + 1);
      L := PCardinal(C2 + 4)^;
      if (J and $01) or (M and $8000) = $01 then
        PWord(P +  0)^ := PWord(R + (L shr 23) and $1E)^;
      if (J and $02) or (M and $4000) = $02 then
        PWord(P +  2)^ := PWord(R + (L shr 15) and $1E)^;
      if (J and $04) or (M and $2000) = $04 then
        PWord(P +  4)^ := PWord(R + (L shr  7) and $1E)^;
      if (J and $08) or (M and $1000) = $08 then
        PWord(P +  6)^ := PWord(R + (L shl  1) and $1E)^;
      if (J and $10) or (M and $0800) = $10 then
        PWord(P +  8)^ := PWord(R + (L shr 27) and $1E)^;
      if (J and $20) or (M and $0400) = $20 then
        PWord(P + 10)^ := PWord(R + (L shr 19) and $1E)^;
      if (J and $40) or (M and $0200) = $40 then
        PWord(P + 12)^ := PWord(R + (L shr 11) and $1E)^;
      if (J and $80) or (M and $0100) = $80 then
        PWord(P + 14)^ := PWord(R + (L shr  3) and $1E)^;
      //L := SpriteToPixel(C);
      L := PCardinal(C2)^;
      if (J and $0100) or (M and $80) = $0100 then
        PWord(P + 16)^ := PWord(R + (L shr 23) and $1E)^;
      if (J and $0200) or (M and $40) = $0200 then
        PWord(P + 18)^ := PWord(R + (L shr 15) and $1E)^;
      if (J and $0400) or (M and $20) = $0400 then
        PWord(P + 20)^ := PWord(R + (L shr  7) and $1E)^;
      if (J and $0800) or (M and $10) = $0800 then
        PWord(P + 22)^ := PWord(R + (L shl  1) and $1E)^;
      if (J and $1000) or (M and $08) = $1000 then
        PWord(P + 24)^ := PWord(R + (L shr 27) and $1E)^;
      if (J and $2000) or (M and $04) = $2000 then
        PWord(P + 26)^ := PWord(R + (L shr 19) and $1E)^;
      if (J and $4000) or (M and $02) = $4000 then
        PWord(P + 28)^ := PWord(R + (L shr 11) and $1E)^;
      if (J and $8000) or (M and $01) = $8000 then
        PWord(P + 30)^ := PWord(R + (L shr  3) and $1E)^;
    Next:
      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
      Inc(YOffset);
      Inc(CC1, 2);
      Inc(CC2, 2);
      Inc(CC3, 2);
    end;
  end;
end;

procedure PutSpriteHFlipBack2(P, C, R, C2: PChar;
  H, Incr, Cx, Cy, XOffset, YOffset: Integer);
label
  Next;
var
  i, No, Tx: Integer;
  J, CL, L, M: Cardinal;
  CC1, CC2, CC3, CR1, CR2, CR3, CP: PChar;
  CC21, CC22, CC23: PCardinal;
begin //Exit; PutSpriteHFlip(P, C, R, C2, H, Incr); Exit;
  //Log(50, 'SpriteHFlipBack2');
  with PS do begin
  Inc(YOffset, 8);
  Dec(Cy);
  { not needed... }
  CC1 := nil; CC2 := nil; CC3 := nil;
  CR1 := nil; CR2 := nil; CR3 := nil;
  CC21 := nil; CC22 := nil; CC23 := nil;
  { till here }
  for i := 0 to H - 1 do
    begin
      if YOffset >= 8 then
        begin
          Cy := (Cy + 1) and BGHeightMask;
          Dec(YOffset, 8);
          No := VRAM[Cx + Cy * BGWidth].W;
          CR1 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC1 := @VRAM[No * 16 + YOffset];
          CC21 := @TileCache[No * 8 + YOffset];
          Tx := (Cx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W;

          CR2 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC2 := @VRAM[No * 16 + YOffset];
          CC22 := @TileCache[No * 8 + YOffset];
          Tx := (Tx + 1) and BGWidthMask;
          No := VRAM[Tx + Cy * BGWidth].W;

          CR3 := @RGBPalette[(No shr 12) * 16];
          No := No and $7ff;
          CC3 := @VRAM[No * 16 + YOffset];
          CC23 := @TileCache[No * 8 + YOffset];
        end;
      M := Ord((CC1 +  0)^) or Ord((CC1 +  1)^)
        or Ord((CC1 + 16)^) or Ord((CC1 + 17)^);
    	M := (M shl 8) or Ord((CC2 + 0)^) or Ord((CC2 + 1)^)
        or Ord((CC2 + 16)^) or Ord((CC2 + 17)^);
      M := (M shl 8) or Ord((CC3 + 0)^) or Ord((CC3 + 1)^)
        or Ord((CC3 + 16)^) or Ord((CC3 + 17)^);
    	M := M shr (8 - XOffset);
      J := PWord(C)^ or PWord(C + 32)^ or PWord(C + 64)^ or PWord(C + 96)^;
      if J = 0 then goto Next;
      //L := SpriteToPixel(C);
      L := PCardinal(C2)^;
      if (J and $80) or (M and $0100) = $80 then
        PWord(P + 14)^ := PWord(R + (L shr  3) and $1E)^;
      if (J and $40) or (M and $0200) = $40 then
        PWord(P + 12)^ := PWord(R + (L shr 11) and $1E)^;
      if (J and $20) or (M and $0400) = $20 then
        PWord(P + 10)^ := PWord(R + (L shr 19) and $1E)^;
      if (J and $10) or (M and $0800) = $10 then
        PWord(P +  8)^ := PWord(R + (L shr 27) and $1E)^;
      if (J and $08) or (M and $1000) = $08 then
        PWord(P +  6)^ := PWord(R + (L shl  1) and $1E)^;
      if (J and $04) or (M and $2000) = $04 then
        PWord(P +  4)^ := PWord(R + (L shr  7) and $1E)^;
      if (J and $02) or (M and $4000) = $02 then
        PWord(P +  2)^ := PWord(R + (L shr 15) and $1E)^;
      if (J and $01) or (M and $8000) = $01 then
        PWord(P +  0)^ := PWord(R + (L shr 23) and $1E)^;
      //L := SpriteToPixel(C + 1);
      L := PCardinal(C2 + 4)^;
      if (J and $8000) or (M and $01) = $8000 then
        PWord(P + 30)^ := PWord(R + (L shr  3) and $1E)^;
      if (J and $4000) or (M and $02) = $4000 then
        PWord(P + 28)^ := PWord(R + (L shr 11) and $1E)^;
      if (J and $2000) or (M and $04) = $2000 then
        PWord(P + 26)^ := PWord(R + (L shr 19) and $1E)^;
      if (J and $1000) or (M and $08) = $1000 then
        PWord(P + 24)^ := PWord(R + (L shr 27) and $1E)^;
      if (J and $0800) or (M and $10) = $0800 then
        PWord(P + 22)^ := PWord(R + (L shl  1) and $1E)^;
      if (J and $0400) or (M and $20) = $0400 then
        PWord(P + 20)^ := PWord(R + (L shr  7) and $1E)^;
      if (J and $0200) or (M and $40) = $0200 then
        PWord(P + 18)^ := PWord(R + (L shr 15) and $1E)^;
      if (J and $0100) or (M and $80) = $0100 then
        PWord(P + 16)^ := PWord(R + (L shr 23) and $1E)^;
    Next:
      M := M shl (8 - XOffset);
      J := J shl XOffset;
      CL := CC21^;
      CP := P - XOffset * 2;

      if (XOffset <= 0) and ((J and $01) or (M and $800000) = $800001) then
        PWord(CP +  0)^ := PWord(CR1 + (CL shr  3) and $1E)^;
      if (XOffset <= 1) and ((J and $02) or (M and $400000) = $400002) then
        PWord(CP +  2)^ := PWord(CR1 + (CL shr 11) and $1E)^;
      if (XOffset <= 2) and ((J and $04) or (M and $200000) = $200004) then
        PWord(CP +  4)^ := PWord(CR1 + (CL shr 19) and $1E)^;
      if (XOffset <= 3) and ((J and $08) or (M and $100000) = $100008) then
        PWord(CP +  6)^ := PWord(CR1 + (CL shr 27) and $1E)^;
      if (XOffset <= 4) and ((J and $10) or (M and $080000) = $080010) then
        PWord(CP +  8)^ := PWord(CR1 + (CL shl  1) and $1E)^;
      if (XOffset <= 5) and ((J and $20) or (M and $040000) = $040020) then
        PWord(CP + 10)^ := PWord(CR1 + (CL shr  7) and $1E)^;
      if (XOffset <= 6) and ((J and $40) or (M and $020000) = $020040) then
        PWord(CP + 12)^ := PWord(CR1 + (CL shr 15) and $1E)^;
      if (J and $80) or (M and $010000) = $010080 then
        PWord(CP + 14)^ := PWord(CR1 + (CL shr 23) and $1E)^;

      CL := CC22^;
      if (J and $0100) or (M and $8000) = $8100 then
        PWord(CP + 16)^ := PWord(CR2 + (CL shr  3) and $1E)^;
      if (J and $0200) or (M and $4000) = $4200 then
        PWord(CP + 18)^ := PWord(CR2 + (CL shr 11) and $1E)^;
      if (J and $0400) or (M and $2000) = $2400 then
        PWord(CP + 20)^ := PWord(CR2 + (CL shr 19) and $1E)^;
      if (J and $0800) or (M and $1000) = $1800 then
        PWord(CP + 22)^ := PWord(CR2 + (CL shr 27) and $1E)^;
      if (J and $1000) or (M and $0800) = $1800 then
        PWord(CP + 24)^ := PWord(CR2 + (CL shl  1) and $1E)^;
      if (J and $2000) or (M and $0400) = $2400 then
        PWord(CP + 26)^ := PWord(CR2 + (CL shr  7) and $1E)^;
      if (J and $4000) or (M and $0200) = $4200 then
        PWord(CP + 28)^ := PWord(CR2 + (CL shr 15) and $1E)^;
      if (J and $8000) or (M and $0100) = $8100 then
        PWord(CP + 30)^ := PWord(CR2 + (CL shr 23) and $1E)^;

      CL := CC23^;
      if (XOffset >= 1) and ((J and $010000) or (M and $80) = $010080) then
        PWord(CP + 32)^ := PWord(CR3 + (CL shr  3) and $1E)^;
      if (XOffset >= 2) and ((J and $020000) or (M and $40) = $020040) then
        PWord(CP + 34)^ := PWord(CR3 + (CL shr 11) and $1E)^;
      if (XOffset >= 3) and ((J and $040000) or (M and $20) = $040020) then
        PWord(CP + 36)^ := PWord(CR3 + (CL shr 19) and $1E)^;
      if (XOffset >= 4) and ((J and $080000) or (M and $10) = $040010) then
        PWord(CP + 38)^ := PWord(CR3 + (CL shr 27) and $1E)^;
      if (XOffset >= 5) and ((J and $100000) or (M and $08) = $100008) then
        PWord(CP + 40)^ := PWord(CR3 + (CL shl  1) and $1E)^;
      if (XOffset >= 6) and ((J and $200000) or (M and $04) = $200004) then
        PWord(CP + 42)^ := PWord(CR3 + (CL shr  7) and $1E)^;
      if (XOffset >= 7) and ((J and $400000) or (M and $02) = $400002) then
        PWord(CP + 44)^ := PWord(CR3 + (CL shr 15) and $1E)^;

      Inc(C, Incr);
      Inc(C2, Incr * 4);
      Inc(P, MAX_WIDTH + MAX_WIDTH);
      Inc(YOffset);
      Inc(CC1, 2);
      Inc(CC2, 2);
      Inc(CC3, 2);
      Inc(CC21);
      Inc(CC22);
      Inc(CC23);
    end;
  end;
end;

procedure RefreshSprite(Y1, Y2: Integer);
const
  SPRITE_VFLIP = $8000;
  SPRITE_HFLIP = $0800;
  SPRITE_IN_BG = $80;
var
  Spr: PSprite;
  Pos, Attr, N, Y, No, X, Cgx, Cgy, Incr, YSum, Cy, Cx: Integer;
  XOffset, YOffset, i, j, T, H, Tx: Integer;
  R, C, C2: PChar;
  UsesBg: Boolean;
begin
  with PS do begin
  UsesBg := False;
  for N := 63 downto 0 do
    begin
      Spr := @SPRAM[N];
      Attr := Spr^.Attr;
      Y := (Spr^.Y and 1023) - 64;
      X := (Spr^.X and 1023) - 32;
      Cgx := (Attr shr 8) and $1;
      Cgy := (Attr shr 12) and $3;
      Cgy := Cgy or (Cgy shr 1);
      if (Y >= Y2) or (Y + (Cgy + 1) * 16 < Y1) or (X >= ScreenWidth) or
          (X + (Cgx + 1) * 16 < 0) then Continue;
      No := Spr^.No and 2047;
      No := (No shr 1) and not (Cgy * 2 + Cgx);

      i := 0;
      While i < Cgy * 2 + Cgx + 1 do
        begin
          if SpriteState[No + i] <> 0 then
            begin
              SpriteState[No + i] := 0;
              AsmUpdateSpriteImage(No + i);
              //SpriteToPixel(No + i);
            end;
          if Cgx = 0 then Inc(I);
          Inc(I);
        end;

      R := @RGBPalette[$100 + (Attr and $0F) * 16];
      C := @VRAM[No * 64];
      C2 := @SpriteCache[No * 32];
      Pos := 32 + MAX_WIDTH * Y + X;
      Incr := 2;
      if Attr and SPRITE_VFLIP <> 0 then
        begin
          Incr := -2;
          Inc(C, 15 * 2 + Cgy * 256);
          Inc(C2, 15 * 2 * 4 + Cgy * 64 * 4);
        end;
      YSum := 0;
      Cy := Y + Regs[R_BYR].W - ScrollYDiff;
      YOffset := Cy and $7;
      Cy := Cy shr 3;
      XOffset := (X + Regs[R_BXR].W) and $7;
      Cx := (X + Regs[R_BXR].W) div 8; // can't be shr

      for i := 0 to Cgy do
        begin
          Cy := Cy and BGHeightMask;
          T := Y1 - Y - YSum;
          H := 16;
          if T > 0 then
            begin
              Inc(C, T * Incr);
              Inc(C2, T * Incr * 4);
              Dec(H, T);
              Inc(Pos, T * MAX_WIDTH);
              Inc(Cy, (YOffset + T) shr 3);
              YOffset := (YOffset + T) and $7;
            end;
          if H > Y2 - Y - YSum then H := Y2 - Y - YSum;
          if (Attr and SPRITE_IN_BG <> 0) or (Regs[R_CR].W and CR_BG_ON = 0) then
            begin
              UsesBg := True;
              if Attr and SPRITE_HFLIP <> 0 then
                for j := 0 to Cgx do
                  PutSpriteHFlip(@Bitmap[Pos + (Cgx - j) * 16],
                    C + j * 128, R, C2 + j * 128, H, Incr)
              else
                for j := 0 to Cgx do
                  PutSprite(@Bitmap[Pos + j * 16],
                    C + j * 128, R, C2 + j * 128, H, Incr);
            end
          else
            begin
              if UsesBg then
                begin
                  if Attr and SPRITE_HFLIP <> 0 then
                    begin
                      Tx := Cx;
                      for j := 0 to Cgx do
                        begin
                          Tx := Tx and (BGWidth - 1);
                          PutSpriteHFlipBack2(PChar(@Bitmap[Pos + j * 16]),
                            C + (Cgx - j) * 128, R, C2 + (Cgx - j) * 128,
                            H, Incr, Tx, Cy, XOffset, YOffset);
                          Inc(Tx, 2);
                        end;
                    end
                  else
                    begin
                      Tx := Cx;
                      for j := 0 to Cgx do
                        begin
                          Tx := Tx and (BGWidth - 1);
                          PutSpriteBack2(PChar(@Bitmap[Pos + j * 16]),
                            C + j * 128, R, C2 + j * 128,
                            H, Incr, Tx, Cy, XOffset, YOffset);
                          Inc(Tx, 2);
                        end;
                    end
                end
              else
                begin
                  if Attr and SPRITE_HFLIP <> 0 then
                    begin
                      Tx := Cx;
                      for j := 0 to Cgx do
                        begin
                          Tx := Tx and (BGWidth - 1);
                          PutSpriteHFlipBack(PChar(@Bitmap[Pos + j * 16]),
                            C + (Cgx - j) * 128, R, C2 + (Cgx - j) * 128,
                            H, Incr, Tx, Cy, XOffset, YOffset);
                          Inc(Tx, 2);
                        end;
                    end
                  else
                    begin
                      //Log(50, 'cx = %d, cgx = %d', [cx, cgx]);
                      Tx := Cx;
                      for j := 0 to Cgx do
                        begin
                          Tx := Tx and BGWidthMask;
                          PutSpriteBack(PChar(@Bitmap[Pos + j * 16]),
                            C + j * 128, R, C2 + j * 128,
                            H, Incr, Tx, Cy, XOffset, YOffset);
                          Inc(Tx, 2);
                        end;
                    end;
                end;
            end;
          Inc(Pos, H * MAX_WIDTH);
          Inc(C, H * Incr + 16 * 7 * Incr);
          Inc(C2, H * Incr * 4 + 16 * Incr * 4);
          Inc(YSum, 16);
          Inc(Cy, (YOffset + H) shr 3);
          YOffset := (YOffset + H) and $7;
        end;
    end;
  end;
end;
