unit IO_CDROM;

interface

procedure PowerOn;

implementation

uses
  CPU, IO_Shared, LogUnit, BinaryFile;

var
  BackupActive: Boolean;

function Read_1803: Byte;
begin
  BackupActive := False;
  Result := Ord(BackupActive);
end;

procedure Write_1807(Value: Byte);
begin
  BackupActive := True;
end;

procedure Reset;
begin
  BackupActive := False;
end;

function LoadState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.ReadCount(@BackupActive, SizeOf(BackupActive));
    Result := True;
  except
  end;
end;

function SaveState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.Write(@BackupActive, SizeOf(BackupActive));
    Result := True;
  except
  end;
end;

procedure PowerOn;
begin
  IOReadHandler[$1803] := Read_1803;
  IOWriteHandler[$1807] := Write_1807;
  ResetList.Add(@Reset);
  LoadSaveStateList.Add(@LoadState);
  LoadSaveStateList.Add(@SaveState);
  Reset;
end;

end.
