var
  IRQMask, IRQStatus: Byte;

procedure Reset_Interrupts;
begin
  IRQMask := 0;
  IRQStatus := 0;
end;

procedure Read_Interrupts;
begin
  case CPU.IOPort.L of
    2:  CPU.IOValue := IRQMask;
    3:  begin
          CPU.IOValue := IRQStatus;
          IRQStatus := 0;
        end;
    else
      InvalidRead;
  end;
end;

procedure Write_Interrupts;
const
  IRQ_TIMER = $04;
begin
  case CPU.IOPort.L of
    2:  IRQMask := CPU.IOValue;
    3:  IRQStatus := IRQStatus and not IRQ_TIMER or CPU.IOValue and $F8;
    else
      InvalidWrite;
  end;
end;

