unit IO_Shared;

interface

uses
  Classes, Messages;

const
  MSG_WRITE_INFO  = WM_APP + 500;
  MSG_CPU_BROKEN  = MSG_WRITE_INFO + 1;

type
  WordBytes = record
    case Integer of
      0: (W: Word);
      1: (L, H: Byte);
  end;
  TMsgWriteInfo = packed record
    Msg: Cardinal;
    Cycles: Cardinal;
    FPS, IOError: Word;
    Result: LongInt;
  end;

var
  LoadSaveStateList, PowerOffList, PauseList, ResumeList, ResetList: TList;
  RGBPalette: array[0..$1ff] of Word;
  IRQMask: Byte;
  IsOn: Boolean = False;
  IsPaused, IsBroken: Boolean;
  InvalidReads, InvalidWrites: Integer;
  MainWindow: Cardinal;

function Max(A, B: Integer): Integer;
function Min(A, B: Integer): Integer;

implementation

uses
  LogUnit, SysUtils;

function Max(A, B: Integer): Integer;
asm
  cmp   eax, edx
  jge   @done
  mov   eax, edx
@done:
end;

function Min(A, B: Integer): Integer;
asm
  cmp   edx, eax
  jge   @done
  mov   eax, edx
@done:
end;

end.
