unit Config;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm2 = class(TForm)
    Label1: TLabel;
    SSDir: TEdit;
    Label2: TLabel;
    cbSoundFormat: TComboBox;
    Label3: TLabel;
    Player1: TComboBox;
    Label4: TLabel;
    Player2: TComboBox;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbSoundFormatChange(Sender: TObject);
    procedure Player1Change(Sender: TObject);
    procedure Player2Change(Sender: TObject);
  private
    procedure SetSoundFormat;
  public
    procedure NewLastDir(Dir: string);
    procedure NewLastRom(Rom: string);
    procedure NewLast(Value: string; var Cache: array of string);
    procedure UpdateMenu;
  end;
  TPlayerInput = (iKeyboard, iJoystick, iBoth);

var
  Form2: TForm2;
  SF: Integer;
  LastDir, LastRom: array[1..4] of string;
  InputP1, InputP2: TPlayerInput;

implementation

{$R *.DFM}

uses
  Registry, Main, DXSounds, MMSystem, Wave;

const
  SOUND_FORMAT: array[0..11] of array[0..2] of Integer = (
    (11025, 8, 1), (11025, 8, 2), (11025, 16, 1), (11025, 16, 2),
    (22050, 8, 1), (22050, 8, 2), (22050, 16, 1), (22050, 16, 2),
    (44100, 8, 1), (44100, 8, 2), (44100, 16, 1), (44100, 16, 2));

procedure TForm2.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then Form2.Close;
end;

procedure TForm2.FormCreate(Sender: TObject);
var
  Reg: TRegistry;
  i: Integer;
  s: string;
begin
  SF := 0;
  for i := 1 to 4 do
    begin
      LastDir[i] := '';
      LastRom[i] := '';
    end;
  InputP1 := iJoystick;
  InputP2 := iKeyboard;
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\PCE\PCEE', False) then
      begin
        SSDir.Text := Reg.ReadString('SaveStateDir');
        SF := StrToInt(Reg.ReadString('SoundFormat'));
        s := Reg.ReadString('InputP1');
        if s <> '' then InputP1 := TPlayerInput(StrToInt(s));
        s := Reg.ReadString('InputP2');
        if s <> '' then InputP2 := TPlayerInput(StrToInt(s));
        for i := 1 to 4 do
          begin
            LastDir[i] := Reg.ReadString('LastDir' + IntToStr(i));
            LastRom[i] := Reg.ReadString('LastRom' + IntToStr(i));
          end;

      end;
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
  cbSoundFormat.ItemIndex := SF;
  SetSoundFormat;
  UpdateMenu;
  Player1.ItemIndex := Ord(InputP1);
  Player2.ItemIndex := Ord(InputP2);
end;

procedure TForm2.FormDestroy(Sender: TObject);
var
  Reg: TRegistry;
  i: Integer;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\PCE\PCEE', True) then
      begin
        Reg.WriteString('SaveStateDir', SSDir.Text);
        Reg.WriteString('SoundFormat', IntToStr(SF));
        for i := 1 to 4 do
          begin
            Reg.WriteString('LastDir' + IntToStr(i), LastDir[i]);
            Reg.WriteString('LastRom' + IntToStr(i), LastRom[i]);
          end;
        Reg.WriteString('InputP1', IntToStr(Ord(InputP1)));
        Reg.WriteString('InputP2', IntToStr(Ord(InputP2)));
      end;
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

procedure TForm2.cbSoundFormatChange(Sender: TObject);
begin
  if not Form1.DXSound.Initialized then Exit;
  if cbSoundFormat.ItemIndex = SF then Exit;
  SF := cbSoundFormat.ItemIndex;
  SetSoundFormat;
end;

procedure TForm2.SetSoundFormat;
var
  SoundFormat: TWaveFormatEx;
begin
  try
    MakePCMWaveFormatEx(SoundFormat,
      SOUND_FORMAT[SF, 0], SOUND_FORMAT[SF, 1], SOUND_FORMAT[SF, 2]);
    Form1.DXSound.Primary.SetFormat(SoundFormat);
  except
  end;
end;

procedure TForm2.NewLastDir(Dir: string);
begin
  NewLast(Dir, LastDir);
end;

procedure TForm2.NewLastRom(Rom: string);
begin
  NewLast(Rom, LastRom);
end;

procedure TForm2.NewLast(Value: string; var Cache: array of string);
var
  i, j: Integer;
begin
  if CompareText(Cache[0], Value) = 0 then Exit;
  for i := 1 to 4 - 1 do
    if CompareText(Cache[i], Value) = 0 then
      begin
        for j := i downto 1 do Cache[j] := Cache[j - 1];
        Cache[0] := Value;
        UpdateMenu;
        Exit;
      end;
  for i := 4 - 1 downto 1 do Cache[i] := Cache[i - 1];
  Cache[0] := Value;
  UpdateMenu;
end;

procedure TForm2.UpdateMenu;
var
  i: Integer;
begin
  for i := 1 to 4 do
    with Form1.ROM1 do
      begin
        with Items[i + 1] do
          begin
            Visible := LastRom[i] <> '';
            Caption := LastRom[i];
          end;
        with Items[i + 4 + 2] do
          begin
            Visible := LastDir[i] <> '';
            Caption := LastDir[i];
          end;
      end;
end;

procedure TForm2.Player1Change(Sender: TObject);
begin
  InputP1 := TPlayerInput(Player1.ItemIndex);
end;

procedure TForm2.Player2Change(Sender: TObject);
begin
  InputP2 := TPlayerInput(Player2.ItemIndex);
end;

end.
