unit IO_Timer;

interface

procedure PowerOn;
procedure Tick;

implementation

uses
  CPU, IO_Shared, LogUnit, IO_IRQ, BinaryFile;

const
  TIMER_MAX = $7F;

type
  TPS = record
    Max, Count, OnOff: Byte;
  end;

var
  PS: TPS;

function Read_c00: Byte;
begin
  Result := PS.Count;
end;

function Read_c01: Byte;
begin
  Result := PS.OnOff;
end;

procedure Write_c00(Value: Byte);
begin
  PS.Max := Value and $7F;
end;

procedure Write_c01(Value: Byte);
begin
  if (Value and 1 = 1) and (PS.OnOff = 0) then PS.Count := PS.Max;
  PS.OnOff := Value and 1;
end;

procedure Tick;
begin
  if PS.OnOff <> 0 then
    begin
      Dec(PS.Count);
      if PS.Count > $80 then
        begin
          PS.Count := PS.Max;
          if IRQMask and IRQ_TIMER = 0 then
            CPU.State.IRQs := CPU.State.IRQs or IRQ_TIMER;
        end;
    end;
end;

procedure Reset;
begin
  PS.Count := $7F;
  PS.OnOff := $00;
  PS.Max := TIMER_MAX;
end;

function LoadState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.ReadCount(@PS, SizeOf(PS));
    Result := True;
  except
  end;
end;

function SaveState(F: TBinaryFile): Boolean;
begin
  Result := False;
  try
    F.Write(@PS, SizeOf(PS));
    Result := True;
  except
  end;
end;

procedure PowerOn;
begin
  IOReadHandler[$c00] := Read_c00;
  IOReadHandler[$c01] := Read_c01;
  IOWriteHandler[$c00] := Write_c00;
  IOWriteHandler[$c01] := Write_c01;
  ResetList.Add(@Reset);
  LoadSaveStateList.Add(@LoadState);
  LoadSaveStateList.Add(@SaveState);
  Reset;
end;

end.
