unit PentiumTimer;

interface

type
  TPTimer = Int64;

procedure StartCounting(var Timer: TPTimer);
function GetElapsed(Timer: TPTimer): Cardinal;

implementation

uses
  Windows;

var
  Freq: Int64 = 0;

procedure StartCounting(var Timer: TPTimer);
begin
  if Freq = 0 then QueryPerformanceFrequency(Freq);
  QueryPerformanceCounter(Timer);
end;

function GetElapsed(Timer: TPTimer): Cardinal;
var
  X: Int64;
begin
  QueryPerformanceCounter(X);
  Result := (X - Timer) * 1000000 div Freq;
end;

end.
