procedure AsmUpdateTileImage(T: Integer); // vars: eax, edx, ecx
asm // eax = T
  push  ebp         ; shl   eax, 5
  push  edi         ; xor   ecx, ecx
  push  esi         ; lea   esi, [VRAM + eax] // TileCache = VRAM + DELTA
  push  ebx
@loop:
  mov   edx, [esi + ecx * 2] // should be only dx, but...
  mov   eax, edx    ; mov   ebp, edx    ; mov   edi, edx
  and   eax, $0088  ; and   ebp, $0044  ; and   edi, $0022
  shr   eax, 3      ; shl   ebp, 6      ; shl   edi, 15
  mov   ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi    ; mov   edi, edx
  and   eax, $0011  ; and   ebp, $8800  ; and   edi, $4400
  shl   eax, 24     ; shr   ebp, 10     ; shr   edi, 1
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi
  and   eax, $2200  ; and   ebp, $1100
  shl   eax, 8      ; shl   ebp, 17
  mov   edx, [esi + 16 + ecx * 2]
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
                      mov   edi, edx
  and   eax, $0088  ; and   ebp, $0044  ; and   edi, $0022
  shr   eax, 1      ; shl   ebp, 8      ; shl   edi, 17
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi    ; mov   edi, edx
  and   eax, $0011  ; and   ebp, $8800  ; and   edi, $4400
  shl   eax, 26     ; shr   ebp, 8      ; shl   edi, 1
  or    ebx, eax    ; mov   eax, edx
  or    ebx, ebp    ; mov   ebp, edx
  or    ebx, edi
  and   eax, $2200  ; and   ebp, $1100
  shl   eax, 10     ; shl   ebp, 19
  or    eax, ebx    ; inc   ecx
  or    eax, ebp    ; cmp   ecx, 8
  mov   [esi + VRAM_TILECACHE_DELTA + ecx * 4 - 4], eax
  jnz   @loop
  pop   ebx
  pop   esi
  pop   edi
  pop   ebp
end;

procedure AsmDrawBGLine(Dest: PChar; N, YY: Integer);
var
  BN, TileLine, TilesLeft, Pos: Cardinal;
asm // eax = Dest, edx = N, ecx = YY
  mov   [Pos], edx  ; push  esi
  mov   esi, edx    ; push  edi
  mov   edi, eax    ; mov   eax, edx
  push  ebx         ; and   eax, [PS.BGWidthNMask]
  shl   ecx, 2      ; mov   [BN], eax
  mov   eax, [PS.HorizontalTiles]
  mov   [TileLine], ecx
  mov   [TilesLeft], eax
@loop:
  mov   eax, dword ptr [VRAM + esi * 2]
  mov   edx, eax
  and   eax, $7ff
  cmp   byte ptr [TileState + eax], 0
  jz    @not_changed
  mov   byte ptr [TileState + eax], 0
  push  eax; push ecx; push ecx
  call  AsmUpdateTileImage
  pop   edx; pop ecx; pop eax
@not_changed:
  shl   eax, 5        ; shr   edx, 7
  lea   eax, [TileCache + eax]
  and   edx, $1e0
  add   eax, [TileLine]
  lea   ebx, [RGBPalette + edx]
  mov   eax, [eax] // eax:ecx, esi:eax, ecx:esi, eax:edx

  mov   edx, eax      ; mov   ecx, eax  ; mov   esi, eax
  shr   eax, 11       ; shr   ecx, 3    ; shr   esi, 27
  and   eax, $1e      ; and   ecx, $1e  ; and   esi, $1e
  mov   eax, [ebx + eax - 2]
  mov   esi, [ebx + esi - 2]
  mov    ax, [ebx + ecx]
  mov   ecx, edx
  mov   [edi + $0], eax
  mov   eax, edx      ; shr   ecx, 7    ; shr   eax, 19
  and   ecx, $1e      ; and   eax, $1e
  mov   ecx, [ebx + ecx - 2]
  mov    si, [ebx + eax]
  mov   eax, edx
  mov   [edi + $4], esi
  mov   eax, edx      ; mov   esi, edx
  shr   eax, 23       ; shl   esi, 1    ; shr   edx, 15
  and   eax, $1e      ; and   esi, $1e  ; and   edx, $1e
  mov   eax, [ebx + eax - 2]
  mov    cx, [ebx + esi]
  mov   esi, [Pos]
  mov   [edi + $8], ecx
  inc   esi           ; add   edi, 16
  and   esi, [PS.BGWidthMask]
  mov    ax, [ebx + edx]
  add   esi, [BN]
  mov   [edi + $c - 16], eax
  dec   [TilesLeft]   ; mov   [Pos], esi

  jnz   @loop
  pop   ebx
  pop   edi
  pop   esi
end;

procedure DrawBGLines(Y1, Y2: Integer);
var
  i, j, Pal, Y, X, N: Integer;
  BW: PChar;
begin
  with PS do begin
  if (Regs[R_CR].W and CR_BG_ON = 0) then
    begin
      BW := @Bitmap[MAX_WIDTH * Y1 + 32];
      Pal := RGBPalette[0];
      for i := Y1 to Y2 do
        begin
          for j := 0 to ScreenWidth - 1 do
            PWord(BW + j * 2)^ := Pal;
          Inc(BW, MAX_WIDTH + MAX_WIDTH);
        end;
      Exit;
    end;
  X := Regs[R_BXR].W;
  Y := Y1 + Regs[R_BYR].W - ScrollYDiff;
  BW := @Bitmap[MAX_WIDTH * Y1 + 32 - X and $07];
  N := (X shr 3) and BGWidthMask;
  for i := Y1 to Y2 do
    begin
      AsmDrawBGLine(BW, N + ((Y shr 3) and BGHeightMask) shl BGWidthShift, Y and $7);
      Inc(BW, MAX_WIDTH + MAX_WIDTH);
      Inc(Y);
    end;
  end;
end;


