/*****************************************************************************
 *                                                                           *
 * Module : CRTC.C                                                           *
 *                                                                           *
 * Gestion du CRTC 6845                                                      *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>
#include  <mem.h>

#include  "vga.h"


//
// Tableau des adresses cran du CPC
//
USHORT tabAdrMemEcrCPC[ 0x4000 ];


static UBYTE RegsCRTC[ 32 ];

USHORT adrEcr = 3;  // adresse mmoire cran (banque de 0  3)

static USHORT lastReg = 0;


//
// Recalcule la table de conversion Adresse ecran CPC->Adresse ecran PC
//
static void CalcAdrEcrCPC( void )
{
    UBYTE tc = RegsCRTC[ 1 ] << 1;
    USHORT offset = ( ( RegsCRTC[ 13 ] + ( RegsCRTC[ 12 ] << 8 ) ) << 1 );
    USHORT reste = 2048 - RegsCRTC[ 6 ] * tc, adr = 0;
    USHORT decal, AdrCPC, TailleColonne, NbLignes, NbBlocks;
    UBYTE ofsL = ( ( 46 - RegsCRTC[ 2 ]  ) << 1 );

    memset( tabAdrMemEcrCPC, 0, sizeof( tabAdrMemEcrCPC ) );

    for ( NbBlocks = 0; NbBlocks < 640; NbBlocks += 80 )
        {
        decal = NbBlocks;
        for ( NbLignes = RegsCRTC[ 6 ]; NbLignes--; )
            {
            TailleColonne = tc;
            for ( AdrCPC = decal + ofsL; TailleColonne--; adr++ )
                tabAdrMemEcrCPC[ AdrCPC++ & 0x3FFF ] = ( adr & 0x3800 )
                                                     + ( ( offset + adr ) & 0x7FF );
            decal += 640;
            }
        adr += reste;
        }
}


//
// Ecriture d'un registre du CRTC
//
void WriteCRTC( USHORT adr, UBYTE val )
{
    if ( ( adr & 0xBF00 ) == 0xBC00 )
        lastReg = val & 31;
    else
        if ( ( ( adr & 0xBF00 ) == 0xBD00 ) && ( RegsCRTC[ lastReg ] != val ) )
            {
            UBYTE tmp = RegsCRTC[ lastReg ];
            RegsCRTC[ lastReg ] = val;
            switch( lastReg )
                {
                case 12 :
                    if ( ( tmp & 7 ) != ( val & 7 ) )
                        CalcAdrEcrCPC();

                    adrEcr = ( val & 0x30 ) >> 4;
                    break;

                case 1 :
                case 2 :
                case 6 :
                case 13 :
                    CalcAdrEcrCPC();
                    break;
                }
            }
}
