/*****************************************************************************
 *                                                                           *
 * Module : FCTED.C                                                          *
 *                                                                           *
 * Fonctions grant les instructions Z80 aprs le code OP. ED : transferts   *
 * de blocs, instructions spciales sur reg. 16 bits...                      *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>

#include  "tools.h"
#include  "regs.h"
#include  "vga.h"
#include  "gestport.h"


extern UBYTE LastInstr;

extern void ___22( void );
extern void ___2A( void );

USHORT ErrED = 0xFFFF;


extern "C"
    {
    void ADC_R16( USHORT );
    void SBC_R16( USHORT );
    };


static void ED_XX( void )
{
    ErrED = LastInstr;
}


static void ED_57( void ) /* LD A, I */
{
    RegA = RegI;
    FLAGS &= FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( RegA == 0 )
        FLAGS |= FLAG_Z;

    FLAGS |= IFF1;
}


static void ED_5F( void ) /* LD A, R */
{
    RegA = RegR;
    FLAGS &= FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( RegA == 0 )
        FLAGS |= FLAG_Z;

    FLAGS |= IFF1;
}


static void ED_47( void ) /* LD I, A */
{
    RegI = RegA;
}


static void ED_4F( void ) /* LD R, A */
{
    RegR = RegA;
}


static void ED_4B( void ) /* LD BC, ( nn ) */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegC = PEEK8( ofs.Word++ );
    RegB = PEEK8( ofs.Word );
}


static void ED_5B( void ) /* LD DE, ( nn ) */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegE = PEEK8( ofs.Word++ );
    RegD = PEEK8( ofs.Word );
}


static void ED_7B( void ) /* LD SP, ( nn ) */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    SP.Byte.Low = PEEK8( ofs.Word++ );
    SP.Byte.High = PEEK8( ofs.Word );
}


static void ED_43( void ) /* LD ( nn ), BC */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, RegC );
    POKE8( ofs.Word, RegB );
}


static void ED_53( void ) /* LD ( nn ), DE */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, RegE );
    POKE8( ofs.Word, RegD );
}


static void ED_73( void ) /* LD ( nn ), SP */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, SP.Byte.Low );
    POKE8( ofs.Word, SP.Byte.High );
}


static void ED_A0( void ) /* LDI */
{
    POKE8( RegDE++, PEEK8( RegHL++ ) );
    FLAGS &= N_FLAG_H & N_FLAG_V & N_FLAG_N;
    if ( --RegBC )
        FLAGS |= FLAG_V;
}


static void ED_B0( void ) /* LDIR */
{
    while( RegBC )
        {
        POKE8( RegDE++, PEEK8( RegHL++ ) );
        RegBC--;
        }
    FLAGS &= N_FLAG_H & N_FLAG_V & N_FLAG_N;
}


static void ED_A8( void ) /* LDD */
{
    POKE8( RegDE--, PEEK8( RegHL-- ) );
    FLAGS &= N_FLAG_H & N_FLAG_V & N_FLAG_N;
    if ( --RegBC )
        FLAGS |= FLAG_V;
}


static void ED_B8( void ) /* LDDR */
{
    while( RegBC )
        {
        POKE8( RegDE--, PEEK8( RegHL-- ) );
        RegBC--;
        }
    FLAGS &= N_FLAG_H & N_FLAG_V & N_FLAG_N;
}


static void ED_A1( void ) /* CPI */
{
    FLAGS &= N_FLAG_Z & N_FLAG_V;

    if ( RegA == PEEK8( RegHL++ ) )
        FLAGS |= FLAG_Z;

    if ( --RegBC )
        FLAGS |= FLAG_V;

    FLAGS |= FLAG_N;
}


static void ED_B1( void ) /* CPIR */
{
    FLAGS &= N_FLAG_Z & N_FLAG_V;

    while( ( RegA != PEEK8( RegHL++ ) ) && ( --RegBC != 0 ) )
         ;
    FLAGS |= FLAG_N;

    if ( RegA == PEEK8( RegHL - 1 ) )
        FLAGS |= FLAG_Z;

    if ( RegBC )
        FLAGS |= FLAG_V;
}


static void ED_A9( void ) /* CPD */
{
    FLAGS &= N_FLAG_Z & N_FLAG_V;

    if ( RegA == PEEK8( RegHL-- ) )
        FLAGS |= FLAG_Z;

    if ( --RegBC )
        FLAGS |= FLAG_V;

    FLAGS |= FLAG_N;
}


static void ED_B9( void ) /* CPDR */
{
    FLAGS &= N_FLAG_Z & N_FLAG_V;

    while( ( RegA != PEEK8( RegHL-- ) ) && ( --RegBC != 0 ) )
         ;
    FLAGS |= FLAG_N;

    if ( RegA == PEEK8( RegHL - 1 ) )
        FLAGS |= FLAG_Z;

    if ( RegBC )
        FLAGS |= FLAG_V;
    while( ( RegA != PEEK8( RegHL-- ) ) && ( --RegBC != 0 ) )
         ;
    FLAGS |= FLAG_N;
    if ( RegBC )
        FLAGS |= FLAG_V;
}


static void ED_44( void ) /* NEG */
{
    RegA = -RegA;
    FLAGS = FLAG_N;

    if ( ! RegA )
        FLAGS |= FLAG_Z;
    else
        FLAGS |= FLAG_C;

    if ( RegA == FLAG_S )
        FLAGS |= FLAG_V;

    if ( RegA & FLAG_S )
        FLAGS |= FLAG_S;
}


static void ED_46( void ) /* IM 0 */
{
    ED_XX();
}


static void ED_56( void ) /* IM 1 */
{
}


static void ED_5E( void ) /* IM 2 */
{
    ED_XX();
}


static void ED_4A( void ) /* ADC HL, BC */
{
    ADC_R16( RegBC );
}


static void ED_5A( void ) /* ADC HL, DE */
{
    ADC_R16( RegDE );
}


static void ED_6A( void ) /* ADC HL, HL */
{
    ADC_R16( RegHL );
}


static void ED_7A( void ) /* ADC HL, SP */
{
    ADC_R16( RegSP );
}


static void ED_42( void ) /* SBC HL, BC */
{
    SBC_R16( RegBC );
}


static void ED_52( void ) /* SBC HL, DE */
{
    SBC_R16( RegDE );
}


static void ED_62( void ) /* SBC HL, HL */
{
    SBC_R16( RegHL );
}


static void ED_72( void ) /* SBC HL, SP */
{
    SBC_R16( RegSP );
}


static void ED_6F( void ) /* RLD */
{
    UBYTE a = RegA;
    UBYTE hl = PEEK8( RegHL );

    RegA = ( a & 0xF0 ) | ( hl >> 4 );
    POKE8( RegHL, ( hl << 4 ) | ( a & 0xF ) );

    FLAGS &= FLAG_C;

    if ( ! RegA )
        FLAGS |= FLAG_Z;

    FLAGS |= ( RegA & FLAG_S ) | Tab_Parite[ RegA ];
}


static void ED_67( void ) /* RRD */
{
    UBYTE a = RegA;
    UBYTE hl = PEEK8( RegHL );

    RegA = ( a & 0xF0 ) | ( hl & 0xF );
    POKE8( RegHL, ( hl >> 4 ) | ( a << 4 ) );

    FLAGS &= FLAG_C;

    if ( ! RegA )
        FLAGS |= FLAG_Z;

    FLAGS |= ( RegA & FLAG_S ) | Tab_Parite[ RegA ];
}


static void ED_4D( void ) /* RETI */
{
    PC.Byte.Low = PEEK8( RegSP++ );
    PC.Byte.High = PEEK8( RegSP++ );
    ED_XX();
}


static void ED_45( void ) /* RETN */
{
    PC.Byte.Low = PEEK8( RegSP++ );
    PC.Byte.High = PEEK8( RegSP++ );
    ED_XX();
}


static void ED_40( void ) /* IN B, ( C ) */
{
    RegB = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegB ] | ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
}


static void ED_48( void ) /* IN C, ( C ) */
{
    RegC = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegC ] | ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
}


static void ED_50( void ) /* IN D, ( C ) */
{
    RegD = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegD ] | ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
}


static void ED_58( void ) /* IN E, ( C ) */
{
    RegE = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegE ] | ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
}


static void ED_60( void ) /* IN H, ( C ) */
{
    RegH = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegH ] | ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
}


static void ED_68( void ) /* IN L, ( C ) */
{
    RegL = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegL ] | ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
}


static void ED_78( void ) /* IN A, ( C ) */
{
    RegA = ReadPort( RegBC );
    FLAGS &= FLAG_C;
    FLAGS |= Tab_Parite[ RegA ] | ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
}


static void ED_A2( void ) /* INI */
{
}


static void ED_B2( void ) /* INIR */
{
}


static void ED_AA( void ) /* IND */
{
}


static void ED_BA( void ) /* INDR */
{
}


static void ED_41( void ) /* OUT ( C ), B */
{
    WritePort( RegBC, RegB );
}


static void ED_49( void ) /* OUT ( C ), C */
{
    WritePort( RegBC, RegC );
}


static void ED_51( void ) /* OUT ( C ), D */
{
    WritePort( RegBC, RegD );
}


static void ED_59( void ) /* OUT ( C ), E */
{
    WritePort( RegBC, RegE );
}


static void ED_61( void ) /* OUT ( C ), H */
{
    WritePort( RegBC, RegH );
}


static void ED_69( void ) /* OUT ( C ), L */
{
    WritePort( RegBC, RegL );
}


static void ED_79( void ) /* OUT ( C ), A */
{
    WritePort( RegBC, RegA );
}


static void ED_A3( void ) /* OUTI */
{

    RegB--;
    WritePort( RegBC, PEEK8( RegHL++ ) );

    if ( RegB )
        FLAGS &= N_FLAG_Z;
    else
        FLAGS |= FLAG_Z;
}


static void ED_B3( void ) /* OTIR */
{
    ED_XX();
}


static void ED_AB( void ) /* OUTD */
{
    RegB--;
    WritePort( RegBC, PEEK8( RegHL-- ) );

    if ( RegB )
        FLAGS &= N_FLAG_Z;
    else
        FLAGS |= FLAG_Z;
}


static void ED_BB( void ) /* OTDR */
{
    ED_XX();
}


pfct tabED[ 256 ] =
    {
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 00
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 08
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 10
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 18
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 20
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 28
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 30
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 38
    ED_40, ED_41, ED_42, ED_43, ED_44, ED_45, ED_46, ED_47, // 40
    ED_48, ED_49, ED_4A, ED_4B, ED_XX, ED_4D, ED_XX, ED_4F, // 48
    ED_50, ED_51, ED_52, ED_53, ED_XX, ED_XX, ED_56, ED_57, // 50
    ED_58, ED_59, ED_5A, ED_5B, ED_XX, ED_XX, ED_5E, ED_5F, // 58
    ED_60, ED_61, ED_62, ___22, ED_XX, ED_XX, ED_XX, ED_67, // 60
    ED_68, ED_69, ED_6A, ___2A, ED_XX, ED_XX, ED_XX, ED_6F, // 68
    ED_XX, ED_XX, ED_72, ED_73, ED_XX, ED_XX, ED_XX, ED_XX, // 70
    ED_78, ED_79, ED_7A, ED_7B, ED_XX, ED_XX, ED_XX, ED_XX, // 78
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 80
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 88
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 90
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // 98
    ED_A0, ED_A1, ED_A2, ED_A3, ED_XX, ED_XX, ED_XX, ED_XX, // A0
    ED_A8, ED_A9, ED_AA, ED_AB, ED_XX, ED_XX, ED_XX, ED_XX, // A8
    ED_B0, ED_B1, ED_B2, ED_B3, ED_XX, ED_XX, ED_XX, ED_XX, // B0
    ED_B8, ED_B9, ED_BA, ED_BB, ED_XX, ED_XX, ED_XX, ED_XX, // B8
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // C0
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // C8
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // D0
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // D8
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // E0
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // E8
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, // F0
    ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX, ED_XX  // F8
    };
