/*****************************************************************************
 *                                                                           *
 * Module : MAIN.C                                                           *
 *                                                                           *
 * Module principal, gestion du noyau du Z80, des interruptions...           *
 *                                                                           *
 *****************************************************************************/


#include  <stdio.h>
#include  <fcntl.h>
#include  <bios.h>
#include  <dos.h>
#include  <mem.h>
#include  <io.h>

#include  "fctfirst.h"
#include  "filebas.h"
#include  "debug.h"
#include  "tools.h"
#include  "regs.h"
#include  "vga.h"
#include  "ppi.h"
#include  "upd.h"

FILE * out;


#define AFFICHE            1
#define EXECUTE            2


extern pfct tabinstr[];

extern UBYTE TabCoul[];

extern UBYTE * segAdrCPC;

extern UBYTE IFF1;          // Interrupt enable Flip Flop

extern USHORT ErrED, ErrIX, ErrIY;

USHORT finMain = 1;
UBYTE DmdChgFic = 0;
UBYTE Reset = 0;
UBYTE VBL = 0;

volatile int IRQ = 0;

//#ifdef DEBUG
//USHORT volatile FreqInt = 65535U;
//#else
USHORT volatile FreqInt = 2838;
//#endif

#ifdef DEBUG
extern char * SetChaine( USHORT adr );
#endif

static void interrupt ( * oldhandler )( __CPPARGS );


extern void interrupt NewInt08( __CPPARGS );


static void InstalleInt08( void )
{
    oldhandler = getvect( 8 );
    disable();
    while( ! ( inportb( 0x3DA ) & 8 ) )
        ;
    setvect( 8, NewInt08 );
    enable();
}


static void RestoreInt08( void )
{
    SetFreq( 0xFFFFU );
    setvect( 8, oldhandler );
}

static void TraiteIRQ( void )
{
    IRQ = 0;
    if ( IFF1 ) // EI ?
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        RegPC = 0x38;
        }
}


//
// Noyau: Excution d'une instruction Z80
//
static void ExecZ80( void )
{
    do
        {
        do
            {
            if ( IRQ )  // Interruption ?
                TraiteIRQ();
#ifdef DEBUG
            if ( IR.Byte.Low == 0 )
                AfficheTexte( SetChaine( RegPC ) );
#endif
            tabinstr[ PEEK8( RegPC++ ) ]();
            IR.Byte.Low++;
            }
        while( ! finMain );

        if ( Reset )
            {
            WriteVGA( 0x89 );
            finMain = 0;
            RegPC = 0;
            IFF1 = 0;
            Reset = 0;
            }
        if ( DmdChgFic ) // Changement de fichier disquette
            {
            finMain = 0;
            RestoreIntClavierPPI();
            char * p = GetFile();
            if ( p )
                {
                EndUPD();
                InitUPD( p );
                }
            InstalleIntClavierPPI();
            DmdChgFic = 0;
            }
        }
    while( ! finMain );
}


#ifdef DEBUG
static char * Hex( UBYTE val )
{
    static char * s = "0123456789ABCDEF";
    static char * r = "??";

    r[ 0 ] = s[ val >> 4 ];
    r[ 1 ] = s[ val & 15 ];
    return r;
}
#endif


void main( int argc, char **argv )
{
    if ( argc == 2 )
        InitUPD( argv[ 1 ] );
    else
        InitUPD( "DISC.DSK" );

        if ( AllocMemCPC() )
            {
            if ( GetEcran() )
                {
                InstalleInt08();
                InstalleIntClavierPPI();
                ExecZ80();
                RestoreIntClavierPPI();
                RestoreInt08();
#ifdef DEBUG
                USHORT c;

                do
                    {
                    AfficheTexte( SetChaine( RegPC++ ) );
                    c = bioskey( 0 ) & 0xFF;
                    }
                while( c != 0x1B );
#endif
                CloseEcran();
                }
            FreeMemCPC();
            }
    EndUPD();
#ifdef SOUND
    nosound();
#endif
#ifdef DEBUG
    printf( "FreqInt = %d\n", FreqInt );
    if ( ErrED != 0xFFFF )
        {
        PutString( 1, 7, 15, "ED" );
        PutString( 4, 7, 15, Hex( ErrED ) );
        }
    if ( ErrIX != 0xFFFF )
        {
        PutString( 1, 8, 15, "DD" );
        PutString( 4, 8, 15, Hex( ErrIX ) );
        }
    if ( ErrIY != 0xFFFF )
        {
        PutString( 1, 9, 15, "FD" );
        PutString( 4, 9, 15, Hex( ErrIY ) );
        }
#endif
}
