#ifndef REGS_H
#define REGS_H


#include  <exec/types.h>


#define   FLAG_C       0x01
#define   FLAG_N       0x02
#define   FLAG_V       0x04
#define   FLAG_H       0x10
#define   FLAG_Z       0x40
#define   FLAG_S       0x80

#define   N_FLAG_C     0xFE
#define   N_FLAG_N     0xFD
#define   N_FLAG_V     0xFB
#define   N_FLAG_H     0xEF
#define   N_FLAG_Z     0xBF
#define   N_FLAG_S     0x7F


typedef struct
    {
    UBYTE Low;
    UBYTE High;
    } byteReg;


typedef union
    {
    USHORT        Word;
    byteReg       Byte;
    } Registre;


extern Registre AF, BC, DE, HL, _AF, _BC, _DE, _HL, IX, IY, IR, SP, PC;

extern UBYTE IFF1, IFF2;

#define     RegAF           AF.Word
#define     RegBC           BC.Word
#define     RegDE           DE.Word
#define     RegHL           HL.Word

#define     Reg_AF          _AF.Word
#define     Reg_BC          _BC.Word
#define     Reg_DE          _DE.Word
#define     Reg_HL          _HL.Word

#define     RegSP           SP.Word
#define     RegPC           PC.Word
#define     RegIX           IX.Word
#define     RegIY           IY.Word
#define     RegIR           IR.Word

#define     RegA            AF.Byte.High
#define     FLAGS           AF.Byte.Low
#define     RegB            BC.Byte.High
#define     RegC            BC.Byte.Low
#define     RegD            DE.Byte.High
#define     RegE            DE.Byte.Low
#define     RegH            HL.Byte.High
#define     RegL            HL.Byte.Low
#define     RegI            IR.Byte.High
#define     RegR            IR.Byte.Low
#define     RegIXH          IX.Byte.High
#define     RegIXL          IX.Byte.Low
#define     RegIYH          IY.Byte.High
#define     RegIYL          IY.Byte.Low


#endif
