#include  <stdio.h>


typedef unsigned char UBYTE;
typedef unsigned int  USHORT;


typedef struct
    {
    UBYTE  User;
    char   Nom[ 11 ];
    UBYTE  Vide1[ 6 ];
    UBYTE  Type;
    UBYTE  Vide2[ 2 ];
    USHORT Debut;
    UBYTE  Vide3;
    USHORT Longueur;
    USHORT Exec;
    UBYTE  Vide4[ 36 ];
    USHORT CopieLong;
    UBYTE  Vide5;
    USHORT Somme;
    UBYTE  Vide6[ 59 ];
    } StHeaderCPC;



USHORT SommeControle( StHeaderCPC * h )
{
    unsigned char * p = ( unsigned char * )h;
    USHORT total = 0;
    USHORT calc = 0;

    for ( USHORT i = 0; i < 67; i++ )
        total += * p++;

    calc = * p++;
    calc += ( * p++ ) << 8;

    return( calc == total );
}


void main( int argc, char * argv[] )
{
    if ( argc == 2 )
        {
        FILE * fp = fopen( argv[ 1 ], "rb" );
        if ( fp )
            {
            StHeaderCPC h;
            fread( &h, sizeof( h ), 1, fp );
            fclose( fp );
            if ( SommeControle( &h ) )
                {
                printf( "User %d, %11s\n", h.User, h.Nom );
                printf( "\tType      = %s\n", h.Type == 2 ? "BINAIRE" : "BASIC" );
                printf( "\tDebut     = $%04X\n", h.Debut );
                printf( "\tLongueur  = $%04X\n", h.Longueur );
                printf( "\tExecution = $%04X\n", h.Exec );
                }
            }
        }
}
