/*
    Optimise les fichiers disquettes CPC
*/


#include  <typesvar.h>
#include  <stdio.h>
#include  <string.h>


#define SECTSIZE   512
#define NBSECT     9

#define NOM_TMP    "$$TEMP$$.$$$"


typedef UCHAR ( * pfctUPD )( UCHAR );


typedef struct
    {
    UCHAR C;
    UCHAR H;
    UCHAR R;
    UCHAR N;
    UCHAR datas[ SECTSIZE ];
    } StSect;


typedef struct
    {
    StSect Sect[ NBSECT ];
    } StTrack;


typedef struct
    {
    UCHAR User;
    UCHAR Nom[ 8 ];
    UCHAR Ext[ 3 ];
    UCHAR NumPage;
    UCHAR Unused[ 2 ];
    UCHAR NbPages;
    UCHAR Blocks[ 16 ];
    } StDirEntry;


static FILE * fp = 0;


static StTrack CurrTrackDatas;


static void ReadTrack( UCHAR newTrack, StTrack * CurrTrackDatas )
{
    if ( fp )
        {
        fseek( fp, ( ULONG )newTrack * sizeof( * CurrTrackDatas ), SEEK_SET );
        fread( CurrTrackDatas, sizeof( * CurrTrackDatas ), 1, fp );
        }
}


static USHORT GetMaxTrack( void )
{
    static StTrack Track0;
    static StDirEntry Dir;
    USHORT i, j, s, l, bMax = 0;

    ReadTrack( 0, &Track0 );
    for ( s = 0; s < 4; s++ )
        for ( i = 0; i < 16; i++ )
            {
            memcpy( &Dir
                  , &Track0.Sect[ s ].datas[ i * sizeof( Dir ) ]
                  , sizeof( Dir )
                  );
            l = ( Dir.NbPages + 7 ) >> 3;
            if ( Dir.User != 0xE5 )
                for ( j = 0; j < l; j++ )
                    if ( bMax < Dir.Blocks[ j ] )
                        bMax = Dir.Blocks[ j ];
            }
    return ( bMax << 1 ) / 9;
}


void main( int argc, char ** argv )
{
    FILE * fout;
    USHORT Track, LastTrack;
    PCHAR nom;

    if ( argc == 2 )
        {
        nom = * ++argv;
        fp = fopen( nom, "rb" );
        LastTrack = GetMaxTrack();
        //
        // Revient au dbut du fichier
        //
        fseek( fp, 0, SEEK_SET );

        fout = fopen( NOM_TMP, "wb" );
        for ( Track = 0; Track <= LastTrack; Track++ )
            {
            fread( &CurrTrackDatas, sizeof( CurrTrackDatas ), 1, fp );
            fwrite( &CurrTrackDatas, sizeof( CurrTrackDatas ), 1, fout );
            }
        fclose( fp );
        fclose( fout );
        remove( nom );
        rename( NOM_TMP, nom );
        }
}
