/*****************************************************************************
 *                                                                           *
 * Module : FCTFIRST.C                                                       *
 *                                                                           *
 * Fonctions grant les instructions Z80 dites "normales".                   *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>

#include  "tools.h"
#include  "regs.h"
#include  "vga.h"
#include  "gestport.h"


extern pfct tabCB[];
extern pfct tabED[];
extern pfct tabIX[];
extern pfct tabIY[];

extern volatile int IRQ;


UBYTE LastInstr;


static void ___40( void ) /* LD B,B */
{
}


static void ___41( void ) /* LD B,C */
{
    RegB = RegC;
}


static void ___42( void ) /* LD B,D */
{
    RegB = RegD;
}


static void ___43( void ) /* LD B,E */
{
    RegB = RegE;
}


static void ___44( void ) /* LD B,H */
{
    RegB = RegH;
}


static void ___45( void ) /* LD B,L */
{
    RegB = RegL;
}


static void ___47( void ) /* LD B,A */
{
    RegB = RegA;
}


static void ___48( void ) /* LD C,B */
{
    RegC = RegB;
}


static void ___49( void ) /* LD C,C */
{
}


static void ___4A( void ) /* LD C,D */
{
    RegC = RegD;
}


static void ___4B( void ) /* LD C,E */
{
    RegC = RegE;
}


static void ___4C( void ) /* LD C,H */
{
    RegC = RegH;
}


static void ___4D( void ) /* LD C,L */
{
    RegC = RegL;
}


static void ___4F( void ) /* LD C,A */
{
    RegC = RegA;
}


static void ___50( void ) /* LD D,B */
{
    RegD = RegB;
}


static void ___51( void ) /* LD D,C */
{
    RegD = RegC;
}


static void ___52( void ) /* LD D,D */
{
}


static void ___53( void ) /* LD D,E */
{
    RegD = RegE;
}


static void ___54( void ) /* LD D,H */
{
    RegD = RegH;
}


static void ___55( void ) /* LD D,L */
{
    RegD = RegL;
}


static void ___57( void ) /* LD D,A */
{
    RegD = RegA;
}


static void ___58( void ) /* LD E,B */
{
    RegE = RegB;
}


static void ___59( void ) /* LD E,C */
{
    RegE = RegC;
}


static void ___5A( void ) /* LD E,D */
{
    RegE = RegD;
}


static void ___5B( void ) /* LD E,E */
{
}


static void ___5C( void ) /* LD E,H */
{
    RegE = RegH;
}


static void ___5D( void ) /* LD E,L */
{
    RegE = RegL;
}


static void ___5F( void ) /* LD E,A */
{
    RegE = RegA;
}


static void ___60( void ) /* LD H,B */
{
    RegH = RegB;
}


static void ___61( void ) /* LD H,C */
{
    RegH = RegC;
}


static void ___62( void ) /* LD H,D */
{
    RegH = RegD;
}


static void ___63( void ) /* LD H,E */
{
    RegH = RegE;
}


static void ___64( void ) /* LD H,H */
{
}


static void ___65( void ) /* LD H,L */
{
    RegH = RegL;
}


static void ___67( void ) /* LD H,A */
{
    RegH = RegA;
}


static void ___68( void ) /* LD L,B */
{
    RegL = RegB;
}


static void ___69( void ) /* LD L,C */
{
    RegL = RegC;
}


static void ___6A( void ) /* LD L,D */
{
    RegL = RegD;
}


static void ___6B( void ) /* LD L,E */
{
    RegL = RegE;
}


static void ___6C( void ) /* LD L,H */
{
    RegL = RegH;
}


static void ___6D( void ) /* LD L,L */
{
}


static void ___6F( void ) /* LD L,A */
{
    RegL = RegA;
}


static void ___78( void ) /* LD A,B */
{
    RegA = RegB;
}


static void ___79( void ) /* LD A,C */
{
    RegA = RegC ;
}


static void ___7A( void ) /* LD A,D */
{
    RegA = RegD;
}


static void ___7B( void ) /* LD A,E */
{
    RegA = RegE;
}


static void ___7C( void ) /* LD A,H */
{
    RegA = RegH;
}


static void ___7D( void ) /* LD A,L */
{
    RegA = RegL;
}


static void ___7F( void ) /* LD A,A */
{
}


static void ___06( void ) /* LD B, n */
{
    RegB = PEEK8( RegPC++ );
}


static void ___0E( void ) /* LD C, n */
{
    RegC = PEEK8( RegPC++ );
}


static void ___16( void ) /* LD D, n */
{
    RegD = PEEK8( RegPC++ );
}


static void ___1E( void ) /* LD E, n */
{
    RegE = PEEK8( RegPC++ );
}


static void ___26( void ) /* LD H, n */
{
    RegH = PEEK8( RegPC++ );
}


static void ___2E( void ) /* LD L, n */
{
    RegL = PEEK8( RegPC++ );
}


static void ___3E( void ) /* LD A, n */
{
    RegA = PEEK8( RegPC++ );
}


static void ___46( void ) /* LD B, ( HL ) */
{
    RegB = PEEK8( RegHL );
}


static void ___4E( void ) /* LD C, ( HL ) */
{
    RegC = PEEK8( RegHL );
}


static void ___56( void ) /* LD D, ( HL ) */
{
    RegD = PEEK8( RegHL );
}


static void ___5E( void ) /* LD E, ( HL ) */
{
    RegE = PEEK8( RegHL );
}


static void ___66( void ) /* LD H, ( HL ) */
{
    RegH = PEEK8( RegHL );
}


static void ___6E( void ) /* LD L, ( HL ) */
{
    RegL = PEEK8( RegHL );
}


static void ___7E( void ) /* LD A, ( HL ) */
{
    RegA = PEEK8( RegHL );
}


static void ___70( void ) /* LD ( HL ), B */
{
    POKE8( RegHL, RegB );
}


static void ___71( void ) /* LD ( HL ), C */
{
    POKE8( RegHL, RegC );
}


static void ___72( void ) /* LD ( HL ), D */
{
    POKE8( RegHL, RegD );
}


static void ___73( void ) /* LD ( HL ), E */
{
    POKE8( RegHL, RegE );
}


static void ___74( void ) /* LD ( HL ), H */
{
    POKE8( RegHL, RegH );
}


static void ___75( void ) /* LD ( HL ), L */
{
    POKE8( RegHL, RegL );
}


static void ___77( void ) /* LD ( HL ), A */
{
    POKE8( RegHL, RegA );
}


static void ___36( void ) /* LD ( HL ), n */
{
    POKE8( RegHL, PEEK8( RegPC++ ) );
}


static void ___0A( void ) /* LD A, ( BC ) */
{
    RegA = PEEK8( RegBC );
}


static void ___1A( void ) /* LD A, ( DE ) */
{
    RegA = PEEK8( RegDE );
}


static void ___3A( void ) /* LD A, ( nn ) */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegA = PEEK8( ofs.Word );
}


static void ___02( void ) /* LD ( BC ), A */
{
    POKE8( RegBC, RegA );
}


static void ___12( void ) /* LD ( DE ), A */
{
    POKE8( RegDE, RegA );
}


static void ___32( void ) /* LD ( nn ), A */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word, RegA );
}


static void ___01( void ) /* LD BC, nn */
{
    RegC = PEEK8( RegPC++ );
    RegB = PEEK8( RegPC++ );
}


static void ___11( void ) /* LD DE, nn */
{
    RegE = PEEK8( RegPC++ );
    RegD = PEEK8( RegPC++ );
}


static void ___21( void ) /* LD HL, nn */
{
    RegL = PEEK8( RegPC++ );
    RegH = PEEK8( RegPC++ );
}


static void ___31( void ) /* LD SP, nn */
{
    SP.Byte.Low = PEEK8( RegPC++ );
    SP.Byte.High = PEEK8( RegPC++ );
}


void ___2A( void ) /* LD HL, ( nn ) */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegL = PEEK8( ofs.Word++ );
    RegH = PEEK8( ofs.Word );
}


void ___22( void ) /* LD ( nn ), HL */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, RegL );
    POKE8( ofs.Word, RegH );
}


static void ___F9( void ) /* LD SP, HL */
{
    SP = HL;
}


static void ___C5( void ) /* PUSH BC */
{
    POKE8( --RegSP, RegB );
    POKE8( --RegSP, RegC );
}


static void ___D5( void ) /* PUSH DE */
{
    POKE8( --RegSP, RegD );
    POKE8( --RegSP, RegE );
}


static void ___E5( void ) /* PUSH HL */
{
    POKE8( --RegSP, RegH );
    POKE8( --RegSP, RegL );
}


static void ___F5( void ) /* PUSH AF */
{
    POKE8( --RegSP, RegA );
    POKE8( --RegSP, FLAGS );
}


static void ___C1( void ) /* POP BC */
{
    RegC = PEEK8( RegSP++ );
    RegB = PEEK8( RegSP++ );
}


static void ___D1( void ) /* POP DE */
{
    RegE = PEEK8( RegSP++ );
    RegD = PEEK8( RegSP++ );
}


static void ___E1( void ) /* POP HL */
{
    RegL = PEEK8( RegSP++ );
    RegH = PEEK8( RegSP++ );
}


static void ___F1( void ) /* POP AF */
{
    FLAGS = PEEK8( RegSP++ );
    RegA = PEEK8( RegSP++ );
}


static void ___EB( void ) /* EX DE, HL */
{
    register USHORT tmp = RegDE;
    DE = HL;
    RegHL = tmp;
}


static void ___08( void ) /* EX AF, AF' */
{
    register USHORT tmp = RegAF;
    AF = _AF;
    Reg_AF = tmp;
}


static void ___D9( void ) /* EXX */
{
    register USHORT tmp = RegBC;
    BC = _BC;
    Reg_BC = tmp;
    tmp = RegDE;
    DE = _DE;
    Reg_DE = tmp;
    tmp = RegHL;
    HL = _HL;
    Reg_HL = tmp;
}


static void ___E3( void ) /* EX ( SP ), HL */
{
    UBYTE a = PEEK8( RegSP );
    UBYTE b = PEEK8( ++RegSP );
    POKE8( RegSP, RegH );
    POKE8( --RegSP, RegL );
    RegL = a;
    RegH = b;
}


static void ___80( void ) /* ADD A, B */
{
    ADD_R8( RegB );
}


static void ___81( void ) /* ADD A, C */
{
    ADD_R8( RegC );
}


static void ___82( void ) /* ADD A, D */
{
    ADD_R8( RegD );
}


static void ___83( void ) /* ADD A, E */
{
    ADD_R8( RegE );
}


static void ___84( void ) /* ADD A, H */
{
    ADD_R8( RegH );
}


static void ___85( void ) /* ADD A, L */
{
    ADD_R8( RegL );
}


static void ___87( void ) /* ADD A, A */
{
    ADD_R8( RegA );
}


static void ___C6( void ) /* ADD A, n */
{
    ADD_R8( PEEK8( RegPC++ ) );
}


static void ___86( void ) /* ADD A, ( HL ) */
{
    ADD_R8( PEEK8( RegHL ) );
}


static void ___88( void ) /* ADC A, B */
{
    ADC_R8( RegB );
}


static void ___89( void ) /* ADC A, C */
{
    ADC_R8( RegC );
}


static void ___8A( void ) /* ADC A, D */
{
    ADC_R8( RegD );
}


static void ___8B( void ) /* ADC A, E */
{
    ADC_R8( RegE );
}


static void ___8C( void ) /* ADC A, H */
{
    ADC_R8( RegH );
}


static void ___8D( void ) /* ADC A, L */
{
    ADC_R8( RegL );
}


static void ___8E( void ) /* ADC A, (HL) */
{
    ADC_R8( PEEK8( RegHL ) );
}


static void ___8F( void ) /* ADC A, A */
{
    ADC_R8( RegA );
}


static void ___CE( void ) /* ADC A, nn */
{
    ADC_R8( PEEK8( RegPC++ ) );
}


static void ___90( void ) /* SUB B */
{
    SUB_R8( RegB );
}


static void ___91( void ) /* SUB C */
{
    SUB_R8( RegC );
}


static void ___92( void ) /* SUB D */
{
    SUB_R8( RegD );
}


static void ___93( void ) /* SUB E */
{
    SUB_R8( RegE );
}


static void ___94( void ) /* SUB H */
{
    SUB_R8( RegH );
}


static void ___95( void ) /* SUB L */
{
    SUB_R8( RegL );
}


static void ___96( void ) /* SUB (HL) */
{
    SUB_R8( PEEK8( RegHL ) );
}


static void ___97( void ) /* SUB A */
{
    SUB_R8( RegA );
}


static void ___D6( void ) /* SUB N */
{
    SUB_R8( PEEK8( RegPC++ ) );
}


static void ___98( void ) /* SBC A, B */
{
    SBC_R8( RegB );
}


static void ___99( void ) /* SBC A, C */
{
    SBC_R8( RegC );
}


static void ___9A( void ) /* SBC A, D */
{
    SBC_R8( RegD );
}


static void ___9B( void ) /* SBC A, E */
{
    SBC_R8( RegE );
}


static void ___9C( void ) /* SBC A, H */
{
    SBC_R8( RegH );
}


static void ___9D( void ) /* SBC A, L */
{
    SBC_R8( RegL );
}


static void ___9E( void ) /* SBC A, (HL) */
{
    SBC_R8( PEEK8( RegHL ) );
}


static void ___9F( void ) /* SBC A, A */
{
    SBC_R8( RegA );
}


static void ___DE( void ) /* SBC A, N */
{
    SBC_R8( PEEK8( RegPC++ ) );
}


static void ___A0( void ) /* AND B */
{
    RegA &= RegB;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A1( void ) /* AND C */
{
    RegA &= RegC;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A2( void ) /* AND D */
{
    RegA &= RegD;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A3( void ) /* AND E */
{
    RegA &= RegE;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A4( void ) /* AND H */
{
    RegA &= RegH;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A5( void ) /* AND L */
{
    RegA &= RegL;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A6( void ) /* AND (HL) */
{
    RegA &= PEEK8( RegHL );
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A7( void ) /* AND A */
{
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___E6( void ) /* AND N */
{
    RegA &= PEEK8( RegPC++ );
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A8( void ) /* XOR B */
{
    RegA ^= RegB;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___A9( void ) /* XOR C */
{
    RegA ^= RegC;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___AA( void ) /* XOR D */
{
    RegA ^= RegD;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___AB( void ) /* XOR E */
{
    RegA ^= RegE;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___AC( void ) /* XOR H */
{
    RegA ^= RegH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___AD( void ) /* XOR L */
{
    RegA ^= RegL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___AE( void ) /* XOR (HL) */
{
    RegA ^= PEEK8( RegHL );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___AF( void ) /* XOR A */
{
    RegA = 0;
    FLAGS = FLAG_Z | FLAG_V;
}


static void ___EE( void ) /* XOR N */
{
    RegA ^= PEEK8( RegPC++ );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B0( void ) /* OR B */
{
    RegA |= RegB;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B1( void ) /* OR C */
{
    RegA |= RegC;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B2( void ) /* OR D */
{
    RegA |= RegD;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void ___B3( void ) /* OR E */
{
    RegA |= RegE;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B4( void ) /* OR H */
{
    RegA |= RegH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B5( void ) /* OR L */
{
    RegA |= RegL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B6( void ) /* OR (HL) */
{
    RegA |= PEEK8( RegHL );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B7( void ) /* OR A */
{
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___F6( void ) /* OR N */
{
    RegA |= PEEK8( RegPC++ );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void ___B8( void ) /* CP B */
{
    CP_R8( RegB );
}


static void ___B9( void ) /* CP C */
{
    CP_R8( RegC );
}


static void ___BA( void ) /* CP D */
{
    CP_R8( RegD );
}


static void ___BB( void ) /* CP E */
{
    CP_R8( RegE );
}


static void ___BC( void ) /* CP H */
{
    CP_R8( RegH );
}


static void ___BD( void ) /* CP L */
{
    CP_R8( RegL );
}


static void ___BE( void ) /* CP (HL) */
{
    CP_R8( PEEK8( RegHL ) );
}


static void ___BF( void ) /* CP A */
{
    CP_R8( RegA );
}


static void ___FE( void ) /* CP nn */
{
    CP_R8( PEEK8( RegPC++ ) );
}


static void ___04( void ) /* INC B */
{
    FLAG_INC( ++RegB );
}


static void ___0C( void ) /* INC C */
{
    FLAG_INC( ++RegC );
}


static void ___14( void ) /* INC D */
{
    FLAG_INC( ++RegD );
}


static void ___1C( void ) /* INC E */
{
    FLAG_INC( ++RegE );
}


static void ___24( void ) /* INC H */
{
    FLAG_INC( ++RegH );
}


static void ___2C( void ) /* INC L */
{
    FLAG_INC( ++RegL );
}


static void ___3C( void ) /* INC A */
{
    FLAG_INC( ++RegA );
}


static void ___34( void ) /* INC ( HL ) */
{
    UBYTE r = PEEK8( RegHL );
    FLAG_INC( ++r );
    POKE8( RegHL, r );
}


static void ___05( void ) /* DEC B */
{
    FLAG_DEC( --RegB );
}


static void ___0D( void ) /* DEC C */
{
    FLAG_DEC( --RegC );
}


static void ___15( void ) /* DEC D */
{
    FLAG_DEC( --RegD );
}


static void ___1D( void ) /* DEC E */
{
    FLAG_DEC( --RegE );
}


static void ___25( void ) /* DEC H */
{
    FLAG_DEC( --RegH );
}


static void ___2D( void ) /* DEC L */
{
    FLAG_DEC( --RegL );
}


static void ___3D( void ) /* DEC A */
{
    FLAG_DEC( --RegA );
}


static void ___35( void ) /* DEC ( HL ) */
{
    UBYTE r = PEEK8( RegHL );
    FLAG_DEC( --r );
    POKE8( RegHL, r );
}


static void ___27( void ) /* DAA */
{
    DAA();
}


static void ___2F( void ) /* CPL */
{
    RegA ^= 255;
    FLAGS |= FLAG_H | FLAG_N;
}


static void ___3F( void ) /* CCF */
{
    UBYTE tmp = ( FLAGS & FLAG_C ) << 4;
    FLAGS ^= FLAG_C;
    FLAGS &= N_FLAG_N & N_FLAG_H;
    FLAGS |= tmp;
}


static void ___37( void ) /* SCF */
{
    FLAGS |= FLAG_C;
    FLAGS &= N_FLAG_N & N_FLAG_H;
}


static void ___00( void ) /* NOP */
{
}


static void ___76( void ) /* HALT */
{
    while( ! IRQ )
        ;
}


static void ___F3( void ) /* DI */
{
    IFF1 = 0;
}


static void ___FB( void ) /* EI */
{
    IFF1 = FLAG_V;
}


static void ___09( void ) /* ADD HL, BC */
{
    register USHORT tmp = RegHL;

    RegHL += RegBC;

    if ( tmp > RegHL )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void ___19( void ) /* ADD HL, DE */
{
    register USHORT tmp = RegHL;

    RegHL += RegDE;

    if ( tmp > RegHL )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void ___29( void ) /* ADD HL, HL */
{
    register USHORT tmp = RegHL;

    RegHL += RegHL;

    if ( tmp > RegHL )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void ___39( void ) /* ADD HL, SP */
{
    register USHORT tmp = RegHL;

    RegHL += RegSP;

    if ( tmp > RegHL )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void ___03( void ) /* INC BC */
{
    RegBC++;
}


static void ___13( void ) /* INC DE */
{
    RegDE++;
}


static void ___23( void ) /* INC HL */
{
    RegHL++;
}


static void ___33( void ) /* INC SP */
{
    RegSP++;
}


static void ___0B( void ) /* DEC BC */
{
    RegBC-- ;
}


static void ___1B( void ) /* DEC DE */
{
    RegDE-- ;
}


static void ___2B( void ) /* DEC HL */
{
    RegHL-- ;
}


static void ___3B( void ) /* DEC SP */
{
    RegSP-- ;
}


static void ___07( void ) /* RLCA */
{
    FLAGS &= N_FLAG_C & N_FLAG_N & N_FLAG_H;
    FLAGS |= ( RegA >> 7 );
    RegA = ( RegA << 1 ) | ( FLAGS & FLAG_C );
}


static void ___0F( void ) /* RRCA */
{
    FLAGS &= N_FLAG_C & N_FLAG_N & N_FLAG_H;
    FLAGS |= ( RegA & FLAG_C );
    RegA = ( RegA >> 1 ) | ( FLAGS << 7 );
}


static void ___17( void ) /* RLA */
{
    USHORT i = RegA << 1;
    RegA = i | ( FLAGS & FLAG_C );
    FLAGS &= N_FLAG_C & N_FLAG_N & N_FLAG_H;
    FLAGS |= ( i >> 8 );
}


static void ___1F( void ) /* RRA */
{
    USHORT i = ( RegA >> 1 ) | ( ( FLAGS << 7 ) & 128 );
    FLAGS &= N_FLAG_C & N_FLAG_N & N_FLAG_H;
    FLAGS |= ( RegA & FLAG_C );
    RegA = i;
}


static void ___C3( void ) /* JP nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    PC = ofs;
}


static void ___C2( void ) /* JP NZ, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_Z ) )
        PC = ofs;
}


static void ___CA( void ) /* JP Z, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_Z )
        PC = ofs;
}



static void ___D2( void ) /* JP NC, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_C ) )
        PC = ofs;
}


static void ___DA( void ) /* JP C, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_C )
        PC = ofs;
}


static void ___E2( void ) /* JP PE, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_V ) )
        PC = ofs;
}


static void ___EA( void ) /* JP PO, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_V )
        PC = ofs;
}


static void ___F2( void ) /* JP P, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_S ) )
        PC = ofs;
}


static void ___FA( void ) /* JP M, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_S )
        PC = ofs;
}


static void ___18( void ) /* JR e */
{
    register char e = PEEK8( RegPC++ );
    RegPC += e;
}


static void ___38( void ) /* JR C, e */
{
    register char e = PEEK8( RegPC++ );

    if ( FLAGS & FLAG_C )
        RegPC += e;
}


static void ___30( void ) /* JR NC, e */
{
    register char e = PEEK8( RegPC++ );

    if ( ! ( FLAGS & FLAG_C ) )
        RegPC += e;
}


static void ___28( void ) /* JR Z, e */
{
    register char e = PEEK8( RegPC++ );

    if ( FLAGS & FLAG_Z )
        RegPC += e;
}


static void ___20( void ) /* JR NZ, e */
{
    register char e = PEEK8( RegPC++ );

    if ( ! ( FLAGS & FLAG_Z ) )
        RegPC += e;
}


static void ___E9( void ) /* JP ( HL ) */
{
    PC = HL;
}


static void ___10( void ) /* DJNZ e */
{
    register char e = PEEK8( RegPC++ );

    if ( --RegB != 0 )
        RegPC += e;
}


static void ___CD( void ) /* CALL nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    PC = ofs;
}


static void ___C4( void ) /* CALL NZ, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_Z ) )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___CC( void ) /* CALL Z, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_Z )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___D4( void ) /* CALL NC, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_C ) )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___DC( void ) /* CALL C, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_C )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___E4( void ) /* CALL PE, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_V ) )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___EC( void ) /* CALL PO, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_V )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___F4( void ) /* CALL P, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( ! ( FLAGS & FLAG_S ) )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___FC( void ) /* CALL M, nn */
{
    register Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    if ( FLAGS & FLAG_S )
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        PC = ofs;
        }
}


static void ___C9( void ) /* RET */
{
    PC.Byte.Low = PEEK8( RegSP++ );
    PC.Byte.High = PEEK8( RegSP++ );
}


static void ___C0( void ) /* RET NZ */
{
    if ( ! ( FLAGS & FLAG_Z ) )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___C8( void ) /* RET Z */
{
    if ( FLAGS & FLAG_Z )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___D0( void ) /* RET NC */
{
    if ( ! ( FLAGS & FLAG_C ) )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___D8( void ) /* RET C */
{
    if ( FLAGS & FLAG_C )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___E0( void ) /* RET PE */
{
    if ( ! ( FLAGS & FLAG_V ) )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___E8( void ) /* RET PO */
{
    if ( FLAGS & FLAG_V )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___F0( void ) /* RET P */
{
    if ( ! ( FLAGS & FLAG_S ) )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___F8( void ) /* RET M */
{
    if ( FLAGS & FLAG_S )
        {
        PC.Byte.Low = PEEK8( RegSP++ );
        PC.Byte.High = PEEK8( RegSP++ );
        }
}


static void ___C7( void ) /* RST 00 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x00;
}


static void ___CF( void ) /* RST 08 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x08;
}


static void ___D7( void ) /* RST 10 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x10;
}


static void ___DF( void ) /* RST 18 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x18;
}


static void ___E7( void ) /* RST 20 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x20;
}


static void ___EF( void ) /* RST 28 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x28;
}


static void ___F7( void ) /* RST 30 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x30;
}


void ___FF( void ) /* RST 38 */
{
    POKE8( --RegSP, PC.Byte.High );
    POKE8( --RegSP, PC.Byte.Low );
    RegPC = 0x38;
}


static void ___DB( void ) /* IN A, ( n ) */
{
    RegA = ReadPort( PEEK8( RegPC++ ) );
}


static void ___D3( void ) /* OUT ( n ), A */
{
    WritePort( PEEK8( RegPC++ ), RegA );
}


static void ___CB( void ) /* Special code CB */
{
    LastInstr = PEEK8( RegPC++ );
    IR.Byte.Low++;
    tabCB[ LastInstr ]();
}


static void ___ED( void ) /* Special code ED */
{
    LastInstr = PEEK8( RegPC++ );
    IR.Byte.Low++;
    tabED[ LastInstr ]();
}


static void ___DD( void ) /* Special code DD : IX */
{
    LastInstr = PEEK8( RegPC++ );
    tabIX[ LastInstr ]();
    IR.Byte.Low++;
}


static void ___FD( void ) /* Special code FD : IY */
{
    LastInstr = PEEK8( RegPC++ );
    IR.Byte.Low++;
    tabIY[ LastInstr ]();
}


pfct tabinstr[ 256 ] =
    {
    ___00, ___01, ___02, ___03, ___04, ___05, ___06, ___07,
    ___08, ___09, ___0A, ___0B, ___0C, ___0D, ___0E, ___0F,
    ___10, ___11, ___12, ___13, ___14, ___15, ___16, ___17,
    ___18, ___19, ___1A, ___1B, ___1C, ___1D, ___1E, ___1F,
    ___20, ___21, ___22, ___23, ___24, ___25, ___26, ___27,
    ___28, ___29, ___2A, ___2B, ___2C, ___2D, ___2E, ___2F,
    ___30, ___31, ___32, ___33, ___34, ___35, ___36, ___37,
    ___38, ___39, ___3A, ___3B, ___3C, ___3D, ___3E, ___3F,
    ___40, ___41, ___42, ___43, ___44, ___45, ___46, ___47,
    ___48, ___49, ___4A, ___4B, ___4C, ___4D, ___4E, ___4F,
    ___50, ___51, ___52, ___53, ___54, ___55, ___56, ___57,
    ___58, ___59, ___5A, ___5B, ___5C, ___5D, ___5E, ___5F,
    ___60, ___61, ___62, ___63, ___64, ___65, ___66, ___67,
    ___68, ___69, ___6A, ___6B, ___6C, ___6D, ___6E, ___6F,
    ___70, ___71, ___72, ___73, ___74, ___75, ___76, ___77,
    ___78, ___79, ___7A, ___7B, ___7C, ___7D, ___7E, ___7F,
    ___80, ___81, ___82, ___83, ___84, ___85, ___86, ___87,
    ___88, ___89, ___8A, ___8B, ___8C, ___8D, ___8E, ___8F,
    ___90, ___91, ___92, ___93, ___94, ___95, ___96, ___97,
    ___98, ___99, ___9A, ___9B, ___9C, ___9D, ___9E, ___9F,
    ___A0, ___A1, ___A2, ___A3, ___A4, ___A5, ___A6, ___A7,
    ___A8, ___A9, ___AA, ___AB, ___AC, ___AD, ___AE, ___AF,
    ___B0, ___B1, ___B2, ___B3, ___B4, ___B5, ___B6, ___B7,
    ___B8, ___B9, ___BA, ___BB, ___BC, ___BD, ___BE, ___BF,
    ___C0, ___C1, ___C2, ___C3, ___C4, ___C5, ___C6, ___C7,
    ___C8, ___C9, ___CA, ___CB, ___CC, ___CD, ___CE, ___CF,
    ___D0, ___D1, ___D2, ___D3, ___D4, ___D5, ___D6, ___D7,
    ___D8, ___D9, ___DA, ___DB, ___DC, ___DD, ___DE, ___DF,
    ___E0, ___E1, ___E2, ___E3, ___E4, ___E5, ___E6, ___E7,
    ___E8, ___E9, ___EA, ___EB, ___EC, ___ED, ___EE, ___EF,
    ___F0, ___F1, ___F2, ___F3, ___F4, ___F5, ___F6, ___F7,
    ___F8, ___F9, ___FA, ___FB, ___FC, ___FD, ___FE, ___FF
};
