/*****************************************************************************
 *                                                                           *
 * Module : FCTIX.C                                                          *
 *                                                                           *
 * Fonctions grant les instructions Z80 aprs le code OP. DD : instructions *
 * utilisant le registre d'index IX                                          *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>

#include  "tools.h"
#include  "regs.h"
#include  "vga.h"


extern pfct tabCB[];

extern UBYTE LastInstr;

USHORT ErrIX = 0xFFFF;


inline USHORT GetIXdd( void )
{
    register char e = PEEK8( RegPC++ );
    return( RegIX + e );
}


static void DD_46( void ) /* LD B, (IX+d) */
{
    RegB = PEEK8( GetIXdd() );
}


static void DD_4E( void ) /* LD C, (IX+d) */
{
    RegC = PEEK8( GetIXdd() );
}


static void DD_56( void ) /* LD D, (IX+d) */
{
    RegD = PEEK8( GetIXdd() );
}


static void DD_5E( void ) /* LD E, (IX+d) */
{
    RegE = PEEK8( GetIXdd() );
}


static void DD_66( void ) /* LD H, (IX+d) */
{
    RegH = PEEK8( GetIXdd() );
}


static void DD_6E( void ) /* LD L, (IX+d) */
{
    RegL = PEEK8( GetIXdd() );
}


static void DD_7E( void ) /* LD A, (IX+d) */
{
    RegA = PEEK8( GetIXdd() );
}


static void DD_70( void ) /* LD (IX+d), B */
{
    POKE8( GetIXdd(), RegB );
}


static void DD_71( void ) /* LD (IX+d), C */
{
    POKE8( GetIXdd(), RegC );
}


static void DD_72( void ) /* LD (IX+d), D */
{
    POKE8( GetIXdd(), RegD );
}


static void DD_73( void ) /* LD (IX+d), E */
{
    POKE8( GetIXdd(), RegE );
}


static void DD_74( void ) /* LD (IX+d), H */
{
    POKE8( GetIXdd(), RegH );
}


static void DD_75( void ) /* LD (IX+d), L */
{
    POKE8( GetIXdd(), RegL );
}


static void DD_77( void ) /* LD (IX+d), A */
{
    POKE8( GetIXdd(), RegA );
}


static void DD_36( void ) /* LD (IX+d), n */
{
    USHORT ofs = GetIXdd();
    POKE8( ofs, PEEK8( RegPC++ ) );
}


static void DD_21( void ) /* LD IX, nn */
{
    RegIXL = PEEK8( RegPC++ );
    RegIXH = PEEK8( RegPC++ );
}


static void DD_2A( void ) /* LD IX, ( nn ) */
{
    Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegIXL = PEEK8( ofs.Word++ );
    RegIXH = PEEK8( ofs.Word );
}


static void DD_22( void ) /* LD ( nn ), IX */
{
    Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, RegIXL );
    POKE8( ofs.Word, RegIXH );
}


static void DD_F9( void ) /* LD SP, IX */
{
    SP = IX;
}


static void DD_E5( void ) /* PUSH IX */
{
    POKE8( --RegSP, RegIXH );
    POKE8( --RegSP, RegIXL );
}


static void DD_E1( void ) /* POP IX */
{
    RegIXL = PEEK8( RegSP++ );
    RegIXH = PEEK8( RegSP++ );
}


static void DD_E3( void ) /* EX (SP), IX */
{
    UBYTE a = PEEK8( RegSP++ );
    UBYTE b = PEEK8( RegSP );
    POKE8( RegSP--, RegIXH );
    POKE8( RegSP, RegIXL );
    RegIXL = a;
    RegIXH = b;
}


static void DD_86( void ) /* ADD A, (IX+n) */
{
    ADD_R8( PEEK8( GetIXdd() ) );
}


static void DD_8E( void ) /* ADC A, (IX+n) */
{
    ADC_R8( PEEK8( GetIXdd()  ) );
}


static void DD_96( void ) /* SUB (ix+n) */
{
    SUB_R8( PEEK8( GetIXdd() ) );
}


static void DD_9E( void ) /* SBC A, (ix+n) */
{
    SBC_R8( PEEK8( GetIXdd() ) );
}


static void DD_A6( void ) /* AND (ix+n) */
{
    RegA &= PEEK8( GetIXdd() );
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_AE( void ) /* XOR (ix+n) */
{
    RegA ^= PEEK8( GetIXdd() );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_B6( void ) /* OR (IX+n) */
{
    RegA |= PEEK8( GetIXdd() );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_BE( void ) /* CP (ix+n) */
{
    CP_R8( PEEK8( GetIXdd() ) );
}


static void DD_34( void ) /* INC (IX+n) */
{
    USHORT ofs = GetIXdd();
    UBYTE r = PEEK8( ofs );
    FLAG_INC( ++r );
    POKE8( ofs, r );
}


static void DD_35( void ) /* DEC (IX+n) */
{
    USHORT ofs = GetIXdd();
    UBYTE r = PEEK8( ofs );
    FLAG_DEC( --r );
    POKE8( ofs, r );
}


static void DD_09( void ) /* ADD IX,BC */
{
    register USHORT tmp = RegIX;

    RegIX += RegBC;

    if ( RegIX < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void DD_19( void ) /* ADD IX,DE */
{
    register USHORT tmp = RegIX;

    RegIX += RegDE;

    if ( RegIX < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void DD_29( void ) /* ADD IX,HL */
{
    register USHORT tmp = RegIX;

    RegIX += RegHL;

    if ( RegIX < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void DD_39( void ) /* ADD IX,SP */
{
    register USHORT tmp = RegIX;

    RegIX += RegSP;

    if ( RegIX < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void DD_23( void ) /* INC IX */
{
    ++RegIX;
}


static void DD_2B( void ) /* DEC IX */
{
    --RegIX;
}


static void DD_CB( void ) /* special code CB */
{
    USHORT tmp = RegHL;
    RegHL = GetIXdd();
    IR.Byte.Low++;
    tabCB[ PEEK8( RegPC++ ) ]();
    RegHL = tmp;
}


static void DD_E9( void ) /* JP (IX) */
{
    PC = IX;
}


static void DD_26( void ) /* LD IXh,n */
{
    RegIXH = PEEK8( RegPC++ );
}


static void DD_2E( void ) /* LD IXl,n */
{
    RegIXL = PEEK8( RegPC++ );
}


static void DD_24( void ) /* INC IXh */
{
    FLAG_INC( ++RegIXH );
}


static void DD_2C( void ) /* INC IXl */
{
    FLAG_INC( ++RegIXL );
}


static void DD_25( void ) /* DEC IXh */
{
    FLAG_DEC( --RegIXH );
}


static void DD_2D( void ) /* DEC IXl */
{
    FLAG_DEC( --RegIXL );
}


static void DD_65( void ) /* LD IXh,IXl */
{
    RegIXH = RegIXL;
}


static void DD_67( void ) /* LD IXh,A */
{
    RegIXH = RegA;
}


static void DD_6F( void ) /* LD IXl,A */
{
    RegIXL = RegA;
}


static void DD_6C( void ) /* LD IXl,IXH */
{
    RegIXL = RegIXH;
}


static void DD_44( void ) /* LD B,IXh */
{
    RegB = RegIXH;
}


static void DD_45( void ) /* LD B,IXl */
{
    RegB = RegIXL;
}


static void DD_4C( void ) /* LD C,IXh */
{
    RegC = RegIXH;
}


static void DD_4D( void ) /* LD C,IXl */
{
    RegC = RegIXL;
}


static void DD_54( void ) /* LD D,IXh */
{
    RegD = RegIXH;
}


static void DD_55( void ) /* LD D,IXl */
{
    RegD = RegIXL;
}


static void DD_5C( void ) /* LD E,IXh */
{
    RegE = RegIXH;
}


static void DD_5D( void ) /* LD E,IXl */
{
    RegE = RegIXL;
}


static void DD_60( void ) /* LD IXh,B */
{
    RegIXH = RegB;
}


static void DD_61( void ) /* LD IXh,C */
{
    RegIXH = RegC;
}


static void DD_62( void ) /* LD IXh,D */
{
    RegIXH = RegD;
}


static void DD_63( void ) /* LD IXh,E */
{
    RegIXH = RegE;
}


static void DD_68( void ) /* LD IXl,B */
{
    RegIXL = RegB;
}


static void DD_69( void ) /* LD IXl,C */
{
    RegIXL = RegC;
}


static void DD_6A( void ) /* LD IXl,D */
{
    RegIXL = RegD;
}


static void DD_6B( void ) /* LD IXl,E */
{
    RegIXL = RegE;
}


static void DD_7C( void ) /* LD A,IXh */
{
    RegA = RegIXH;
}


static void DD_7D( void ) /* LD A,IXl */
{
    RegA = RegIXL;
}


static void DD_84( void ) /* ADD A, IXh */
{
    ADD_R8( RegIXH );
}


static void DD_85( void ) /* ADD A, IXl */
{
    ADD_R8( RegIXL );
}


static void DD_BC( void ) /* CP IXh */
{
    CP_R8( RegIXH );
}


static void DD_8C( void ) /* ADC A, IXh */
{
    ADC_R8( RegIXH );
}


static void DD_8D( void ) /* ADC A, IXl */
{
    ADC_R8( RegIXL );
}


static void DD_94( void ) /* SUB IXh */
{
    SUB_R8( RegIXH );
}


static void DD_95( void ) /* SUB IXl */
{
    SUB_R8( RegIXL );
}


static void DD_9C( void ) /* SBC A, IXh */
{
    SBC_R8( RegIXH );
}


static void DD_9D( void ) /* SBC A, IXl */
{
    SBC_R8( RegIXL );
}


static void DD_BD( void ) /* CP IXl */
{
    CP_R8( RegIXL );
}


static void DD_A4( void ) /* AND IXh */
{
    RegA &= RegIXH;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void DD_A5( void ) /* AND IXl */
{
    RegA &= RegIXL;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void DD_AC( void ) /* XOR IXh */
{
    RegA ^= RegIXH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_AD( void ) /* XOR IXl */
{
    RegA ^= RegIXL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_B4( void ) /* OR IXh */
{
    RegA |= RegIXH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_B5( void ) /* OR IXl */
{
    RegA |= RegIXL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void DD_XX( void )
{
    ErrIX = LastInstr;
}


pfct tabIX[ 256 ] =
    {
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // 00
    DD_XX, DD_09, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // 08
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // 10
    DD_XX, DD_19, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // 18
    DD_XX, DD_21, DD_22, DD_23, DD_24, DD_25, DD_26, DD_XX, // 20
    DD_XX, DD_29, DD_2A, DD_2B, DD_2C, DD_2D, DD_2E, DD_XX, // 28
    DD_XX, DD_XX, DD_XX, DD_XX, DD_34, DD_35, DD_36, DD_XX, // 30
    DD_XX, DD_39, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // 38
    DD_XX, DD_XX, DD_XX, DD_XX, DD_44, DD_45, DD_46, DD_XX, // 40
    DD_XX, DD_XX, DD_XX, DD_XX, DD_4C, DD_4D, DD_4E, DD_XX, // 48
    DD_XX, DD_XX, DD_XX, DD_XX, DD_54, DD_55, DD_56, DD_XX, // 50
    DD_XX, DD_XX, DD_XX, DD_XX, DD_5C, DD_5D, DD_5E, DD_XX, // 58
    DD_60, DD_61, DD_62, DD_63, DD_XX, DD_65, DD_66, DD_67, // 60
    DD_68, DD_69, DD_6A, DD_6B, DD_6C, DD_XX, DD_6E, DD_6F, // 68
    DD_70, DD_71, DD_72, DD_73, DD_74, DD_75, DD_XX, DD_77, // 70
    DD_XX, DD_XX, DD_XX, DD_XX, DD_7C, DD_7D, DD_7E, DD_XX, // 78
    DD_XX, DD_XX, DD_XX, DD_XX, DD_84, DD_85, DD_86, DD_XX, // 80
    DD_XX, DD_XX, DD_XX, DD_XX, DD_8C, DD_8D, DD_8E, DD_XX, // 88
    DD_XX, DD_XX, DD_XX, DD_XX, DD_94, DD_95, DD_96, DD_XX, // 90
    DD_XX, DD_XX, DD_XX, DD_XX, DD_9C, DD_9D, DD_9E, DD_XX, // 98
    DD_XX, DD_XX, DD_XX, DD_XX, DD_A4, DD_A5, DD_A6, DD_XX, // A0
    DD_XX, DD_XX, DD_XX, DD_XX, DD_AC, DD_AD, DD_AE, DD_XX, // A8
    DD_XX, DD_XX, DD_XX, DD_XX, DD_B4, DD_B5, DD_B6, DD_XX, // B0
    DD_XX, DD_XX, DD_XX, DD_XX, DD_BC, DD_BD, DD_BE, DD_XX, // B8
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // C0
    DD_XX, DD_XX, DD_XX, DD_CB, DD_XX, DD_XX, DD_XX, DD_XX, // C8
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // D0
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // D8
    DD_XX, DD_E1, DD_XX, DD_E3, DD_XX, DD_E5, DD_XX, DD_XX, // E0
    DD_XX, DD_E9, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // E8
    DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, // F0
    DD_XX, DD_F9, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX, DD_XX  // F8
    };
