/*****************************************************************************
 *                                                                           *
 * Module : FCTIY.C                                                          *
 *                                                                           *
 * Fonctions grant les instructions Z80 aprs le code OP. DD : instructions *
 * utilisant le registre d'index IY                                          *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>

#include  "tools.h"
#include  "regs.h"
#include  "vga.h"


extern pfct tabCB[];

extern UBYTE LastInstr;

USHORT ErrIY = 0xFFFF;


inline USHORT GetIYdd( void )
{
    register char e = PEEK8( RegPC++ );
    return( RegIY + e );
}


static void FD_46( void ) /* LD B, (IY+d) */
{
    RegB = PEEK8( GetIYdd() );
}


static void FD_4E( void ) /* LD C, (IY+d) */
{
    RegC = PEEK8( GetIYdd() );
}


static void FD_56( void ) /* LD D, (IY+d) */
{
    RegD = PEEK8( GetIYdd() );
}


static void FD_5E( void ) /* LD E, (IY+d) */
{
    RegE = PEEK8( GetIYdd() );
}


static void FD_66( void ) /* LD H, (IY+d) */
{
    RegH = PEEK8( GetIYdd() );
}


static void FD_6E( void ) /* LD L, (IY+d) */
{
    RegL = PEEK8( GetIYdd() );
}


static void FD_7E( void ) /* LD A, (IY+d) */
{
    RegA = PEEK8( GetIYdd() );
}


static void FD_70( void ) /* LD (IY+d), B */
{
    POKE8( GetIYdd(), RegB );
}


static void FD_71( void ) /* LD (IY+d), C */
{
    POKE8( GetIYdd(), RegC );
}


static void FD_72( void ) /* LD (IY+d), D */
{
    POKE8( GetIYdd(), RegD );
}


static void FD_73( void ) /* LD (IY+d), E */
{
    POKE8( GetIYdd(), RegE );
}


static void FD_74( void ) /* LD (IY+d), H */
{
    POKE8( GetIYdd(), RegH );
}


static void FD_75( void ) /* LD (IY+d), L */
{
    POKE8( GetIYdd(), RegL );
}


static void FD_77( void ) /* LD (IY+d), A */
{
    POKE8( GetIYdd(), RegA );
}


static void FD_36( void ) /* LD (IY+d), n */
{
    USHORT ofs = GetIYdd();
    POKE8( ofs, PEEK8( RegPC++ ) );
}


static void FD_21( void ) /* LD IY, nn */
{
    RegIYL = PEEK8( RegPC++ );
    RegIYH = PEEK8( RegPC++ );
}


static void FD_2A( void ) /* LD IY, ( nn ) */
{
    Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    RegIYL = PEEK8( ofs.Word++ );
    RegIYH = PEEK8( ofs.Word );
}


static void FD_22( void ) /* LD ( nn ), IY */
{
    Registre ofs;
    ofs.Byte.Low = PEEK8( RegPC++ );
    ofs.Byte.High = PEEK8( RegPC++ );
    POKE8( ofs.Word++, RegIYL );
    POKE8( ofs.Word, RegIYH );
}


static void FD_F9( void ) /* LD SP, IY */
{
    SP = IY;
}


static void FD_E5( void ) /* PUSH IY */
{
    POKE8( --RegSP, RegIYH );
    POKE8( --RegSP, RegIYL );
}


static void FD_E1( void ) /* POP IY */
{
    RegIYL = PEEK8( RegSP++ );
    RegIYH = PEEK8( RegSP++ );
}


static void FD_E3( void ) /* EX (SP), IY */
{
    UBYTE a = PEEK8( RegSP++ );
    UBYTE b = PEEK8( RegSP );
    POKE8( RegSP--, RegIYH );
    POKE8( RegSP, RegIYL );
    RegIYL = a;
    RegIYH = b;
}


static void FD_86( void ) /* ADD A, (IY+n) */
{
    ADD_R8( PEEK8( GetIYdd() ) );
}


static void FD_8E( void ) /* ADC A, (IY+n) */
{
    ADC_R8( PEEK8( GetIYdd()  ) );
}


static void FD_96( void ) /* SUB (ix+n) */
{
    SUB_R8( PEEK8( GetIYdd() ) );
}


static void FD_9E( void ) /* SBC A, (ix+n) */
{
    SBC_R8( PEEK8( GetIYdd() ) );
}


static void FD_A6( void ) /* AND (ix+n) */
{
    RegA &= PEEK8( GetIYdd() );
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_AE( void ) /* XOR (ix+n) */
{
    RegA ^= PEEK8( GetIYdd() );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_B6( void ) /* OR (IY+n) */
{
    RegA |= PEEK8( GetIYdd() );
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_BE( void ) /* CP (ix+n) */
{
    CP_R8( PEEK8( GetIYdd() ) );
}


static void FD_34( void ) /* INC (IY+n) */
{
    USHORT ofs = GetIYdd();
    UBYTE r = PEEK8( ofs );
    FLAG_INC( ++r );
    POKE8( ofs, r );
}


static void FD_35( void ) /* DEC (IY+n) */
{
    USHORT ofs = GetIYdd();
    UBYTE r = PEEK8( ofs );
    FLAG_DEC( --r );
    POKE8( ofs, r );
}


static void FD_09( void ) /* ADD IY,BC */
{
    register USHORT tmp = RegIY;

    RegIY += RegBC;

    if ( RegIY < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void FD_19( void ) /* ADD IY,DE */
{
    register USHORT tmp = RegIY;

    RegIY += RegDE;

    if ( RegIY < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void FD_29( void ) /* ADD IY,HL */
{
    register USHORT tmp = RegIY;

    RegIY += RegHL;

    if ( RegIY < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void FD_39( void ) /* ADD IY,SP */
{
    register USHORT tmp = RegIY;

    RegIY += RegSP;

    if ( RegIY < tmp )
        FLAGS |= FLAG_C;
    else
        FLAGS &= N_FLAG_C;

    FLAGS &= N_FLAG_N;
}


static void FD_23( void ) /* INC IY */
{
    ++RegIY;
}


static void FD_2B( void ) /* DEC IY */
{
    --RegIY;
}


static void FD_CB( void ) /* special code CB */
{
    USHORT tmp = RegHL;
    RegHL = GetIYdd();
    IR.Byte.Low++;
    tabCB[ PEEK8( RegPC++ ) ]();
    RegHL = tmp;
}


static void FD_E9( void ) /* JP (IY) */
{
    PC = IY;
}


static void FD_26( void ) /* LD IYh,n */
{
    RegIYH = PEEK8( RegPC++ );
}


static void FD_2E( void ) /* LD IYl,n */
{
    RegIYL = PEEK8( RegPC++ );
}


static void FD_24( void ) /* INC IYh */
{
    FLAG_INC( ++RegIYH );
}


static void FD_2C( void ) /* INC IYl */
{
    FLAG_INC( ++RegIYL );
}


static void FD_25( void ) /* DEC IYh */
{
    FLAG_DEC( --RegIYH );
}


static void FD_2D( void ) /* DEC IYl */
{
    FLAG_DEC( --RegIYL );
}


static void FD_65( void ) /* LD IYh,IYl */
{
    RegIYH = RegIYL;
}


static void FD_67( void ) /* LD IYh,A */
{
    RegIYH = RegA;
}


static void FD_6F( void ) /* LD IYl,A */
{
    RegIYL = RegA;
}


static void FD_6C( void ) /* LD IYl,IYH */
{
    RegIYL = RegIYH;
}


static void FD_44( void ) /* LD B,IYh */
{
    RegB = RegIYH;
}


static void FD_45( void ) /* LD B,IYl */
{
    RegB = RegIYL;
}


static void FD_4C( void ) /* LD C,IYh */
{
    RegC = RegIYH;
}


static void FD_4D( void ) /* LD C,IYl */
{
    RegC = RegIYL;
}


static void FD_54( void ) /* LD D,IYh */
{
    RegD = RegIYH;
}


static void FD_55( void ) /* LD D,IYl */
{
    RegD = RegIYL;
}


static void FD_5C( void ) /* LD E,IYh */
{
    RegE = RegIYH;
}


static void FD_5D( void ) /* LD E,IYl */
{
    RegE = RegIYL;
}


static void FD_60( void ) /* LD IYh,B */
{
    RegIYH = RegB;
}


static void FD_61( void ) /* LD IYh,C */
{
    RegIYH = RegC;
}


static void FD_62( void ) /* LD IYh,D */
{
    RegIYH = RegD;
}


static void FD_63( void ) /* LD IYh,E */
{
    RegIYH = RegE;
}


static void FD_68( void ) /* LD IYl,B */
{
    RegIYL = RegB;
}


static void FD_69( void ) /* LD IYl,C */
{
    RegIYL = RegC;
}


static void FD_6A( void ) /* LD IYl,D */
{
    RegIYL = RegD;
}


static void FD_6B( void ) /* LD IYl,E */
{
    RegIYL = RegE;
}


static void FD_7C( void ) /* LD A,IYh */
{
    RegA = RegIYH;
}


static void FD_7D( void ) /* LD A,IYl */
{
    RegA = RegIYL;
}


static void FD_84( void ) /* ADD A, IYh */
{
    ADD_R8( RegIYH );
}


static void FD_85( void ) /* ADD A, IYl */
{
    ADD_R8( RegIYL );
}


static void FD_BC( void ) /* CP IYh */
{
    CP_R8( RegIYH );
}


static void FD_8C( void ) /* ADC A, IYh */
{
    ADC_R8( RegIYH );
}


static void FD_8D( void ) /* ADC A, IYl */
{
    ADC_R8( RegIYL );
}


static void FD_94( void ) /* SUB IYh */
{
    SUB_R8( RegIYH );
}


static void FD_95( void ) /* SUB IYl */
{
    SUB_R8( RegIYL );
}


static void FD_9C( void ) /* SBC A, IYh */
{
    SBC_R8( RegIYH );
}


static void FD_9D( void ) /* SBC A, IYl */
{
    SBC_R8( RegIYL );
}


static void FD_BD( void ) /* CP IYl */
{
    CP_R8( RegIYL );
}


static void FD_A4( void ) /* AND IYh */
{
    RegA &= RegIYH;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void FD_A5( void ) /* AND IYl */
{
    RegA &= RegIYL;
    FLAGS = FLAG_H;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];

}


static void FD_AC( void ) /* XOR IYh */
{
    RegA ^= RegIYH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_AD( void ) /* XOR IYl */
{
    RegA ^= RegIYL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_B4( void ) /* OR IYh */
{
    RegA |= RegIYH;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_B5( void ) /* OR IYl */
{
    RegA |= RegIYL;
    FLAGS = ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void FD_XX( void )
{
    ErrIY = LastInstr;
}


pfct tabIY[ 256 ] =
    {
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // 00
    FD_XX, FD_09, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // 08
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // 10
    FD_XX, FD_19, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // 18
    FD_XX, FD_21, FD_22, FD_23, FD_24, FD_25, FD_26, FD_XX, // 20
    FD_XX, FD_29, FD_2A, FD_2B, FD_2C, FD_2D, FD_2E, FD_XX, // 28
    FD_XX, FD_XX, FD_XX, FD_XX, FD_34, FD_35, FD_36, FD_XX, // 30
    FD_XX, FD_39, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // 38
    FD_XX, FD_XX, FD_XX, FD_XX, FD_44, FD_45, FD_46, FD_XX, // 40
    FD_XX, FD_XX, FD_XX, FD_XX, FD_4C, FD_4D, FD_4E, FD_XX, // 48
    FD_XX, FD_XX, FD_XX, FD_XX, FD_54, FD_55, FD_56, FD_XX, // 50
    FD_XX, FD_XX, FD_XX, FD_XX, FD_5C, FD_5D, FD_5E, FD_XX, // 58
    FD_60, FD_61, FD_62, FD_63, FD_XX, FD_65, FD_66, FD_67, // 60
    FD_68, FD_69, FD_6A, FD_6B, FD_6C, FD_XX, FD_6E, FD_6F, // 68
    FD_70, FD_71, FD_72, FD_73, FD_74, FD_75, FD_XX, FD_77, // 70
    FD_XX, FD_XX, FD_XX, FD_XX, FD_7C, FD_7D, FD_7E, FD_XX, // 78
    FD_XX, FD_XX, FD_XX, FD_XX, FD_84, FD_85, FD_86, FD_XX, // 80
    FD_XX, FD_XX, FD_XX, FD_XX, FD_8C, FD_8D, FD_8E, FD_XX, // 88
    FD_XX, FD_XX, FD_XX, FD_XX, FD_94, FD_95, FD_96, FD_XX, // 90
    FD_XX, FD_XX, FD_XX, FD_XX, FD_9C, FD_9D, FD_9E, FD_XX, // 98
    FD_XX, FD_XX, FD_XX, FD_XX, FD_A4, FD_A5, FD_A6, FD_XX, // A0
    FD_XX, FD_XX, FD_XX, FD_XX, FD_AC, FD_AD, FD_AE, FD_XX, // A8
    FD_XX, FD_XX, FD_XX, FD_XX, FD_B4, FD_B5, FD_B6, FD_XX, // B0
    FD_XX, FD_XX, FD_XX, FD_XX, FD_BC, FD_BD, FD_BE, FD_XX, // B8
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // C0
    FD_XX, FD_XX, FD_XX, FD_CB, FD_XX, FD_XX, FD_XX, FD_XX, // C8
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // D0
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // D8
    FD_XX, FD_E1, FD_XX, FD_E3, FD_XX, FD_E5, FD_XX, FD_XX, // E0
    FD_XX, FD_E9, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // E8
    FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, // F0
    FD_XX, FD_F9, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX, FD_XX  // F8
    };
