#ifndef GESTPORT_H
#define GESTPORT_H


#include  <exec/types.h>


#include  "vga.h"
#include  "ppi.h"
#include  "crtc.h"
#include  "upd.h"


inline UBYTE ReadPort( USHORT port )
{
    if ( ( port & 0xF400 ) == 0xF400 )
        return ReadPPI( port );

    if ( ( port & 0xFB7E ) == 0xFB7E )
        return ReadUPD( port );

    return 0xFF;
}


inline void WritePort( USHORT port, UBYTE val )
{
    if ( ( port & 0x7E00 ) == 0x7E00 )
        WriteVGA( val );
    else
        if ( ( port & 0xF400 ) == 0xF400 )
            WritePPI( port, val );
        else
            if ( ( port & 0xFE00 ) == 0xBC00 )
                WriteCRTC( port, val );
            else
                if ( port == 0xFB7F )
                    WriteUPD( val );
                else
                    if ( ( port & 0xFF00 ) == 0xDF00 )
                        {
                        if ( val == 7 )
                            DecodeurAdresse |= ROMDISC_SEL;
                        else
                            DecodeurAdresse &= N_ROMDISC_SEL;

                        ChangeROMSup();
                        }
}


#endif
