_TEXT	segment byte public 'CODE'

                    .386


;                   void ADD_R8( UBYTE incr )

_ADD_R8:            push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    add             byte ptr es:[ _AF + 1 ], al
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    ret


;                   void ADC_R8( UBYTE incr )

_ADC_R8:            pushf
                    push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    mov             bl, byte ptr es:[ _AF ]
                    and             bx, 1
                    push            bx
                    popf

                    adc             byte ptr es:[ _AF + 1 ], al
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    popf
                    ret


;                   void SUB_R8( UBYTE incr )

_SUB_R8:            push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    sub             byte ptr es:[ _AF + 1 ], al
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    or              bl,4
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    ret


;                   void SBC_R8( UBYTE incr )

_SBC_R8:            pushf
                    push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    mov             bl, byte ptr es:[ _AF ]
                    and             bx, 1
                    push            bx
                    popf

                    sbb             byte ptr es:[ _AF + 1 ], al
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    or              bl,4
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    popf
                    ret


;                   void CP_R8( UBYTE incr )

_CP_R8:             push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    cmp             byte ptr es:[ _AF + 1 ], al
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    or              bl,4
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    ret


;                   void DAA( void )

_DAA:               pushf
                    push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    xor             ah,ah
                    mov             al, byte ptr es:[ _AF + 1 ]
                    mov             bl, byte ptr es:[ _AF ]
                    mov             bh, bl
                    and             bh, 2
                    shl             bh, 2
                    and             bl, 0D1H
                    push            bx
                    popf
                    daa
                    pushf
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    mov             byte ptr es:[ _AF ],bl
                    mov             byte ptr es:[ _AF + 1 ],al
                    pop             es
                    popf
                    ret


;                   void ADC_R16( UBYTE incr )

_ADC_R16:           pushf
                    push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    mov             bl, byte ptr es:[ _AF ]
                    and             bx, 1
                    push            bx
                    popf

                    mov             bx, seg _HL
                    adc             word ptr es:[ _HL ], ax
                    pushf
                    mov             bx, seg _AF
                    mov             es, bx
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    popf
                    ret


;                   void SBC_R16( UBYTE incr )

_SBC_R16:           pushf
                    push            es
                    mov             bx, seg _AF
                    mov             es, bx
                    mov             bl, byte ptr es:[ _AF ]
                    and             bx, 1
                    push            bx
                    popf

                    mov             bx, seg _HL
                    sbb             word ptr es:[ _HL ], ax
                    pushf
                    mov             bx, seg _AF
                    mov             es, bx
                    pop             bx
                    and             bx, 08D1H
                    shr             bh,2
                    or              bl,bh
                    mov             byte ptr es:[ _AF ],bl
                    pop             es
                    popf
                    ret


_TEXT               ends


extrn               _AF : word, _HL : word

public              _ADD_R8, _ADC_R8, _SUB_R8, _SBC_R8, _CP_R8, _DAA, _ADC_R16, _SBC_R16


                    END