    .286

DGROUP  group   _DATA, _BSS
    assume  cs:_TEXT, ds:DGROUP

_BSS    segment word public 'BSS'
b@  label   byte
b@w label   word
_BSS    ends

_DATA   segment word public 'DATA'
d@  label   byte
d@w label   word
_segAdrCPC  label   dword
    db  4 dup (0)
_TabCoul    label   byte
    db  32 dup (0)
_TabDac label   byte
    db  0, 1, 2, 3, 4, 5, 6, 7
    db  16, 17, 18, 19, 20, 21, 22, 23
    db  16 dup (255)
_DecodeurAdresse    label   word
    db  1
    db  0
_segdosAdrCPC   label   word
    db  2 dup (0)
_TabPOKE    label   dword
    db  16 dup (0)
_TabPEEK    label   dword
    db  16 dup (0)
tabCouleursCPC  label   word
    db  3 dup (31)
    db  0
    db  3 dup (31)
    db  2 dup (0)
    db  63
    db  31
    db  0
    db  2 dup (63)
    db  31
    db  3 dup (0)
    db  31
    db  0
    db  63
    db  0
    db  31
    db  2 dup (0)
    db  2 dup (31)
    db  0
    db  63
    db  2 dup (31)
    db  0
    db  63
    db  0
    db  31
    db  0
    db  2 dup (63)
    db  2 dup (0)
    db  2 dup (63)
    db  2 dup (0)
    db  3 dup (63)
    db  0
    db  63
    db  3 dup (0)
    db  63
    db  0
    db  63
    db  0
    db  63
    db  31
    db  2 dup (0)
    db  63
    db  31
    db  63
    db  3 dup (0)
    db  31
    db  2 dup (0)
    db  63
    db  31
    db  2 dup (0)
    db  63
    db  3 dup (0)
    db  2 dup (63)
    db  7 dup (0)
    db  63
    db  2 dup (0)
    db  31
    db  3 dup (0)
    db  31
    db  63
    db  0
    db  31
    db  0
    db  31
    db  0
    db  31
    db  63
    db  31
    db  0
    db  31
    db  63
    db  2 dup (0)
    db  31
    db  2 dup (63)
    db  0
    db  31
    db  3 dup (0)
    db  31
    db  0
    db  63
    db  0
    db  2 dup (31)
    db  2 dup (0)
    db  2 dup (31)
    db  63
    db  0
tabOctMode0P1   label   byte
    db  64 dup (0)
    db  64 dup (15)
    db  64 dup (240)
    db  64 dup (255)
tabOctMode0P2   label   byte
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
    db  4 dup (0)
    db  4 dup (15)
    db  4 dup (240)
    db  4 dup (255)
tabOctMode0P3   label   byte
    db  16 dup (0)
    db  16 dup (15)
    db  16 dup (240)
    db  16 dup (255)
    db  16 dup (0)
    db  16 dup (15)
    db  16 dup (240)
    db  16 dup (255)
    db  16 dup (0)
    db  16 dup (15)
    db  16 dup (240)
    db  16 dup (255)
    db  16 dup (0)
    db  16 dup (15)
    db  16 dup (240)
    db  16 dup (255)
tabOctMode0P4   label   byte
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
    db  0, 15, 240, 255, 0, 15, 240, 255
tabOctMode1P1   label   byte
    db  16 dup (0)
    db  16 dup (3)
    db  16 dup (12)
    db  16 dup (15)
    db  16 dup (48)
    db  16 dup (51)
    db  16 dup (60)
    db  16 dup (63)
    db  16 dup (192)
    db  16 dup (195)
    db  16 dup (204)
    db  16 dup (207)
    db  16 dup (240)
    db  16 dup (243)
    db  16 dup (252)
    db  16 dup (255)
tabOctMode1P2   label   byte
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
    db  0, 3, 12, 15, 48, 51, 60, 63, 192, 195, 204, 207, 240, 243, 252, 255
tabOctMode2P1   label   byte
    db  0, 1, 2, 3, 4, 5, 6, 7
    db  8, 9, 10, 11, 12, 13, 14, 15
    db  16, 17, 18, 19, 20, 21, 22, 23
    db  24, 25, 26, 27, 28, 29, 30, 31
    db  32, 33, 34, 35, 36, 37, 38, 39
    db  40, 41, 42, 43, 44, 45, 46, 47
    db  48, 49, 50, 51, 52, 53, 54, 55
    db  56, 57, 58, 59, 60, 61, 62, 63
    db  64, 65, 66, 67, 68, 69, 70, 71
    db  72, 73, 74, 75, 76, 77, 78, 79
    db  80, 81, 82, 83, 84, 85, 86, 87
    db  88, 89, 90, 91, 92, 93, 94, 95
    db  96, 97, 98, 99, 100, 101, 102, 103
    db  104, 105, 106, 107, 108, 109, 110, 111
    db  112, 113, 114, 115, 116, 117, 118, 119
    db  120, 121, 122, 123, 124, 125, 126, 127
    db  128, 129, 130, 131, 132, 133, 134, 135
    db  136, 137, 138, 139, 140, 141, 142, 143
    db  144, 145, 146, 147, 148, 149, 150, 151
    db  152, 153, 154, 155, 156, 157, 158, 159
    db  160, 161, 162, 163, 164, 165, 166, 167
    db  168, 169, 170, 171, 172, 173, 174, 175
    db  176, 177, 178, 179, 180, 181, 182, 183
    db  184, 185, 186, 187, 188, 189, 190, 191
    db  192, 193, 194, 195, 196, 197, 198, 199
    db  200, 201, 202, 203, 204, 205, 206, 207
    db  208, 209, 210, 211, 212, 213, 214, 215
    db  216, 217, 218, 219, 220, 221, 222, 223
    db  224, 225, 226, 227, 228, 229, 230, 231
    db  232, 233, 234, 235, 236, 237, 238, 239
    db  240, 241, 242, 243, 244, 245, 246, 247
    db  248, 249, 250, 251, 252, 253, 254, 255
Oct1    label   byte
    db  256 dup (0)
Oct2    label   byte
    db  256 dup (0)
Oct3    label   byte
    db  256 dup (0)
Oct4    label   byte
    db  256 dup (0)
    db  6, 0, 48, 57, 0, 64, 0, 0, 0, 4, 0, 4, 0, 10, 0, 10
    db  0, 25, 0, 25, 128, 42, 128, 42, 48, 57
    dw      0400h
    dw      0400h
    dw      0400h
    dw      0400h
    dw      1000h
    dw      1400h
    dw      1800h
    dw      1C00h
    db      0
    db      0
_DATA   ends

_TEXT   segment byte public 'CODE'
    assume  cs:_TEXT

@NewInt08$qve   proc    far
    pusha
    push    es
    push    ds

    mov     byte ptr DGROUP:_VBL, 0
    mov     al, byte ptr DGROUP:d@ + 3048
    inc     al
    mov     byte ptr DGROUP:d@ + 3048, al
    cmp     al, 5
    jbe     short Interrupt
    mov     byte ptr DGROUP:d@ + 3048, 0
    mov     byte ptr DGROUP:_VBL, 1

Interrupt:
    mov     al, byte ptr DGROUP:_DmdChgFic
    xor     ah, ah
    or      ax, ax
    je      RedrawScreen
    jmp     FinInterrupt

RedrawScreen:
    mov     al, byte ptr DGROUP:d@ + 3048
    shl     ax, 2
    mov     bx, ax
    mov     di, word ptr DGROUP:d@w + 3050[ bx ]
    mov     cx, word ptr DGROUP:d@w + 3050[ bx + 2 ]
    mov     bx, word ptr DGROUP:_adrEcr
    shl     bx, 2
    mov     ax, word ptr DGROUP:_TabPOKE[ bx + 2 ]
    mov     bp, ax

    mov     dx, 03C5h
    mov     al, 1
    out     dx, al
    mov     ax, di
    shl     ax, 1
    add     ax, offset DGROUP:_tabAdrMemEcrCPC
    mov     si, ax
    mov     dx, 0A000h
    sub     cx, di
    pusha
RedrawPlan0:
    mov     es, bp
    mov     bx, word ptr [ si ]
    mov     bl, byte ptr es:[ bx ]
    xor     bh, bh
    mov     al, byte ptr DGROUP:Oct1[ bx ]
    mov     es, dx
    stosb
    add     si, 2
    loop    RedrawPlan0

    mov     dx, 03C5h
    mov     al, 2
    out     dx, al
    popa
    pusha
RedrawPlan1:
    mov     es, bp
    mov     bx, word ptr [ si ]
    mov     bl, byte ptr es:[ bx ]
    xor     bh, bh
    mov     al, byte ptr DGROUP:Oct2[ bx ]
    mov     es, dx
    stosb
    add     si, 2
    loop    RedrawPlan1

    mov     dx, 03C5h
    mov     al, 4
    out     dx, al
    popa
    pusha
RedrawPlan2:
    mov     es, bp
    mov     bx, word ptr [ si ]
    mov     bl, byte ptr es:[ bx ]
    xor     bh, bh
    mov     al, byte ptr DGROUP:Oct3[ bx ]
    mov     es, dx
    stosb
    add     si, 2
    loop    RedrawPlan2

    mov     dx, 03C5h
    mov     al, 8
    out     dx, al
    popa
RedrawPlan3:
    mov     es, bp
    mov     bx, word ptr [ si ]
    mov     bl, byte ptr es:[ bx ]
    xor     bh, bh
    mov     al, byte ptr DGROUP:Oct4[ bx ]
    mov     es, dx
    stosb
    add     si, 2
    loop    RedrawPlan3

FinInterrupt:
    mov     word ptr DGROUP:_IRQ, 1
    mov     ax, word ptr DGROUP:_FreqInt
    mov     dx, 64
    out     dx, al
    mov     al, ah
    out     dx, al
    mov     dx, 32
    mov     al, dl
    out     dx, al

    pop     ds
    pop     es
    popa
    iret
@NewInt08$qve   endp

@WriteVGA$quc   proc    near
    mov     dx, ax
    and     ax, 001Fh
    and     dx, 00C0h
    or      dx, dx
    je      short WrVga00
    cmp     dx, 040h
    je      short WrVga40
    cmp     dx, 080h
    je      short WrVga80

WrVgaC0:
    and     ax, 7
    shl     ax, 1
    mov     bx, word ptr DGROUP:_segdosAdrCPC
    xchg    bx, ax
    add     ax, word ptr DGROUP:d@w + 3074[ bx ]
    mov     word ptr DGROUP:_TabPEEK + 6, ax
    mov     word ptr DGROUP:_TabPOKE + 6, ax
    ret

WrVga00:
    mov     byte ptr DGROUP:d@ + 3090, al
    ret

WrVga40:
    mov     cx, ax
    shl     cx, 2
    mov     bl, byte ptr DGROUP:d@ + 3090
    xor     bh, bh
    mov     byte ptr DGROUP:_TabCoul[ bx ], al
    mov     al, byte ptr DGROUP:_TabDac[ bx ]
    mov     dx, 3C8H
    out     dx, al
    inc     dx
    mov     bx, cx
    mov     al, byte ptr DGROUP:tabCouleursCPC[ bx ]
    out     dx, al
    mov     al, byte ptr DGROUP:tabCouleursCPC[ bx + 1 ]
    out     dx, al
    mov     al, byte ptr DGROUP:tabCouleursCPC[ bx + 2 ]
    out     dx, al
    ret

WrVga80:
    push    si
    push    di
    and     word ptr DGROUP:_DecodeurAdresse, 0FCh
    test    ax, 4
    jne     short FlagMem
    or      word ptr DGROUP:_DecodeurAdresse, 1
FlagMem:
    test    ax, 8
    jne     short ModeEcr
    or      word ptr DGROUP:_DecodeurAdresse, 2
ModeEcr:
    mov     dl, byte ptr DGROUP:d@ + 3091
    xor     dh, dh
    mov     bx, ax
    and     bx, 3
    cmp     dx, bx
    je      SetMem

    mov     byte ptr DGROUP:d@ + 3091, bl
    push    ds
    pop     es
    mov     di, offset DGROUP:Oct1
    shl     bx, 1
    jmp     word ptr cs:TabPtrMode[ bx ]

SetMode0:
    mov     si, offset DGROUP:tabOctMode0P1
    mov     cx, 512
    rep     movsw
    jmp     short SetMem

SetMode1:
    mov     si, offset DGROUP:tabOctMode1P1
    mov     cx, 256
    rep     movsw
    xor     ax, ax
    mov     cx, 256
    rep     stosw
    jmp     short SetMem

SetMode2:
    mov     si, offset DGROUP:tabOctMode2P1
    mov     cx, 128
    rep     movsw
    xor     ax, ax
    mov     cx, 384
    rep     stosw

SetMem:
    mov     dx, word ptr DGROUP:_segdosAdrCPC
    test    word ptr DGROUP:_DecodeurAdresse, 1
    je      short SetLowMem
    mov     dx, seg _ROMINF
SetLowMem:
    mov     word ptr DGROUP:_TabPEEK + 2, dx
    mov     dx, word ptr DGROUP:_segdosAdrCPC
    add     dx, 0C00h
    test    word ptr DGROUP:_DecodeurAdresse, 2
    je      short SetHighMem
    mov     dx, seg _ROMSUP
    test    word ptr DGROUP:_DecodeurAdresse, 4
    je      short SetHighMem
    mov     dx, seg _ROMDISC
SetHighMem:
    mov     word ptr DGROUP:_TabPEEK + 14, dx
    pop     di
    pop     si
    ret

@WriteVGA$quc   endp

TabPtrMode label   word
    dw      SetMode0
    dw      SetMode1
    dw      SetMode2
    dw      SetMode0

@GetEcran$qv    proc    near
    mov     ax, 0EH
    int     10h
    mov     dx, 3C0h
    mov     al, 31h
    out     dx, al
    mov     al, 0FFh
    out     dx, al
    mov     dx, 3C4h
    mov     al, 2
    out     dx, al
    mov     ax, 1
    ret
@GetEcran$qv    endp

@CloseEcran$qv  proc    near
    mov     ax, 3
    int     10h
    ret
@CloseEcran$qv  endp

@AllocMemCPC$qv proc    near
    push    ds
    push    offset DGROUP:_segdosAdrCPC
    push    02000h
    call    near ptr _allocmem
    add     sp, 6
    cmp     ax, 0FFFFh
    jne     FinAlloc

    mov     dx, seg _ROMINF
    mov     ax, offset _ROMINF
    mov     word ptr DGROUP:_TabPEEK + 2, dx
    mov     word ptr DGROUP:_TabPEEK, ax
    mov     dx, word ptr DGROUP:_segdosAdrCPC
    xor     ax, ax
    mov     word ptr DGROUP:_TabPOKE + 2, dx
    mov     word ptr DGROUP:_TabPOKE, ax
    add     dx, 0400H
    mov     word ptr DGROUP:_TabPEEK + 6, dx
    mov     word ptr DGROUP:_TabPEEK + 4, ax
    mov     word ptr DGROUP:_TabPOKE + 6, dx
    mov     word ptr DGROUP:_TabPOKE + 4, ax
    add     dx, 0400H
    mov     word ptr DGROUP:_TabPEEK + 10, dx
    mov     word ptr DGROUP:_TabPEEK + 8, ax
    mov     word ptr DGROUP:_TabPOKE + 10, dx
    mov     word ptr DGROUP:_TabPOKE + 8, ax
    add     dx, 0400H
    mov     word ptr DGROUP:_TabPOKE + 14, dx
    mov     word ptr DGROUP:_TabPOKE + 12, ax
    mov     word ptr DGROUP:_TabPEEK + 14, dx
    mov     word ptr DGROUP:_TabPEEK + 12, ax
    mov     ax, 1
    ret
FinAlloc:
    xor     ax, ax
    ret
@AllocMemCPC$qv endp

@FreeMemCPC$qv  proc    near
    push    word ptr DGROUP:_segdosAdrCPC
    call    near ptr _freemem
    add     sp, 2
    ret
@FreeMemCPC$qv  endp

_TEXT   ends

    public  @NewInt08$qve
    public  @WriteVGA$quc
    public  @GetEcran$qv, @CloseEcran$qv
    public  @AllocMemCPC$qv, @FreeMemCPC$qv
    public  _TabCoul, _TabDac
    public  _TabPOKE, _TabPEEK
    public  _DecodeurAdresse
    public  _segdosAdrCPC
    extrn   _FreqInt:word
    extrn   _IRQ:word
    extrn   _VBL:byte
    extrn   _DmdChgFic:byte
    extrn   _adrEcr:word
    extrn   _tabAdrMemEcrCPC:word
    extrn   _ROMDISC:byte, _ROMSUP:byte, _ROMINF:byte
    extrn   _freemem:near, _allocmem:near
    end
