#ifndef VGA_H
#define VGA_H


#include  <exec/types.h>
#include  <dos.h>


#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif


#define   ROMINF_SEL        0x01
#define   ROMSUP_SEL        0x02
#define   ROMDISC_SEL       0x04

#define   N_ROMINF_SEL      0xFE
#define   N_ROMSUP_SEL      0xFD
#define   N_ROMDISC_SEL     0xFB


extern USHORT segdosAdrCPC, adrEcr, DecodeurAdresse;

extern UBYTE * TabPEEK[];
extern UBYTE * TabPOKE[];
extern UBYTE TabDac[];

extern UBYTE far ROMINF[ 0x4000 ];
extern UBYTE far ROMSUP[ 0x4000 ];
extern UBYTE far ROMDISC[ 0x4000 ];

extern USHORT tabAdrMemEcrCPC[ 0x4000 ];


//
// Changement frquence Int08
//
inline void SetFreq( USHORT Freq )
{
    outportb( 0x40, Freq & 0xFF );
    outportb( 0x40, Freq >> 8 );
}


inline UBYTE PEEK8( USHORT adr )
{
    return TabPEEK[ adr >> 14 ][ adr & 0x3FFF ];
}


inline void POKE8( USHORT adr, UBYTE val )
{
    TabPOKE[ adr >> 14 ][ adr &0x3FFF ] = val;
}


inline void SetDac( USHORT dac, USHORT r, USHORT v, USHORT b )
{
    outportb( 0x3C8, TabDac[ dac ] );
    outportb( 0x3C9, r );
    outportb( 0x3C9, v );
    outportb( 0x3C9, b );
}


inline void ChangeROMInf( void )
{
    TabPEEK[ 0 ] = ( DecodeurAdresse & ROMINF_SEL ) ?
                   ROMINF :
                   ( UBYTE * )MK_FP( segdosAdrCPC, 0 );
}


inline void ChangeROMSup( void )
{
    TabPEEK[ 3 ] = ( DecodeurAdresse & ROMSUP_SEL ) ?
                       ( ( DecodeurAdresse & ROMDISC_SEL ) ?
                       ROMDISC :
                       ROMSUP
                       ) :
                   ( UBYTE * )MK_FP( segdosAdrCPC + 0xC00, 0 );
}


void WriteVGA( UBYTE val );

BOOL AllocMemCPC( void );

BOOL GetEcran( void );

void CloseEcran( void );

void FreeMemCPC( void );

void CalcAdrEcrCPC( void );

void AfficheTexte( char * Texte );


#endif
