/*****************************************************************************
 *                                                                           *
 * Module : FILEBAS.S                                                        *
 *                                                                           *
 * Gestion du file-requester pour changer de disquette CPC                   *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>
#include  <string.h>
#include  <alloc.h>
#include  <bios.h>
#include  <dos.h>
#include  <dir.h>

#include  "tools.h"
#include  "vga.h"


#define Color1     0x4E
#define Color2     0x9B

#define MAXFILES    256

#define POS_X        31
#define POS_Y         7


typedef struct
    {
    char    NomFic[ 13 ];
    USHORT  Type;
    } FileName;


extern UBYTE TabCoul[];


static FileName tab[ MAXFILES ];

static USHORT nbelt = 0;


//
// Affiche les fichiers du rpertoire courrant
//
static void AffFiles( SHORT rel )
{
    static char vide[ 20 ] = "                  ";
    char chaine[ 20 ];
    USHORT i;

    for ( i = 0; i < 10; i++ )
        {
        FileName * t = &tab[ i + rel ];
        memcpy( chaine, vide, 20 );
        if ( i + rel < nbelt )
            {
            memcpy( chaine
                  , t->NomFic
                  , strlen( t->NomFic )
                  );
            if ( t->Type & FA_DIREC )
                memcpy( chaine + 13, "<DIR>", 5 );
            }
        PutString( POS_X + 1, POS_Y + 1 + i, Color1, chaine );
        }
}


//
// Affiche le curseur aux coordonnes dsires
//
static void AfficheCurseur( USHORT yreel, USHORT Color )
{
    USHORT p = ( POS_X + 80 * ( POS_Y + 1 + yreel ) - 80 ) << 1;

    for ( USHORT j = 0; j < 18; j++, p += 2 )
        * ( UBYTE * )MK_FP( MemEcr, 1 + p ) = Color;
}


//
// Lit le rpertoire courrant et remplit le tableau tab
//
static void GetDir( void )
{
    struct ffblk fb;
    SHORT done;

    nbelt = 0;
    done = findfirst( "*.*", &fb, FA_DIREC );
    while ( ( nbelt < MAXFILES ) && ( ! done ) )
        {
        if ( ( fb.ff_attrib == FA_DIREC ) && ( strncmp( fb.ff_name, ".", 2 ) ) )
            {
            strcpy( tab[ nbelt ].NomFic, fb.ff_name );
            tab[ nbelt++ ].Type = fb.ff_attrib;
            }
        done = findnext( &fb );
        }
    done = findfirst( "*.*", &fb, FA_ARCH | FA_HIDDEN | FA_SYSTEM | FA_RDONLY );
    while ( ( nbelt < MAXFILES ) && ( ! done ) )
        {
        if ( strstr( fb.ff_name, ".CPC" ) || strstr( fb.ff_name, ".DSK" ) )
           {
           strcpy( tab[ nbelt ].NomFic, fb.ff_name );
           tab[ nbelt++ ].Type = fb.ff_attrib;
           }
        done = findnext( &fb );
        }
}


//
// Gestion file-requester, retourne le nom du fichier choisi
//
char * GetFile( void )
{
    USHORT i, c, rel = 0, cur = 0;
    struct REGPACK r;

    r.r_ax = 3;
    intr( 0x10, &r );
    r.r_ax = 0x1003;
    r.r_bx = 0;
    intr( 0x10, &r );
    r.r_ax = 0x100;
    r.r_cx = 0x100;
    intr( 0x10, &r );

    GetDir();

    PutString( POS_X, POS_Y, Color1, "ͻ" );
    for ( i = POS_Y + 1; i < POS_Y + 11; i++ )
        PutString( POS_X, i, Color1, "                  " );
    PutString( POS_X, POS_Y + 11, Color1, "ͼ" );

    AffFiles( rel );
    AfficheCurseur( cur, Color2 );
    do
        {
        c = bioskey( 0 );

        if ( c & 0xFF )
            c &= 0xFF;

        switch( c )
            {
            case 0x5100 :   // PG_DOWN
                for ( i = 0; i < 10; i++ )
                    if ( cur + rel < nbelt - 1 )
                       {
                       AfficheCurseur( cur, Color1 );
                       if ( cur < 9 )
                           cur++;
                       else
                           AffFiles( ++rel );

                           AfficheCurseur( cur, Color2 );
                       }
                break;

            case 0x4900 :   // PG_UP
                for ( i = 0; i < 10; i++ )
                    if ( cur + rel > 0 )
                        {
                        AfficheCurseur( cur, Color1 );
                        if ( cur > 0 )
                            cur--;
                        else
                            AffFiles( --rel );

                        AfficheCurseur( cur, Color2 );
                        }
                break;

            case 0x5000 :   // UP
                if ( cur + rel < nbelt - 1 )
                    {
                    AfficheCurseur( cur, Color1 );
                    if ( cur < 9 )
                        cur++;
                    else
                        AffFiles( ++rel );

                    AfficheCurseur( cur, Color2 );
                    }
                break;

            case 0x4800 :   // DOWN
                if ( cur + rel > 0 )
                    {
                    AfficheCurseur( cur, Color1 );
                    if ( cur > 0 )
                        cur--;
                    else
                        AffFiles( --rel );

                    AfficheCurseur( cur, Color2 );
                    }
                break;

            case 0x0D :
                if ( tab[ cur + rel ].Type == FA_DIREC )
                    {
                    chdir( tab[ cur + rel ].NomFic );
                    rel = 0;
                    GetDir();
                    AffFiles( rel );
                    cur = c = 0;
                    AfficheCurseur( cur, Color2 );
                    }
                break;
            }
        }
    while ( ( c != 0x0D ) && ( c != 0x1B ) );

    GetEcran();
    RedrawScreen();

    for ( i = 0; i < 16; i++ )
        {
        WriteVGA( i );
        WriteVGA( TabCoul[ i ] + 0x40 );
        }

    if ( c != 0x1B )
        return( tab[ cur + rel ].NomFic );

    return( 0 );
}
