/*****************************************************************************
 *                                                                           *
 * Module : MAIN.C                                                           *
 *                                                                           *
 * Module principal, gestion du noyau du Z80, des interruptions...           *
 *                                                                           *
 *****************************************************************************/


#include  <stdio.h>
#include  <fcntl.h>
#include  <bios.h>
#include  <dos.h>
#include  <mem.h>
#include  <io.h>

#include  "fctfirst.h"
#include  "filebas.h"
#include  "debug.h"
#include  "tools.h"
#include  "regs.h"
#include  "vga.h"
#include  "ppi.h"
#include  "upd.h"

FILE * out;
#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif


#define AFFICHE            1
#define EXECUTE            2


extern pfct tabinstr[];

extern UBYTE TabCoul[];

extern UBYTE * segAdrCPC;

extern UBYTE IFF1;          // Interrupt enable Flip Flop

extern USHORT ErrED, ErrIX, ErrIY, Bit4, Bit5;

USHORT finMain = 1;
UBYTE DmdChgFic = 0;
UBYTE Reset = 0;
UBYTE VBL = 0;

volatile int IRQ = 0;

USHORT volatile FreqInt = 3977;

#ifdef DEBUG
extern char * SetChaine( USHORT adr );
#endif

static void interrupt ( * oldhandler )( __CPPARGS );


//
// Changement frquence Int08
//
inline void SetFreq( USHORT Freq )
{
    outportb( 0x40, Freq & 0xFF );
    outportb( 0x40, Freq >> 8 );
}


//
// Nouvelle interruption 08
//
static void interrupt NewInt08( __CPPARGS )
{
    static UBYTE r = 6;

    if ( ++r > 5 )
        {
        r = 0;
        VBL = 1;
        }
    else
        VBL = 0;
    IRQ = 1;
    SetFreq( FreqInt );
    outportb( 0x20, 0x20 );
}


static void InstalleInt08( void )
{
    oldhandler = getvect( 8 );
    while( ! ( inportb( 0x3DA ) & 8 ) )
        ;
    setvect( 8, NewInt08 );
}


static void RestoreInt08( void )
{
    SetFreq( 0xFFFFU );
    setvect( 8, oldhandler );
}

inline void TraiteIRQ( void )
{
    IRQ = 0;
    if ( IFF1 ) // EI ?
        {
        POKE8( --RegSP, PC.Byte.High );
        POKE8( --RegSP, PC.Byte.Low );
        RegPC = 0x38;
    }
}


//
// Noyau: Excution d'une instruction Z80
//
static void ExecZ80( void )
{
    do
        {
        do
            {
            if ( IRQ )  // Interruption ?
                {
                TraiteIRQ();
#ifdef DEBUG
                AfficheTexte( SetChaine( RegPC ) );
#endif
                }
            IR.Byte.Low += 2;
            tabinstr[ PEEK8( RegPC++ ) ]();
            }
        while( ! finMain );

        if ( Reset )
            {
            WriteVGA( 0x89 );
            finMain = 0;
            RegPC = 0;
            IFF1 = 0;
            Reset = 0;
            }
        if ( DmdChgFic ) // Changement de fichier disquette
            {
            finMain = 0;
            RestoreIntClavierPPI();
            char * p = GetFile();
            if ( p )
                {
                EndUPD();
                InitUPD( p );
                }
            InstalleIntClavierPPI();
            DmdChgFic = 0;
            }
        }
    while( ! finMain );
}


static char * Hex( UBYTE val )
{
    static char * s = "0123456789ABCDEF";
    static char * r = "??";

    r[ 0 ] = s[ val >> 4 ];
    r[ 1 ] = s[ val & 15 ];
    return r;
}


void main( int argc, char **argv )
{
    if ( argc == 2 )
        InitUPD( argv[ 1 ] );
    else
        InitUPD( "DISC.DSK" );

        if ( AllocMemCPC() )
            {
            if ( GetEcran() )
                {
                InstalleInt08();
                InstalleIntClavierPPI();
                ExecZ80();
                RestoreIntClavierPPI();
                RestoreInt08();
#ifdef DEBUG
                USHORT c, tmp;

                do
                    {
                    AfficheTexte( SetChaine( RegPC ) );
                    IR.Byte.Low++;
                    tabinstr[ PEEK8( RegPC++ ) ]();
                    VBL++;
                    c = bioskey( 0 ) & 0xFF;
                    switch( c )
                        {
                        case ' ' :
                            tmp = RegSP;
                            while( tmp == RegSP )
                                {
                                IR.Byte.Low++;
                                tabinstr[ PEEK8( RegPC++ ) ]();
                                VBL++;
                                }
                            break;

                        case '0' :
                            for ( tmp = 0; tmp < 1000; tmp++ )
                                {
                                IR.Byte.Low++;
                                tabinstr[ PEEK8( RegPC++ ) ]();
                                VBL++;
                                }
                            break;

                        case '1' :
                            for ( tmp = 0; tmp < 10000; tmp++ )
                                {
                                IR.Byte.Low++;
                                tabinstr[ PEEK8( RegPC++ ) ]();
                                VBL++;
                                }
                            break;

                        }

                    }
                while( c != 0x1B );
#endif
                CloseEcran();
                }
            FreeMemCPC();
            }
    EndUPD();
#ifdef SOUND
    nosound();
#endif
#ifdef DEBUG
    printf( "FreqInt = %d\n", FreqInt );
#endif
    if ( ErrED != 0xFFFF )
        {
        PutString( 1, 7, 15, "ED" );
        PutString( 4, 7, 15, Hex( ErrED ) );
        }
    if ( ErrIX != 0xFFFF )
        {
        PutString( 1, 8, 15, "DD" );
        PutString( 4, 8, 15, Hex( ErrIX ) );
        }
    if ( ErrIY != 0xFFFF )
        {
        PutString( 1, 9, 15, "FD" );
        PutString( 4, 9, 15, Hex( ErrIY ) );
        }
#ifdef DEBUG
    if ( Bit4 )
        {
        PutString( 1, 10, 15, "BIT4" );
        }
    if ( Bit5 )
        {
        PutString( 10, 10, 15, "BIT5" );
        }
#endif
}
