#include  <typesvar.h>
#include  <stdio.h>
#include  <string.h>


#define SECTSIZE   512
#define NBSECT     9

typedef UCHAR ( * pfctUPD )( UCHAR );

typedef struct
    {
    UCHAR C;
    UCHAR H;
    UCHAR R;
    UCHAR N;
    UCHAR datas[ SECTSIZE ];
    } StSect;

typedef struct
    {
    StSect Sect[ NBSECT ];
    } StTrack;

typedef struct
    {
    UCHAR User;
    UCHAR Nom[ 8 ];
    UCHAR Ext[ 3 ];
    UCHAR NumPage;
    UCHAR Unused[ 2 ];
    UCHAR NbPages;
    UCHAR Blocks[ 16 ];
    } StDirEntry;


static FILE * fp = 0;

static StTrack CurrTrackDatas;


static void ReadTrack( UCHAR newTrack, StTrack * CurrTrackDatas )
{
    if ( fp )
        {
        fseek( fp, ( ULONG )newTrack * sizeof( * CurrTrackDatas ), SEEK_SET );
        fread( CurrTrackDatas, sizeof( * CurrTrackDatas ), 1, fp );
        }
}


static PCHAR ReadBloc( USHORT bloc )
{
    static CHAR buffer[ SECTSIZE * 2 ];
    USHORT track = ( bloc << 1 ) / 9;
    USHORT sect = ( bloc << 1 ) % 9;

    ReadTrack( track, &CurrTrackDatas );
    memcpy( buffer, &CurrTrackDatas.Sect[ sect ].datas[ 0 ], SECTSIZE );
    if ( ++sect > 8 )
        {
        ReadTrack( ++track, &CurrTrackDatas );
        sect = 0;
        }

    memcpy( buffer + SECTSIZE
          , &CurrTrackDatas.Sect[ sect ].datas[ 0 ]
          , SECTSIZE
          );

    return buffer;
}


static void ExtDir( void )
{
    static StTrack Track0;
    static StDirEntry Dir;
    CHAR nom[ 14 ];
    PCHAR p;
    USHORT i, j, s, l;
    FILE * fout = NULL;

    ReadTrack( 0, &Track0 );
    for ( s = 0; s < 4; s++ )
        for ( i = 0; i < 16; i++ )
            {
            memcpy( &Dir
                  , &Track0.Sect[ s ].datas[ i * sizeof( Dir ) ]
                  , sizeof( Dir )
                  );
            if ( Dir.User != 0xE5 )
                {
                memcpy( nom, Dir.Nom, 8 );
                memcpy( nom + 9, Dir.Ext, 3 );
                nom[ 8 ] = '.';
                nom[ 12 ] = 0;
                printf( "%3d - %s - %d - ", Dir.User, nom, Dir.NumPage );
                l = ( Dir.NbPages + 7 ) >> 3;
                if ( ! Dir.NumPage )
                    {
                    fclose( fout );
                    fout = fopen( nom, "wb" );
                    }
                for ( j = 0; j < l; j++ )
                    {
                    printf( "%02X ", Dir.Blocks[ j ] );
                    p = ReadBloc( Dir.Blocks[ j ] );
                    fwrite( p, 1024, 1, fout );
                    }
                printf( "\n" );
                }
            }
    fclose( fout );
}


void main( int argc, char ** argv )
{
    if ( argc == 2 )
        {
        fp = fopen( *++argv, "rb+" );
        ExtDir();
        fclose( fp );
        }
}
