/*****************************************************************************
 *                                                                           *
 * Module : PPI.C                                                            *
 *                                                                           *
 * Gestion du PPI 8255 et du PSG AY3 8912                                    *
 *                                                                           *
 *****************************************************************************/


#include  <Exec/Types.h>
#include  <Dos.h>
#include  <Mem.h>

#include  "regs.h"
#include  "vga.h"


#define CONSTRUCTEUR    0x5E    // valeurs possibles :
                                // 0x50 = Isp
                                // 0x52 = Triumph
                                // 0x54 = Saisho
                                // 0x56 = Solavox
                                // 0x58 = Awa
                                // 0x5A = Schneider
                                // 0x5C = Orion
                                // 0x5E = Amstrad



extern UBYTE VBL;
extern UBYTE DmdChgFic;
extern USHORT finMain;
extern UBYTE Reset;
extern USHORT FreqInt;


#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif


typedef struct
    {
    UBYTE valPortA;
    UBYTE valLigne;
    } stToucheClav;


static stToucheClav tabTouches[] =
    {
        { 0xFF, 0x0F },           // 0x00
        { 0xFB, 0x08 },           // ESC
        { 0xFE, 0x08 },           // '1'
        { 0xFD, 0x08 },           // '2'
        { 0xFD, 0x07 },           // '3'
        { 0xFE, 0x07 },           // '4'
        { 0xFD, 0x06 },           // '5'
        { 0xFE, 0x06 },           // '6'
        { 0xFD, 0x05 },           // '7'
        { 0xFE, 0x05 },           // '8'
        { 0xFD, 0x04 },           // '9'
        { 0xFE, 0x04 },           // '0'
        { 0xFD, 0x03 },           // ')'
        { 0xFE, 0x03 },           // '='
        { 0x7F, 0x09 },           // DEL
        { 0xEF, 0x08 },           // TAB
        { 0xF7, 0x08 },           // 'A'
        { 0xF7, 0x07 },           // 'Z'
        { 0xFB, 0x07 },           // 'E'
        { 0xFB, 0x06 },           // 'R'
        { 0xF7, 0x06 },           // 'T'
        { 0xF7, 0x05 },           // 'Y'
        { 0xFB, 0x05 },           // 'U'
        { 0xF7, 0x04 },           // 'I'
        { 0xFB, 0x04 },           // 'O'
        { 0xF7, 0x03 },           // 'P'
        { 0xFB, 0x03 },           // '^'
        { 0xFD, 0x02 },           // ''
        { 0xFB, 0x02 },           // ENTER
        { 0x7F, 0x02 },           // CTRL
        { 0xDF, 0x08 },           // 'Q'
        { 0xEF, 0x07 },           // 'S'
        { 0xDF, 0x07 },           // 'D'
        { 0xDF, 0x06 },           // 'F'
        { 0xEF, 0x06 },           // 'G'
        { 0xEF, 0x05 },           // 'H'
        { 0xDF, 0x05 },           // 'J'
        { 0xDF, 0x04 },           // 'K'
        { 0xEF, 0x04 },           // 'L'
        { 0xDF, 0x03 },           // 'M'
        { 0xEF, 0x03 },           // ''
        { 0xFF, 0x0F },           // 0x00
        { 0xDF, 0x02 },           // SHIFT gauche
        { 0xF7, 0x02 },           // '*'
        { 0x7F, 0x08 },           // 'W'
        { 0x7F, 0x07 },           // 'X'
        { 0xBF, 0x07 },           // 'C'
        { 0x7F, 0x06 },           // 'V'
        { 0xBF, 0x06 },           // 'B'
        { 0xBF, 0x05 },           // 'N'
        { 0xBF, 0x04 },           // ','
        { 0x7F, 0x04 },           // ';'
        { 0x7F, 0x03 },           // ':'
        { 0xBF, 0x03 },           // '!'
        { 0xDF, 0x02 },           // SHIFT droite
        { 0xEF, 0x09 },           // '*'                -> Joy Fire
        { 0xFD, 0x01 },           // ALT -> COPY
        { 0x7F, 0x05 },           // ' '
        { 0xBF, 0x08 },           // CAPS LOCK
        { 0xFF, 0x0F },           // F1
        { 0xFB, 0x09 },           // F2                 -> Joy Left
        { 0xF7, 0x09 },           // F3                 -> Joy Right
        { 0xFD, 0x09 },           // F4                 -> Joy Down
        { 0xFE, 0x09 },           // F5                 -> Joy Up
        { 0xFF, 0x0F },           // F6
        { 0xFF, 0x0F },           // F7
        { 0xFF, 0x0F },           // F8
        { 0xFF, 0x0F },           // F9
        { 0xFF, 0x0F },           // F10
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFB, 0x01 },           // P'7'
        { 0xF7, 0x01 },           // P'8'
        { 0xF7, 0x00 },           // P'9'
        { 0xFF, 0x0F },           // P'-'
        { 0xEF, 0x02 },           // P'4'
        { 0xEF, 0x01 },           // P'5'
        { 0xEF, 0x00 },           // P'6'
        { 0xFF, 0x0F },           // P'+'
        { 0xDF, 0x01 },           // P'1'
        { 0xBF, 0x01 },           // P'2'
        { 0xDF, 0x00 },           // P'3'
        { 0x7F, 0x01 },           // P'0'
        { 0x7F, 0x00 },           // P'.'
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xBF, 0x02 },           // '$'
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
    };

static stToucheClav tabTouchesExt[] =
    {
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x01
        { 0xFF, 0x0F },           // 0x02
        { 0xFF, 0x0F },           // 0x03
        { 0xFF, 0x0F },           // 0x04
        { 0xFF, 0x0F },           // 0x05
        { 0xFF, 0x0F },           // 0x06
        { 0xFF, 0x0F },           // 0x07
        { 0xFF, 0x0F },           // 0x08
        { 0xFF, 0x0F },           // 0x09
        { 0xFF, 0x0F },           // 0x0A
        { 0xFF, 0x0F },           // 0x0B
        { 0xFF, 0x0F },           // 0x0C
        { 0xFF, 0x0F },           // 0x0D
        { 0xFF, 0x0F },           // 0x0E
        { 0xFF, 0x0F },           // 0x0F
        { 0xFF, 0x0F },           // 0x10
        { 0xFF, 0x0F },           // 0x11
        { 0xFF, 0x0F },           // 0x12
        { 0xFF, 0x0F },           // 0x13
        { 0xFF, 0x0F },           // 0x14
        { 0xFF, 0x0F },           // 0x15
        { 0xFF, 0x0F },           // 0x16
        { 0xFF, 0x0F },           // 0x17
        { 0xFF, 0x0F },           // 0x18
        { 0xFF, 0x0F },           // 0x19
        { 0xFF, 0x0F },           // 0x1A
        { 0xFF, 0x0F },           // 0x1B
        { 0xBF, 0x00 },           // ENTER
        { 0x7F, 0x02 },           // CTRL
        { 0xFF, 0x0F },           // 0x1E
        { 0xFF, 0x0F },           // 0x1F
        { 0xFF, 0x0F },           // 0x20
        { 0xFF, 0x0F },           // 0x21
        { 0xFF, 0x0F },           // 0x22
        { 0xFF, 0x0F },           // 0x23
        { 0xFF, 0x0F },           // 0x24
        { 0xFF, 0x0F },           // 0x25
        { 0xFF, 0x0F },           // 0x26
        { 0xFF, 0x0F },           // 0x27
        { 0xFF, 0x0F },           // 0x28
        { 0xFF, 0x0F },           // 0x29
        { 0xFF, 0x0F },           // 0x2A
        { 0xFF, 0x0F },           // 0x2B
        { 0xFF, 0x0F },           // 0x2C
        { 0xFF, 0x0F },           // 0x2D
        { 0xFF, 0x0F },           // 0x2E
        { 0xFF, 0x0F },           // 0x2F
        { 0xFF, 0x0F },           // 0x30
        { 0xFF, 0x0F },           // 0x31
        { 0xFF, 0x0F },           // 0x32
        { 0xFF, 0x0F },           // 0x33
        { 0xFF, 0x0F },           // 0x34
        { 0xFF, 0x0F },           // 0x35
        { 0xFF, 0x0F },           // 0x36
        { 0xFF, 0x0F },           // 0x37
        { 0xFF, 0x0F },           // 0x38
        { 0xFF, 0x0F },           // 0x39
        { 0xFF, 0x0F },           // 0x3A
        { 0xFF, 0x0F },           // 0x3B
        { 0xFF, 0x0F },           // 0x3C
        { 0xFF, 0x0F },           // 0x3D
        { 0xFF, 0x0F },           // 0x3E
        { 0xFF, 0x0F },           // 0x3F
        { 0xFF, 0x0F },           // 0x40
        { 0xFF, 0x0F },           // 0x41
        { 0xFF, 0x0F },           // 0x42
        { 0xFF, 0x0F },           // 0x43
        { 0xFF, 0x0F },           // 0x44
        { 0xFF, 0x0F },           // 0x45
        { 0xFF, 0x0F },           // 0x46
        { 0xFF, 0x0F },           // 0x47
        { 0xFE, 0x00 },           // Fleche Haut
        { 0xFF, 0x0F },           // 0x49
        { 0xFF, 0x0F },           // 0x4A
        { 0xFE, 0x01 },           // Fleche Gauche
        { 0xFF, 0x0F },           // 0x4C
        { 0xFD, 0x00 },           // Fleche Droite
        { 0xFF, 0x0F },           // 0x4E
        { 0xFF, 0x0F },           // 0x4F
        { 0xFB, 0x00 },           // Fleche Bas
        { 0xFF, 0x0F },           // 0x51
        { 0xFF, 0x0F },           // 0x52
        { 0xFE, 0x02 },           // SUPPR
        { 0xFF, 0x0F },           // 0x54
        { 0xFF, 0x0F },           // 0x55
        { 0xFF, 0x0F },           // 0x56
        { 0xFF, 0x0F },           // 0x57
        { 0xFF, 0x0F },           // 0x58
        { 0xFF, 0x0F },           // 0x59
        { 0xFF, 0x0F },           // 0x5A
        { 0xFF, 0x0F },           // 0x5B
        { 0xFF, 0x0F },           // 0x5C
        { 0xFF, 0x0F },           // 0x5D
        { 0xFF, 0x0F },           // 0x5E
        { 0xFF, 0x0F },           // 0x5F
        { 0xFF, 0x0F },           // 0x60
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
        { 0xFF, 0x0F },           // 0x00
    };

static UBYTE clav[ 16 ];

static UBYTE TabRegsPSG[ 16 ];

static void interrupt ( * oldhandler )( __CPPARGS );

static UBYTE modePSG = 0, numReg = 0, portA = 0, ligneClav = 0;


//
// Lecture touche PC, transfert tableau touches CPC
//
void interrupt GestionTouche( __CPPARGS )
{
    static stToucheClav * Tab = tabTouches;

    UBYTE al = inportb( 0x60 );

    if ( al == 0xE0 )
        Tab = tabTouchesExt;
    else
        {
        UBYTE l = Tab[ al & 0x7F ].valLigne;
        UBYTE c = Tab[ al & 0x7F ].valPortA;
        Tab = tabTouches;

        switch( al )
            {
            case 0x3B :         // F1
                DmdChgFic = 1;
                finMain = 1;
                break;

            case 0x41 :         // F7
                FreqInt--;
                break;

            case 0x42 :         // F8
                FreqInt++;
                break;

            case 0x44 :         // F10
                Reset = 1;
                finMain = 1;
                break;

            case 0x58 :         // F12
                finMain = 1;
                break;
            }
        if ( ! ( al & 0x80 ) )
            clav[ l ] &= c;
        else
            clav[ l ] |= ~c;
        }
    al = inportb( 0x61 );
    outportb( 0x61, al | 0x80 );
    outportb( 0x61, al );
    outportb( 0x20, 0x20 );
}


void InstalleIntClavierPPI( void )
{
    memset( clav, 0xFF, sizeof( clav ) );
    memset( TabRegsPSG, 0xFF, sizeof( TabRegsPSG ) );
    finMain = 0;
    disable();
    oldhandler = getvect( 9 );
    setvect( 9, GestionTouche );
    enable();
}


void RestoreIntClavierPPI( void )
{
    setvect( 9, oldhandler );
}


void WritePPI( USHORT adr, UBYTE val )
{
    switch( ( adr >> 8 ) & 3 )
        {
        case 0 :
            portA = val;
            break;

        case 2 :
            {
            modePSG = val & 0xC0;
            ligneClav = val & 15;

            switch( modePSG )
                {
                case 0x40:
                    TabRegsPSG[ 14 ] = clav[ ligneClav ];
                    portA = TabRegsPSG[ numReg ];
                    break;

                case 0x80:
                    TabRegsPSG[ numReg ] = portA;
                    //
                    // Inclure la gestion des sons ici
                    //
#ifdef SOUND
                    switch( numReg )
                        {
                        case 10:
                            if ( portA > 7 )
                                {
                                USHORT p = TabRegsPSG[ 4 ] + ( TabRegsPSG[ 5 ] << 8 );
                                if ( p )
                                    sound( 62500U / p );
                                else
                                    nosound();
                                }
                            else
                                nosound();
                            break;

                        case 8 :
                            if ( portA > 7 )
                                {
                                USHORT p = TabRegsPSG[ 0 ] + ( TabRegsPSG[ 1 ] << 8 );
                                if ( p )
                                    sound( 62500U / p );
                                else
                                    nosound();
                                }
                            else
                                nosound();
                            break;

                        case 9 :
                            if ( portA > 7 )
                                {
                                USHORT p = TabRegsPSG[ 2 ] + ( TabRegsPSG[ 3 ] << 8 );
                                if ( p )
                                    sound( 62500U / p );
                                else
                                    nosound();
                                }
                            else
                                nosound();
                            break;
                        }
#endif
                    break;

                case 0xC0 :
                    numReg = portA;
                    break;
                }
            break;
            }
        case 3 :
            break;
        }
}


UBYTE ReadPPI( USHORT adr )
{
    switch( ( adr >> 8 ) & 3 )
        {
        case 0 :
            return portA;

        case 1 :
            return VBL | CONSTRUCTEUR;

        case 2 :
            return modePSG;
        }
    return 0xFF;
}
