#ifndef TOOLS_H
#define TOOLS_H


#include  <exec/types.h>

#include  "regs.h"


#define MemEcr   0xB800


typedef void ( * pfct )( void );


extern "C"
    {
    void ADD_R8( UBYTE );
    void ADC_R8( UBYTE );
    void SUB_R8( UBYTE );
    void SBC_R8( UBYTE );
    void CP_R8( UBYTE );
    void DAA( void );
    };


inline void FLAG_INC( USHORT reg )
{
    FLAGS &= FLAG_C;  // garder seulement C

    if ( reg == FLAG_S )
        FLAGS |= FLAG_V;

    if ( reg & FLAG_S )
        FLAGS |= FLAG_S;

    if ( ! reg )
        FLAGS |= FLAG_Z;
}


inline void FLAG_DEC( USHORT reg )
{
    FLAGS = ( FLAGS & FLAG_C ) | FLAG_N;  // garder seulement C
                                          // et positionner N
    if ( reg == FLAG_S )
        FLAGS |= FLAG_V;

    if ( reg & FLAG_S )
        FLAGS |= FLAG_S;

    if ( ! reg )
        FLAGS |= FLAG_Z;
}


extern UBYTE Tab_Parite[ 256 ];


void PutString( SHORT x, SHORT y, SHORT c, char * s );


#endif
