/*****************************************************************************
 *                                                                           *
 * Module : FCTCB.C                                                          *
 *                                                                           *
 * Fonctions grant les instructions Z80 aprs le code OP. CB : manipulation *
 * de bits, rotations, dcalages                                             *
 *                                                                           *
 *****************************************************************************/


#include  <exec/types.h>

#include  "regs.h"
#include  "tools.h"
#include  "vga.h"


#define     BIT0        0x01
#define     BIT1        0x02
#define     BIT2        0x04
#define     BIT3        0x08
#define     BIT4        0x10
#define     BIT5        0x20
#define     BIT6        0x40
#define     BIT7        0x80

#define     N_BIT0      0xFE
#define     N_BIT1      0xFD
#define     N_BIT2      0xFB
#define     N_BIT3      0xF7
#define     N_BIT4      0xEF
#define     N_BIT5      0xDF
#define     N_BIT6      0xBF
#define     N_BIT7      0x7F



static void CB_00( void )   /* RLC B */
{
    FLAGS = RegB >> 7;
    RegB = ( RegB << 1 ) | FLAGS;
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_01( void )   /* RLC C */
{
    FLAGS = RegC >> 7;
    RegC = ( RegC << 1 ) | FLAGS;
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_02( void )   /* RLC D */
{
    FLAGS = RegD >> 7;
    RegD = ( RegD << 1 ) | FLAGS;
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_03( void )   /* RLC E */
{
    FLAGS = RegE >> 7;
    RegE = ( RegE << 1 ) | FLAGS;
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_04( void )   /* RLC H */
{
    FLAGS = RegH >> 7;
    RegH = ( RegH << 1 ) | FLAGS;
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_05( void )   /* RLC L */
{
    FLAGS = RegL >> 7;
    RegL = ( RegL << 1 ) | FLAGS;
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_06( void )   /* RLC (HL) */
{
    UBYTE hl = PEEK8( RegHL );
    FLAGS = hl >> 7;
    POKE8( RegHL , hl = ( ( hl << 1 ) | FLAGS ) );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_07( void )   /* RLC A */
{
    FLAGS = RegA >> 7;
    RegA = ( RegA << 1 ) | FLAGS;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_08( void )   /* RRC B */
{
    FLAGS = RegB & FLAG_C;
    RegB = ( RegB >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_09( void )   /* RRC C */
{
    FLAGS = RegC & FLAG_C;
    RegC = ( RegC >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_0A( void )   /* RRC D */
{
    FLAGS = RegD & FLAG_C;
    RegD = ( RegD >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_0B( void )   /* RRC E */
{
    FLAGS = RegE & FLAG_C;
    RegE = ( RegE >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_0C( void )   /* RRC H */
{
    FLAGS = RegH & FLAG_C;
    RegH = ( RegH >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_0D( void )   /* RRC L */
{
    FLAGS = RegL & FLAG_C;
    RegL = ( RegL >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_0E( void )   /* RRC (HL) */
{
    UBYTE hl = PEEK8( RegHL );
    FLAGS = hl & FLAG_C;
    POKE8( RegHL, hl = ( hl >> 1 ) | ( FLAGS << 7 ) );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_0F( void )   /* RRC A */
{
    FLAGS = RegA & FLAG_C;
    RegA = ( RegA >> 1 ) | ( FLAGS << 7 );
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_10( void )   /* RL B */
{
    register USHORT i = RegB << 1;
    RegB = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_11( void )   /* RL C */
{
    register USHORT i = RegC << 1;
    RegC = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_12( void )   /* RL D */
{
    register USHORT i = RegD << 1;
    RegD = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_13( void )   /* RL E */
{
    register USHORT i = RegE << 1;
    RegE = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_14( void )   /* RL H */
{
    register USHORT i = RegH << 1;
    RegH = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_15( void )   /* RL L */
{
    register USHORT i = RegL << 1;
    RegL = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_16( void )   /* RL (HL) */
{
    UBYTE hl = PEEK8( RegHL );
    register USHORT i = hl << 1;
    POKE8( RegHL, hl = i | ( FLAGS & FLAG_C ) );
    FLAGS = i >> 8;
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_17( void )   /* RL A */
{
    register USHORT i = RegA << 1;
    RegA = i | ( FLAGS & FLAG_C );
    FLAGS = i >> 8;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_18( void )   /* RR B */
{
    register USHORT i = ( RegB >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegB & FLAG_C;
    RegB = i;
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_19( void )   /* RR C */
{
    register USHORT i = ( RegC >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegC & FLAG_C;
    RegC = i;
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_1A( void )   /* RR D */
{
    register USHORT i = ( RegD >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegD & FLAG_C;
    RegD = i;
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_1B( void )   /* RR E */
{
    register USHORT i = ( RegE >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegE & FLAG_C;
    RegE = i;
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_1C( void )   /* RR H */
{
    register USHORT i = ( RegH >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegH & FLAG_C;
    RegH = i;
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_1D( void )   /* RR L */
{
    register USHORT i = ( RegL >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegL & FLAG_C;
    RegL = i;
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_1E( void )   /* RR HL */
{
    UBYTE hl = PEEK8( RegHL );
    register USHORT i = ( hl >> 1 ) | ( FLAGS << 7 );
    FLAGS = hl & FLAG_C;
    POKE8( RegHL, hl = i );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_1F( void )   /* RR A */
{
    register USHORT i = ( RegA >> 1 ) | ( FLAGS << 7 );
    FLAGS = RegA & FLAG_C;
    RegA = i;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_20( void )   /* SLA B */
{
    FLAGS = RegB >> 7;
    RegB = RegB << 1;
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_21( void )   /* SLA C */
{
    FLAGS = RegC >> 7;
    RegC = RegC << 1;
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_22( void )   /* SLA D */
{
    FLAGS = RegD >> 7;
    RegD = RegD << 1;
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_23( void )   /* SLA E */
{
    FLAGS = RegE >> 7;
    RegE = RegE << 1;
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_24( void )   /* SLA H */
{
    FLAGS = RegH >> 7;
    RegH = RegH << 1;
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_25( void )   /* SLA L */
{
    FLAGS = RegL >> 7;
    RegL = RegL << 1;
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_26( void )   /* SLA (HL) */
{
    UBYTE hl = PEEK8( RegHL );
    FLAGS = hl >> 7;
    POKE8( RegHL, hl = hl << 1 );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_27( void )   /* SLA A */
{
    FLAGS = RegA >> 7;
    RegA = RegA << 1;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_28( void )   /* SRA B */
{
    FLAGS = RegB & FLAG_C;
    RegB = ( RegB >> 1 ) | ( RegB & FLAG_S );
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_29( void )   /* SRA C */
{
    FLAGS = RegC & FLAG_C;
    RegC = ( RegC >> 1 ) | ( RegC & FLAG_S );
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_2A( void )   /* SRA D */
{
    FLAGS = RegD & FLAG_C;
    RegD = ( RegD >> 1 ) | ( RegD & FLAG_S );
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_2B( void )   /* SRA E */
{
    FLAGS = RegE & FLAG_C;
    RegE = ( RegE >> 1 ) | ( RegE & FLAG_S );
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_2C( void )   /* SRA H */
{
    FLAGS = RegH & FLAG_C;
    RegH = ( RegH >> 1 ) | ( RegH & FLAG_S );
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_2D( void )   /* SRA L */
{
    FLAGS = RegL & FLAG_C;
    RegL = ( RegL >> 1 ) | ( RegL & FLAG_S );
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_2E( void )   /* SRA (HL) */
{
    UBYTE hl = PEEK8( RegHL );
    FLAGS = hl & FLAG_C;
    POKE8( RegHL, hl = ( hl >> 1 ) | ( hl & FLAG_S ) );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_2F( void )   /* SRA A */
{
    FLAGS = RegA & FLAG_C;
    RegA = ( RegA >> 1 ) | ( RegA & FLAG_S );
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_38( void )   /* SRL B */
{
    FLAGS = RegB & FLAG_C;
    RegB = RegB >> 1;
    FLAGS |= ( RegB & FLAG_S );
    if ( ! RegB )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegB ];
}


static void CB_39( void )   /* SRL C */
{
    FLAGS = RegC & FLAG_C;
    RegC = RegC >> 1;
    FLAGS |= ( RegC & FLAG_S );
    if ( ! RegC )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegC ];
}


static void CB_3A( void )   /* SRL D */
{
    FLAGS = RegD & FLAG_C;
    RegD = RegD >> 1;
    FLAGS |= ( RegD & FLAG_S );
    if ( ! RegD )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegD ];
}


static void CB_3B( void )   /* SRL E */
{
    FLAGS = RegE & FLAG_C;
    RegE = RegE >> 1;
    FLAGS |= ( RegE & FLAG_S );
    if ( ! RegE )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegE ];
}


static void CB_3C( void )   /* SRL H */
{
    FLAGS = RegH & FLAG_C;
    RegH = RegH >> 1;
    FLAGS |= ( RegH & FLAG_S );
    if ( ! RegH )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegH ];
}


static void CB_3D( void )   /* SRL L */
{
    FLAGS = RegL & FLAG_C;
    RegL = RegL >> 1;
    FLAGS |= ( RegL & FLAG_S );
    if ( ! RegL )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegL ];
}


static void CB_3E( void )   /* SRL HL */
{
    UBYTE hl = PEEK8( RegHL );
    FLAGS = hl & FLAG_C;
    POKE8( RegHL, hl = hl >> 1 );
    FLAGS |= ( hl & FLAG_S );
    if ( ! hl )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ hl ];
}


static void CB_3F( void )   /* SRL A */
{
    FLAGS = RegA & FLAG_C;
    RegA = RegA >> 1;
    FLAGS |= ( RegA & FLAG_S );
    if ( ! RegA )
        FLAGS |= FLAG_Z;
    FLAGS |= Tab_Parite[ RegA ];
}


static void CB_40( void )      /* BIT 0,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_48( void )      /* BIT 1,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_50( void )      /* BIT 2,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_58( void )      /* BIT 3,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_60( void )      /* BIT 4,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_68( void )      /* BIT 5,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_70( void )      /* BIT 6,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_78( void )      /* BIT 7,B */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegB & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_41( void )      /* BIT 0,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_49( void )      /* BIT 1,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_51( void )      /* BIT 2,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_59( void )      /* BIT 3,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_61( void )      /* BIT 4,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_69( void )      /* BIT 5,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_71( void )      /* BIT 6,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_79( void )      /* BIT 7,C */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegC & BIT7 )
        FLAGS &= N_FLAG_Z;
}

static void CB_42( void )      /* BIT 0,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4A( void )      /* BIT 1,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_52( void )      /* BIT 2,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5A( void )      /* BIT 3,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_62( void )      /* BIT 4,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6A( void )      /* BIT 5,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_72( void )      /* BIT 6,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7A( void )      /* BIT 7,D */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegD & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_43( void )      /* BIT 0,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4B( void )      /* BIT 1,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_53( void )      /* BIT 2,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5B( void )      /* BIT 3,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_63( void )      /* BIT 4,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6B( void )      /* BIT 5,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_73( void )      /* BIT 6,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7B( void )      /* BIT 7,E */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegE & BIT7 )
        FLAGS &= N_FLAG_Z;
}

static void CB_44( void )      /* BIT 0,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4C( void )      /* BIT 1,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_54( void )      /* BIT 2,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5C( void )      /* BIT 3,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_64( void )      /* BIT 4,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6C( void )      /* BIT 5,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_74( void )      /* BIT 6,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7C( void )      /* BIT 7,H */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegH & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_45( void )      /* BIT 0,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4D( void )      /* BIT 1,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_55( void )      /* BIT 2,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5D( void )      /* BIT 3,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_65( void )      /* BIT 4,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6D( void )      /* BIT 5,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_75( void )      /* BIT 6,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7D( void )      /* BIT 7,L */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegL & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_46( void )      /* BIT 0,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4E( void )      /* BIT 1,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_56( void )      /* BIT 2,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5E( void )      /* BIT 3,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_66( void )      /* BIT 4,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6E( void )      /* BIT 5,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_76( void )      /* BIT 6,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7E( void )      /* BIT 7,(HL) */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( PEEK8( RegHL ) & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_47( void )      /* BIT 0,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT0 )
        FLAGS &= N_FLAG_Z;
}


static void CB_4F( void )      /* BIT 1,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT1 )
        FLAGS &= N_FLAG_Z;
}


static void CB_57( void )      /* BIT 2,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT2 )
        FLAGS &= N_FLAG_Z;
}


static void CB_5F( void )      /* BIT 3,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT3 )
        FLAGS &= N_FLAG_Z;
}


static void CB_67( void )      /* BIT 4,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT4 )
        FLAGS &= N_FLAG_Z;
}


static void CB_6F( void )      /* BIT 5,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT5 )
        FLAGS &= N_FLAG_Z;
}


static void CB_77( void )      /* BIT 6,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT6 )
        FLAGS &= N_FLAG_Z;
}


static void CB_7F( void )      /* BIT 7,A */
{
    FLAGS |= FLAG_Z | FLAG_H;
    if ( RegA & BIT7 )
        FLAGS &= N_FLAG_Z;
}


static void CB_80( void )      /* RES 0,B */
{
    RegB &= N_BIT0;
}


static void CB_88( void )      /* RES 1,B */
{
    RegB &= N_BIT1;
}


static void CB_90( void )      /* RES 2,B */
{
    RegB &= N_BIT2;
}


static void CB_98( void )      /* RES 3,B */
{
    RegB &= N_BIT3;
}


static void CB_A0( void )      /* RES 4,B */
{
    RegB &= N_BIT4;
}


static void CB_A8( void )      /* RES 5,B */
{
    RegB &= N_BIT5;
}


static void CB_B0( void )      /* RES 6,B */
{
    RegB &= N_BIT6;
}


static void CB_B8( void )      /* RES 7,B */
{
    RegB &= N_BIT7;
}


static void CB_81( void )      /* RES 0,C */
{
    RegC &= N_BIT0;
}


static void CB_89( void )      /* RES 1,C */
{
    RegC &= N_BIT1;
}


static void CB_91( void )      /* RES 2,C */
{
    RegC &= N_BIT2;
}


static void CB_99( void )      /* RES 3,C */
{
    RegC &= N_BIT3;
}


static void CB_A1( void )      /* RES 4,C */
{
    RegC &= N_BIT4;
}


static void CB_A9( void )      /* RES 5,C */
{
    RegC &= N_BIT5;
}


static void CB_B1( void )      /* RES 6,C */
{
    RegC &= N_BIT6;
}


static void CB_B9( void )      /* RES 7,C */
{
    RegC &= N_BIT7;
}


static void CB_82( void )      /* RES 0,D */
{
    RegD &= N_BIT0;
}


static void CB_8A( void )      /* RES 1,D */
{
    RegD &= N_BIT1;
}


static void CB_92( void )      /* RES 2,D */
{
    RegD &= N_BIT2;
}


static void CB_9A( void )      /* RES 3,D */
{
    RegD &= N_BIT3;
}


static void CB_A2( void )      /* RES 4,D */
{
    RegD &= N_BIT4;
}


static void CB_AA( void )      /* RES 5,D */
{
    RegD &= N_BIT5;
}


static void CB_B2( void )      /* RES 6,D */
{
    RegD &= N_BIT6;
}


static void CB_BA( void )      /* RES 7,D */
{
    RegD &= N_BIT7;
}


static void CB_83( void )      /* RES 0,E */
{
    RegE &= N_BIT0;
}


static void CB_8B( void )      /* RES 1,E */
{
    RegE &= N_BIT1;
}


static void CB_93( void )      /* RES 2,E */
{
    RegE &= N_BIT2;
}


static void CB_9B( void )      /* RES 3,E */
{
    RegE &= N_BIT3;
}


static void CB_A3( void )      /* RES 4,E */
{
    RegE &= N_BIT4;
}


static void CB_AB( void )      /* RES 5,E */
{
    RegE &= N_BIT5;
}


static void CB_B3( void )      /* RES 6,E */
{
    RegE &= N_BIT6;
}


static void CB_BB( void )      /* RES 7,E */
{
    RegE &= N_BIT7;
}


static void CB_84( void )      /* RES 0,H */
{
    RegH &= N_BIT0;
}


static void CB_8C( void )      /* RES 1,H */
{
    RegH &= N_BIT1;
}


static void CB_94( void )      /* RES 2,H */
{
    RegH &= N_BIT2;
}


static void CB_9C( void )      /* RES 3,H */
{
    RegH &= N_BIT3;
}


static void CB_A4( void )      /* RES 4,H */
{
    RegH &= N_BIT4;
}


static void CB_AC( void )      /* RES 5,H */
{
    RegH &= N_BIT5;
}


static void CB_B4( void )      /* RES 6,H */
{
    RegH &= N_BIT6;
}


static void CB_BC( void )      /* RES 7,H */
{
    RegH &= N_BIT7;
}


static void CB_85( void )      /* RES 0,L */
{
    RegL &= N_BIT0;
}


static void CB_8D( void )      /* RES 1,L */
{
    RegL &= N_BIT1;
}


static void CB_95( void )      /* RES 2,L */
{
    RegL &= N_BIT2;
}


static void CB_9D( void )      /* RES 3,L */
{
    RegL &= N_BIT3;
}


static void CB_A5( void )      /* RES 4,L */
{
    RegL &= N_BIT4;
}


static void CB_AD( void )      /* RES 5,L */
{
    RegL &= N_BIT5;
}


static void CB_B5( void )      /* RES 6,L */
{
    RegL &= N_BIT6;
}


static void CB_BD( void )      /* RES 7,L */
{
    RegL &= N_BIT7;
}


static void CB_86( void )      /* RES 0,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT0 );
}


static void CB_8E( void )      /* RES 1,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT1 );
}


static void CB_96( void )      /* RES 2,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT2 );
}


static void CB_9E( void )      /* RES 3,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT3 );
}


static void CB_A6( void )      /* RES 4,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT4 );
}


static void CB_AE( void )      /* RES 5,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT5 );
}


static void CB_B6( void )      /* RES 6,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT6 );
}


static void CB_BE( void )      /* RES 7,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) & N_BIT7 );
}


static void CB_87( void )      /* RES 0,A */
{
    RegA &= N_BIT0;
}


static void CB_8F( void )      /* RES 1,A */
{
    RegA &= N_BIT1;
}


static void CB_97( void )      /* RES 2,A */
{
    RegA &= N_BIT2;
}


static void CB_9F( void )      /* RES 3,A */
{
    RegA &= N_BIT3;
}


static void CB_A7( void )      /* RES 4,A */
{
    RegA &= N_BIT4;
}


static void CB_AF( void )      /* RES 5,A */
{
    RegA &= N_BIT5;
}


static void CB_B7( void )      /* RES 6,A */
{
    RegA &= N_BIT6;
}


static void CB_BF( void )      /* RES 7,A */
{
    RegA &= N_BIT7;
}


static void CB_C0( void )      /* SET 0,B */
{
    RegB |= BIT0;
}


static void CB_C8( void )      /* SET 1,B */
{
    RegB |= BIT1;
}


static void CB_D0( void )      /* SET 2,B */
{
    RegB |= BIT2;
}


static void CB_D8( void )      /* SET 3,B */
{
    RegB |= BIT3;
}


static void CB_E0( void )      /* SET 4,B */
{
    RegB |= BIT4;
}


static void CB_E8( void )      /* SET 5,B */
{
    RegB |= BIT5;
}


static void CB_F0( void )      /* SET 6,B */
{
    RegB |= BIT6;
}


static void CB_F8( void )      /* SET 7,B */
{
    RegB |= BIT7;
}


static void CB_C1( void )      /* SET 0,C */
{
    RegC |= BIT0;
}


static void CB_C9( void )      /* SET 1,C */
{
    RegC |= BIT1;
}


static void CB_D1( void )      /* SET 2,C */
{
    RegC |= BIT2;
}


static void CB_D9( void )      /* SET 3,C */
{
    RegC |= BIT3;
}


static void CB_E1( void )      /* SET 4,C */
{
    RegC |= BIT4;
}


static void CB_E9( void )      /* SET 5,C */
{
    RegC |= BIT5;
}


static void CB_F1( void )      /* SET 6,C */
{
    RegC |= BIT6;
}


static void CB_F9( void )      /* SET 7,C */
{
    RegC |= BIT7;
}


static void CB_C2( void )      /* SET 0,D */
{
    RegD |= BIT0;
}


static void CB_CA( void )      /* SET 1,D */
{
    RegD |= BIT1;
}


static void CB_D2( void )      /* SET 2,D */
{
    RegD |= BIT2;
}


static void CB_DA( void )      /* SET 3,D */
{
    RegD |= BIT3;
}


static void CB_E2( void )      /* SET 4,D */
{
    RegD |= BIT4;
}


static void CB_EA( void )      /* SET 5,D */
{
    RegD |= BIT5;
}


static void CB_F2( void )      /* SET 6,D */
{
    RegD |= BIT6;
}


static void CB_FA( void )      /* SET 7,D */
{
    RegD |= BIT7;
}


static void CB_C3( void )      /* SET 0,E */
{
    RegE |= BIT0;
}


static void CB_CB( void )      /* SET 1,E */
{
    RegE |= BIT1;
}


static void CB_D3( void )      /* SET 2,E */
{
    RegE |= BIT2;
}


static void CB_DB( void )      /* SET 3,E */
{
    RegE |= BIT3;
}


static void CB_E3( void )      /* SET 4,E */
{
    RegE |= BIT4;
}


static void CB_EB( void )      /* SET 5,E */
{
    RegE |= BIT5;
}


static void CB_F3( void )      /* SET 6,E */
{
    RegE |= BIT6;
}


static void CB_FB( void )      /* SET 7,E */
{
    RegE |= BIT7;
}


static void CB_C4( void )      /* SET 0,H */
{
    RegH |= BIT0;
}


static void CB_CC( void )      /* SET 1,H */
{
    RegH |= BIT1;
}


static void CB_D4( void )      /* SET 2,H */
{
    RegH |= BIT2;
}


static void CB_DC( void )      /* SET 3,H */
{
    RegH |= BIT3;
}


static void CB_E4( void )      /* SET 4,H */
{
    RegH |= BIT4;
}


static void CB_EC( void )      /* SET 5,H */
{
    RegH |= BIT5;
}


static void CB_F4( void )      /* SET 6,H */
{
    RegH |= BIT6;
}


static void CB_FC( void )      /* SET 7,H */
{
    RegH |= BIT7;
}


static void CB_C5( void )      /* SET 0,L */
{
    RegL |= BIT0;
}


static void CB_CD( void )      /* SET 1,L */
{
    RegL |= BIT1;
}


static void CB_D5( void )      /* SET 2,L */
{
    RegL |= BIT2;
}


static void CB_DD( void )      /* SET 3,L */
{
    RegL |= BIT3;
}


static void CB_E5( void )      /* SET 4,L */
{
    RegL |= BIT4;
}


static void CB_ED( void )      /* SET 5,L */
{
    RegL |= BIT5;
}


static void CB_F5( void )      /* SET 6,L */
{
    RegL |= BIT6;
}


static void CB_FD( void )      /* SET 7,L */
{
    RegL |= BIT7;
}


static void CB_C6( void )      /* SET 0,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT0 );
}


static void CB_CE( void )      /* SET 1,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT1 );
}


static void CB_D6( void )      /* SET 2,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT2 );
}


static void CB_DE( void )      /* SET 3,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT3 );
}


static void CB_E6( void )      /* SET 4,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT4 );
}


static void CB_EE( void )      /* SET 5,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT5 );
}


static void CB_F6( void )      /* SET 6,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT6 );
}


static void CB_FE( void )      /* SET 7,( HL ) */
{
    POKE8( RegHL, PEEK8( RegHL ) | BIT7 );
}


static void CB_C7( void )      /* SET 0,A */
{
    RegA |= BIT0;
}


static void CB_CF( void )      /* SET 1,A */
{
    RegA |= BIT1;
}


static void CB_D7( void )      /* SET 2,A */
{
    RegA |= BIT2;
}


static void CB_DF( void )      /* SET 3,A */
{
    RegA |= BIT3;
}


static void CB_E7( void )      /* SET 4,A */
{
    RegA |= BIT4;
}


static void CB_EF( void )      /* SET 5,A */
{
    RegA |= BIT5;
}


static void CB_F7( void )      /* SET 6,A */
{
    RegA |= BIT6;
}


static void CB_FF( void )      /* SET 7,A */
{
    RegA |= BIT7;
}


pfct tabCB[ 256 ] =
    {
    CB_00, CB_01, CB_02, CB_03, CB_04, CB_05, CB_06, CB_07,
    CB_08, CB_09, CB_0A, CB_0B, CB_0C, CB_0D, CB_0E, CB_0F,
    CB_10, CB_11, CB_12, CB_13, CB_14, CB_15, CB_16, CB_17,
    CB_18, CB_19, CB_1A, CB_1B, CB_1C, CB_1D, CB_1E, CB_1F,
    CB_20, CB_21, CB_22, CB_23, CB_24, CB_25, CB_26, CB_27,
    CB_28, CB_29, CB_2A, CB_2B, CB_2C, CB_2D, CB_2E, CB_2F,
    CB_20, CB_21, CB_22, CB_23, CB_24, CB_25, CB_26, CB_27,
    CB_38, CB_39, CB_3A, CB_3B, CB_3C, CB_3D, CB_3E, CB_3F,
    CB_40, CB_41, CB_42, CB_43, CB_44, CB_45, CB_46, CB_47,
    CB_48, CB_49, CB_4A, CB_4B, CB_4C, CB_4D, CB_4E, CB_4F,
    CB_50, CB_51, CB_52, CB_53, CB_54, CB_55, CB_56, CB_57,
    CB_58, CB_59, CB_5A, CB_5B, CB_5C, CB_5D, CB_5E, CB_5F,
    CB_60, CB_61, CB_62, CB_63, CB_64, CB_65, CB_66, CB_67,
    CB_68, CB_69, CB_6A, CB_6B, CB_6C, CB_6D, CB_6E, CB_6F,
    CB_70, CB_71, CB_72, CB_73, CB_74, CB_75, CB_76, CB_77,
    CB_78, CB_79, CB_7A, CB_7B, CB_7C, CB_7D, CB_7E, CB_7F,
    CB_80, CB_81, CB_82, CB_83, CB_84, CB_85, CB_86, CB_87,
    CB_88, CB_89, CB_8A, CB_8B, CB_8C, CB_8D, CB_8E, CB_8F,
    CB_90, CB_91, CB_92, CB_93, CB_94, CB_95, CB_96, CB_97,
    CB_98, CB_99, CB_9A, CB_9B, CB_9C, CB_9D, CB_9E, CB_9F,
    CB_A0, CB_A1, CB_A2, CB_A3, CB_A4, CB_A5, CB_A6, CB_A7,
    CB_A8, CB_A9, CB_AA, CB_AB, CB_AC, CB_AD, CB_AE, CB_AF,
    CB_B0, CB_B1, CB_B2, CB_B3, CB_B4, CB_B5, CB_B6, CB_B7,
    CB_B8, CB_B9, CB_BA, CB_BB, CB_BC, CB_BD, CB_BE, CB_BF,
    CB_C0, CB_C1, CB_C2, CB_C3, CB_C4, CB_C5, CB_C6, CB_C7,
    CB_C8, CB_C9, CB_CA, CB_CB, CB_CC, CB_CD, CB_CE, CB_CF,
    CB_D0, CB_D1, CB_D2, CB_D3, CB_D4, CB_D5, CB_D6, CB_D7,
    CB_D8, CB_D9, CB_DA, CB_DB, CB_DC, CB_DD, CB_DE, CB_DF,
    CB_E0, CB_E1, CB_E2, CB_E3, CB_E4, CB_E5, CB_E6, CB_E7,
    CB_E8, CB_E9, CB_EA, CB_EB, CB_EC, CB_ED, CB_EE, CB_EF,
    CB_F0, CB_F1, CB_F2, CB_F3, CB_F4, CB_F5, CB_F6, CB_F7,
    CB_F8, CB_F9, CB_FA, CB_FB, CB_FC, CB_FD, CB_FE, CB_FF,
    };
