#include  <typesvar.h>
#include  <string.h>
#include  <stdio.h>


typedef unsigned char UBYTE;


typedef struct
    {
    CHAR  debut[ 0x30 ]; // "MV - CPCEMU Disk-File\r\nDisk-Info\r\n"
    CHAR  NbTracks;
    CHAR  NbHeads;
    SHORT info;     // 0x1300
    CHAR  Unused[ 0xCC ];
    } CPCEMUEnt;



typedef struct
    {
    CHAR C;                 // track
    CHAR H;                 // head
    CHAR R;                 // sect
    CHAR N;                 // size
    SHORT Un1;
    SHORT Un2;
    } CPCEMUSect;


typedef struct
    {
    CHAR  ID[ 0x10 ];   // "Track-Info\r\n"
    CHAR  Track;
    CHAR  Head;
    SHORT Unused;
    CHAR  X1;       // 2
    CHAR  X2;       // 9
    CHAR  X3;       // 0x4E
    CHAR  X4;       // 0xE5
    CPCEMUSect sect[ 9 ];
    CHAR Unu2[160];
    } CPCEMUTrack;

typedef struct
    {
    UBYTE C;
    UBYTE H;
    UBYTE R;
    UBYTE N;
    UBYTE datas[ 512 ];
    } StSect;

typedef struct
    {
    StSect Sect[ 9 ];
    } StTrack;


void main( int argc, char ** argv )
{
    if ( argc == 2 )
        {
        static StTrack piste;
        static CPCEMUEnt e;
        static CPCEMUTrack t;
        int i;
        CHAR nomSource[ 256 ];
        CHAR nomDest[ 256 ];

        PCHAR p = argv[ 1 ];
        PCHAR q = strchr( p, '.' );
        if ( q )
            * q = 0;

        sprintf( nomSource, "%s.CPC", p );
        sprintf( nomDest, "%s.DSK", p );
        memset( &e, 0, sizeof( e ) );
        memset( &t, 0, sizeof( t ) );
        strcpy( e.debut, "MV - CPCEMU Disk-File\r\nDisk-Info\r\n" );
        e.NbTracks = 40;
        e.NbHeads = 1;
        e.info = 0x1300;

        strcpy( t.ID, "Track-Info\r\n" );
        t.X1 = 2;
        t.X2 = 9;
        t.X3 = 0x4E;
        t.X4 = 0xE5;

        FILE * f1 = fopen( nomSource, "rb" );
        if ( f1 )
            {
            FILE * f2 = fopen( nomDest, "wb" );

            fwrite( &e, sizeof( e ) , 1, f2 );
            for ( i = 0; i < 40; i++ )
                {
                for ( int s = 0; s < 9; s++ )
                    {
                    piste.Sect[ s ].C = i;
                    piste.Sect[ s ].H = 0;
                    piste.Sect[ s ].R = 0xC1 + s;
                    piste.Sect[ s ].N = 2;
                    memset( piste.Sect[ s ].datas, 0xE5, 512 );
                    }
                fread( &piste, sizeof( piste ), 1, f1 );
                for ( s = 0; s < 9; s++ )
                    {
                    t.sect[ s ].C = piste.Sect[ s ].C;
                    t.sect[ s ].H = piste.Sect[ s ].H;
                    t.sect[ s ].R = piste.Sect[ s ].R;
                    t.sect[ s ].N = piste.Sect[ s ].N;
                    t.Track = i;
                    }
                fwrite( &t, sizeof( t ) , 1, f2 );
                for ( s = 0; s < 9; s++ )
                    fwrite( piste.Sect[ s ].datas, 512, 1, f2 );
                }
            fclose( f2 );
            }
        fclose( f1 );
        }
}
