#include  <typesvar.h>
#include  <string.h>
#include  <stdio.h>


typedef unsigned char UBYTE;


#define SECTSIZE   512
#define NBSECT     9


typedef struct
    {
    UBYTE C;
    UBYTE H;
    UBYTE R;
    UBYTE N;
    UBYTE datas[ SECTSIZE ];
    } StSect;

typedef struct
    {
    StSect Sect[ NBSECT ];
    } StTrack;
typedef struct
    {
    UBYTE C;
    UBYTE H;
    UBYTE R;
    UBYTE N;
    UBYTE Rien2[ 4 ];
    } StSectDsk;

typedef struct
    {
    UBYTE Titre[ 16 ];
    UBYTE numPiste;
    UBYTE rien1[ 7 ];
    StSectDsk Sect[ 9 ];
    UBYTE Rien2[ 160 ];
    UBYTE Datas[ NBSECT * SECTSIZE ];
    } StDSK;


void main( int argc, char * argv[] )
{
    if ( argc == 2 )
        {
        CHAR nomSource[ 256 ];
        CHAR nomDest[ 256 ];
        PCHAR p = argv[ 1 ];
        PCHAR q = strchr( p, '.' );
        if ( q )
            * q = 0;

        sprintf( nomSource, "%s.DSK", p );
        sprintf( nomDest, "%s.CPC", p );
        FILE * fSource = fopen( nomSource, "rb" );
        if ( fSource )
            {
            fread( nomSource, sizeof( nomSource ), 1, fSource );
            USHORT nbPistes = nomSource[ 0x30 ];
            FILE * fDest = fopen( nomDest, "wb" );
            if ( fDest )
                {
                StDSK pSource;
                StTrack pDest;
                for ( ; nbPistes--; )
                    {
                    fread( &pSource, sizeof( pSource ), 1, fSource );
                    for ( USHORT i = 0; i < 9; i++ )
                        {
                        pDest.Sect[ i ].C = pSource.Sect[ i ].C;
                        pDest.Sect[ i ].H = pSource.Sect[ i ].H;
                        pDest.Sect[ i ].R = pSource.Sect[ i ].R;
                        pDest.Sect[ i ].N = pSource.Sect[ i ].N;
                        memcpy( pDest.Sect[ i ].datas
                              , &pSource.Datas[ i * SECTSIZE ]
                              , SECTSIZE
                              );
                        }
                    fwrite( &pDest, sizeof( pDest ), 1, fDest );
                    }
                fclose( fDest );
                }
            fclose( fSource );
            }
        }
}