// COME BACK 64 v0.9H, 2nd build
//
// Johan Fitie'
//
//  [ ICQ UIN: 28546439 ]  [ Phone: +31-(0)6-23.660.661 ]
//  [ Contact info: www.fitie.com ] [ URL: www.cb64.com ]
//
// ::::: NEW :::::
// 2nd build of 0.9H, nov 11 2000
// CB64 main homepage is at http://www.cb64.com
// CB64/DOS homepage is at http://cb64.fitie.com
// Disclaimer and copyright option /C added

// ### INCLUDES #############################################################
#include <MATH.H>
#include <STDLIB.H>
#include <FCNTL.H>
#include <IO.H>
#include <DOS.H>
#include "HARDSID.H"
#include <alloc.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include "sound.h"
#include "keys.h"
#include "6510.H"
#include "ROMS.H"

// ### DEFINES ##############################################################
#define SOUND
#define VERMAJ '0'
#define VERMIN '9'
#define VERMINTWO 'H'
#define DEFAULTEMULATEDJOYSTICK 1
#define DEFAULTGAMMA 1.0
#define DEFAULTSKIPRATE 0
#define DEFAULTILLEGALOPCODE 0
#define NEGATIVE 128
#define OVERFLOW 64
#define BREAK    16
#define DECIMAL  8
#define INT      4
#define ZERO     2
#define CARRY    1
#define NEG_OFF  127
#define OVER_OFF 191
#define BRK_OFF  239
#define DEC_OFF  247
#define INT_OFF  251
#define ZERO_OFF 253
#define CRRY_OFF 254
#define JOYPORT 0x201
#define ATNOR 1
#define CLKOR 2
#define INITOR 4
#define DATAOR 8
#define ATNAND 254
#define CLKAND 253
#define INITAND 251
#define DATAAND 247

// ### TYPEDEFS #############################################################
typedef struct CRT_str {
        unsigned char C64CART[16];
        unsigned long headerlen;
        unsigned int version;
        unsigned int hardtype;
        unsigned char exromline;
        unsigned char gameline;
        unsigned char dummy[6];
        unsigned char name[20];
	unsigned char chip[4];
        unsigned long packlen;
        unsigned int chiptype;
        unsigned int bank;
        unsigned int address;
        unsigned int length;
        }
CARTRIDGE;
typedef union {
        struct {
                unsigned char l,h;
                }
        B;
        unsigned int W;
        }
pair;

// ### GLOBAL DEFINES #######################################################
float gamma=DEFAULTGAMMA;
unsigned long cyc_orig,cyc_last=0,cycles=0,time=0;
int SBver,SBbase,SBint,SBdma8,SBdma16,SBcurdmahalf,frameskip=0,sbaddr;
int select=0,scroll=0,selectcart=0,scrollcart=0,currsprite=0;
int vic_ecm,vic_bmm,vic_mcm,vic_den,vic_x,vic_y,vic_rsel,vic_csel,vic_xscrl;
int vic_yscrl,vic_vm,vic_cb,vic_rasirq,skipper=DEFAULTSKIPRATE;
int go, IRQ=0, modeset=0,allocated=0,done,rawkey,percent=0;
int modex_page,menupos1=0,menupos2=0,menuchangepos=0;
unsigned int HARDSID=0,loadcounter=0,PPORT,reset,vic_bank;
unsigned int latch1a=0, latch2a=0,latch1b=0,latch2b=0;
unsigned int t1a,t2a,t1b,t2b;
unsigned char execstring[255],execstring_do=0,programload[255],manskp;
unsigned char showsid=0,interlaceline=1,interlaced=0,dointro=0,interl_on=2;
unsigned char show_status_text=0,Cartflg=0,volume=6,showvol=0,emuid=1;
unsigned char vidmode=1,titlescreen=0,spritemethod=1,statusstring[50];
unsigned char statustime=0,statusstring1[50],statustime1=0,statusstring2[50];
unsigned char statustime2=0,statusstring3[50],statustime3=0,statusstring4[50];
unsigned char statustime4=0,olddrive=255,definput=255,defoutput=255;
unsigned char directprog=255,key_table[128][2],key_pressed[255];
unsigned char oldkeycolumn,joytoemu=DEFAULTEMULATEDJOYSTICK;
unsigned char paltype=0,restart=0,illopc=DEFAULTILLEGALOPCODE,PPORTACT=0;
unsigned char kflag,bflag,charrom=1,notenow=1,loadonstart[255];
unsigned char far *BasicPointer, far *KernalPointer,far *RAMPointer;
unsigned char VICRegs[0x2F],SIDRegs[0x1D],CIA1Regs[0x10],CIA2Regs[0x10],far *ColorPointer;
unsigned char far *CharPointer,far *Virtualscreen,opcodestring[40];
unsigned char ICR1set=0, enable1a=0, enable1b=0,ICR2set=0, enable2a=0, enable2b=0,sidon=1;
unsigned char NMI=0,autoskip=1,bcolor[312],skiptype=1,whereami=0;
unsigned char keysdown,scan,vicram,cpuport,imagefile[255],disksec[256];
char CurrentCrt[80],donone=0,vic_ec,vic_b0c,vic_b1c,vic_b2c,vic_b3c;
char key[127];
char far *data;
CARTRIDGE cart;

// ### ROUTINE DECLARATIONS ################################################
void loadcrt (unsigned char fname[80]);
unsigned char dircart (void);
void interrupt (far *Old_Isr)();
void loadprg (unsigned char filename[80]);
void putcbmchar (unsigned int letter,int xp,int yp,int fore,int back);
void putcbmcharsmall (unsigned int letter,int xp,int yp,int fore,int back);
void spriteinfo (void);
void help (void);
void Cleanup(unsigned char message[161]);
void setstatus (unsigned char stringetje[50]);
void Message (unsigned char text[41],unsigned int delayed);
void CIA (void);
void resetkeyboard (void);

// ### JOYSTICK EMULATION ###################################################
unsigned char joyemu (void)
{
        unsigned char up=1,down=1,left=1,right=1,fire=1,joyvalue;
        if (key[KB_kp_8]) {
                up=0;
                }
        if (key[KB_kp_5]) {
                down=0;
                }
        if (key[KB_kp_4]) {
                left=0;
                }
        if (key[KB_kp_6]) {
                right=0;
                }
        if (key[KB_kp_plus]) {
                fire=0;
                }
        joyvalue=(up)+(2*down)+(4*left)+(8*right)+(16*fire);
        return (joyvalue);
        }

// ### TYPE A STRING ON THE C64'S KEYBOARD ##################################
void typestring (unsigned char typesomething[255])
{
        strcpy (execstring,typesomething);
        execstring_do=1;
        }

// ### READ A VALUE FROM THE C64'S MEMORY ###################################
unsigned char Peek(unsigned int address)
{
        unsigned char ret;
        static unsigned char emudetect=0xAA;
        if(address<0xA000)
        ret=RAMPointer[address];
        else if(address<0xC000)
        {
                if((RAMPointer[1]&3)==3)
                ret=BasicPointer[address&0x1FFF];
                else  ret=RAMPointer[address];
                }
        else if(address<0xD000)
        ret=RAMPointer[address];
        else if(address<0xE000)
        {
                ret=RAMPointer[1];
                if(ret&3)
                if(ret&4)
                {
                        //IO chips
                        if(address<0xD400) //VIC
                        {
                                address&=0x3f;
                                if(address<0x2f)
                                ret=VICRegs[address];
                                else  ret=0xFF;
                                switch(address)
                                {
                                        case 0x11: if(vic_y&0x100)
                                        ret|=0x80;
                                        else ret&=0x7F;
                                        break;
                                        case 0x12: ret=vic_y&0xFF;
                                        break;
                                        case 0x19: //if(key[KB_f12])
                                        ret|=6;
                                        break;
                                        }
                                }
                        else if(address<0xD800) //SID
                        {
                                if (HARDSID==0)
                                {
                                        address&=0x1F;
                                        if(address<0x1d)
                                        ret=SIDRegs[address];
                                        else ret=0xFF;
                                        if(address==0x1C)
                                        ret=SNDvoices[2].envx>>23;
                                        }
                                else {
                                        if(address>=0xD400&&address<=0xD41C) {
                                                ret=hardsidread (address,HARDSID);
                                                }
                                        }
                                }
                        else if(address<0xDBE8) //ColorRAM
                        ret=ColorPointer[address&0x3ff]&0xF;
                        else if(address<0xDC00) //Nothing, I think
                        ret=0xFF;
                        else if(address<0xDD00) //CIA 1
                        {
                                address&=0xF;
                                ret=CIA1Regs[address];
                                switch(address)
                                {
                                        case 0: if(joytoemu==1)
                                        ret=(ret&224)+joyemu();
                                        break;
                                        case 1: ret=key_pressed[255-CIA1Regs[0]];
                                        if(joytoemu==2&&ret==255)
                                        ret=(ret&224)+joyemu();
                                        break;
                                        case 13:IRQ=CIA1Regs[13]=0;
                                        break;
                                        }
                                }
                        else if(address<0xDE00) //CIA 2
                        {
                                address&=0xF;
                                ret=CIA2Regs[address];
                                switch(address)
                                {
                                        case 0: /*ret=inp(PPORT);
                                        */ ret=0;
                                        if(ret&CLKOR)
                                        CIA2Regs[0]&=0xBF;
                                        else CIA2Regs[0]|=0x40;
                                        if(ret&DATAOR)
                                        {
                                                CIA2Regs[0]&=0x7F;
                                                PPORTACT=1;
                                                }
                                        else CIA2Regs[0]|=0x80;
                                        ret=CIA2Regs[0];
                                        break;
                                        case 13:CIA2Regs[13]=IRQ=0;
                                        break;
                                        }
                                }
                        else if(address<0xDFA0) //Nothing or CIA2 echoes, not sure
                        ret=0xFF;
                        else
                        {
                                ret=0;
                                if (emuid==1) {
                                        setstatus ("READ EMULATOR ID");
                                        switch(address)
                                        {
                                                case 0xdfa0: ret='C';
                                                break;
                                                case 0xdfa1: ret='O';
                                                break;
                                                case 0xdfa2: ret='M';
                                                break;
                                                case 0xdfa3: ret='E';
                                                break;
                                                case 0xdfa4: ret=' ';
                                                break;
                                                case 0xdfa5: ret='B';
                                                break;
                                                case 0xdfa6: ret='A';
                                                break;
                                                case 0xdfa7: ret='C';
                                                break;
                                                case 0xdfa8: ret='K';
                                                break;
                                                case 0xdfa9: ret=' ';
                                                break;
                                                case 0xdfaa: ret='6';
                                                break;
                                                case 0xdfab: ret='4';
                                                break;
                                                case 0xdfac: ret=',';
                                                break;
                                                case 0xdfad: ret=' ';
                                                break;
                                                case 0xdfae: ret='V';
                                                break;
                                                case 0xdfaf: ret=VERMAJ;
                                                break;
                                                case 0xdfb0: ret='.';
                                                break;
                                                case 0xdfb1: ret=VERMIN;
                                                break;
                                                case 0xdfb2: ret=VERMINTWO;
                                                break;
                                                case 0xdfb3: ret=0x0d;
                                                break;
                                                case 0xdfb4: ret='C';
                                                break;
                                                case 0xdfb5: ret='O';
                                                break;
                                                case 0xdfb6: ret='P';
                                                break;
                                                case 0xdfb7: ret='Y';
                                                break;
                                                case 0xdfb8: ret='R';
                                                break;
                                                case 0xdfb9: ret='I';
                                                break;
                                                case 0xdfba: ret='G';
                                                break;
                                                case 0xdfbb: ret='H';
                                                break;
                                                case 0xdfbc: ret='T';
                                                break;
                                                case 0xdfbd: ret=' ';
                                                break;
                                                case 0xdfbe: ret='(';
                                                break;
                                                case 0xdfbf: ret='C';
                                                break;
                                                case 0xdfc0: ret=')';
                                                break;
                                                case 0xdfc1: ret=' ';
                                                break;
                                                case 0xdfc2: ret='1';
                                                break;
                                                case 0xdfc3: ret='9';
                                                break;
                                                case 0xdfc4: ret='9';
                                                break;
                                                case 0xdfc5: ret='8';
                                                break;
                                                case 0xdfc6: ret='-';
                                                break;
                                                case 0xdfc7: ret='2';
                                                break;
                                                case 0xdfc8: ret='0';
                                                break;
                                                case 0xdfc9: ret='0';
                                                break;
                                                case 0xdfca: ret='0';
                                                break;
                                                case 0xdfcb: ret=' ';
                                                break;
                                                case 0xdfcc: ret='B';
                                                break;
                                                case 0xdfcd: ret='Y';
                                                break;
                                                case 0xdfce: ret=' ';
                                                break;
                                                case 0xdfcf: ret='J';
                                                break;
                                                case 0xdfd0: ret='O';
                                                break;
                                                case 0xdfd1: ret='H';
                                                break;
                                                case 0xdfd2: ret='A';
                                                break;
                                                case 0xdfd3: ret='N';
                                                break;
                                                case 0xdfd4: ret=' ';
                                                break;
                                                case 0xdfd5: ret='F';
                                                break;
                                                case 0xdfd6: ret='I';
                                                break;
                                                case 0xdfd7: ret='T';
                                                break;
                                                case 0xdfd8: ret='I';
                                                break;
                                                case 0xdfd9: ret='E';
                                                break;
                                                case 0xdfda: ret=0x0d;
                                                break;
                                                case 0xdfdb: ret='H';
                                                break;
                                                case 0xdfdc: ret='T';
                                                break;
                                                case 0xdfdd: ret='T';
                                                break;
                                                case 0xdfde: ret='P';
                                                break;
                                                case 0xdfdf: ret=':';
                                                break;
                                                case 0xdfe0: ret='/';
                                                break;
                                                case 0xdfe1: ret='/';
                                                break;
						case 0xdfe2: ret='C';
						break;
						case 0xdfe3: ret='B';
						break;
						case 0xdfe4: ret='6';
						break;
						case 0xdfe5: ret='4';
						break;
						case 0xdfe6: ret='.';
						break;
						case 0xdfe7: ret='F';
						break;
						case 0xdfe8: ret='I';
						break;
						case 0xdfe9: ret='T';
						break;
						case 0xdfea: ret='I';
						break;
						case 0xdfeb: ret='E';
						break;
						case 0xdfec: ret='.';
						break;
						case 0xdfed: ret='C';
						break;
						case 0xdfee: ret='O';
						break;
						case 0xdfef: ret='M';
						break;
						case 0xdff0: ret=0x00;
						break;
						case 0xdff1: ret=0x00;
						break;
						case 0xdff2: ret=0x00;
                                                break;
                                                case 0xdff3: ret=0x00;
                                                break;
                                                case 0xdff4: ret=0x00;
                                                break;
                                                case 0xdff5: ret=0x00;
                                                break;
                                                case 0xdff6: ret=0x00;
                                                break;
                                                case 0xdffc: ret=(VERMINTWO-'0');
                                                break;
                                                case 0xdffd: ret=(VERMIN-'0')+16*(VERMAJ-'0');
                                                break;
                                                case 0xdffe: ret='J';
                                                break;
                                                case 0xdfff: {
                                                        ret=emudetect;
                                                        emudetect=~emudetect;
                                                        }
                                                break;
                                                }
                                        }
                                }
                        }
                else ret=CharPointer[address&0x0FFF];
                else ret=RAMPointer[address];
                }
        else if(RAMPointer[1]&2)
        ret=KernalPointer[address&0x1FFF];
        else ret=RAMPointer[address];
        return(ret);
        }

// ### READ A DOUBLE BYTE USING PEEK ########################################
unsigned int Deek(unsigned int address)
{
        return (unsigned int)Peek(address)+((unsigned int)Peek(address+1)<<8);
        }

// ### POKE A VALUE INTO THE 64'S MEMORY ####################################
void Poke(unsigned int address, unsigned char value)
{
        unsigned char ret;
        ret=value;
        // ADD BY MAX
        ///////////////////////
        // IF ANY CARTRIDGE IN USE WE CANNOT TO PERFORM WRITE OPERATIONS
        // IN CARTRIDGE AREA (I THINK).
        if (Cartflg) {
                if (address>0x8000 && address<0x9FFF) return;
                }
        ////////////////////////////////////////////////////////////
        if(address<0xD000)
        {
                switch(address)
                {
                        case 1: cpuport=ret;
                        ret=RAMPointer[0];
                        //no break on purpose
                        case 0: RAMPointer[0]=ret;
                        RAMPointer[1]&=~(ret|0x20);
                        RAMPointer[1]|=(cpuport&ret)|(0x17&~ret);
                        break;
                        default:RAMPointer[address]=ret;
                        }
                }
        else if(address<0xE000)
        {
                if((RAMPointer[1]&7)>4) //Write to I/O
                {
                        if(address<0xD400) //VIC
                        {
                                address&=0x3F;
                                switch(address)
                                {
                                        case 0x11:      vic_ecm=ret&0x40;
                                        vic_bmm=ret&0x20;
                                        vic_den=ret&0x10;
                                        vic_rsel=ret&8;
                                        vic_yscrl=ret&7;
                                        vic_rasirq=VICRegs[0x12];
                                        if(ret&0x80)
                                        vic_rasirq|=0x100;
                                        break;
                                        case 0x12: vic_rasirq=ret;
                                        if(VICRegs[0x11]&0x80)
                                        vic_rasirq|=0x100;
                                        break;
                                        case 0x16: ret|=0xA0;
                                        vic_mcm=ret&0x10;
                                        vic_csel=ret&8;
                                        vic_xscrl=ret&7;
                                        break;
                                        case 0x18:      ret|=1;
                                        vic_vm=((int)ret&0xF0)<<6;
                                        vic_cb=((int)ret&0xE)<<10;
                                        break;
                                        case 0x19:      ret=~(ret&0xF)&VICRegs[0x19];
                                        if(!(ret&VICRegs[0x1A]&0xF)&&(ret&0x80))
                                        {
                                                IRQ=0;
                                                ret&=0x7f;
                                                }
                                        ret|=0x70;
                                        break;
                                        case 0x1A: ret|=0xF0;
                                        break;
                                        case 0x20:  vic_ec=ret&0xF;
                                        ret|=0xF0;
                                        break;
                                        case 0x21: vic_b0c=ret&0xf;
                                        ret|=0xF0;
                                        break;
                                        case 0x22: vic_b1c=ret&0xf;
                                        ret|=0xF0;
                                        break;
                                        case 0x23: vic_b2c=ret&0xf;
                                        ret|=0xF0;
                                        break;
                                        case 0x24: vic_b3c=ret&0xf;
                                        ret|=0xF0;
                                        break;
                                        }
                                if(address<0x2f)
                                VICRegs[address]=ret;
                                }
                        else if(address<0xD800) //SID
                        {
                                if (HARDSID==0) {
                                        address&=0x1F;
                                        if(address<0x1d)
                                        {
                                                ret=SIDRegs[address];
                                                SIDRegs[address]=value;
                                                }
                                        switch(address)
                                        {
                                                case 4: if((ret^value)&0xF1)
                                                if(value&1)
                                                SNDNoteOn(0);
                                                else SNDNoteOff(0);
                                                break;
                                                case 5: SNDvoices[0].ar=ret>>4;
                                                SNDvoices[0].dr=ret&0xF;
                                                break;
                                                case 6: SNDvoices[0].sr=ret&0xf;
                                                SNDvoices[0].sl=ret>>4;
                                                break;
                                                case 11:if((ret^value)&0xF1)
                                                if(value&1)
                                                SNDNoteOn(1);
                                                else SNDNoteOff(1);
                                                break;
                                                case 12:SNDvoices[1].ar=ret>>4;
                                                SNDvoices[1].dr=ret&0xF;
                                                break;
                                                case 13:SNDvoices[1].sr=ret&0xf;
                                                SNDvoices[1].sl=ret>>4;
                                                break;
                                                case 18:if((ret^value)&0xF1)
                                                if(value&1)
                                                SNDNoteOn(2);
                                                else SNDNoteOff(2);
                                                break;
                                                case 19:SNDvoices[2].ar=ret>>4;
                                                SNDvoices[2].dr=ret&0xF;
                                                break;
                                                case 20:SNDvoices[2].sr=ret&0xf;
                                                SNDvoices[2].sl=ret>>4;
                                                break;
                                                }
                                        }
                                else {
                                        if(address>=0xD400&&address<=0xD41C) {
                                                RAMPointer[address]=ret;
                                                hardsidwrite (ret,address,HARDSID);
                                                }
                                        }
                                }
                        else if(address<0xDBE8) //ColorRAM
                        ColorPointer[address&0x3ff]=ret&0xF;
                        else if(address<0xDC00);
                        //Nothing, I think
                        else if(address<0xDD00) //CIA 1
                        {
                                address&=0xF;
                                CIA1Regs[address]=ret;
                                switch(address)
                                {
                                        case 4: latch1a&=0xFF00;
                                        latch1a|=value;
                                        break;
                                        case 5: latch1a&=0xFF;
                                        latch1a|=(unsigned int)value<<8;
                                        break;
                                        case 6: latch1b&=0xFF00;
                                        latch1b|=value;
                                        break;
                                        case 7: latch1b&=0xFF;
                                        latch1b|=(unsigned int)value<<8;
                                        case 13:if(value&0x01) if(value&0x80) ICR1set|=1;
                                        else   ICR1set&=254;
                                        if(value&0x02)  if(value&0x80)  ICR1set|=2;
                                        else   ICR1set&=253;
                                        if(value&0x04)  if(value&0x80)  ICR1set|=4;
                                        else   ICR1set&=251;
                                        if(value&0x08)  if(value&0x80)  ICR1set|=8;
                                        else   ICR1set&=247;
                                        if(value&0x10)  if(value&0x80)  ICR1set|=16;
                                        else   ICR1set&=239;
                                        break;
                                        case 14:if(value&0x10)
                                        {
                                                ret&=0xEF;
                                                t1a=CIA1Regs[4]=latch1a;
                                                }
                                        enable1a=ret&0x01;
                                        break;
                                        case 15:if(value&0x10)
                                        {
                                                ret&=0xEF;
                                                t1b=CIA1Regs[6]=latch1b;
                                                }
                                        enable1b=ret&0x1;
                                        break;
                                        }
                                }
                        else if(address<0xDE00)
                        {
                                address&=0xF;
                                CIA2Regs[address]=ret;
                                switch(address)
                                {
                                        case 0: vic_bank=(~value&3)<<14;
                                        ret=244;
                                        if(value&0x08)
                                        ret|=ATNOR;
                                        if(value&0x10)
                                        ret|=CLKOR;
                                        if(value&0x20)
                                        {
                                                ret|=DATAOR;
                                                PPORTACT=2;
                                                }
                                        break;
                                        case 4: latch2a&=0xFF00;
                                        latch2a|=value;
                                        break;
                                        case 5: latch2a&=0xFF;
                                        latch2a|=(unsigned int)value<<8;
                                        break;
                                        case 6: latch2b&=0xFF00;
                                        latch2b|=value;
                                        break;
                                        case 7: latch2b&=0xFF;
                                        latch2b|=(unsigned int)value<<8;
                                        case 13:if(value&0x01)  if(value&0x80)  ICR2set|=1;
                                        else   ICR2set&=254;
                                        if(value&0x02)  if(value&0x80)  ICR2set|=2;
                                        else   ICR2set&=253;
                                        if(value&0x04)  if(value&0x80)  ICR2set|=4;
                                        else   ICR2set&=251;
                                        if(value&0x08)  if(value&0x80)  ICR2set|=8;
                                        else   ICR2set&=247;
                                        if(value&0x10)  if(value&0x80)  ICR2set|=16;
                                        else   ICR2set&=239;
                                        break;
                                        case 14:if(value&0x10)
                                        {
                                                ret&=0xEF;
                                                t2a=CIA2Regs[4]=latch2a;
                                                }
                                        enable2a=ret&1;
                                        break;
                                        case 15:if(value&0x10)
                                        {
                                                ret&=0xEF;
                                                t2b=CIA2Regs[6]=latch2b;
                                                }
                                        enable2b=ret&1;
                                        break;
                                        }
                                }
                        }
                else RAMPointer[address]=ret;
                }
        else RAMPointer[address]=ret;
        }

// ### PUT A STRING ON THE STATUSLINE AND SCROLL ############################
void setstatus (unsigned char stringetje[50])
{
        statustime4=statustime3;
        strcpy (statusstring4,statusstring3);
        statustime3=statustime2;
        strcpy (statusstring3,statusstring2);
        statustime2=statustime1;
        strcpy (statusstring2,statusstring1);
        statustime1=statustime;
        strcpy (statusstring1,statusstring);
        strcpy (statusstring,stringetje);
        strupr (statusstring);
        statustime=50;
        }

// ### SIMULATE THE LOADING OF A PROGRAM ####################################
unsigned int Basic2_ProgLoad (void)
{
        struct ffblk ffblk;
        struct diskfree_t free;
        unsigned int whatreturn,filelen;
        unsigned int kk;
        FILE *infile;
        unsigned int loadat;
        unsigned char data,quit=0;
        unsigned char filename[20];
        unsigned int memptr;
        unsigned char L,counter,chr,ok,done;
        unsigned int A;
        unsigned char cnt2=0;
        long avail;
        unsigned int available;
        unsigned char label[80];
	unsigned char number,linenum,tempie[60],tempiecount;
	unsigned char retstat[50];
        strcpy (retstat,"FILE NOT FOUND");
        findfirst("\*.*",&ffblk,FA_LABEL);
        strcpy (label,ffblk.ff_name);
        whatreturn=0xf5d2;
        // LOADING
        L=Peek(0x00b7);
        A=Deek(187);
        for (counter=0;counter<20;counter++) {
                filename[counter]=0;
                }
        for (counter=0;counter<L;counter++) {
                chr=Peek(A+counter);
                ok=0;
                if (chr>='A'&&chr<='Z') ok=1;
                if (chr>='a'&&chr<='z') {
                        ok=1;
                        chr=chr-32;
                        }
                if (chr>='0'&&chr<='9') ok=1;
                if (chr=='-'||chr=='('||chr==')'||chr=='$'||chr=='*'||chr=='?') ok=1;
                if (chr=='*'||chr=='?') ok=1;
                // WILDCARDS
                if (ok==1) {
                        filename[cnt2]=chr;
                        cnt2++;
                        ok=0;
                        }
                }
        filename[cnt2]=0;
        strcpy (tempie,"FILENAME: ");
        for (tempiecount=0;tempiecount<strlen(filename);tempiecount++) {
                if (filename[tempiecount]=='0') {
                        filename[tempiecount]='~';
                        }
                tempie[10+tempiecount]=filename[tempiecount];
                tempie[tempiecount+11]=0;
                }
        setstatus (tempie);
        //setstatus(filename);
        
        if (cnt2==0) whatreturn=0xf710;
        // MISSING FILE NAME
        
        filename[cnt2+0]='.';
        filename[cnt2+1]='P';
        filename[cnt2+2]='R';
        filename[cnt2+3]='G';
        filename[cnt2+4]=0;
        // ADD .PRG
        
        if ((infile=fopen(filename, "rb")) == NULL) {
                filename[cnt2+0]='.';
                filename[cnt2+1]='P';
                filename[cnt2+2]='0';
                filename[cnt2+3]='0';
                filename[cnt2+4]=0;
                }
        // IF NOT THEN ADD .P00
        else fclose(infile);
        if ((infile=fopen(filename, "rb")) == NULL) {
                if (cnt2!=0) {
                        whatreturn=0xf704;
                        }
                // FILE NOT FOUND
                
                }
        else
        {
                strcpy (retstat,"PRG LOADED");
                if (filename[strlen(filename)-1]=='0') {
                        fseek(infile,0x1a,0);
                        strcpy (retstat,"P00 LOADED");
                        }
                data=fgetc(infile);
                loadat=data;
                data=fgetc(infile);
                loadat=loadat+data*256;
                do {
                        data=fgetc(infile);
                        RAMPointer[loadat]=data;
                        loadat++;
                        if (feof(infile)) quit=1;
                        if (loadat==0xffff) quit=1;
                        }
                while (quit==0);
                fclose(infile);
                RAMPointer[0x2e]=RAMPointer[0x30]=RAMPointer[0x32]=(unsigned char)((loadat-1)>>8);
                RAMPointer[0x2d]=loadat++-1;
                RAMPointer[0x2f]=loadat++-1;
                RAMPointer[0x31]=loadat++-1;
                }
        if (filename[0]=='$'&&filename[5]==0) // LOAD DIRECTORY OF FILES
        {
                setstatus ("GET DIRECTORY");
                memptr=0x0801;
                // FIRST LINE - HEADER
                RAMPointer[memptr]=  4;
                memptr++;
                  RAMPointer[memptr]=  4;
                memptr++;
                RAMPointer[memptr]=  0;
                memptr++;
                  RAMPointer[memptr]=  0;
                memptr++;
                RAMPointer[memptr]= 18;
                memptr++;
                  RAMPointer[memptr]= 34;
                memptr++;
                // FIRST LINE - DISK NAME
                for (ok=strlen(label);ok<79;ok++) {
                        label[ok]=32;
                        }
                label[16]=0;
                strcpy (filename,label);
                for (ok=0;ok<strlen(filename);ok++) {
                         RAMPointer[memptr]=filename[ok];
                        memptr++;
                         }
                // FIRST LINE - MIDDLE
                RAMPointer[memptr]= 34;
                memptr++;
                  RAMPointer[memptr]= 32;
                memptr++;
                // FIRST LINE - DISK ID
                strcpy (filename,"00 2A");
                for (ok=0;ok<strlen(filename);ok++) {
                         RAMPointer[memptr]=filename[ok];
                        memptr++;
                         }
                // FIRST LINE - END
                RAMPointer[memptr]=  0;
                memptr++;
                // ----------- LIST PROGRAMS
                /* ======= .PRG LISTING ======== */
                done = findfirst("*.PRG",&ffblk,0);
                if (done==0) {
                        while (!done) {
                                kk=((long)ffblk.ff_fsize+253)/254;
                                filelen=kk;
                                strcpy (filename,ffblk.ff_name);
                                done = findnext(&ffblk);
                                filename[strlen(filename)-4]=0;
                                RAMPointer[memptr]=  4;
                                memptr++;
                                RAMPointer[memptr]=  4;
                                memptr++;
                                RAMPointer[memptr]=filelen%256;
                                memptr++;
                                RAMPointer[memptr]=filelen/256;
                                memptr++;
                                if (filelen<100) {
                                        RAMPointer[memptr]=' ';
                                        memptr++;
                                        }
                                if (filelen<10) {
                                        RAMPointer[memptr]=' ';
                                        memptr++;
                                        }
                                RAMPointer[memptr]=' ';
                                memptr++;
                                RAMPointer[memptr]= 34;
                                memptr++;
                                for (ok=0;ok<strlen(filename);ok++) {
                                        if (filename[ok]=='~') filename[ok]='0';
                                        RAMPointer[memptr]=filename[ok];
                                        memptr++;
                                        }
                                RAMPointer[memptr]= 34;
                                memptr++;
                                for (ok=0;ok<17-strlen(filename);ok++) {
                                        RAMPointer[memptr]=32;
                                        memptr++;
                                        }
                                RAMPointer[memptr]='P';
                                memptr++;
                                   RAMPointer[memptr]='R';
                                memptr++;
                                RAMPointer[memptr]='G';
                                memptr++;
                                   RAMPointer[memptr]='<';
                                memptr++;
                                RAMPointer[memptr]= 0;
                                memptr++;
                                }
                        }
                /* ======= .P00 LISTING ======== */
                done = findfirst("*.P00",&ffblk,0);
                if (done==0) {
                        while (!done) {
                                kk=((long)ffblk.ff_fsize+253-0x1c/*for header*/)/254;
                                filelen=kk;
                                strcpy (filename,ffblk.ff_name);
                                done = findnext(&ffblk);
                                filename[strlen(filename)-4]=0;
                                RAMPointer[memptr]=  4;
                                memptr++;
                                RAMPointer[memptr]=  4;
                                memptr++;
                                RAMPointer[memptr]=filelen%256;
                                memptr++;
                                RAMPointer[memptr]=filelen/256;
                                memptr++;
                                if (filelen<100) {
                                        RAMPointer[memptr]=' ';
                                        memptr++;
                                        }
                                if (filelen<10) {
                                        RAMPointer[memptr]=' ';
                                        memptr++;
                                        }
                                RAMPointer[memptr]=' ';
                                memptr++;
                                RAMPointer[memptr]= 34;
                                memptr++;
                                for (ok=0;ok<strlen(filename);ok++) {
                                        if (filename[ok]=='~') filename[ok]='0';
                                        RAMPointer[memptr]=filename[ok];
                                        memptr++;
                                        }
                                RAMPointer[memptr]= 34;
                                memptr++;
                                for (ok=0;ok<17-strlen(filename);ok++) {
                                        RAMPointer[memptr]=32;
                                        memptr++;
                                        }
                                RAMPointer[memptr]='P';
                                memptr++;
                                   RAMPointer[memptr]='0';
                                memptr++;
				RAMPointer[memptr]='0';
				memptr++;
				   RAMPointer[memptr]='<';
				memptr++;
				RAMPointer[memptr]= 0;
				memptr++;
				}
			}
		// ----------- END OF LIST - GIVE FREE BLOCKS
                _dos_getdiskfree(0, &free);
                avail=(long)free.avail_clusters*(long)free.bytes_per_sector*(long)free.sectors_per_cluster;
                avail=avail/254;
                if (avail>65535) avail=65535;
                available=avail;
                RAMPointer[memptr]= 4;
                memptr++;
                RAMPointer[memptr]= 4;
                memptr++;
                RAMPointer[memptr]=available%256;
                memptr++;
                RAMPointer[memptr]=available/256;
                memptr++;
                strcpy (filename,"BLOCKS FREE.");
                for (ok=0;ok<strlen(filename);ok++)
                {
                         RAMPointer[memptr]=filename[ok];
                        memptr++;
                         }
                RAMPointer[memptr]= 0;
                memptr++;
                RAMPointer[memptr]= 0;
                memptr++;
                RAMPointer[memptr]= 0;
                memptr++;
                // ----------- END OF FREE BLOCKS
                RAMPointer[memptr]=0;
                RAMPointer[memptr+1]=0;
                RAMPointer[memptr+2]=0;
                RAMPointer[0x2e]=RAMPointer[0x30]=RAMPointer[0x32]=(unsigned char)((memptr-1)>>8);
                RAMPointer[0x2d]=memptr++-1;
                RAMPointer[0x2f]=memptr++-1;
                RAMPointer[0x31]=memptr++-1;
                whatreturn=0xf5d2;
                // LOADING
                strcpy (retstat,"DIR LOADED");
		}
        setstatus(retstat);
        return (whatreturn);
        }

// ### TRAP AND SHOW ON STATUSLINE ##########################################
void trap2 (void)
{
        unsigned char tempstring[50];
        // Direct/program
        if (directprog!=RAMPointer[157])
        {
                directprog=RAMPointer[157];
                if (directprog==0x00) {
                        setstatus("MODE: PROGRAM");
                        }
                if (directprog==0x80) {
                        setstatus("MODE: DIRECT");
                        }
                }
        // Default drive
        if (olddrive!=RAMPointer[186])
        {
                olddrive=RAMPointer[186];
                strcpy (tempstring,"SET STORAGE DEVICE ##");
                tempstring[19]=olddrive/10+'0';
                tempstring[20]=olddrive%10+'0';
                if (olddrive<100) {
                        setstatus(tempstring);
                        }
                }
        // Default input
        if (definput!=RAMPointer[153])
        {
                definput=RAMPointer[153];
                strcpy (tempstring,"SET INPUT DEVICE ##");
                tempstring[17]=definput/10+'0';
                tempstring[18]=definput%10+'0';
                if (definput<100) {
                        setstatus(tempstring);
                        }
                }
        // Default output
        if (defoutput!=RAMPointer[154])
        {
                defoutput=RAMPointer[154];
                strcpy (tempstring,"SET OUTPUT DEVICE ##");
                tempstring[18]=defoutput/10+'0';
                tempstring[19]=defoutput%10+'0';
                if (defoutput<100) {
                        setstatus(tempstring);
                        }
                }
        }

// ### PUT THE VIRTUALSCREEN ON THE MONITOR #################################
void flip (void)
{
        int x,y,xp,yp,col;
        unsigned char clr;
        unsigned int colpos=0;
        void far *Realscreen,far *border=&bcolor[30];
        int cbtitle;
        unsigned char statusdraw,tempstring[50];
        trap2();
        if(key[KB_capslock]) {
                show_status_text=1-show_status_text;
                do {
                        }
		while (key[KB_capslock]);
                }
        if (show_status_text==1)
        {
                //STATUS LINE 0
                if (statustime>0)
                {
                        statustime--;
                        if (statustime<statustime4) {
                                statustime=statustime4;
                                }
                        for (statusdraw=0;statusdraw<strlen(statusstring);statusdraw++) {
                                cbtitle=statusstring[statusdraw];
                                if (cbtitle>64&&cbtitle<91) cbtitle-=64;
                                putcbmcharsmall (cbtitle,statusdraw+(40-strlen(statusstring)),24,113,-1);
                                }
                        }
                //STATUS LINE 1
                if (statustime1>0)
                {
                        statustime1--;
                        if (statustime1<statustime4) {
                                statustime1=statustime4;
                                }
                        for (statusdraw=0;statusdraw<strlen(statusstring1);statusdraw++) {
                                cbtitle=statusstring1[statusdraw];
                                if (cbtitle>64&&cbtitle<91) cbtitle-=64;
                                putcbmcharsmall (cbtitle,statusdraw+(40-strlen(statusstring1)),23,101,-1);
                                }
                        }
                //STATUS LINE 2
                if (statustime2>0)
                {
                        statustime2--;
                        if (statustime2<statustime4) {
                                statustime2=statustime4;
                                }
                        for (statusdraw=0;statusdraw<strlen(statusstring2);statusdraw++) {
                                cbtitle=statusstring2[statusdraw];
                                if (cbtitle>64&&cbtitle<91) cbtitle-=64;
                                putcbmcharsmall (cbtitle,statusdraw+(40-strlen(statusstring2)),22,101,-1);
                                }
                        }
                //STATUS LINE 3
                if (statustime3>0)
                {
                        statustime3--;
                        if (statustime3<statustime4) {
                                statustime3=statustime4;
                                }
                        for (statusdraw=0;statusdraw<strlen(statusstring3);statusdraw++) {
                                cbtitle=statusstring3[statusdraw];
                                if (cbtitle>64&&cbtitle<91) cbtitle-=64;
                                putcbmcharsmall (cbtitle,statusdraw+(40-strlen(statusstring3)),21,101,-1);
                                }
                        }
                //STATUS LINE 4
                if (statustime4>0)
                {
                        statustime4--;
                        for (statusdraw=0;statusdraw<strlen(statusstring4);statusdraw++) {
                                cbtitle=statusstring4[statusdraw];
                                if (cbtitle>64&&cbtitle<91) cbtitle-=64;
                                putcbmcharsmall (cbtitle,statusdraw+(40-strlen(statusstring4)),20,101,-1);
                                }
                        if (statustime4==1)
                        {
                                statustime4=statustime3+1;
                                strcpy (statusstring4,statusstring3);
                                statustime3=statustime2+1;
                                strcpy (statusstring3,statusstring2);
                                statustime2=statustime1+1;
                                strcpy (statusstring2,statusstring1);
                                statustime1=statustime+1;
                                strcpy (statusstring1,statusstring);
                                strcpy(statusstring,"");
                                statustime=50;
                                }
                        }
                }
        if (showvol)
        {
                showvol--;
                for (xp=0;xp<114;xp++) {
                        for (yp=0;yp<14;yp++) {
                                Virtualscreen[102+320*168+xp+320*yp]=100;
                                }
                        }
                for (x=7;x<122;x++) {
                        Virtualscreen[53534+x]=111;
                        Virtualscreen[58334+x]=111;
                        }
                for (x=0;x<15;x++) {
                        Virtualscreen[53861+x*320]=111;
                        Virtualscreen[53975+x*320]=111;
                        }
                for (x=0;x<16;x++) {
                        if (volume>=x) {
                                col=107;
                                for (xp=0;xp<4;xp++) {
                                        for (yp=0;yp<10;yp++) {
                                                Virtualscreen[54504+x*7+xp+320*yp]=col;
                                                }
                                        }
                                }
                        }
                }
        // if (PPORTACT==1) {putcbmchar ('R'-64,39,24,1,0); PPORTACT=0;}
        // if (PPORTACT==2) {putcbmchar ('W'-64,39,24,1,0); PPORTACT=0;}
        
        if (vidmode!=1)
        _fmemcpy((void far *)0xA0000000L,Virtualscreen,64000);
        else {
                if(modex_page)
                {
                        modex_page=0;
                        Realscreen=(void far *)0xA0000000L;
                        }
                else
                {
                        modex_page++;
                        Realscreen=(void far *)0xA0005460L;
                        }
                for(x=0;x<4;x++) {
                        asm mov dx,0x3c4
                        asm mov ax,0x0102
                        asm mov cx,x
                        asm shl ah,cl
                        asm out dx,ax
                        asm push es
                        asm push ds
                        asm les di,border
                        asm add di,239
                        asm mov cx,240
                        v360p:   asm mov al,[es:di]
                        asm add al,100
                        asm mov ah,al
                        asm push ax
                        asm dec di
                        asm loop v360p
                        asm les di,Realscreen
                        asm lds si,Virtualscreen
                        asm add si,x
                        asm mov dx,20
                        v360bt:   asm pop ax
                        asm mov cx,45
                        asm rep stosw
                        asm dec dx
                        asm jne v360bt
                        asm mov dx,200
                        v360line:  asm pop ax
                        asm mov cx,5
                        asm rep stosb
                        asm push ax
                        asm mov cx,20
                        v360l:   asm mov bl,[ds:si]
                        asm add si,4
                        asm mov bh,[ds:si]
                        asm add si,4
                        asm mov al,[ds:si]
                        asm add si,4
                        asm mov ah,[ds:si]
                        asm add si,4
                        asm db 0x66
                        asm shl ax,16
                        asm mov ax,bx
                        asm db 0x66
                        asm mov [es:di],ax
                        asm add di,4
                        asm loop v360l
                        asm pop ax
                        asm mov cx,5
                        asm rep stosb
                        asm dec dx
                        asm jne v360line
                        asm mov dx,20
                        v360bb:   asm pop ax
                        asm mov cx,45
                        asm rep stosw
                        asm dec dx
                        asm jne v360bb
                        asm pop ds
                        asm pop es
                        }
                asm mov ax,WORD PTR Realscreen
                asm mov al,0x0C
                asm mov dx,0x3D4
                asm out dx,ax
                asm mov ah,BYTE PTR Realscreen
                asm inc al
                asm out dx,ax
                }
        }

// ### USE THE C64'S FONT TO PUT A CHAR ON THE PC'S MONITOR #################
void putcbmchar (unsigned int letter,int xp,int yp,int fore,int back)
{
        int x,y,o,pos,col;
        unsigned int place;
        place=xp*8+320*yp*8;
        for (y=0;y<8;y++) {
                o=CharPointer[letter*8+y];
                pos=128;
                for (x=0;x<8;x++) {
                        col=back;
                        if (o>=pos) {
                                o=o-pos;
                                col=fore;
                                }
                        if (col!=-1) {
                                Virtualscreen[x+320*y+place]=100+col;
                                if (back==-1)
                                {
                                         Virtualscreen[x+320*y+place+1]=0;
                                        Virtualscreen[x+320*y+place+320]=0;
                                        Virtualscreen[x+320*y+place+321]=0;
                                        }
                                }
                        pos=pos/2;
                        }
                }
        }

// ### USE THE C64'S FONT TO PUT A SMALL CHAR ON THE PC'S MONITOR ###########
void putcbmcharsmall (unsigned int letter,int xp,int yp,int fore,int back)
{
        int x,y,o,pos,col;
        unsigned int place;
        unsigned char whichone;
        place=(xp+40)*4+320*(yp*6+49);
        for (y=1;y<6;y++) {
                whichone=y;
                if (y==1) whichone--;
                o=CharPointer[letter*8+(whichone*1.3)];
                pos=128;
                for (x=0;x<8;x++) {
                        col=back;
                        if (o>=pos) {
                                o=o-pos;
                                col=fore;
                                }
                        if (x==1||x==3||x==5||x==7) {
                                if (col!=-1) {
                                        Virtualscreen[x/2+320*y+place]=col;
                                        }
                                }
                        pos=pos/2;
                        }
                }
        }

// ### USING PUTCBMCHAR, PUT A STRING ONSCREEN ##############################
void putcbmstr (unsigned char far * string,int xp, int yp, int fore, int back)
{
        unsigned int x;
        while ( (x = *string++ ) != '\0' )
        {
                putcbmchar( x&63, xp++, yp, fore, back );
                }
        }

// ### SHOW FRAMESKIP AND SPEED COMPARED TO AN ORIGINAL 64 ##################
void showpercent (void)
{
        unsigned char r1,r2,r3;
        unsigned int ps;
        r1=0;
        r2=0;
        r3=0;
        r1=percent/100;
        r2=percent/10-r1*10;
        r3=percent-r1*100-r2*10;
        putcbmchar ('S'-64,24,24,1,0);
	putcbmchar (':',25,24,1,0);
        putcbmchar ('0'+skipper/10,26,24,1,0);
	putcbmchar ('0'+skipper%10,27,24,1,0);
        putcbmchar (' ',28,24,1,0);
        putcbmchar ('-',29,24,1,0);
        putcbmchar (' ',30,24,1,0);
        if (RAMPointer[678]==0) {
                putcbmchar ('N'-64,31,24,1,0);
                putcbmchar ('T'-64,32,24,1,0);
                putcbmchar ('S'-64,33,24,1,0);
                putcbmchar ('C'-64,34,24,1,0);
                putcbmchar (' ',35,24,1,0);
                }
        if (RAMPointer[678]==1) {
                putcbmchar ('P'-64,32,24,1,0);
                putcbmchar ('A'-64,33,24,1,0);
                putcbmchar ('L'-64,34,24,1,0);
                putcbmchar (' ',35,24,1,0);
                putcbmchar (' ',31,24,1,0);
                }
        putcbmchar (r1+'0',36,24,1,0);
        putcbmchar (r2+'0',37,24,1,0);
        putcbmchar (r3+'0',38,24,1,0);
        putcbmchar ('%',39,24,1,0);
        }

// ### ILLEGAL OPCODE.. HANG 64'S PROCESSOR #################################
void Processor_hung (int curr_loc, int op,int from)
{
        int x,y;
        unsigned char col,text[40],hex[16];
        unsigned int old;
        old=curr_loc;
        for (x=-1;x<201;x++) {
                for (y=-1;y<51;y++) {
                        col=100;
                        if ((x==2||x==3)&&(y>1&&y<48)) {
                                col=101;
                                }
                        if ((y==2||y==3)&&(x>1&&x<198)) {
                                col=101;
                                }
                        if ((x==196||x==197)&&(y>1&&y<48)) {
                                col=101;
                                }
                        if ((y==46||y==47)&&(x>1&&x<198)) {
                                col=101;
                                }
                        Virtualscreen[(x+60)+320*(y+75)]=col;
                        }
                }
        for (x=0;x<10;x++) {
                hex[x]='0'+x;
                }
        for (x=0;x<6;x++) {
                hex[10+x]='A'+x;
                }
        strcpy (text,"ILLEGAL OP xx AT xxxx");
        text[11]=hex[op>>4];
        text[12]=hex[op&0xF];
        text[17]=hex[(curr_loc>>12)&0xF];
        text[18]=hex[(curr_loc>>8)&0xF];
        text[19]=hex[(curr_loc>>4)&0xF];
        text[20]=hex[curr_loc&0xF];
        for (x=0;x<strlen(text);x++) {
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,9+x,11,7,0);
                }
        strcpy (text,"  JUMPED FROM xxxx  ");
        text[14]=hex[(from>>12)&0xF];
        text[15]=hex[(from>>8)&0xF];
        text[16]=hex[(from>>4)&0xF];
        text[17]=hex[from&0xF];
        for (x=0;x<strlen(text);x++) {
                col=text[x];
                if(col>64&&col<91)
                col=col-64;
                putcbmchar (col,10+x,13,7,0);
                }
        flip();
        curr_loc=old;
        while(!key[KB_space]&&!done)
        CIA();
        //Keep us from getting into tight, unescapable loops
        }

// ### CLEAR THE EMULATED MEMORY ############################################
void clearmem (void)
{
        unsigned int temp;
        for (temp=0;temp<65535;temp++) {
                if(temp&0x80)
                RAMPointer[temp]=0x66;
                else RAMPointer[temp]=0x99;
                }
        for(temp=0;temp<1000;temp++) {
                ColorPointer[temp]=0;
                }
        for(temp=0;temp<0x2F;temp++) {
                VICRegs[temp]=0;
                }
        for(temp=0;temp<0x1D;temp++) {
                SIDRegs[temp]=0;
                }
        for(temp=0;temp<0x10;temp++) {
                CIA1Regs[temp]=CIA2Regs[temp]=0;
                }
        RAMPointer[0]=0x2F;
        RAMPointer[1]=0x37;
        enable1a=enable1b=enable2a=enable2b=vic_den=vic_ec=vic_b0c=0;
        // ADD BY MAX
        //////////////////////////////////////////
        if (Cartflg) {
                loadcrt(CurrentCrt);
                }
        //////////////////////////////////////////
        
        }

// ### WAIT FOR MONITORS 60HZ RETRACE #######################################
void waitretrace (void)
{
        _asm {
                mov dx,0x3DA}
        l1:
        _asm {
                in al,dx;
                and al,0x08;
                jnz l1}
        l2:
        _asm {
                in al,dx;
                and al,0x08;
                jz l2}
        }

// ### SET VIDEOMODE ########################################################
void SetMode(char mode)
{
        waitretrace ();
        asm {
                mov AH,0;
                mov AL, (mode);
                int 0x10;
                }
        if (mode!=0x03){
                _asm {
                        mov  ah, 1;
                        mov  cx, 0x1400;
                        int  0x10}
                }
        if (mode==0x13&&vidmode==1) {
                // THANKS TO PAUL TOTH
                _asm{
                          mov   ax, 0x13       }
                _asm{
                          int   0x10           }
                _asm{
                          mov   dx, 0x3C4      }
                       /* Sequencer Register */
                _asm{
                          mov   ax, 0x0604     }
                       /* Disable Chain 4 Mode */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x0100     }
                       /* (A)synchronous Reset */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   dx, 0x3C2      }
                       /* VGA Misc Register */
                _asm{
                          mov   al, 0xE7       }
                       /* Use 28Mhz Clock & 60Hz */
                _asm{
                          out   dx, al         }
                _asm{
                          mov   dx, 0x3C4      }
                       /* Sequencer Register */
                _asm{
                          mov   ax, 0x0300     }
                       /* Restart Sequencer */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   dx, 0x3D4      }
                       /* VGA CrtC Registers */
                _asm{
                          mov   al, 0x11       }
                       /* CrtC register 11h */
                _asm{
                          out   dx, al         }
                       /* Load current value */
                _asm{
                          inc   dx             }
                       /* Point to data */
                _asm{
                          in    al, dx         }
                       /* Get CrtC register 11h */
                _asm{
                          and   al, 0x7F       }
                       /* Mask out Write protect */
                _asm{
                          out   dx, al         }
                       /* and send it back */
                _asm{
                          mov   dx, 0x3D4      }
                       /* VGA CrtC Registers */
                _asm{
                          cld                  }
                       /* Forward block load */
                _asm{
                          mov   ax, 0x6B00     }
                       /* Horizontal total          */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x5901     }
                       /* Horizontal displayed      */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x5A02     }
                       /* Start horizontal blanking */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x8E03     }
                       /* 8E - end horizontal blanking   */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x5E04     }
                       /* Start H sync.             */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x8A05     }
                       /* 8A - end H sync.               */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x0D06     }
                       /* Vertical total            */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x3E07     }
                       /* Overflow 0011-1110        */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x4109     }
                       /* Cell height  0100-0001    */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0xEA10     }
                       /* V sync. start             */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0xAC11     }
                       /* V sync. end/Prot CR0 CR7  */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0xDF12     }
                       /* Vertical displayed        */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x2D13     }
                       /* 2D offset       5A->180 40->128 */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x0014     }
                       /* DWord mode off            */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0xE715     }
                       /* V Blank start             */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0x0616     }
                       /* V Blank end               */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   ax, 0xE317     }
                       /* Turn on Byte mode         */
                _asm{
                          out   dx, ax         }
                _asm{
                          mov   dx, 0x3D4      }
                       /* VGA CrtC Registers */
                _asm{
                          mov   al, 0x11       }
                       /* CrtC register 11h */
                _asm{
                          out   dx, al         }
                       /* Load current value */
                _asm{
                          inc   dx             }
                       /* Point to data */
                _asm{
                          in    al, dx         }
                       /* Get CrtC register 11h */
                _asm{
                          or    al, 0x80       }
                       /* Mask *in* Write protect */
                _asm{
                          out   dx, al         }
                       /* and send it back */
                _asm{
                          mov dx,0x3C4         }
                _asm{
                          mov ax,0x0F02        }
                _asm{
                          out dx,ax            }
                _asm{
                          mov ax,0x0000        }
                _asm{
                          push 0xa000          }
                _asm{
                          pop es               }
                _asm{
                          xor di,di            }
                _asm{
                          mov cx,64800         }
                _asm{
                          rep stosw            }
                }
        }

// ### END OF EMULATION .. CLEAN UP AND RETURN ##############################
void Cleanup(unsigned char message[161])
{
        int a,b,c;
        struct dostime_t t;
        _dos_gettime(&t);
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
	//while(inp(0x64)&2);
	//outp(0x60,0xED);
	//while(inp(0x64)&1==0);
	//while(inp(0x60)!=0xFA);
	//outp(0x60,SNDkeys);
        if(modeset)SetMode(0x03);
        textcolor (7);
        textbackground(0);
	clrscr();
	printf ("END OF EMULATION AT %d:%02d:%02d\n\n",t.hour,t.minute,t.second);
        a=VERMAJ;
        b=VERMIN;
        c=VERMINTWO;
        if(allocated){
		printf ("- Releasing allocated memory...");
		farfree(BasicPointer);
		farfree(KernalPointer);
		farfree(Virtualscreen);
		farfree(RAMPointer);
		farfree(CharPointer);
		printf ("Done\n");
		}
	printf ("- Releasing keyboard...");
	_dos_setvect(0x09, Old_Isr);
	printf("Done\n");
	printf ("- Showing exit screen...\n\n");
	clrscr ();
	printf ("Come Back 64 v%c.%c%c - Commodore 64 Emulator\nType CB64 /C for copyright and disclaimer\n",a,b,c);
	if (message[0]!=0) printf ("\nERROR: '%s'\nFor more information, please see http://cb64.fitie.com and http://www.cb64.com\n",message);
	exit(0);
	}

// ### ALLOCATE MEMORY FOR ROMS AND RAM #####################################
void AllocMem(void)
{
        if((BasicPointer=(char far *)farmalloc(8192))==NULL) Cleanup ("Cannot allocate 8K for BASIC");
        if((KernalPointer=(char far *)farmalloc(8192))==NULL) Cleanup ("Cannot allocate 8K for Kernal");
        if((RAMPointer=(char far *)farmalloc(65536))==NULL) Cleanup ("Cannot allocate 64K for RAM");
        if((CharPointer=(char far *)farmalloc(4096))==NULL) Cleanup ("Cannot allocate 4K for CHAR");
        if((ColorPointer=(char far *)farmalloc(1000))==NULL) Cleanup ("Cannot allocate 4K for Color");
        if((Virtualscreen=(char far *)farmalloc(65536))==NULL) Cleanup ("Cannot allocate 64K for virtual screen");
        allocated=1;
        }

// ### LOAD INTERNAL OR EXTERNAL ROMS #######################################
void LoadROM(void)
{
        FILE *infile;
        int index;
        unsigned char t,message[40];
        if ((infile=fopen("BASIC.ROM", "rb")) == NULL) {
                printf ("\n   Loading internal Basic V2 ROM...");
                for(index=0;index<8192;index++) {
                        BasicPointer[index]=ORIGINAL64B[index];
                        }
                }
        else {
                printf ("\n   Loading external BASIC.ROM...");
                for (index=0;index<8192;index++) {
                        BasicPointer[index]=fgetc(infile);
                        }
                fclose(infile);
                }
        if ((infile=fopen("KERNAL.ROM", "rb")) == NULL) {
                printf ("\n   Loading internal Kernal rev. 3 ROM...");
                for(index=0;index<8192;index++) {
                        KernalPointer[index]=ORIGINAL64K[index];
                        }
                }
        else {
                printf ("\n   Loading external KERNAL.ROM...");
                for (index=0;index<8192;index++) {
                        KernalPointer[index]=fgetc(infile);
                        }
                fclose(infile);
                }
        if ((infile=fopen("CHAR.ROM", "rb")) == NULL) {
                printf ("\n   Loading internal character ROM...");
                for(index=0;index<4096;index++) {
                        CharPointer[index]=ORIGINAL64C[index];
                        }
                }
        else {
                printf ("\n   Loading external CHAR.ROM...");
                for (index=0;index<4096;index++) {
                        CharPointer[index]=fgetc(infile);
                        }
                fclose(infile);
                }
        }

// ### PUT A NOTICE ON SCREEN AND WAIT A WHILE ##############################
void Message (unsigned char text[41],unsigned int delayed)
{
        int x,y;
        unsigned char col,xpos;
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        xpos=20-strlen(text)/2;
        for (x=-1;x<201;x++) {
                for (y=7;y<43;y++) {
                        col=100;
                        if ((x==2||x==3)&&(y>9&&y<40)) {
                                col=101;
                                }
                        if ((y==10||y==11)&&(x>1&&x<198)) {
                                col=101;
                                }
                        if ((x==196||x==197)&&(y>9&&y<40)) {
                                col=101;
                                }
                        if ((y==38||y==39)&&(x>1&&x<198)) {
                                col=101;
                                }
                        Virtualscreen[(x+60)+320*(y+75)]=col;
                        }
                }
        for (x=0;x<strlen(text);x++) {
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,xpos+x,12,7,0);
                }
        flip();
        delay (delayed);
        }

// ### SET C64 PALETTE ON VGA ###############################################
void setcolors (void)
{
        unsigned int cbmcolor[16*3]={
                // taken from area 64
                
                0x00,0x00,0x00,
                0xff,0xff,0xff,
                0x88,0x20,0x00,
                0x68,0xd0,0xa8,
                0xa8,0x38,0xa0,
                0x50,0xb8,0x18,
                0x18,0x10,0x90,
                0xf0,0xe8,0x58,
                0xa0,0x48,0x00,
                0x47,0x2b,0x1b,
                0xc8,0x78,0x70,
                0x48,0x48,0x48,
                0x80,0x80,0x80,
                0x98,0xff,0x98,
                0x50,0x90,0xd0,
                0xb8,0xb8,0xb8
                
                }
        ;
        int x,y;
        //C64S
        if (paltype==1) {
                cbmcolor[0]=0x00;
                cbmcolor[1]=0x00;
                cbmcolor[2]=0x00;
                cbmcolor[3]=0xFC;
                cbmcolor[4]=0xFC;
                cbmcolor[5]=0xFC;
                cbmcolor[6]=0xA8;
                cbmcolor[7]=0x00;
                cbmcolor[8]=0x00;
                cbmcolor[9]=0x54;
                cbmcolor[10]=0xFC;
                cbmcolor[11]=0xFC;
                cbmcolor[12]=0xA8;
                cbmcolor[13]=0x00;
                cbmcolor[14]=0xA8;
                cbmcolor[15]=0x00;
                cbmcolor[16]=0xA8;
                cbmcolor[17]=0x00;
                cbmcolor[18]=0x00;
                cbmcolor[19]=0x00;
                cbmcolor[20]=0xA8;
                cbmcolor[21]=0xFC;
                cbmcolor[22]=0xFC;
                cbmcolor[23]=0x00;
                cbmcolor[24]=0xA8;
                cbmcolor[25]=0x54;
                cbmcolor[26]=0x00;
                cbmcolor[27]=0x80;
                cbmcolor[28]=0x2C;
                cbmcolor[29]=0x00;
                cbmcolor[30]=0xFC;
                cbmcolor[31]=0x54;
                cbmcolor[32]=0x54;
                cbmcolor[33]=0x54;
                cbmcolor[34]=0x54;
                cbmcolor[35]=0x54;
                cbmcolor[36]=0x80;
                cbmcolor[37]=0x80;
                cbmcolor[38]=0x80;
                cbmcolor[39]=0x54;
                cbmcolor[40]=0xFC;
                cbmcolor[41]=0x54;
                cbmcolor[42]=0x54;
                cbmcolor[43]=0x54;
                cbmcolor[44]=0xFC;
                cbmcolor[45]=0xA8;
                cbmcolor[46]=0xA8;
                cbmcolor[47]=0xA8;
                }
        //CCS64
        if (paltype==2) {
                cbmcolor[0]=0x10;
                cbmcolor[1]=0x10;
                cbmcolor[2]=0x10;
                cbmcolor[3]=0xFF;
                cbmcolor[4]=0xFF;
                cbmcolor[5]=0xFF;
                cbmcolor[6]=0xE0;
                cbmcolor[7]=0x40;
                cbmcolor[8]=0x40;
                cbmcolor[9]=0x60;
                cbmcolor[10]=0xFF;
                cbmcolor[11]=0xFF;
                cbmcolor[12]=0xE0;
                cbmcolor[13]=0x60;
                cbmcolor[14]=0xE0;
                cbmcolor[15]=0x40;
                cbmcolor[16]=0xE0;
                cbmcolor[17]=0x40;
                cbmcolor[18]=0x40;
                cbmcolor[19]=0x40;
                cbmcolor[20]=0xE0;
                cbmcolor[21]=0xFF;
                cbmcolor[22]=0xFF;
                cbmcolor[23]=0x40;
                cbmcolor[24]=0xE0;
                cbmcolor[25]=0xA0;
                cbmcolor[26]=0x40;
                cbmcolor[27]=0x9C;
                cbmcolor[28]=0x74;
                cbmcolor[29]=0x48;
                cbmcolor[30]=0xFF;
                cbmcolor[31]=0xA0;
                cbmcolor[32]=0xA0;
                cbmcolor[33]=0x54;
                cbmcolor[34]=0x54;
                cbmcolor[35]=0x54;
                cbmcolor[36]=0x88;
                cbmcolor[37]=0x88;
                cbmcolor[38]=0x88;
                cbmcolor[39]=0xA0;
                cbmcolor[40]=0xFF;
                cbmcolor[41]=0xA0;
                cbmcolor[42]=0xA0;
                cbmcolor[43]=0xA0;
                cbmcolor[44]=0xFF;
                cbmcolor[45]=0xC0;
                cbmcolor[46]=0xC0;
                cbmcolor[47]=0xC0;
                }
        //FRODO
        if (paltype==3) {
                cbmcolor[0]=0x00;
                cbmcolor[1]=0x00;
                cbmcolor[2]=0x00;
                cbmcolor[3]=0xFF;
                cbmcolor[4]=0xFF;
                cbmcolor[5]=0xFF;
                cbmcolor[6]=0xCC;
                cbmcolor[7]=0x00;
                cbmcolor[8]=0x00;
                cbmcolor[9]=0x00;
                cbmcolor[10]=0xFF;
                cbmcolor[11]=0xCC;
                cbmcolor[12]=0xFF;
                cbmcolor[13]=0x00;
                cbmcolor[14]=0xFF;
                cbmcolor[15]=0x00;
                cbmcolor[16]=0xCC;
                cbmcolor[17]=0x00;
                cbmcolor[18]=0x00;
                cbmcolor[19]=0x00;
                cbmcolor[20]=0xCC;
                cbmcolor[21]=0xFF;
                cbmcolor[22]=0xFF;
                cbmcolor[23]=0x00;
                cbmcolor[24]=0xFF;
                cbmcolor[25]=0x88;
                cbmcolor[26]=0x00;
                cbmcolor[27]=0x88;
                cbmcolor[28]=0x44;
                cbmcolor[29]=0x00;
                cbmcolor[30]=0xFF;
                cbmcolor[31]=0x88;
                cbmcolor[32]=0x88;
                cbmcolor[33]=0x44;
                cbmcolor[34]=0x44;
                cbmcolor[35]=0x44;
                cbmcolor[36]=0x88;
                cbmcolor[37]=0x88;
                cbmcolor[38]=0x88;
                cbmcolor[39]=0x88;
                cbmcolor[40]=0xFF;
                cbmcolor[41]=0x88;
                cbmcolor[42]=0x88;
                cbmcolor[43]=0x88;
                cbmcolor[44]=0xFF;
                cbmcolor[45]=0xCC;
                cbmcolor[46]=0xCC;
                cbmcolor[47]=0xCC;
                }
        //GODOT
        if (paltype==4) {
                cbmcolor[0]=0x00;
                cbmcolor[1]=0x00;
                cbmcolor[2]=0x00;
                cbmcolor[3]=0xFF;
                cbmcolor[4]=0xFF;
                cbmcolor[5]=0xFF;
                cbmcolor[6]=0x88;
                cbmcolor[7]=0x00;
                cbmcolor[8]=0x00;
                cbmcolor[9]=0xAA;
                cbmcolor[10]=0xFF;
                cbmcolor[11]=0xEE;
                cbmcolor[12]=0xCC;
                cbmcolor[13]=0x44;
                cbmcolor[14]=0xCC;
                cbmcolor[15]=0x00;
                cbmcolor[16]=0xCC;
                cbmcolor[17]=0x55;
                cbmcolor[18]=0x00;
                cbmcolor[19]=0x00;
                cbmcolor[20]=0xAA;
                cbmcolor[21]=0xEE;
                cbmcolor[22]=0xEE;
                cbmcolor[23]=0x77;
                cbmcolor[24]=0xDD;
                cbmcolor[25]=0x88;
                cbmcolor[26]=0x55;
                cbmcolor[27]=0x66;
                cbmcolor[28]=0x44;
                cbmcolor[29]=0x00;
                cbmcolor[30]=0xFE;
                cbmcolor[31]=0x77;
                cbmcolor[32]=0x77;
                cbmcolor[33]=0x33;
                cbmcolor[34]=0x33;
                cbmcolor[35]=0x33;
                cbmcolor[36]=0x77;
                cbmcolor[37]=0x77;
		cbmcolor[38]=0x77;
                cbmcolor[39]=0xAA;
                cbmcolor[40]=0xFF;
                cbmcolor[41]=0x66;
                cbmcolor[42]=0x00;
                cbmcolor[43]=0x88;
                cbmcolor[44]=0xFF;
                cbmcolor[45]=0xBB;
                cbmcolor[46]=0xBB;
                cbmcolor[47]=0xBB;
                }
        //PC64
        if (paltype==5) {
                cbmcolor[0]=0x21;
                cbmcolor[1]=0x21;
                cbmcolor[2]=0x21;
                cbmcolor[3]=0xFF;
                cbmcolor[4]=0xFF;
                cbmcolor[5]=0xFF;
                cbmcolor[6]=0xB5;
		cbmcolor[7]=0x21;
                cbmcolor[8]=0x21;
                cbmcolor[9]=0x73;
                cbmcolor[10]=0xFF;
                cbmcolor[11]=0xFF;
                cbmcolor[12]=0xB5;
                cbmcolor[13]=0x21;
                cbmcolor[14]=0xB5;
                cbmcolor[15]=0x21;
                cbmcolor[16]=0xB5;
                cbmcolor[17]=0x21;
                cbmcolor[18]=0x21;
                cbmcolor[19]=0x21;
                cbmcolor[20]=0xB5;
                cbmcolor[21]=0xFF;
                cbmcolor[22]=0xFF;
                cbmcolor[23]=0x21;
                cbmcolor[24]=0xB5;
                cbmcolor[25]=0x73;
                cbmcolor[26]=0x21;
		cbmcolor[27]=0x94;
                cbmcolor[28]=0x42;
                cbmcolor[29]=0x21;
                cbmcolor[30]=0xFF;
                cbmcolor[31]=0x73;
                cbmcolor[32]=0x73;
                cbmcolor[33]=0x73;
                cbmcolor[34]=0x73;
                cbmcolor[35]=0x73;
                cbmcolor[36]=0x94;
                cbmcolor[37]=0x94;
                cbmcolor[38]=0x94;
                cbmcolor[39]=0x73;
                cbmcolor[40]=0xFF;
                cbmcolor[41]=0x73;
                cbmcolor[42]=0x73;
                cbmcolor[43]=0x73;
                cbmcolor[44]=0xFF;
                cbmcolor[45]=0xB5;
                cbmcolor[46]=0xB5;
		cbmcolor[47]=0xB5;
                }
        //VICE
        if (paltype==6) {
                cbmcolor[0]=0x00;
                cbmcolor[1]=0x00;
                cbmcolor[2]=0x00;
                cbmcolor[3]=0xFD;
                cbmcolor[4]=0xFE;
                cbmcolor[5]=0xFC;
                cbmcolor[6]=0xBE;
                cbmcolor[7]=0x1A;
                cbmcolor[8]=0x24;
                cbmcolor[9]=0x30;
                cbmcolor[10]=0xE6;
                cbmcolor[11]=0xC6;
                cbmcolor[12]=0xB4;
                cbmcolor[13]=0x1A;
                cbmcolor[14]=0xE2;
                cbmcolor[15]=0x1F;
		cbmcolor[16]=0xD2;
                cbmcolor[17]=0x1E;
                cbmcolor[18]=0x21;
                cbmcolor[19]=0x1B;
                cbmcolor[20]=0xAE;
                cbmcolor[21]=0xDF;
                cbmcolor[22]=0xF6;
                cbmcolor[23]=0x0A;
                cbmcolor[24]=0xB8;
                cbmcolor[25]=0x41;
                cbmcolor[26]=0x04;
                cbmcolor[27]=0x6A;
                cbmcolor[28]=0x33;
                cbmcolor[29]=0x04;
                cbmcolor[30]=0xFE;
                cbmcolor[31]=0x4A;
                cbmcolor[32]=0x57;
                cbmcolor[33]=0x42;
                cbmcolor[34]=0x45;
                cbmcolor[35]=0x40;
		cbmcolor[36]=0x70;
                cbmcolor[37]=0x74;
                cbmcolor[38]=0x6F;
                cbmcolor[39]=0x59;
                cbmcolor[40]=0xFE;
                cbmcolor[41]=0x59;
                cbmcolor[42]=0x5F;
                cbmcolor[43]=0x53;
                cbmcolor[44]=0xFE;
                cbmcolor[45]=0xA4;
                cbmcolor[46]=0xA7;
                cbmcolor[47]=0xA2;
                }
        for (x=0;x<16;x++) {
                outportb (0x3c8,32+x);
                outportb (0x3c9,cbmcolor[x*3+0]/4);
                outportb (0x3c9,cbmcolor[x*3+1]/4);
                outportb (0x3c9,cbmcolor[x*3+2]/4);
                }
        for (x=0;x<16*3;x++) {
		cbmcolor[x]=(cbmcolor[x]/4)*gamma;
                if (cbmcolor[x]>63) cbmcolor[x]=63;
                }
        for (x=0;x<16;x++) {
                outportb (0x3c8,100+x);
                outportb (0x3c9,cbmcolor[x*3+0]);
                outportb (0x3c9,cbmcolor[x*3+1]);
                outportb (0x3c9,cbmcolor[x*3+2]);
                outportb (0x3c8,x);
                outportb (0x3c9,cbmcolor[x*3+0]);
                outportb (0x3c9,cbmcolor[x*3+1]);
                outportb (0x3c9,cbmcolor[x*3+2]);
                outportb (0x3c8,200+x);
                y=cbmcolor[x*3+0]+5;
		if (y>63) y=63;
                outportb (0x3c9,y);
                y=cbmcolor[x*3+1]+5;
                if (y>63) y=63;
                outportb (0x3c9,y);
		y=cbmcolor[x*3+2]+5;
		if (y>63) y=63;
                outportb (0x3c9,y);
                outportb (0x3c8,150+x);
		outportb (0x3c9,cbmcolor[x*3+0]/4);
		outportb (0x3c9,cbmcolor[x*3+1]/4);
		outportb (0x3c9,cbmcolor[x*3+2]/4);
		}
	// outportb(0x3c8,0);outportb(0x3c9,0);outportb(0x3c9,0);outportb(0x3c9,0);

	}

// ### LOAD A PROGRAM INTO THE EMULATOR #####################################
void loadprg (unsigned char filename[80])
{
	FILE *infile;
	unsigned int loadat;
	unsigned char data,quit=0;
	if ((infile=fopen(filename, "rb")) == NULL) {
		}
	else {
		if (filename[strlen(filename)-1]=='0') {
			fseek(infile,0x1a,0);
			}
		data=fgetc(infile);
		loadat=data;
		data=fgetc(infile);
		loadat=loadat+data*256;
		do {
                        data=fgetc(infile);
                        RAMPointer[loadat]=data;
			loadat++;
                        if (feof(infile)) quit=1;
			if (loadat==0xffff) quit=1;
			}
                while (quit==0);
		}
	fclose(infile);
	RAMPointer[0x2e]=RAMPointer[0x30]=RAMPointer[0x32]=(unsigned char)((loadat-1)>>8);
	RAMPointer[0x2d]=loadat++-1;
	RAMPointer[0x2f]=loadat++-1;
	RAMPointer[0x31]=loadat++-1;
	}

unsigned char readdisk (unsigned char name[255],unsigned char track,unsigned char sector) {
// READ A SECTOR (TRACK,SECTOR) FROM A DISK IMAGE (NAME) INTO DISKSEC[0-255]
	FILE *infile;
	unsigned int tempread;
	unsigned int trackcounter;
	unsigned int pos=0;
	unsigned char dskerror=0;

	infile=fopen(name, "rb");
	for (trackcounter=1;trackcounter<track;trackcounter++) {
		if (trackcounter<=17) {
			for (tempread=0;tempread<21*256;tempread++) {
				fgetc(infile); // track 1-17: sec 0-20
				}
			}
		if (trackcounter>17&&trackcounter<=24) {
			for (tempread=0;tempread<19*256;tempread++) {
				fgetc(infile); // track 18-24: sec 0-18
				}
			}
		if (trackcounter>24&&trackcounter<=30) {
			for (tempread=0;tempread<18*256;tempread++) {
				fgetc(infile); // track 25-30: sec 0-17
				}
			}
		if (trackcounter>30) {
			for (tempread=0;tempread<17*256;tempread++) {
				fgetc(infile); // track 31-35: sec 0-16
				}
			}
		}
		for (tempread=0;tempread<sector*256;tempread++) {
			fgetc(infile); // go to correct sector
			}
	for (trackcounter=0;trackcounter<256;trackcounter++) {
		disksec[trackcounter]=fgetc(infile);
		}
	fclose (infile);
	if (dskerror==1) {
		disksec[0]=0x00;
		disksec[1]=0xff;
		}
}

// ### WRONG NAME.. LIST CARTS AND PROGRAMS AND SELECT ONE TO LOAD ##########
unsigned char dircart (void)
{
	int done,x,y; unsigned char imagetemp_1,imagetemp_2,imagetemp_3,imagetemp_4;
	unsigned char imagetemp_5,imagetemp_6; unsigned int t64start,t64stop,t64pos;
	unsigned int count1,count2; unsigned char direntries;
	struct ffblk ffblk;
	unsigned char sort1,sort2,blockset=0;
	unsigned char text[40];
	FILE *infile; FILE *outfile;
	unsigned char ret=0;
	unsigned char file[501][15],col,numfiles=1,back,fore;
	unsigned char realname[501][30],loadtype[501];
	unsigned char temp1[255],temp2[255],temp3;
	unsigned char track[501],sector[501];
	unsigned int numblocks[501];
	int oldskipper=skipper;
	imagefile[0]=0;
	selectcart=menupos1; scrollcart=menupos2; menuchangepos=1;
	do {
		} while (key[KB_capslock]);
	for (x=0;x<500;x++) {
		for (y=0;y<15;y++) {
			file[x][y]=0;
			}
		}
	for (x=0;x<500;x++) {
		for (y=0;y<30;y++) {
			realname[x][y]=0;
			}
		}
	SNDkeys&=~(1<<0);
	SNDkeys&=~(1<<1);
	SNDkeys&=~(1<<2);
	percent=100;
	skipper=0;
	frameskip=0;
	showvol=0;
	for (x=-1;x<281;x++) {
		for (y=15;y<135;y++) {
			col=100;
			if ((x==2||x==3)&&(y>17&&y<132)) {
				col=101;
				}
			if ((y==18||y==19)&&(x>1&&x<278)) {
				col=101;
				}
			if ((x==276||x==277)&&(y>17&&y<132)) {
				col=101;
				}
			if ((y==130||y==131)&&(x>1&&x<278)) {
				col=101;
				}
			Virtualscreen[(x+20)+320*(y+25)]=col;
			}
		}
	flip();
        done = findfirst("*.CRT",&ffblk,0);
	if (done==0) {
		while (!done&&numfiles<500) {
			strcpy (file[numfiles],ffblk.ff_name);
                        done = findnext(&ffblk);
			infile=fopen(file[numfiles], "rb");
			fseek (infile,0x20,0);
			for (x=0;x<29;x++)
                        {
                                realname[numfiles][x]=fgetc(infile);
                                loadtype[numfiles]=1;
                                if (realname[numfiles][x]==0) realname[numfiles][x]=' ';
                                if (realname[numfiles][x]>=97&&realname[numfiles][x]<=122) realname[numfiles][x]-=32;
                                }
                        fclose (infile);
			numfiles++;
			}
		}
	done = findfirst("*.T64",&ffblk,0);
	if (done==0) {
                while (!done&&numfiles<500) {
			strcpy (file[numfiles],ffblk.ff_name);
			done = findnext(&ffblk);
			infile=fopen(file[numfiles], "rb");
                        fseek (infile,0x28,0);
                        for (x=0;x<29;x++) {
				realname[numfiles][x]=fgetc(infile);
				loadtype[numfiles]=3;
				if (realname[numfiles][x]==0) realname[numfiles][x]=' ';
				if (realname[numfiles][x]>=97&&realname[numfiles][x]<=122) realname[numfiles][x]-=32;
                                }
                        fclose (infile);
                        numfiles++;
                        }
                }
        done = findfirst("*.D64",&ffblk,0);
        if (done==0) {
		while (!done&&numfiles<500) {
			strcpy (file[numfiles],ffblk.ff_name);
			done = findnext(&ffblk);
                        infile=fopen(file[numfiles], "rb");
			fseek (infile,0x16590,0);
			for (x=0;x<29;x++) {
				realname[numfiles][x]=fgetc(infile);
                                loadtype[numfiles]=4;
                                if (realname[numfiles][x]==0) realname[numfiles][x]=' ';
				if (realname[numfiles][x]==0xA0) realname[numfiles][x]=' ';
				if (realname[numfiles][x]>=97&&realname[numfiles][x]<=122) realname[numfiles][x]-=32;
                                }
                        fclose (infile);
                        numfiles++;
                        }
                }
        done = findfirst("*.LNX",&ffblk,0);
	if (done==0) {
		while (!done&&numfiles<500) {
                        strcpy (file[numfiles],ffblk.ff_name);
			done = findnext(&ffblk);
			infile=fopen(file[numfiles], "rb");
			fseek (infile,0x80,0);
                        for (x=0;x<29;x++) {
				realname[numfiles][x]=fgetc(infile);
				loadtype[numfiles]=5;
				if (realname[numfiles][x]==0) realname[numfiles][x]=' ';
                                if (realname[numfiles][x]==0xA0) realname[numfiles][x]=' ';
                                if (realname[numfiles][x]>=97&&realname[numfiles][x]<=122) realname[numfiles][x]-=32;
				}
			fclose (infile);
			numfiles++;
                        }
                }
        done = findfirst("*.P00",&ffblk,0);
        if (done==0) {
                while (!done&&numfiles<500) {
                        strcpy (file[numfiles],ffblk.ff_name);
                        done = findnext(&ffblk);
                        infile=fopen(file[numfiles], "rb");
			fseek (infile,0x08,0);
			for (x=0;x<29;x++) {
				realname[numfiles][x]=fgetc(infile);
				loadtype[numfiles]=2;
				if (realname[numfiles][x]==0) realname[numfiles][x]=' ';
				if (realname[numfiles][x]>=97&&realname[numfiles][x]<=122) realname[numfiles][x]-=32;
				}
			fclose (infile);
			numfiles++;
			}
		}
	done = findfirst("*.PRG",&ffblk,0);
	if (done==0) {
		while (!done&&numfiles<500) {
			strcpy (file[numfiles],ffblk.ff_name);
			done = findnext(&ffblk);
			strcpy (realname[numfiles],"NO DESCRIPTION   ");
			if (!strcmp(file[numfiles],"T64TEMP.PRG")) {
				strcpy (realname[numfiles],"TAPE EXTRACT     ");
				}
			if (!strcmp(file[numfiles],"D64TEMP.PRG")) {
				strcpy (realname[numfiles],"DISK EXTRACT     ");
				}
			loadtype[numfiles]=2;
			numfiles++;
			}
		}
	numfiles--;
	if (numfiles!=255) {
		//if (numfiles<11) {numfiles+=11;}
		strcpy (file[0],"REMOVE1234");
		loadtype[0]=0;
		strcpy (realname[0],"REMOVE CART            ");
		strcpy (text,"CARTS, TAPES & PROGRAMS FOUND:");
		for (x=0;x<strlen(text);x++) {
			col=text[x];
			if (col>64&&col<91) col=col-64;
			putcbmchar (col,5+x,6,7,0);
			}
		done=0;
		//Message ("DIR LOADED",1000);
		do {
			for (y=0;y<11;y++) {
				fore=1;
				back=0;
				if(y==selectcart) {
					back=2;
					fore=13;
					}
				strcpy (text,"xxxx                            ");
				if (loadtype[y+scrollcart]==0) {
					text[0]='C';
					text[1]='A';
					text[2]='R';
					text[3]='T';
                                        }
                                if (loadtype[y+scrollcart]==1) {
                                        text[0]='C';
					text[1]='A';
                                        text[2]='R';
                                        text[3]='T';
					}
                                if (loadtype[y+scrollcart]==2) {
					text[0]='P';
					text[1]='R';
                                        text[2]='O';
					text[3]='G';
					}
				if (loadtype[y+scrollcart]==3) {
					text[0]='T';
					text[1]='A';
                                        text[2]='P';
					text[3]='E';
					}
				if (loadtype[y+scrollcart]==4) {
                                        text[0]='D';
					text[1]='I';
					text[2]='S';
					text[3]='K';
                                        }
                                if (loadtype[y+scrollcart]==5) {
					text[0]='L';
                                        text[1]='Y';
                                        text[2]='N';
					text[3]='X';
                                        }
				for (x=0;x<strlen(file[y+scrollcart])-4;x++) {
					text[x+5]=file[y+scrollcart][x];
					if (text[x+5]=='~') {
						text[x+5]=' ';
						x=254;
                                                }
					if (text[x+5]=='_') {
						text[x+5]='-';
						}
                                        }
                                for (x=15;x<32;x++) {
                                        text[x-1]=realname[y+scrollcart][x-15];
					}
                                text[30]=32;
                                /* BAR */
				text[31]=221-128;
				if (scrollcart>(numfiles-22)/11*y) {
					text[31]=160;
					/*BAR*/}
				/* BAR */

				if (y+scrollcart>numfiles) {
					strcpy(text,"                                ");
					}
				for (x=0;x<strlen(text);x++){
                                        col=text[x];
					if (col>64&&col<91) col=col-64;
					putcbmchar (col,4+x,8+y,fore,back);
					}
				}
			flip();
			if (menuchangepos==1) {
				menupos1=selectcart;
				menupos2=scrollcart;
				}
			if (key[KB_escape]) done=1;
			if (key[KB_enter]) {
				menuchangepos=0;
				}
			if (key[KB_page_down]) {
				for (x=0;x<10;x++) {
					selectcart++;
					if (selectcart>10) {
						selectcart=10;
						scrollcart++;
						}
					if (scrollcart>numfiles-10) scrollcart=numfiles-10;
					}
				do{
					}
				while(key[KB_page_down]);
                                for (x=0;x<10;x++) {
                                        if (selectcart>numfiles) {
						selectcart--;
						if (selectcart<0) {
							selectcart=0;
                                                        scrollcart--;
                                                        }
                                                if (scrollcart<0) scrollcart=0;
						}
                                        }
                                }
			if (key[KB_page_up]) {
				for (x=0;x<10;x++) {
                                        selectcart--;
                                        if (selectcart<0) {
                                                selectcart=0;
                                                scrollcart--;
						}
					if (scrollcart<0) scrollcart=0;
					}
                                do{
                                        }
				while(key[KB_page_up]);
				}
			if (key[KB_down]) {
				selectcart++;
                                if (selectcart>10) {
                                        selectcart=10;
					scrollcart++;
                                        }
                                if (scrollcart>numfiles-10) scrollcart=numfiles-10;
				do{
                                        }
                                while(key[KB_down]);
                                if (selectcart>numfiles) {
                                        selectcart--;
                                        if (selectcart<0) {
						selectcart=0;
						scrollcart--;
						}
                                        if (scrollcart<0) scrollcart=0;
                                        }
				}
			if (key[KB_up]) {
				selectcart--;
				if (selectcart<0) {
					selectcart=0;
					scrollcart--;
					}
				if (scrollcart<0) scrollcart=0;
				do{
					}
				while(key[KB_up]);
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==0) {
				done=1;
				reset=1;
				Cartflg=0;
				ret=1;
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==1) {
				done=1;
				strcpy(CurrentCrt,file[(selectcart+scrollcart)]);
				reset=1;
				Cartflg=1;
				ret=1;
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==2) {
				done=1;
				strcpy(loadonstart,file[(selectcart+scrollcart)]);
				loadcounter=0;
				reset=1;
				Cartflg=0;
				ret=1;
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==3) {
				done=0;
				strcpy (text,"                              ");
				infile=fopen(file[selectcart+scrollcart], "rb");
				fseek (infile,0x28,0); // Get TAPE NAME
				for (x=0;x<0x17;x++) {
					text[x]=fgetc(infile);
					}
				fclose (infile);
				for (x=0;x<strlen(text);x++) {
					col=text[x];
					if (col>64&&col<91) col=col-64;
					putcbmchar (col,5+x,6,7,0);
					} // put image name on screen
				if (imagefile[0]!=0) {
					done=1;
					reset=1;
					Cartflg=0;
					ret=1;
					// write temporary prg file from t64
					Message ("EXTRACTING ...",1);
					infile=fopen(imagefile, "rb");
					outfile=fopen("t64temp.prg", "wb");
					fseek (infile,0x40+(0x20*(selectcart+scrollcart))+0x02,0);
					imagetemp_1=fgetc(infile); // start pos (0x01)
					fputc (imagetemp_1,outfile); // byte 1/2
					imagetemp_2=fgetc(infile); // start pos (0x08)
					fputc (imagetemp_2,outfile); // byte 2/2
					imagetemp_5=fgetc(infile); // end pos (1/2)
					imagetemp_6=fgetc(infile); // end pos (2/2)
					t64start=imagetemp_1+256*imagetemp_2; // start
					t64stop=imagetemp_5+256*imagetemp_6;  // stop
					// locate position inside t64
					fseek (infile,0x40+(0x20*(selectcart+scrollcart))+0x08,0);
					imagetemp_1=fgetc(infile); // pos in file xxxxxxXX
					imagetemp_2=fgetc(infile); // pos in file xxxxXXxx
					imagetemp_3=fgetc(infile); // pos in file xxXXxxxx
					imagetemp_4=fgetc(infile); // pos in file XXxxxxxx
					// go to position
					fseek (infile,0,0); // rewind file
					// SET POSITION
					for (t64pos=0;t64pos<imagetemp_3+256*imagetemp_4;t64pos++) {
						for (y=0;y<32;y++) {
							for (count1=0;count1<0x0800;count1++) {
								fgetc(infile);
								}
							}
						}
					for (count1=0;count1<imagetemp_1+256*imagetemp_2;count1++) {
						fgetc (infile);
						}
					// END SET POSITION
					for (y=t64start;y<t64stop;y++) {
						imagetemp_1=fgetc(infile);
						fputc (imagetemp_1,outfile);
						}
					fclose (outfile);
					fclose (infile);
					strcpy(loadonstart,"T64TEMP.PRG");
					loadcounter=0;
					scrollcart=0;
					selectcart=0;
					}
				strcpy (imagefile,file[selectcart+scrollcart]);
				// LOAD T64 CONTENTS
				y=0;
				infile=fopen(file[selectcart+scrollcart], "rb");
				fseek (infile,0x24,0);
				direntries=fgetc(infile); // num files in t64
				do {
					fseek (infile,0x50+0x20*y,0);
					strcpy (file[y],file[selectcart+scrollcart]);
					loadtype[y]=3;
					for (x=0;x<16;x++) {
						realname[y][x]=fgetc(infile);
						}
					y++;
					} while (y<direntries);
				fclose (infile);
				numfiles=direntries-1;
				// END LOAD T64 CONTENTS
				selectcart=0; scrollcart=0; y=0;
				do {
					} while (key[KB_enter]);
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==4) {
				done=0;
				if (imagefile[0]!=0) {
					// imagefile = d64 file
					// selectcart+scrollcart = filenummer
					// track[selectcart+scrollcart] = track
					// sector[selectcart+scrollcart] = sector
					// numblocks[selectcart+scrollcart] = num of blocks
					Message ("EXTRACTING ...",1);
					y=0;
					outfile=fopen("d64temp.prg", "wb");
					imagetemp_3=track[selectcart+scrollcart];
					imagetemp_4=sector[selectcart+scrollcart];
					do { // read d64
						readdisk (imagefile,imagetemp_3,imagetemp_4); // read t/s
						imagetemp_3=disksec[0]; // next t/s
						imagetemp_4=disksec[1];
						for (x=2;x<=255;x++) { // read 253 databytes
							fputc (disksec[x],outfile); // write !
							}
						y++; // 1 block read
						if (imagetemp_3>35||imagetemp_4>20) {
							y=numblocks[selectcart+scrollcart]+1;
							}
						} while (y<numblocks[selectcart+scrollcart]); // end of file?
					fclose (outfile);
					strcpy(loadonstart,"D64TEMP.PRG");
					done=1;
					reset=1;
					Cartflg=0;
					ret=1;
					loadcounter=0;
					scrollcart=0;
					selectcart=0;
					}
				strcpy (text,"0 \"xxxxxxxxxxxxxxxx\" xx xx    ");
				strcpy (imagefile,file[selectcart+scrollcart]);
				readdisk (imagefile,18,0);
				for (x=0;x<16;x++) {
					text[x+3]=disksec[x+144]; // DISK NAME
					if (text[x+3]==0xa0) {
						text[x+3]=' ';
						}
					}
				for (x=0;x<5;x++) {
					text[x+21]=disksec[x+162]; // DISK ID
					if (text[x+21]==0xa0) {
						text[x+21]=' ';
						}
					}
				for (x=0;x<strlen(text);x++) {
					col=text[x];
					if (col>64&&col<91) col=col-64;
					if (x>2&&x<26) {
						col+=128;
						}
					putcbmchar (col,5+x,6,7,0);
					} // put image name on screen
				readdisk(imagefile,18,1);
				numfiles=0;
				do {
					for (y=0;y<8;y++) {
						strcpy (file[numfiles],imagefile);
						for (x=0;x<16;x++) {
							realname[numfiles][x]=disksec[(2+(32*y))+3+x];
							track[numfiles]=disksec[(2+(32*y))+1];
							sector[numfiles]=disksec[(2+(32*y))+2];
							numblocks[numfiles]=disksec[(2+(32*y))+28]+256*(disksec[(2+(32*y))+29]);
							if (realname[numfiles][x]==0xa0) {
								realname[numfiles][x]=' ';
								}
							realname[numfiles][x+1]=0;
							}
						if (realname[numfiles][0]!=0) {
							loadtype[numfiles]=4;
							numfiles++;
							}
						}
					imagetemp_1=disksec[0]; imagetemp_2=disksec[1]; // Next T/S
					readdisk(imagefile,disksec[0],disksec[1]);
					} while ((imagetemp_1!=0)&&(imagetemp_2!=0xff)); // end of list?
				selectcart=0;
				scrollcart=0;
				numfiles--;
				y=0;
				}
			if (key[KB_enter]&&loadtype[(selectcart+scrollcart)]==5) {
				done=0;
				Message ("SORRY.. LYNX NOT DONE",2500);
				}
			if (numfiles<11) scrollcart=0;
			}
		while (done==0);
		resetkeyboard();
		skipper=oldskipper;
		return(ret);
		}
	skipper=oldskipper;
	return(0);
	}

// ### SHOW INFO ABOUT THE VIC'S VIDEOMODE ETC ##############################
void generalvicinfo (void)
{
        int x,y;
        unsigned char text[45];
        int r,g,b;
        unsigned int pos,col,cur;
        float clr;
        unsigned char ecm,bmm,mcm;
        SNDkeys&=~(1<<0);
	SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        for (x=-1;x<281;x++) {
		for (y=15;y<135;y++) {
                        col=100;
                         if ((x==2||x==3)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==18||y==19)&&(x>1&&x<278)) {
                                col=101;
                                }
                        if ((x==276||x==277)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==130||y==131)&&(x>1&&x<278)) {
                                col=101;
				}
                        Virtualscreen[(x+20)+320*(y+25)]=col;
                        }
                }
        strcpy (text,"VIC II BANK:.........$0000-$0FFF");
        if (vic_bank==0xC000) {
                text[22]='C';
                text[28]='F';
                }
        if (vic_bank==0x8000) {
                text[22]='8';
                text[28]='B';
                }
        if (vic_bank==0x4000) {
                text[22]='4';
                text[28]='7';
                }
        if (vic_bank==0x0000) {
                text[22]='0';
                text[28]='3';
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,7,1,0);
                }
        ecm=(Peek(0xD011)&64)/64;
        bmm=(Peek(0xD011)&32)/32;
        mcm=(Peek(0xD016)&16)/16;
        strcpy (text,"MODE OPTIONS:..ECM:  BMM:  MCM: ");
        text[19]='0';
        if (ecm!=0) {
                text[19]='1';
                }
        text[25]='0';
        if (bmm!=0) {
                text[25]='1';
                }
        text[31]='0';
        if (mcm!=0) {
                text[31]='1';
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,9,1,0);
                }
        if (ecm==0&&bmm==0&&mcm==0) {
                strcpy (text,"MODE:.........STANDARD TEXT MODE");
                }
        if (ecm==1&&bmm==0&&mcm==0) {
                strcpy (text,"MODE:..............ECM TEXT MODE");
                }
        if (ecm==0&&bmm==1&&mcm==0) {
                strcpy (text,"MODE:.......STANDARD BITMAP MODE");
                }
        if (ecm==0&&bmm==0&&mcm==1) {
                strcpy (text,"MODE:.......MULTICOLOR TEXT MODE");
                }
        if (ecm==1&&bmm==1&&mcm==0) {
                strcpy (text,"MODE:......INVALID BITMAP MODE 1");
                }
        if (ecm==1&&bmm==0&&mcm==1) {
                strcpy (text,"MODE:..........INVALID TEXT MODE");
                }
        if (ecm==0&&bmm==1&&mcm==1) {
                strcpy (text,"MODE:.....MULTICOLOR BITMAP MODE");
                }
        if (ecm==1&&bmm==1&&mcm==1) {
                strcpy (text,"MODE:......INVALID BITMAP MODE 2");
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,11,1,0);
                }
        strcpy (text,"MEMORY $D000-DFFF:......CHAR ROM");
        if (charrom==0) {
                strcpy (text,"MEMORY $D000-DFFF:........4K RAM");
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,13,1,0);
                }
        strcpy (text,"38/40 COLUMN TEXT DISPLAY:....40");
        if (1-((Peek(0xD016)&8)/8)==1) {
                strcpy (text,"38/40 COLUMN TEXT DISPLAY:....38");
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,15,1,0);
                }
        strcpy (text,"24/25 ROW TEXT DISPLAY:.......25");
        if (1-((Peek(0xD011)&8)/8)==1) {
                strcpy (text,"24/25 ROW TEXT DISPLAY:.......24");
                }
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,17,1,0);
                }
        flip ();
        do {
                }
        while (key[KB_escape]!=1);
        do {
                }
        while (key[KB_escape]==1);
        rawkey=0;
        skipper=0;
        }

// ### GET INFO ON THE SOUNDBLASTER CARD ####################################
void sbgetinfo (void)
{
        int i;
        char *BLASTER=getenv("BLASTER");
        SBbase=0;
        if(BLASTER==NULL)
        if((BLASTER=getenv("blaster"))==NULL)
        {
                //                        Cleanup ("SET BLASTER not detected");
                return(1);
                }
        for(i=0;BLASTER[i]!=0;i++) {
                switch(BLASTER[i]) {
                        case 'A':SBbase=(BLASTER[i+1]-'0')*0x100+
                        (BLASTER[i+2]-'0')*0x10+
                        (BLASTER[i+3]-'0');
                        break;
                        case 'I':SBint=atoi(&BLASTER[i+1]);
                        break;
                        case 'D':SBdma8=atoi(&BLASTER[i+1]);
                        break;
                        case 'H':SBdma16=atoi(&BLASTER[i+1]);
                        break;
                        default: break;
                        }
                }
        return(0);
        }

// ### READ THE SOUNDBLASTER'S VERSION ######################################
unsigned char SB_ver (void)
{
        int vermaj,vermin;
        sbgetinfo();
        vermaj=0;
        if (SBbase!=0) {
                delay (20);
                outportb (SBbase+0xc,0xe1);
                delay (20);
                vermaj=inportb (SBbase+0xa);
                delay (20);
                vermin=inportb (SBbase+0xa);
                }
        return (vermaj);
        }

// ### SHOW INFO ON THE SID (SOUND INTERFACE) ON SCREEN #####################
void sidinfo (void)
{
        int x,y;
        unsigned char text[45];
        int r,g,b;
        unsigned int pos,col,cur;
        float clr;
        unsigned char ecm,bmm,mcm,vers;
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        for (x=-1;x<281;x++) {
                for (y=15;y<135;y++) {
                        col=100;
                         if ((x==2||x==3)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==18||y==19)&&(x>1&&x<278)) {
                                col=101;
                                }
                        if ((x==276||x==277)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==130||y==131)&&(x>1&&x<278)) {
                                col=101;
                                }
                        Virtualscreen[(x+20)+320*(y+25)]=col;
                        }
                }
        vers=SB_ver();
        if (vers<=4) strcpy (text,"SNDCARD DRIVER: SNDBLASTER 8 BIT");
        if (vers>=4) strcpy (text,"SNDCARD DRIVER: SOUNDBLASTER 16 ");
        if (vers==0) strcpy (text,"SNDCARD DRIVER: NO SOUNDCARD    ");
        if (HARDSID==0x300) strcpy (text,"SNDCARD DRIVER: HARDSID AT 0X300");
        if (HARDSID==0x302) strcpy (text,"SNDCARD DRIVER: HARDSID AT 0X302");
        if (HARDSID==0x304) strcpy (text,"SNDCARD DRIVER: HARDSID AT 0X304");
        if (HARDSID==0x306) strcpy (text,"SNDCARD DRIVER: HARDSID AT 0X306");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,7,1,0);
                }
        if (vers==0) strcpy (text,"DETECTED SNDCD: NO SOUNDCARD    ");
        if (vers==1) strcpy (text,"DETECTED SNDCD: SNDBLASTER 8 BIT");
        if (vers==2) strcpy (text,"DETECTED SNDCD: SOUNDBLASTER 2.0");
        if (vers==3) strcpy (text,"DETECTED SNDCD: SOUNDBLASTER PRO");
        if (vers==4) strcpy (text,"DETECTED SNDCD: SB16/AWE32/AWE64");
        if (vers>=5) strcpy (text,"DETECTED SNDCD: VERY NEW V5+ SB ");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,4+x,8,1,0);
                }
        strcpy (text,"SID FUNCTION KEYS:");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,11+x,10,1,0);
                }
        strcpy (text,"CTRL+F1:....VOICE 1 ON/OFF");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,7+x,12,1,0);
                }
        strcpy (text,"CTRL+F2:....VOICE 2 ON/OFF");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,7+x,13,1,0);
                }
        strcpy (text,"CTRL+F3:....VOICE 3 ON/OFF");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<91) col=col-64;
                putcbmchar (col,7+x,14,1,0);
                }
        strcpy (text,"CTRL+[:.........VOL. LOWER");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<94) col=col-64;
                putcbmchar (col,7+x,16,1,0);
                }
        strcpy (text,"CTRL+]:........VOL. HIGHER");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>64&&col<94) col=col-64;
                putcbmchar (col,7+x,17,1,0);
                }
        flip ();
        do {
                }
        while (key[KB_escape]!=1);
        do {
                }
        while (key[KB_escape]==1);
        rawkey=0;
        skipper=0;
        }

// ### SHOW INFO ABOUT CB64 #################################################
void intro (void)
{
        int x,y;
        unsigned char text[45],cc;
        int r,g,b;
        unsigned int pos,filepos=0,col,cur;
        float clr;
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        for (pos=0;pos<65535;pos++) {
                Virtualscreen[pos]=150;
                }
        strcpy (text,"COME BACK 64");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,14+x,4,1,0);
                }
        strcpy (text,"COMMODORE 64 EMULATOR");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,9+x,6,5,0);
                }
        strcpy (text,"VERSION x.xx");
        text[8]=VERMAJ;
        text[10]=VERMIN;
        text[11]=VERMINTWO;
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,14+x,7,5,0);
                }
        strcpy (text,"FREEWARE, CREATED BY");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,10+x,16,1,0);
                }
        strcpy (text,"J. FITIE <WWW.FITIE.COM>");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,8+x,18,5,0);
                }
        strcpy (text,"- PRESS SPACE TO CONTINUE -");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,6+x,24,3,0);
                }
        strcpy (text,"1/3");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,37+x,0,1,0);
                }
        flip();
        do{
                }
        while (rawkey!=KB_space);
        do{
                }
        while(rawkey==KB_space);
        for (pos=0;pos<65535;pos++) {
                Virtualscreen[pos]=150;
                }
        strcpy (text,"- PRESS SPACE TO CONTINUE -");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,6+x,24,3,0);
                }
        strcpy (text,"MAIN PROGRAMMER:....................");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,2+x,2,1,0);
                }
        strcpy (text,"JOHAN FITIE");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,27+x,4,5,0);
                }
        strcpy (text,"ORIGINAL COMMODORE 64 PALETTE:......");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,2+x,6,1,0);
                }
        strcpy (text,"AREA64");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,32+x,8,5,0);
                }
        strcpy (text,"DOCUMENTATION, ROUTINES AND SUPPORT:");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,2+x,10,1,0);
                }
        strcpy (text,"BRAD MARTIN/BUTCHA");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,20+x,12,5,0);
                }
        strcpy (text,"BACCHUS/FAIRLIGHT");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,21+x,13,5,0);
                }
        strcpy (text,"MARKO MAKELA");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,26+x,14,5,0);
                }
        strcpy (text,"PER HAKAN SUNDELL/CCS64");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,15+x,15,5,0);
                }
        strcpy (text,"MICHAEL SCHWENDT/SIDPLAY");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,14+x,16,5,0);
                }
        strcpy (text,"WOLFGANG LORENZ/PC64");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,18+x,17,5,0);
                }
        strcpy (text,"STEVEN H DON/SHD");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,22+x,18,5,0);
                }
        strcpy (text,"JOE FORSTER/STA");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,23+x,19,5,0);
                }
        strcpy (text,"MASSIMO AGOSTINELLI");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,19+x,20,5,0);
                }
        strcpy (text,"PAUL TOTH");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,29+x,21,5,0);
                }
        strcpy (text,"2/3");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,37+x,0,1,0);
                }
        flip();
        do{
                }
        while (rawkey!=KB_space);
        do{
                }
        while(rawkey==KB_space);
        for (pos=0;pos<65535;pos++) {
                Virtualscreen[pos]=150;
                }
        strcpy (text,"- PRESS SPACE TO CONTINUE -");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,6+x,24,3,0);
                }
        strcpy (text,"UPDATES CAN BE FOUND ON");
        for (x=0;x<strlen(text);x++){
                col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,8+x,6,1,0);
		}
	strcpy (text,"   HTTP://CB64.FITIE.COM   ");
	for (x=0;x<strlen(text);x++){
		col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,7+x,8,5,0);
		}
	strcpy (text,"CONTACT THE AUTHOR");
	for (x=0;x<strlen(text);x++){
		col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,11+x,11,1,0);
		}
	strcpy (text,"HTTP://WWW.FITIE.COM");
	for (x=0;x<strlen(text);x++){
		col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,10+x,13,5,0);
		}
	strcpy (text,"INCLUDES HARDSID SUPPORT");
	for (x=0;x<strlen(text);x++){
		col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,8+x,16,1,0);
		}
	strcpy (text,"HTTP://WWW.HARDSID.COM");
	for (x=0;x<strlen(text);x++){
		col=text[x];
		if (col>63&&col<91) col=col-64;
		putcbmchar (col,9+x,18,5,0);
		}
        strcpy (text,"3/3");
        for (x=0;x<strlen(text);x++){
                col=text[x];
                if (col>63&&col<91) col=col-64;
                putcbmchar (col,37+x,0,1,0);
                }
        flip();
        do{
                }
        while (rawkey!=KB_space);
        do{
                }
        while(rawkey==KB_space);
        rawkey=0;
        skipper=0;
        }

// ### RESET KEYBOARD... SOMETIMES IT JUST 'HANGS' ##########################
void resetkeyboard (void)
{
        unsigned int index;
        for(index=0;index<255;index++) {
                key_pressed[index]=255;
                }
        keysdown=0;
        for (index=0;index<0x80;index++) {
                key[index]=0;
                }
        }

// ### MAIN MENU ############################################################
void menu (void)
{
        unsigned int x,y,select=1,back,fore,index;
        int changecol=0;
        unsigned char text[40],col,exit=0,msg[40],oldsidon;
        int oldskipper=skipper;
        float oldgamma;
        oldgamma=gamma;
        gamma=0.4;
        /* setcolors ();
        */gamma=oldgamma;
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        oldsidon=sidon;
        sidon=0;
        RAMPointer[0xDFFC]=VERMAJ;
        RAMPointer[0xDFFD]=VERMIN;
        do {
                strcpy (text,"** COME BACK 64 -- VER x.xx **");
                text[23]=RAMPointer[0xDFFC];
                text[25]=RAMPointer[0xDFFD];
                text[26]=VERMINTWO;
                for (x=0;x<strlen(text);x++) {
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,1,13+changecol,0);
                        }
		strcpy (text," VISIT HTTP://CB64.FITIE.COM  ");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,23,13+changecol,0);
                        }
                fore=14;
                back=6;
                if (select==1) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"COLOR SCHEME......CB64 DEFAULT");
                if (paltype==1) strcpy (text,"COLOR SCHEME..............C64S");
                if (paltype==2) strcpy (text,"COLOR SCHEME.............CCS64");
                if (paltype==3) strcpy (text,"COLOR SCHEME.............FRODO");
                if (paltype==4) strcpy (text,"COLOR SCHEME.............GODOT");
                if (paltype==5) strcpy (text,"COLOR SCHEME..............PC64");
                if (paltype==6) strcpy (text,"COLOR SCHEME..............VICE");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,3,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==2) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"EMULATOR ID AT $DFA0 (F9)..YES");
                if (emuid==0) strcpy (text,"EMULATOR ID AT $DFA0 (F9)...NO");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,4,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==3) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"SUPPRESS 'ILLEGAL OPCODE'...NO");
                if (illopc==0) strcpy (text,"SUPPRESS 'ILLEGAL OPCODE'..YES");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,5,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==4) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"FRAMESKIP.................NONE");
                if (skiptype==1) strcpy (text,"FRAMESKIP.................AUTO");
                if (skiptype==2) strcpy (text,"FRAMESKIP......EVERY 2ND FRAME");
                if (skiptype==3) strcpy (text,"FRAMESKIP......EVERY 4TH FRAME");
                if (skiptype==4) strcpy (text,"FRAMESKIP......EVERY 6TH FRAME");
                if (skiptype==5) strcpy (text,"FRAMESKIP......EVERY 8TH FRAME");
                if (skiptype==6) strcpy (text,"FRAMESKIP.....EVERY 10TH FRAME");
                if (skiptype==7) strcpy (text,"FRAMESKIP.....EVERY 12TH FRAME");
                if (skiptype==8) strcpy (text,"FRAMESKIP.....EVERY 14TH FRAME");
                if (skiptype==9) strcpy (text,"FRAMESKIP.....EVERY 16TH FRAME");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,6,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==5) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"INTERLACE.................NONE");
                if (interl_on==1) strcpy (text,"INTERLACE...............ALWAYS");
                if (interl_on==2) strcpy (text,"INTERLACE.................AUTO");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,7,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==6) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"EMULATED JOYSTICK (8546+)....2");
                if (joytoemu==2) strcpy (text,"EMULATED JOYSTICK (8546+)....1");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,8,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==7) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"HARDSID OR BLASTER.....BLASTER");
                if (HARDSID==0x300) strcpy (text,"HARDSID OR BLASTER.HARDSID 300");
                if (HARDSID==0x302) strcpy (text,"HARDSID OR BLASTER.HARDSID 302");
                if (HARDSID==0x304) strcpy (text,"HARDSID OR BLASTER.HARDSID 304");
                if (HARDSID==0x306) strcpy (text,"HARDSID OR BLASTER.HARDSID 306");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,9,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==8) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"RESET EMULATOR......CTRL/ALT/R");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,10,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==9) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"SID FUNCTION KEYS...CTRL/ALT/K");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,11,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==10) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"VIC II INFORMATION..CTRL/ALT/V");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,12,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==11) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"STATUS DISPLAY.......CAPS LOCK");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,13,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==12) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"RELATIVE SPEED.....SCROLL LOCK");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,14,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==13) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"SPRITE INFO.........CTRL/ALT/I");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,15,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==14) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"CARTRIDGE/FILE MENU........F10");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,16,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==15) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"GAMMA..........CTRL/ALT/+ OR -");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,17,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==17) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"SPRITE METHOD (SINGLE)..ALT/F2");
                if (spritemethod==1) strcpy (text,"SPRITE METHOD (COMPAT.).ALT/F2");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,19,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==16) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"ABOUT...................ALT/F1");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,18,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==18) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"VIDEOMODE (320X200).....ALT/F3");
                if (vidmode==1) {
                        strcpy (text,"VIDEOMODE (360X240).....ALT/F3");
                        }
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,20,fore+changecol,back);
                        }
                fore=14;
                back=6;
                if (select==19) {
                        back=14;
                        fore=6;
                        }
                strcpy (text,"QUIT COME BACK 64.......ALT/F4");
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,5+x,21,fore+changecol,back);
                        }
                flip ();
                if (key[KB_down]) {
                        select++;
                        if (select==20) select=1;
                        do {
                                }
                        while (key[KB_down]);
                        }
                if (key[KB_up]) {
                        select--;
                        if (select==0) select=19;
                        do {
                                }
                        while (key[KB_up]);
                        }
                if (key[KB_enter])
                
                {
                        do {
                                }
                        while (key[KB_enter]);
                        if (select==1) {
                                paltype++;
                                if (paltype==7) {
                                        paltype=0;
                                        }
                                ;
                                setcolors();
                                }
                        if (select==2) {
                                emuid=1-emuid;
                                }
                        if (select==3) {
                                illopc=1-illopc;
                                }
                        if (select==4) {
                                skiptype++;
                                if (skiptype==10) {
                                        skiptype=0;
                                        }
                                autoskip=0;
                                if (skiptype==1) {
                                        autoskip=1;
                                        }
                                manskp=0;
                                if (skiptype==2) {
                                        manskp=1;
                                        autoskip=1;
                                        }
                                if (skiptype==3) {
                                        manskp=3;
                                        autoskip=1;
                                        }
                                if (skiptype==4) {
                                        manskp=5;
                                        autoskip=1;
                                        }
                                if (skiptype==5) {
                                        manskp=7;
                                        autoskip=1;
                                        }
                                if (skiptype==6) {
                                        manskp=9;
                                        autoskip=1;
                                        }
                                if (skiptype==7) {
                                        manskp=11;
                                        autoskip=1;
                                        }
                                if (skiptype==8) {
                                        manskp=13;
                                        autoskip=1;
                                        }
                                if (skiptype==9) {
                                        manskp=15;
                                        autoskip=1;
                                        }
                                }
                        if (select==5) {
                                interl_on++;
                                if (interl_on==3) interl_on=0;
                                }
                        if (select==6) {
                                joytoemu=3-joytoemu;
                                }
                        if (select==7) {
                                HARDSID++;
                                if (HARDSID==1) {
                                        HARDSID=0x300;
                                        }
                                if (HARDSID==0x301) {
                                        HARDSID=0x302;
                                        }
                                if (HARDSID==0x303) {
                                        HARDSID=0x304;
                                        }
                                if (HARDSID==0x305) {
                                        HARDSID=0x306;
                                        }
                                if (HARDSID==0x307) {
                                        HARDSID=0;
                                        }
                                if (HARDSID==0x300) {
                                        Message ("HARDSID ON - SB DISABLED",1000);
                                        }
                                if (HARDSID==0) {
                                        Message ("HARDSID OFF",1000);
                                        }
                                }
                        if (select==8) {
                                reset=1;
                                exit=1;
                                }
                        if (select==9) {
                                sidinfo();
                                }
                        if (select==10) {
                                generalvicinfo();
                                }
                        if (select==11) {
                                Message ("USE IN EMULATOR ONLY",1000);
                                }
                        if (select==12) {
                                Message ("USE IN EMULATOR ONLY",1000);
                                }
                        if (select==13) {
                                spriteinfo();
                                }
                        if (select==14) {
				exit=dircart();
                                }
                        if (select==15) {
                                Message ("USE IN EMULATOR ONLY",1000);
                                }
                        if (select==16) {
                                intro();
                                setcolors();
                                exit=1;
                                }
                        if (select==17) {
                                spritemethod=1-spritemethod;
                                }
                        if (select==18) {
                                vidmode=1-vidmode;
                                SetMode(0x13);
                                setcolors();
                                do {
                                        }
                                while (key[KB_f3]);
                                }
                        if (select==19) {
                                done=1;
                                exit=1;
                                }
                        do {
                                }
                        while (key[KB_enter]);
			}
                if (key[KB_escape]) exit=1;
                }
        while (exit==0);
        rawkey=0;
        sidon=oldsidon;
        skipper=oldskipper;
        setcolors();
        }

// ### GET SOUNDBLASTER INFO ################################################
static int sbgetset(void)
{
        int i;
        char *BLASTER=getenv("BLASTER");
        if(BLASTER==NULL)
        if((BLASTER=getenv("blaster"))==NULL)
        {
                //                        Cleanup ("SET BLASTER not detected");
                return(1);
                }
        for(i=0;BLASTER[i]!=0;i++) {
                switch(BLASTER[i]) {
                        case 'A':SBbase=(BLASTER[i+1]-'0')*0x100+
                        (BLASTER[i+2]-'0')*0x10+
                        (BLASTER[i+3]-'0');
                        sbaddr=SBbase;
                        break;
                        default: break;
                        }
                }
        return(0);
        }

// ### SET SOUNDBLASTER VOLUME ##############################################
void sbvol (unsigned char vol)
{
        outportb (sbaddr+4,4);
        outportb (sbaddr+5,(vol<<4)|vol);
        }

// ### DRAW A SINGLE COLOR SPRITE ###########################################
void Singlecolsprite (unsigned char primecol,unsigned int spriteloc,unsigned char dubx,unsigned char duby,unsigned char addx,int xpos,int ypos,int screen_y)
{
        unsigned char x1,x2,y,check,curr,col;
        unsigned int screenpos,rampos;
        int xnow,ynow;
        xpos+=addx*256;
        col=primecol+100;
        for (y=0;y<21;y++) {
                if (y*(duby+1)+ypos<=screen_y) {
                        for (x1=0;x1<3;x1++) {
                                curr=RAMPointer[spriteloc+x1+3*y];
                                check=128;
                                for (x2=0;x2<8;x2++) {
                                        if (curr>=check) {
                                                curr=curr-check;
                                                screenpos=((x1*8+x2)*(dubx+1)+xpos)+320*(y*(duby+1)+ypos);
                                                xnow=(x1*8+x2)*(dubx+1)+xpos;
                                                ynow=(y*(duby+1)+ypos);
                                                if (xnow>=0&&xnow<=319&&ynow>=0&&ypos+y<=199) Virtualscreen[screenpos]=col;
                                                if (dubx==1&&xnow+1>=0&&xnow+1<=319&&ynow>=0&&ynow<=199) {
                                                        Virtualscreen[screenpos+1]=col;
                                                        }
                                                if (duby==1&&xnow>=0&&xnow<=319&&ynow+1>=0&&ynow+1<=199) {
                                                        Virtualscreen[screenpos+320]=col;
                                                        }
                                                if (dubx==1&&duby==1&&xnow+1>=0&&xnow+1<=319&&ynow+1>=0&&ynow+1<=199) {
                                                        Virtualscreen[screenpos+321]=col;
                                                        }
                                                }
                                        check=check/2;
                                        }
                                }
                        }
                }
        }

// ### DRAW A MULTI-COLOR SPRITE ############################################
void Multicolsprite (unsigned char primecol,unsigned char coltwo,unsigned char colthree,unsigned int spriteloc,unsigned char dubx,unsigned char duby,unsigned char addx,int xpos,int ypos,int screen_y)
{
        unsigned char x1,x2,y,check,curr,col,multicol,colors[4];
        unsigned int screenpos,rampos;
        int xnow,ynow;
        xpos+=addx*256;
        colors[1]=coltwo;
        //VICRegs[0x25];
        colors[3]=colthree;
        //VICRegs[0x26];
        colors[2]=primecol;
        col=colors[2];
        for (y=0;y<21;y++) {
                if (y*(duby+1)+ypos<=screen_y) {
                        for (x1=0;x1<3;x1++) {
                                curr=RAMPointer[spriteloc+x1+3*y];
                                check=128;
                                for (x2=0;x2<4;x2++) {
                                        multicol=0;
                                        if (curr>=check) {
                                                curr=curr-check;
                                                multicol+=2;
                                                }
                                        check=check/2;
                                        if (curr>=check) {
                                                curr=curr-check;
                                                multicol+=1;
                                                }
                                        check=check/2;
                                        col=colors[multicol];
                                        if (multicol!=0) {
                                                screenpos=(x1*8+x2*2)*(dubx+1)+xpos+320*((y)*(duby+1)+ypos);
                                                xnow=(x1*8+x2*2)*(dubx+1)+xpos;
                                                ynow=((y)*(duby+1)+ypos);
                                                if (xnow>=0&&xnow<=319&&ynow>=0&&ypos+y<=199) Virtualscreen[screenpos]=col+100;
                                                if (xnow+1>=0&&xnow+1<=319&&ynow>=0&&ypos+y<=199) Virtualscreen[screenpos+1]=col+100;
                                                if (dubx==1) {
                                                        if (xnow+2>=0&&xnow+2<=319&&ynow>=0&&ypos+y<=199) Virtualscreen[screenpos+2]=col+100;
                                                        if (xnow+3>=0&&xnow+3<=319&&ynow>=0&&ypos+y<=199) Virtualscreen[screenpos+3]=col+100;
                                                        }
                                                if (duby==1) {
                                                        if (xnow>=0&&xnow<=319&&ynow+1>=0&&ypos+y+1<=199) Virtualscreen[screenpos+320]=col+100;
                                                        if (xnow+1>=0&&xnow+1<=319&&ynow+1>=0&&ypos+y+1<=199) Virtualscreen[screenpos+321]=col+100;
                                                        }
                                                if (dubx==1&&duby==1) {
                                                        if (xnow+2>=0&&xnow+2<=319&&ynow+1>=0&&ypos+y+1<=199) Virtualscreen[screenpos+322]=col+100;
                                                        if (xnow+3>=0&&xnow+3<=319&&ynow+1>=0&&ypos+y+1<=199) Virtualscreen[screenpos+323]=col+100;
                                                        }
                                                }
                                        }
                                }
                        }
                }
        }

// ### SCAN SCREEN AND DRAW SPRITES #########################################
void Sprite (int screen_y)
{
        unsigned char x,powtwo;
        int xpos,ypos;
        unsigned char hibyte;
        powtwo=128;
        if (spritemethod==0) {
                for (x=0;x<8;x++)
                {
                        if ((VICRegs[0x15]&powtwo)/powtwo==1) {
                                hibyte=(VICRegs[0x10]&powtwo)/powtwo;
                                ypos=VICRegs[1+(7-x)*2]-50;
                                xpos=VICRegs[0+(7-x)*2]-24;
                                if ((VICRegs[0x1C]&powtwo)/powtwo==1) {
                                        Multicolsprite(VICRegs[0x27+(7-x)],VICRegs[0x25],VICRegs[0x26],(RAMPointer[vic_vm+vic_bank+0x3f8+(7-x)])*64+vic_bank,(VICRegs[0x1D]&powtwo)/powtwo,(VICRegs[0x17]&powtwo)/powtwo,hibyte,xpos,ypos,screen_y);
                                        }
                                else {
                                        Singlecolsprite(VICRegs[0x27+(7-x)],(RAMPointer[vic_vm+vic_bank+0x3f8+(7-x)])*64+vic_bank,(VICRegs[0x1D]&powtwo)/powtwo,(VICRegs[0x17]&powtwo)/powtwo,hibyte,xpos,ypos,screen_y);
                                        }
                                }
                        powtwo=powtwo/2;
                        }
                }
        if (spritemethod==1) {
                for (x=0;x<8;x++)
                {
                        if ((VICRegs[0x15]&powtwo)/powtwo==1) {
                                ypos=VICRegs[1+(7-x)*2]-50;
                                if (screen_y-ypos-92<=21&&screen_y-ypos-42>21) {
                                        hibyte=(VICRegs[0x10]&powtwo)/powtwo;
                                        xpos=VICRegs[0+(7-x)*2]-24;
                                        if ((VICRegs[0x1C]&powtwo)/powtwo==1) {
                                                Multicolsprite(VICRegs[0x27+(7-x)],VICRegs[0x25],VICRegs[0x26],(RAMPointer[vic_vm+vic_bank+0x3f8+(7-x)])*64+vic_bank,(VICRegs[0x1D]&powtwo)/powtwo,(VICRegs[0x17]&powtwo)/powtwo,hibyte,xpos,ypos,screen_y);
                                                }
                                        else {
                                                Singlecolsprite(VICRegs[0x27+(7-x)],(RAMPointer[vic_vm+vic_bank+0x3f8+(7-x)])*64+vic_bank,(VICRegs[0x1D]&powtwo)/powtwo,(VICRegs[0x17]&powtwo)/powtwo,hibyte,xpos,ypos,screen_y);
                                                }
                                        }
                                }
                        powtwo=powtwo/2;
                        }
                }
        }

// ### SHOW INFO ON THE SPRITES AND VIEW THEM ###############################
void spriteinfo (void)
{
        unsigned char powtwo;
        int xpos,ypos;
        unsigned char hibyte;
        int x,y;
        unsigned char text[45];
        int r,g,b;
        unsigned int pos,col,cur;
        float clr;
        unsigned char ecm,bmm,mcm,vers;
        unsigned char col1,col2,col3;
        col1=1;
        col2=VICRegs[0x25];
        col3=VICRegs[0x26];
        SNDkeys&=~(1<<0);
        SNDkeys&=~(1<<1);
        SNDkeys&=~(1<<2);
        percent=100;
        skipper=0;
        frameskip=0;
        showvol=0;
        for (x=-1;x<281;x++) {
                for (y=15;y<135;y++) {
                        col=100;
                         if ((x==2||x==3)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==18||y==19)&&(x>1&&x<278)) {
                                col=101;
                                }
                        if ((x==276||x==277)&&(y>17&&y<132)) {
                                col=101;
                                }
                        if ((y==130||y==131)&&(x>1&&x<278)) {
                                col=101;
                                }
                        Virtualscreen[(x+20)+320*(y+25)]=col;
                        }
                }
        do {
                strcpy (text,"CURRENT SPRITE: xxx");
                text[16]=currsprite/100;
                text[17]=currsprite/10-10*(currsprite/100);
                text[18]=currsprite%10;
                text[16]+='0';
                text[17]+='0';
                text[18]+='0';
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,10+x,7,1,0);
                        }
                if (key[KB_left]) {
                        currsprite--;
                        do {
                                }
                        while (key[KB_left]);
                        if (currsprite==-1) currsprite=255;
                        }
                if (key[KB_right]) {
                        currsprite++;
                        do {
                                }
                        while (key[KB_right]);
                        if (currsprite==256) currsprite=0;
                        }
                if (key[KB_1]) {
                        col1++;
                        if (col1>=16) col1=0;
                        do {
                                }
                        while (key[KB_1]);
                        }
                if (key[KB_2]) {
                        col2++;
                        if (col2>=16) col2=0;
                        do {
                                }
                        while (key[KB_2]);
                        }
                if (key[KB_3]) {
                        col3++;
                        if (col3>=16) col3=0;
                        do {
                                }
                        while (key[KB_3]);
                        }
                for (x=66;x<248;x++) {
                        for (y=74;y<123;y++) {
                                Virtualscreen[x+320*y]=114;
                                }
                        }
                Singlecolsprite (col1,(currsprite)*64+vic_bank,0,0,0,68,88,200);
                Multicolsprite (col1,col2,col3,(currsprite)*64+vic_bank,0,0,0,222,88,200);
                Singlecolsprite (col1,(currsprite)*64+vic_bank,1,1,0,103,77,200);
                Multicolsprite (col1,col2,col3,(currsprite)*64+vic_bank,1,1,0,163,77,200);
                for (x=0;x<25;x++) {
                        for (y=0;y<22;y++) {
                                Virtualscreen[x*2+320*y*2+(103+77*320)]=106;
                                if (x<24) Virtualscreen[x*2+320*y*2+1+(103+77*320)]=106;
                                if (y<21) Virtualscreen[x*2+320*y*2+320+(103+77*320)]=106;
                                }
                        }
                for (x=0;x<13;x++) {
                        for (y=0;y<22;y++) {
                                Virtualscreen[x*4+320*y*2+(163+77*320)]=106;
                                if (x<12) {
                                        Virtualscreen[x*4+320*y*2+1+(163+77*320)]=106;
                                        Virtualscreen[x*4+320*y*2+2+(163+77*320)]=106;
                                        Virtualscreen[x*4+320*y*2+3+(163+77*320)]=106;
                                        }
                                if (y<21) Virtualscreen[x*4+320*y*2+320+(163+77*320)]=106;
                                }
                        }
                strcpy (text," COL1 ");
		y=0;
                if (col1==0) y=1;
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,9+x,17,y,col1);
                        }
                strcpy (text," COL2 ");
                y=0;
                if (col2==0) y=1;
                for (x=0;x<strlen(text);x++){
                        col=text[x];
                        if (col>64&&col<91) col=col-64;
                        putcbmchar (col,17+x,17,y,col2);
                        }
                strcpy (text," COL3 ");
                y=0;
                if (col3==0) y=1;
                for (x=0;x<strlen(text);x++){
                        col=text[x];
			if (col>64&&col<91) col=col-64;
			putcbmchar (col,25+x,17,y,col3);
			}
		flip ();
		}
	while (key[KB_escape]!=1);
	do {
		}
	while (key[KB_escape]==1);
	rawkey=0;
	skipper=0;
	}

// ### COMPLEX INTERFACE ADAPTER ############################################
void CIA (void)
{
	unsigned int index; unsigned char messy,temptel,msgline[255];
	FILE *f;
	if (showsid>0)
	{
		putcbmchar ('S'-64,0,0,1,0);
		putcbmchar ('I'-64,1,0,1,0);
		putcbmchar ('D'-64,2,0,1,0);
		putcbmchar (':',3,0,1,0);
		putcbmchar (' ',4,0,1,0);
		putcbmchar ('V'-64,5,0,1,0);
		putcbmchar ('1',6,0,1,0);
		putcbmchar ('-',7,0,1,0);
		putcbmchar ('0'+v2on,8,0,1,0);
		putcbmchar (' ',9,0,1,0);
                putcbmchar ('V'-64,10,0,1,0);
                putcbmchar ('2',11,0,1,0);
                putcbmchar ('-',12,0,1,0);
                putcbmchar ('0'+v3on,13,0,1,0);
                putcbmchar (' ',14,0,1,0);
                putcbmchar ('V'-64,15,0,1,0);
                putcbmchar ('3',16,0,1,0);
		putcbmchar ('-',17,0,1,0);
                putcbmchar ('0'+v1on,18,0,1,0);
		showsid--;
                }
        if (keysdown!=0) {
                if (key[KB_left_control]&key[KB_sqropen]&volume>0&showvol<44) {
                        volume--;
                        sbvol (volume);
                         showvol=45;
			setstatus ("VOLUME DOWN");
			}
                if (key[KB_left_control]&key[KB_sqrcls]&volume<15&showvol<44) {
			volume++;
                        sbvol (volume);
                        showvol=45;
                        setstatus ("VOLUME UP");
                        }
                if (key[KB_left_alt]&key[KB_f3]) {
                        vidmode=1-vidmode;
                        SetMode(0x13);
			setcolors();
                        do {
				}
                        while (key[KB_f3]);
                        setstatus ("VIDEOMODE: 320X200");
                        if (vidmode==1) {
                                setstatus("VIDEOMODE: 360X240");
                                }
                        }
		if (key[KB_f1]&&key[KB_left_control]) {
			v2on=1-v2on;
                        showsid=25;
			do {
                                }
                        while (key[KB_f1]);
                        setstatus("VOICE 1 OFF");
                        if (v2on) {
                                setstatus("VOICE 1 ON");
                                }
                        }
		if (key[KB_f2]&&key[KB_left_control]) {
                        v3on=1-v3on;
			showsid=25;
                        do {
                                }
                        while (key[KB_f2]);
                        setstatus("VOICE 2 OFF");
                        if (v3on) {
                                setstatus("VOICE 2 ON");
				}
			}
                if (key[KB_f3]&&key[KB_left_control]) {
			v1on=1-v1on;
                        showsid=25;
                        do {
                                }
                        while (key[KB_f3]);
                        setstatus("VOICE 3 OFF");
                        if (v1on) {
                                setstatus("VOICE 3 ON");
				}
                        }
		if (key[KB_left_control]&key[KB_left_alt]&key[KB_r]) {
                        /*Message("HARD RESET",250);
                        */ reset=1;
                        setstatus("HARD RESET");
                        }
                if (key[KB_left_control]&key[KB_left_alt]&key[KB_i]) {
                        spriteinfo();
			}
		if (key[KB_left_control]&key[KB_left_alt]&key[KB_k]) {
                        sidinfo();
			}
                if (key[KB_left_control]&key[KB_left_alt]&key[KB_v]) {
                        generalvicinfo();
                        }
                if (key[KB_left_control]&key[KB_left_alt]&key[KB_plus]) {
                        if (gamma<=1.8) {
                                gamma=gamma+0.05;
                                setcolors();
				}
                        do{
				}
                        while(key[KB_plus]);
                        setstatus("GAMMA UP");
                        }
                if (key[KB_left_control]&key[KB_left_alt]&key[KB_min]) {
                        if (gamma>=.05) {
                                gamma=gamma-0.05;
				setcolors();
				}
                        do{
				}
                        while(key[KB_min]);
                        setstatus("GAMMA DOWN");
                        }
                if (key[KB_left_alt]&key[KB_f4]) {
                        done=1;
                        }
                if (key[KB_left_alt]&key[KB_f1]) {
			intro();
                        setcolors();
			}
                if (key[KB_left_alt]&key[KB_f2]) {
                        spritemethod=1-spritemethod;
                        if (spritemethod==0) {
                                setstatus("FAST SPRITE DRAWING");
                                }
                        if (spritemethod==1) {
				setstatus("SLOW, ACCURATE SPRITE DRAWING");
				}
                        do {
				}
                        while(key[KB_f2]);
                        }
                // if (key[KB_f9]) {dirprg(); rawkey=0;}
                
		if (key[KB_f9]) {
			Message("ARE YOU SURE?",1);
			messy=0;
			do {
				if (key[KB_y]) {
					messy=1;
					do {
						}
					while (key[KB_y]);
					}
				if (key[KB_n]) {
					messy=2;
					do {
						}
					while (key[KB_n]);
					}
				}
			while (messy==0);
			if (messy==1) {
				whereami=1;
				typestring ("");
				execstring_do=1;
				}
			rawkey=0;
			}
		// ADD BY MAX & menu by Johan
		/////////////////////////////////////////////
		if (key[KB_f10]) {
			dircart();
			rawkey=0;
			}
		/////////////////////////////////////////////


		if (key[KB_insert]) NMI=1;
		if (rawkey>0) {
			if(rawkey==KB_escape) {
				do {
					}
				while (key[KB_escape]);
				menu();
				}
			if (rawkey<0x80) {
				key_pressed[key_table[rawkey][0]]&=255-key_table[rawkey][1];
				rawkey=0;
				}
			else {
				rawkey&=0x7f;
				key_pressed[key_table[rawkey][0]]|=key_table[rawkey][1];
				rawkey=0;
				}
			}
		RAMPointer[0xDC01]=key_pressed[255-(oldkeycolumn=RAMPointer[0xDC00])];
		if (RAMPointer[0xdc01]<255&&RAMPointer[0xdc01]>0&&keysdown==0) {
			for(index=0;index<255;index++) {
				key_pressed[index]=255;
				}
			}
		}
	}

// ### DRAW A LINE ##########################################################
void VICDrawLine()
{
	int scrn_y = vic_y - 50;
	int temp1,temp2,i;
	unsigned int line,line2;
	unsigned char *scrn,*chr,*clrp,*result,*l_pScr;
	static unsigned char data[327];
	bcolor[vic_y]=vic_ec;
        if((scrn_y<0)||(scrn_y>199))
        ;
        else if(!vic_den||(!vic_rsel&&((scrn_y<4)||(scrn_y>=196))))
        memset(Virtualscreen+(scrn_y<<8)+(scrn_y<<6),vic_ec,320);
        else
        {
                line=(scrn_y-vic_yscrl+3)&0xFFF8;
                line+=line<<2;
                if ( vic_bmm ) 
                {
                        temp1 =vic_vm+line+vic_bank;
                        if((temp1 &0x7000)==0x1000)
                        scrn=&CharPointer[temp1&0xFFF];
                        else    
                        scrn=&RAMPointer[temp1];
                        line2 = (( scrn_y-vic_yscrl+3 ) >> 3 ) * ( 40 * 8 );
                        temp2=vic_bank+vic_cb+line2+((scrn_y-vic_yscrl+3)&7);
                        if((temp2&0x7000)==0x1000)
                        chr=&CharPointer[temp2&0xFFF];
                        else    
                        chr=&RAMPointer[temp2];
                        }
                else
                {
                        temp1 =vic_vm+line+vic_bank;
                        if((temp1 &0x7000)==0x1000)
                        scrn=&CharPointer[temp1&0xFFF];
                        else    
                        scrn=&RAMPointer[temp1];
                        temp2=vic_bank+vic_cb+((scrn_y-vic_yscrl+3)&7);
                        if((temp2&0x7000)==0x1000)
                        chr=&CharPointer[temp2&0xFFF];
                        else    
                        chr=&RAMPointer[temp2];
                        }
                clrp=&ColorPointer[line];
                result=&data[vic_xscrl];
                memset( data, vic_ec, 320 );
                if ( vic_mcm )
                {
                        if ( vic_bmm )
                        {
                                if ( vic_ecm )
                                {
                                        // ECM/BMM/MCM: Invalid bitmap mode 2
                                        
                                        // black is displayed.
                                        }
                                else
                                {
                                        // ecm/BMM/MCM: Multicolor bitmap mode
                                        
                                        for ( i = 0;i < 40;i++ ) {
                                                int l_nChar = chr[ i << 3 ];
                                                unsigned char l_bCol10 = *scrn & 0xf;
                                                unsigned char l_bCol01 = (*scrn++ & 0xf0) >> 4;
                                                unsigned char l_bCol11 = *clrp++;
                                                if ( l_nChar & 128 )
                                                *result = ( l_nChar & 64 ) ? l_bCol11 : l_bCol10;
                                                else
                                                *result = ( l_nChar & 64 ) ? l_bCol01 : vic_b0c;
                                                *(result+1) = *result;
                                                result += 2;
                                                if ( l_nChar & 32 )
                                                *result = ( l_nChar & 16 ) ? l_bCol11 : l_bCol10;
                                                else
                                                *result = ( l_nChar & 16 ) ? l_bCol01 : vic_b0c;
                                                *(result+1) = *result;
                                                result += 2;
                                                if ( l_nChar & 8 )
                                                *result = ( l_nChar & 4 ) ? l_bCol11 : l_bCol10;
                                                else
                                                *result = ( l_nChar & 4 ) ? l_bCol01 : vic_b0c;
                                                *(result+1) = *result;
                                                result += 2;
                                                
                                                if ( l_nChar & 2 )
                                                *result = ( l_nChar & 1 ) ? l_bCol11 : l_bCol10;
                                                else
                                                *result = ( l_nChar & 1 ) ? l_bCol01 : vic_b0c;
                                                *(result+1) = *result;
                                                result += 2;
                                                }
                                        }
                                }
                        else
                        {
                                if ( vic_ecm )
                                {
                                        // ECM/bmm/MCM: Invalid text mode
                                        
                                        // black is displayed.
                                        }
                                else
                                {
                                        // ecm/bmm/MCM: Multicolor text mode
                                        
                                        for ( i = 0;i < 40;i++ ) {
                                                int l_nChar = chr[ *scrn++ << 3 ];
                                                unsigned char l_bCol = *clrp++;
                                                if ( l_bCol & 0x08 )
                                                {
                                                        l_bCol &= 0x07;
                                                        if ( l_nChar & 128 )
                                                        *result = ( l_nChar & 64 ) ? l_bCol : vic_b2c;
                                                        else
                                                        *result = ( l_nChar & 64 ) ? vic_b1c : vic_b0c;
                                                        *(result+1) = *result;
                                                        result += 2;
                                                        if ( l_nChar & 32 )
                                                        *result = ( l_nChar & 16 ) ? l_bCol : vic_b2c;
                                                        else
                                                        *result = ( l_nChar & 16 ) ? vic_b1c : vic_b0c;
                                                        *(result+1) = *result;
                                                        result += 2;
                                                        if ( l_nChar & 8 )
                                                        *result = ( l_nChar & 4) ? l_bCol : vic_b2c;
                                                        else
                                                        *result = ( l_nChar & 4) ? vic_b1c : vic_b0c;
                                                        *(result+1) = *result;
                                                        result += 2;
                                                        
                                                        if ( l_nChar & 2 )
                                                        *result = ( l_nChar & 1) ? l_bCol : vic_b2c;
                                                        else
                                                        *result = ( l_nChar & 1) ? vic_b1c : vic_b0c;
                                                        *(result+1) = *result;
                                                        result += 2;
                                                        }
                                                else
                                                {
                                                        *result++ = ( l_nChar & 128 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 64 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 32 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 16 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 8 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 4 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 2 ) ? l_bCol : vic_b0c;
                                                        *result++ = ( l_nChar & 1 ) ? l_bCol : vic_b0c;
                                                        }
                                                }
                                        }
                                }
                        }
                else
                {
                        if ( vic_bmm )
                        {
                                if ( vic_ecm )
                                {
                                        // ECM/BMM/mcm: Invalid bitmap mode 1
                                        
                                        // black is displayed.
                                        }
                                else
                                {
                                        // ecm/BMM/mcm: Standard bitmap mode
                                        
                                        for ( i = 0;i < 40;i++ ) {
                                                int l_nChar = chr[ i << 3 ];
                                                unsigned char l_bCol0 = *scrn & 0xf;
                                                unsigned char l_bCol1 = (*scrn++ & 0xf0) >> 4;
                                                *result++ = ( l_nChar & 128 ) ? l_bCol1: l_bCol0;
                                                *result++ = ( l_nChar & 64 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 32 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 16 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 8 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 4 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 2 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 1 ) ? l_bCol1 : l_bCol0;
                                                }
                                        }
                                }
                        else                    
                        {
                                if ( vic_ecm )
                                {
                                        // ECM/bmm/mcm: ECM text mode
                                        
                                        for ( i = 0; i < 40; i++ ) {
                                                unsigned char l_bCol0 = *scrn >> 6;
                                                unsigned char l_bCol1 = *clrp++;
                                                int l_nChar = chr[ ( *scrn++ & 0x3f ) << 3 ];
                                                
                                                *result++ = ( l_nChar & 128 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 64 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 32 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 16 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 8 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 4 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 2 ) ? l_bCol1 : l_bCol0;
                                                *result++ = ( l_nChar & 1 ) ? l_bCol1 : l_bCol0;
                                                }
                                        }
                                else
                                {
                                        // ecm/bmm/mcm: Standard text mode
                                        
                                        for ( i = 0; i < 40; i++ ) {
                                                int l_nChar = chr[ *scrn++ << 3 ];
                                                unsigned char l_bCol = *clrp++;
                                                
                                                *result++ = ( l_nChar & 128 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 64 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 32 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 16 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 8 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 4 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 2 ) ? l_bCol : vic_b0c;
                                                *result++ = ( l_nChar & 1 ) ? l_bCol : vic_b0c;
                                                }
                                        }
                                }
                        }
                l_pScr = Virtualscreen + scrn_y * 320;
                if(vic_csel)
                {
                        memcpy( l_pScr, data, 320 );
                        }
                else
                {
                        memset( l_pScr, vic_ec, 7 );
                        l_pScr += 7;
                        memcpy( l_pScr, data + 7, 320 - 14 );
                        l_pScr += 320 - 14;
                        memset( l_pScr, vic_ec, 7 );
                        }
                }
        }

// ### SHOW RASTER-INTERRUPT ################################################
void ShowRaster(void)
{
        int x=vic_rasirq;
        putcbmchar ((x%10)+'0',39,24,1,0);
        x/=10;
        putcbmchar ((x%10)+'0',38,24,1,0);
        x/=10;
        putcbmchar (x+'0',37,24,1,0);
        }

// ### LET THE VIC DRAW A LINE ##############################################
void VICDoLine(void)
{
        unsigned char temp1;
        if(!frameskip||!(autoskip||key[KB_f12]))
        if (vic_y+interlaceline&1||!(interlaced||key[KB_f12]))
        VICDrawLine();
        vic_x=0;
        if (spritemethod==1) {
                if (vic_y%42==0||vic_rasirq==vic_y) {
                        Sprite(vic_y);
                        }
                }
        #ifdef PAL
        if(++vic_y==312)
        #else
        if(++vic_y==262)
        #endif
        {
                if (manskp!=0) {
                        skipper=manskp;
                        }
                if(!frameskip||!(autoskip||key[KB_f12]))
                {
                        CIA();
                        if (spritemethod==0) {
                                Sprite(255);
                                }
                        if(key[KB_scrolllock])showpercent();
                        interlaced=1;
                        if (interl_on==0) interlaced=0;
                        if (interl_on==2)
                        {
                                interlaced=0;
                                if (skipper>4)
                                interlaced=1;
                                }
                        if (percent>120) {
                                waitretrace();
                                skipper=0;
                                frameskip=0;
                                }
                        flip();
                        interlaceline=1-interlaceline;
			//Klight(leds);
                        if(key[KB_f12])
                        {
                                frameskip=25;
                                setstatus(">> FAST FORWARD >>");
                                }
                        else frameskip=skipper;
                        }
                else frameskip--;
                vic_y=0;
                }
        if(key[KB_f11])
        {
                ShowRaster();
                flip();
                }
        if(vic_y==vic_rasirq)
        {
                VICRegs[0x19]|=1;
                if(VICRegs[0x1A]&0x1)
                {
                        IRQ=1;
                        VICRegs[0x19]|=0x80;
                        }
                }
        }

// ### COMPLEX INTERFACE ADAPTER TIMERS #####################################
void CIATimers(void)
{
        if(enable1a)
        {
                if(t1a==0)
                {
                        t1a=*(unsigned int far *)&CIA1Regs[4]=latch1a;
                        if(CIA1Regs[0xE]&0x08) CIA1Regs[0xE]&=254;
                        if(ICR1set&0x01)
                        {
                                IRQ=1;
                                CIA1Regs[0xD]=0x80;
                                }
                        CIA1Regs[0xD]|=1;
                        if((CIA1Regs[0xF]&0x60)==0x40)CIA1Regs[6]=--t1b;
                        }
                CIA1Regs[4]=--t1a;
                }
        if(enable1b)
        {
                if(t1b==0)
                {
                        t1b=*(unsigned int far *)&CIA1Regs[6]=latch1b;
                        if(CIA1Regs[0xF]&0x08) CIA1Regs[0xF]&=254;
                        if(ICR1set&0x02)
                        {
                                IRQ=1;
                                CIA1Regs[0xD]=0x80;
                                }
                        CIA1Regs[0xD]|=2;
                        }
                else
                {
                        if((CIA1Regs[0xF]&0x60)==0)
                        {
                                CIA1Regs[6]=--t1b;
                                }
                        }
                }
        // end CIA 1
        // CIA 2
        if(enable2a)
        {
                if(t2a==0)
                {
                        t2a=*(unsigned int far *)&CIA2Regs[4]=latch2a;
                        if(CIA2Regs[0xE]&0x08) CIA2Regs[0xE]&=254;
                        if(ICR2set&0x01)
                        {
                                NMI=1;
                                CIA2Regs[0xD]=0x80;
                                }
                        CIA2Regs[0xD]|=1;
                        if((CIA2Regs[0xF]&0x60)==0x40)CIA2Regs[0x6]=--t2b;
                        }
                CIA2Regs[0x4]=--t2a;
                }
        if(enable2b)
        {
                if(t2b==0)
                {
                        t2b=*(unsigned int far *)&CIA2Regs[6]=latch2b;
                        if(CIA2Regs[0xF]&0x08) CIA2Regs[0xF]&=254;
                        if(ICR2set&0x02)
                        {
                                NMI=1;
                                CIA2Regs[0xD]=0x80;
                                }
                        CIA2Regs[0xD]|=2;
                        }
                else if((CIA2Regs[0xF]&0x60)==0) CIA2Regs[0x6]=--t2b;
                }
        // end CIA 2
        }

// ### MAIN LOOP OF THE EMULATOR ############################################
void MainLoop(void)
{
        unsigned char L,counter,chr,ok;
        unsigned int A;
        unsigned char cnt2=0;
        unsigned int address,jmp_from;
        unsigned char curr_inst=0x80,checktrap=0;
        unsigned char error[40],tempstring[50];
        unsigned int curr_loc=(KernalPointer[0x1FFD]<<8)+KernalPointer[0x1FFC];
        unsigned char stack_ptr=0xFF;
        unsigned char a_reg=0,x_reg=0,y_reg=0,flags=0x30,curr_cycle,gen1;
        unsigned char tempstr[255],tempcnt;
        // unsigned char sprite_old_y[8],spritetemp,spritechange,y_temp;
        pair K;
        done=reset=vic_x=vic_y=0;
        vic_rasirq=0xFFFF;
        data=farmalloc(327);
        //7 dummy bytes
        //   for (spritetemp=0;spritetemp<8;spritetemp++)
        //    {sprite_old_y[spritetemp]=255;}
        for(;;) {
                // startup-file
                if (loadcounter==0&&curr_loc==0xe5cd)
                {
                        setstatus ("AUTO-LOADING PROGRAM");
                        tempcnt=0;
			tempstr[tempcnt]='L';
                        tempcnt++;
                        tempstr[tempcnt]='O';
                        tempcnt++;
                        tempstr[tempcnt]='A';
                        tempcnt++;
                        tempstr[tempcnt]='D';
                        tempcnt++;
                        tempstr[tempcnt]='\"'; tempcnt++;
                        for (loadcounter=0;loadcounter<strlen(loadonstart)-4;loadcounter++) {
                        tempstr[tempcnt]=loadonstart[loadcounter];
                        if (tempstr[tempcnt]=='~') {tempstr[tempcnt]='0';}
                        tempcnt++;
                        }
                        tempstr[tempcnt]='\"';
                        tempcnt++;
                        tempstr[tempcnt]=',';
                        tempcnt++;
                        tempstr[tempcnt]='8';
                        tempcnt++;
                        tempstr[tempcnt]=',';
                        tempcnt++;
                        tempstr[tempcnt]='1';
                        tempcnt++;
                        tempstr[tempcnt]='\r';
                        tempcnt++;
                        tempstr[tempcnt]='R';
                        tempcnt++;
                        tempstr[tempcnt]='U';
                        tempcnt++;
                        tempstr[tempcnt]='N';
                        tempcnt++;
			tempstr[tempcnt]='\r';
			tempcnt++;
			tempstr[tempcnt]=0;
			tempcnt++;
			typestring (tempstr);
			loadcounter=1;
			setstatus ("RUNNING PROGRAM");
			}
		// AUTOTYPE
		if (execstring_do!=0&&RAMPointer[0xc6]==0) {
			RAMPointer[0x277]=execstring[execstring_do-1];
			RAMPointer[0xc6]=1;
			execstring_do++;
			if (execstring_do-1>strlen(execstring)) {
				execstring_do=0;
				if (whereami>0) {whereami++;}
				if (whereami== 2) {typestring("\rNEW\r100 REM ********* WHERE AM I? *********\r110 REM -------------------------------\r120 REM THIS IS THE RECOMMENDED METHOD\r130 REM HOW TO DETECT A C64 EMULATOR,\r140 REM E.G. FOR DISABLING FAST LOADERS\r150 REM\r1");};
				if (whereami== 3) {typestring("60 REM - THE BYTE AT $DFFF CHANGES\r170 REM   BETWEEN $55 AND $AA\r180 REM - THE BYTE AT $DFFE CONTAINS\r190 REM   THE MANUFACTURER CODE LETTER:\r200 REM   A = C64ALIVE\r210 REM   F = FRODO\r220 REM   P = PERSONAL C64\r");};
				if (whereami== 4) {typestring("230 REM   S = C64 SOFTWARE EMULATOR\r240 REM   X = X64\r250 REM   / = POWER64\r260 REM - THE WORD AT $DFFC CONTAINS\r270 REM   THE EMULATOR VERSION NUMBER,\r280 REM   E.G. $0120 FOR VERSION 1.2\r290 REM - THE BYTES FROM");};
				if (whereami== 5) {typestring(" $DFA0 CONTAIN\r300 REM   A COPYRIGHT STRING WITH\r310 REM   EMULATOR NAME AND VERSION,\r320 REM   $0D, COPYRIGHT AND $00.\r330 REM -------------------------------\r340 :\r500 PRINT\r510 X=57343: REM $DFFF\r520 IF PEEK(");};
				if (whereami== 6) {typestring("X)<>85 THEN IF PEEK(X)<>85 THEN 1000\r530 IF PEEK(X)<>170 THEN 1000\r540 IF PEEK(X)<>85  THEN 1000\r550 IF PEEK(X)<>170 THEN 1000\r560 M$=CHR$(PEEK(57342)): REM $DFFE\r570 PRINT \"MANUFACTURER = '\"; M$; \"' \";\r580 IF");};
				if (whereami== 7) {typestring(" M$=\"A\" THEN PRINT \"(C64ALIVE)\";\r590 IF M$=\"F\" THEN PRINT \"(FRODO)\";\r600 IF M$=\"P\" THEN PRINT \"(PC64)\";\r610 IF M$=\"S\" THEN PRINT \"(C64S)\";\r620 IF M$=\"X\" THEN PRINT \"(X64)\";\r630 IF M$=\"/\" THEN ");};
				if (whereami== 8) {typestring("PRINT \"(POWER64)\";\r640 PRINT\r650 :\r700 V=PEEK(57341)*256 + PEEK(57340): REM $DFFD/$DFFC\r710 H$=\"0123456789ABCDEF\"\r720 FOR I=0 TO 3\r730 V$=MID$(H$,1+(V AND 15),1)+V$\r740 V=INT(V/16)\r750 NEXT\r760 PRINT ");};
				if (whereami== 9) {typestring("\"VERSION = $\";V$\r770 PRINT\r780 :\r800 I=57248: REM $DFA0\r810 X=PEEK(I)\r820 IF X=0 THEN PRINT: END\r830 PRINT CHR$(X);\r840 I=I+1\r850 GOTO 810\r860 :\r900 REM -------------------------------\r910 REM THESE ARE MANUFACTU");};
				if (whereami==10) {typestring("RER-SPECIFIC\r920 REM WORKAROUNDS, WHICH SHOULD BE\r930 REM REPLACED WITH THE OFFICIAL\r940 REM EMULATOR DETECTION METHOD\r950 :\r1000 IF PEEK(60682)<>0 THEN 1100: REM $ED0A\r1010 PRINT \"C64 SOFTWARE EMULATOR\"\r1020 P");};
				if (whereami==11) {typestring("RINT \"(C)1991-94 MIHA PETERNEL\"\r1030 END\r1040 :\r1100 IF PEEK(60736)<>0 THEN 1200: REM $ED40\r1110 PRINT \"X64 (VERSION 1 OR 2)\"\r1120 PRINT \"(C)1993-94 J.SONNINEN/T.RANTANEN/J.VALTA\"\r1130 END\r1140 :\r1200 X=57");};
				if (whereami==12) {typestring("087: REM $DEFF\r1210 IF PEEK(X)+PEEK(X)+PEEK(X)<>0 THEN 2000\r1220 PRINT \"C64ALIVE\"\r1230 PRINT \"(C)1993-94 F.LITTMANN DEVELOPMENTS\"\r1240 END\r1250 :\r2000 PRINT \"THIS IS AN ORIGINAL C64 OR C128\"\r\rRUN\r");};
				if (whereami==13) {whereami=0;}
				}
			}
		// END AUTOTYPE
		// VIC
		// We need to draw 8 dots in the time it takes the CPU to
		// execute one cycle (dot clock=8.1818 Mhz,
		// CPU_clock=dot_clock/8)
		vic_x+=8;
		#ifdef PAL
		if(vic_x>=506)
		#else
                if(vic_x>=512)
                #endif
                {
                        VICDoLine();
                        //   spritechange=0;
                        //   for (spritetemp=0;spritetemp<8;spritetemp++)
                        //     {
                        //      y_temp=VICRegs[1+(7-spritetemp)*2]-50;
                        //      if (y_temp!=sprite_old_y[spritetemp])
                        //       {spritechange=1;
                        //        sprite_old_y[spritetemp]=y_temp;
                        //       }
                        //     }
                        //   if (spritechange==1) {Sprite(vic_y);}
                        }
                // 6510
                switch(curr_inst) {
                        case 0x80:
                        if(done)
                        return;
                        if(reset==1)
                        {
                                curr_loc=((unsigned int)KernalPointer[0x1FFD]<<8)+(unsigned int)KernalPointer[0x1FFC];
                                checktrap=1;
                                stack_ptr=0xFF;
                                flags=0x30;
                                clearmem();
                                IRQ=NMI=reset=0;
				//Klight(SNDkeys=0);
                                leds=0;
                                }
                        else if(reset==2)
                        {
                                RAMPointer[1]=55;
                                curr_inst=0x80;
                                curr_loc=2456;
                                checktrap=1;
                                IRQ=NMI=reset=0;
				//Klight (SNDkeys=0);
                                leds=0;
                                }
                        if(IRQ)
                        {
                                if(flags&INT)goto NOIRQ;
                                Poke(0x100+stack_ptr--,curr_loc>>8);
                                Poke(0x100+stack_ptr--,curr_loc&255);
                                Poke(0x100+stack_ptr--,flags&BRK_OFF);
                                curr_loc=Deek(0xFFFE);
                                checktrap=1;
                                flags|=INT;
                                }
                        if(NMI)
                        {
                                NMI=0;
                                Poke(0x100+stack_ptr--,(curr_loc)>>8);
                                Poke(0x100+stack_ptr--,(curr_loc)&255);
                                Poke(0x100+stack_ptr--,flags);
                                curr_loc=Deek(0xFFFA);
                                checktrap=1;
                                }
                        NOIRQ:                  if((curr_inst=Peek(curr_loc))==0x80)
                        curr_inst=0x82;
                        curr_cycle=1;
                        break;
                        case 0x00: //BRK();
                        if(curr_cycle==1)
                        {
                                Poke(0x100+stack_ptr--,(curr_loc+2)>>8);
                                Poke(0x100+stack_ptr--,(curr_loc+2)&255);
                                Poke(0x100+stack_ptr--,flags);
                                flags|=INT;
                                curr_loc=Deek(0xFFFE);
                                checktrap=1;
                                }
                        if(curr_cycle++==6) curr_inst=0x80;
                        break;
                        case 0x01: //ORA_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                ORA();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x05: //ORA_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                ORA();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x06: //ASL_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                ASL();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x08: //PHP();
                        if(curr_cycle==1)
                        {
                                Poke(0x100+stack_ptr--,flags);
                                curr_loc+=1;
                                checktrap=1;
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x09: //ORA_Imm();
                        Imm();
                        ORA();
                        curr_inst=0x80;
                        break;
                        case 0x0A: //ASL_Acc();
                        if(a_reg&0x80)flags|=CARRY;
                        else flags&=(CRRY_OFF);
                        a_reg<<=1;
                        setflags(a_reg);
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x0D: //ORA_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                ORA();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x0E: //ASL_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                ASL();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x10: //BPL();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if((flags&NEGATIVE)==0)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)
                                curr_inst=0x80;
                                }
                        else
                        curr_inst=0x80;
                        break;
                        case 0x11: //ORA_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                ORA();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x15: //ORA_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                ORA();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x16: //ASL_Zero_X();
                        if(curr_cycle++==1)
                        {
                                Zero_X();
                                ASL();
                                }
                        if(curr_cycle==5)curr_inst=0x80;
                        break;
                        case 0x18: //CLC();
                        flags&=(CRRY_OFF);
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x19: //ORA_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                ORA();
                                }
                        if(((address-y_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x1D: //ORA_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                ORA();
                                }
                        if(((address-x_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x1E: //ASL_Abs_X();
                        if(curr_cycle++==1)
                        {
                                Abs_X();
                                ASL();
                                }
                        if(curr_cycle==6)curr_inst=0x80;
                        break;
                        case 0x20: //JSR();
                        
                        curr_loc+=2;
                        checktrap=1;
                        jmp_from=curr_loc;
                        Poke(0x100+stack_ptr--,curr_loc>>8);
                        Poke(0x100+stack_ptr--,curr_loc&255);
                        curr_loc=Deek(curr_loc-1);
                        curr_inst=0x80;
                        break;
                        case 0x21: //AND_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                AND();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x24: //BIT_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                BIT();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x25: //AND_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                AND();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x26: //ROL_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                ROL();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x28: //PLP();
                        if(curr_cycle==1)
                        {
                                flags=Peek(0x100+(++stack_ptr))|0x30;
                                }
                        if(curr_cycle++==3)
                        {
                                curr_inst=0x80;
                                curr_loc++;
                                checktrap=1;
                                }
                        break;
                        case 0x29: //AND_Imm();
                        Imm();
                        AND();
                        curr_inst=0x80;
                        break;
                        case 0x2A: //ROL_Acc();
                        gen1=a_reg<<1;
                        if(flags&CARRY)gen1|=1;
                        if(a_reg&0x80)
                        flags|=CARRY;
                        else
                        flags&=CRRY_OFF;
                        setflags(gen1);
                        a_reg=gen1;
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x2C: //BIT_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                BIT();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x2D: //AND_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                AND();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x2E: //ROL_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                ROL();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x30: //BMI();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if(flags&NEGATIVE)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else{
                                curr_inst=0x80;
                                }
                        break;
                        case 0x31: //AND_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                AND();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x35: //AND_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                AND();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x36: //ROL_Zero_X();
                        if(curr_cycle++==1)
                        {
                                Zero_X();
                                ROL();
                                }
                        if(curr_cycle==5)curr_inst=0x80;
                        break;
                        case 0x38: //SEC();
                        flags|=CARRY;
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x39: //AND_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                AND();
                                }
                        if(((address-y_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x3D: //AND_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                AND();
                                }
                        if(((address-x_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x3E: //ROL_Abs_X();
                        if(curr_cycle++==1)
                        {
                                Abs_X();
                                ROL();
                                }
                        if(curr_cycle==6)curr_inst=0x80;
                        break;
                        case 0x40: //RTI();
                        if(curr_cycle==1)
                        {
                                flags=Peek(0x100+(++stack_ptr))|0x30;
                                K.B.l=Peek(0x100+(++stack_ptr));
                                K.B.h=Peek(0x100+(++stack_ptr));
                                curr_loc=K.W;
                                checktrap=1;
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0x41: //EOR_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                EOR();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x45: //EOR_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                EOR();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x46: //LSR_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                LSR();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x48: //PHA();
                        if(curr_cycle==1)
                        {
                                Poke(0x100+stack_ptr--,a_reg);
                                curr_loc++;
                                checktrap=1;
                                }
                        if(curr_cycle++==2)
                        {
                                curr_inst=0x80;
                                }
                        break;
                        case 0x49: //EOR_Imm();
                        Imm();
                        EOR();
                        curr_inst=0x80;
                        break;
                        case 0x4A: //LSR_Acc();
                        if(a_reg&1)flags|=CARRY;
                        else flags&=(CRRY_OFF);
                        a_reg>>=1;
                        setflags(a_reg);
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x4C: //JMP_Abs();
                        if(curr_cycle==1)
                        {
                                jmp_from=curr_loc;
                                curr_loc++;
                                curr_loc=Deek(curr_loc);
                                checktrap=1;
                                }
                        if(curr_cycle++==2) curr_inst=0x80;
                        break;
                        case 0x4D: //EOR_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                EOR();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x4E: //LSR_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                LSR();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x50: //BVC();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if((flags&OVERFLOW)==0)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0x51: //EOR_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                EOR();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x55: //EOR_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                EOR();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x56: //LSR_Zero_X();
                        if(curr_cycle++==1)
                        {
                                Zero_X();
                                LSR();
                                }
                        if(curr_cycle==5)curr_inst=0x80;
                        break;
                        case 0x58: //CLI();
                        flags&=(INT_OFF);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x59: //EOR_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                EOR();
                                }
                        if(((address-y_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x5D: //EOR_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                EOR();
                                }
                        if(((address-x_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x5E: //LSR_Abs_X();
                        if(curr_cycle++==1)
                        {
                                Abs_X();
                                LSR();
                                }
                        if(curr_cycle==6)curr_inst=0x80;
                        break;
                        case 0x60: //RTS();
                        if(curr_cycle==1)
                        {
                                K.B.l=Peek(0x100+(++stack_ptr));
                                K.B.h=Peek(0x100+(++stack_ptr));
                                curr_loc=K.W+1;
                                checktrap=1;
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0x61: //ADC_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                ADC();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x65: //ADC_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                ADC();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0x66: //ROR_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                ROR();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x68: //PLA();
                        if(curr_cycle==1)
                        {
                                a_reg=Peek(0x100+(++stack_ptr));
                                setflags(a_reg);
                                }
                        if(curr_cycle++==3)
                        {
                                curr_inst=0x80;
                                curr_loc+=1;
                                checktrap=1;
                                }
                        break;
                        case 0x69: //ADC_Imm();
                        Imm();
                        ADC();
                        curr_inst=0x80;
                        break;
                        case 0x6A: //ROR_Acc();
                        gen1=a_reg>>1;
                        if(flags&CARRY)gen1|=0x80;
                        if(a_reg&1)
                        flags|=CARRY;
                        else
                        flags&=CRRY_OFF;
                        setflags(gen1);
                        a_reg=gen1;
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0x6C: //JMP_Ind();
                        if(curr_cycle==1)
                        {
                                jmp_from=curr_loc;
                                address=Deek(curr_loc+1);
                                K.W=address;
                                curr_loc=Peek(K.W);
                                checktrap=1;
                                K.B.l++;
                                curr_loc+=Peek(K.W)<<8;
                                }
                        if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0x6D: //ADC_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                ADC();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x6E: //ROR_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                ROR();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x70: //BVS();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if(flags&OVERFLOW)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0x71: //ADC_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                ADC();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0x75: //ADC_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                ADC();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0x76: //ROR_Zero_X();
                        if(curr_cycle++==1)
                        {
                                Zero_X();
                                ROR();
                                }
                        if(curr_cycle==5)curr_inst=0x80;
                        break;
                        case 0x78: //SEI();
                        flags|=INT;
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x79: //ADC_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                ADC();
                                }
                        if(((address-y_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x7D: //ADC_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                ADC();
                                }
                        if(((address-x_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0x7E: //ROR_Abs_X();
                        if(curr_cycle++==1)
                        {
                                Abs_X();
                                ROR();
                                }
                        if(curr_cycle==6)curr_inst=0x80;
                        break;
                        case 0x81: //STA_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0x84: //STY_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                Poke(address,y_reg);
                                }
                        if(curr_cycle++==2) curr_inst=0x80;
                        break;
                        case 0x85: //STA_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==2) curr_inst=0x80;
                        break;
                        case 0x86: //STX_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                Poke(address,x_reg);
                                }
                        if(curr_cycle++==2) curr_inst=0x80;
                        break;
                        case 0x88: //DEY();
                        y_reg--;
                        setflags(y_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x8A: //TXA();
                        a_reg=x_reg;
                        setflags(a_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x8C: //STY_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                Poke(address,y_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x8D: //STA_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x8E: //STX_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                Poke(address,x_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x90: //BCC();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if((flags&CARRY)==0)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0x91: //STA_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0x94: //STY_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                Poke(address,y_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x95: //STA_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x96: //STX_Zero_Y();
                        if(curr_cycle==1)
                        {
                                Zero_Y();
                                Poke(address,x_reg);
                                }
                        if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0x98: //TYA();
                        a_reg=y_reg;
                        setflags(a_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x99: //STA_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0x9A: //TXS();
                        stack_ptr=x_reg;
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0x9D: //STA_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                Poke(address,a_reg);
                                }
                        if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xA0: //LDY_Imm();
                        Imm();
                        y_reg=Peek(address);
                        setflags(y_reg);
                        curr_inst=0x80;
                        break;
                        case 0xA1: //LDA_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(curr_cycle++==5)
                        curr_inst=0x80;
                        break;
                        case 0xA2: //LDX_Imm();
                        Imm();
                        x_reg=Peek(address);
                        setflags(x_reg);
                        curr_inst=0x80;
                        break;
                        case 0xA4: //LDY_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                y_reg=Peek(address);
                                setflags(y_reg);
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xA5: //LDA_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xA6: //LDX_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                x_reg=Peek(address);
                                setflags(x_reg);
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xA8: //TAY();
                        y_reg=a_reg;
                        setflags(y_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xA9: //LDA_Imm();
                        Imm();
                        a_reg=Peek(address);
                        setflags(a_reg);
                        curr_inst=0x80;
                        break;
                        case 0xAA: //TAX();
                        x_reg=a_reg;
                        setflags(x_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xAC: //LDY_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                y_reg=Peek(address);
                                setflags(y_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xAD: //LDA_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xAE: //LDX_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                x_reg=Peek(address);
                                setflags(x_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xB0: //BCS();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if(flags&CARRY)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0xB1: //LDA_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(((address-y_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xB4: //LDY_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                y_reg=Peek(address);
                                setflags(y_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xB5: //LDA_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xB6: //LDX_Zero_Y();
                        if(curr_cycle==1)
                        {
                                Zero_Y();
                                x_reg=Peek(address);
                                setflags(x_reg);
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xB8: //CLV();
                        flags&=(OVER_OFF);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xB9: //LDA_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(((address-y_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xBA: //TSX();
                        x_reg=stack_ptr;
                        setflags(x_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xBC: //LDY_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                y_reg=Peek(address);
                                setflags(y_reg);
                                }
                        if(((address-x_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xBD: //LDA_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                a_reg=Peek(address);
                                setflags(a_reg);
                                }
                        if(((address-x_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xBE: //LDX_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                x_reg=Peek(address);
                                setflags(x_reg);
                                }
                        if(((address-y_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xC0: //CPY_Imm();
                        Imm();
                        CPY();
                        curr_inst=0x80;
                        break;
                        case 0xC1: //CMP_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                CMP();
                                }
                        if(curr_cycle++==5)
                        curr_inst=0x80;
                        break;
                        case 0xC4: //CPY_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                CPY();
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xC5: //CMP_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                CMP();
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xC6: //DEC_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                Poke(address,gen1=Peek(address)-1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xC8: //INY();
                        y_reg++;
                        setflags(y_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xC9: //CMP_Imm();
                        Imm();
                        CMP();
                        curr_inst=0x80;
                        break;
                        case 0xCA: //DEX();
                        x_reg--;
                        setflags(x_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xCC: //CPY_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                CPY();
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xCD: //CMP_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                CMP();
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xCE: //DEC_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                Poke(address,gen1=Peek(address)-1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0xD0: //BNE();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if((flags&ZERO)==0)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0xD1: //CMP_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                CMP();
                                }
                        if(((address-y_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==5) curr_inst=0x80;
                                }
                        else if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xD5: //CMP_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                CMP();
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xD6: //DEC_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                Poke(address,gen1=Peek(address)-1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0xD8: //CLD();
                        flags&=(DEC_OFF);
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0xD9: //CMP_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                CMP();
                                }
                        if(((address-y_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==4) curr_inst=0x80;
                                }
                        else if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0xDD: //CMP_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                CMP();
                                }
                        if(((address-x_reg)/256)!=(address/256))
                        {
                                if(curr_cycle++==4) curr_inst=0x80;
                                }
                        else if(curr_cycle++==3) curr_inst=0x80;
                        break;
                        case 0xDE: //DEC_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                Poke(address,gen1=Peek(address)-1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==6) curr_inst=0x80;
                        break;
                        case 0xE0: //CPX_Imm();
                        Imm();
                        CPX();
                        curr_inst=0x80;
                        break;
                        case 0xE1: //SBC_IndX();
                        if(curr_cycle==1)
                        {
                                IndX();
                                SBC();
                                }
                        if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0xE4: //CPX_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                CPX();
                                }
                        if(curr_cycle++==2)
                        curr_inst=0x80;
                        break;
                        case 0xE5: //SBC_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                SBC();
                                }
                        if(curr_cycle++==2)curr_inst=0x80;
                        break;
                        case 0xE6: //INC_Zero();
                        if(curr_cycle==1)
                        {
                                Zero();
                                Poke(address,gen1=Peek(address)+1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==4) curr_inst=0x80;
                        break;
                        case 0xE8: //INX();
                        x_reg++;
                        setflags(x_reg);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xE9: //SBC_Imm();
                        Imm();
                        SBC();
                        curr_inst=0x80;
                        break;
                        // UNDOC'D
                        case 0x1A:
                        case 0x3A:
                        case 0x5A:
                        case 0x7A:
                        case 0xDA:
                        case 0xFA:
                        case 0xEA: //NOP();
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        case 0xEC: //CPX_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                CPX();
                                }
                        if(curr_cycle++==3)
                        curr_inst=0x80;
                        break;
                        case 0xED: //SBC_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                SBC();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0xEE: //INC_Abs();
                        if(curr_cycle==1)
                        {
                                Abs();
                                Poke(address,gen1=Peek(address)+1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0xF0: //BEQ();
                        if(curr_cycle==1){
                                curr_loc+=2;
                                checktrap=1;
                                }
                        if(flags&ZERO)
                        {
                                if(curr_cycle==2)
                                {
                                        curr_loc+=(signed char)(gen1=Peek(curr_loc-1));
                                        checktrap=1;
                                        if((curr_loc/256)==((curr_loc+(signed char)gen1)/256));
                                        {
                                                curr_inst=0x80;
                                                }
                                        }
                                if(curr_cycle++==3)curr_inst=0x80;
                                }
                        else {
                                curr_inst=0x80;
                                }
                        break;
                        case 0xF1: //SBC_Ind_Y();
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                SBC();
                                }
                        if(curr_cycle++==4)curr_inst=0x80;
                        break;
                        case 0xF5: //SBC_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                SBC();
                                }
                        if(curr_cycle++==3)curr_inst=0x80;
                        break;
                        case 0xF6: //INC_Zero_X();
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                Poke(address,gen1=Peek(address)+1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==5) curr_inst=0x80;
                        break;
                        case 0xF8: //SED();
                        flags|=DECIMAL;
                        curr_inst=0x80;
                        curr_loc++;
                        checktrap=1;
                        break;
                        case 0xF9: //SBC_Abs_Y();
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                SBC();
                                }
                        if(((address-y_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0xFD: //SBC_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                SBC();
                                }
                        if(((address-x_reg)/256)==(address/256))
                        {
                                if(curr_cycle++==4)curr_inst=0x80;
                                }
                        else if(curr_cycle++==5)curr_inst=0x80;
                        break;
                        case 0xFE: //INC_Abs_X();
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                Poke(address,gen1=Peek(address)+1);
                                setflags(gen1);
                                }
                        if(curr_cycle++==6) curr_inst=0x80;
                        break;
                        // UNDOC'D INSTRUCTIONS ///////////
                        
                        case 0x82: // SKB
                        case 0xc2:
                        case 0xe2:
                        case 0x04:
                        case 0x14:
                        case 0x34:
                        case 0x44:
                        case 0x54:
                        case 0x64:
                        case 0x74:
                        case 0x89: // op tests call it NOP #imm ??
                        case 0xD4:
                        case 0xf4: curr_loc+=2;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        #ifdef UNDOCd
                        case 0x03: //ASO_Ind_X
                        if(curr_cycle==1)
                        {
                                IndX();
                                ASO();
                                setstatus("UNDOC OPCODE: ASO_IND_X");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x07: //ASO_Zero
                        if(curr_cycle==1)
                        {
                                Zero();
                                ASO();
                                setstatus("UNDOC OPCODE: ASO_ZERO");
                                }
                        if(curr_cycle++==5)
                        curr_inst=0x80;
                        break;
                        #endif
                        case 0x0B: //ASO_Imm
                        if(curr_cycle==1)
                        {
                                Imm();
                                gen1=Peek(address);
                                if(gen1&0x80)
                                flags|=CARRY;
                                gen1<<=1;
                                a_reg|=gen1;
                                setflags(a_reg);
                                }
                        if(curr_cycle++==4)
                        curr_inst=0x80;
                        break;
                        #ifdef UNDOCd
                        case 0x0F: Abs();
                        ASO();
                        setstatus("UNDOC OPCODE: 0X0F");
                        break;
                        case 0x13: Ind_Y();
                        ASO();
                        setstatus("UNDOC OPCODE: 0X13");
                        break;
                        case 0x17: //ASO_Zero_X
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                ASO();
                                setstatus("UNDOC OPCODE: ASO_ZERO_X");
                                }
                        if(curr_cycle++==6)
                        curr_inst=0x80;
                        break;
                        case 0x1B: Abs_Y();
                        ASO();
                        setstatus("UNDOC OPCODE: 0X1B");
                        break;
                        #endif
                        case 0x1F:
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                ASO();
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        #ifdef UNDOCd
                        case 0x23: //RLA_IndX
                        if(curr_cycle==1)
                        {
                                IndX();
                                RLA();
                                setstatus("UNDOC OPCODE: RLA_INDX");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x27: //RLA_Zero
                        if(curr_cycle==1)
                        {
                                Zero();
                                RLA();
                                setstatus("UNDOC OPCODE: RLA_ZERO");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x2B:
                        if(curr_cycle==1)
                        {
                                Imm();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X2B");
                                }
                        if(curr_cycle++==6)
                        curr_inst=0x80;
                        break;
                        case 0x2F:
                        if(curr_cycle==1)
                        {
                                Abs();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X2F");
                                }
                        if(curr_cycle++==7)
                        curr_inst=0x80;
                        break;
                        case 0x33:
                        if(curr_cycle==1)
                        {
                                Ind_Y();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X33");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x37:
                        if(curr_cycle==1)
                        {
                                Zero_X();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X37");
                                }
                        if(curr_cycle++==7)
                        curr_inst=0x80;
                        break;
                        case 0x3B:
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X3B");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x3F:
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                RLA();
                                setstatus("UNDOC OPCODE: 0X3F");
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        #endif
                        //case 0x43: IndX(); LSE(); break;
                        //case 0x47: Zero(); LSE(); break;
                        //case 0x4B: Imm(); ALR(); break;//
                        //case 0x4F: Abs(); LSE(); break;
                        //case 0x53: Ind_Y(); LSE(); break;
                        //case 0x57: Zero_X(); LSE(); break;
                        //case 0x5B: Abs_Y();LSE(); break;
                        //case 0x5F: Abs_X(); LSE(); break; //
                        //case 0x63: IndX(); RRA(); break;
                        case 0x67:
                        if(curr_cycle==1)
                        {
                                Zero();
                                RRA();
                                }
                        if(curr_cycle++==5)
                        curr_inst=0x80;
                        break;
                        //case 0x6B: Imm(); ARR(); break; //
                        //case 0x6F: Abs(); RRA(); break;
                        //case 0x73: Ind_Y(); RRA(); break;
                        //case 0x77: Zero_X(); RRA(); break;
                        //case 0x7B: Abs_Y(); RRA(); break;
                        //case 0x7F: Abs_X(); RRA(); break;
                        //case 0x83: IndX(); AXS(); break;
                        case 0x87:
                        if(curr_cycle==1)
                        {
                                Zero();
                                AXS();
                                }
                        if(curr_cycle++==5)
                        curr_inst=0x80;
                        break;
                        //case 0x8F: Abs(); AXS(); break;
                        //case 0x97: Zero_Y(); AXS(); break;
                        //case 0xA3: IndX(); LAX(); break;
                        //case 0xA7: Zero(); LAX(); break;
                        //case 0xAB: Imm(); OAL(); break;
                        //case 0xAF: Abs(); LAX(); break;
                        //case 0xB3: Ind_Y(); LAX(); break;
                        //case 0xB7: Zero_X(); LAX(); break;
                        case 0xBF:
                        if(curr_cycle==1)
                        {
                                Abs_Y();
                                LAX();
                                }
                        if(curr_cycle==1)
                        curr_inst=0x80;
                        break;
                        case 0xC3:
                        if(curr_cycle==1)
                        {
                                IndX();
                                DCM();
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0xC7:
                        if(curr_cycle==1)
                        {
                                Zero();
                                DCM();
                                }
                        if(curr_cycle++==6)
                        curr_inst=0x80;
                        break;
                        //case 0xCB: Imm();  SAX(); break;
                        //case 0xCF: Abs();  DCM(); break;
                        //case 0xD3: Ind_Y(); DCM(); break;
                        //case 0xD7: Zero_X(); DCM(); break;
                        //case 0xDB: Abs_Y(); DCM(); break;
                        //case 0xDF: Abs_X(); DCM(); break;
                        //case 0xE3: IndX();  INS(); break;
                        //case 0xE7: Zero();  INS(); break;
                        //case 0xEF: Abs();  INS(); break;
                        //case 0xF3: Ind_Y(); INS(); break;
                        //case 0xF7: Zero_X(); INS(); break;
                        //case 0xFB: Abs_Y(); INS(); break;
                        case 0xFF:
                        if(curr_cycle==1)
                        {
                                Abs_X();
                                INS();
                                }
                        if(curr_cycle++==8)
                        curr_inst=0x80;
                        break;
                        case 0x0C: // SKW
                        case 0x1C:
                        case 0x3C:
                        case 0x5C:
                        case 0x7C:
                        case 0xDC:
                        case 0xFC: curr_loc+=3;
                        checktrap=1;
                        curr_inst=0x80;
                        break;
                        default:if(illopc)
                        Processor_hung(curr_loc,curr_inst,jmp_from);
                        curr_loc++;
                        checktrap=1;
                        curr_inst=0x80;
                        }
                // end switch
                // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                // KERNAL TRAPS
                if (checktrap==1) {
                        checktrap=0;
                        if (curr_loc>=0xe100&&curr_loc<0xe400) {
                                if (curr_loc==0xe1be) {
                                        setstatus("E1BE: OPEN");
                                        }
                                if (curr_loc==0xe1c7) {
                                        setstatus("E1C7: CLOSE");
                                        }
                                if (curr_loc==0xe156) {
                                        setstatus("E156: PERFORM SAVE");
                                        }
                                if (curr_loc==0xe165) {
                                        setstatus("E165: PERFORM LOAD/VERIFY");
                                        }
                                if (curr_loc==0xe37b) {
                                        setstatus("E1BE: BASIC warm start");
                                        }
                                if (curr_loc==0xe394) {
                                        setstatus("E1BE: BASIC cold start");
                                        }
                                }
                        else {
                                if (curr_loc>=0xf400) {
                                        /*on reset sound off*/  if (curr_loc==0xfce2) {
						SNDkeys&=~(1<<0);
						SNDkeys&=~(1<<1);
                                                SNDkeys&=~(1<<2);
                                                setstatus ("FCE2: SYSTEM RESET");
                                                }
                                        // IO
                                        /*tape redir to disk*/
                                        if (curr_loc==0xf533) {
                                                setstatus("F533: TAPE LOAD, REDIR TO DISK");
                                                RAMPointer[186]=8;
                                                curr_loc=0xf4b8;
                                                }
                                        if (curr_loc==0xF659) {
                                                setstatus("F659: TAPE SAVE, REDIR TO DISK");
                                                RAMPointer[186]=8;
                                                curr_loc=0xF5FA;
                                                }
                                        /*load program*/  if (curr_loc==0xf4b8) {
                                                if (RAMPointer[186]>=8&&RAMPointer[186]<=11) {
                                                        curr_loc=Basic2_ProgLoad();
                                                        if (curr_loc==0xf5d2) flags|=CARRY-CARRY;
                                                        }
                                                else {
                                                        setstatus("F4B8: SERIAL LOAD");
                                                        }
                                                }
                                        if (curr_loc==0xF5FA) {
                                                setstatus("F5FA: SERIAL SAVE");
						//curr_loc=0xb3ac; /*undef'd function*/
						}
                                        if (curr_loc==0xFFFA) {
                                                setstatus("FFFA: NMI");
                                                }
                                        if (curr_loc==0xFFFC) {
                                                setstatus("FFFC: RESET");
                                                }
                                        if (curr_loc==0xFFFE) {
                                                setstatus("FFFE: IRQ");
                                                }
                                        if (curr_loc>=0xff81) {
                                                if (curr_loc==0xff81) {
                                                        setstatus("FF81: Init Editor & Video Chips");
                                                        }
                                                if (curr_loc==0xff84) {
                                                        setstatus("FF84: Init I/O Devices, Ports & Timers");
                                                        }
                                                if (curr_loc==0xff87) {
                                                        setstatus("FF87: Init Ram & Buffers");
                                                        }
                                                if (curr_loc==0xff8a) {
                                                        setstatus("FF8A: Restore Vectors");
                                                        }
                                                if (curr_loc==0xff8d) {
                                                        setstatus("FF8D: Change Vectors For User");
                                                        }
                                                if (curr_loc==0xff93) {
                                                        setstatus("FF93: Send SA After Listen");
                                                        }
                                                if (curr_loc==0xff96) {
                                                        setstatus("FF96: Send SA After Talk");
                                                        }
                                                if (curr_loc==0xff99) {
                                                        setstatus("FF99: Set/Read System RAM Top");
                                                        }
                                                if (curr_loc==0xff9c) {
                                                        setstatus("FF9C: Set/Read System RAM Bottom");
                                                        }
                                                if (curr_loc==0xffa2) {
                                                        setstatus("FFA2: Set Timeout In IEEE");
                                                        }
                                                if (curr_loc==0xffa5) {
                                                        setstatus("FFA5: Handshake Serial Byte In");
                                                        }
                                                if (curr_loc==0xffa8) {
                                                        setstatus("FFA8: Handshake Serial Byte Out");
                                                        }
                                                if (curr_loc==0xffab) {
                                                        setstatus("FFAB: Command Serial Bus UNTALK");
                                                        }
                                                if (curr_loc==0xffae) {
                                                        setstatus("FFAE: Command Serial Bus UNLISTEN");
                                                        }
                                                if (curr_loc==0xffb1) {
                                                        setstatus("FFB1: Command Serial Bus LISTEN");
                                                        }
                                                if (curr_loc==0xffb4) {
                                                        setstatus("FFB4: Command Serial Bus TALK");
                                                        }
                                                if (curr_loc==0xffba) {
                                                        setstatus("FFBA: Set Logical File Parameters");
                                                        }
                                                if (curr_loc==0xffbd) {
                                                        setstatus("FFBD: Set Filename");
                                                        }
                                                if (curr_loc==0xffc0) {
                                                        setstatus("FFC0: Open Vector");
                                                        }
                                                if (curr_loc==0xffc3) {
                                                        setstatus("FFC3: Close Vector");
                                                        }
                                                if (curr_loc==0xffc6) {
                                                        setstatus("FFC6: Set Input");
                                                        }
                                                if (curr_loc==0xffc9) {
                                                        setstatus("FFC9: Set Output");
                                                        }
                                                if (curr_loc==0xffd5) {
                                                        setstatus("FFD5: Load RAM From Device");
                                                        }
                                                if (curr_loc==0xffd8) {
                                                        setstatus("FFD8: Save RAM To Device");
                                                        }
                                                if (curr_loc==0xffed) {
                                                        setstatus("FFED: Return Screen Organization");
                                                        }
                                                if (curr_loc==0xfff3) {
                                                        setstatus("FFF3: Return I/O Base Address");
                                                        }
                                                }
                                        }
                                }
                        }
                // END KERNAL TRAPS
                // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                
                
                // end 6510
                CIATimers();
                cycles++;
                }
        }

// ### OWN KEYBOARD INTERRUPT TO CAPTURE PC KEYBOARD ########################
void interrupt New_Key_Int(void)
{
        int x;
        // asm cli;
        scan = inp(0x60);
        if(scan > 0x7F) {
                if(key[scan ^ 0x80]) {
                        keysdown--;
                        key[scan ^ 0x80] = 0;
                        }
                }
        else  {
                if(!key[scan]) {
                        keysdown++;
                        key[scan] = 1;
                        }
                }
        rawkey=scan;
        if(rawkey&0x80)
        key_pressed[key_table[rawkey&0x7f][0]]|=key_table[rawkey&0x7f][1];
        else
        key_pressed[key_table[rawkey][0]]&=~key_table[rawkey][1];
        _asm {
                mov al, 0x20;
                out 0x20, al;
                }
        // asm sti;
        // fixes bug with kb
        }

// ### MAIN #################################################################
void main(int argc, char *argv[])
{
        unsigned char KEYTABLEDAT[257]={
                0,0,'','',2,2,4,4,8,8,16,16,' ','@',1,'','',2,2,4,4,8,8,16,16,' ',
                
                ' ','@',1,'',2,2,4,4,8,8,16,16,' ',' ','@','',2,' ',2,4,4,8,8,16,16,
                
                ' ',' ','@','@',0,'','',0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
                
                1,0,0,0,0,0,0,'@','@',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,8,1,8,1,8,1,8,1,8,8,' ',1,'','@',
                
                2,'@',2,'@',2,'@',2,'@',2,'@',2,2,4,4,' ',4,' ',4,' ',4,' ',4,' ',4,2,
                
                '',1,16,'',16,'',16,'',16,'',16,'',16,0,' ',16,0,16,0,' ',0,'@',
                
                0,8,0,0,0,0,0,0,0,0,0,0,0,4,0,0,'',0,0,0,0,0,0,8,'@',0,0,0,0,0,0,0,0,
                
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
        ;
        unsigned char string[256];
        unsigned char tempstring[50];
        long int temp;
        unsigned int index;
        struct dostime_t t;
        _dos_gettime(&t);
        printf ("Come Back 64 version %c.%c%c\n\n",VERMAJ,VERMIN,VERMINTWO);
	printf ("By J. Fiti (see www.fitie.com for contactinfo)\n");
	printf ("Email: johan@fitie.com\n");
	printf ("http://cb64.fitie.com and http://www.cb64.com\n");
        printf ("---\n\n");
        manskp=0;
	printf ("- Checking command line parameters...\n");
	printf ("     Supported switches:\n");
	printf ("     /C            View copyright and disclaimer\n");
	printf ("     -? -H /? /H   Help\n");
	printf ("     /J1 /J2       Select to joystick port 1 or 2\n");
	printf ("     /320          Start in 320x200 videomode\n");
	printf ("     /HS           Use the HardSID by default (0x300)\n");
	printf ("     /NOAUTO       Don't autoskip frames\n");
	printf ("     /NOID         No emulator ID at 0xDFA0\n");
	printf ("     /WHEREAMI     Show emulator ID info on start\n");
	printf ("     /L<prg>       Load the file (PRG/P00) called <prg> on startup\n");
	delay (200);
	// Especially for James Burrows/GameBase 64 ^_-! Thnx a lot m8!
	// visit www.geocities.com/~gamebase64 :)


	loadcounter=1;
	for (index=0;index<argc;index++) {
		strcpy (string,argv[index]);
		strupr (string);
		if (strcmp(string,"/C")==0) {
			clrscr();
			printf ("Copyrights and disclaimer:\n");
			printf ("\n");
			printf ("CB64 (tm) is copyright 1998,1999,2000 by Johan Fiti.\n");
			printf ("Come Back 64 (tm) is copyright 1998,1999,2000 by Johan Fiti.\n");
			printf ("\n");
			printf ("All Rights Reserved.\n");
			printf ("Come Back 64 may not be sold and may be spread only in its unmodified form and at no costs.\n");
			printf ("\n");
			printf ("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
			printf ("\n");
			printf ("Character ROM MOS901225-01, 1982 by Commodore Business Machines.\n");
			printf ("BASIC ROM MOS901226-01, 1982 by Commodore Business Machines, Microsoft Corp.\n");
			printf ("Kernal ROM MOS901227-03 (rev. 3), 1983 by Commodore Business Machines.\n");
			printf ("\n");
			printf ("All trademarks and other registered names contained in the Come Back 64 package are the property of their respective owners.\n");
			printf ("\n");
			printf ("Use of this software indicates that you agree to the above conditions.\n");
			printf ("\n\n<Page 1 of 2 | Press ENTER to continue> "); do {} while (getch()!=13);
			clrscr ();
			printf ("BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.\n");
			printf ("\n");
			printf ("IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n");
			printf ("\n");
			printf ("Basically, you use it at YOUR OWN RISK.\n");
			printf ("\n\n<Page 2 of 2 | Press ENTER to continue> "); do {} while (getch()!=13);
			clrscr ();
			exit(2);
			}
		if (strcmp(string,"/?")==0||strcmp(string,"-?")==0||strcmp(string,"/H")==0||strcmp(string,"-H")==0) {
			exit(5);
			}
		if (strcmp(string,"/J1")==0) {
			joytoemu=2;
			/*my stupid joystick notation:)*/}
		if (strcmp(string,"/J2")==0) {
			joytoemu=1;
			/*my stupid joystick notation:)*/}
		if (strcmp(string,"/HS")==0) {
			HARDSID=0x300;
			}
		if (strcmp(string,"/320")==0) {
			vidmode=0;
			}
		if (strcmp(string,"/NOAUTO")==0) {
			autoskip=0;
			interl_on=0;
			skiptype=0;
			printf ("  - Frameskipping disabled\n");
			}
		if (strcmp(string,"/NOID")==0) {
			emuid=0;
			printf ("  - Emulator ID disabled\n");
			}
		if (strcmp(string,"/WHEREAMI")==0) {
			whereami=1;
			typestring ("");
			execstring_do=1;
			printf ("  - Run emulator ID program\n");
			}
		if (string[0]=='/'&&string[1]=='L') {
			for (temp=2;temp<strlen(string);temp++)
			{
				 loadonstart[temp-2]=string[temp];
				}
			loadonstart[temp]=0;
			loadcounter=0;
			printf ("  - Loading '%s' on startup\n",loadonstart);
			}
		}
	if (vidmode==0) {
		printf ("  - Video mode used: 320x200\n");
		}
	if (vidmode==1) {
		printf ("  - Video mode used: 360x240\n");
		}
	if (joytoemu==1) {
		printf ("  - Joystick port selected: 2\n");
		}
	if (joytoemu==2) {
		printf ("  - Joystick port selected: 1\n");
		}
	if (HARDSID!=0) {
		printf ("  - Using HardSID at 0x300\n");
		}
	//delay (100);
	printf ("- Allocating memory...");
	AllocMem();
	printf ("Done\n");
	printf ("- Loading ROM's...");
	LoadROM();
	printf ("Done\n");
	// mainintro();

	printf ("- Capturing keyboard...");
	Old_Isr = _dos_getvect(0x09);
	_dos_setvect(0x09, New_Key_Int);
	printf ("Done\n");
	printf ("- Setting up C64 keyboard emulation...");
	for(index=0;index<128;index++) {
		key_table[index][0]=KEYTABLEDAT[index];
		}
	for(index=0;index<128;index++) {
		key_table[index][1]=KEYTABLEDAT[index+128];
		}
	for(index=0;index<255;index++) {
		key_pressed[index]=255;
		}
	printf ("Done\n");
	printf ("- Clearing emulator memory...");
	clearmem ();
	printf ("Done\n");
	#ifdef SOUND
	printf ("- Allocating memory for sound...");
	if(SNDInit(22050,40)) // <- sample frequency, updates/second
	Cleanup("Error allocating memory for sound");
	printf ("Done\n");
	#endif
	#ifdef SOUND
	printf ("- Checking Soundblaster...");
	sbgetset();
	SNDStart(0);
	if (SB_ver()==0) {printf ("Failed\n");}
	if (SB_ver()!=0) {printf ("Done\n");}
	printf ("- Setting sound volume...");
	sbvol (volume);
	printf ("Done\n");
	#endif
	//delay (75);
	printf ("\nSTARTING EMULATION AT %d:%02d:%02d\n...\n",t.hour,t.minute,t.second);
	// coolintro(); <-- and kicked out another intro ^_-! lol :)
	SetMode(0x13);
	modeset=1;
	setcolors ();
	MainLoop();
	#ifdef SOUND
	SNDClose(0);
	#endif
	// Message ("SHUTTING DOWN...",250);
	Cleanup("");
	}

// ### LOAD A CARTRIDGE #####################################################
void loadcrt (unsigned char fname[80])
{
	int hfile,nread,ret;
	unsigned int cont;
	unsigned int ret_read;
	unsigned char CRT_HEADER[64];
	unsigned char CRT_CHIP[16];
	char *CRT_BUFFER;
	hfile=open(fname,O_RDONLY | O_BINARY);
	if (hfile<=0)
	Cleanup ("Error opening cartridge file");
	if((CRT_BUFFER=(char *)malloc(8200))==NULL)
	{
		Cleanup ("Error loading cartridge file");
		}
	nread=read(hfile,(char *)CRT_HEADER,64);
	cart.hardtype=CRT_HEADER[21];
	// Now loading Normal Cartridge only, and Simons Basic
	if (cart.hardtype!=4 && cart.hardtype!=0)
	return;
	while (nread>0)
	{
		nread=read(hfile,(char *)CRT_CHIP,16);
		if (nread<=0) break;
		cart.address=(CRT_CHIP[0x0C]<<8)+CRT_CHIP[0x0D];
		cart.length=(CRT_CHIP[0x0E]<<8)+CRT_CHIP[0x0F];
		cart.bank=CRT_CHIP[0x0B];
		nread=read (hfile,(char *)CRT_BUFFER,cart.length);
		if (nread<=0) break;
		for (cont=0;cont<cart.length;cont++) {
			RAMPointer[cart.address+cont]=CRT_BUFFER[cont];
			}
		}
	close(hfile);
	free(CRT_BUFFER);
	reset=2;
	}
